/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.linkis.common.utils.ClassUtils$;
import org.apache.linkis.cs.common.entity.history.metadata.TableOperationType;
import org.apache.linkis.cs.common.entity.metadata.CSColumn;
import org.apache.linkis.engineplugin.spark.metadata.HPOBuilder$;
import org.apache.linkis.engineplugin.spark.metadata.SparkHiveObject;
import org.apache.spark.package$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.execution.command.AlterTableAddPartitionCommand;
import org.apache.spark.sql.execution.command.AlterTableDropPartitionCommand;
import org.apache.spark.sql.execution.command.AlterTableRenameCommand;
import org.apache.spark.sql.execution.command.AlterTableRenamePartitionCommand;
import org.apache.spark.sql.execution.command.AlterViewAsCommand;
import org.apache.spark.sql.execution.command.CreateDataSourceTableAsSelectCommand;
import org.apache.spark.sql.execution.command.CreateDataSourceTableCommand;
import org.apache.spark.sql.execution.command.CreateTableCommand;
import org.apache.spark.sql.execution.command.CreateTableLikeCommand;
import org.apache.spark.sql.execution.command.CreateViewCommand;
import org.apache.spark.sql.execution.command.DropTableCommand;
import org.apache.spark.sql.execution.command.ExplainCommand;
import org.apache.spark.sql.execution.command.LoadDataCommand;
import org.apache.spark.sql.execution.command.TruncateTableCommand;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.hive.execution.CreateHiveTableAsSelectCommand;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SparkSQLHistoryParser$ {
    public static SparkSQLHistoryParser$ MODULE$;

    static {
        new SparkSQLHistoryParser$();
    }

    public Tuple2<java.util.List<SparkHiveObject>, java.util.List<SparkHiveObject>> parse(LogicalPlan plan) {
        LogicalPlan logicalPlan = plan;
        if (logicalPlan instanceof ExplainCommand) {
            ExplainCommand explainCommand = (ExplainCommand)logicalPlan;
            return this.doParse(explainCommand.logicalPlan());
        }
        return this.doParse(logicalPlan);
    }

    public Tuple2<java.util.List<SparkHiveObject>, java.util.List<SparkHiveObject>> doParse(LogicalPlan plan) {
        ArrayList<SparkHiveObject> inputMetas = new ArrayList<SparkHiveObject>();
        ArrayList<SparkHiveObject> outputMetas = new ArrayList<SparkHiveObject>();
        LogicalPlan logicalPlan = plan;
        if (logicalPlan instanceof Command) {
            Command command = (Command)logicalPlan;
            this.parseRunnableCommand((LogicalPlan)command, inputMetas, outputMetas);
        } else {
            this.ParseQuery(plan, inputMetas, this.ParseQuery$default$3());
        }
        return new Tuple2(inputMetas, outputMetas);
    }

    public java.util.List<CSColumn> toCSColumns(StructType schema) {
        if (schema == null) {
            return null;
        }
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)schema.map((Function1 & Serializable & scala.Serializable)field -> MODULE$.toCSColumn((StructField)field), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SparkSQLHistoryParser$.$anonfun$toCSColumns$2(x$1)))).asJava();
    }

    public java.util.List<CSColumn> toCSColumns(Seq<StructField> fields) {
        if (fields == null) {
            return null;
        }
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)fields.map((Function1 & Serializable & scala.Serializable)field -> MODULE$.toCSColumn((StructField)field), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SparkSQLHistoryParser$.$anonfun$toCSColumns$4(x$2)))).asJava();
    }

    public CSColumn toCSColumn(StructField field) {
        if (field == null) {
            return null;
        }
        CSColumn csColumn = new CSColumn();
        csColumn.setName(field.name());
        csColumn.setComment((String)field.getComment().orNull(Predef$.MODULE$.$conforms()));
        csColumn.setType(field.dataType().typeName());
        return csColumn;
    }

    public java.util.List<CSColumn> toCSColumnsByNamed(Seq<NamedExpression> projectionList) {
        if (projectionList == null) {
            return null;
        }
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)projectionList.map((Function1 & Serializable & scala.Serializable)namedExpression -> {
            CSColumn csColumn;
            block0: {
                csColumn = new CSColumn();
                csColumn.setName(namedExpression.name());
                NamedExpression namedExpression2 = namedExpression;
                if (!(namedExpression2 instanceof AttributeReference)) break block0;
                AttributeReference attributeReference = (AttributeReference)namedExpression2;
                csColumn.setType(attributeReference.dataType().typeName());
            }
            return csColumn;
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SparkSQLHistoryParser$.$anonfun$toCSColumnsByNamed$2(x$3)))).asJava();
    }

    public java.util.List<CSColumn> toCSColumnsByColumnName(Seq<String> columnNames) {
        if (columnNames == null) {
            return null;
        }
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)columnNames.map((Function1 & Serializable & scala.Serializable)name -> {
            CSColumn csColumn = new CSColumn();
            csColumn.setName(name);
            return csColumn;
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SparkSQLHistoryParser$.$anonfun$toCSColumnsByColumnName$2(x$4)))).asJava();
    }

    private void ParseQuery(LogicalPlan plan, java.util.List<SparkHiveObject> sparkHiveObjects, Seq<NamedExpression> projectionList) {
        LogicalPlan logicalPlan;
        while ((logicalPlan = plan) instanceof Project) {
            Project project = (Project)logicalPlan;
            projectionList = project.projectList();
            plan = project.child();
        }
        String string = logicalPlan.nodeName();
        String string2 = "HiveTableRelation";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.mergeProjection$1((CatalogTable)ClassUtils$.MODULE$.getFieldVal((Object)logicalPlan, "tableMeta"), projectionList, sparkHiveObjects);
        } else {
            LogicalRelation logicalRelation;
            String string3 = logicalPlan.nodeName();
            String string4 = "MetastoreRelation";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                this.mergeProjection$1((CatalogTable)ClassUtils$.MODULE$.getFieldVal((Object)logicalPlan, "catalogTable"), projectionList, sparkHiveObjects);
            } else if (logicalPlan instanceof LogicalRelation && (logicalRelation = (LogicalRelation)logicalPlan).catalogTable().nonEmpty()) {
                this.mergeProjection$1((CatalogTable)logicalRelation.catalogTable().get(), projectionList, sparkHiveObjects);
            } else if (logicalPlan instanceof UnresolvedRelation) {
                UnresolvedRelation unresolvedRelation = (UnresolvedRelation)logicalPlan;
                this.addTableOrViewLevelObjs(TableIdentifier$.MODULE$.apply(unresolvedRelation.tableName()), sparkHiveObjects, this.addTableOrViewLevelObjs$default$3(), this.addTableOrViewLevelObjs$default$4(), this.addTableOrViewLevelObjs$default$5(), this.addTableOrViewLevelObjs$default$6());
            } else {
                logicalPlan.children().foreach((Function1 & Serializable & scala.Serializable)child -> {
                    SparkSQLHistoryParser$.MODULE$.ParseQuery(child, sparkHiveObjects, (Seq<NamedExpression>)projectionList);
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    private Seq<NamedExpression> ParseQuery$default$3() {
        return Nil$.MODULE$;
    }

    private void parseRunnableCommand(LogicalPlan plan, java.util.List<SparkHiveObject> inputObjects, java.util.List<SparkHiveObject> outputObjects) {
        AlterTableRenameCommand alterTableRenameCommand;
        LogicalPlan logicalPlan = plan;
        if (logicalPlan instanceof CreateDataSourceTableAsSelectCommand) {
            CreateDataSourceTableAsSelectCommand createDataSourceTableAsSelectCommand = (CreateDataSourceTableAsSelectCommand)logicalPlan;
            java.util.List<CSColumn> columnList = this.toCSColumns(createDataSourceTableAsSelectCommand.table().schema());
            TableIdentifier x$1 = createDataSourceTableAsSelectCommand.table().identifier();
            java.util.List<SparkHiveObject> x$2 = outputObjects;
            java.util.List<CSColumn> x$3 = columnList;
            TableOperationType x$4 = TableOperationType.CREATE;
            Seq<String> x$5 = this.addTableOrViewLevelObjs$default$3();
            Seq<String> x$6 = this.addTableOrViewLevelObjs$default$6();
            this.addTableOrViewLevelObjs(x$1, x$2, x$5, x$3, x$4, x$6);
            this.ParseQuery(createDataSourceTableAsSelectCommand.query(), inputObjects, this.ParseQuery$default$3());
            return;
        }
        if (logicalPlan instanceof CreateDataSourceTableCommand) {
            CreateDataSourceTableCommand createDataSourceTableCommand = (CreateDataSourceTableCommand)logicalPlan;
            TableIdentifier x$7 = createDataSourceTableCommand.table().identifier();
            java.util.List<SparkHiveObject> x$8 = outputObjects;
            java.util.List<CSColumn> x$9 = this.toCSColumns(createDataSourceTableCommand.table().schema());
            TableOperationType x$10 = TableOperationType.CREATE;
            Seq<String> x$11 = this.addTableOrViewLevelObjs$default$3();
            Seq<String> x$12 = this.addTableOrViewLevelObjs$default$6();
            this.addTableOrViewLevelObjs(x$7, x$8, x$11, x$9, x$10, x$12);
            return;
        }
        if (logicalPlan instanceof CreateHiveTableAsSelectCommand) {
            CreateHiveTableAsSelectCommand createHiveTableAsSelectCommand = (CreateHiveTableAsSelectCommand)logicalPlan;
            java.util.List<CSColumn> columnList = this.toCSColumns(createHiveTableAsSelectCommand.tableDesc().schema());
            TableIdentifier x$13 = createHiveTableAsSelectCommand.tableDesc().identifier();
            java.util.List<SparkHiveObject> x$14 = outputObjects;
            java.util.List<CSColumn> x$15 = columnList;
            TableOperationType x$16 = TableOperationType.CREATE;
            Seq<String> x$17 = this.addTableOrViewLevelObjs$default$3();
            Seq<String> x$18 = this.addTableOrViewLevelObjs$default$6();
            this.addTableOrViewLevelObjs(x$13, x$14, x$17, x$15, x$16, x$18);
            this.ParseQuery(createHiveTableAsSelectCommand.query(), inputObjects, this.ParseQuery$default$3());
            return;
        }
        if (logicalPlan instanceof CreateTableCommand) {
            CreateTableCommand createTableCommand = (CreateTableCommand)logicalPlan;
            TableIdentifier x$19 = createTableCommand.table().identifier();
            java.util.List<SparkHiveObject> x$20 = outputObjects;
            java.util.List<CSColumn> x$21 = this.toCSColumns(createTableCommand.table().schema());
            TableOperationType x$22 = TableOperationType.CREATE;
            Seq<String> x$23 = this.addTableOrViewLevelObjs$default$3();
            Seq<String> x$24 = this.addTableOrViewLevelObjs$default$6();
            this.addTableOrViewLevelObjs(x$19, x$20, x$23, x$21, x$22, x$24);
            return;
        }
        if (logicalPlan instanceof CreateTableLikeCommand) {
            CreateTableLikeCommand createTableLikeCommand = (CreateTableLikeCommand)logicalPlan;
            TableIdentifier x$25 = createTableLikeCommand.targetTable();
            java.util.List<SparkHiveObject> x$26 = outputObjects;
            TableOperationType x$27 = TableOperationType.CREATE;
            Seq<String> x$28 = this.addTableOrViewLevelObjs$default$3();
            java.util.List<CSColumn> x$29 = this.addTableOrViewLevelObjs$default$4();
            Seq<String> x$30 = this.addTableOrViewLevelObjs$default$6();
            this.addTableOrViewLevelObjs(x$25, x$26, x$28, x$29, x$27, x$30);
            this.addTableOrViewLevelObjs(createTableLikeCommand.sourceTable(), inputObjects, this.addTableOrViewLevelObjs$default$3(), this.addTableOrViewLevelObjs$default$4(), this.addTableOrViewLevelObjs$default$5(), this.addTableOrViewLevelObjs$default$6());
            return;
        }
        if (logicalPlan instanceof CreateViewCommand) {
            CreateViewCommand createViewCommand = (CreateViewCommand)logicalPlan;
            TableIdentifier x$31 = createViewCommand.name();
            java.util.List<SparkHiveObject> x$32 = outputObjects;
            java.util.List<CSColumn> x$33 = this.toCSColumnsByNamed((Seq<NamedExpression>)createViewCommand.output());
            TableOperationType x$34 = TableOperationType.CREATE;
            Seq<String> x$35 = this.addTableOrViewLevelObjs$default$3();
            Seq<String> x$36 = this.addTableOrViewLevelObjs$default$6();
            this.addTableOrViewLevelObjs(x$31, x$32, x$35, x$33, x$34, x$36);
            LogicalPlan logicalPlan2 = new StringOps(Predef$.MODULE$.augmentString(package$.MODULE$.SPARK_VERSION())).$less((Object)"3.2") ? (LogicalPlan)ClassUtils$.MODULE$.getFieldVal((Object)createViewCommand, "child") : (LogicalPlan)ClassUtils$.MODULE$.getFieldVal((Object)createViewCommand, "plan");
            this.ParseQuery(logicalPlan2, inputObjects, this.ParseQuery$default$3());
            return;
        }
        if (logicalPlan instanceof LoadDataCommand) {
            LoadDataCommand loadDataCommand = (LoadDataCommand)logicalPlan;
            this.addTableOrViewLevelObjs(loadDataCommand.table(), outputObjects, this.addTableOrViewLevelObjs$default$3(), this.addTableOrViewLevelObjs$default$4(), this.addTableOrViewLevelObjs$default$5(), this.addTableOrViewLevelObjs$default$6());
            return;
        }
        String string = logicalPlan.nodeName();
        String string2 = "InsertIntoHiveTable";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            CatalogTable table = (CatalogTable)ClassUtils$.MODULE$.getFieldVal((Object)logicalPlan, "table");
            TableIdentifier x$37 = table.identifier();
            java.util.List<SparkHiveObject> x$38 = outputObjects;
            java.util.List<CSColumn> x$39 = this.toCSColumns(table.schema());
            TableOperationType x$40 = TableOperationType.CREATE;
            Seq<String> x$41 = this.addTableOrViewLevelObjs$default$3();
            Seq<String> x$42 = this.addTableOrViewLevelObjs$default$6();
            this.addTableOrViewLevelObjs(x$37, x$38, x$41, x$39, x$40, x$42);
            this.ParseQuery((LogicalPlan)ClassUtils$.MODULE$.getFieldVal((Object)logicalPlan, "query"), inputObjects, this.ParseQuery$default$3());
            return;
        }
        if (logicalPlan instanceof DropTableCommand) {
            DropTableCommand dropTableCommand = (DropTableCommand)logicalPlan;
            TableIdentifier x$43 = dropTableCommand.tableName();
            java.util.List<SparkHiveObject> x$44 = outputObjects;
            TableOperationType x$45 = TableOperationType.DROP;
            Seq<String> x$46 = this.addTableOrViewLevelObjs$default$3();
            java.util.List<CSColumn> x$47 = this.addTableOrViewLevelObjs$default$4();
            Seq<String> x$48 = this.addTableOrViewLevelObjs$default$6();
            this.addTableOrViewLevelObjs(x$43, x$44, x$46, x$47, x$45, x$48);
            return;
        }
        if (logicalPlan instanceof TruncateTableCommand) {
            TruncateTableCommand truncateTableCommand = (TruncateTableCommand)logicalPlan;
            TableIdentifier x$49 = truncateTableCommand.tableName();
            java.util.List<SparkHiveObject> x$50 = outputObjects;
            TableOperationType x$51 = TableOperationType.DROP;
            Seq<String> x$52 = this.addTableOrViewLevelObjs$default$3();
            java.util.List<CSColumn> x$53 = this.addTableOrViewLevelObjs$default$4();
            Seq<String> x$54 = this.addTableOrViewLevelObjs$default$6();
            this.addTableOrViewLevelObjs(x$49, x$50, x$52, x$53, x$51, x$54);
            return;
        }
        if (logicalPlan instanceof AlterTableAddPartitionCommand) {
            AlterTableAddPartitionCommand alterTableAddPartitionCommand = (AlterTableAddPartitionCommand)logicalPlan;
            TableIdentifier x$55 = alterTableAddPartitionCommand.tableName();
            java.util.List<SparkHiveObject> x$56 = outputObjects;
            TableOperationType x$57 = TableOperationType.ALTER;
            Seq<String> x$58 = this.addTableOrViewLevelObjs$default$3();
            java.util.List<CSColumn> x$59 = this.addTableOrViewLevelObjs$default$4();
            Seq<String> x$60 = this.addTableOrViewLevelObjs$default$6();
            this.addTableOrViewLevelObjs(x$55, x$56, x$58, x$59, x$57, x$60);
            return;
        }
        if (logicalPlan instanceof AlterTableDropPartitionCommand) {
            AlterTableDropPartitionCommand alterTableDropPartitionCommand = (AlterTableDropPartitionCommand)logicalPlan;
            this.addTableOrViewLevelObjs(alterTableDropPartitionCommand.tableName(), outputObjects, this.addTableOrViewLevelObjs$default$3(), this.addTableOrViewLevelObjs$default$4(), this.addTableOrViewLevelObjs$default$5(), this.addTableOrViewLevelObjs$default$6());
            return;
        }
        if (logicalPlan instanceof AlterTableRenameCommand && (!(alterTableRenameCommand = (AlterTableRenameCommand)logicalPlan).isView() || alterTableRenameCommand.oldName().database().nonEmpty())) {
            this.addTableOrViewLevelObjs(alterTableRenameCommand.oldName(), inputObjects, this.addTableOrViewLevelObjs$default$3(), this.addTableOrViewLevelObjs$default$4(), this.addTableOrViewLevelObjs$default$5(), this.addTableOrViewLevelObjs$default$6());
            this.addTableOrViewLevelObjs(alterTableRenameCommand.newName(), outputObjects, this.addTableOrViewLevelObjs$default$3(), this.addTableOrViewLevelObjs$default$4(), this.addTableOrViewLevelObjs$default$5(), this.addTableOrViewLevelObjs$default$6());
            return;
        }
        if (logicalPlan instanceof AlterTableRenamePartitionCommand) {
            AlterTableRenamePartitionCommand alterTableRenamePartitionCommand = (AlterTableRenamePartitionCommand)logicalPlan;
            this.addTableOrViewLevelObjs(alterTableRenamePartitionCommand.tableName(), inputObjects, this.addTableOrViewLevelObjs$default$3(), this.addTableOrViewLevelObjs$default$4(), this.addTableOrViewLevelObjs$default$5(), this.addTableOrViewLevelObjs$default$6());
            this.addTableOrViewLevelObjs(alterTableRenamePartitionCommand.tableName(), outputObjects, this.addTableOrViewLevelObjs$default$3(), this.addTableOrViewLevelObjs$default$4(), this.addTableOrViewLevelObjs$default$5(), this.addTableOrViewLevelObjs$default$6());
            return;
        }
        if (logicalPlan instanceof AlterViewAsCommand) {
            AlterViewAsCommand alterViewAsCommand = (AlterViewAsCommand)logicalPlan;
            if (alterViewAsCommand.name().database().nonEmpty()) {
                TableIdentifier x$61 = alterViewAsCommand.name();
                java.util.List<SparkHiveObject> x$62 = outputObjects;
                TableOperationType x$63 = TableOperationType.ALTER;
                Seq<String> x$64 = this.addTableOrViewLevelObjs$default$3();
                java.util.List<CSColumn> x$65 = this.addTableOrViewLevelObjs$default$4();
                Seq<String> x$66 = this.addTableOrViewLevelObjs$default$6();
                this.addTableOrViewLevelObjs(x$61, x$62, x$64, x$65, x$63, x$66);
            }
            this.ParseQuery(alterViewAsCommand.query(), inputObjects, this.ParseQuery$default$3());
            return;
        }
        String string3 = logicalPlan.nodeName();
        String string4 = "AlterTableAddColumnsCommand";
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            TableIdentifier x$67 = (TableIdentifier)ClassUtils$.MODULE$.getFieldVal((Object)logicalPlan, "table");
            java.util.List<SparkHiveObject> x$68 = inputObjects;
            java.util.List<CSColumn> x$69 = this.toCSColumns((Seq<StructField>)((Seq)ClassUtils$.MODULE$.getFieldVal((Object)logicalPlan, "colsToAdd")));
            Seq<String> x$70 = this.addTableOrViewLevelObjs$default$3();
            TableOperationType x$71 = this.addTableOrViewLevelObjs$default$5();
            Seq<String> x$72 = this.addTableOrViewLevelObjs$default$6();
            this.addTableOrViewLevelObjs(x$67, x$68, x$70, x$69, x$71, x$72);
            TableIdentifier x$73 = (TableIdentifier)ClassUtils$.MODULE$.getFieldVal((Object)logicalPlan, "table");
            java.util.List<SparkHiveObject> x$74 = outputObjects;
            java.util.List<CSColumn> x$75 = this.toCSColumns((Seq<StructField>)((Seq)ClassUtils$.MODULE$.getFieldVal((Object)logicalPlan, "colsToAdd")));
            TableOperationType x$76 = TableOperationType.ALTER;
            Seq<String> x$77 = this.addTableOrViewLevelObjs$default$3();
            Seq<String> x$78 = this.addTableOrViewLevelObjs$default$6();
            this.addTableOrViewLevelObjs(x$73, x$74, x$77, x$75, x$76, x$78);
            return;
        }
        String string5 = logicalPlan.nodeName();
        String string6 = "AlterTableChangeColumnCommand";
        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
            TableIdentifier x$79 = (TableIdentifier)ClassUtils$.MODULE$.getFieldVal((Object)logicalPlan, "tableName");
            java.util.List<SparkHiveObject> x$80 = inputObjects;
            java.util.List<CSColumn> x$81 = this.toCSColumns((Seq<StructField>)((Seq)new .colon.colon((Object)((StructField)ClassUtils$.MODULE$.getFieldVal((Object)logicalPlan, "newColumn")), (List)Nil$.MODULE$)));
            TableOperationType x$82 = TableOperationType.ALTER;
            Seq<String> x$83 = this.addTableOrViewLevelObjs$default$3();
            Seq<String> x$84 = this.addTableOrViewLevelObjs$default$6();
            this.addTableOrViewLevelObjs(x$79, x$80, x$83, x$81, x$82, x$84);
            return;
        }
    }

    private void addDbLevelObjs(String dbName, java.util.List<SparkHiveObject> sparkHiveObjects, TableOperationType actionType) {
        sparkHiveObjects.add(HPOBuilder$.MODULE$.apply(HivePrivilegeObject.HivePrivilegeObjectType.DATABASE, dbName, dbName, actionType));
    }

    private TableOperationType addDbLevelObjs$default$3() {
        return TableOperationType.ACCESS;
    }

    private void addTableOrViewLevelObjs(TableIdentifier tableIdentifier, java.util.List<SparkHiveObject> sparkHiveObjects, Seq<String> partKeys, java.util.List<CSColumn> columns, TableOperationType actionType, Seq<String> cmdParams) {
        Option option = tableIdentifier.database();
        if (option instanceof Some) {
            Some some = (Some)option;
            String db = (String)some.value();
            String tbName = tableIdentifier.table();
            sparkHiveObjects.add(HPOBuilder$.MODULE$.apply(HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW, db, tbName, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(partKeys).asJava(), columns, actionType, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(cmdParams).asJava()));
            return;
        }
    }

    private Seq<String> addTableOrViewLevelObjs$default$3() {
        return Nil$.MODULE$;
    }

    private java.util.List<CSColumn> addTableOrViewLevelObjs$default$4() {
        return null;
    }

    private TableOperationType addTableOrViewLevelObjs$default$5() {
        return TableOperationType.ACCESS;
    }

    private Seq<String> addTableOrViewLevelObjs$default$6() {
        return Nil$.MODULE$;
    }

    private void addFunctionLevelObjs(Option<String> databaseName, String functionName, java.util.List<SparkHiveObject> sparkHiveObjects, TableOperationType actionType) {
        Option<String> option = databaseName;
        if (option instanceof Some) {
            Some some = (Some)option;
            String db = (String)some.value();
            sparkHiveObjects.add(HPOBuilder$.MODULE$.apply(HivePrivilegeObject.HivePrivilegeObjectType.FUNCTION, db, functionName, actionType));
            return;
        }
    }

    private TableOperationType addFunctionLevelObjs$default$4() {
        return TableOperationType.ACCESS;
    }

    public static final /* synthetic */ boolean $anonfun$toCSColumns$2(CSColumn x$1) {
        return x$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$toCSColumns$4(CSColumn x$2) {
        return x$2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$toCSColumnsByNamed$2(CSColumn x$3) {
        return x$3 != null;
    }

    public static final /* synthetic */ boolean $anonfun$toCSColumnsByColumnName$2(CSColumn x$4) {
        return x$4 != null;
    }

    public static final /* synthetic */ boolean $anonfun$ParseQuery$1(Seq projectionList$1, String x$6) {
        return ((SeqLike)projectionList$1.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.name(), Seq$.MODULE$.canBuildFrom())).contains((Object)x$6);
    }

    private final void mergeProjection$1(CatalogTable table, Seq projectionList$1, java.util.List sparkHiveObjects$1) {
        if (projectionList$1.isEmpty()) {
            this.addTableOrViewLevelObjs(table.identifier(), sparkHiveObjects$1, (Seq<String>)table.partitionColumnNames(), this.toCSColumns(table.schema()), this.addTableOrViewLevelObjs$default$5(), this.addTableOrViewLevelObjs$default$6());
            return;
        }
        this.addTableOrViewLevelObjs(table.identifier(), sparkHiveObjects$1, (Seq<String>)((Seq)table.partitionColumnNames().filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SparkSQLHistoryParser$.$anonfun$ParseQuery$1(projectionList$1, x$6)))), this.toCSColumnsByNamed((Seq<NamedExpression>)projectionList$1), this.addTableOrViewLevelObjs$default$5(), this.addTableOrViewLevelObjs$default$6());
    }

    private SparkSQLHistoryParser$() {
        MODULE$ = this;
    }
}

