/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.jobhistory.dao;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Param;
import org.apache.linkis.jobhistory.entity.JobHistory;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;

public interface JobHistoryMapper {
    public List<JobHistory> selectJobHistory(JobHistory var1);

    @Retryable(value={CannotGetJdbcConnectionException.class}, maxAttempts=5, backoff=@Backoff(delay=10000L))
    public void insertJobHistory(JobHistory var1);

    @Retryable(value={CannotGetJdbcConnectionException.class}, maxAttempts=5, backoff=@Backoff(delay=10000L))
    public void updateJobHistory(JobHistory var1);

    public List<JobHistory> searchWithIdOrderAsc(@Param(value="startDate") Date var1, @Param(value="endDate") Date var2, @Param(value="startId") Long var3, @Param(value="status") List<String> var4);

    public List<JobHistory> search(@Param(value="id") Long var1, @Param(value="umUser") String var2, @Param(value="status") List<String> var3, @Param(value="startDate") Date var4, @Param(value="endDate") Date var5, @Param(value="engineType") String var6, @Param(value="startId") Long var7, @Param(value="instances") String var8, @Param(value="departmentId") String var9, @Param(value="engineInstance") String var10);

    public List<JobHistory> searchWithUserCreator(@Param(value="id") Long var1, @Param(value="umUser") String var2, @Param(value="userCreatorKey") String var3, @Param(value="userCreatorValue") String var4, @Param(value="status") List<String> var5, @Param(value="startDate") Date var6, @Param(value="endDate") Date var7, @Param(value="engineType") String var8, @Param(value="startId") Long var9, @Param(value="instances") String var10, @Param(value="departmentId") String var11, @Param(value="engineInstance") String var12);

    public List<JobHistory> searchWithCreatorOnly(@Param(value="id") Long var1, @Param(value="umUser") String var2, @Param(value="userCreatorKey") String var3, @Param(value="creator") String var4, @Param(value="status") List<String> var5, @Param(value="startDate") Date var6, @Param(value="endDate") Date var7, @Param(value="engineType") String var8, @Param(value="startId") Long var9, @Param(value="instances") String var10, @Param(value="departmentId") String var11, @Param(value="engineInstance") String var12);

    public Integer countUndoneTaskNoCreator(@Param(value="umUser") String var1, @Param(value="status") List<String> var2, @Param(value="startDate") Date var3, @Param(value="endDate") Date var4, @Param(value="engineType") String var5, @Param(value="startId") Long var6);

    public Integer countUndoneTaskWithUserCreator(@Param(value="umUser") String var1, @Param(value="userCreatorKey") String var2, @Param(value="userCreatorValue") String var3, @Param(value="status") List<String> var4, @Param(value="startDate") Date var5, @Param(value="endDate") Date var6, @Param(value="engineType") String var7, @Param(value="startId") Long var8);

    public Integer countUndoneTaskWithCreatorOnly(@Param(value="umUser") String var1, @Param(value="userCreatorKey") String var2, @Param(value="creator") String var3, @Param(value="status") List<String> var4, @Param(value="startDate") Date var5, @Param(value="endDate") Date var6, @Param(value="engineType") String var7, @Param(value="startId") Long var8);

    public String selectJobHistoryStatusForUpdate(Long var1);

    public void updateOberverById(@Param(value="taskid") Long var1, @Param(value="observeInfo") String var2);

    public void updateJobHistoryCancelById(@Param(value="idList") List<Long> var1, @Param(value="errorDesc") String var2);

    public List<JobHistory> selectJobHistoryByTaskidList(@Param(value="idList") List<String> var1, @Param(value="umUser") String var2);

    public List<JobHistory> selectJobHistoryNoCode(JobHistory var1);

    public List<JobHistory> selectFailoverJobHistory(@Param(value="instancesMap") Map<String, Long> var1, @Param(value="statusList") List<String> var2, @Param(value="startTimestamp") Long var3, @Param(value="limit") Integer var4);

    public List<JobHistory> taskDurationTopN(@Param(value="startDate") Date var1, @Param(value="endDate") Date var2, @Param(value="umUser") String var3, @Param(value="engineType") String var4);

    public List<JobHistory> taskDurationTopNWithUserCreator(@Param(value="umUser") String var1, @Param(value="userCreatorKey") String var2, @Param(value="userCreatorValue") String var3, @Param(value="startDate") Date var4, @Param(value="endDate") Date var5, @Param(value="engineType") String var6);

    public List<JobHistory> taskDurationTopNWithCreatorOnly(@Param(value="umUser") String var1, @Param(value="userCreatorKey") String var2, @Param(value="creator") String var3, @Param(value="startDate") Date var4, @Param(value="endDate") Date var5, @Param(value="engineType") String var6);
}

