/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.hive.executor;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.common.HiveInterruptUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecDriver;
import org.apache.hadoop.hive.ql.exec.mr.HadoopJobExecHelper;
import org.apache.hadoop.hive.ql.exec.tez.TezJobExecHelper;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSetWriter;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.computation.executor.execute.ComputationExecutor;
import org.apache.linkis.engineconn.computation.executor.execute.ComputationExecutor$;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.engineconn.computation.executor.utlis.ProgressUtils$;
import org.apache.linkis.engineconn.core.EngineConnObject$;
import org.apache.linkis.engineconn.executor.entity.ResourceFetchExecutor;
import org.apache.linkis.engineplugin.hive.conf.Counters$;
import org.apache.linkis.engineplugin.hive.conf.HiveEngineConfiguration$;
import org.apache.linkis.engineplugin.hive.cs.CSHiveHelper$;
import org.apache.linkis.engineplugin.hive.errorcode.HiveErrorCodeSummary;
import org.apache.linkis.engineplugin.hive.exception.HiveQueryFailedException;
import org.apache.linkis.engineplugin.hive.executor.HiveDriverProxy;
import org.apache.linkis.engineplugin.hive.executor.HiveDriverProxy$;
import org.apache.linkis.engineplugin.hive.executor.HiveEngineConnExecutor$;
import org.apache.linkis.engineplugin.hive.progress.HiveProgressHelper$;
import org.apache.linkis.governance.common.constant.job.JobRequestConstants$;
import org.apache.linkis.governance.common.paser.CodeParser;
import org.apache.linkis.governance.common.paser.SQLCodeParser;
import org.apache.linkis.governance.common.utils.JobUtils$;
import org.apache.linkis.hadoop.common.conf.HadoopConf$;
import org.apache.linkis.manager.common.entity.resource.CommonNodeResource;
import org.apache.linkis.manager.common.entity.resource.NodeResource;
import org.apache.linkis.manager.common.entity.resource.Resource;
import org.apache.linkis.manager.common.protocol.resource.ResourceWithStatus;
import org.apache.linkis.manager.engineplugin.common.util.NodeResourceUtils$;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.protocol.engine.JobProgressInfo;
import org.apache.linkis.scheduler.executer.ErrorExecuteResponse;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.scheduler.executer.SuccessExecuteResponse;
import org.apache.linkis.storage.domain.Column;
import org.apache.linkis.storage.domain.DataType$;
import org.apache.linkis.storage.resultset.ResultSetFactory$;
import org.apache.linkis.storage.resultset.table.TableMetaData;
import org.apache.linkis.storage.resultset.table.TableRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.HashSet;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\rMf\u0001B&M\u0001eC\u0001\u0002\u001c\u0001\u0003\u0002\u0003\u0006I!\u001c\u0005\tg\u0002\u0011\t\u0011)A\u0005i\"Iq\u0010\u0001B\u0001B\u0003%\u0011\u0011\u0001\u0005\u000b\u0003\u001b\u0001!\u0011!Q\u0001\n\u0005=\u0001BCA\u000e\u0001\t\u0005\t\u0015!\u0003\u0002\u001e!9\u0011Q\u0006\u0001\u0005\u0002\u0005=\u0002\"CA \u0001\t\u0007I\u0011BA!\u0011!\ty\u0005\u0001Q\u0001\n\u0005\r\u0003\"CA)\u0001\t\u0007I\u0011BA*\u0011!\tY\u0007\u0001Q\u0001\n\u0005U\u0003bCA7\u0001\u0001\u0007\t\u0019!C\u0005\u0003_B1\"! \u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0000!Y\u00111\u0012\u0001A\u0002\u0003\u0005\u000b\u0015BA9\u0011%\ti\t\u0001a\u0001\n\u0013\ty\tC\u0005\u0002\u0012\u0002\u0001\r\u0011\"\u0003\u0002\u0014\"9\u0011q\u0013\u0001!B\u0013i\u0007\"CAM\u0001\u0001\u0007I\u0011BAH\u0011%\tY\n\u0001a\u0001\n\u0013\ti\nC\u0004\u0002\"\u0002\u0001\u000b\u0015B7\t\u0013\u0005\r\u0006A1A\u0005\n\u0005\u0015\u0006\u0002CAW\u0001\u0001\u0006I!a*\t\u0013\u0005=\u0006\u00011A\u0005\n\u0005\u0015\u0006\"CAY\u0001\u0001\u0007I\u0011BAZ\u0011!\t9\f\u0001Q!\n\u0005\u001d\u0006bCA]\u0001\u0001\u0007\t\u0019!C\u0005\u0003wC1\"a1\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002F\"Y\u0011\u0011\u001a\u0001A\u0002\u0003\u0005\u000b\u0015BA_\u0011%\tY\r\u0001b\u0001\n\u0013\ti\r\u0003\u0005\u0002d\u0002\u0001\u000b\u0011BAh\u0011%\t)\u000f\u0001a\u0001\n\u0013\ty\tC\u0005\u0002h\u0002\u0001\r\u0011\"\u0003\u0002j\"9\u0011Q\u001e\u0001!B\u0013i\u0007\"CAx\u0001\u0001\u0007I\u0011BAS\u0011%\t\t\u0010\u0001a\u0001\n\u0013\t\u0019\u0010\u0003\u0005\u0002x\u0002\u0001\u000b\u0015BAT\u0011%\tI\u0010\u0001b\u0001\n\u0013\tY\u0010\u0003\u0005\u0003\u0006\u0001\u0001\u000b\u0011BA\u007f\u0011%\u00119\u0001\u0001b\u0001\n\u0013\u0011I\u0001\u0003\u0005\u0003.\u0001\u0001\u000b\u0011\u0002B\u0006\u0011-\u0011i\u0004\u0001a\u0001\u0002\u0004%IAa\u0010\t\u0017\t\u001d\u0003\u00011AA\u0002\u0013%!\u0011\n\u0005\f\u0005\u001b\u0002\u0001\u0019!A!B\u0013\u0011\t\u0005C\u0006\u0003P\u0001\u0001\r\u00111A\u0005\n\tE\u0003b\u0003B0\u0001\u0001\u0007\t\u0019!C\u0005\u0005CB1B!\u001a\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003T!I!q\r\u0001C\u0002\u0013%!\u0011\u000e\u0005\t\u0005_\u0002\u0001\u0015!\u0003\u0003l!I!\u0011\u000f\u0001C\u0002\u0013%!\u0011\u000e\u0005\t\u0005g\u0002\u0001\u0015!\u0003\u0003l!9!Q\u000f\u0001\u0005B\t]\u0004b\u0002B=\u0001\u0011\u0005#1\u0010\u0005\b\u0005'\u0003A\u0011\u0002BK\u0011\u001d\u0011i\n\u0001C\u0005\u0005?CqA!0\u0001\t\u0013\u0011y\fC\u0004\u0003b\u0002!IAa9\t\u000f\t%\b\u0001\"\u0003\u0003x!9!1\u001e\u0001\u0005\n\t]\u0004b\u0002Bw\u0001\u0011%!q\u001e\u0005\b\u0005k\u0004A\u0011\tB|\u0011\u001d\u0019\t\u0001\u0001C!\u0005oBqaa\u0001\u0001\t\u0003\u001a)\u0001C\u0004\u0004\"\u0001!\tea\t\t\u000f\r%\u0002\u0001\"\u0011\u0004,!911\t\u0001\u0005B\r\u0015\u0003bBB%\u0001\u0011\u000531\n\u0005\b\u0007\u001b\u0002A\u0011IB(\u0011\u001d\u0019i\u0006\u0001C!\u0007?Bqa!\u001d\u0001\t\u0003\u001a\u0019\bC\u0004\u0004\u0006\u0002!\tea\"\t\u000f\r%\u0005\u0001\"\u0011\u0004\f\u001eI1Q\u0012'\u0002\u0002#\u00051q\u0012\u0004\t\u00172\u000b\t\u0011#\u0001\u0004\u0012\"9\u0011Q\u0006%\u0005\u0002\re\u0005\"CBN\u0011F\u0005I\u0011ABO\u0005YA\u0015N^3F]\u001eLg.Z\"p]:,\u00050Z2vi>\u0014(BA'O\u0003!)\u00070Z2vi>\u0014(BA(Q\u0003\u0011A\u0017N^3\u000b\u0005E\u0013\u0016\u0001D3oO&tW\r\u001d7vO&t'BA*U\u0003\u0019a\u0017N\\6jg*\u0011QKV\u0001\u0007CB\f7\r[3\u000b\u0003]\u000b1a\u001c:h\u0007\u0001\u00192\u0001\u0001.f!\tY6-D\u0001]\u0015\tif,A\u0004fq\u0016\u001cW\u000f^3\u000b\u00055{&B\u00011b\u0003-\u0019w.\u001c9vi\u0006$\u0018n\u001c8\u000b\u0005\t\u0014\u0016AC3oO&tWmY8o]&\u0011A\r\u0018\u0002\u0014\u0007>l\u0007/\u001e;bi&|g.\u0012=fGV$xN\u001d\t\u0003M*l\u0011a\u001a\u0006\u0003Q&\fa!\u001a8uSRL(BA'b\u0013\tYwMA\u000bSKN|WO]2f\r\u0016$8\r[#yK\u000e,Ho\u001c:\u0002\u0005%$\u0007C\u00018r\u001b\u0005y'\"\u00019\u0002\u000bM\u001c\u0017\r\\1\n\u0005I|'aA%oi\u0006a1/Z:tS>t7\u000b^1uKB\u0011Q/`\u0007\u0002m*\u0011q\u000f_\u0001\bg\u0016\u001c8/[8o\u0015\tI(0\u0001\u0002rY*\u0011qj\u001f\u0006\u0003yR\u000ba\u0001[1e_>\u0004\u0018B\u0001@w\u00051\u0019Vm]:j_:\u001cF/\u0019;f\u0003\r)x-\u001b\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011qA>\u0002\u0011M,7-\u001e:jifLA!a\u0003\u0002\u0006\t!Rk]3s\u000fJ|W\u000f]%oM>\u0014X.\u0019;j_:\f\u0001\u0002[5wK\u000e{gN\u001a\t\u0005\u0003#\t9\"\u0004\u0002\u0002\u0014)\u0019\u0011Q\u0003>\u0002\t\r|gNZ\u0005\u0005\u00033\t\u0019B\u0001\u0005ISZ,7i\u001c8g\u0003\u0011\u0011\u0017m\\:\u0011\t\u0005}\u0011\u0011F\u0007\u0003\u0003CQA!a\t\u0002&\u0005\u0011\u0011n\u001c\u0006\u0003\u0003O\tAA[1wC&!\u00111FA\u0011\u0005U\u0011\u0015\u0010^3BeJ\f\u0017pT;uaV$8\u000b\u001e:fC6\fa\u0001P5oSRtD\u0003DA\u0019\u0003k\t9$!\u000f\u0002<\u0005u\u0002cAA\u001a\u00015\tA\nC\u0003m\r\u0001\u0007Q\u000eC\u0003t\r\u0001\u0007A\u000f\u0003\u0004\u0000\r\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003\u001b1\u0001\u0019AA\b\u0011%\tYB\u0002I\u0001\u0002\u0004\ti\"A\u0002M\u001f\u001e+\"!a\u0011\u0011\t\u0005\u0015\u00131J\u0007\u0003\u0003\u000fR1!!\u0013W\u0003\u0015\u0019HN\u001a\u001bk\u0013\u0011\ti%a\u0012\u0003\r1{wmZ3s\u0003\u0011auj\u0012\u0011\u0002\u00159\fW.\u001a)sK\u001aL\u00070\u0006\u0002\u0002VA!\u0011qKA3\u001d\u0011\tI&!\u0019\u0011\u0007\u0005ms.\u0004\u0002\u0002^)\u0019\u0011q\f-\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019g\\\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d\u0014\u0011\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\rt.A\u0006oC6,\u0007K]3gSb\u0004\u0013\u0001\u00029s_\u000e,\"!!\u001d\u0011\t\u0005M\u0014\u0011P\u0007\u0003\u0003kR1!a\u001ey\u0003)\u0001(o\\2fgN|'o]\u0005\u0005\u0003w\n)H\u0001\tD_6l\u0017M\u001c3Qe>\u001cWm]:pe\u0006A\u0001O]8d?\u0012*\u0017\u000f\u0006\u0003\u0002\u0002\u0006\u001d\u0005c\u00018\u0002\u0004&\u0019\u0011QQ8\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u0013c\u0011\u0011!a\u0001\u0003c\n1\u0001\u001f\u00132\u0003\u0015\u0001(o\\2!\u0003\ri\u0017\r]\u000b\u0002[\u00069Q.\u00199`I\u0015\fH\u0003BAA\u0003+C\u0001\"!#\u0010\u0003\u0003\u0005\r!\\\u0001\u0005[\u0006\u0004\b%\u0001\u0004sK\u0012,8-Z\u0001\u000be\u0016$WoY3`I\u0015\fH\u0003BAA\u0003?C\u0001\"!#\u0013\u0003\u0003\u0005\r!\\\u0001\be\u0016$WoY3!\u0003%!x\u000e^1m)\u0006\u001c8.\u0006\u0002\u0002(B\u0019a.!+\n\u0007\u0005-vNA\u0003GY>\fG/\u0001\u0006u_R\fG\u000eV1tW\u0002\n!c]5oO2,G*\u001b8f!J|wM]3tg\u000612/\u001b8hY\u0016d\u0015N\\3Qe><'/Z:t?\u0012*\u0017\u000f\u0006\u0003\u0002\u0002\u0006U\u0006\"CAE/\u0005\u0005\t\u0019AAT\u0003M\u0019\u0018N\\4mK2Kg.\u001a)s_\u001e\u0014Xm]:!\u0003U)gnZ5oK\u0016CXmY;u_J\u001cuN\u001c;fqR,\"!!0\u0011\u0007m\u000by,C\u0002\u0002Br\u0013a#\u00128hS:,W\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u001aK:<\u0017N\\3Fq\u0016\u001cW\u000f^8s\u0007>tG/\u001a=u?\u0012*\u0017\u000f\u0006\u0003\u0002\u0002\u0006\u001d\u0007\"CAE5\u0005\u0005\t\u0019AA_\u0003Y)gnZ5oK\u0016CXmY;u_J\u001cuN\u001c;fqR\u0004\u0013aE:j]\u001edWmQ8eK\u000e{W\u000e\u001d7fi\u0016$WCAAh!\u0011\t\t.a8\u000e\u0005\u0005M'\u0002BAk\u0003/\fa!\u0019;p[&\u001c'\u0002BAm\u00037\f!bY8oGV\u0014(/\u001a8u\u0015\u0011\ti.!\n\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003C\f\u0019NA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\u0015g&tw\r\\3D_\u0012,7i\\7qY\u0016$X\r\u001a\u0011\u0002\u001d9,XNY3s\u001f\u001al%KS8cg\u0006\u0011b.^7cKJ|e-\u0014*K_\n\u001cx\fJ3r)\u0011\t\t)a;\t\u0011\u0005%u$!AA\u00025\fqB\\;nE\u0016\u0014xJZ'S\u0015>\u00147\u000fI\u0001\u0013GV\u0014(/\u001a8u'Fd\u0007K]8he\u0016\u001c8/\u0001\fdkJ\u0014XM\u001c;Tc2\u0004&o\\4sKN\u001cx\fJ3r)\u0011\t\t)!>\t\u0013\u0005%%%!AA\u0002\u0005\u001d\u0016aE2veJ,g\u000e^*rYB\u0013xn\u001a:fgN\u0004\u0013\u0001F:j]\u001edWmU9m!J|wM]3tg6\u000b\u0007/\u0006\u0002\u0002~BA\u0011q B\u0001\u0003+\n9+\u0004\u0002\u0002\\&!!1AAn\u0005\ri\u0015\r]\u0001\u0016g&tw\r\\3Tc2\u0004&o\\4sKN\u001cX*\u00199!\u00039)\u00070Z2vi>\u0014H*\u00192fYN,\"Aa\u0003\u0011\r\u0005}(Q\u0002B\t\u0013\u0011\u0011y!a7\u0003\t1K7\u000f\u001e\u0019\u0005\u0005'\u0011I\u0003\u0005\u0004\u0003\u0016\t\u0005\"QE\u0007\u0003\u0005/Q1\u0001\u001bB\r\u0015\u0011\u0011YB!\b\u0002\u000b1\f'-\u001a7\u000b\u0007\t}!+A\u0004nC:\fw-\u001a:\n\t\t\r\"q\u0003\u0002\u0006\u0019\u0006\u0014W\r\u001c\t\u0005\u0005O\u0011I\u0003\u0004\u0001\u0005\u0017\t-r%!A\u0001\u0002\u000b\u0005!q\u0006\u0002\u0004?\u0012\n\u0014aD3yK\u000e,Ho\u001c:MC\n,Gn\u001d\u0011\u0012\t\tE\"q\u0007\t\u0004]\nM\u0012b\u0001B\u001b_\n9aj\u001c;iS:<\u0007c\u00018\u0003:%\u0019!1H8\u0003\u0007\u0005s\u00170\u0001\u0004ee&4XM]\u000b\u0003\u0005\u0003\u0002B!a\r\u0003D%\u0019!Q\t'\u0003\u001f!Kg/\u001a#sSZ,'\u000f\u0015:pqf\f!\u0002\u001a:jm\u0016\u0014x\fJ3r)\u0011\t\tIa\u0013\t\u0013\u0005%\u0015&!AA\u0002\t\u0005\u0013a\u00023sSZ,'\u000fI\u0001\u0007i\"\u0014X-\u00193\u0016\u0005\tM\u0003\u0003\u0002B+\u00057j!Aa\u0016\u000b\t\te\u0013QE\u0001\u0005Y\u0006tw-\u0003\u0003\u0003^\t]#A\u0002+ie\u0016\fG-\u0001\u0006uQJ,\u0017\rZ0%KF$B!!!\u0003d!I\u0011\u0011\u0012\u0017\u0002\u0002\u0003\u0007!1K\u0001\bi\"\u0014X-\u00193!\u0003U\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8TiJLgn\u001a(b[\u0016,\"Aa\u001b\u0011\t\tU#QN\u0005\u0005\u0003O\u00129&\u0001\fbaBd\u0017nY1uS>t7\u000b\u001e:j]\u001et\u0015-\\3!\u0003!\u0019\b\u000f\\5ui\u0016\u0014\u0018!C:qY&$H/\u001a:!\u0003\u0011Ig.\u001b;\u0015\u0005\u0005\u0005\u0015aC3yK\u000e,H/\u001a'j]\u0016$bA! \u0003\u000e\n=\u0005\u0003\u0002B@\u0005\u0013k!A!!\u000b\t\t\r%QQ\u0001\tKb,7-\u001e;fe*\u0019!q\u0011*\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\u0018\u0002\u0002BF\u0005\u0003\u0013q\"\u0012=fGV$XMU3ta>t7/\u001a\u0005\b\u0003s\u001b\u0004\u0019AA_\u0011\u001d\u0011\tj\ra\u0001\u0003+\nAaY8eK\u0006QQ\r_3dkR,\u0007*\u0015'\u0015\r\tu$q\u0013BN\u0011\u001d\u0011I\n\u000ea\u0001\u0003+\n\u0001B]3bY\u000e{G-\u001a\u0005\b\u0005{!\u0004\u0019\u0001B!\u00035\u0019XM\u001c3SKN,H\u000e^*fiR9QN!)\u0003$\n\u0015\u0006bBA]k\u0001\u0007\u0011Q\u0018\u0005\b\u0005{)\u0004\u0019\u0001B!\u0011\u001d\u00119+\u000ea\u0001\u0005S\u000b\u0001\"\\3uC\u0012\u000bG/\u0019\t\u0005\u0005W\u0013I,\u0004\u0002\u0003.*!!q\u0016BY\u0003\u0015!\u0018M\u00197f\u0015\u0011\u0011\u0019L!.\u0002\u0013I,7/\u001e7ug\u0016$(b\u0001B\\%\u000691\u000f^8sC\u001e,\u0017\u0002\u0002B^\u0005[\u0013Q\u0002V1cY\u0016lU\r^1ECR\f\u0017!E4fiJ+7/\u001e7u\u001b\u0016$\u0018\rR1uCR1!\u0011\u0016Ba\u0005/DqAa17\u0001\u0004\u0011)-\u0001\u0007gS\u0016dGmU2iK6\f7\u000f\u0005\u0004\u0002\u0000\n5!q\u0019\t\u0005\u0005\u0013\u0014\u0019.\u0004\u0002\u0003L*!!Q\u001aBh\u0003\r\t\u0007/\u001b\u0006\u0004\u0005#T\u0018!C7fi\u0006\u001cHo\u001c:f\u0013\u0011\u0011)Na3\u0003\u0017\u0019KW\r\u001c3TG\",W.\u0019\u0005\b\u000534\u0004\u0019\u0001Bn\u00031)8/\u001a+bE2,g*Y7f!\rq'Q\\\u0005\u0004\u0005?|'a\u0002\"p_2,\u0017M\\\u0001\u000eSNtuNU3tk2$8+\u001d7\u0015\t\tm'Q\u001d\u0005\b\u0005O<\u0004\u0019AA+\u0003\r\u0019\u0018\u000f\\\u0001\u000b_:\u001cu.\u001c9mKR,\u0017\u0001F2mK\u0006\u00148)\u001e:sK:$\bK]8he\u0016\u001c8/A\u0007kkN$h)[3mI:\u000bW.\u001a\u000b\u0005\u0003+\u0012\t\u0010C\u0004\u0003tj\u0002\r!!\u0016\u0002\u0015M\u001c\u0007.Z7b\u001d\u0006lW-A\tfq\u0016\u001cW\u000f^3D_6\u0004H.\u001a;fYf$\u0002B! \u0003z\nm(Q \u0005\b\u0003s[\u0004\u0019AA_\u0011\u001d\u0011\tj\u000fa\u0001\u0003+BqAa@<\u0001\u0004\t)&A\u0007d_6\u0004H.\u001a;fI2Kg.Z\u0001\u0006G2|7/Z\u0001\u000e\r\u0016$8\r\u001b*fg>,(oY3\u0016\u0005\r\u001d\u0001\u0003CA\u0000\u0007\u0013\t)f!\u0004\n\t\r-\u00111\u001c\u0002\b\u0011\u0006\u001c\b.T1q!\u0011\u0019ya!\b\u000e\u0005\rE!\u0002BB\n\u0007+\t\u0001B]3t_V\u00148-\u001a\u0006\u0005\u0007/\u0019I\"\u0001\u0005qe>$xnY8m\u0015\u0011\u0019YB!\b\u0002\r\r|W.\\8o\u0013\u0011\u0019yb!\u0005\u0003%I+7o\\;sG\u0016<\u0016\u000e\u001e5Ti\u0006$Xo]\u0001\taJ|wM]3tgR!\u0011qUB\u0013\u0011\u001d\u00199C\u0010a\u0001\u0003+\na\u0001^1tW&#\u0015aD4fiB\u0013xn\u001a:fgNLeNZ8\u0015\t\r52\u0011\t\t\u0006]\u000e=21G\u0005\u0004\u0007cy'!B!se\u0006L\b\u0003BB\u001b\u0007{i!aa\u000e\u000b\t\re21H\u0001\u0007K:<\u0017N\\3\u000b\u0007\r]!+\u0003\u0003\u0004@\r]\"a\u0004&pEB\u0013xn\u001a:fgNLeNZ8\t\u000f\r\u001dr\b1\u0001\u0002V\u0005A1.\u001b7m)\u0006\u001c8\u000e\u0006\u0003\u0002\u0002\u000e\u001d\u0003bBB\u0014\u0001\u0002\u0007\u0011QK\u0001\u0014gV\u0004\bo\u001c:u\u0007\u0006dGNQ1dW2{wm\u001d\u000b\u0003\u00057\f\u0011cZ3u\u000bb,7-\u001e;pe2\u000b'-\u001a7t)\t\u0019\t\u0006\u0005\u0004\u0002\u0000\n511\u000b\u0019\u0005\u0007+\u001aI\u0006\u0005\u0004\u0003\u0016\t\u00052q\u000b\t\u0005\u0005O\u0019I\u0006B\u0006\u0004\\\t\u000b\t\u0011!A\u0003\u0002\t=\"aA0%g\u0005\t2/\u001a;Fq\u0016\u001cW\u000f^8s\u0019\u0006\u0014W\r\\:\u0015\t\u0005\u00055\u0011\r\u0005\b\u0007G\u001a\u0005\u0019AB3\u0003\u0019a\u0017MY3mgB1\u0011q B\u0007\u0007O\u0002Da!\u001b\u0004nA1!Q\u0003B\u0011\u0007W\u0002BAa\n\u0004n\u0011a1qNB1\u0003\u0003\u0005\tQ!\u0001\u00030\t\u0019q\f\n\u001b\u0002/I,\u0017/^3ti\u0016C\b/Z2uK\u0012\u0014Vm]8ve\u000e,G\u0003BB;\u0007\u0003\u0003Baa\u001e\u0004~5\u00111\u0011\u0010\u0006\u0005\u0007'\u0019YHC\u0002i\u00073IAaa \u0004z\taaj\u001c3f%\u0016\u001cx.\u001e:dK\"911\u0011#A\u0002\rU\u0014\u0001E3ya\u0016\u001cG/\u001a3SKN|WO]2f\u0003Y9W\r^\"veJ,g\u000e\u001e(pI\u0016\u0014Vm]8ve\u000e,GCAB;\u0003\u00159W\r^%e)\t\t)&\u0001\fISZ,WI\\4j]\u0016\u001cuN\u001c8Fq\u0016\u001cW\u000f^8s!\r\t\u0019\u0004S\n\u0004\u0011\u000eM\u0005c\u00018\u0004\u0016&\u00191qS8\u0003\r\u0005s\u0017PU3g)\t\u0019y)A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0003\u0007?SC!!\b\u0004\".\u001211\u0015\t\u0005\u0007K\u001by+\u0004\u0002\u0004(*!1\u0011VBV\u0003%)hn\u00195fG.,GMC\u0002\u0004.>\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0019\tla*\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class HiveEngineConnExecutor
extends ComputationExecutor
implements ResourceFetchExecutor {
    private final int id;
    private final SessionState sessionState;
    private final UserGroupInformation ugi;
    private final HiveConf hiveConf;
    public final ByteArrayOutputStream org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$baos;
    private final Logger LOG;
    private final String namePrefix;
    private CommandProcessor proc;
    private int map;
    private int reduce;
    private final float totalTask;
    private float singleLineProgress;
    private EngineExecutionContext engineExecutorContext;
    private final AtomicBoolean singleCodeCompleted;
    private int numberOfMRJobs;
    private float currentSqlProgress;
    private final Map<String, Object> org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap;
    private final List<Label<?>> executorLabels;
    private HiveDriverProxy org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver;
    private Thread org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$thread;
    private final String applicationStringName;
    private final String splitter;

    public static ByteArrayOutputStream $lessinit$greater$default$5() {
        return HiveEngineConnExecutor$.MODULE$.$lessinit$greater$default$5();
    }

    private Logger LOG() {
        return this.LOG;
    }

    private String namePrefix() {
        return this.namePrefix;
    }

    private CommandProcessor proc() {
        return this.proc;
    }

    private void proc_$eq(CommandProcessor x$1) {
        this.proc = x$1;
    }

    private int map() {
        return this.map;
    }

    private void map_$eq(int x$1) {
        this.map = x$1;
    }

    private int reduce() {
        return this.reduce;
    }

    private void reduce_$eq(int x$1) {
        this.reduce = x$1;
    }

    private float totalTask() {
        return this.totalTask;
    }

    private float singleLineProgress() {
        return this.singleLineProgress;
    }

    private void singleLineProgress_$eq(float x$1) {
        this.singleLineProgress = x$1;
    }

    private EngineExecutionContext engineExecutorContext() {
        return this.engineExecutorContext;
    }

    private void engineExecutorContext_$eq(EngineExecutionContext x$1) {
        this.engineExecutorContext = x$1;
    }

    private AtomicBoolean singleCodeCompleted() {
        return this.singleCodeCompleted;
    }

    private int numberOfMRJobs() {
        return this.numberOfMRJobs;
    }

    private void numberOfMRJobs_$eq(int x$1) {
        this.numberOfMRJobs = x$1;
    }

    private float currentSqlProgress() {
        return this.currentSqlProgress;
    }

    private void currentSqlProgress_$eq(float x$1) {
        this.currentSqlProgress = x$1;
    }

    public Map<String, Object> org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap() {
        return this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap;
    }

    private List<Label<?>> executorLabels() {
        return this.executorLabels;
    }

    public HiveDriverProxy org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver() {
        return this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver;
    }

    public void org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver_$eq(HiveDriverProxy x$1) {
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver = x$1;
    }

    private Thread org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$thread() {
        return this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$thread;
    }

    public void org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$thread_$eq(Thread x$1) {
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$thread = x$1;
    }

    private String applicationStringName() {
        return this.applicationStringName;
    }

    private String splitter() {
        return this.splitter;
    }

    public void init() {
        this.LOG().info("Ready to change engine state!");
        Object object = BoxesRunTime.unboxToBoolean((Object)HadoopConf$.MODULE$.KEYTAB_PROXYUSER_ENABLED().getValue()) ? System.setProperty("javax.security.auth.useSubjectCredsOnly", "false") : BoxedUnit.UNIT;
        this.setCodeParser((CodeParser)new SQLCodeParser());
        super.init();
    }

    public ExecuteResponse executeLine(EngineExecutionContext engineExecutorContext, String code) {
        this.engineExecutorContext_$eq(engineExecutorContext);
        CSHiveHelper$.MODULE$.setContextIDInfoToHiveConf(engineExecutorContext, this.hiveConf);
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap().clear();
        this.singleCodeCompleted().set(false);
        this.currentSqlProgress_$eq(0.0f);
        String realCode = code.trim();
        this.LOG().info(new StringBuilder(37).append("hive client begins to run hql code:\n ").append(realCode.trim()).toString());
        String jobId = JobUtils$.MODULE$.getJobIdFromMap(engineExecutorContext.getProperties());
        if (StringUtils.isNotBlank((CharSequence)jobId)) {
            String jobTags = JobUtils$.MODULE$.getJobSourceTagsFromObjectMap(engineExecutorContext.getProperties());
            String tags = StringUtils.isAsciiPrintable((CharSequence)jobTags) ? new StringBuilder(8).append("LINKIS_").append(jobId).append(",").append(jobTags).toString() : new StringBuilder(7).append("LINKIS_").append(jobId).toString();
            this.LOG().info(new StringBuilder(23).append("set mapreduce.job.tags=").append(tags).toString());
            this.hiveConf.set("mapreduce.job.tags", tags);
        }
        if (realCode.trim().length() > 500) {
            engineExecutorContext.appendStdout(new StringBuilder(8).append(this.getId()).append(" >> ").append(realCode.trim().substring(0, 500)).append(" ...").toString());
        } else {
            engineExecutorContext.appendStdout(new StringBuilder(4).append(this.getId()).append(" >> ").append(realCode.trim()).toString());
        }
        String[] tokens = realCode.trim().split("\\s+");
        SessionState.setCurrentSessionState((SessionState)this.sessionState);
        this.sessionState.setLastCommand(code);
        if (engineExecutorContext.getCurrentParagraph() == 1 && engineExecutorContext.getProperties().containsKey(JobRequestConstants$.MODULE$.LINKIS_JDBC_DEFAULT_DB())) {
            String defaultDB = (String)engineExecutorContext.getProperties().get(JobRequestConstants$.MODULE$.LINKIS_JDBC_DEFAULT_DB());
            this.logger().info(new StringBuilder(18).append("set default DB to ").append(defaultDB).toString());
            this.sessionState.setCurrentDatabase(defaultDB);
        }
        CommandProcessor proc = CommandProcessorFactory.get((String[])tokens, (HiveConf)this.hiveConf);
        this.proc_$eq(proc);
        this.LOG().debug(new StringBuilder(7).append("ugi is ").append(this.ugi.getUserName()).toString());
        return (ExecuteResponse)Utils$.MODULE$.tryFinally((Function0 & Serializable & scala.Serializable)() -> (ExecuteResponse)$this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ExecuteResponse>(this, proc, realCode, tokens, engineExecutorContext){
            private final /* synthetic */ HiveEngineConnExecutor $outer;
            private final CommandProcessor proc$1;
            private final String realCode$1;
            private final String[] tokens$1;
            private final EngineExecutionContext engineExecutorContext$1;

            public ExecuteResponse run() {
                CommandProcessor commandProcessor = this.proc$1;
                if (HiveDriverProxy$.MODULE$.isDriver(commandProcessor)) {
                    this.$outer.logger().info(new StringBuilder(10).append("driver is ").append(commandProcessor).toString());
                    this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$thread_$eq(Thread.currentThread());
                    this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver_$eq(new HiveDriverProxy(commandProcessor));
                    return this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$executeHQL(this.realCode$1, this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver());
                }
                CommandProcessorResponse resp = this.proc$1.run(this.realCode$1.substring(this.tokens$1[0].length()).trim());
                String result = new String(this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$baos.toByteArray());
                this.$outer.logger().info("RESULT => {}", new Object[]{result});
                this.engineExecutorContext$1.appendStdout(result);
                this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$baos.reset();
                if (resp.getResponseCode() != 0) {
                    this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$clearCurrentProgress();
                    HiveProgressHelper$.MODULE$.clearHiveProgress();
                    this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$onComplete();
                    this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap().clear();
                    HiveProgressHelper$.MODULE$.storeSingleSQLProgress(0.0f);
                    throw resp.getException();
                }
                HiveProgressHelper$.MODULE$.clearHiveProgress();
                HiveProgressHelper$.MODULE$.storeSingleSQLProgress(0.0f);
                this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$onComplete();
                this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap().clear();
                return new SuccessExecuteResponse();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.proc$1 = proc$1;
                this.realCode$1 = realCode$1;
                this.tokens$1 = tokens$1;
                this.engineExecutorContext$1 = engineExecutorContext$1;
            }
        }), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver() != null) {
                Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver().close();
                    this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver_$eq(null);
                    SessionState ss = SessionState.get();
                    if (ss != null) {
                        ss.deleteTmpOutputFile();
                        ss.deleteTmpErrOutputFile();
                        return;
                    }
                });
                return;
            }
        });
    }

    public ExecuteResponse org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$executeHQL(String realCode, HiveDriverProxy driver) {
        boolean needRetry = true;
        int tryCount = 0;
        boolean hasResult = false;
        int rows = 0;
        int columnCount = 0;
        while (needRetry) {
            needRetry = false;
            driver.setTryCount(tryCount + 1);
            long startTime = System.currentTimeMillis();
            try {
                List list;
                CommandProcessorResponse hiveResponse;
                CommandProcessorResponse commandProcessorResponse;
                if (!HiveDriverProxy$.MODULE$.isIDriver(driver.getDriver())) {
                    IntRef compileRet = IntRef.create((int)-1);
                    Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        compileRet$1.elem = driver.compile(realCode);
                        this.logger().info(new StringBuilder(50).append("driver compile realCode : \n ").append(realCode).append(" \n finished, status : ").append(compileRet$1.elem).toString());
                        if (0 != compileRet$1.elem) {
                            this.logger().warn(new StringBuilder(39).append("compile realCode : \n ").append(realCode).append(" \n error status : ").append(compileRet$1.elem).toString());
                            throw new HiveQueryFailedException(HiveErrorCodeSummary.COMPILE_HIVE_QUERY_ERROR.getErrorCode(), HiveErrorCodeSummary.COMPILE_HIVE_QUERY_ERROR.getErrorDesc());
                        }
                        QueryPlan queryPlan = driver.getPlan();
                        int numberOfJobs = Utilities.getMRTasks((List)queryPlan.getRootTasks()).size();
                        this.numberOfMRJobs_$eq(numberOfJobs);
                        this.logger().info(new StringBuilder(16).append("there are ").append(this.numberOfMRJobs()).append(" jobs.").toString());
                    }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
                        HiveEngineConnExecutor.$anonfun$executeHQL$2(this, x0$1);
                        return BoxedUnit.UNIT;
                    });
                    if (this.numberOfMRJobs() > 0) {
                        this.engineExecutorContext().appendStdout(new StringBuilder(32).append("Your hive sql has ").append(this.numberOfMRJobs()).append(" MR jobs to do").toString());
                    }
                    if (this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$thread().isInterrupted()) {
                        this.logger().error("The thread of execution has been interrupted and the task should be terminated");
                        return new ErrorExecuteResponse("The thread of execution has been interrupted and the task should be terminated", null);
                    }
                    commandProcessorResponse = driver.run(realCode, compileRet.elem == 0);
                } else {
                    commandProcessorResponse = hiveResponse = driver.run(realCode);
                }
                if (hiveResponse.getResponseCode() != 0) {
                    this.LOG().error("Hive query failed, response code is {}", (Object)BoxesRunTime.boxToInteger((int)hiveResponse.getResponseCode()));
                    return new ErrorExecuteResponse(hiveResponse.getErrorMessage(), hiveResponse.getException());
                }
                this.engineExecutorContext().appendStdout(new StringBuilder(37).append("Time taken: ").append(ByteTimeUtils.msDurationToString((long)(System.currentTimeMillis() - startTime))).append(", begin to fetch results.").toString());
                this.LOG().info(new StringBuilder(41).append(this.getId()).append(" >> Time taken: ").append(ByteTimeUtils.msDurationToString((long)(System.currentTimeMillis() - startTime))).append(", begin to fetch results.").toString());
                if (hiveResponse.getSchema() != null) {
                    list = hiveResponse.getSchema().getFieldSchemas();
                } else if (driver.getSchema() != null) {
                    list = driver.getSchema().getFieldSchemas();
                } else {
                    throw new HiveQueryFailedException(HiveErrorCodeSummary.GET_FIELD_SCHEMAS_ERROR.getErrorCode(), HiveErrorCodeSummary.GET_FIELD_SCHEMAS_ERROR.getErrorDesc());
                }
                List fieldSchemas = list;
                this.LOG().debug(new StringBuilder(17).append("fieldSchemas are ").append(fieldSchemas).toString());
                if (fieldSchemas == null || this.isNoResultSql(realCode)) {
                    this.numberOfMRJobs_$eq(-1);
                    this.singleCodeCompleted().set(true);
                    this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$onComplete();
                    this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap().clear();
                    return new SuccessExecuteResponse();
                }
                TableMetaData metaData = this.getResultMetaData(fieldSchemas, this.engineExecutorContext().getEnableResultsetMetaWithTableName());
                rows = this.sendResultSet(this.engineExecutorContext(), driver, metaData);
                columnCount = fieldSchemas != null ? fieldSchemas.size() : 0;
                hasResult = true;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (HiveDriverProxy$.MODULE$.isCommandNeedRetryException(throwable2)) {
                    ++tryCount;
                    needRetry = true;
                    HiveProgressHelper$.MODULE$.clearHiveProgress();
                    this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$onComplete();
                    this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap().clear();
                    this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$clearCurrentProgress();
                    HiveProgressHelper$.MODULE$.storeSingleSQLProgress(0.0f);
                    this.LOG().warn("Retry hive query with a different approach...");
                    continue;
                }
                if (throwable2 != null) {
                    Throwable throwable3 = throwable2;
                    this.LOG().error("query failed, reason : ", throwable3);
                    HiveProgressHelper$.MODULE$.clearHiveProgress();
                    this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$clearCurrentProgress();
                    HiveProgressHelper$.MODULE$.storeSingleSQLProgress(0.0f);
                    this.singleCodeCompleted().set(true);
                    this.numberOfMRJobs_$eq(-1);
                    this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$onComplete();
                    this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap().clear();
                    return new ErrorExecuteResponse(throwable3.getMessage(), throwable3);
                }
                throw throwable;
            }
        }
        if (hasResult) {
            this.engineExecutorContext().appendStdout(new StringBuilder(34).append("Fetched  ").append(columnCount).append(" col(s) : ").append(rows).append(" row(s) in hive").toString());
            this.LOG().info(new StringBuilder(38).append(this.getId()).append(" >> Fetched  ").append(columnCount).append(" col(s) : ").append(rows).append(" row(s) in hive").toString());
        }
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$clearCurrentProgress();
        HiveProgressHelper$.MODULE$.clearHiveProgress();
        HiveProgressHelper$.MODULE$.storeSingleSQLProgress(0.0f);
        this.singleCodeCompleted().set(true);
        this.numberOfMRJobs_$eq(-1);
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$onComplete();
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap().clear();
        return new SuccessExecuteResponse();
    }

    private int sendResultSet(EngineExecutionContext engineExecutorContext, HiveDriverProxy driver, TableMetaData metaData) {
        ResultSetWriter resultSetWriter = engineExecutorContext.createResultSetWriter(ResultSetFactory$.MODULE$.TABLE_TYPE());
        resultSetWriter.addMetaData((MetaData)metaData);
        int colLength = metaData.columns().length;
        ArrayList result = new ArrayList();
        int rows = 0;
        while (driver.getResults(result)) {
            Buffer scalaResult = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(result).asScala();
            scalaResult.foreach((Function1 & Serializable & scala.Serializable)s -> {
                HiveEngineConnExecutor.$anonfun$sendResultSet$1(this, colLength, resultSetWriter, s);
                return BoxedUnit.UNIT;
            });
            rows += result.size();
            result.clear();
        }
        engineExecutorContext.sendResultSet(resultSetWriter);
        return rows;
    }

    private TableMetaData getResultMetaData(List<FieldSchema> fieldSchemas, boolean useTableName) {
        List<FieldSchema> results = null;
        HashSet nameSet = new HashSet();
        ArrayList<FieldSchema> cleanSchema = new ArrayList<FieldSchema>();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fieldSchemas).asScala()).foreach((Function1 & Serializable & scala.Serializable)fieldSchema -> {
            String name = fieldSchema.getName();
            if (new StringOps(Predef$.MODULE$.augmentString(name)).split('.').length == 2) {
                nameSet.add((Object)new StringOps(Predef$.MODULE$.augmentString(name)).split('.')[1]);
                return ((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)cleanSchema).asScala()).$plus$eq((Object)new FieldSchema(new StringOps(Predef$.MODULE$.augmentString(name)).split('.')[1], fieldSchema.getType(), fieldSchema.getComment()));
            }
            return BoxedUnit.UNIT;
        });
        results = nameSet.size() < ((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(fieldSchemas).asScala()).length() ? fieldSchemas : (useTableName ? fieldSchemas : cleanSchema);
        Column[] columns = (Column[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(results).asScala()).map((Function1 & Serializable & scala.Serializable)result -> new Column(result.getName(), DataType$.MODULE$.toDataType(result.getType().toLowerCase()), result.getComment()), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Column.class));
        TableMetaData metaData = new TableMetaData(columns);
        return metaData;
    }

    private boolean isNoResultSql(String sql) {
        return sql.trim().startsWith("create table") || sql.trim().startsWith("drop table");
    }

    public void org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$onComplete() {
    }

    public void org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$clearCurrentProgress() {
        this.reduce_$eq(0);
        this.map_$eq(0);
        this.singleLineProgress_$eq(0.0f);
    }

    private String justFieldName(String schemaName) {
        this.LOG().debug(new StringBuilder(12).append("schemaName: ").append(schemaName).toString());
        String[] arr = schemaName.split("\\.");
        if (arr.length == 2) {
            return arr[1];
        }
        return schemaName;
    }

    public ExecuteResponse executeCompletely(EngineExecutionContext engineExecutorContext, String code, String completedLine) {
        String completeCode = new StringBuilder(0).append(code).append(completedLine).toString();
        return this.executeLine(engineExecutorContext, completeCode);
    }

    public void close() {
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap().clear();
        Utils$.MODULE$.tryAndWarnMsg((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.sessionState.close(), "close session failed", this.logger());
        super.close();
    }

    public HashMap<String, ResourceWithStatus> FetchResource() {
        HashMap<String, ResourceWithStatus> resourceMap = new HashMap<String, ResourceWithStatus>();
        String queue = this.hiveConf.get("mapreduce.job.queuename");
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(HadoopJobExecHelper.runningJobs).asScala()).foreach((Function1 & Serializable & scala.Serializable)yarnJob -> {
            Counters counters = yarnJob.getCounters();
            if (counters != null) {
                long millsMap = counters.getCounter((Enum)Counters$.MODULE$.MILLIS_MAPS());
                long millsReduces = counters.getCounter((Enum)Counters$.MODULE$.MILLIS_REDUCES());
                long totalMapCores = counters.getCounter((Enum)Counters$.MODULE$.VCORES_MILLIS_MAPS());
                long totalReducesCores = counters.getCounter((Enum)Counters$.MODULE$.VCORES_MILLIS_REDUCES());
                long totalMapMBMemory = counters.getCounter((Enum)Counters$.MODULE$.MB_MILLIS_MAPS());
                long totalReducesMBMemory = counters.getCounter((Enum)Counters$.MODULE$.MB_MILLIS_REDUCES());
                int avgCores = 0;
                long avgMemory = 0L;
                if (millsMap > 0L && millsReduces > 0L) {
                    avgCores = (int)Math.ceil(totalMapCores / millsMap + totalReducesCores / millsReduces);
                    avgMemory = (long)Math.ceil(totalMapMBMemory * 1024L * 1024L / millsMap + totalReducesMBMemory * 1024L * 1024L / millsReduces);
                    ResourceWithStatus yarnResource = new ResourceWithStatus(avgMemory, avgCores, 0, JobStatus.getJobRunState((int)yarnJob.getJobStatus().getRunState()), queue);
                    String applicationId = new StringBuilder(0).append(this.applicationStringName()).append(this.splitter()).append(yarnJob.getID().getJtIdentifier()).append(this.splitter()).append(yarnJob.getID().getId()).toString();
                    return resourceMap.put(applicationId, yarnResource);
                }
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        return resourceMap;
    }

    public float progress(String taskID) {
        if (this.engineExecutorContext() != null) {
            int hiveRunJobs;
            RunningJob runningJob;
            float _progress;
            int totalSQLs = this.engineExecutorContext().getTotalParagraph();
            int currentSQL = this.engineExecutorContext().getCurrentParagraph();
            float currentBegin = (float)(currentSQL - 1) / (float)totalSQLs;
            int finishedStage = this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver() != null && this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver().getPlan() != null && !this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver().getPlan().getRootTasks().isEmpty() ? BoxesRunTime.unboxToInt((Object)Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(Utilities.getMRTasks((List)this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver().getPlan().getRootTasks())).asScala()).count((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToBoolean((boolean)HiveEngineConnExecutor.$anonfun$progress$2(task))))) : 0;
            float totalProgress = 0.0f;
            if (!HadoopJobExecHelper.runningJobs.isEmpty() && !Float.isNaN(_progress = BoxesRunTime.unboxToFloat((Object)Utils$.MODULE$.tryCatch((Function0)((JFunction0.mcF.sp & Serializable & scala.Serializable)() -> HiveEngineConnExecutor.$anonfun$progress$3(runningJob = (RunningJob)HadoopJobExecHelper.runningJobs.get(0))), (Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToFloat((float)HiveEngineConnExecutor.$anonfun$progress$4(this, runningJob, x0$1)))))) {
                totalProgress = _progress / (float)2;
            }
            this.logger().info(new StringBuilder(51).append("Running stage  progress is ").append(totalProgress).append(", and finished stage is ").append(finishedStage).toString());
            int n = hiveRunJobs = this.numberOfMRJobs() <= 0 ? 1 : this.numberOfMRJobs();
            if (finishedStage <= hiveRunJobs) {
                totalProgress += (float)finishedStage;
            }
            try {
                totalProgress /= (float)(hiveRunJobs * totalSQLs);
            }
            catch (Exception e) {
                totalProgress = 0.0f;
            }
            catch (Throwable throwable) {
                totalProgress = 0.0f;
            }
            float newProgress = Float.isNaN(totalProgress) || Float.isInfinite(totalProgress) ? currentBegin : totalProgress + currentBegin;
            this.logger().info(new StringBuilder(41).append("Hive progress is ").append(newProgress).append(", and finished stage is ").append(finishedStage).toString());
            float oldProgress = ProgressUtils$.MODULE$.getOldProgress(this.engineExecutorContext());
            if (newProgress < oldProgress) {
                return oldProgress;
            }
            ProgressUtils$.MODULE$.putProgress(newProgress, this.engineExecutorContext());
            return newProgress;
        }
        return 0.0f;
    }

    public JobProgressInfo[] getProgressInfo(String taskID) {
        ArrayBuffer arrayBuffer = new ArrayBuffer();
        Map<String, Object> map = this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap();
        synchronized (map) {
            Set<String> set = this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap().keySet();
            java.util.HashSet tempSet = new java.util.HashSet(HadoopJobExecHelper.runningJobs);
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(set).asScala()).foreach((Function1 & Serializable & scala.Serializable)key -> {
                if (!tempSet.contains(key)) {
                    return arrayBuffer.$plus$eq((Object)new JobProgressInfo(key, 200, 0, 0, 200));
                }
                return BoxedUnit.UNIT;
            });
        }
        List list = HadoopJobExecHelper.runningJobs;
        synchronized (list) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(HadoopJobExecHelper.runningJobs).asScala()).foreach((Function1 & Serializable & scala.Serializable)runningJob -> {
                int succeedTask = (int)((runningJob.mapProgress() + runningJob.reduceProgress()) * (float)100);
                if (((Object)BoxesRunTime.boxToInteger((int)succeedTask)).equals(BoxesRunTime.boxToInteger((int)((int)this.totalTask()))) || runningJob.isComplete() || runningJob.isSuccessful()) {
                    return arrayBuffer.$plus$eq((Object)new JobProgressInfo(runningJob.getID().toString(), (int)this.totalTask(), 0, 0, (int)this.totalTask()));
                }
                return arrayBuffer.$plus$eq((Object)new JobProgressInfo(runningJob.getID().toString(), (int)this.totalTask(), 1, 0, succeedTask));
            });
        }
        return (JobProgressInfo[])arrayBuffer.toArray(ClassTag$.MODULE$.apply(JobProgressInfo.class));
    }

    public void killTask(String taskID) {
        this.LOG().info(new StringBuilder(34).append("hive begins to kill job with id : ").append(taskID).toString());
        this.LOG().info(new StringBuilder(18).append("hive engine type :").append(HiveEngineConfiguration$.MODULE$.HIVE_ENGINE_TYPE()).toString());
        String string = HiveEngineConfiguration$.MODULE$.HIVE_ENGINE_TYPE();
        if ("mr".equals(string)) {
            HadoopJobExecHelper.killRunningJobs();
            Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> HiveInterruptUtils.interrupt());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver().close(), this.logger());
        } else if ("tez".equals(string)) {
            Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> TezJobExecHelper.killRunningJobs());
            this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver().close();
        } else {
            throw new MatchError((Object)string);
        }
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$clearCurrentProgress();
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap().clear();
        HiveProgressHelper$.MODULE$.clearHiveProgress();
        this.LOG().info("hive killed job successfully");
        super.killTask(taskID);
    }

    public boolean supportCallBackLogs() {
        return true;
    }

    public List<Label<?>> getExecutorLabels() {
        return this.executorLabels();
    }

    public void setExecutorLabels(List<Label<?>> labels) {
        if (labels != null) {
            this.executorLabels().clear();
            this.executorLabels().addAll(labels);
            return;
        }
    }

    public NodeResource requestExpectedResource(NodeResource expectedResource) {
        return null;
    }

    public NodeResource getCurrentNodeResource() {
        CommonNodeResource resource = new CommonNodeResource();
        resource.setUsedResource((Resource)NodeResourceUtils$.MODULE$.applyAsLoadInstanceResource(EngineConnObject$.MODULE$.getEngineCreationContext().getOptions()));
        return resource;
    }

    public String getId() {
        return new StringBuilder(0).append(this.namePrefix()).append(this.id).toString();
    }

    public static final /* synthetic */ void $anonfun$executeHQL$2(HiveEngineConnExecutor $this, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            $this.logger().warn("obtain hive execute query plan failed,", (Throwable)exception);
            return;
        }
        if (throwable != null) {
            Throwable throwable2 = throwable;
            $this.logger().warn("obtain hive execute query plan failed,", throwable2);
            return;
        }
        throw new MatchError((Object)throwable);
    }

    public static final /* synthetic */ void $anonfun$sendResultSet$1(HiveEngineConnExecutor $this, int colLength$1, ResultSetWriter resultSetWriter$1, String s) {
        String[] arr = s.split("\t");
        ArrayBuffer arrAny = new ArrayBuffer();
        if (arr.length > colLength$1) {
            $this.logger().error("There is a \t tab in the result of hive code query, hive cannot cut it, please use spark to execute(\u67e5\u8be2\u7684\u7ed3\u679c\u4e2d\u6709\t\u5236\u8868\u7b26\uff0chive\u4e0d\u80fd\u8fdb\u884c\u5207\u5272,\u8bf7\u4f7f\u7528spark\u6267\u884c)");
            throw new ErrorException(60078, "There is a \\t tab in the result of your query, hive cannot cut it, please use spark to execute(\u60a8\u67e5\u8be2\u7684\u7ed3\u679c\u4e2d\u6709\\t\u5236\u8868\u7b26\uff0chive\u4e0d\u80fd\u8fdb\u884c\u5207\u5272,\u8bf7\u4f7f\u7528spark\u6267\u884c)");
        }
        if (arr.length == colLength$1) {
            List list = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)arrAny).asJava();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arr)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)list.add(x$1)));
        } else if (arr.length == 0) {
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), colLength$1).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> ((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)arrAny).asJava()).add(""));
        } else {
            int i2 = colLength$1 - arr.length;
            List list = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)arrAny).asJava();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arr)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)list.add(x$1)));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), i2).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> ((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)arrAny).asJava()).add(""));
        }
        resultSetWriter$1.addRecord((Record)new TableRecord((Object[])arrAny.toArray(ClassTag$.MODULE$.Any())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$progress$2(ExecDriver task) {
        if (!task.isMapRedTask()) return false;
        Task.TaskState taskState = task.getTaskState();
        Task.TaskState taskState2 = Task.TaskState.FINISHED;
        if (taskState != null) {
            if (!taskState.equals(taskState2)) return false;
            return true;
        }
        if (taskState2 == null) return true;
        return false;
    }

    public static final /* synthetic */ float $anonfun$progress$3(RunningJob runningJob$1) {
        return runningJob$1.reduceProgress() + runningJob$1.mapProgress();
    }

    public static final /* synthetic */ float $anonfun$progress$4(HiveEngineConnExecutor $this, RunningJob runningJob$1, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            $this.logger().info(new StringBuilder(29).append("Failed to get job(").append(runningJob$1.getJobName()).append(") progress ").toString(), (Throwable)exception);
            return 0.2f;
        }
        throw new MatchError((Object)throwable);
    }

    public HiveEngineConnExecutor(int id, SessionState sessionState, UserGroupInformation ugi, HiveConf hiveConf, ByteArrayOutputStream baos) {
        this.id = id;
        this.sessionState = sessionState;
        this.ugi = ugi;
        this.hiveConf = hiveConf;
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$baos = baos;
        super(ComputationExecutor$.MODULE$.$lessinit$greater$default$1());
        this.LOG = LoggerFactory.getLogger((Class)this.getClass());
        this.namePrefix = "HiveEngineExecutor_";
        this.map = 0;
        this.reduce = 0;
        this.totalTask = 200.0f;
        this.singleLineProgress = 0.0f;
        this.singleCodeCompleted = new AtomicBoolean(false);
        this.numberOfMRJobs = 0;
        this.currentSqlProgress = 0.0f;
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap = new HashMap<String, Object>();
        this.executorLabels = new ArrayList();
        this.applicationStringName = "application";
        this.splitter = "_";
    }
}

