/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.monitor.bml.cleaner.service.impl;

import java.io.Closeable;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.monitor.bml.cleaner.dao.VersionDao;
import org.apache.linkis.monitor.bml.cleaner.entity.CleanedResourceVersion;
import org.apache.linkis.monitor.bml.cleaner.entity.ResourceVersion;
import org.apache.linkis.monitor.bml.cleaner.service.CleanerService;
import org.apache.linkis.monitor.bml.cleaner.service.VersionService;
import org.apache.linkis.monitor.bml.cleaner.vo.CleanResourceVo;
import org.apache.linkis.monitor.constants.Constants;
import org.apache.linkis.storage.FSFactory;
import org.apache.linkis.storage.fs.FileSystem;
import org.apache.linkis.storage.utils.StorageConfiguration;
import org.apache.linkis.storage.utils.StorageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CleanerServiceImpl
implements CleanerService {
    private final Logger logger = LoggerFactory.getLogger((String)"CleanerServiceImpl");
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
    public static final String VERSION_FORMAT = "%06d";
    public static final String VERSION_PREFIX = "v";
    public static final String TRASH_DIR = "/trash";
    private FileSystem fs = null;
    @Autowired
    private VersionDao versionDao;
    private Set<String> cleanedResourceIds = new HashSet<String>();
    Date previous;
    @Autowired
    VersionService versionService;

    public void setVersionDao(VersionDao versionDao) {
        this.versionDao = versionDao;
    }

    public void clean() {
        this.previous = new Date(System.currentTimeMillis() - (Long)Constants.BML_PREVIOUS_INTERVAL_TIME_DAYS().getValue() * 86400L * 1000L);
        if ((Integer)Constants.BML_VERSION_MAX_NUM().getValue() - (Integer)Constants.BML_VERSION_KEEP_NUM().getValue() <= 1) {
            this.logger.error("conf error need to keep version num > 1");
            return;
        }
        List<CleanResourceVo> needCleanResources = this.getCleanResources();
        while (needCleanResources != null && needCleanResources.size() > 0) {
            this.logger.info("need cleaned resource count:{}", (Object)needCleanResources.size());
            this.fs = (FileSystem)FSFactory.getFs((String)StorageUtils.HDFS(), (String)((String)StorageConfiguration.HDFS_ROOT_USER().getValue()));
            for (CleanResourceVo resourceVo : needCleanResources) {
                String minVersion = this.versionDao.getMinKeepVersion(resourceVo.getResourceId(), resourceVo.getMaxVersion(), (Integer)Constants.BML_VERSION_KEEP_NUM().getValue() - 1);
                List<ResourceVersion> cleanVersionList = this.versionDao.getCleanVersionsByResourceId(resourceVo.getResourceId(), minVersion);
                for (ResourceVersion version : cleanVersionList) {
                    FsPath srcPath = new FsPath(version.getResource());
                    try {
                        this.fs.init(null);
                        if (!this.fs.exists(srcPath)) {
                            this.logger.error("try to move but bml source file:{} not exists!", (Object)version.getResource());
                            CleanedResourceVersion cleanedResourceVersion = CleanedResourceVersion.copyFromResourceVersion(version);
                            cleanedResourceVersion.setResource("");
                            this.versionService.moveOnDb(cleanedResourceVersion, version.getId());
                            continue;
                        }
                        String destPrefix = version.getResource().substring(0, version.getResource().indexOf("/bml/") + 4);
                        String destPath = destPrefix + TRASH_DIR + File.separator + this.sdf.format(new Date()) + File.separator + version.getResourceId() + "_" + version.getVersion();
                        FsPath dest = new FsPath(destPath);
                        if (!this.fs.exists(dest.getParent())) {
                            this.fs.mkdirs(dest.getParent());
                        }
                        this.logger.info("begin to mv bml resource:{} to dest:{}", (Object)version.getResource(), (Object)destPath);
                        CleanedResourceVersion cleanedResourceVersion = CleanedResourceVersion.copyFromResourceVersion(version);
                        cleanedResourceVersion.setResource(destPath);
                        this.versionService.doMove(this.fs, srcPath, dest, cleanedResourceVersion, version.getId());
                    }
                    catch (Exception e) {
                        this.logger.error("failed to mv bml resource:{}", (Object)e.getMessage(), (Object)e);
                    }
                }
                this.cleanedResourceIds.add(resourceVo.getResourceId());
            }
            needCleanResources = this.getCleanResources();
        }
    }

    @Override
    public void run() {
        this.logger.info("start to clean.");
        this.clean();
        this.logger.info("start to shutdown.");
        this.shutdown();
    }

    void shutdown() {
        IOUtils.closeQuietly((Closeable)this.fs);
    }

    List<CleanResourceVo> getCleanResources() {
        List<CleanResourceVo> cleanResourceVoList = this.versionDao.getAllNeedCleanResource((Integer)Constants.BML_VERSION_MAX_NUM().getValue(), this.previous, (Integer)Constants.BML_CLEAN_ONCE_RESOURCE_LIMIT_NUM().getValue());
        return cleanResourceVoList.stream().filter(cleanResourceVo -> !this.cleanedResourceIds.contains(cleanResourceVo.getResourceId())).collect(Collectors.toList());
    }
}

