/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.orchestrator.computation.monitor;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.conf.TimeType;
import org.apache.linkis.common.listener.Event;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.governance.common.conf.GovernanceCommonConf$;
import org.apache.linkis.governance.common.entity.NodeExistStatus;
import org.apache.linkis.governance.common.protocol.engineconn.RequestEngineStatusBatch;
import org.apache.linkis.governance.common.protocol.engineconn.ResponseEngineStatusBatch;
import org.apache.linkis.governance.common.utils.GovernanceConstant$;
import org.apache.linkis.manager.common.entity.enumeration.NodeStatus;
import org.apache.linkis.manager.common.protocol.node.RequestNodeStatus;
import org.apache.linkis.manager.common.protocol.node.ResponseNodeStatus;
import org.apache.linkis.orchestrator.computation.conf.ComputationOrchestratorConf$;
import org.apache.linkis.orchestrator.computation.execute.CodeExecTaskExecutor;
import org.apache.linkis.orchestrator.computation.execute.EngineConnTaskInfo;
import org.apache.linkis.orchestrator.computation.monitor.EngineConnMonitor$;
import org.apache.linkis.orchestrator.listener.task.EngineQuitedUnexpectedlyEvent;
import org.apache.linkis.orchestrator.plans.physical.ExecTask;
import org.apache.linkis.rpc.Sender$;
import org.apache.linkis.server.BDPJettyServerHelper$;
import org.apache.linkis.server.package$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ResizableArray;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

public final class EngineConnMonitor$
implements Logging {
    public static EngineConnMonitor$ MODULE$;
    private final long org$apache$linkis$orchestrator$computation$monitor$EngineConnMonitor$$ENGINECONN_LASTUPDATE_TIMEOUT;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new EngineConnMonitor$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        EngineConnMonitor$ engineConnMonitor$ = this;
        synchronized (engineConnMonitor$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public long org$apache$linkis$orchestrator$computation$monitor$EngineConnMonitor$$ENGINECONN_LASTUPDATE_TIMEOUT() {
        return this.org$apache$linkis$orchestrator$computation$monitor$EngineConnMonitor$$ENGINECONN_LASTUPDATE_TIMEOUT;
    }

    public void addEngineExecutorStatusMonitor(Map<EngineConnTaskInfo, CodeExecTaskExecutor> engineConnExecutorCache) {
        Runnable task = new Runnable(engineConnExecutorCache){
            private final Map engineConnExecutorCache$1;

            public void run() {
                Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    long endTime;
                    long startTime = System.currentTimeMillis();
                    HashMap unActivityExecutors = new HashMap();
                    ArrayBuffer allTaskExecutors = new ArrayBuffer();
                    allTaskExecutors.appendAll((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter($this.engineConnExecutorCache$1.values()).asScala());
                    ((ResizableArray)allTaskExecutors.filter((Function1 & Serializable & scala.Serializable)executor -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$run$2(startTime, executor)))).foreach((Function1 & Serializable & scala.Serializable)executor -> {
                        anon.1.$anonfun$run$3(unActivityExecutors, executor);
                        return BoxedUnit.UNIT;
                    });
                    if (unActivityExecutors.nonEmpty()) {
                        EngineConnMonitor$.MODULE$.logger().info("There are {} unActivity engineConn.", (Object)BoxesRunTime.boxToInteger((int)unActivityExecutors.size()));
                        if (unActivityExecutors.size() > GovernanceConstant$.MODULE$.REQUEST_ENGINE_STATUS_BATCH_LIMIT()) {
                            EngineConnMonitor$.MODULE$.org$apache$linkis$orchestrator$computation$monitor$EngineConnMonitor$$queryEngineStatusAndHandle((HashMap<ServiceInstance, ArrayBuffer<CodeExecTaskExecutor>>)unActivityExecutors, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)unActivityExecutors.keys().toList()).asJava());
                        } else {
                            ArrayList<ServiceInstance> engineList = new ArrayList<ServiceInstance>();
                            unActivityExecutors.keys().foreach((Function1 & Serializable & scala.Serializable)serviceInstance -> {
                                anon.1.$anonfun$run$5(engineList, unActivityExecutors, serviceInstance);
                                return BoxedUnit.UNIT;
                            });
                            if (!engineList.isEmpty()) {
                                EngineConnMonitor$.MODULE$.org$apache$linkis$orchestrator$computation$monitor$EngineConnMonitor$$queryEngineStatusAndHandle((HashMap<ServiceInstance, ArrayBuffer<CodeExecTaskExecutor>>)unActivityExecutors, engineList);
                                engineList.clear();
                            }
                        }
                    }
                    if ((endTime = System.currentTimeMillis()) - startTime >= ((TimeType)ComputationOrchestratorConf$.MODULE$.ENGINECONN_ACTIVITY_MONITOR_INTERVAL().getValue()).toLong()) {
                        EngineConnMonitor$.MODULE$.logger().warn("Query engines status costs longer time than query task interval, you should increase interval.");
                        return;
                    }
                }, EngineConnMonitor$.MODULE$.logger());
            }

            public static final /* synthetic */ boolean $anonfun$run$2(long startTime$1, CodeExecTaskExecutor executor) {
                return startTime$1 - executor.getEngineConnExecutor().getLastUpdateTime() > EngineConnMonitor$.MODULE$.org$apache$linkis$orchestrator$computation$monitor$EngineConnMonitor$$ENGINECONN_LASTUPDATE_TIMEOUT();
            }

            public static final /* synthetic */ void $anonfun$run$3(HashMap unActivityExecutors$1, CodeExecTaskExecutor executor) {
                ArrayBuffer executors = (ArrayBuffer)unActivityExecutors$1.getOrElseUpdate((Object)executor.getEngineConnExecutor().getServiceInstance(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
                executors.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CodeExecTaskExecutor[]{executor}));
            }

            public static final /* synthetic */ void $anonfun$run$5(ArrayList engineList$1, HashMap unActivityExecutors$1, ServiceInstance serviceInstance) {
                engineList$1.add(serviceInstance);
                if (engineList$1.size() >= GovernanceConstant$.MODULE$.REQUEST_ENGINE_STATUS_BATCH_LIMIT()) {
                    EngineConnMonitor$.MODULE$.org$apache$linkis$orchestrator$computation$monitor$EngineConnMonitor$$queryEngineStatusAndHandle((HashMap<ServiceInstance, ArrayBuffer<CodeExecTaskExecutor>>)unActivityExecutors$1, engineList$1);
                    engineList$1.clear();
                    return;
                }
            }
            {
                this.engineConnExecutorCache$1 = engineConnExecutorCache$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.linkis.orchestrator.computation.monitor.EngineConnMonitor$$anon$1 ), $anonfun$run$4(), $anonfun$run$2$adapted(long org.apache.linkis.orchestrator.computation.execute.CodeExecTaskExecutor ), $anonfun$run$3$adapted(scala.collection.mutable.HashMap org.apache.linkis.orchestrator.computation.execute.CodeExecTaskExecutor ), $anonfun$run$5$adapted(java.util.ArrayList scala.collection.mutable.HashMap org.apache.linkis.common.ServiceInstance )}, serializedLambda);
            }
        };
        Utils$.MODULE$.defaultScheduler().scheduleWithFixedDelay(task, 10000L, ((TimeType)ComputationOrchestratorConf$.MODULE$.ENGINECONN_ACTIVITY_MONITOR_INTERVAL().getValue()).toLong(), TimeUnit.MILLISECONDS);
        this.logger().info("Entrance engineStatusMonitor inited.");
    }

    public void org$apache$linkis$orchestrator$computation$monitor$EngineConnMonitor$$queryEngineStatusAndHandle(HashMap<ServiceInstance, ArrayBuffer<CodeExecTaskExecutor>> unActivityExecutors, List<ServiceInstance> engineList) {
        RequestEngineStatusBatch requestEngineStatus = new RequestEngineStatusBatch(engineList);
        Utils$.MODULE$.tryAndError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Object object = Sender$.MODULE$.getSender((String)GovernanceCommonConf$.MODULE$.MANAGER_SERVICE_NAME().getValue()).ask((Object)requestEngineStatus);
            if (object instanceof ResponseEngineStatusBatch) {
                ResponseEngineStatusBatch responseEngineStatusBatch = (ResponseEngineStatusBatch)object;
                if (responseEngineStatusBatch.msg() != null) {
                    MODULE$.logger().info("ResponseEngineStatusBatch msg: {}", new Object[]{responseEngineStatusBatch.msg()});
                }
                if (responseEngineStatusBatch.engineStatus().size() != requestEngineStatus.engineList().size()) {
                    MODULE$.logger().warn("ResponseEngineStatusBatch engines size: {} is not equal request: {}.", (Object)BoxesRunTime.boxToInteger((int)responseEngineStatusBatch.engineStatus().size()), (Object)BoxesRunTime.boxToInteger((int)requestEngineStatus.engineList().size()));
                    ArrayBuffer unKnownEngines = new ArrayBuffer();
                    ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(requestEngineStatus.engineList()).asScala()).foreach((Function1 & Serializable & scala.Serializable)instance -> {
                        if (!responseEngineStatusBatch.engineStatus().containsKey(instance)) {
                            responseEngineStatusBatch.engineStatus().put(instance, NodeExistStatus.Unknown);
                            return unKnownEngines.$plus$eq(instance);
                        }
                        return BoxedUnit.UNIT;
                    });
                    String instances = ((TraversableOnce)unKnownEngines.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getInstance(), ArrayBuffer$.MODULE$.canBuildFrom())).mkString(",");
                    MODULE$.logger().warn("These engine instances cannot be found in manager : {}", new Object[]{instances});
                }
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(responseEngineStatusBatch.engineStatus()).asScala()).foreach((Function1 & Serializable & scala.Serializable)status -> {
                    EngineConnMonitor$.MODULE$.dealWithEngineStatus((Tuple2<ServiceInstance, NodeExistStatus>)status, (HashMap<ServiceInstance, ArrayBuffer<CodeExecTaskExecutor>>)unActivityExecutors);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            MODULE$.logger().warn("Invalid response. request : {}", new Object[]{BDPJettyServerHelper$.MODULE$.gson().toJson((Object)requestEngineStatus)});
        }, this.logger());
    }

    private void dealWithEngineStatus(Tuple2<ServiceInstance, NodeExistStatus> status, HashMap<ServiceInstance, ArrayBuffer<CodeExecTaskExecutor>> unActivityExecutors) {
        NodeExistStatus nodeExistStatus = (NodeExistStatus)status._2();
        if (NodeExistStatus.UnExist.equals(nodeExistStatus)) {
            this.logger().warn("Engine {} is Failed, now go to clear its task.", new Object[]{status._1()});
            this.killTask((Option<ArrayBuffer<CodeExecTaskExecutor>>)unActivityExecutors.get(status._1()));
            return;
        }
        if (NodeExistStatus.Unknown.equals(nodeExistStatus)) {
            ArrayBuffer engineConnExecutor = package$.MODULE$.toJavaMap(unActivityExecutors).getOrDefault(status._1(), null);
            if (engineConnExecutor != null) {
                BoxedUnit cfr_ignored_0 = (BoxedUnit)Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    RequestNodeStatus requestNodeStatus = new RequestNodeStatus();
                    Object object = Sender$.MODULE$.getSender((ServiceInstance)status._1()).ask((Object)requestNodeStatus);
                    if (object instanceof ResponseNodeStatus) {
                        ResponseNodeStatus responseNodeStatus = (ResponseNodeStatus)object;
                        if (Predef$.MODULE$.Boolean2boolean(NodeStatus.isCompleted((NodeStatus)responseNodeStatus.getNodeStatus()))) {
                            MODULE$.killTask((Option<ArrayBuffer<CodeExecTaskExecutor>>)unActivityExecutors.get(status._1()));
                            return;
                        }
                        if (MODULE$.logger().isDebugEnabled()) {
                            MODULE$.logger().debug("Will update engineConnExecutor({}) lastupdated time", new Object[]{status._1()});
                        }
                        MODULE$.updateExecutorActivityTime((ServiceInstance)status._1(), unActivityExecutors);
                        return;
                    }
                    MODULE$.logger().warn(new StringBuilder(31).append("Unknown response for request : ").append(BDPJettyServerHelper$.MODULE$.gson().toJson((Object)requestNodeStatus)).toString());
                }, (Function1 & Serializable & scala.Serializable)t -> {
                    EngineConnMonitor$.$anonfun$dealWithEngineStatus$2(status, unActivityExecutors, t);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            return;
        }
    }

    private void killTask(Option<ArrayBuffer<CodeExecTaskExecutor>> mayExecutors) {
        if (mayExecutors.isEmpty()) {
            this.logger().error("executor is not Defined");
            return;
        }
        ArrayBuffer executors = (ArrayBuffer)mayExecutors.get();
        executors.foreach((Function1 & Serializable & scala.Serializable)executor -> {
            EngineConnMonitor$.$anonfun$killTask$1(executor);
            return BoxedUnit.UNIT;
        });
    }

    private void updateExecutorActivityTime(ServiceInstance serviceInstance, HashMap<ServiceInstance, ArrayBuffer<CodeExecTaskExecutor>> engineConnExecutorCache) {
        if (serviceInstance != null) {
            ArrayBuffer executors = package$.MODULE$.toJavaMap(engineConnExecutorCache).getOrDefault(serviceInstance, null);
            if (executors != null) {
                executors.foreach((Function1 & Serializable & scala.Serializable)executor -> {
                    EngineConnMonitor$.$anonfun$updateExecutorActivityTime$1(serviceInstance, executor);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            this.logger().warn("EngineConnExecutor {} cannot be found in engineConnExecutorCache", new Object[]{serviceInstance.toString()});
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$dealWithEngineStatus$2(Tuple2 status$1, HashMap unActivityExecutors$3, Throwable t) {
        MODULE$.logger().error(new StringBuilder(56).append("Failed to get status of engineConn : ").append(status$1._1()).append(", now end the job. ").toString(), t);
        MODULE$.killTask((Option<ArrayBuffer<CodeExecTaskExecutor>>)unActivityExecutors$3.get(status$1._1()));
    }

    public static final /* synthetic */ void $anonfun$killTask$1(CodeExecTaskExecutor executor) {
        ExecTask execTask = executor.getExecTask();
        Utils$.MODULE$.tryAndError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MODULE$.logger().warn(new StringBuilder(56).append("Will kill task ").append(execTask.getIDInfo()).append(" because the engine ").append(executor.getEngineConnExecutor().getServiceInstance().toString()).append(" quited unexpectedly.").toString());
            EngineQuitedUnexpectedlyEvent event = new EngineQuitedUnexpectedlyEvent(execTask, executor.getEngineConnExecutor().getServiceInstance().toString());
            execTask.getPhysicalContext().broadcastSyncEvent((Event)event);
        }, MODULE$.logger());
    }

    public static final /* synthetic */ void $anonfun$updateExecutorActivityTime$1(ServiceInstance serviceInstance$1, CodeExecTaskExecutor executor) {
        if (executor.getEngineConnExecutor().getServiceInstance().equals((Object)serviceInstance$1)) {
            executor.getEngineConnExecutor().updateLastUpdateTime();
            return;
        }
    }

    private EngineConnMonitor$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.org$apache$linkis$orchestrator$computation$monitor$EngineConnMonitor$$ENGINECONN_LASTUPDATE_TIMEOUT = ((TimeType)ComputationOrchestratorConf$.MODULE$.ENGINECONN_LASTUPDATE_TIMEOUT().getValue()).toLong();
    }
}

