/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.am.pointer;

import java.util.Optional;
import org.apache.linkis.manager.am.exception.AMErrorException;
import org.apache.linkis.manager.am.pointer.AbstractNodePointer;
import org.apache.linkis.manager.am.pointer.EngineNodePointer;
import org.apache.linkis.manager.common.entity.node.Node;
import org.apache.linkis.manager.common.protocol.RequestEngineLock;
import org.apache.linkis.manager.common.protocol.RequestEngineUnlock;
import org.apache.linkis.manager.common.protocol.ResponseEngineLock;
import org.apache.linkis.manager.common.protocol.engine.EngineOperateRequest;
import org.apache.linkis.manager.common.protocol.engine.EngineOperateResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEngineNodPointer
extends AbstractNodePointer
implements EngineNodePointer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEngineNodPointer.class);
    private Node node;

    public DefaultEngineNodPointer(Node node) {
        this.node = node;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public Optional<String> lockEngine(RequestEngineLock requestEngineLock) {
        Object result = this.getSender().ask((Object)requestEngineLock);
        if (result instanceof ResponseEngineLock) {
            ResponseEngineLock responseEngineLock = (ResponseEngineLock)result;
            if (responseEngineLock.lockStatus()) {
                return Optional.of(responseEngineLock.lock());
            }
            logger.info("Failed to get locker," + this.node.getServiceInstance() + ": " + responseEngineLock.msg());
            return Optional.empty();
        }
        return Optional.empty();
    }

    @Override
    public void releaseLock(RequestEngineUnlock requestEngineUnlock) {
        this.getSender().send((Object)requestEngineUnlock);
    }

    @Override
    public EngineOperateResponse executeOperation(EngineOperateRequest engineOperateRequest) {
        Object result = this.getSender().ask((Object)engineOperateRequest);
        if (result instanceof EngineOperateResponse) {
            return (EngineOperateResponse)result;
        }
        throw new AMErrorException(-1, "Illegal response of operation.");
    }
}

