/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.configuration.validate;

import com.google.gson.GsonBuilder;
import java.io.Serializable;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.configuration.errorcode.LinkisConfigurationErrorCodeSummary;
import org.apache.linkis.configuration.exception.ConfigurationException;
import org.apache.linkis.configuration.validate.Validator;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00153AAB\u0004\u0001%!)Q\u0005\u0001C\u0001M!)\u0001\u0002\u0001C!Q!91\b\u0001a\u0001\n\u0003b\u0004bB\u001f\u0001\u0001\u0004%\tE\u0010\u0005\u0007\t\u0002\u0001\u000b\u0015\u0002\u0018\u0003%9+X.\u001a:jG\u0006dg+\u00197jI\u0006$xN\u001d\u0006\u0003\u0011%\t\u0001B^1mS\u0012\fG/\u001a\u0006\u0003\u0015-\tQbY8oM&<WO]1uS>t'B\u0001\u0007\u000e\u0003\u0019a\u0017N\\6jg*\u0011abD\u0001\u0007CB\f7\r[3\u000b\u0003A\t1a\u001c:h\u0007\u0001\u0019B\u0001A\n\u001a;A\u0011AcF\u0007\u0002+)\ta#A\u0003tG\u0006d\u0017-\u0003\u0002\u0019+\t1\u0011I\\=SK\u001a\u0004\"AG\u000e\u000e\u0003\u001dI!\u0001H\u0004\u0003\u0013Y\u000bG.\u001b3bi>\u0014\bC\u0001\u0010$\u001b\u0005y\"B\u0001\u0011\"\u0003\u0015)H/\u001b7t\u0015\t\u00113\"\u0001\u0004d_6lwN\\\u0005\u0003I}\u0011q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002OA\u0011!\u0004\u0001\u000b\u0004S1J\u0004C\u0001\u000b+\u0013\tYSCA\u0004C_>dW-\u00198\t\u000b5\u0012\u0001\u0019\u0001\u0018\u0002\u000bY\fG.^3\u0011\u0005=2dB\u0001\u00195!\t\tT#D\u00013\u0015\t\u0019\u0014#\u0001\u0004=e>|GOP\u0005\u0003kU\ta\u0001\u0015:fI\u00164\u0017BA\u001c9\u0005\u0019\u0019FO]5oO*\u0011Q'\u0006\u0005\u0006u\t\u0001\rAL\u0001\u0006e\u0006tw-Z\u0001\u0005W&tG-F\u0001/\u0003!Y\u0017N\u001c3`I\u0015\fHCA C!\t!\u0002)\u0003\u0002B+\t!QK\\5u\u0011\u001d\u0019E!!AA\u00029\n1\u0001\u001f\u00132\u0003\u0015Y\u0017N\u001c3!\u0001")
public class NumericalValidator
implements Validator,
Logging {
    private String kind;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        NumericalValidator numericalValidator = this;
        synchronized (numericalValidator) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public boolean validate(String value, String range) {
        boolean bl;
        Object object = new Object();
        try {
            bl = BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                int[] rangArray = (int[])new GsonBuilder().create().fromJson(range, int[].class);
                int valueInt = Integer.parseInt(value);
                if (new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(rangArray)).size() != 2) {
                    throw new ConfigurationException(LinkisConfigurationErrorCodeSummary.ERROR_VALIDATOR_RANGE.getErrorDesc());
                }
                return valueInt >= ((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(rangArray)).sorted((Ordering)Ordering.Int$.MODULE$))[0] && valueInt <= ((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(rangArray)).sorted((Ordering)Ordering.Int$.MODULE$))[1];
            }, (Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)NumericalValidator.$anonfun$validate$2(this, value, object, x0$1))));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    @Override
    public String kind() {
        return this.kind;
    }

    @Override
    public void kind_$eq(String x$1) {
        this.kind = x$1;
    }

    public static final /* synthetic */ boolean $anonfun$validate$2(NumericalValidator $this, String value$1, Object nonLocalReturnKey1$1, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof NumberFormatException) {
            $this.logger().info(new StringBuilder(61).append(value$1).append(" cannot be converted to int, validation failed(").append(value$1).append("\u4e0d\u80fd\u8f6c\u6362\u4e3aint\uff0c\u6821\u9a8c\u5931\u8d25)").toString());
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
        }
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            throw exception;
        }
        throw new MatchError((Object)throwable);
    }

    public NumericalValidator() {
        Logging.$init$((Logging)this);
        this.kind = "NumInterval";
    }
}

