/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.configuration.service;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.configuration.conf.Configuration$;
import org.apache.linkis.configuration.dao.ConfigKeyLimitForUserMapper;
import org.apache.linkis.configuration.dao.ConfigMapper;
import org.apache.linkis.configuration.dao.LabelMapper;
import org.apache.linkis.configuration.entity.ConfigKey;
import org.apache.linkis.configuration.entity.ConfigKeyLimitVo;
import org.apache.linkis.configuration.entity.ConfigKeyValue;
import org.apache.linkis.configuration.entity.ConfigLabel;
import org.apache.linkis.configuration.entity.ConfigTree;
import org.apache.linkis.configuration.entity.ConfigValue;
import org.apache.linkis.configuration.exception.ConfigurationException;
import org.apache.linkis.configuration.util.LabelEntityParser;
import org.apache.linkis.configuration.util.LabelParameterParser$;
import org.apache.linkis.configuration.validate.ValidatorManager;
import org.apache.linkis.governance.common.protocol.conf.RemoveCacheConfRequest;
import org.apache.linkis.governance.common.protocol.conf.ResponseQueryConfig;
import org.apache.linkis.manager.label.builder.CombinedLabelBuilder;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactoryContext;
import org.apache.linkis.manager.label.entity.CombinedLabel;
import org.apache.linkis.manager.label.entity.CombinedLabelImpl;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;
import org.apache.linkis.manager.label.entity.engine.UserCreatorLabel;
import org.apache.linkis.manager.label.utils.EngineTypeLabelCreator;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.Sender$;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Stream$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@Service
@ScalaSignature(bytes="\u0006\u0001\r}e\u0001\u0002\u001b6\u0001\u0001CQa\u0014\u0001\u0005\u0002AC\u0011b\u0015\u0001A\u0002\u0003\u0007I\u0011\u0002+\t\u0013m\u0003\u0001\u0019!a\u0001\n\u0013a\u0006\"\u00032\u0001\u0001\u0004\u0005\t\u0015)\u0003V\u0011%\u0001\b\u00011AA\u0002\u0013%\u0011\u000fC\u0005v\u0001\u0001\u0007\t\u0019!C\u0005m\"I\u0001\u0010\u0001a\u0001\u0002\u0003\u0006KA\u001d\u0005\nu\u0002\u0001\r\u00111A\u0005\nmD1\"!\u0002\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\b!Q\u00111\u0002\u0001A\u0002\u0003\u0005\u000b\u0015\u0002?\t\u0017\u0005=\u0001\u00011AA\u0002\u0013%\u0011\u0011\u0003\u0005\f\u00033\u0001\u0001\u0019!a\u0001\n\u0013\tY\u0002C\u0006\u0002 \u0001\u0001\r\u0011!Q!\n\u0005M\u0001\"CA\u0012\u0001\t\u0007I\u0011BA\u0013\u0011!\tY\u0004\u0001Q\u0001\n\u0005\u001d\u0002bBA\u001f\u0001\u0011\u0005\u0011q\b\u0005\b\u0003\u007f\u0002A\u0011AAA\u0011\u001d\t\t\f\u0001C\u0001\u0003gCq!!2\u0001\t\u0003\t9\rC\u0004\u00022\u0002!\t!a5\t\u000f\u0005\u001d\b\u0001\"\u0001\u0002j\"9\u0011Q\u001e\u0001\u0005\u0002\u0005=\bbBA|\u0001\u0011\u0005\u0011\u0011 \u0005\b\u0005\u0003\u0001A\u0011\u0001B\u0002\u0011%\u0011I\u0002AI\u0001\n\u0003\u0011Y\u0002C\u0005\u00030\u0001\t\n\u0011\"\u0001\u0003\u001c!I!\u0011\u0007\u0001\u0012\u0002\u0013\u0005!1\u0004\u0005\b\u0005g\u0001A\u0011\u0001B\u001b\u0011%\u0011Y\u0005AI\u0001\n\u0003\u0011i\u0005C\u0004\u0003R\u0001!\tAa\u0015\t\u000f\tu\u0003\u0001\"\u0001\u0003`!I!\u0011\u000e\u0001\u0012\u0002\u0013\u0005!1\u0004\u0005\b\u0005W\u0002A\u0011\u0001B7\u0011%\u0011y\nAI\u0001\n\u0003\u0011\t\u000bC\u0004\u0003&\u0002!IAa*\t\u000f\tu\u0006\u0001\"\u0001\u0003@\"I!1\u001b\u0001\u0012\u0002\u0013\u0005!\u0011\u0015\u0005\b\u0005+\u0004A\u0011\u0001Bl\u0011%\u0011I\u000fAI\u0001\n\u0003\u0011\t\u000bC\u0004\u0003l\u0002!\tA!<\t\u0013\r\u0015\u0001!%A\u0005\u0002\t\u0005\u0006bBB\u0004\u0001\u0011\u00051\u0011\u0002\u0005\b\u00073\u0001A\u0011AB\u000e\u0011%\u0019I\u0005AI\u0001\n\u0003\u0011\t\u000bC\u0005\u0004L\u0001\t\n\u0011\"\u0001\u0003\u001c!91Q\n\u0001\u0005\u0002\r=\u0003bBB0\u0001\u0011\u00051\u0011\r\u0005\b\u0007K\u0002A\u0011AB4\u0011\u001d\u00199\b\u0001C\u0001\u0007sBqa!!\u0001\t\u0013\u0019\u0019\tC\u0005\u0004\u0010\u0002\t\n\u0011\"\u0003\u0003\u001c\t!2i\u001c8gS\u001e,(/\u0019;j_:\u001cVM\u001d<jG\u0016T!AN\u001c\u0002\u000fM,'O^5dK*\u0011\u0001(O\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u000b\u0005iZ\u0014A\u00027j].L7O\u0003\u0002={\u00051\u0011\r]1dQ\u0016T\u0011AP\u0001\u0004_J<7\u0001A\n\u0004\u0001\u0005;\u0005C\u0001\"F\u001b\u0005\u0019%\"\u0001#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001b%AB!osJ+g\r\u0005\u0002I\u001b6\t\u0011J\u0003\u0002K\u0017\u0006)Q\u000f^5mg*\u0011A*O\u0001\u0007G>lWn\u001c8\n\u00059K%a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0003\"A\u0015\u0001\u000e\u0003U\nAbY8oM&<W*\u00199qKJ,\u0012!\u0016\t\u0003-fk\u0011a\u0016\u0006\u00031^\n1\u0001Z1p\u0013\tQvK\u0001\u0007D_:4\u0017nZ'baB,'/\u0001\td_:4\u0017nZ'baB,'o\u0018\u0013fcR\u0011Q\f\u0019\t\u0003\u0005zK!aX\"\u0003\tUs\u0017\u000e\u001e\u0005\bC\u000e\t\t\u00111\u0001V\u0003\rAH%M\u0001\u000eG>tg-[4NCB\u0004XM\u001d\u0011)\u0005\u0011!\u0007CA3o\u001b\u00051'BA4i\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003S*\fqAZ1di>\u0014\u0018P\u0003\u0002lY\u0006)!-Z1og*\u0011Q.P\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW&\u0011qN\u001a\u0002\n\u0003V$xn^5sK\u0012\f1\u0002\\1cK2l\u0015\r\u001d9feV\t!\u000f\u0005\u0002Wg&\u0011Ao\u0016\u0002\f\u0019\u0006\u0014W\r\\'baB,'/A\bmC\n,G.T1qa\u0016\u0014x\fJ3r)\tiv\u000fC\u0004b\r\u0005\u0005\t\u0019\u0001:\u0002\u00191\f'-\u001a7NCB\u0004XM\u001d\u0011)\u0005\u001d!\u0017\u0001\u0005<bY&$\u0017\r^8s\u001b\u0006t\u0017mZ3s+\u0005a\bcA?\u0002\u00025\taP\u0003\u0002\u0000o\u0005Aa/\u00197jI\u0006$X-C\u0002\u0002\u0004y\u0014\u0001CV1mS\u0012\fGo\u001c:NC:\fw-\u001a:\u0002)Y\fG.\u001b3bi>\u0014X*\u00198bO\u0016\u0014x\fJ3r)\ri\u0016\u0011\u0002\u0005\bC&\t\t\u00111\u0001}\u0003E1\u0018\r\\5eCR|'/T1oC\u001e,'\u000f\t\u0015\u0003\u0015\u0011\f1dY8oM&<7*Z=MS6LGOR8s+N,'/T1qa\u0016\u0014XCAA\n!\r1\u0016QC\u0005\u0004\u0003/9&aG\"p]\u001aLwmS3z\u0019&l\u0017\u000e\u001e$peV\u001bXM]'baB,'/A\u0010d_:4\u0017nZ&fs2KW.\u001b;G_J,6/\u001a:NCB\u0004XM]0%KF$2!XA\u000f\u0011!\tG\"!AA\u0002\u0005M\u0011\u0001H2p]\u001aLwmS3z\u0019&l\u0017\u000e\u001e$peV\u001bXM]'baB,'\u000f\t\u0015\u0003\u001b\u0011\fAcY8nE&tW\r\u001a'bE\u0016d')^5mI\u0016\u0014XCAA\u0014!\u0011\tI#a\u000e\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\tqAY;jY\u0012,'O\u0003\u0003\u00022\u0005M\u0012!\u00027bE\u0016d'bAA\u001bs\u00059Q.\u00198bO\u0016\u0014\u0018\u0002BA\u001d\u0003W\u0011AcQ8nE&tW\r\u001a'bE\u0016d')^5mI\u0016\u0014\u0018!F2p[\nLg.\u001a3MC\n,GNQ;jY\u0012,'\u000fI\u0001\u0010C\u0012$7*Z=G_J,enZ5oKR9Q,!\u0011\u0002\\\u0005}\u0003bBA\"!\u0001\u0007\u0011QI\u0001\u000bK:<\u0017N\\3UsB,\u0007\u0003BA$\u0003+rA!!\u0013\u0002RA\u0019\u00111J\"\u000e\u0005\u00055#bAA(\u007f\u00051AH]8pizJ1!a\u0015D\u0003\u0019\u0001&/\u001a3fM&!\u0011qKA-\u0005\u0019\u0019FO]5oO*\u0019\u00111K\"\t\u000f\u0005u\u0003\u00031\u0001\u0002F\u00059a/\u001a:tS>t\u0007bBA1!\u0001\u0007\u00111M\u0001\u0004W\u0016L\b\u0003BA3\u0003Wj!!a\u001a\u000b\u0007\u0005%t'\u0001\u0004f]RLG/_\u0005\u0005\u0003[\n9GA\u0005D_:4\u0017nZ&fs\"\u001a\u0001#!\u001d\u0011\t\u0005M\u00141P\u0007\u0003\u0003kR1aZA<\u0015\r\tI\b\\\u0001\fiJ\fgn]1di&|g.\u0003\u0003\u0002~\u0005U$!\u0004+sC:\u001c\u0018m\u0019;j_:\fG.A\fdQ\u0016\u001c7.\u00118e\u0007J,\u0017\r^3Vg\u0016\u0014H*\u00192fYRA\u00111QAJ\u0003S\u000bi\u000b\u0005\u0003\u0002\u0006\u0006=UBAAD\u0015\u0011\tI)a#\u0002\t1\fgn\u001a\u0006\u0003\u0003\u001b\u000bAA[1wC&!\u0011\u0011SAD\u0005\u001dIe\u000e^3hKJDq!!&\u0012\u0001\u0004\t9*\u0001\u0005tKR$\u0018N\\4t!\u0019\tI*a(\u0002$6\u0011\u00111\u0014\u0006\u0005\u0003;\u000bY)\u0001\u0003vi&d\u0017\u0002BAQ\u00037\u0013A\u0001T5tiB!\u0011QMAS\u0013\u0011\t9+a\u001a\u0003\u001d\r{gNZ5h\u0017\u0016Lh+\u00197vK\"9\u00111V\tA\u0002\u0005\u0015\u0013\u0001C;tKJt\u0017-\\3\t\u000f\u0005=\u0016\u00031\u0001\u0002F\u000591M]3bi>\u0014\u0018aD;qI\u0006$X-V:feZ\u000bG.^3\u0015\u000bu\u000b),!1\t\u000f\u0005]&\u00031\u0001\u0002:\u0006Q1M]3bi\u0016d\u0015n\u001d;\u0011\r\u0005e\u0015qTA^!\u0011\t)'!0\n\t\u0005}\u0016q\r\u0002\f\u0007>tg-[4WC2,X\rC\u0004\u0002DJ\u0001\r!!/\u0002\u0015U\u0004H-\u0019;f\u0019&\u001cH/\u0001\tdY\u0016\f'/Q'DC\u000eDWmQ8oMRIQ,!3\u0002L\u00065\u0017\u0011\u001b\u0005\b\u0003W\u001b\u0002\u0019AA#\u0011\u001d\tyk\u0005a\u0001\u0003\u000bBq!a4\u0014\u0001\u0004\t)%\u0001\u0004f]\u001eLg.\u001a\u0005\b\u0003;\u001a\u0002\u0019AA#))\t).a7\u0002`\u0006\r\u0018Q\u001d\t\u0004\u0005\u0006]\u0017bAAm\u0007\n\u0019\u0011I\\=\t\u000f\u0005uG\u00031\u0001\u0002$\u000691/\u001a;uS:<\u0007bBAq)\u0001\u0007\u00111Q\u0001\fkN,'\u000fT1cK2LE\rC\u0004\u00028R\u0001\r!!/\t\u000f\u0005\rG\u00031\u0001\u0002:\u0006Q\u0001/\u0019:b[\u000eCWmY6\u0015\u0007u\u000bY\u000fC\u0004\u0002^V\u0001\r!a)\u0002)A\f'/Y7DQ\u0016\u001c7NQ=LKf4\u0016\r\\;f)\u0015i\u0016\u0011_Az\u0011\u001d\t\tG\u0006a\u0001\u0003\u000bBq!!>\u0017\u0001\u0004\t)%A\u0003wC2,X-A\tmSN$\u0018\t\u001c7F]\u001eLg.\u001a+za\u0016$\"!a?\u0011\u000b\t\u000bi0!\u0012\n\u0007\u0005}8IA\u0003BeJ\f\u00170A\u000bhK:,'/\u0019;f\u0007>l'-\u001b8fI2\u000b'-\u001a7\u0015\u0015\t\u0015!q\u0002B\t\u0005'\u00119\u0002\u0005\u0003\u0003\b\t-QB\u0001B\u0005\u0015\u0011\tI'a\f\n\t\t5!\u0011\u0002\u0002\u000e\u0007>l'-\u001b8fI2\u000b'-\u001a7\t\u0013\u0005\r\u0003\u0004%AA\u0002\u0005\u0015\u0003bBA/1\u0001\u0007\u0011Q\t\u0005\n\u0005+A\u0002\u0013!a\u0001\u0003\u000b\n\u0001\"^:fe:\u000bW.\u001a\u0005\n\u0003_C\u0002\u0013!a\u0001\u0003\u000b\nqdZ3oKJ\fG/Z\"p[\nLg.\u001a3MC\n,G\u000e\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011iB\u000b\u0003\u0002F\t}1F\u0001B\u0011!\u0011\u0011\u0019Ca\u000b\u000e\u0005\t\u0015\"\u0002\u0002B\u0014\u0005S\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005\u001d\u001c\u0015\u0002\u0002B\u0017\u0005K\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003}9WM\\3sCR,7i\\7cS:,G\rT1cK2$C-\u001a4bk2$HeM\u0001 O\u0016tWM]1uK\u000e{WNY5oK\u0012d\u0015MY3mI\u0011,g-Y;mi\u0012\"\u0014a\u00042vS2$GK]3f%\u0016\u001cX\u000f\u001c;\u0015\r\t]\"1\tB$!\u0019\tIJ!\u000f\u0003>%!!1HAN\u0005%\t%O]1z\u0019&\u001cH\u000f\u0005\u0003\u0002f\t}\u0012\u0002\u0002B!\u0003O\u0012!bQ8oM&<GK]3f\u0011\u001d\u0011)\u0005\ba\u0001\u0003/\u000bqaY8oM&<7\u000fC\u0005\u0003Jq\u0001\n\u00111\u0001\u0002\u0018\u0006qA-\u001a4bk2$8i\u001c8gS\u001e\u001c\u0018!\u00072vS2$GK]3f%\u0016\u001cX\u000f\u001c;%I\u00164\u0017-\u001e7uII*\"Aa\u0014+\t\u0005]%qD\u0001\u0017e\u0016\u0004H.Y2f\u0007J,\u0017\r^8s)>,enZ5oKR)QL!\u0016\u0003Z!9!q\u000b\u0010A\u0002\u0005]\u0015!\u00063fM\u0006,H\u000e^\"sK\u0006$xN]\"p]\u001aLwm\u001d\u0005\b\u00057r\u0002\u0019AAL\u0003Q!WMZ1vYR,enZ5oK\u000e{gNZ5hg\u0006\u0011r-\u001a;D_:4\u0017n\u001a\"z\u0019\u0006\u0014W\r\\%e)\u0019\t9J!\u0019\u0003f!9!1M\u0010A\u0002\u0005\r\u0015a\u00027bE\u0016d\u0017\n\u001a\u0005\n\u0005Oz\u0002\u0013!a\u0001\u0003\u000b\n\u0001\u0002\\1oOV\fw-Z\u0001\u001dO\u0016$8i\u001c8gS\u001e\u0014\u0015\u0010T1cK2LE\r\n3fM\u0006,H\u000e\u001e\u00133\u0003U9W\r^\"p]\u001aLwm\u001d\"z\u0019\u0006\u0014W\r\u001c'jgR$\u0002Ba\u001c\u0003v\tM%Q\u0014\t\b\u0005\nE\u0014qSAL\u0013\r\u0011\u0019h\u0011\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\t]\u0014\u00051\u0001\u0003z\u0005IA.\u00192fY2K7\u000f\u001e\t\u0007\u00033\u000byJa\u001f1\t\tu$q\u0011\t\u0007\u0005\u000f\u0011yHa!\n\t\t\u0005%\u0011\u0002\u0002\u0006\u0019\u0006\u0014W\r\u001c\t\u0005\u0005\u000b\u00139\t\u0004\u0001\u0005\u0019\t%%QOA\u0001\u0002\u0003\u0015\tAa#\u0003\u0007}#\u0013'\u0005\u0003\u0003\u000e\u0006U\u0007c\u0001\"\u0003\u0010&\u0019!\u0011S\"\u0003\u000f9{G\u000f[5oO\"I!QS\u0011\u0011\u0002\u0003\u0007!qS\u0001\u0011kN,G)\u001a4bk2$8i\u001c8gS\u001e\u00042A\u0011BM\u0013\r\u0011Yj\u0011\u0002\b\u0005>|G.Z1o\u0011\u001d\u00119'\ta\u0001\u0003\u000b\nqdZ3u\u0007>tg-[4t\u0005fd\u0015MY3m\u0019&\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011\u0019K\u000b\u0003\u0003\u0018\n}\u0011AE4fi\u000e{gN\u001a\"z\u0019\u0006\u0014W\r\u001c'jgR$BA!+\u00030B!\u0011Q\rBV\u0013\u0011\u0011i+a\u001a\u0003\u0017\r{gNZ5h\u0019\u0006\u0014W\r\u001c\u0005\b\u0005o\u001a\u0003\u0019\u0001BY!\u0019\tI*a(\u00034B\"!Q\u0017B]!\u0019\u00119Aa \u00038B!!Q\u0011B]\t1\u0011YLa,\u0002\u0002\u0003\u0005)\u0011\u0001BF\u0005\ryFEM\u0001\u0017O\u0016$h)\u001e7m)J,WMQ=MC\n,G\u000eT5tiRA!q\u0007Ba\u0005\u001f\u0014\t\u000eC\u0004\u0003x\u0011\u0002\rAa1\u0011\r\u0005e\u0015q\u0014Bca\u0011\u00119Ma3\u0011\r\t\u001d!q\u0010Be!\u0011\u0011)Ia3\u0005\u0019\t5'\u0011YA\u0001\u0002\u0003\u0015\tAa#\u0003\u0007}#3\u0007C\u0005\u0003\u0016\u0012\u0002\n\u00111\u0001\u0003\u0018\"9!q\r\u0013A\u0002\u0005\u0015\u0013\u0001I4fi\u001a+H\u000e\u001c+sK\u0016\u0014\u0015\u0010T1cK2d\u0015n\u001d;%I\u00164\u0017-\u001e7uII\n1eZ3u\u0007>tg-[4ve\u0006$\u0018n\u001c8UK6\u0004H.\u0019;f\u0005fd\u0015MY3m\u0019&\u001cH\u000f\u0006\u0004\u00038\te'q\u001d\u0005\b\u0005o2\u0003\u0019\u0001Bn!\u0019\tI*a(\u0003^B\"!q\u001cBr!\u0019\u00119Aa \u0003bB!!Q\u0011Br\t1\u0011)O!7\u0002\u0002\u0003\u0005)\u0011\u0001BF\u0005\ryF\u0005\u000e\u0005\n\u0005+3\u0003\u0013!a\u0001\u0005/\u000bQfZ3u\u0007>tg-[4ve\u0006$\u0018n\u001c8UK6\u0004H.\u0019;f\u0005fd\u0015MY3m\u0019&\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003Q9W\r^\"p]\u001aLw-T1q\u0005fd\u0015MY3mgR1!q\u001eB{\u0007\u0007\u0001\u0002\"!'\u0003r\u0006\u0015\u0013QI\u0005\u0005\u0005g\fYJA\u0002NCBDqAa\u001e)\u0001\u0004\u00119\u0010\u0005\u0004\u0002\u001a\u0006}%\u0011 \u0019\u0005\u0005w\u0014y\u0010\u0005\u0004\u0003\b\t}$Q \t\u0005\u0005\u000b\u0013y\u0010\u0002\u0007\u0004\u0002\tU\u0018\u0011!A\u0001\u0006\u0003\u0011YIA\u0002`IUB\u0011B!&)!\u0003\u0005\rAa&\u0002=\u001d,GoQ8oM&<W*\u00199Cs2\u000b'-\u001a7tI\u0011,g-Y;mi\u0012\u0012\u0014!\u00059feNL7\u000f^3Vg\u0016\u0014h/\u00197vKRIQla\u0003\u0004\u000e\r=11\u0003\u0005\b\u0005\u000bR\u0003\u0019AAL\u0011\u001d\u0011IE\u000ba\u0001\u0003/Cqa!\u0005+\u0001\u0004\u0011)!A\u0007d_6\u0014\u0017N\\3e\u0019\u0006\u0014W\r\u001c\u0005\b\u0007+Q\u0003\u0019\u0001BU\u0003-)\u00070[:ug2\u000b'-\u001a7)\u0007)\n\t(\u0001\nrk\u0016\u0014\u0018pQ8oM&<')\u001f'bE\u0016dG\u0003CB\u000f\u0007g\u0019\te!\u0012\u0011\t\r}1qF\u0007\u0003\u0007CQAaa\t\u0004&\u0005!1m\u001c8g\u0015\u0011\u00199c!\u000b\u0002\u0011A\u0014x\u000e^8d_2T1\u0001TB\u0016\u0015\r\u0019i#O\u0001\u000bO>4XM\u001d8b]\u000e,\u0017\u0002BB\u0019\u0007C\u00111CU3ta>t7/Z)vKJL8i\u001c8gS\u001eDqAa\u001e,\u0001\u0004\u0019)\u0004\u0005\u0004\u0002\u001a\u0006}5q\u0007\u0019\u0005\u0007s\u0019i\u0004\u0005\u0004\u0003\b\t}41\b\t\u0005\u0005\u000b\u001bi\u0004\u0002\u0007\u0004@\rM\u0012\u0011!A\u0001\u0006\u0003\u0011YIA\u0002`IYB\u0011ba\u0011,!\u0003\u0005\rAa&\u0002\u000f%\u001cX*\u001a:hK\"I1qI\u0016\u0011\u0002\u0003\u0007\u0011QI\u0001\u0007M&dG/\u001a:\u00029E,XM]=D_:4\u0017n\u001a\"z\u0019\u0006\u0014W\r\u001c\u0013eK\u001a\fW\u000f\u001c;%e\u0005a\u0012/^3ss\u000e{gNZ5h\u0005fd\u0015MY3mI\u0011,g-Y;mi\u0012\u001a\u0014\u0001G9vKJLH)\u001a4bk2$XI\\4j]\u0016\u001cuN\u001c4jOR!1QDB)\u0011\u001d\u0019\u0019F\fa\u0001\u0007+\nq\"\u001a8hS:,G+\u001f9f\u0019\u0006\u0014W\r\u001c\t\u0005\u0007/\u001aY&\u0004\u0002\u0004Z)!\u0011q\u001aB\u0005\u0013\u0011\u0019if!\u0017\u0003\u001f\u0015sw-\u001b8f)f\u0004X\rT1cK2\f\u0011#];fef<En\u001c2bY\u000e{gNZ5h)\u0011\u0019iba\u0019\t\u000f\tUq\u00061\u0001\u0002F\u0005Y\u0011/^3ss\u000e{gNZ5h)!\u0019ib!\u001b\u0004t\rU\u0004bBB6a\u0001\u00071QN\u0001\u0011kN,'o\u0011:fCR|'\u000fT1cK2\u0004Baa\u0016\u0004p%!1\u0011OB-\u0005A)6/\u001a:De\u0016\fGo\u001c:MC\n,G\u000eC\u0004\u0004TA\u0002\ra!\u0016\t\u000f\r\u001d\u0003\u00071\u0001\u0002F\u0005)\u0012/^3ss\u000e{gNZ5h/&$\bn\u00127pE\u0006dG\u0003CB\u000f\u0007w\u001aiha \t\u000f\r-\u0014\u00071\u0001\u0004n!911K\u0019A\u0002\rU\u0003bBB$c\u0001\u0007\u0011QI\u0001\u0007O\u0016$X*\u00199\u0015\u0011\t=8QQBE\u0007\u001bCqaa\"3\u0001\u0004\u0011y/A\u0002bY2Dqaa#3\u0001\u0004\u0011y/\u0001\u0003vg\u0016\u0014\b\"CB$eA\u0005\t\u0019AA#\u0003A9W\r^'ba\u0012\"WMZ1vYR$3\u0007K\u0002\u0001\u0007'\u0003Ba!&\u0004\u001c6\u00111q\u0013\u0006\u0004\u00073c\u0017AC:uKJ,w\u000e^=qK&!1QTBL\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class ConfigurationService
implements Logging {
    @Autowired
    private ConfigMapper configMapper;
    @Autowired
    private LabelMapper labelMapper;
    @Autowired
    private ValidatorManager validatorManager;
    @Autowired
    private ConfigKeyLimitForUserMapper configKeyLimitForUserMapper;
    private final CombinedLabelBuilder combinedLabelBuilder;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        ConfigurationService configurationService = this;
        synchronized (configurationService) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private ConfigMapper configMapper() {
        return this.configMapper;
    }

    private void configMapper_$eq(ConfigMapper x$1) {
        this.configMapper = x$1;
    }

    private LabelMapper labelMapper() {
        return this.labelMapper;
    }

    private void labelMapper_$eq(LabelMapper x$1) {
        this.labelMapper = x$1;
    }

    private ValidatorManager validatorManager() {
        return this.validatorManager;
    }

    private void validatorManager_$eq(ValidatorManager x$1) {
        this.validatorManager = x$1;
    }

    private ConfigKeyLimitForUserMapper configKeyLimitForUserMapper() {
        return this.configKeyLimitForUserMapper;
    }

    private void configKeyLimitForUserMapper_$eq(ConfigKeyLimitForUserMapper x$1) {
        this.configKeyLimitForUserMapper = x$1;
    }

    private CombinedLabelBuilder combinedLabelBuilder() {
        return this.combinedLabelBuilder;
    }

    @Transactional
    public void addKeyForEngine(String engineType, String version, ConfigKey key) {
        ArrayList<Label> labelList = LabelEntityParser.generateUserCreatorEngineTypeLabelList("*", "*", engineType, version);
        CombinedLabel combinedLabel = (CombinedLabel)this.combinedLabelBuilder().build("", labelList);
        ConfigLabel label = this.labelMapper().getLabelByKeyValue(combinedLabel.getLabelKey(), combinedLabel.getStringValue());
        List<Object> configs = new ArrayList();
        if (label != null && Predef$.MODULE$.Integer2int(label.getId()) > 0) {
            configs = this.configMapper().getConfigKeyValueByLabelId(label.getId());
        } else {
            ConfigLabel parsedLabel = LabelEntityParser.parseToConfigLabel(combinedLabel);
            this.labelMapper().insertLabel(parsedLabel);
            this.logger().info(new StringBuilder(24).append("succeed to create lable:").append(parsedLabel.getStringValue()).toString());
            label = parsedLabel;
        }
        boolean existsKey = ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(configs).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getKey(), Buffer$.MODULE$.canBuildFrom())).contains((Object)key.getKey());
        if (!existsKey) {
            this.configMapper().insertKey(key);
            this.logger().info(new StringBuilder(23).append("succeed to create key: ").append(key.getKey()).toString());
        } else {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(configs).asScala()).foreach((Function1 & Serializable & scala.Serializable)conf -> {
                ConfigurationService.$anonfun$addKeyForEngine$2(key, conf);
                return BoxedUnit.UNIT;
            });
        }
        List<ConfigKeyValue> existsConfigValue = this.configMapper().getConfigKeyValueByLabelId(label.getId());
        if (existsConfigValue == null) {
            ConfigValue configValue = new ConfigValue();
            configValue.setConfigKeyId(key.getId());
            configValue.setConfigValue("");
            configValue.setConfigLabelId(label.getId());
            this.configMapper().insertValue(configValue);
            this.logger().info(new StringBuilder(40).append("Succeed to  create relation: key:").append(key.getKey()).append(",label:").append(label.getStringValue()).toString());
            return;
        }
    }

    public Integer checkAndCreateUserLabel(List<ConfigKeyValue> settings, String username, String creator) {
        ObjectRef labelId = ObjectRef.create(null);
        if (!settings.isEmpty()) {
            ConfigKeyValue setting = settings.get(0);
            ConfigLabel configLabel = this.labelMapper().getLabelById(setting.getConfigLabelId());
            CombinedLabel combinedLabel = (CombinedLabel)this.combinedLabelBuilder().buildFromStringValue(configLabel.getLabelKey(), configLabel.getStringValue());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)combinedLabel.getValue()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ConfigurationService.$anonfun$checkAndCreateUserLabel$1(this, username, creator, combinedLabel, labelId, configLabel, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        if ((Integer)labelId.elem == null) {
            throw new ConfigurationException("create user label false, cannot save user configuration!(\u521b\u5efa\u7528\u6237label\u4fe1\u606f\u5931\u8d25\uff0c\u65e0\u6cd5\u4fdd\u5b58\u7528\u6237\u914d\u7f6e)");
        }
        return (Integer)labelId.elem;
    }

    public void updateUserValue(List<ConfigValue> createList, List<ConfigValue> updateList) {
        if (!CollectionUtils.isEmpty(createList)) {
            this.configMapper().insertValueList(createList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            this.configMapper().updateUserValueList(updateList);
            return;
        }
    }

    public void clearAMCacheConf(String username, String creator, String engine, String version) {
        Sender sender = Sender$.MODULE$.getSender((String)Configuration$.MODULE$.MANAGER_SPRING_NAME().getValue());
        if (StringUtils.isNotBlank((CharSequence)username)) {
            EngineTypeLabel engineTypeLabel;
            UserCreatorLabel userCreatorLabel = (UserCreatorLabel)LabelBuilderFactoryContext.getLabelBuilderFactory().createLabel(UserCreatorLabel.class);
            userCreatorLabel.setUser(username);
            userCreatorLabel.setCreator(creator);
            if (StringUtils.isNotBlank((CharSequence)engine) && StringUtils.isNotBlank((CharSequence)version)) {
                EngineTypeLabel label = EngineTypeLabelCreator.createEngineTypeLabel((String)engine);
                label.setVersion(version);
                engineTypeLabel = label;
            } else {
                engineTypeLabel = null;
            }
            EngineTypeLabel engineTypeLabel2 = engineTypeLabel;
            RemoveCacheConfRequest request = new RemoveCacheConfRequest(userCreatorLabel, engineTypeLabel2);
            this.logger().info(new StringBuilder(37).append("Broadcast cleanup message to manager ").append(request).toString());
            sender.ask((Object)request);
            return;
        }
    }

    public Object updateUserValue(ConfigKeyValue setting, Integer userLabelId, List<ConfigValue> createList, List<ConfigValue> updateList) {
        ConfigLabel configLabel = this.labelMapper().getLabelById(setting.getConfigLabelId());
        CombinedLabel combinedLabel = (CombinedLabel)this.combinedLabelBuilder().buildFromStringValue(configLabel.getLabelKey(), configLabel.getStringValue());
        ConfigKeyLimitVo templateConfigKeyVo = this.configKeyLimitForUserMapper().selectByLabelAndKeyId(combinedLabel.getStringValue(), setting.getId());
        Object object = templateConfigKeyVo != null && StringUtils.isNotBlank((CharSequence)templateConfigKeyVo.getMaxValue()) ? Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Integer maxValue = Integer.valueOf(templateConfigKeyVo.getMaxValue().replaceAll("[^0-9]", ""));
            Integer configValue = Integer.valueOf(setting.getConfigValue().replaceAll("[^0-9]", ""));
            if (Predef$.MODULE$.Integer2int(configValue) > Predef$.MODULE$.Integer2int(maxValue)) {
                throw new ConfigurationException(new StringBuilder(102).append("Parameter key:").append(setting.getKey()).append(",config value:").append(setting.getConfigValue()).append(" verification failed\uff0cexceeds the specified max value:").append(templateConfigKeyVo.getMaxValue()).append(":(\u53c2\u6570\u6821\u9a8c\u5931\u8d25\uff0c\u8d85\u8fc7\u6307\u5b9a\u7684\u6700\u5927\u503c):").append(setting.getValidateType()).append("--").append(setting.getValidateRange()).toString());
            }
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            ConfigurationService.$anonfun$updateUserValue$2(this, setting, x0$1);
            return BoxedUnit.UNIT;
        }) : BoxedUnit.UNIT;
        this.paramCheck(setting);
        if (Predef$.MODULE$.Boolean2boolean(setting.getIsUserDefined())) {
            ConfigValue configValue = new ConfigValue();
            if (StringUtils.isEmpty((CharSequence)setting.getConfigValue())) {
                configValue.setConfigValue("");
            } else {
                configValue.setConfigValue(setting.getConfigValue());
            }
            configValue.setId(setting.getValueId());
            return BoxesRunTime.boxToBoolean((boolean)updateList.add(configValue));
        }
        if (!StringUtils.isEmpty((CharSequence)setting.getConfigValue())) {
            ConfigValue configValue = new ConfigValue();
            configValue.setConfigKeyId(setting.getId());
            configValue.setConfigLabelId(userLabelId);
            configValue.setConfigValue(setting.getConfigValue());
            return BoxesRunTime.boxToBoolean((boolean)createList.add(configValue));
        }
        return BoxedUnit.UNIT;
    }

    public void paramCheck(ConfigKeyValue setting) {
        if (!StringUtils.isEmpty((CharSequence)setting.getConfigValue())) {
            ConfigKey key = null;
            if (setting.getId() != null) {
                key = this.configMapper().selectKeyByKeyID(setting.getId());
            } else {
                List<ConfigKey> keys = this.configMapper().selectKeyByKeyName(setting.getKey());
                if (keys != null && !keys.isEmpty()) {
                    key = keys.get(0);
                }
            }
            if (key == null) {
                throw new ConfigurationException("config key is null, please check again!(\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5key\u503c)");
            }
            this.logger().info(new StringBuilder(66).append("parameter ").append(key.getKey()).append(" value ").append(setting.getConfigValue()).append(" is not empty, enter checksum...(\u53c2\u6570").append(key.getKey()).append(" \u503c").append(setting.getConfigValue()).append("\u4e0d\u4e3a\u7a7a\uff0c\u8fdb\u5165\u6821\u9a8c...)").toString());
            if (!this.validatorManager().getOrCreateValidator(key.getValidateType()).validate(setting.getConfigValue(), key.getValidateRange())) {
                throw new ConfigurationException(new StringBuilder(44).append("Parameter verification failed(\u53c2\u6570\u6821\u9a8c\u5931\u8d25):").append(key.getKey()).append("--").append(key.getValidateType()).append("--").append(key.getValidateRange()).append("--").append(setting.getConfigValue()).toString());
            }
            return;
        }
    }

    public void paramCheckByKeyValue(String key, String value) {
        ConfigKeyValue setting = new ConfigKeyValue();
        setting.setKey(key);
        setting.setConfigValue(value);
        this.paramCheck(setting);
    }

    public String[] listAllEngineType() {
        String engineTypeString = (String)Configuration$.MODULE$.ENGINE_TYPE().getValue();
        String[] engineTypeList = engineTypeString.split(",");
        return engineTypeList;
    }

    public CombinedLabel generateCombinedLabel(String engineType, String version, String userName, String creator) {
        ArrayList<Label> labelList = LabelEntityParser.generateUserCreatorEngineTypeLabelList(userName, creator, engineType, version);
        Label combinedLabel = this.combinedLabelBuilder().build("", labelList);
        return (CombinedLabelImpl)combinedLabel;
    }

    public String generateCombinedLabel$default$1() {
        return "*";
    }

    public String generateCombinedLabel$default$3() {
        return "*";
    }

    public String generateCombinedLabel$default$4() {
        return "*";
    }

    public ArrayList<ConfigTree> buildTreeResult(List<ConfigKeyValue> configs, List<ConfigKeyValue> defaultConfigs) {
        ObjectRef resultConfigs = ObjectRef.create(new ArrayList());
        if (!defaultConfigs.isEmpty()) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(defaultConfigs).asScala()).foreach((Function1 & Serializable & scala.Serializable)defaultConfig -> {
                ConfigurationService.$anonfun$buildTreeResult$1(configs, defaultConfig);
                return BoxedUnit.UNIT;
            });
            resultConfigs.elem = defaultConfigs;
        }
        Buffer treeNames = (Buffer)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)resultConfigs.elem).asScala()).map((Function1 & Serializable & scala.Serializable)config -> config.getTreeName(), Buffer$.MODULE$.canBuildFrom())).distinct();
        ArrayList<ConfigTree> resultConfigsTree = new ArrayList<ConfigTree>(treeNames.length());
        resultConfigsTree.addAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)treeNames.map((Function1 & Serializable & scala.Serializable)treeName -> {
            ConfigTree configTree = new ConfigTree();
            configTree.setName((String)treeName);
            configTree.getSettings().addAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)resultConfigs$1.elem).asScala()).filter((Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean((boolean)ConfigurationService.$anonfun$buildTreeResult$5(treeName, config)))).toList()).asJava());
            return configTree;
        }, Buffer$.MODULE$.canBuildFrom())).toList()).asJava());
        return resultConfigsTree;
    }

    public List<ConfigKeyValue> buildTreeResult$default$2() {
        return new ArrayList<ConfigKeyValue>();
    }

    public void replaceCreatorToEngine(List<ConfigKeyValue> defaultCreatorConfigs, List<ConfigKeyValue> defaultEngineConfigs) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(defaultCreatorConfigs).asScala()).foreach((Function1 & Serializable & scala.Serializable)creatorConfig -> {
            if (creatorConfig.getKey() != null) {
                Option engineconfig = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(defaultEngineConfigs).asScala()).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ConfigurationService.$anonfun$replaceCreatorToEngine$2(creatorConfig, x$2)));
                if (engineconfig.isDefined()) {
                    ((ConfigKeyValue)engineconfig.get()).setDefaultValue(creatorConfig.getDefaultValue());
                    ((ConfigKeyValue)engineconfig.get()).setConfigValue(creatorConfig.getConfigValue());
                    return BoxedUnit.UNIT;
                }
                return BoxesRunTime.boxToBoolean((boolean)defaultEngineConfigs.add((ConfigKeyValue)creatorConfig));
            }
            return BoxedUnit.UNIT;
        });
    }

    public List<ConfigKeyValue> getConfigByLabelId(Integer labelId, String language) {
        List<Object> configs = new ArrayList();
        configs = "en".equals(language) ? this.configMapper().getConfigEnKeyValueByLabelId(labelId) : this.configMapper().getConfigKeyValueByLabelId(labelId);
        return configs;
    }

    public String getConfigByLabelId$default$2() {
        return "zh-CN";
    }

    public Tuple2<List<ConfigKeyValue>, List<ConfigKeyValue>> getConfigsByLabelList(List<Label<?>> labelList, boolean useDefaultConfig, String language) {
        LabelParameterParser$.MODULE$.labelCheck(labelList);
        CombinedLabelImpl combinedLabel = (CombinedLabelImpl)this.combinedLabelBuilder().build("", labelList);
        ConfigLabel label = this.labelMapper().getLabelByKeyValue(combinedLabel.getLabelKey(), combinedLabel.getStringValue());
        List<Object> configs = new ArrayList();
        if (label != null && Predef$.MODULE$.Integer2int(label.getId()) > 0) {
            configs = this.getConfigByLabelId(label.getId(), language);
        }
        ArrayList<ConfigKeyValue> defaultEngineConfigs = new ArrayList();
        ArrayList<ConfigKeyValue> defaultCreatorConfigs = new ArrayList();
        ArrayList<ConfigKeyValue> defaultUserConfigs = new ArrayList();
        if (useDefaultConfig) {
            ConfigLabel defaultEngineLabel;
            ConfigLabel defaultUserLabel;
            ConfigLabel defaultCreatorLabel = this.getConfByLabelList(LabelParameterParser$.MODULE$.changeUserToDefault(labelList, false, LabelParameterParser$.MODULE$.changeUserToDefault$default$3()));
            if (defaultCreatorLabel != null) {
                defaultCreatorConfigs = this.getConfigByLabelId(defaultCreatorLabel.getId(), language);
            }
            if ((defaultUserLabel = this.getConfByLabelList(LabelParameterParser$.MODULE$.changeUserToDefault(labelList, true, false))) != null) {
                defaultUserConfigs = this.getConfigByLabelId(defaultUserLabel.getId(), language);
            }
            if ((defaultEngineLabel = this.getConfByLabelList(LabelParameterParser$.MODULE$.changeUserToDefault(labelList, LabelParameterParser$.MODULE$.changeUserToDefault$default$2(), LabelParameterParser$.MODULE$.changeUserToDefault$default$3()))) != null) {
                defaultEngineConfigs = this.getConfigByLabelId(defaultEngineLabel.getId(), language);
            }
            if (CollectionUtils.isEmpty(defaultEngineConfigs)) {
                this.logger().warn("The default configuration is empty. Please check the default configuration information in the database table(\u9ed8\u8ba4\u914d\u7f6e\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u8868\u4e2d\u5173\u4e8e\u6807\u7b7e *-* \u7684\u9ed8\u8ba4\u914d\u7f6e\u4fe1\u606f\u662f\u5426\u5b8c\u6574)");
            }
            UserCreatorLabel userCreatorLabel = (UserCreatorLabel)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(labelList).asScala()).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ConfigurationService.$anonfun$getConfigsByLabelList$1(x$3))).get();
            if (Configuration$.MODULE$.USE_CREATOR_DEFAULE_VALUE()) {
                String string = userCreatorLabel.getCreator();
                String string2 = "*";
                if (string == null ? string2 != null : !string.equals(string2)) {
                    this.replaceCreatorToEngine(defaultCreatorConfigs, defaultEngineConfigs);
                }
            }
            if (Configuration$.MODULE$.USE_USER_DEFAULE_VALUE()) {
                String string = userCreatorLabel.getUser();
                String string3 = "*";
                if (string == null ? string3 != null : !string.equals(string3)) {
                    this.replaceCreatorToEngine(defaultUserConfigs, defaultEngineConfigs);
                }
            }
        }
        if (defaultEngineConfigs.size() > 0) {
            List keyIdList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(defaultEngineConfigs).asScala()).toStream().map((Function1 & Serializable & scala.Serializable)e -> e.getId(), Stream$.MODULE$.canBuildFrom())).toList()).asJava();
            List<ConfigKeyLimitVo> limitList = this.configKeyLimitForUserMapper().selectByLabelAndKeyIds(combinedLabel.getStringValue(), keyIdList);
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(defaultEngineConfigs).asScala()).foreach((Function1 & Serializable & scala.Serializable)entity -> {
                ConfigurationService.$anonfun$getConfigsByLabelList$3(limitList, entity);
                return BoxedUnit.UNIT;
            });
        } else {
            this.logger().warn(new StringBuilder(120).append("The configuration is empty. Please check the configuration information in the database table(\u914d\u7f6e\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u8868\u4e2d\u5173\u4e8e\u6807\u7b7e").append(combinedLabel.getStringValue()).append("\u7684\u914d\u7f6e\u4fe1\u606f\u662f\u5426\u5b8c\u6574)").toString());
        }
        return new Tuple2(configs, defaultEngineConfigs);
    }

    public boolean getConfigsByLabelList$default$2() {
        return true;
    }

    private ConfigLabel getConfByLabelList(List<Label<?>> labelList) {
        CombinedLabelImpl combinedLabel = (CombinedLabelImpl)this.combinedLabelBuilder().build("", labelList);
        return this.labelMapper().getLabelByKeyValue(combinedLabel.getLabelKey(), combinedLabel.getStringValue());
    }

    public ArrayList<ConfigTree> getFullTreeByLabelList(List<Label<?>> labelList, boolean useDefaultConfig, String language) {
        Tuple2<List<ConfigKeyValue>, List<ConfigKeyValue>> tuple2 = this.getConfigsByLabelList(labelList, useDefaultConfig, language);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List configs = (List)tuple2._1();
        List defaultEngineConfigs = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)configs, (Object)defaultEngineConfigs);
        List configs2 = (List)tuple22._1();
        List defaultEngineConfigs2 = (List)tuple22._2();
        return this.buildTreeResult(configs2, defaultEngineConfigs2);
    }

    public boolean getFullTreeByLabelList$default$2() {
        return true;
    }

    public ArrayList<ConfigTree> getConfigurationTemplateByLabelList(List<Label<?>> labelList, boolean useDefaultConfig) {
        Tuple2<List<ConfigKeyValue>, List<ConfigKeyValue>> tuple2 = this.getConfigsByLabelList(labelList, useDefaultConfig, null);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List configs = (List)tuple2._1();
        List defaultEngineConfigs = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)configs, (Object)defaultEngineConfigs);
        List configs2 = (List)tuple22._1();
        List defaultEngineConfigs2 = (List)tuple22._2();
        configs2 = Lists.newArrayList();
        return this.buildTreeResult(configs2, defaultEngineConfigs2);
    }

    public boolean getConfigurationTemplateByLabelList$default$2() {
        return true;
    }

    public Map<String, String> getConfigMapByLabels(List<Label<?>> labelList, boolean useDefaultConfig) {
        HashMap<String, String> configMap;
        block2: {
            Tuple2<List<ConfigKeyValue>, List<ConfigKeyValue>> tuple2 = this.getConfigsByLabelList(labelList, useDefaultConfig, null);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            List configs = (List)tuple2._1();
            List defaultEngineConfigs = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)configs, (Object)defaultEngineConfigs);
            List configs2 = (List)tuple22._1();
            List defaultEngineConfigs2 = (List)tuple22._2();
            configMap = new HashMap<String, String>();
            if (defaultEngineConfigs2 != null) {
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(defaultEngineConfigs2).asScala()).foreach((Function1 & Serializable & scala.Serializable)keyValue -> {
                    if (StringUtils.isNotBlank((CharSequence)keyValue.getKey()) && StringUtils.isNotEmpty((CharSequence)keyValue.getConfigValue())) {
                        return configMap.put(keyValue.getKey(), keyValue.getConfigValue());
                    }
                    return BoxedUnit.UNIT;
                });
            }
            if (configs2 == null) break block2;
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(configs2).asScala()).foreach((Function1 & Serializable & scala.Serializable)keyValue -> {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{keyValue.getKey()})) {
                    if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{keyValue.getConfigValue()})) {
                        return configMap.put(keyValue.getKey(), keyValue.getConfigValue());
                    }
                    return configMap.put(keyValue.getKey(), keyValue.getDefaultValue());
                }
                return BoxedUnit.UNIT;
            });
        }
        return configMap;
    }

    public boolean getConfigMapByLabels$default$2() {
        return true;
    }

    @Transactional
    public void persisteUservalue(List<ConfigKeyValue> configs, List<ConfigKeyValue> defaultConfigs, CombinedLabel combinedLabel, ConfigLabel existsLabel) {
        this.logger().info(new StringBuilder(82).append("Start checking the integrity of user configuration data(\u5f00\u59cb\u68c0\u67e5\u7528\u6237\u914d\u7f6e\u6570\u636e\u7684\u5b8c\u6574\u6027): label\u6807\u7b7e\u4e3a\uff1a").append(combinedLabel.getStringValue()).toString());
        Buffer userConfigList = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(configs).asScala();
        Buffer userConfigKeyIdList = (Buffer)userConfigList.map((Function1 & Serializable & scala.Serializable)config -> config.getId(), Buffer$.MODULE$.canBuildFrom());
        Buffer defaultConfigsList = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(defaultConfigs).asScala();
        ConfigLabel parsedLabel = LabelEntityParser.parseToConfigLabel(combinedLabel);
        if (existsLabel == null) {
            this.logger().info(new StringBuilder(68).append("start to create label for user(\u5f00\u59cb\u4e3a\u7528\u6237\u521b\u5efalabel)\uff1alabelKey:").append(parsedLabel.getLabelKey()).append(" , ").append("labelValue:").append(parsedLabel.getStringValue()).toString());
            this.labelMapper().insertLabel(parsedLabel);
            this.logger().info(new StringBuilder(26).append("Creation completed(\u521b\u5efa\u5b8c\u6210\uff01)\uff1a").append((Object)parsedLabel).toString());
        }
        defaultConfigsList.foreach((Function1 & Serializable & scala.Serializable)defaultConfig -> {
            ConfigurationService.$anonfun$persisteUservalue$2(this, userConfigKeyIdList, existsLabel, parsedLabel, defaultConfig);
            return BoxedUnit.UNIT;
        });
        this.logger().info(new StringBuilder(77).append("User configuration data integrity check completed!(\u7528\u6237\u914d\u7f6e\u6570\u636e\u5b8c\u6574\u6027\u68c0\u67e5\u5b8c\u6bd5\uff01): label\u6807\u7b7e\u4e3a\uff1a").append(combinedLabel.getStringValue()).toString());
    }

    public ResponseQueryConfig queryConfigByLabel(List<Label<?>> labelList, boolean isMerge, String filter) {
        LabelParameterParser$.MODULE$.labelCheck(labelList);
        Map<String, String> allGolbalUserConfig = this.getConfigMapByLabels(labelList, this.getConfigMapByLabels$default$2());
        List<Label<?>> defaultLabel = LabelParameterParser$.MODULE$.changeUserToDefault(labelList, LabelParameterParser$.MODULE$.changeUserToDefault$default$2(), LabelParameterParser$.MODULE$.changeUserToDefault$default$3());
        Map<String, String> allGolbalDefaultConfig = this.getConfigMapByLabels(defaultLabel, this.getConfigMapByLabels$default$2());
        ResponseQueryConfig config = new ResponseQueryConfig();
        config.setKeyAndValue(this.getMap(allGolbalDefaultConfig, allGolbalUserConfig, filter));
        return config;
    }

    public ResponseQueryConfig queryDefaultEngineConfig(EngineTypeLabel engineTypeLabel) {
        ArrayList<Label<?>> labelList = LabelEntityParser.generateUserCreatorEngineTypeLabelList("*", "*", engineTypeLabel.getEngineType(), engineTypeLabel.getVersion());
        return this.queryConfigByLabel(labelList, this.queryConfigByLabel$default$2(), this.queryConfigByLabel$default$3());
    }

    public ResponseQueryConfig queryGlobalConfig(String userName) {
        ArrayList<Label<?>> labelList = LabelEntityParser.generateUserCreatorEngineTypeLabelList(userName, "*", "*", "*");
        return this.queryConfigByLabel(labelList, this.queryConfigByLabel$default$2(), this.queryConfigByLabel$default$3());
    }

    public ResponseQueryConfig queryConfig(UserCreatorLabel userCreatorLabel, EngineTypeLabel engineTypeLabel, String filter) {
        ArrayList labelList = new ArrayList();
        labelList.add((Label<?>)userCreatorLabel);
        labelList.add((Label<?>)engineTypeLabel);
        return this.queryConfigByLabel(labelList, true, filter);
    }

    public boolean queryConfigByLabel$default$2() {
        return true;
    }

    public String queryConfigByLabel$default$3() {
        return null;
    }

    public ResponseQueryConfig queryConfigWithGlobal(UserCreatorLabel userCreatorLabel, EngineTypeLabel engineTypeLabel, String filter) {
        ResponseQueryConfig globalConfig = this.queryGlobalConfig(userCreatorLabel.getUser());
        ResponseQueryConfig engineConfig = this.queryConfig(userCreatorLabel, engineTypeLabel, filter);
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(globalConfig.getKeyAndValue()).asScala()).foreach((Function1 & Serializable & scala.Serializable)keyAndValue -> {
            if (!engineConfig.getKeyAndValue().containsKey(keyAndValue._1())) {
                return engineConfig.getKeyAndValue().put(keyAndValue._1(), keyAndValue._2());
            }
            return BoxedUnit.UNIT;
        });
        return engineConfig;
    }

    private Map<String, String> getMap(Map<String, String> all, Map<String, String> user, String filter) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (filter != null) {
            if (all != null) {
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(all).asScala()).foreach((Function1 & Serializable & scala.Serializable)keyValue -> {
                    if (((String)keyValue._1()).contains(filter)) {
                        return map.put((String)keyValue._1(), (String)keyValue._2());
                    }
                    return BoxedUnit.UNIT;
                });
            }
            if (user != null) {
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(user).asScala()).foreach((Function1 & Serializable & scala.Serializable)keyValue -> {
                    if (((String)keyValue._1()).contains(filter)) {
                        return map.put((String)keyValue._1(), (String)keyValue._2());
                    }
                    return BoxedUnit.UNIT;
                });
            }
        } else {
            map.putAll(all);
            map.putAll(user);
        }
        return map;
    }

    private String getMap$default$3() {
        return null;
    }

    public static final /* synthetic */ void $anonfun$addKeyForEngine$2(ConfigKey key$1, ConfigKeyValue conf) {
        if (conf.getKey().equals(key$1.getKey())) {
            key$1.setId(conf.getId());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$checkAndCreateUserLabel$1(ConfigurationService $this, String username$1, String creator$1, CombinedLabel combinedLabel$1, ObjectRef labelId$1, ConfigLabel configLabel$1, Label x0$1) {
        Label label = x0$1;
        if (label instanceof UserCreatorLabel) {
            UserCreatorLabel userCreatorLabel = (UserCreatorLabel)label;
            if (userCreatorLabel.getUser().equals("*")) {
                userCreatorLabel.setUser(username$1);
                userCreatorLabel.setCreator(creator$1);
                ConfigLabel parsedLabel = LabelEntityParser.parseToConfigLabel(combinedLabel$1);
                ConfigLabel userLabel = $this.labelMapper().getLabelByKeyValue(parsedLabel.getLabelKey(), parsedLabel.getStringValue());
                if (userLabel == null) {
                    $this.labelMapper().insertLabel(parsedLabel);
                    labelId$1.elem = parsedLabel.getId();
                    return;
                }
                labelId$1.elem = userLabel.getId();
                return;
            }
            labelId$1.elem = configLabel$1.getId();
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateUserValue$2(ConfigurationService $this, ConfigKeyValue setting$1, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            if (exception instanceof ConfigurationException) {
                throw exception;
            }
            $this.logger().warn(new StringBuilder(60).append("Failed to check special limit setting for key:").append(setting$1.getKey()).append(",config value:").append(setting$1.getConfigValue()).toString());
            return;
        }
        throw new MatchError((Object)throwable);
    }

    public static final /* synthetic */ void $anonfun$buildTreeResult$2(ConfigKeyValue defaultConfig$1, ConfigKeyValue config) {
        if (config.getKey() != null && config.getKey().equals(defaultConfig$1.getKey())) {
            defaultConfig$1.setConfigValue(config.getConfigValue());
            defaultConfig$1.setConfigLabelId(config.getConfigLabelId());
            defaultConfig$1.setValueId(config.getValueId());
            defaultConfig$1.setIsUserDefined(Predef$.MODULE$.boolean2Boolean(true));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$buildTreeResult$1(List configs$1, ConfigKeyValue defaultConfig) {
        defaultConfig.setIsUserDefined(Predef$.MODULE$.boolean2Boolean(false));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(configs$1).asScala()).foreach((Function1 & Serializable & scala.Serializable)config -> {
            ConfigurationService.$anonfun$buildTreeResult$2(defaultConfig, config);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$buildTreeResult$5(String treeName$1, ConfigKeyValue config) {
        return config.getTreeName().equals(treeName$1);
    }

    public static final /* synthetic */ boolean $anonfun$replaceCreatorToEngine$2(ConfigKeyValue creatorConfig$1, ConfigKeyValue x$2) {
        return x$2.getKey().equals(creatorConfig$1.getKey());
    }

    public static final /* synthetic */ boolean $anonfun$getConfigsByLabelList$1(Label x$3) {
        return x$3 instanceof UserCreatorLabel;
    }

    public static final /* synthetic */ boolean $anonfun$getConfigsByLabelList$4(Long keyId$1, ConfigKeyLimitVo v) {
        Long l = v.getKeyId();
        Long l2 = keyId$1;
        return !(l != null ? !((Object)l).equals(l2) : l2 != null);
    }

    public static final /* synthetic */ void $anonfun$getConfigsByLabelList$3(List limitList$1, ConfigKeyValue entity) {
        Long keyId = entity.getId();
        List res = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(limitList$1).asScala()).filter((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)ConfigurationService.$anonfun$getConfigsByLabelList$4(keyId, v)))).toList()).asJava();
        if (res.size() > 0) {
            HashMap<String, String> specialMap = new HashMap<String, String>();
            String maxValue = ((ConfigKeyLimitVo)res.get(0)).getMaxValue();
            if (StringUtils.isNotBlank((CharSequence)maxValue)) {
                specialMap.put("maxValue", maxValue);
                entity.setSpecialLimit(specialMap);
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$persisteUservalue$2(ConfigurationService $this, Buffer userConfigKeyIdList$1, ConfigLabel existsLabel$1, ConfigLabel parsedLabel$1, ConfigKeyValue defaultConfig) {
        if (!userConfigKeyIdList$1.contains((Object)defaultConfig.getId())) {
            $this.logger().info(new StringBuilder(82).append("Initialize database configuration information for users(\u4e3a\u7528\u6237\u521d\u59cb\u5316\u6570\u636e\u5e93\u914d\u7f6e\u4fe1\u606f)\uff1a").append("configKey: ").append(defaultConfig.getKey()).toString());
            ConfigValue configValue = new ConfigValue();
            configValue.setConfigKeyId(defaultConfig.getId());
            if (existsLabel$1 == null) {
                configValue.setConfigLabelId(parsedLabel$1.getId());
            } else {
                configValue.setConfigLabelId(existsLabel$1.getId());
            }
            configValue.setConfigValue("");
            $this.configMapper().insertValue(configValue);
            $this.logger().info(new StringBuilder(95).append("Initialization of user database configuration information completed(\u521d\u59cb\u5316\u7528\u6237\u6570\u636e\u5e93\u914d\u7f6e\u4fe1\u606f\u5b8c\u6210)\uff1aconfigKey: ").append(defaultConfig.getKey()).toString());
            return;
        }
    }

    public ConfigurationService() {
        Logging.$init$((Logging)this);
        this.combinedLabelBuilder = new CombinedLabelBuilder();
    }
}

