/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.orchestrator.computation.service;

import java.io.Serializable;
import javax.annotation.PostConstruct;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.listener.Event;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.governance.common.entity.ExecutionNodeStatus;
import org.apache.linkis.governance.common.protocol.task.ResponseTaskError;
import org.apache.linkis.governance.common.protocol.task.ResponseTaskLog;
import org.apache.linkis.governance.common.protocol.task.ResponseTaskResultSet;
import org.apache.linkis.governance.common.protocol.task.ResponseTaskResultSize;
import org.apache.linkis.governance.common.protocol.task.ResponseTaskStatus;
import org.apache.linkis.manager.common.protocol.resource.ResponseTaskRunningInfo;
import org.apache.linkis.orchestrator.computation.conf.ComputationOrchestratorConf$;
import org.apache.linkis.orchestrator.computation.execute.CodeExecTaskExecutor;
import org.apache.linkis.orchestrator.computation.execute.CodeExecTaskExecutorManager;
import org.apache.linkis.orchestrator.computation.execute.CodeExecTaskExecutorManager$;
import org.apache.linkis.orchestrator.computation.monitor.EngineConnMonitor$;
import org.apache.linkis.orchestrator.core.ResultSet;
import org.apache.linkis.orchestrator.ecm.service.TaskExecutionReceiver;
import org.apache.linkis.orchestrator.listener.task.TaskErrorResponseEvent;
import org.apache.linkis.orchestrator.listener.task.TaskLogEvent;
import org.apache.linkis.orchestrator.listener.task.TaskResultSetEvent;
import org.apache.linkis.orchestrator.listener.task.TaskResultSetSizeEvent;
import org.apache.linkis.orchestrator.listener.task.TaskRunningInfoEvent;
import org.apache.linkis.orchestrator.listener.task.TaskStatusEvent;
import org.apache.linkis.orchestrator.utils.OrchestratorLoggerUtils$;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.message.annotation.Receiver;
import org.apache.linkis.rpc.utils.RPCUtils$;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;

@Service
@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\u0006\r\u0001eAQa\f\u0001\u0005\u0002ABqa\r\u0001C\u0002\u0013%A\u0007\u0003\u0004<\u0001\u0001\u0006I!\u000e\u0005\u0006y\u0001!I!\u0010\u0005\u0006\u0015\u0002!\te\u0013\u0005\u0006S\u0002!\tE\u001b\u0005\u0006s\u0002!\tE\u001f\u0005\b\u0003\u000b\u0001A\u0011IA\u0004\u0011\u001d\t9\u0002\u0001C!\u00033Aq!!\u000b\u0001\t\u0003\nYC\u0001\u0011D_6\u0004X\u000f^1uS>tG+Y:l\u000bb,7-\u001e;j_:\u0014VmY3jm\u0016\u0014(BA\u0007\u000f\u0003\u001d\u0019XM\u001d<jG\u0016T!a\u0004\t\u0002\u0017\r|W\u000e];uCRLwN\u001c\u0006\u0003#I\tAb\u001c:dQ\u0016\u001cHO]1u_JT!a\u0005\u000b\u0002\r1Lgn[5t\u0015\t)b#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002/\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0007\u0011(!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0019\te.\u001f*fMB\u0011\u0011%J\u0007\u0002E)\u0011Qb\t\u0006\u0003IA\t1!Z2n\u0013\t1#EA\u000bUCN\\W\t_3dkRLwN\u001c*fG\u0016Lg/\u001a:\u0011\u0005!jS\"A\u0015\u000b\u0005)Z\u0013!B;uS2\u001c(B\u0001\u0017\u0013\u0003\u0019\u0019w.\\7p]&\u0011a&\u000b\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0007\u0005\u00023\u00015\tA\"A\u000ed_\u0012,W\t_3d)\u0006\u001c8.\u0012=fGV$xN]'b]\u0006<WM]\u000b\u0002kA\u0011a'O\u0007\u0002o)\u0011\u0001HD\u0001\bKb,7-\u001e;f\u0013\tQtGA\u000eD_\u0012,W\t_3d)\u0006\u001c8.\u0012=fGV$xN]'b]\u0006<WM]\u0001\u001dG>$W-\u0012=fGR\u000b7o[#yK\u000e,Ho\u001c:NC:\fw-\u001a:!\u0003\u0011Ig.\u001b;\u0015\u0003y\u0002\"aG \n\u0005\u0001c\"\u0001B+oSRD#\u0001\u0002\"\u0011\u0005\rCU\"\u0001#\u000b\u0005\u00153\u0015AC1o]>$\u0018\r^5p]*\tq)A\u0003kCZ\f\u00070\u0003\u0002J\t\ni\u0001k\\:u\u0007>t7\u000f\u001e:vGR\fq\u0002^1tW2{wMU3dK&4XM\u001d\u000b\u0004}1K\u0006\"B'\u0006\u0001\u0004q\u0015a\u0002;bg.dun\u001a\t\u0003\u001f^k\u0011\u0001\u0015\u0006\u0003#J\u000bA\u0001^1tW*\u00111\u000bV\u0001\taJ|Go\\2pY*\u0011A&\u0016\u0006\u0003-J\t!bZ8wKJt\u0017M\\2f\u0013\tA\u0006KA\bSKN\u0004xN\\:f)\u0006\u001c8\u000eT8h\u0011\u0015QV\u00011\u0001\\\u0003\u0019\u0019XM\u001c3feB\u0011AlX\u0007\u0002;*\u0011aLE\u0001\u0004eB\u001c\u0017B\u00011^\u0005\u0019\u0019VM\u001c3fe\"\u0012QA\u0019\t\u0003G\u001el\u0011\u0001\u001a\u0006\u0003\u000b\u0016T!AZ/\u0002\u000f5,7o]1hK&\u0011\u0001\u000e\u001a\u0002\t%\u0016\u001cW-\u001b<fe\u0006!B/Y:l!J|wM]3tgJ+7-Z5wKJ$2AP6x\u0011\u0015ag\u00011\u0001n\u0003a!\u0018m]6Qe><'/Z:t/&$\bNU3t_V\u00148-\u001a\t\u0003]Vl\u0011a\u001c\u0006\u0003aF\f\u0001B]3t_V\u00148-\u001a\u0006\u0003'JT!\u0001L:\u000b\u0005Q\u0014\u0012aB7b]\u0006<WM]\u0005\u0003m>\u0014qCU3ta>t7/\u001a+bg.\u0014VO\u001c8j]\u001eLeNZ8\t\u000bi3\u0001\u0019A.)\u0005\u0019\u0011\u0017A\u0005;bg.\u001cF/\u0019;vgJ+7-Z5wKJ$BAP>\u0002\u0002!)Ap\u0002a\u0001{\u0006QA/Y:l'R\fG/^:\u0011\u0005=s\u0018BA@Q\u0005I\u0011Vm\u001d9p]N,G+Y:l'R\fG/^:\t\u000bi;\u0001\u0019A.)\u0005\u001d\u0011\u0017A\u0006;bg.\u0014Vm];miNK'0\u001a*fG\u0016Lg/\u001a:\u0015\u000by\nI!a\u0005\t\u000f\u0005-\u0001\u00021\u0001\u0002\u000e\u0005qA/Y:l%\u0016\u001cX\u000f\u001c;TSj,\u0007cA(\u0002\u0010%\u0019\u0011\u0011\u0003)\u0003-I+7\u000f]8og\u0016$\u0016m]6SKN,H\u000e^*ju\u0016DQA\u0017\u0005A\u0002mC#\u0001\u00032\u0002+Q\f7o\u001b*fgVdGoU3u%\u0016\u001cW-\u001b<feR)a(a\u0007\u0002&!9\u0011QD\u0005A\u0002\u0005}\u0011!\u0004;bg.\u0014Vm];miN+G\u000fE\u0002P\u0003CI1!a\tQ\u0005U\u0011Vm\u001d9p]N,G+Y:l%\u0016\u001cX\u000f\u001c;TKRDQAW\u0005A\u0002mC#!\u00032\u0002#Q\f7o[#se>\u0014(+Z2fSZ,'\u000fF\u0003?\u0003[\t9\u0004C\u0004\u00020)\u0001\r!!\r\u0002#I,7\u000f]8og\u0016$\u0016m]6FeJ|'\u000fE\u0002P\u0003gI1!!\u000eQ\u0005E\u0011Vm\u001d9p]N,G+Y:l\u000bJ\u0014xN\u001d\u0005\u00065*\u0001\ra\u0017\u0015\u0003\u0015\tD3\u0001AA\u001f!\u0011\ty$!\u0013\u000e\u0005\u0005\u0005#\u0002BA\"\u0003\u000b\n!b\u001d;fe\u0016|G/\u001f9f\u0015\r\t9EF\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW&!\u00111JA!\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class ComputationTaskExecutionReceiver
implements TaskExecutionReceiver,
Logging {
    private final CodeExecTaskExecutorManager codeExecTaskExecutorManager;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        ComputationTaskExecutionReceiver computationTaskExecutionReceiver = this;
        synchronized (computationTaskExecutionReceiver) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private CodeExecTaskExecutorManager codeExecTaskExecutorManager() {
        return this.codeExecTaskExecutorManager;
    }

    @PostConstruct
    private void init() {
        EngineConnMonitor$.MODULE$.addEngineExecutorStatusMonitor(this.codeExecTaskExecutorManager().getAllInstanceToExecutorCache());
    }

    @Override
    @Receiver
    public void taskLogReceiver(ResponseTaskLog taskLog, Sender sender) {
        ServiceInstance serviceInstance = RPCUtils$.MODULE$.getServiceInstanceFromSender(sender);
        this.codeExecTaskExecutorManager().getByEngineConnAndTaskId(serviceInstance, taskLog.execId()).foreach((Function1 & Serializable & scala.Serializable)codeExecutor -> {
            ComputationTaskExecutionReceiver.$anonfun$taskLogReceiver$1(taskLog, codeExecutor);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    @Receiver
    public void taskProgressReceiver(ResponseTaskRunningInfo taskProgressWithResource, Sender sender) {
        ServiceInstance serviceInstance = RPCUtils$.MODULE$.getServiceInstanceFromSender(sender);
        this.codeExecTaskExecutorManager().getByEngineConnAndTaskId(serviceInstance, taskProgressWithResource.execId()).foreach((Function1 & Serializable & scala.Serializable)codeExecutor -> {
            ComputationTaskExecutionReceiver.$anonfun$taskProgressReceiver$1(taskProgressWithResource, codeExecutor);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    @Receiver
    public void taskStatusReceiver(ResponseTaskStatus taskStatus, Sender sender) {
        ServiceInstance serviceInstance = RPCUtils$.MODULE$.getServiceInstanceFromSender(sender);
        if (!this.postStatus$1(serviceInstance, taskStatus) && ExecutionNodeStatus.isCompleted((ExecutionNodeStatus)taskStatus.status())) {
            this.logger().warn(new StringBuilder(45).append(" from ").append(serviceInstance).append(" received ").append(taskStatus).append(" cannot find execTask to deal").toString());
            Thread.sleep(ComputationOrchestratorConf$.MODULE$.TASK_STATUS_COMPLETE_WAIT_TIMEOUT());
            if (!this.postStatus$1(serviceInstance, taskStatus)) {
                this.logger().warn(new StringBuilder(63).append(" from ").append(serviceInstance).append(" received ").append(taskStatus).append(" cannot find execTask to deal, by retry 2 times").toString());
            }
        }
        OrchestratorLoggerUtils$.MODULE$.removeJobIdMDC();
    }

    @Override
    @Receiver
    public void taskResultSizeReceiver(ResponseTaskResultSize taskResultSize, Sender sender) {
        ServiceInstance serviceInstance = RPCUtils$.MODULE$.getServiceInstanceFromSender(sender);
        BooleanRef isExist = BooleanRef.create((boolean)false);
        this.codeExecTaskExecutorManager().getByEngineConnAndTaskId(serviceInstance, taskResultSize.execId()).foreach((Function1 & Serializable & scala.Serializable)codeExecutor -> {
            ComputationTaskExecutionReceiver.$anonfun$taskResultSizeReceiver$1(this, taskResultSize, isExist, codeExecutor);
            return BoxedUnit.UNIT;
        });
        if (!isExist.elem) {
            this.logger().warn(new StringBuilder(44).append("from ").append(serviceInstance).append(" received ").append(taskResultSize).append(" cannot find execTask to deal").toString());
        }
        OrchestratorLoggerUtils$.MODULE$.removeJobIdMDC();
    }

    @Override
    @Receiver
    public void taskResultSetReceiver(ResponseTaskResultSet taskResultSet, Sender sender) {
        ServiceInstance serviceInstance = RPCUtils$.MODULE$.getServiceInstanceFromSender(sender);
        BooleanRef isExist = BooleanRef.create((boolean)false);
        this.codeExecTaskExecutorManager().getByEngineConnAndTaskId(serviceInstance, taskResultSet.execId()).foreach((Function1 & Serializable & scala.Serializable)codeExecutor -> {
            ComputationTaskExecutionReceiver.$anonfun$taskResultSetReceiver$1(this, taskResultSet, isExist, codeExecutor);
            return BoxedUnit.UNIT;
        });
        if (!isExist.elem) {
            this.logger().warn(new StringBuilder(44).append("from ").append(serviceInstance).append(" received ").append(taskResultSet).append(" cannot find execTask to deal").toString());
        }
        OrchestratorLoggerUtils$.MODULE$.removeJobIdMDC();
    }

    @Override
    @Receiver
    public void taskErrorReceiver(ResponseTaskError responseTaskError, Sender sender) {
        BooleanRef isExist = BooleanRef.create((boolean)false);
        ServiceInstance serviceInstance = RPCUtils$.MODULE$.getServiceInstanceFromSender(sender);
        this.codeExecTaskExecutorManager().getByEngineConnAndTaskId(serviceInstance, responseTaskError.execId()).foreach((Function1 & Serializable & scala.Serializable)codeExecutor -> {
            ComputationTaskExecutionReceiver.$anonfun$taskErrorReceiver$1(this, responseTaskError, isExist, codeExecutor);
            return BoxedUnit.UNIT;
        });
        if (!isExist.elem) {
            this.logger().warn(new StringBuilder(44).append("from ").append(serviceInstance).append(" received ").append(responseTaskError).append(" cannot find execTask to deal").toString());
        }
        OrchestratorLoggerUtils$.MODULE$.removeJobIdMDC();
    }

    public static final /* synthetic */ void $anonfun$taskLogReceiver$1(ResponseTaskLog taskLog$1, CodeExecTaskExecutor codeExecutor) {
        TaskLogEvent event = new TaskLogEvent(codeExecutor.getExecTask(), taskLog$1.log());
        codeExecutor.getExecTask().getPhysicalContext().pushLog(event);
        codeExecutor.getEngineConnExecutor().updateLastUpdateTime();
    }

    public static final /* synthetic */ void $anonfun$taskProgressReceiver$1(ResponseTaskRunningInfo taskProgressWithResource$1, CodeExecTaskExecutor codeExecutor) {
        TaskRunningInfoEvent event = new TaskRunningInfoEvent(codeExecutor.getExecTask(), taskProgressWithResource$1.progress(), taskProgressWithResource$1.progressInfo(), taskProgressWithResource$1.resourceMap(), taskProgressWithResource$1.extraInfoMap());
        codeExecutor.getExecTask().getPhysicalContext().pushProgress(event);
        codeExecutor.getEngineConnExecutor().updateLastUpdateTime();
    }

    public static final /* synthetic */ void $anonfun$taskStatusReceiver$1(ComputationTaskExecutionReceiver $this, ResponseTaskStatus taskStatus$1, BooleanRef isExist$1, CodeExecTaskExecutor codeExecutor) {
        OrchestratorLoggerUtils$.MODULE$.setJobIdMDC(codeExecutor.getExecTask());
        TaskStatusEvent event = new TaskStatusEvent(codeExecutor.getExecTask(), taskStatus$1.status());
        $this.logger().info(new StringBuilder(69).append("From engineConn receive status info:").append(taskStatus$1).append(", now post to listenerBus event: ").append(event).toString());
        codeExecutor.getExecTask().getPhysicalContext().broadcastSyncEvent((Event)event);
        codeExecutor.getEngineConnExecutor().updateLastUpdateTime();
        isExist$1.elem = true;
    }

    private final boolean postStatus$1(ServiceInstance serviceInstance$1, ResponseTaskStatus taskStatus$1) {
        BooleanRef isExist = BooleanRef.create((boolean)false);
        this.codeExecTaskExecutorManager().getByEngineConnAndTaskId(serviceInstance$1, taskStatus$1.execId()).foreach((Function1 & Serializable & scala.Serializable)codeExecutor -> {
            ComputationTaskExecutionReceiver.$anonfun$taskStatusReceiver$1(this, taskStatus$1, isExist, codeExecutor);
            return BoxedUnit.UNIT;
        });
        return isExist.elem;
    }

    public static final /* synthetic */ void $anonfun$taskResultSizeReceiver$1(ComputationTaskExecutionReceiver $this, ResponseTaskResultSize taskResultSize$1, BooleanRef isExist$2, CodeExecTaskExecutor codeExecutor) {
        OrchestratorLoggerUtils$.MODULE$.setJobIdMDC(codeExecutor.getExecTask());
        TaskResultSetSizeEvent event = new TaskResultSetSizeEvent(codeExecutor.getExecTask(), taskResultSize$1.resultSize());
        $this.logger().info(new StringBuilder(76).append("From engineConn receive resultSet size info").append(taskResultSize$1).append(", now post to listenerBus event: ").append(event).toString());
        codeExecutor.getExecTask().getPhysicalContext().broadcastSyncEvent((Event)event);
        codeExecutor.getEngineConnExecutor().updateLastUpdateTime();
        isExist$2.elem = true;
    }

    public static final /* synthetic */ void $anonfun$taskResultSetReceiver$1(ComputationTaskExecutionReceiver $this, ResponseTaskResultSet taskResultSet$1, BooleanRef isExist$3, CodeExecTaskExecutor codeExecutor) {
        OrchestratorLoggerUtils$.MODULE$.setJobIdMDC(codeExecutor.getExecTask());
        TaskResultSetEvent event = new TaskResultSetEvent(codeExecutor.getExecTask(), new ResultSet(taskResultSet$1.output(), taskResultSet$1.alias()));
        $this.logger().info(new StringBuilder(74).append("From engineConn receive resultSet  info ").append(taskResultSet$1).append(" , now post to listenerBus event: ").append(event).toString());
        codeExecutor.getExecTask().getPhysicalContext().broadcastSyncEvent((Event)event);
        codeExecutor.getEngineConnExecutor().updateLastUpdateTime();
        isExist$3.elem = true;
    }

    public static final /* synthetic */ void $anonfun$taskErrorReceiver$1(ComputationTaskExecutionReceiver $this, ResponseTaskError responseTaskError$1, BooleanRef isExist$4, CodeExecTaskExecutor codeExecutor) {
        OrchestratorLoggerUtils$.MODULE$.setJobIdMDC(codeExecutor.getExecTask());
        TaskErrorResponseEvent event = new TaskErrorResponseEvent(codeExecutor.getExecTask(), responseTaskError$1.errorMsg());
        $this.logger().info(new StringBuilder(80).append("From engineConn receive responseTaskError  info").append(responseTaskError$1.execId()).append(", now post to listenerBus event: ").append(event.execTask().getIDInfo()).toString());
        codeExecutor.getExecTask().getPhysicalContext().broadcastSyncEvent((Event)event);
        codeExecutor.getEngineConnExecutor().updateLastUpdateTime();
        isExist$4.elem = true;
    }

    public ComputationTaskExecutionReceiver() {
        Logging.$init$((Logging)this);
        this.codeExecTaskExecutorManager = CodeExecTaskExecutorManager$.MODULE$.getCodeExecTaskExecutorManager();
    }
}

