/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.storage.conf.LinkisStorageConf$;
import org.apache.linkis.storage.domain.ArrayType$;
import org.apache.linkis.storage.domain.BigIntType$;
import org.apache.linkis.storage.domain.BinaryType$;
import org.apache.linkis.storage.domain.BooleanType$;
import org.apache.linkis.storage.domain.CharType$;
import org.apache.linkis.storage.domain.DataType;
import org.apache.linkis.storage.domain.DateType$;
import org.apache.linkis.storage.domain.DecimalType$;
import org.apache.linkis.storage.domain.Dolphin$;
import org.apache.linkis.storage.domain.DoubleType$;
import org.apache.linkis.storage.domain.FloatType$;
import org.apache.linkis.storage.domain.IntType$;
import org.apache.linkis.storage.domain.ListType$;
import org.apache.linkis.storage.domain.LongType$;
import org.apache.linkis.storage.domain.MapType$;
import org.apache.linkis.storage.domain.NullType$;
import org.apache.linkis.storage.domain.ShortIntType$;
import org.apache.linkis.storage.domain.StringType$;
import org.apache.linkis.storage.domain.StructType$;
import org.apache.linkis.storage.domain.TimestampType$;
import org.apache.linkis.storage.domain.VarcharType$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;
import scala.util.matching.UnanchoredRegex;

public final class DataType$
implements Logging {
    public static DataType$ MODULE$;
    private final String LOWCASE_NULL_VALUE;
    private final UnanchoredRegex DECIMAL_REGEX;
    private final UnanchoredRegex SHORT_REGEX;
    private final UnanchoredRegex INT_REGEX;
    private final UnanchoredRegex LONG_REGEX;
    private final UnanchoredRegex BIGINT_REGEX;
    private final UnanchoredRegex FLOAT_REGEX;
    private final UnanchoredRegex DOUBLE_REGEX;
    private final UnanchoredRegex VARCHAR_REGEX;
    private final UnanchoredRegex CHAR_REGEX;
    private final UnanchoredRegex ARRAY_REGEX;
    private final UnanchoredRegex MAP_REGEX;
    private final UnanchoredRegex LIST_REGEX;
    private final UnanchoredRegex STRUCT_REGEX;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new DataType$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        DataType$ dataType$ = this;
        synchronized (dataType$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String LOWCASE_NULL_VALUE() {
        return this.LOWCASE_NULL_VALUE;
    }

    public UnanchoredRegex DECIMAL_REGEX() {
        return this.DECIMAL_REGEX;
    }

    public UnanchoredRegex SHORT_REGEX() {
        return this.SHORT_REGEX;
    }

    public UnanchoredRegex INT_REGEX() {
        return this.INT_REGEX;
    }

    public UnanchoredRegex LONG_REGEX() {
        return this.LONG_REGEX;
    }

    public UnanchoredRegex BIGINT_REGEX() {
        return this.BIGINT_REGEX;
    }

    public UnanchoredRegex FLOAT_REGEX() {
        return this.FLOAT_REGEX;
    }

    public UnanchoredRegex DOUBLE_REGEX() {
        return this.DOUBLE_REGEX;
    }

    public UnanchoredRegex VARCHAR_REGEX() {
        return this.VARCHAR_REGEX;
    }

    public UnanchoredRegex CHAR_REGEX() {
        return this.CHAR_REGEX;
    }

    public UnanchoredRegex ARRAY_REGEX() {
        return this.ARRAY_REGEX;
    }

    public UnanchoredRegex MAP_REGEX() {
        return this.MAP_REGEX;
    }

    public UnanchoredRegex LIST_REGEX() {
        return this.LIST_REGEX;
    }

    public UnanchoredRegex STRUCT_REGEX() {
        return this.STRUCT_REGEX;
    }

    public DataType toDataType(String dataType) {
        Option option;
        String string = dataType;
        if ("void".equals(string) ? true : "null".equals(string)) {
            return NullType$.MODULE$;
        }
        if ("string".equals(string)) {
            return StringType$.MODULE$;
        }
        if ("boolean".equals(string)) {
            return BooleanType$.MODULE$;
        }
        Option option2 = ((Regex)this.SHORT_REGEX()).unapplySeq((CharSequence)string);
        if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(0) == 0) {
            return ShortIntType$.MODULE$;
        }
        Option option3 = ((Regex)this.LONG_REGEX()).unapplySeq((CharSequence)string);
        if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(0) == 0) {
            return LongType$.MODULE$;
        }
        Option option4 = ((Regex)this.BIGINT_REGEX()).unapplySeq((CharSequence)string);
        if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(0) == 0) {
            return BigIntType$.MODULE$;
        }
        Option option5 = ((Regex)this.INT_REGEX()).unapplySeq((CharSequence)string);
        if (!option5.isEmpty() && option5.get() != null && ((LinearSeqOptimized)option5.get()).lengthCompare(0) == 0 ? true : ("integer".equals(string) ? true : "smallint".equals(string))) {
            return IntType$.MODULE$;
        }
        Option option6 = ((Regex)this.FLOAT_REGEX()).unapplySeq((CharSequence)string);
        if (!option6.isEmpty() && option6.get() != null && ((LinearSeqOptimized)option6.get()).lengthCompare(0) == 0) {
            return FloatType$.MODULE$;
        }
        Option option7 = ((Regex)this.DOUBLE_REGEX()).unapplySeq((CharSequence)string);
        if (!option7.isEmpty() && option7.get() != null && ((LinearSeqOptimized)option7.get()).lengthCompare(0) == 0) {
            return DoubleType$.MODULE$;
        }
        Option option8 = ((Regex)this.VARCHAR_REGEX()).unapplySeq((CharSequence)string);
        if (!option8.isEmpty() && option8.get() != null && ((LinearSeqOptimized)option8.get()).lengthCompare(0) == 0) {
            return VarcharType$.MODULE$;
        }
        Option option9 = ((Regex)this.CHAR_REGEX()).unapplySeq((CharSequence)string);
        if (!option9.isEmpty() && option9.get() != null && ((LinearSeqOptimized)option9.get()).lengthCompare(0) == 0) {
            return CharType$.MODULE$;
        }
        if ("date".equals(string)) {
            return DateType$.MODULE$;
        }
        if ("timestamp".equals(string)) {
            return TimestampType$.MODULE$;
        }
        if ("binary".equals(string)) {
            return BinaryType$.MODULE$;
        }
        if ("decimal".equals(string) ? true : !(option = ((Regex)this.DECIMAL_REGEX()).unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(0) == 0) {
            return DecimalType$.MODULE$;
        }
        Option option10 = ((Regex)this.ARRAY_REGEX()).unapplySeq((CharSequence)string);
        if (!option10.isEmpty() && option10.get() != null && ((LinearSeqOptimized)option10.get()).lengthCompare(0) == 0) {
            return ArrayType$.MODULE$;
        }
        Option option11 = ((Regex)this.MAP_REGEX()).unapplySeq((CharSequence)string);
        if (!option11.isEmpty() && option11.get() != null && ((LinearSeqOptimized)option11.get()).lengthCompare(0) == 0) {
            return MapType$.MODULE$;
        }
        Option option12 = ((Regex)this.LIST_REGEX()).unapplySeq((CharSequence)string);
        if (!option12.isEmpty() && option12.get() != null && ((LinearSeqOptimized)option12.get()).lengthCompare(0) == 0) {
            return ListType$.MODULE$;
        }
        Option option13 = ((Regex)this.STRUCT_REGEX()).unapplySeq((CharSequence)string);
        if (!option13.isEmpty() && option13.get() != null && ((LinearSeqOptimized)option13.get()).lengthCompare(0) == 0) {
            return StructType$.MODULE$;
        }
        return StringType$.MODULE$;
    }

    public Object toValue(DataType dataType, String value) {
        ObjectRef newValue;
        block1: {
            newValue = ObjectRef.create((Object)value);
            if (!this.isLinkisNull(value)) break block1;
            if (!LinkisStorageConf$.MODULE$.LINKIS_RESULT_ENABLE_NULL()) {
                return null;
            }
            newValue.elem = Dolphin$.MODULE$.NULL();
        }
        return Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> {
            DataType dataType = dataType;
            if (NullType$.MODULE$.equals(dataType)) {
                return null;
            }
            if (StringType$.MODULE$.equals(dataType) ? true : (CharType$.MODULE$.equals(dataType) ? true : (VarcharType$.MODULE$.equals(dataType) ? true : (StructType$.MODULE$.equals(dataType) ? true : (ListType$.MODULE$.equals(dataType) ? true : (ArrayType$.MODULE$.equals(dataType) ? true : MapType$.MODULE$.equals(dataType))))))) {
                return (String)newValue$1.elem;
            }
            if (BooleanType$.MODULE$.equals(dataType)) {
                if (MODULE$.isNumberNull((String)newValue$1.elem)) {
                    return null;
                }
                return BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString((String)newValue$1.elem)).toBoolean());
            }
            if (ShortIntType$.MODULE$.equals(dataType)) {
                if (MODULE$.isNumberNull((String)newValue$1.elem)) {
                    return null;
                }
                return BoxesRunTime.boxToShort((short)new StringOps(Predef$.MODULE$.augmentString((String)newValue$1.elem)).toShort());
            }
            if (IntType$.MODULE$.equals(dataType)) {
                if (MODULE$.isNumberNull((String)newValue$1.elem)) {
                    return null;
                }
                return BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString((String)newValue$1.elem)).toInt());
            }
            if (LongType$.MODULE$.equals(dataType) ? true : BigIntType$.MODULE$.equals(dataType)) {
                if (MODULE$.isNumberNull((String)newValue$1.elem)) {
                    return null;
                }
                return BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString((String)newValue$1.elem)).toLong());
            }
            if (FloatType$.MODULE$.equals(dataType)) {
                if (MODULE$.isNumberNull((String)newValue$1.elem)) {
                    return null;
                }
                return BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString((String)newValue$1.elem)).toFloat());
            }
            if (DoubleType$.MODULE$.equals(dataType)) {
                if (MODULE$.isNumberNull((String)newValue$1.elem)) {
                    return null;
                }
                return BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString((String)newValue$1.elem)).toDouble());
            }
            if (DecimalType$.MODULE$.equals(dataType)) {
                if (MODULE$.isNumberNull((String)newValue$1.elem)) {
                    return null;
                }
                return new BigDecimal((String)newValue$1.elem);
            }
            if (DateType$.MODULE$.equals(dataType)) {
                if (MODULE$.isNumberNull((String)newValue$1.elem)) {
                    return null;
                }
                return Date.valueOf((String)newValue$1.elem);
            }
            if (TimestampType$.MODULE$.equals(dataType)) {
                if (MODULE$.isNumberNull((String)newValue$1.elem)) {
                    return null;
                }
                return new StringOps(Predef$.MODULE$.augmentString(Timestamp.valueOf((String)newValue$1.elem).toString())).stripSuffix(".0");
            }
            if (BinaryType$.MODULE$.equals(dataType)) {
                if (MODULE$.isNull((String)newValue$1.elem)) {
                    return null;
                }
                return ((String)newValue$1.elem).getBytes();
            }
            return (String)newValue$1.elem;
        }, (Function1 & Serializable & scala.Serializable)t -> {
            MODULE$.logger().debug(new StringBuilder(32).append("Failed to  ").append((String)newValue$1.elem).append(" switch  to dataType:").toString(), t);
            return (String)newValue$1.elem;
        });
    }

    public boolean isLinkisNull(String value) {
        block3: {
            block2: {
                if (value == null) break block2;
                String string = value;
                String string2 = Dolphin$.MODULE$.LINKIS_NULL();
                if (string != null ? !string.equals(string2) : string2 != null) break block3;
            }
            return true;
        }
        return false;
    }

    public boolean isNull(String value) {
        block3: {
            block2: {
                if (value == null) break block2;
                String string = value;
                String string2 = Dolphin$.MODULE$.NULL();
                if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
                String string3 = value.trim();
                String string4 = "";
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
            }
            return true;
        }
        return false;
    }

    public boolean isNumberNull(String value) {
        block3: {
            block2: {
                if (value == null || Dolphin$.MODULE$.NULL().equalsIgnoreCase(value)) break block2;
                String string = value.trim();
                String string2 = "";
                if (string != null ? !string.equals(string2) : string2 != null) break block3;
            }
            return true;
        }
        return false;
    }

    public String valueToString(Object value) {
        if (value == null) {
            return null;
        }
        Object object = value;
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            return bigDecimal.toPlainString();
        }
        return value.toString();
    }

    private DataType$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.LOWCASE_NULL_VALUE = "null";
        this.DECIMAL_REGEX = new StringOps(Predef$.MODULE$.augmentString("^decimal\\(\\s*\\d*\\s*,\\s*\\d*\\s*\\)")).r().unanchored();
        this.SHORT_REGEX = new StringOps(Predef$.MODULE$.augmentString("^short.*")).r().unanchored();
        this.INT_REGEX = new StringOps(Predef$.MODULE$.augmentString("^int.*")).r().unanchored();
        this.LONG_REGEX = new StringOps(Predef$.MODULE$.augmentString("^long.*")).r().unanchored();
        this.BIGINT_REGEX = new StringOps(Predef$.MODULE$.augmentString("^bigint.*")).r().unanchored();
        this.FLOAT_REGEX = new StringOps(Predef$.MODULE$.augmentString("^float.*")).r().unanchored();
        this.DOUBLE_REGEX = new StringOps(Predef$.MODULE$.augmentString("^double.*")).r().unanchored();
        this.VARCHAR_REGEX = new StringOps(Predef$.MODULE$.augmentString("^varchar.*")).r().unanchored();
        this.CHAR_REGEX = new StringOps(Predef$.MODULE$.augmentString("^char.*")).r().unanchored();
        this.ARRAY_REGEX = new StringOps(Predef$.MODULE$.augmentString("array.*")).r().unanchored();
        this.MAP_REGEX = new StringOps(Predef$.MODULE$.augmentString("map.*")).r().unanchored();
        this.LIST_REGEX = new StringOps(Predef$.MODULE$.augmentString("list.*")).r().unanchored();
        this.STRUCT_REGEX = new StringOps(Predef$.MODULE$.augmentString("struct.*")).r().unanchored();
    }
}

