/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.operator.ujes;

import java.io.IOException;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cli.application.entity.operator.JobOper;
import org.apache.linkis.cli.application.exception.LinkisClientExecutionException;
import org.apache.linkis.cli.application.exception.LinkisClientRuntimeException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;
import org.apache.linkis.cli.application.interactor.job.interactive.InteractiveJobDesc;
import org.apache.linkis.cli.application.operator.ujes.LinkisOperResultAdapter;
import org.apache.linkis.cli.application.operator.ujes.UJESConstants;
import org.apache.linkis.cli.application.operator.ujes.UJESResultAdapter;
import org.apache.linkis.cli.application.operator.ujes.result.OpenLogResult2;
import org.apache.linkis.cli.application.operator.ujes.result.ResultSetResult2;
import org.apache.linkis.cli.application.utils.CliUtils;
import org.apache.linkis.common.exception.LinkisException;
import org.apache.linkis.ujes.client.UJESClient;
import org.apache.linkis.ujes.client.request.JobSubmitAction;
import org.apache.linkis.ujes.client.request.OpenLogAction;
import org.apache.linkis.ujes.client.request.ResultSetAction;
import org.apache.linkis.ujes.client.response.JobExecuteResult;
import org.apache.linkis.ujes.client.response.JobInfoResult;
import org.apache.linkis.ujes.client.response.JobKillResult;
import org.apache.linkis.ujes.client.response.JobLogResult;
import org.apache.linkis.ujes.client.response.JobProgressResult;
import org.apache.linkis.ujes.client.response.JobStatusResult;
import org.apache.linkis.ujes.client.response.JobSubmitResult;
import org.apache.linkis.ujes.client.response.OpenLogResult;
import org.apache.linkis.ujes.client.response.ResultSetResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkisJobOper
implements JobOper {
    protected UJESClient client;
    private Logger logger = LoggerFactory.getLogger(LinkisJobOper.class);
    private String serverUrl;

    public UJESClient getUJESClient() {
        return this.client;
    }

    public void setUJESClient(UJESClient client) {
        this.client = client;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void close() {
        if (null != this.client) {
            try {
                this.client.close();
            }
            catch (IOException e) {
                this.logger.error("Close error. " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void checkInit() throws LinkisClientRuntimeException {
        if (this.client == null) {
            throw new LinkisClientExecutionException("EXE0011", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionInitErr, "UjesClientDriver is null");
        }
    }

    public LinkisOperResultAdapter submit(InteractiveJobDesc jobDesc) throws LinkisClientRuntimeException {
        JobSubmitResult jobSubmitResult;
        this.checkInit();
        try {
            JobSubmitAction jobSubmitAction = JobSubmitAction.builder().setUser(jobDesc.getSubmitUser()).addExecuteUser(jobDesc.getProxyUser()).setExecutionContent(jobDesc.getExecutionMap()).addExecuteCode((String)jobDesc.getExecutionMap().get("code")).setStartupParams(jobDesc.getParamConfMap()).setRuntimeParams(jobDesc.getParamRunTimeMap()).setVariableMap(jobDesc.getParamVarsMap()).setLabels(jobDesc.getLabelMap()).setSource(jobDesc.getSourceMap()).setHeaders(jobDesc.getHeaders()).build();
            this.logger.info("Request info to Linkis: \n{}", (Object)CliUtils.GSON.toJson((Object)jobSubmitAction));
            jobSubmitResult = this.client.submit(jobSubmitAction);
            this.logger.info("Response info from Linkis: \n{}", (Object)CliUtils.GSON.toJson((Object)jobSubmitResult));
        }
        catch (Exception e) {
            throw new LinkisClientExecutionException("EXE0011", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, "Failed to submit job", e);
        }
        if (jobSubmitResult == null || 0 != jobSubmitResult.getStatus() || StringUtils.isBlank((CharSequence)jobSubmitResult.getTaskID())) {
            String reason;
            if (jobSubmitResult == null) {
                reason = "JobSubmitResult is null";
            } else if (0 != jobSubmitResult.getStatus()) {
                reason = "server returns non-zero status-code. ";
                reason = reason + jobSubmitResult.getMessage();
            } else {
                reason = "server returns blank TaskId";
            }
            String msg = MessageFormat.format("Failed to submit job\uff0c Reason: {0}", reason);
            throw new LinkisClientExecutionException("EXE0012", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, msg);
        }
        return new UJESResultAdapter(jobSubmitResult);
    }

    public LinkisOperResultAdapter queryJobInfo(String user, String taskID) throws LinkisClientRuntimeException {
        if (user == null || taskID == null) {
            throw new LinkisClientExecutionException("EXE0036", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, "user or jobID is null");
        }
        return new UJESResultAdapter(this.queryJobInfoInternal(user, taskID));
    }

    public LinkisOperResultAdapter queryJobStatus(String user, String taskID, String execID) throws LinkisClientRuntimeException {
        String msg;
        String reason;
        if (user == null || taskID == null || execID == null) {
            throw new LinkisClientExecutionException("EXE0036", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, "user or jobID or execID is null");
        }
        this.checkInit();
        JobExecuteResult executeResult = new JobExecuteResult();
        executeResult.setTaskID(taskID);
        executeResult.setUser(user);
        executeResult.setExecID(execID);
        JobStatusResult jobStatusResult = null;
        int retryTime = 0;
        int MAX_RETRY_TIME = UJESConstants.DRIVER_REQUEST_MAX_RETRY_TIME;
        while (retryTime++ < MAX_RETRY_TIME) {
            block10: {
                try {
                    jobStatusResult = this.client.status(executeResult);
                    this.logger.debug("job-status: " + CliUtils.GSON.toJson((Object)jobStatusResult));
                    if (jobStatusResult != null && 0 == jobStatusResult.getStatus()) break;
                    if (jobStatusResult == null) {
                        reason = "jobStatusResult is null";
                    } else {
                        reason = "server returns non-zero status-code. ";
                        reason = reason + jobStatusResult.getMessage();
                    }
                    msg = MessageFormat.format("Get job status failed. retry time : {0}/{1}. taskID={0}, Reason: {1}", retryTime, MAX_RETRY_TIME, taskID, reason);
                    this.logger.debug("", (Throwable)new LinkisClientExecutionException("EXE0013", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, msg));
                }
                catch (Exception e) {
                    msg = MessageFormat.format("Get job status failed. retry time : {0}/{1}", retryTime, MAX_RETRY_TIME);
                    if (e instanceof LinkisException) {
                        msg = msg + " " + e.toString();
                    }
                    this.logger.warn(msg, (Throwable)e);
                    if (retryTime < MAX_RETRY_TIME) break block10;
                    throw new LinkisClientExecutionException("EXE0013", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, msg, e);
                }
            }
            CliUtils.doSleepQuietly(UJESConstants.DRIVER_QUERY_SLEEP_MILLS);
        }
        if (jobStatusResult == null || 0 != jobStatusResult.getStatus()) {
            if (jobStatusResult == null) {
                reason = "jobStatusResult is null";
            } else {
                reason = "server returns non-zero status-code. ";
                reason = reason + jobStatusResult.getMessage();
            }
            msg = MessageFormat.format("Get status failed. Retry exhausted. taskID={0}, Reason: {1}", taskID, reason);
            throw new LinkisClientExecutionException("EXE0013", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, msg);
        }
        return new UJESResultAdapter(jobStatusResult);
    }

    private JobInfoResult queryJobInfoInternal(String user, String taskID) throws LinkisClientRuntimeException {
        String msg;
        String reason;
        this.checkInit();
        JobExecuteResult executeResult = new JobExecuteResult();
        executeResult.setTaskID(taskID);
        executeResult.setUser(user);
        JobInfoResult jobInfoResult = null;
        int retryTime = 0;
        int MAX_RETRY_TIME = UJESConstants.DRIVER_REQUEST_MAX_RETRY_TIME;
        while (retryTime++ < MAX_RETRY_TIME) {
            block9: {
                try {
                    jobInfoResult = this.client.getJobInfo(executeResult);
                    this.logger.debug("job-info: " + CliUtils.GSON.toJson((Object)jobInfoResult));
                    if (jobInfoResult != null && 0 == jobInfoResult.getStatus()) break;
                    if (jobInfoResult == null) {
                        reason = "JobInfoResult is null";
                    } else {
                        reason = "server returns non-zero status-code. ";
                        reason = reason + jobInfoResult.getMessage();
                    }
                    msg = MessageFormat.format("Get job info failed. retry time : {0}/{1}. taskID={2}, Reason: {3}", retryTime, MAX_RETRY_TIME, taskID, reason);
                    this.logger.debug("", (Throwable)new LinkisClientExecutionException("EXE0013", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, msg));
                }
                catch (Exception e) {
                    msg = MessageFormat.format("Get job info failed. retry time : {0}/{1}", retryTime, MAX_RETRY_TIME);
                    if (e instanceof LinkisException) {
                        msg = msg + " " + e.toString();
                    }
                    this.logger.warn(msg, (Throwable)e);
                    if (retryTime < MAX_RETRY_TIME) break block9;
                    throw new LinkisClientExecutionException("EXE0013", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, msg, e);
                }
            }
            CliUtils.doSleepQuietly(UJESConstants.DRIVER_QUERY_SLEEP_MILLS);
        }
        if (jobInfoResult == null || 0 != jobInfoResult.getStatus()) {
            if (jobInfoResult == null) {
                reason = "JobInfoResult is null";
            } else {
                reason = "server returns non-zero status-code. ";
                reason = reason + jobInfoResult.getMessage();
            }
            msg = MessageFormat.format("Get info failed. Retry exhausted. taskID={0}, Reason: {1}", taskID, reason);
            throw new LinkisClientExecutionException("EXE0013", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, msg);
        }
        return jobInfoResult;
    }

    public LinkisOperResultAdapter queryRunTimeLogFromLine(String user, String taskID, String execID, int fromLine) throws LinkisClientRuntimeException {
        String msg;
        String reason;
        this.checkInit();
        JobExecuteResult jobExecuteResult = new JobExecuteResult();
        jobExecuteResult.setUser(user);
        jobExecuteResult.setTaskID(taskID);
        jobExecuteResult.setExecID(execID);
        JobLogResult logResult = null;
        int retryTime = 0;
        int MAX_RETRY_TIME = UJESConstants.DRIVER_REQUEST_MAX_RETRY_TIME;
        while (retryTime++ < MAX_RETRY_TIME) {
            block8: {
                try {
                    logResult = this.client.log(jobExecuteResult, fromLine, UJESConstants.MAX_LOG_SIZE.intValue());
                    this.logger.debug("runtime-log-result:" + CliUtils.GSON.toJson((Object)logResult));
                    if (logResult != null && 0 == logResult.getStatus()) break;
                    if (logResult == null) {
                        reason = "JobLogResult is null";
                    } else {
                        reason = "server returns non-zero status-code";
                        reason = reason + logResult.getMessage();
                    }
                    msg = MessageFormat.format("Get log failed. retry time : {0}/{1}. taskID={2}. Reason: {3}", retryTime, MAX_RETRY_TIME, taskID, reason);
                    this.logger.debug("", (Throwable)new LinkisClientExecutionException("EXE0015", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, msg));
                }
                catch (Exception e) {
                    msg = MessageFormat.format("Get log failed. Retry time : {0}/{1}", retryTime, MAX_RETRY_TIME);
                    if (retryTime < MAX_RETRY_TIME) break block8;
                    throw new LinkisClientExecutionException("EXE0016", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, msg, e);
                }
            }
            CliUtils.doSleepQuietly(UJESConstants.DRIVER_QUERY_SLEEP_MILLS);
        }
        if (logResult == null || 0 != logResult.getStatus()) {
            if (logResult == null) {
                reason = "JobLogResult is null";
            } else {
                reason = "server returns non-zero status-code. ";
                reason = reason + logResult.getMessage();
            }
            msg = MessageFormat.format("Get log failed. Retry exhausted. taskID={0}, Reason: {1}", taskID, reason);
            throw new LinkisClientExecutionException("EXE0016", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, msg);
        }
        return new UJESResultAdapter(logResult);
    }

    public LinkisOperResultAdapter queryPersistedLogFromLine(String logPath, String user, String taskID, int fromLine) {
        return new UJESResultAdapter(new OpenLogResult2(this.queryPersistedLogInternal(logPath, user, taskID), fromLine));
    }

    private OpenLogResult queryPersistedLogInternal(String logPath, String user, String taskID) throws LinkisClientRuntimeException {
        String msg;
        String reason;
        this.checkInit();
        int retryCnt = 0;
        int MAX_RETRY_TIMES = UJESConstants.DRIVER_REQUEST_MAX_RETRY_TIME;
        OpenLogResult openLogResult = null;
        while (retryCnt++ < MAX_RETRY_TIMES) {
            block10: {
                try {
                    openLogResult = this.client.openLog(OpenLogAction.newBuilder().setLogPath(logPath).setProxyUser(user).build());
                    this.logger.debug("persisted-log-result:" + CliUtils.GSON.toJson((Object)openLogResult));
                    if (openLogResult != null && 0 == openLogResult.getStatus() && !StringUtils.isBlank((CharSequence)openLogResult.getLog()[UJESConstants.IDX_FOR_LOG_TYPE_ALL])) break;
                    if (openLogResult == null) {
                        reason = "OpenLogResult is null";
                    } else if (0 != openLogResult.getStatus()) {
                        reason = "server returns non-zero status-code. ";
                        reason = reason + openLogResult.getMessage();
                    } else {
                        reason = "server returns empty log";
                    }
                    msg = MessageFormat.format("Get log from openLog failed. retry time : {0}/{1}. taskID={2}. Reason: {3}", retryCnt, MAX_RETRY_TIMES, taskID, reason);
                    this.logger.debug(msg);
                }
                catch (Exception e) {
                    msg = MessageFormat.format("Get log from openLog failed. retry time : {0}/{1}", retryCnt, MAX_RETRY_TIMES);
                    if (e instanceof LinkisException) {
                        msg = msg + " " + e.toString();
                    }
                    this.logger.debug(msg, (Throwable)e);
                    if (retryCnt < MAX_RETRY_TIMES) break block10;
                    throw new LinkisClientExecutionException("EXE0017", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, "Get log from openLog failed. Retry exhausted. taskID=" + taskID, e);
                }
            }
            CliUtils.doSleepQuietly(UJESConstants.DRIVER_QUERY_SLEEP_MILLS);
        }
        if (openLogResult == null || 0 != openLogResult.getStatus() || StringUtils.isBlank((CharSequence)openLogResult.getLog()[UJESConstants.IDX_FOR_LOG_TYPE_ALL])) {
            reason = openLogResult == null ? "OpenLogResult is null" : (0 != openLogResult.getStatus() ? "server returns non-zero status-code" : "server returns empty log");
            msg = MessageFormat.format("Get log from openLog failed. retry time : {0}/{1}. taskID={2}. Reason: {3}", retryCnt, MAX_RETRY_TIMES, taskID, reason);
            this.logger.debug(msg);
            if (retryCnt >= MAX_RETRY_TIMES) {
                msg = MessageFormat.format("Get log from openLog failed. Retry exhausted. taskID={0}, Reason: {1}", taskID, reason);
                throw new LinkisClientExecutionException("EXE0017", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, msg);
            }
        }
        return openLogResult;
    }

    public UJESResultAdapter queryProgress(String user, String taskID, String execId) throws LinkisClientRuntimeException {
        String msg;
        String reason;
        this.checkInit();
        JobExecuteResult executeResult = new JobExecuteResult();
        executeResult.setTaskID(taskID);
        executeResult.setUser(user);
        executeResult.setExecID(execId);
        JobProgressResult jobProgressResult = null;
        int retryTime = 0;
        int MAX_RETRY_TIME = UJESConstants.DRIVER_REQUEST_MAX_RETRY_TIME;
        while (retryTime++ < MAX_RETRY_TIME) {
            block9: {
                try {
                    jobProgressResult = this.client.progress(executeResult);
                    if (jobProgressResult != null && 0 == jobProgressResult.getStatus()) break;
                    if (jobProgressResult == null) {
                        reason = "JobProgressResult is null";
                    } else {
                        reason = "server returns non-zero status-code. ";
                        reason = reason + jobProgressResult.getMessage();
                    }
                    msg = MessageFormat.format("Get progress failed. retry time : {0}/{1}. taskID={2}. Reason: {3}", retryTime, MAX_RETRY_TIME, taskID, reason);
                    this.logger.debug(msg);
                }
                catch (Exception e) {
                    msg = MessageFormat.format("Get progress failed. retry time : {0}/{1}", retryTime, MAX_RETRY_TIME);
                    if (e instanceof LinkisException) {
                        msg = msg + " " + e.toString();
                    }
                    this.logger.warn(msg, (Throwable)e);
                    if (retryTime < MAX_RETRY_TIME) break block9;
                    throw new LinkisClientExecutionException("EXE0019", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, "Get progress failed. Retry exhausted. taskID=" + taskID, e);
                }
            }
            CliUtils.doSleepQuietly(UJESConstants.DRIVER_QUERY_SLEEP_MILLS);
        }
        if (jobProgressResult == null || 0 != jobProgressResult.getStatus()) {
            if (jobProgressResult == null) {
                reason = "JobProgressResult is null";
            } else {
                reason = "server returns non-zero status-code. ";
                reason = reason + jobProgressResult.getMessage();
            }
            msg = MessageFormat.format("Get progress failed. Retry exhausted. taskID={0}, Reason: {1}", taskID, reason);
            throw new LinkisClientExecutionException("EXE0020", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, msg);
        }
        return new UJESResultAdapter(jobProgressResult);
    }

    public LinkisOperResultAdapter queryResultSetPaths(String user, String taskID, String resultLocation) {
        String msg;
        String reason;
        this.checkInit();
        JobInfoResult jobInfoResult = this.queryJobInfoInternal(user, taskID);
        if (null == jobInfoResult) {
            String msg2 = "Get ResultSet Failed: Cannot get a valid jobInfo";
            this.logger.error(msg2);
            throw new LinkisClientExecutionException("EXE0021", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, msg2);
        }
        if (!jobInfoResult.isSucceed()) {
            String msg3 = "Get ResultSet Failed: job Status is not \"Succeed\", .";
            throw new LinkisClientExecutionException("EXE0021", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, msg3);
        }
        if (StringUtils.isBlank((CharSequence)jobInfoResult.getRequestPersistTask().getResultLocation())) {
            jobInfoResult.getRequestPersistTask().setResultLocation(resultLocation);
        }
        if (StringUtils.isBlank((CharSequence)jobInfoResult.getRequestPersistTask().getResultLocation())) {
            throw new LinkisClientExecutionException("EXE0021", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, "ResultLocation is blank.");
        }
        String[] resultSetArray = null;
        int retryTime = 0;
        int MAX_RETRY_TIME = UJESConstants.DRIVER_REQUEST_MAX_RETRY_TIME;
        while (retryTime++ < MAX_RETRY_TIME) {
            block10: {
                try {
                    resultSetArray = jobInfoResult.getResultSetList(this.client);
                    if (resultSetArray == null || 0 == resultSetArray.length) {
                        reason = resultSetArray == null ? "array is null" : "array length is zero";
                        msg = MessageFormat.format("Get resultSetArray failed. retry time : {0}/{1}. taskID={2} Reason: {3}", retryTime, MAX_RETRY_TIME, taskID, reason);
                        this.logger.debug(msg);
                        break;
                    }
                }
                catch (Exception e) {
                    msg = MessageFormat.format("Get resultSetArray failed. retry time : {0}/{1}", retryTime, MAX_RETRY_TIME);
                    if (e instanceof LinkisException) {
                        msg = msg + " " + e.toString();
                    }
                    this.logger.warn(msg, (Throwable)e);
                    if (retryTime < MAX_RETRY_TIME) break block10;
                    throw new LinkisClientExecutionException("EXE0022", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, "Get resultSetArray failed. Retry exhausted. taskID=" + taskID, e);
                }
            }
            CliUtils.doSleepQuietly(UJESConstants.DRIVER_QUERY_SLEEP_MILLS);
        }
        if (resultSetArray == null || 0 == resultSetArray.length) {
            reason = resultSetArray == null ? "array is null" : "array length is zero";
            msg = MessageFormat.format("Get resultSetArray failed. retry exhausted. taskID={0}. Reason: {1}", taskID, reason);
            this.logger.warn(msg);
        }
        return new UJESResultAdapter(resultSetArray);
    }

    public LinkisOperResultAdapter queryResultSetGivenResultSetPath(String[] resultSetPaths, int idxResultSet, String user, Integer page, Integer pageSize) {
        String msg;
        this.checkInit();
        int retryTime = 0;
        int MAX_RETRY_TIME = UJESConstants.DRIVER_REQUEST_MAX_RETRY_TIME;
        ResultSetResult result = null;
        String resultSetPath = resultSetPaths[idxResultSet];
        while (retryTime++ < MAX_RETRY_TIME) {
            block9: {
                try {
                    String reason;
                    ResultSetAction action = ResultSetAction.builder().setPath(resultSetPath).setUser(user).setPage(page.intValue()).setPageSize(pageSize.intValue()).build();
                    result = this.client.resultSet(action);
                    this.logger.debug("resultset-result:" + CliUtils.GSON.toJson((Object)result));
                    if (result != null && 0 == result.getStatus()) break;
                    if (result == null) {
                        reason = "array is null";
                    } else {
                        reason = "server returns non-zero status-code. ";
                        reason = reason + result.getMessage();
                    }
                    String msg2 = MessageFormat.format("Get resultSet failed. retry time : {0}/{1}. path={2}, Reason: {3}", retryTime, MAX_RETRY_TIME, resultSetPath, reason);
                    this.logger.debug(msg2);
                }
                catch (Exception e) {
                    msg = MessageFormat.format("Get resultSet failed. retry time : {0}/{1}", retryTime, MAX_RETRY_TIME);
                    if (e instanceof LinkisException) {
                        msg = msg + " " + e.toString();
                    }
                    this.logger.warn(msg, (Throwable)e);
                    if (retryTime < MAX_RETRY_TIME) break block9;
                    throw new LinkisClientExecutionException("EXE0024", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, "Get resultSet failed. Retry exhausted. path=" + resultSetPath, e);
                }
            }
            CliUtils.doSleepQuietly(UJESConstants.DRIVER_QUERY_SLEEP_MILLS);
        }
        if (result == null || 0 != result.getStatus()) {
            String reason;
            if (result == null) {
                reason = "ResultSetResult is null";
            } else {
                reason = "server returns non-zero status-code. ";
                reason = reason + result.getMessage();
            }
            msg = MessageFormat.format("Get resultSet failed. Retry exhausted. Path={0}, Reason: {1}", resultSetPath, reason);
            throw new LinkisClientExecutionException("EXE0024", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, msg);
        }
        return new UJESResultAdapter(new ResultSetResult2(idxResultSet, result));
    }

    public LinkisOperResultAdapter kill(String user, String taskId, String execId) throws LinkisClientRuntimeException {
        String msg;
        this.checkInit();
        int retryTime = 0;
        int MAX_RETRY_TIME = UJESConstants.DRIVER_REQUEST_MAX_RETRY_TIME;
        JobKillResult result = null;
        while (retryTime++ < MAX_RETRY_TIME) {
            block9: {
                try {
                    String reason;
                    JobExecuteResult killRequest = new JobExecuteResult();
                    killRequest.setUser(user);
                    killRequest.setTaskID(taskId);
                    killRequest.setExecID(execId);
                    result = this.client.kill(killRequest);
                    this.logger.debug("job-kill-result:" + CliUtils.GSON.toJson((Object)result));
                    if (result != null && 0 == result.getStatus()) break;
                    if (result == null) {
                        reason = "result is null";
                    } else {
                        reason = "server returns non-zero status-code. ";
                        reason = reason + result.getMessage();
                    }
                    String msg2 = MessageFormat.format("Kill job failed. retry time : {0}/{1}. taskId={2}, Reason: {3}", retryTime, MAX_RETRY_TIME, taskId, reason);
                    this.logger.debug(msg2);
                }
                catch (Exception e) {
                    msg = MessageFormat.format("Kill job failed. retry time : {0}/{1}", retryTime, MAX_RETRY_TIME);
                    if (e instanceof LinkisException) {
                        msg = msg + " " + e.toString();
                    }
                    this.logger.warn(msg, (Throwable)e);
                    if (retryTime < MAX_RETRY_TIME) break block9;
                    throw new LinkisClientExecutionException("EXE0025", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, "Kill job failed. taskId={0} Retry exhausted.", taskId, e);
                }
            }
            CliUtils.doSleepQuietly(UJESConstants.DRIVER_QUERY_SLEEP_MILLS);
        }
        if (result == null || 0 != result.getStatus()) {
            String reason;
            if (result == null) {
                reason = "result is null";
            } else {
                reason = "server returns non-zero status-code. ";
                reason = reason + result.getMessage();
            }
            msg = MessageFormat.format("Kill job failed. Retry exhausted. taskId={0}, Reason: {1}", taskId, reason);
            throw new LinkisClientExecutionException("EXE0025", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, msg);
        }
        return new UJESResultAdapter(result);
    }
}

