/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.gateway.springcloud.http;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestData;
import org.springframework.cloud.client.loadbalancer.RequestDataContext;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.loadbalancer.core.NoopServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ReactorServiceInstanceLoadBalancer;
import org.springframework.cloud.loadbalancer.core.SelectedInstanceCallback;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import reactor.core.publisher.Mono;

public class IpPriorityLoadBalancer
implements ReactorServiceInstanceLoadBalancer {
    private static final Logger logger = LoggerFactory.getLogger(IpPriorityLoadBalancer.class);
    private final String serviceId;
    private final ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider;

    public IpPriorityLoadBalancer(String serviceId, ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider) {
        this.serviceId = serviceId;
        this.serviceInstanceListSupplierProvider = serviceInstanceListSupplierProvider;
    }

    public Mono<Response<ServiceInstance>> choose(Request request) {
        RequestData clientRequest = ((RequestDataContext)request.getContext()).getClientRequest();
        List clientIpList = clientRequest.getHeaders().get((Object)"FIXED_INSTANCE");
        String clientIp = CollectionUtils.isNotEmpty((Collection)clientIpList) ? (String)clientIpList.get(0) : null;
        ServiceInstanceListSupplier supplier = (ServiceInstanceListSupplier)this.serviceInstanceListSupplierProvider.getIfAvailable(NoopServiceInstanceListSupplier::new);
        return supplier.get(request).next().map(serviceInstances -> this.processInstanceResponse(supplier, (List<ServiceInstance>)serviceInstances, clientIp, clientRequest));
    }

    private Response<ServiceInstance> processInstanceResponse(ServiceInstanceListSupplier supplier, List<ServiceInstance> serviceInstances, String clientIp, RequestData request) {
        Response<ServiceInstance> serviceInstanceResponse = this.getInstanceResponse(serviceInstances, clientIp, request);
        if (supplier instanceof SelectedInstanceCallback && serviceInstanceResponse.hasServer()) {
            ((SelectedInstanceCallback)supplier).selectedServiceInstance((ServiceInstance)serviceInstanceResponse.getServer());
        }
        return serviceInstanceResponse;
    }

    private Response<ServiceInstance> getInstanceResponse(List<ServiceInstance> instances, String clientIp, RequestData request) {
        if (instances.isEmpty()) {
            logger.warn("No servers available for service: " + this.serviceId);
            return new EmptyResponse();
        }
        if (StringUtils.isEmpty((CharSequence)clientIp)) {
            return new DefaultResponse(instances.get(ThreadLocalRandom.current().nextInt(instances.size())));
        }
        String[] ipAndPort = clientIp.split(":");
        if (ipAndPort.length != 2) {
            return new DefaultResponse(instances.get(ThreadLocalRandom.current().nextInt(instances.size())));
        }
        for (ServiceInstance instance : instances) {
            if (!Objects.equals(ipAndPort[0], instance.getHost()) || !Objects.equals(ipAndPort[1], String.valueOf(instance.getPort()))) continue;
            logger.info("Request {} fixed route to instance {}", (Object)request.getUrl(), (Object)instance);
            return new DefaultResponse(instance);
        }
        return new DefaultResponse(instances.get(ThreadLocalRandom.current().nextInt(instances.size())));
    }
}

