/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.bml.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.bml.common.ResourceHelper;
import org.apache.linkis.bml.common.UploadResourceException;
import org.apache.linkis.bml.conf.BmlServerConfiguration;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.storage.FSFactory;
import org.apache.linkis.storage.utils.FileSystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ResourceHelper
implements ResourceHelper {
    private static final Logger logger = LoggerFactory.getLogger(S3ResourceHelper.class);
    private static final String SCHEMA = "s3://";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long upload(String path, String user, InputStream inputStream, StringBuilder stringBuilder, boolean overwrite) throws UploadResourceException {
        OutputStream outputStream = null;
        InputStream is0 = null;
        InputStream is1 = null;
        long size = 0L;
        Fs fileSystem = null;
        try {
            FsPath fsPath = new FsPath(path);
            fileSystem = FSFactory.getFsByProxyUser((FsPath)fsPath, (String)user);
            fileSystem.init(null);
            if (!fileSystem.exists(fsPath)) {
                FileSystemUtils.createNewFile((FsPath)fsPath, (String)user, (boolean)true);
            }
            byte[] buffer = new byte[1024];
            long beforeSize = -1L;
            is0 = fileSystem.read(fsPath);
            int ch0 = 0;
            while ((ch0 = is0.read(buffer)) != -1) {
                beforeSize += (long)ch0;
            }
            outputStream = fileSystem.write(fsPath, overwrite);
            int ch = 0;
            MessageDigest md5Digest = DigestUtils.getMd5Digest();
            while ((ch = inputStream.read(buffer)) != -1) {
                md5Digest.update(buffer, 0, ch);
                outputStream.write(buffer, 0, ch);
                size += (long)ch;
            }
            if (stringBuilder != null) {
                stringBuilder.append(Hex.encodeHexString((byte[])md5Digest.digest()));
            }
            long afterSize = -1L;
            is1 = fileSystem.read(fsPath);
            int ch1 = 0;
            while ((ch1 = is1.read(buffer)) != -1) {
                afterSize += (long)ch1;
            }
            size = Math.max(size, afterSize - beforeSize);
        }
        catch (IOException e) {
            try {
                logger.error("{} write to {} failed, reason is, IOException:", new Object[]{user, path, e});
                UploadResourceException uploadResourceException = new UploadResourceException();
                uploadResourceException.initCause(e);
                throw uploadResourceException;
                catch (Throwable t) {
                    logger.error("{} write to {} failed, reason is", new Object[]{user, path, t});
                    uploadResourceException = new UploadResourceException();
                    uploadResourceException.initCause(t);
                    throw uploadResourceException;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly(is0);
                IOUtils.closeQuietly(is1);
                if (fileSystem == null) throw throwable;
                try {
                    fileSystem.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    logger.error("close filesystem failed", (Throwable)e2);
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((InputStream)is0);
        IOUtils.closeQuietly((InputStream)is1);
        if (fileSystem == null) return size;
        try {
            fileSystem.close();
            return size;
        }
        catch (Exception e) {
            logger.error("close filesystem failed", (Throwable)e);
            return size;
        }
    }

    @Override
    public void update(String path) {
    }

    @Override
    public void getResource(String path, int start, int end) {
    }

    @Override
    public String getSchema() {
        return SCHEMA;
    }

    @Override
    public String generatePath(String user, String fileName, Map<String, Object> properties) {
        String resourceHeader = (String)properties.get("resourceHeader");
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String dateStr = format.format(new Date());
        if (StringUtils.isNotEmpty((CharSequence)resourceHeader)) {
            return this.getSchema() + (String)BmlServerConfiguration.BML_PREFIX().getValue() + "/" + user + "/bml/" + dateStr + "/" + resourceHeader + "/" + fileName;
        }
        return this.getSchema() + (String)BmlServerConfiguration.BML_PREFIX().getValue() + "/" + user + "/bml/" + dateStr + "/" + fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkIfExists(String path, String user) throws IOException {
        fileSystem.init(null);
        try (Fs fileSystem = FSFactory.getFsByProxyUser((FsPath)new FsPath(path), (String)user);){
            boolean bl = fileSystem.exists(new FsPath(path));
            return bl;
        }
    }

    @Override
    public boolean checkBmlResourceStoragePrefixPathIfChanged(String path) {
        String prefixPath = this.getSchema() + (String)BmlServerConfiguration.BML_PREFIX().getValue();
        return !path.startsWith(prefixPath);
    }
}

