/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.hdfs.dispatch;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.knox.gateway.ha.dispatch.ConfigurableHADispatch;
import org.apache.knox.gateway.hdfs.dispatch.SafeModeException;
import org.apache.knox.gateway.hdfs.dispatch.StandbyException;
import org.apache.knox.gateway.hdfs.i18n.WebHdfsMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;

public abstract class AbstractHdfsHaDispatch
extends ConfigurableHADispatch {
    private static final String FAILOVER_COUNTER_ATTRIBUTE = "dispatch.ha.failover.counter";
    private static final WebHdfsMessages LOG = (WebHdfsMessages)MessagesFactory.get(WebHdfsMessages.class);

    public void init() {
        super.init();
    }

    abstract String getResourceRole();

    protected void executeRequest(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) throws IOException {
        HttpResponse inboundResponse = null;
        try {
            inboundResponse = this.executeOutboundRequest(outboundRequest);
            this.writeOutboundResponse(outboundRequest, inboundRequest, outboundResponse, inboundResponse);
        }
        catch (IOException | SafeModeException | StandbyException e) {
            if (!this.getHaConfigurations().isFailoverNonIdempotentRequestEnabled()) {
                if (nonIdempotentRequests.stream().anyMatch(outboundRequest.getMethod()::equalsIgnoreCase)) {
                    LOG.cannotFailoverNonIdempotentRequest(outboundRequest.getMethod(), e.getCause());
                    throw e;
                }
            }
            this.printExceptionLogMessage(e, outboundRequest.getURI().toString());
            this.failoverRequest(outboundRequest, inboundRequest, outboundResponse, inboundResponse, e);
        }
    }

    protected void writeOutboundResponse(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse, HttpResponse inboundResponse) throws IOException {
        if (inboundResponse.getStatusLine().getStatusCode() == 403) {
            BufferedHttpEntity entity = new BufferedHttpEntity(inboundResponse.getEntity());
            inboundResponse.setEntity((HttpEntity)entity);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            inboundResponse.getEntity().writeTo((OutputStream)outputStream);
            String body = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
            if (body.contains("StandbyException")) {
                throw new StandbyException();
            }
            if (body.contains("SafeModeException") || body.contains("RetriableException")) {
                throw new SafeModeException();
            }
        }
        super.writeOutboundResponse(outboundRequest, inboundRequest, outboundResponse, inboundResponse);
    }

    protected void failoverRequest(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse, HttpResponse inboundResponse, Exception exception) throws IOException {
        LOG.failedToConnectTo(outboundRequest.getURI().toString());
        AtomicInteger counter = (AtomicInteger)inboundRequest.getAttribute(FAILOVER_COUNTER_ATTRIBUTE);
        if (counter == null) {
            counter = new AtomicInteger(0);
        }
        inboundRequest.setAttribute(FAILOVER_COUNTER_ATTRIBUTE, (Object)counter);
        if (counter.incrementAndGet() <= this.getHaConfigurations().getMaxFailoverAttempts()) {
            this.getHaConfigurations().getHaProvider().markFailedURL(this.getResourceRole(), outboundRequest.getURI().toString());
            inboundRequest.setAttribute("targetRequestUrl", null);
            URI uri = this.getDispatchUrl(inboundRequest);
            ((HttpRequestBase)outboundRequest).setURI(uri);
            if (this.getHaConfigurations().getFailoverSleep() > 0) {
                try {
                    Thread.sleep(this.getHaConfigurations().getFailoverSleep());
                }
                catch (InterruptedException e) {
                    LOG.failoverSleepFailed(this.getResourceRole(), e);
                    Thread.currentThread().interrupt();
                }
            }
            LOG.failingOverRequest(outboundRequest.getURI().toString());
            this.executeRequest(outboundRequest, inboundRequest, outboundResponse);
        } else {
            LOG.maxFailoverAttemptsReached(this.getHaConfigurations().getMaxFailoverAttempts(), this.getResourceRole());
            if (inboundResponse != null) {
                this.writeOutboundResponse(outboundRequest, inboundRequest, outboundResponse, inboundResponse);
            } else {
                throw new IOException(exception);
            }
        }
    }

    protected HttpEntity createRequestEntity(HttpServletRequest request) throws IOException {
        return null;
    }

    private void printExceptionLogMessage(Exception e, String uri) {
        if (e instanceof StandbyException) {
            LOG.errorReceivedFromStandbyNode(e);
        } else if (e instanceof SafeModeException) {
            LOG.errorReceivedFromSafeModeNode(e);
        } else {
            LOG.errorConnectingToServer(uri, e);
        }
    }
}

