/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.yarn;

import com.cloudera.api.swagger.ServicesResourceApi;
import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class JobHistoryUIServiceModelGenerator
extends AbstractServiceModelGenerator {
    private static final String SERVICE = "JOBHISTORYUI";
    private static final String SERVICE_TYPE = "YARN";
    private static final String ROLE_TYPE = "JOBHISTORY";
    private static final String HTTPS_PORT = "mapreduce_jobhistory_webapp_https_address";
    private static final String HTTP_PORT = "mapreduce_jobhistory_webapp_address";

    @Override
    public String getService() {
        return SERVICE;
    }

    @Override
    public String getServiceType() {
        return SERVICE_TYPE;
    }

    @Override
    public String getRoleType() {
        return ROLE_TYPE;
    }

    @Override
    public ServiceModel.Type getModelType() {
        return ServiceModel.Type.UI;
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig, ApiServiceConfig coreSettingsConfig) throws ApiException {
        String port;
        String scheme;
        String hostname = role.getHostRef().getHostname();
        if (this.isSSLEnabled(service, serviceConfig, coreSettingsConfig)) {
            scheme = "https";
            port = this.getRoleConfigValue(roleConfig, HTTPS_PORT);
        } else {
            scheme = "http";
            port = this.getRoleConfigValue(roleConfig, HTTP_PORT);
        }
        ServiceModel model = this.createServiceModel(String.format(Locale.getDefault(), "%s://%s:%s", scheme, hostname, port));
        model.addRoleProperty(this.getRoleType(), HTTP_PORT, this.getRoleConfigValue(roleConfig, HTTP_PORT));
        model.addRoleProperty(this.getRoleType(), HTTPS_PORT, this.getRoleConfigValue(roleConfig, HTTPS_PORT));
        return model;
    }

    private boolean isSSLEnabled(ApiService service, ApiServiceConfig serviceConfig, ApiServiceConfig coreSettingsConfig) throws ApiException {
        ServicesResourceApi servicesResourceApi = new ServicesResourceApi(this.getClient());
        String clusterName = service.getClusterRef().getClusterName();
        String hdfsService = this.getServiceConfigValue(serviceConfig, "hdfs_service");
        ApiServiceConfig hdfsServiceConfig = servicesResourceApi.readServiceConfig(clusterName, hdfsService, "full");
        return Boolean.parseBoolean(this.getCoreOrServiceConfig(hdfsServiceConfig, coreSettingsConfig, "hdfs_hadoop_ssl_enabled"));
    }
}

