/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiClusterRef;
import com.cloudera.api.swagger.model.ApiCommand;
import com.cloudera.api.swagger.model.ApiCommandStepProcess;
import com.cloudera.api.swagger.model.ApiHostRef;
import com.cloudera.api.swagger.model.ApiRemoteCommand;
import com.cloudera.api.swagger.model.ApiRoleRef;
import com.cloudera.api.swagger.model.ApiServiceRef;
import com.cloudera.api.swagger.model.State;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Provides detailed information about a step of a command.")
public class ApiCommandStep {
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="startTime")
    private String startTime = null;
    @SerializedName(value="endTime")
    private String endTime = null;
    @SerializedName(value="state")
    private State state = null;
    @SerializedName(value="resultMessage")
    private String resultMessage = null;
    @SerializedName(value="ignoreError")
    private Boolean ignoreError = null;
    @SerializedName(value="parallel")
    private Boolean parallel = null;
    @SerializedName(value="processes")
    private List<ApiCommandStepProcess> processes = null;
    @SerializedName(value="clientConfigs")
    private List<ApiCommandStepProcess> clientConfigs = null;
    @SerializedName(value="roles")
    private List<ApiRoleRef> roles = null;
    @SerializedName(value="clusters")
    private List<ApiClusterRef> clusters = null;
    @SerializedName(value="hosts")
    private List<ApiHostRef> hosts = null;
    @SerializedName(value="services")
    private List<ApiServiceRef> services = null;
    @SerializedName(value="children")
    private List<ApiCommandStep> children = null;
    @SerializedName(value="commands")
    private List<ApiCommand> commands = null;
    @SerializedName(value="remoteCommand")
    private ApiRemoteCommand remoteCommand = null;

    public ApiCommandStep description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The command step description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ApiCommandStep startTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(value="The start time.")
    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public ApiCommandStep endTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(value="The end time, if the command step is finished.")
    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public ApiCommandStep state(State state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(value="Current state of the command step")
    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public ApiCommandStep resultMessage(String resultMessage) {
        this.resultMessage = resultMessage;
        return this;
    }

    @ApiModelProperty(value="If the command step is finished, the result message.")
    public String getResultMessage() {
        return this.resultMessage;
    }

    public void setResultMessage(String resultMessage) {
        this.resultMessage = resultMessage;
    }

    public ApiCommandStep ignoreError(Boolean ignoreError) {
        this.ignoreError = ignoreError;
        return this;
    }

    @ApiModelProperty(value="Whether the step will continue even upon error.")
    public Boolean getIgnoreError() {
        return this.ignoreError;
    }

    public void setIgnoreError(Boolean ignoreError) {
        this.ignoreError = ignoreError;
    }

    public ApiCommandStep parallel(Boolean parallel) {
        this.parallel = parallel;
        return this;
    }

    @ApiModelProperty(value="Whether the children are scattered simultaneously, i.e. parallel. If not they would execute one after another, i.e. serially.")
    public Boolean getParallel() {
        return this.parallel;
    }

    public void setParallel(Boolean parallel) {
        this.parallel = parallel;
    }

    public ApiCommandStep processes(List<ApiCommandStepProcess> processes) {
        this.processes = processes;
        return this;
    }

    public ApiCommandStep addProcessesItem(ApiCommandStepProcess processesItem) {
        if (this.processes == null) {
            this.processes = new ArrayList<ApiCommandStepProcess>();
        }
        this.processes.add(processesItem);
        return this;
    }

    @ApiModelProperty(value="List of processes executed by the command step.")
    public List<ApiCommandStepProcess> getProcesses() {
        return this.processes;
    }

    public void setProcesses(List<ApiCommandStepProcess> processes) {
        this.processes = processes;
    }

    public ApiCommandStep clientConfigs(List<ApiCommandStepProcess> clientConfigs) {
        this.clientConfigs = clientConfigs;
        return this;
    }

    public ApiCommandStep addClientConfigsItem(ApiCommandStepProcess clientConfigsItem) {
        if (this.clientConfigs == null) {
            this.clientConfigs = new ArrayList<ApiCommandStepProcess>();
        }
        this.clientConfigs.add(clientConfigsItem);
        return this;
    }

    @ApiModelProperty(value="List of command step client configs.")
    public List<ApiCommandStepProcess> getClientConfigs() {
        return this.clientConfigs;
    }

    public void setClientConfigs(List<ApiCommandStepProcess> clientConfigs) {
        this.clientConfigs = clientConfigs;
    }

    public ApiCommandStep roles(List<ApiRoleRef> roles) {
        this.roles = roles;
        return this;
    }

    public ApiCommandStep addRolesItem(ApiRoleRef rolesItem) {
        if (this.roles == null) {
            this.roles = new ArrayList<ApiRoleRef>();
        }
        this.roles.add(rolesItem);
        return this;
    }

    @ApiModelProperty(value="List of command step roles.")
    public List<ApiRoleRef> getRoles() {
        return this.roles;
    }

    public void setRoles(List<ApiRoleRef> roles) {
        this.roles = roles;
    }

    public ApiCommandStep clusters(List<ApiClusterRef> clusters) {
        this.clusters = clusters;
        return this;
    }

    public ApiCommandStep addClustersItem(ApiClusterRef clustersItem) {
        if (this.clusters == null) {
            this.clusters = new ArrayList<ApiClusterRef>();
        }
        this.clusters.add(clustersItem);
        return this;
    }

    @ApiModelProperty(value="List of clusters associated with command step.")
    public List<ApiClusterRef> getClusters() {
        return this.clusters;
    }

    public void setClusters(List<ApiClusterRef> clusters) {
        this.clusters = clusters;
    }

    public ApiCommandStep hosts(List<ApiHostRef> hosts) {
        this.hosts = hosts;
        return this;
    }

    public ApiCommandStep addHostsItem(ApiHostRef hostsItem) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<ApiHostRef>();
        }
        this.hosts.add(hostsItem);
        return this;
    }

    @ApiModelProperty(value="List of hosts associated with command step.")
    public List<ApiHostRef> getHosts() {
        return this.hosts;
    }

    public void setHosts(List<ApiHostRef> hosts) {
        this.hosts = hosts;
    }

    public ApiCommandStep services(List<ApiServiceRef> services) {
        this.services = services;
        return this;
    }

    public ApiCommandStep addServicesItem(ApiServiceRef servicesItem) {
        if (this.services == null) {
            this.services = new ArrayList<ApiServiceRef>();
        }
        this.services.add(servicesItem);
        return this;
    }

    @ApiModelProperty(value="List of services associated with command step.")
    public List<ApiServiceRef> getServices() {
        return this.services;
    }

    public void setServices(List<ApiServiceRef> services) {
        this.services = services;
    }

    public ApiCommandStep children(List<ApiCommandStep> children) {
        this.children = children;
        return this;
    }

    public ApiCommandStep addChildrenItem(ApiCommandStep childrenItem) {
        if (this.children == null) {
            this.children = new ArrayList<ApiCommandStep>();
        }
        this.children.add(childrenItem);
        return this;
    }

    @ApiModelProperty(value="List of child command steps.")
    public List<ApiCommandStep> getChildren() {
        return this.children;
    }

    public void setChildren(List<ApiCommandStep> children) {
        this.children = children;
    }

    public ApiCommandStep commands(List<ApiCommand> commands) {
        this.commands = commands;
        return this;
    }

    public ApiCommandStep addCommandsItem(ApiCommand commandsItem) {
        if (this.commands == null) {
            this.commands = new ArrayList<ApiCommand>();
        }
        this.commands.add(commandsItem);
        return this;
    }

    @ApiModelProperty(value="List of subcommands. <p> The list contains only the summary view of the commands.")
    public List<ApiCommand> getCommands() {
        return this.commands;
    }

    public void setCommands(List<ApiCommand> commands) {
        this.commands = commands;
    }

    public ApiCommandStep remoteCommand(ApiRemoteCommand remoteCommand) {
        this.remoteCommand = remoteCommand;
        return this;
    }

    @ApiModelProperty(value="Remote command executed by the current step on a peer cluster.")
    public ApiRemoteCommand getRemoteCommand() {
        return this.remoteCommand;
    }

    public void setRemoteCommand(ApiRemoteCommand remoteCommand) {
        this.remoteCommand = remoteCommand;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiCommandStep apiCommandStep = (ApiCommandStep)o;
        return Objects.equals(this.description, apiCommandStep.description) && Objects.equals(this.startTime, apiCommandStep.startTime) && Objects.equals(this.endTime, apiCommandStep.endTime) && Objects.equals((Object)this.state, (Object)apiCommandStep.state) && Objects.equals(this.resultMessage, apiCommandStep.resultMessage) && Objects.equals(this.ignoreError, apiCommandStep.ignoreError) && Objects.equals(this.parallel, apiCommandStep.parallel) && Objects.equals(this.processes, apiCommandStep.processes) && Objects.equals(this.clientConfigs, apiCommandStep.clientConfigs) && Objects.equals(this.roles, apiCommandStep.roles) && Objects.equals(this.clusters, apiCommandStep.clusters) && Objects.equals(this.hosts, apiCommandStep.hosts) && Objects.equals(this.services, apiCommandStep.services) && Objects.equals(this.children, apiCommandStep.children) && Objects.equals(this.commands, apiCommandStep.commands) && Objects.equals(this.remoteCommand, apiCommandStep.remoteCommand);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.startTime, this.endTime, this.state, this.resultMessage, this.ignoreError, this.parallel, this.processes, this.clientConfigs, this.roles, this.clusters, this.hosts, this.services, this.children, this.commands, this.remoteCommand});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiCommandStep {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    resultMessage: ").append(this.toIndentedString(this.resultMessage)).append("\n");
        sb.append("    ignoreError: ").append(this.toIndentedString(this.ignoreError)).append("\n");
        sb.append("    parallel: ").append(this.toIndentedString(this.parallel)).append("\n");
        sb.append("    processes: ").append(this.toIndentedString(this.processes)).append("\n");
        sb.append("    clientConfigs: ").append(this.toIndentedString(this.clientConfigs)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    clusters: ").append(this.toIndentedString(this.clusters)).append("\n");
        sb.append("    hosts: ").append(this.toIndentedString(this.hosts)).append("\n");
        sb.append("    services: ").append(this.toIndentedString(this.services)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("    commands: ").append(this.toIndentedString(this.commands)).append("\n");
        sb.append("    remoteCommand: ").append(this.toIndentedString(this.remoteCommand)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

