/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.security.token;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.knox.gateway.util.JsonUtils;

public class TokenMetadata {
    public static final String USER_NAME = "userName";
    public static final String COMMENT = "comment";
    public static final String ENABLED = "enabled";
    public static final String PASSCODE = "passcode";
    public static final String CREATED_BY = "createdBy";
    private static final List<String> KNOWN_MD_NAMES = Arrays.asList("userName", "comment", "enabled", "passcode", "createdBy");
    private final Map<String, String> metadataMap = new HashMap<String, String>();

    public TokenMetadata(String userName) {
        this(userName, null);
    }

    public TokenMetadata(String userName, String comment) {
        this(userName, comment, true);
    }

    public TokenMetadata(String userName, String comment, boolean enabled) {
        this.saveMetadata(USER_NAME, userName);
        this.saveMetadata(COMMENT, comment);
        this.setEnabled(enabled);
    }

    private void saveMetadata(String key, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.metadataMap.put(key, value);
        }
    }

    public TokenMetadata(Map<String, String> metadataMap) {
        this.metadataMap.clear();
        this.metadataMap.putAll(metadataMap);
    }

    @JsonIgnore
    public Map<String, String> getMetadataMap() {
        return new HashMap<String, String>(this.metadataMap);
    }

    @JsonIgnore
    public String getMetadata(String key) {
        return this.metadataMap.get(key);
    }

    public Map<String, String> getCustomMetadataMap() {
        HashMap<String, String> customMetadataMap = new HashMap<String, String>();
        this.metadataMap.forEach((key, value) -> {
            if (!KNOWN_MD_NAMES.contains(key)) {
                customMetadataMap.put((String)key, (String)value);
            }
        });
        return customMetadataMap;
    }

    public String getUserName() {
        return this.getMetadata(USER_NAME);
    }

    public String getComment() {
        return this.getMetadata(COMMENT);
    }

    public void setEnabled(boolean enabled) {
        this.saveMetadata(ENABLED, String.valueOf(enabled));
    }

    public boolean isEnabled() {
        return Boolean.parseBoolean(this.getMetadata(ENABLED));
    }

    public void setPasscode(String passcode) {
        this.saveMetadata(PASSCODE, passcode);
    }

    @JsonIgnore
    public String getPasscode() {
        return this.getMetadata(PASSCODE);
    }

    public void setCreatedBy(String createdBy) {
        this.saveMetadata(CREATED_BY, createdBy);
    }

    public String getCreatedBy() {
        return this.getMetadata(CREATED_BY);
    }

    public String toJSON() {
        return JsonUtils.renderAsJsonString(this.metadataMap);
    }

    public static TokenMetadata fromJSON(String json) {
        Map metadataMap = JsonUtils.getMapFromJsonString((String)json);
        if (metadataMap != null) {
            return new TokenMetadata(metadataMap);
        }
        throw new IllegalArgumentException("Invalid metadata JSON: " + json);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public void add(String name, String value) {
        this.metadataMap.put(name, value);
    }
}

