/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.db.sdo;

import com.sun.xml.ws.db.sdo.HelperContextResolver;
import com.sun.xml.ws.db.sdo.SDOBond;
import com.sun.xml.ws.db.sdo.SDODatabindingException;
import com.sun.xml.ws.db.sdo.SDOSchemaCompiler;
import com.sun.xml.ws.db.sdo.SDOUtils;
import com.sun.xml.ws.db.sdo.SDOWrapperAccessor;
import com.sun.xml.ws.db.sdo.SchemaInfo;
import com.sun.xml.ws.db.sdo.Xsd2JavaSDOModel;
import com.sun.xml.ws.spi.db.BindingContext;
import com.sun.xml.ws.spi.db.BindingInfo;
import com.sun.xml.ws.spi.db.PropertyAccessor;
import com.sun.xml.ws.spi.db.ServiceArtifactSchemaGenerator;
import com.sun.xml.ws.spi.db.TypeInfo;
import com.sun.xml.ws.spi.db.WrapperBridge;
import com.sun.xml.ws.spi.db.WrapperComposite;
import com.sun.xml.ws.spi.db.XMLBridge;
import com.sun.xml.ws.util.xml.XmlUtil;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.TypeHelper;
import commonj.sdo.helper.XSDHelper;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.Version;
import org.eclipse.persistence.sdo.helper.SDOHelperContext;

public final class SDOContextWrapper
implements BindingContext {
    public static final String SDO_SCHEMA_INFO = "com.sun.xml.ws.db.sdo.SCHEMA_INFO";
    public static final String SDO_SCHEMA_FILE = "com.sun.xml.ws.db.sdo.SCHEMA_FILE";
    public static final String SDO_HELPER_CONTEXT_RESOLVER = "com.sun.xml.ws.db.sdo.HELPER_CONTEXT_RESOLVER";
    private Map<String, Object> properties;
    private Set<SchemaInfo> suppliedSchemas;
    private List<Source> schemas = null;
    private Map<Class<?>, SDOWrapperAccessor> wrapperAccessors;
    private Xsd2JavaSDOModel model;
    private HelperContextResolver contextResolver;
    private boolean isClient;
    private QName serviceName;
    private boolean initialized;
    private HelperContext defaultContext;
    private BindingInfo bindingInfo;

    public SDOContextWrapper(BindingInfo bi) {
        URL wsdlURL;
        this.properties = bi.properties();
        this.bindingInfo = bi;
        this.wrapperAccessors = new HashMap();
        this.contextResolver = (HelperContextResolver)this.properties.get(SDO_HELPER_CONTEXT_RESOLVER);
        if (this.contextResolver == null) {
            this.defaultContext = SDOHelperContext.getHelperContext();
            this.contextResolver = new HelperContextResolver(){

                @Override
                public HelperContext getHelperContext(boolean isClient, QName serviceName, Map<String, Object> properties) {
                    return SDOContextWrapper.this.defaultContext;
                }
            };
        }
        this.suppliedSchemas = (Set)this.properties.get(SDO_SCHEMA_INFO);
        if (this.suppliedSchemas == null && (wsdlURL = bi.getWsdlURL()) != null) {
            try {
                this.suppliedSchemas = SDOUtils.getSchemas(wsdlURL.getFile());
            }
            catch (Exception e) {
                throw new SDODatabindingException("uninitialized helper context", e);
            }
        }
        this.config(this.suppliedSchemas);
        SDOUtils.registerSDOContext(this.getHelperContext(), this.schemas);
        this.serviceName = null;
    }

    public void config(Set<SchemaInfo> schemas) {
        ArrayList<Source> list = new ArrayList<Source>();
        if (schemas == null) {
            return;
        }
        for (SchemaInfo schema : schemas) {
            Source src = schema.getSchemaSource();
            String systemId = schema.getSystemID();
            src.setSystemId(systemId);
            list.add(src);
        }
        this.init(list.iterator());
    }

    public HelperContext getHelperContext() {
        return this.contextResolver.getHelperContext(this.isClient, this.serviceName, this.properties);
    }

    public Object newWrapperInstace(Class<?> wrapperType) {
        return this.getHelperContext().getDataFactory().create(wrapperType);
    }

    public HelperContext getHelperContext(HelperContextResolver resolver, boolean isClient, QName serviceName, Map<String, Object> properties) {
        if (!this.initialized) {
            throw new SDODatabindingException("uninitialized helper context");
        }
        return resolver.getHelperContext(isClient, serviceName, properties);
    }

    public void init(Iterator<Source> i) {
        this.schemas = new ArrayList<Source>();
        while (i.hasNext()) {
            Source src = i.next();
            this.schemas.add(src);
        }
        this.initialized = true;
    }

    public void init(Source primaryWsdl) {
        this.schemas = SDOUtils.getSchemaClosureFromWSDL(primaryWsdl);
        this.initialized = true;
    }

    public Marshaller createMarshaller() throws JAXBException {
        return null;
    }

    public Unmarshaller createUnmarshaller() throws JAXBException {
        return null;
    }

    public JAXBContext getJAXBContext() {
        return null;
    }

    public boolean hasSwaRef() {
        return false;
    }

    public QName getElementName(Object o) throws JAXBException {
        return null;
    }

    public QName getElementName(Class o) throws JAXBException {
        return null;
    }

    public XMLBridge createBridge(TypeInfo ref) {
        return WrapperComposite.class.equals((Object)ref.type) ? new WrapperBridge((BindingContext)this, ref) : new SDOBond(this, ref);
    }

    public XMLBridge createFragmentBridge() {
        return new SDOBond(this, null);
    }

    public <B, V> PropertyAccessor<B, V> getElementPropertyAccessor(Class<B> wrapperBean, String nsUri, String localName) throws JAXBException {
        SDOWrapperAccessor wa = this.wrapperAccessors.get(wrapperBean);
        if (wa == null) {
            wa = new SDOWrapperAccessor(this, wrapperBean);
            this.wrapperAccessors.put(wrapperBean, wa);
        }
        return wa.getPropertyAccessor(nsUri, localName);
    }

    public List<String> getKnownNamespaceURIs() {
        return new ArrayList<String>();
    }

    public void generateSchema(SchemaOutputResolver outputResolver) throws IOException {
        try {
            TransformerFactory tf = XmlUtil.newTransformerFactory((boolean)false);
            Transformer tx = tf.newTransformer();
            for (SchemaInfo si : this.suppliedSchemas) {
                Result res = outputResolver.createOutput(si.getTargetNamespace(), si.getSystemID());
                if (si.getSchemaSource() != null) {
                    tx.transform(si.getSchemaSource(), res);
                    continue;
                }
                StreamSource ss = new StreamSource(si.getSchemaLocation());
                ss.setSystemId(si.getSystemID());
                tx.transform(si.getSchemaSource(), res);
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        SDOSchemaCompiler compiler = this.createSDOCompiler();
        this.model = compiler.bind();
        ServiceArtifactSchemaGenerator xsdgen = new ServiceArtifactSchemaGenerator(this.bindingInfo.getSEIModel());
        xsdgen.generate(outputResolver);
    }

    public SDOSchemaCompiler createSDOCompiler() {
        SDOSchemaCompiler compiler = new SDOSchemaCompiler();
        for (Source s : this.schemas) {
            compiler.parseSchema(s);
        }
        return compiler;
    }

    public QName getTypeName(TypeInfo tr) {
        QName res = this.model.getXsdTypeName(((Class)tr.type).getName());
        if (res != null) {
            return res;
        }
        HelperContext hc = this.contextResolver.getHelperContext(this.isClient, this.serviceName, this.properties);
        TypeHelper th = hc.getTypeHelper();
        Type t = th.getType((Class)tr.type);
        XSDHelper helper = hc.getXSDHelper();
        String localName = helper.getLocalName(t);
        String namespaceURI = helper.getNamespaceURI(t);
        if (namespaceURI == null) {
            namespaceURI = t.getURI();
        }
        if (localName == null) {
            localName = t.getName();
        }
        return new QName(namespaceURI == null ? "" : namespaceURI, localName);
    }

    public String getBuildId() {
        return Version.getBuildRevision();
    }
}

