/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.libraries.asm.AnnotationVisitor;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.FieldVisitor;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.libraries.asm.MethodVisitor;
import org.eclipse.persistence.internal.libraries.asm.ModuleVisitor;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.libraries.asm.TypePath;
import org.eclipse.persistence.internal.libraries.asm.TypeReference;
import org.eclipse.persistence.internal.libraries.asm.tree.ClassNode;
import org.eclipse.persistence.internal.libraries.asm.tree.MethodNode;
import org.eclipse.persistence.internal.libraries.asm.tree.TryCatchBlockNode;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.Analyzer;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.BasicValue;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.Frame;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.SimpleVerifier;
import org.eclipse.persistence.internal.libraries.asm.util.CheckAnnotationAdapter;
import org.eclipse.persistence.internal.libraries.asm.util.CheckFieldAdapter;
import org.eclipse.persistence.internal.libraries.asm.util.CheckMethodAdapter;
import org.eclipse.persistence.internal.libraries.asm.util.CheckModuleAdapter;
import org.eclipse.persistence.internal.libraries.asm.util.Textifier;
import org.eclipse.persistence.internal.libraries.asm.util.TraceMethodVisitor;

public class CheckClassAdapter
extends ClassVisitor {
    private static final String ERROR_AT = ": error at index ";
    private boolean checkDataFlow;
    private int version;
    private boolean visitCalled;
    private boolean visitModuleCalled;
    private boolean visitSourceCalled;
    private boolean visitOuterClassCalled;
    private boolean visitEndCalled;
    private Map<Label, Integer> labelInsnIndices = new HashMap<Label, Integer>();

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 1) {
            System.err.println("Verifies the given class.\nUsage: CheckClassAdapter <fully qualified class name or class file name>");
            return;
        }
        ClassReader classReader = stringArray[0].endsWith(".class") ? new ClassReader(new FileInputStream(stringArray[0])) : new ClassReader(stringArray[0]);
        CheckClassAdapter.verify(classReader, false, new PrintWriter(System.err));
    }

    public static void verify(ClassReader classReader, boolean bl, PrintWriter printWriter) {
        CheckClassAdapter.verify(classReader, null, bl, printWriter);
    }

    public static void verify(ClassReader classReader, ClassLoader classLoader, boolean bl, PrintWriter printWriter) {
        ClassNode classNode = new ClassNode();
        classReader.accept(new CheckClassAdapter(classNode, false), 2);
        Type type = classNode.superName == null ? null : Type.getObjectType(classNode.superName);
        List<MethodNode> list = classNode.methods;
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (String object : classNode.interfaces) {
            arrayList.add(Type.getObjectType(object));
        }
        for (MethodNode methodNode : list) {
            SimpleVerifier simpleVerifier = new SimpleVerifier(Type.getObjectType(classNode.name), type, arrayList, (classNode.access & 0x200) != 0);
            Analyzer<BasicValue> analyzer = new Analyzer<BasicValue>(simpleVerifier);
            if (classLoader != null) {
                simpleVerifier.setClassLoader(classLoader);
            }
            try {
                analyzer.analyze(classNode.name, methodNode);
            }
            catch (Exception exception) {
                exception.printStackTrace(printWriter);
            }
            if (!bl) continue;
            CheckClassAdapter.printAnalyzerResult(methodNode, analyzer, printWriter);
        }
        printWriter.flush();
    }

    static void printAnalyzerResult(MethodNode methodNode, Analyzer<BasicValue> analyzer, PrintWriter printWriter) {
        Textifier textifier = new Textifier();
        TraceMethodVisitor traceMethodVisitor = new TraceMethodVisitor(textifier);
        printWriter.println(methodNode.name + methodNode.desc);
        for (int i = 0; i < methodNode.instructions.size(); ++i) {
            methodNode.instructions.get(i).accept(traceMethodVisitor);
            StringBuilder object = new StringBuilder();
            Frame<BasicValue> frame = analyzer.getFrames()[i];
            if (frame == null) {
                object.append('?');
            } else {
                int n;
                for (n = 0; n < frame.getLocals(); ++n) {
                    object.append(CheckClassAdapter.getUnqualifiedName(frame.getLocal(n).toString())).append(' ');
                }
                object.append(" : ");
                for (n = 0; n < frame.getStackSize(); ++n) {
                    object.append(CheckClassAdapter.getUnqualifiedName(frame.getStack(n).toString())).append(' ');
                }
            }
            while (object.length() < methodNode.maxStack + methodNode.maxLocals + 1) {
                object.append(' ');
            }
            printWriter.print(Integer.toString(i + 100000).substring(1));
            printWriter.print(" " + object + " : " + textifier.text.get(textifier.text.size() - 1));
        }
        for (TryCatchBlockNode tryCatchBlockNode : methodNode.tryCatchBlocks) {
            tryCatchBlockNode.accept(traceMethodVisitor);
            printWriter.print(" " + textifier.text.get(textifier.text.size() - 1));
        }
        printWriter.println();
    }

    private static String getUnqualifiedName(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            return string;
        }
        int n2 = string.length();
        if (string.charAt(n2 - 1) == ';') {
            --n2;
        }
        return string.substring(n + 1, n2);
    }

    public CheckClassAdapter(ClassVisitor classVisitor) {
        this(classVisitor, true);
    }

    public CheckClassAdapter(ClassVisitor classVisitor, boolean bl) {
        this(393216, classVisitor, bl);
        if (this.getClass() != CheckClassAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected CheckClassAdapter(int n, ClassVisitor classVisitor, boolean bl) {
        super(n, classVisitor);
        this.checkDataFlow = bl;
    }

    @Override
    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        if (this.visitCalled) {
            throw new IllegalStateException("visit must be called only once");
        }
        this.visitCalled = true;
        this.checkState();
        CheckClassAdapter.checkAccess(n2, 194097);
        if (string == null) {
            throw new IllegalArgumentException("Illegal class name (null)");
        }
        if (!string.endsWith("package-info") && !string.endsWith("module-info")) {
            CheckMethodAdapter.checkInternalName(string, "class name");
        }
        if ("java/lang/Object".equals(string)) {
            if (string3 != null) {
                throw new IllegalArgumentException("The super class name of the Object class must be 'null'");
            }
        } else if (string.endsWith("module-info")) {
            if (string3 != null) {
                throw new IllegalArgumentException("The super class name of a module-info class must be 'null'");
            }
        } else {
            CheckMethodAdapter.checkInternalName(string3, "super class name");
        }
        if (string2 != null) {
            CheckClassAdapter.checkClassSignature(string2);
        }
        if ((n2 & 0x200) != 0 && !"java/lang/Object".equals(string3)) {
            throw new IllegalArgumentException("The super class name of interfaces must be 'java/lang/Object'");
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                CheckMethodAdapter.checkInternalName(stringArray[i], "interface name at index " + i);
            }
        }
        this.version = n;
        super.visit(n, n2, string, string2, string3, stringArray);
    }

    @Override
    public void visitSource(String string, String string2) {
        this.checkState();
        if (this.visitSourceCalled) {
            throw new IllegalStateException("visitSource can be called only once.");
        }
        this.visitSourceCalled = true;
        super.visitSource(string, string2);
    }

    @Override
    public ModuleVisitor visitModule(String string, int n, String string2) {
        this.checkState();
        if (this.visitModuleCalled) {
            throw new IllegalStateException("visitModule can be called only once.");
        }
        this.visitModuleCalled = true;
        CheckClassAdapter.checkFullyQualifiedName(string, "module name");
        CheckClassAdapter.checkAccess(n, 36896);
        CheckModuleAdapter checkModuleAdapter = new CheckModuleAdapter(this.api, super.visitModule(string, n, string2), (n & 0x20) != 0);
        checkModuleAdapter.classVersion = this.version;
        return checkModuleAdapter;
    }

    @Override
    public void visitOuterClass(String string, String string2, String string3) {
        this.checkState();
        if (this.visitOuterClassCalled) {
            throw new IllegalStateException("visitOuterClass can be called only once.");
        }
        this.visitOuterClassCalled = true;
        if (string == null) {
            throw new IllegalArgumentException("Illegal outer class owner");
        }
        if (string3 != null) {
            CheckMethodAdapter.checkMethodDescriptor(string3);
        }
        super.visitOuterClass(string, string2, string3);
    }

    @Override
    public void visitInnerClass(String string, String string2, String string3, int n) {
        this.checkState();
        CheckMethodAdapter.checkInternalName(string, "class name");
        if (string2 != null) {
            CheckMethodAdapter.checkInternalName(string2, "outer class name");
        }
        if (string3 != null) {
            int n2;
            for (n2 = 0; n2 < string3.length() && Character.isDigit(string3.charAt(n2)); ++n2) {
            }
            if (n2 == 0 || n2 < string3.length()) {
                CheckMethodAdapter.checkIdentifier(string3, n2, -1, "inner class name");
            }
        }
        CheckClassAdapter.checkAccess(n, 30239);
        super.visitInnerClass(string, string2, string3, n);
    }

    @Override
    public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        this.checkState();
        CheckClassAdapter.checkAccess(n, 151775);
        CheckMethodAdapter.checkUnqualifiedName(this.version, string, "field name");
        CheckMethodAdapter.checkDescriptor(string2, false);
        if (string3 != null) {
            CheckClassAdapter.checkFieldSignature(string3);
        }
        if (object != null) {
            CheckMethodAdapter.checkConstant(object);
        }
        return new CheckFieldAdapter(this.api, super.visitField(n, string, string2, string3, object));
    }

    @Override
    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        this.checkState();
        CheckClassAdapter.checkAccess(n, 138751);
        if (!"<init>".equals(string) && !"<clinit>".equals(string)) {
            CheckMethodAdapter.checkMethodIdentifier(this.version, string, "method name");
        }
        CheckMethodAdapter.checkMethodDescriptor(string2);
        if (string3 != null) {
            CheckClassAdapter.checkMethodSignature(string3);
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                CheckMethodAdapter.checkInternalName(stringArray[i], "exception name at index " + i);
            }
        }
        CheckMethodAdapter checkMethodAdapter = this.checkDataFlow ? new CheckMethodAdapter(this.api, n, string, string2, super.visitMethod(n, string, string2, string3, stringArray), this.labelInsnIndices) : new CheckMethodAdapter(this.api, super.visitMethod(n, string, string2, string3, stringArray), this.labelInsnIndices);
        checkMethodAdapter.version = this.version;
        return checkMethodAdapter;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        this.checkState();
        CheckMethodAdapter.checkDescriptor(string, false);
        return new CheckAnnotationAdapter(super.visitAnnotation(string, bl));
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        this.checkState();
        int n2 = new TypeReference(n).getSort();
        if (n2 != 0 && n2 != 17 && n2 != 16) {
            throw new IllegalArgumentException("Invalid type reference sort 0x" + Integer.toHexString(n2));
        }
        CheckClassAdapter.checkTypeRef(n);
        CheckMethodAdapter.checkDescriptor(string, false);
        return new CheckAnnotationAdapter(super.visitTypeAnnotation(n, typePath, string, bl));
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.checkState();
        if (attribute == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        super.visitAttribute(attribute);
    }

    @Override
    public void visitEnd() {
        this.checkState();
        this.visitEndCalled = true;
        super.visitEnd();
    }

    private void checkState() {
        if (!this.visitCalled) {
            throw new IllegalStateException("Cannot visit member before visit has been called.");
        }
        if (this.visitEndCalled) {
            throw new IllegalStateException("Cannot visit member after visitEnd has been called.");
        }
    }

    static void checkAccess(int n, int n2) {
        if ((n & ~n2) != 0) {
            throw new IllegalArgumentException("Invalid access flags: " + n);
        }
        int n3 = 7;
        if (Integer.bitCount(n & n3) > 1) {
            throw new IllegalArgumentException("public, protected and private are mutually exclusive: " + n);
        }
        if (Integer.bitCount(n & 0x410) > 1) {
            throw new IllegalArgumentException("final and abstract are mutually exclusive: " + n);
        }
    }

    static void checkFullyQualifiedName(String string, String string2) {
        try {
            int n;
            int n2 = 0;
            while ((n = string.indexOf(46, n2 + 1)) != -1) {
                CheckMethodAdapter.checkIdentifier(string, n2, n, null);
                n2 = n + 1;
            }
            CheckMethodAdapter.checkIdentifier(string, n2, string.length(), null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Invalid " + string2 + " (must be a fully qualified name): " + string);
        }
    }

    public static void checkClassSignature(String string) {
        int n = 0;
        if (CheckClassAdapter.getChar(string, 0) == '<') {
            n = CheckClassAdapter.checkTypeParameters(string, n);
        }
        n = CheckClassAdapter.checkClassTypeSignature(string, n);
        while (CheckClassAdapter.getChar(string, n) == 'L') {
            n = CheckClassAdapter.checkClassTypeSignature(string, n);
        }
        if (n != string.length()) {
            throw new IllegalArgumentException(string + ERROR_AT + n);
        }
    }

    public static void checkMethodSignature(String string) {
        int n = 0;
        if (CheckClassAdapter.getChar(string, 0) == '<') {
            n = CheckClassAdapter.checkTypeParameters(string, n);
        }
        n = CheckClassAdapter.checkChar('(', string, n);
        while ("ZCBSIFJDL[T".indexOf(CheckClassAdapter.getChar(string, n)) != -1) {
            n = CheckClassAdapter.checkJavaTypeSignature(string, n);
        }
        n = CheckClassAdapter.getChar(string, n = CheckClassAdapter.checkChar(')', string, n)) == 'V' ? ++n : CheckClassAdapter.checkJavaTypeSignature(string, n);
        while (CheckClassAdapter.getChar(string, n) == '^') {
            if (CheckClassAdapter.getChar(string, ++n) == 'L') {
                n = CheckClassAdapter.checkClassTypeSignature(string, n);
                continue;
            }
            n = CheckClassAdapter.checkTypeVariableSignature(string, n);
        }
        if (n != string.length()) {
            throw new IllegalArgumentException(string + ERROR_AT + n);
        }
    }

    public static void checkFieldSignature(String string) {
        int n = CheckClassAdapter.checkReferenceTypeSignature(string, 0);
        if (n != string.length()) {
            throw new IllegalArgumentException(string + ERROR_AT + n);
        }
    }

    private static int checkTypeParameters(String string, int n) {
        int n2 = n;
        n2 = CheckClassAdapter.checkChar('<', string, n2);
        n2 = CheckClassAdapter.checkTypeParameter(string, n2);
        while (CheckClassAdapter.getChar(string, n2) != '>') {
            n2 = CheckClassAdapter.checkTypeParameter(string, n2);
        }
        return n2 + 1;
    }

    private static int checkTypeParameter(String string, int n) {
        int n2 = n;
        n2 = CheckClassAdapter.checkIdentifier(string, n2);
        if ("L[T".indexOf(CheckClassAdapter.getChar(string, n2 = CheckClassAdapter.checkChar(':', string, n2))) != -1) {
            n2 = CheckClassAdapter.checkReferenceTypeSignature(string, n2);
        }
        while (CheckClassAdapter.getChar(string, n2) == ':') {
            n2 = CheckClassAdapter.checkReferenceTypeSignature(string, n2 + 1);
        }
        return n2;
    }

    private static int checkReferenceTypeSignature(String string, int n) {
        switch (CheckClassAdapter.getChar(string, n)) {
            case 'L': {
                return CheckClassAdapter.checkClassTypeSignature(string, n);
            }
            case '[': {
                return CheckClassAdapter.checkJavaTypeSignature(string, n + 1);
            }
        }
        return CheckClassAdapter.checkTypeVariableSignature(string, n);
    }

    private static int checkClassTypeSignature(String string, int n) {
        int n2 = n;
        n2 = CheckClassAdapter.checkChar('L', string, n2);
        n2 = CheckClassAdapter.checkIdentifier(string, n2);
        while (CheckClassAdapter.getChar(string, n2) == '/') {
            n2 = CheckClassAdapter.checkIdentifier(string, n2 + 1);
        }
        if (CheckClassAdapter.getChar(string, n2) == '<') {
            n2 = CheckClassAdapter.checkTypeArguments(string, n2);
        }
        while (CheckClassAdapter.getChar(string, n2) == '.') {
            if (CheckClassAdapter.getChar(string, n2 = CheckClassAdapter.checkIdentifier(string, n2 + 1)) != '<') continue;
            n2 = CheckClassAdapter.checkTypeArguments(string, n2);
        }
        return CheckClassAdapter.checkChar(';', string, n2);
    }

    private static int checkTypeArguments(String string, int n) {
        int n2 = n;
        n2 = CheckClassAdapter.checkChar('<', string, n2);
        n2 = CheckClassAdapter.checkTypeArgument(string, n2);
        while (CheckClassAdapter.getChar(string, n2) != '>') {
            n2 = CheckClassAdapter.checkTypeArgument(string, n2);
        }
        return n2 + 1;
    }

    private static int checkTypeArgument(String string, int n) {
        int n2 = n;
        char c = CheckClassAdapter.getChar(string, n2);
        if (c == '*') {
            return n2 + 1;
        }
        if (c == '+' || c == '-') {
            ++n2;
        }
        return CheckClassAdapter.checkReferenceTypeSignature(string, n2);
    }

    private static int checkTypeVariableSignature(String string, int n) {
        int n2 = n;
        n2 = CheckClassAdapter.checkChar('T', string, n2);
        n2 = CheckClassAdapter.checkIdentifier(string, n2);
        return CheckClassAdapter.checkChar(';', string, n2);
    }

    private static int checkJavaTypeSignature(String string, int n) {
        int n2 = n;
        switch (CheckClassAdapter.getChar(string, n2)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return n2 + 1;
            }
        }
        return CheckClassAdapter.checkReferenceTypeSignature(string, n2);
    }

    private static int checkIdentifier(String string, int n) {
        int n2 = n;
        if (!Character.isJavaIdentifierStart(CheckClassAdapter.getChar(string, n2))) {
            throw new IllegalArgumentException(string + ": identifier expected at index " + n2);
        }
        ++n2;
        while (Character.isJavaIdentifierPart(CheckClassAdapter.getChar(string, n2))) {
            ++n2;
        }
        return n2;
    }

    private static int checkChar(char c, String string, int n) {
        if (CheckClassAdapter.getChar(string, n) == c) {
            return n + 1;
        }
        throw new IllegalArgumentException(string + ": '" + c + "' expected at index " + n);
    }

    private static char getChar(String string, int n) {
        return n < string.length() ? string.charAt(n) : (char)'\u0000';
    }

    static void checkTypeRef(int n) {
        int n2 = 0;
        switch (n >>> 24) {
            case 0: 
            case 1: 
            case 22: {
                n2 = -65536;
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                n2 = -16777216;
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 66: {
                n2 = -256;
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                n2 = -16776961;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if ((n & ~n2) != 0) {
            throw new IllegalArgumentException("Invalid type reference 0x" + Integer.toHexString(n));
        }
    }
}

