/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedRouteControllerMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.RouteController;

@ManagedResource(description="Managed RouteController")
public class ManagedRouteController
extends ManagedService
implements ManagedRouteControllerMBean {
    private final RouteController controller;

    public ManagedRouteController(CamelContext context, RouteController controller) {
        super(context, (Service)controller);
        this.controller = controller;
    }

    public RouteController getRouteController() {
        return this.controller;
    }

    @Override
    public void init(ManagementStrategy strategy) {
    }

    public Collection<String> getControlledRoutes() {
        if (this.controller != null) {
            return this.controller.getControlledRoutes().stream().map(Route::getId).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public String getRouteStartupLoggingLevel() {
        if (this.controller != null) {
            return this.controller.getRouteStartupLoggingLevel().name();
        }
        return null;
    }
}

