/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vm;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.seda.BlockingQueueFactory;
import org.apache.camel.component.seda.QueueReference;
import org.apache.camel.component.seda.SedaComponent;
import org.apache.camel.component.vm.VmEndpoint;

@org.apache.camel.spi.annotations.Component(value="vm")
public class VmComponent
extends SedaComponent {
    protected static final Map<String, QueueReference> QUEUES = new HashMap<String, QueueReference>();
    protected static final Map<String, VmEndpoint> ENDPOINTS = new HashMap<String, VmEndpoint>();
    private static final AtomicInteger START_COUNTER = new AtomicInteger();

    public Map<String, QueueReference> getQueues() {
        return QUEUES;
    }

    public QueueReference getQueueReference(String key) {
        return QUEUES.get(key);
    }

    protected void doStart() throws Exception {
        super.doStart();
        START_COUNTER.incrementAndGet();
    }

    protected void doStop() throws Exception {
        if (START_COUNTER.decrementAndGet() <= 0) {
            this.getQueues().clear();
            ENDPOINTS.clear();
        }
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (ENDPOINTS.containsKey(uri)) {
            return (Endpoint)ENDPOINTS.get(uri);
        }
        VmEndpoint answer = (VmEndpoint)super.createEndpoint(uri, remaining, parameters);
        ENDPOINTS.put(uri, answer);
        return answer;
    }

    protected VmEndpoint createEndpoint(String endpointUri, Component component, BlockingQueueFactory<Exchange> queueFactory, int concurrentConsumers) {
        return new VmEndpoint(endpointUri, component, queueFactory, concurrentConsumers);
    }

    protected VmEndpoint createEndpoint(String endpointUri, Component component, BlockingQueue<Exchange> queue, int concurrentConsumers) {
        return new VmEndpoint(endpointUri, component, queue, concurrentConsumers);
    }
}

