/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.common.util.io.InputStreamWithChannel;

public class SftpInputStreamWithChannel
extends InputStreamWithChannel {
    private final SftpClient client;
    private final String path;
    private byte[] bb;
    private byte[] buffer;
    private int index;
    private int available;
    private SftpClient.CloseableHandle handle;
    private long offset;

    public SftpInputStreamWithChannel(SftpClient client, int bufferSize, String path, Collection<SftpClient.OpenMode> mode) throws IOException {
        this.client = Objects.requireNonNull(client, "No SFTP client instance");
        this.path = path;
        this.bb = new byte[1];
        this.buffer = new byte[bufferSize];
        this.handle = client.open(path, mode);
    }

    public final SftpClient getClient() {
        return this.client;
    }

    public final String getPath() {
        return this.path;
    }

    @Override
    public boolean isOpen() {
        return this.handle != null && this.handle.isOpen();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException("mark(" + readlimit + ") N/A");
    }

    @Override
    public long skip(long n) throws IOException {
        long skipLen;
        long newIndex = (long)this.index + n;
        long bufLen = Math.max(0L, (long)this.available);
        if (newIndex > bufLen) {
            long extraLen = newIndex - bufLen;
            this.offset += extraLen;
            skipLen = Math.max(0L, bufLen - (long)this.index) + extraLen;
            this.index = 0;
            this.available = 0;
        } else if (newIndex < 0L) {
            long startOffset = this.offset - bufLen;
            long newOffset = startOffset + newIndex;
            newOffset = Math.max(0L, newOffset);
            skipLen = (long)this.index - newIndex;
            this.offset = newOffset;
            this.index = 0;
            this.available = 0;
        } else {
            this.index = (int)newIndex;
            skipLen = Math.abs(n);
        }
        return skipLen;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.offset = 0L;
        this.index = 0;
        this.available = 0;
    }

    @Override
    public int read() throws IOException {
        int read = this.read(this.bb, 0, 1);
        if (read > 0) {
            return this.bb[0] & 0xFF;
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("read(" + this.getPath() + ") stream closed");
        }
        int idx = off;
        while (len > 0) {
            if (this.index >= this.available) {
                this.available = this.client.read(this.handle, this.offset, this.buffer, 0, this.buffer.length);
                if (this.available < 0) {
                    if (idx != off) break;
                    return -1;
                }
                this.offset += (long)this.available;
                this.index = 0;
            }
            if (this.index >= this.available) break;
            int nb = Math.min(len, this.available - this.index);
            System.arraycopy(this.buffer, this.index, b, idx, nb);
            this.index += nb;
            idx += nb;
            len -= nb;
        }
        return idx - off;
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen()) {
            try {
                this.handle.close();
            }
            finally {
                this.handle = null;
            }
        }
    }
}

