/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.processor.loadbalancer.QueueLoadBalancer;
import org.apache.camel.processor.loadbalancer.RoundRobinLoadBalancer;

public class StickyLoadBalancer
extends QueueLoadBalancer {
    private Expression correlationExpression;
    private RoundRobinLoadBalancer loadBalancer;
    private int numberOfHashGroups = 65536;
    private final Map<Object, AsyncProcessor> stickyMap = new ConcurrentHashMap<Object, AsyncProcessor>();

    public StickyLoadBalancer(Expression correlationExpression) {
        this.correlationExpression = correlationExpression;
        this.loadBalancer = new RoundRobinLoadBalancer();
    }

    @Override
    protected AsyncProcessor chooseProcessor(AsyncProcessor[] processors, Exchange exchange) {
        Object value = this.correlationExpression.evaluate(exchange, Object.class);
        Object key = this.getStickyKey(value);
        AsyncProcessor processor = this.stickyMap.computeIfAbsent(key, k -> this.loadBalancer.chooseProcessor(processors, exchange));
        return processor;
    }

    @Override
    public void removeProcessor(AsyncProcessor processor) {
        this.stickyMap.values().remove(processor);
        super.removeProcessor(processor);
    }

    public int getLastChosenProcessorIndex() {
        return this.loadBalancer.getLastChosenProcessorIndex();
    }

    public Expression getCorrelationExpression() {
        return this.correlationExpression;
    }

    public int getNumberOfHashGroups() {
        return this.numberOfHashGroups;
    }

    public void setNumberOfHashGroups(int numberOfHashGroups) {
        this.numberOfHashGroups = numberOfHashGroups;
    }

    protected Object getStickyKey(Object value) {
        int hashCode = 37;
        if (value != null) {
            hashCode = value.hashCode();
        }
        if (this.numberOfHashGroups > 0) {
            hashCode %= this.numberOfHashGroups;
        }
        return hashCode;
    }
}

