/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.server.common.FeatureVersion;
import org.apache.kafka.server.common.MetadataVersion;

public enum TestFeatureVersion implements FeatureVersion
{
    TEST_0(0, MetadataVersion.MINIMUM_KRAFT_VERSION, Collections.emptyMap()),
    TEST_1(1, MetadataVersion.IBP_3_7_IV0, Collections.emptyMap()),
    TEST_2(2, MetadataVersion.IBP_4_0_IV0, Collections.singletonMap("metadata.version", MetadataVersion.IBP_4_0_IV0.featureLevel()));

    private final short featureLevel;
    private final MetadataVersion metadataVersionMapping;
    private final Map<String, Short> dependencies;
    public static final String FEATURE_NAME = "test.feature.version";

    private TestFeatureVersion(int featureLevel, MetadataVersion metadataVersionMapping, Map<String, Short> dependencies) {
        this.featureLevel = (short)featureLevel;
        this.metadataVersionMapping = metadataVersionMapping;
        this.dependencies = dependencies;
    }

    @Override
    public short featureLevel() {
        return this.featureLevel;
    }

    @Override
    public String featureName() {
        return FEATURE_NAME;
    }

    @Override
    public MetadataVersion bootstrapMetadataVersion() {
        return this.metadataVersionMapping;
    }

    @Override
    public Map<String, Short> dependencies() {
        return this.dependencies;
    }
}

