/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.KafkaConfig;
import kafka.utils.Implicits$;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.server.config.AbstractKafkaConfig;
import org.apache.kafka.server.config.ZkConfigs;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.zookeeper.client.ZKClientConfig;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;

public final class KafkaConfig$ {
    public static KafkaConfig$ MODULE$;
    private final ConfigDef configDef;

    static {
        new KafkaConfig$();
    }

    public void main(String[] args) {
        System.out.println(this.configDef().toHtml(4, config -> new StringBuilder(14).append("brokerconfigs_").append((String)config).toString(), DynamicBrokerConfig$.MODULE$.dynamicConfigUpdateModes()));
    }

    public Option<String> zooKeeperClientProperty(ZKClientConfig clientConfig, String kafkaPropName) {
        return Option$.MODULE$.apply((Object)clientConfig.getProperty((String)ZkConfigs.ZK_SSL_CONFIG_TO_SYSTEM_PROPERTY_MAP.get(kafkaPropName)));
    }

    public void setZooKeeperClientProperty(ZKClientConfig clientConfig, String kafkaPropName, Object kafkaPropValue) {
        String string;
        String string2 = (String)ZkConfigs.ZK_SSL_CONFIG_TO_SYSTEM_PROPERTY_MAP.get(kafkaPropName);
        if ("zookeeper.ssl.endpoint.identification.algorithm".equals(kafkaPropName)) {
            String string3 = kafkaPropValue.toString().toUpperCase();
            String string4 = "HTTPS";
            string = Boolean.toString(string3 != null && string3.equals(string4));
        } else if ("zookeeper.ssl.enabled.protocols".equals(kafkaPropName) ? true : "zookeeper.ssl.cipher.suites".equals(kafkaPropName)) {
            if (kafkaPropValue instanceof List) {
                List list = (List)kafkaPropValue;
                string = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(list).asScala()).mkString(",");
            } else {
                string = kafkaPropValue.toString();
            }
        } else {
            string = kafkaPropValue.toString();
        }
        clientConfig.setProperty(string2, string);
    }

    public boolean zkTlsClientAuthEnabled(ZKClientConfig zkClientConfig) {
        return this.zooKeeperClientProperty(zkClientConfig, "zookeeper.ssl.client.enable").contains((Object)"true") && this.zooKeeperClientProperty(zkClientConfig, "zookeeper.clientCnxnSocket").isDefined() && this.zooKeeperClientProperty(zkClientConfig, "zookeeper.ssl.keystore.location").isDefined();
    }

    public ConfigDef configDef() {
        return this.configDef;
    }

    public Seq<String> configNames() {
        return (Seq)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(this.configDef().names()).asScala()).toBuffer().sorted((Ordering)Ordering.String$.MODULE$);
    }

    public Map<String, ?> defaultValues() {
        return (Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(this.configDef().defaultValues()).asScala();
    }

    public Map<String, ConfigDef.ConfigKey> configKeys() {
        return (Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(this.configDef().configKeys()).asScala();
    }

    public KafkaConfig fromProps(Properties props) {
        return this.fromProps(props, true);
    }

    public KafkaConfig fromProps(Properties props, boolean doLog) {
        return new KafkaConfig(props, doLog);
    }

    public KafkaConfig fromProps(Properties defaults, Properties overrides) {
        return this.fromProps(defaults, overrides, true);
    }

    public KafkaConfig fromProps(Properties defaults, Properties overrides, boolean doLog) {
        Properties props = new Properties();
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(defaults);
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(overrides);
        return this.fromProps(props, doLog);
    }

    public KafkaConfig apply(java.util.Map<?, ?> props, boolean doLog) {
        return new KafkaConfig(props, doLog);
    }

    public boolean apply$default$2() {
        return true;
    }

    private Option<ConfigDef.Type> typeOf(String name) {
        return Option$.MODULE$.apply(this.configDef().configKeys().get(name)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.type);
    }

    public Option<ConfigDef.Type> configType(String configName) {
        Option<ConfigDef.Type> configType = this.configTypeExact(configName);
        if (configType.isDefined()) {
            return configType;
        }
        Option<ConfigDef.Type> option = this.typeOf(configName);
        if (option instanceof Some) {
            ConfigDef.Type t = (ConfigDef.Type)((Some)option).value();
            return new Some((Object)t);
        }
        if (None$.MODULE$.equals(option)) {
            return ((TraversableLike)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(configName, true).flatMap((Function1 & Serializable & scala.Serializable)name -> Option$.MODULE$.option2Iterable(MODULE$.typeOf((String)name)), List$.MODULE$.canBuildFrom())).headOption();
        }
        throw new MatchError(option);
    }

    private Option<ConfigDef.Type> configTypeExact(String exactName) {
        ConfigDef.Type configType = (ConfigDef.Type)this.typeOf(exactName).orNull(Predef$.MODULE$.$conforms());
        if (configType != null) {
            return new Some((Object)configType);
        }
        ConfigDef.ConfigKey configKey = DynamicConfig$Broker$.MODULE$.configKeys().get(exactName);
        if (configKey != null) {
            return new Some((Object)configKey.type);
        }
        return None$.MODULE$;
    }

    public boolean maybeSensitive(Option<ConfigDef.Type> configType) {
        return configType.isEmpty() || configType.contains((Object)ConfigDef.Type.PASSWORD);
    }

    public String loggableValue(ConfigResource.Type resourceType, String name, String value) {
        if (ConfigResource.Type.BROKER.equals(resourceType) ? this.maybeSensitive(this.configType(name)) : (ConfigResource.Type.TOPIC.equals(resourceType) ? this.maybeSensitive((Option<ConfigDef.Type>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(LogConfig.configType((String)name)))) : (ConfigResource.Type.BROKER_LOGGER.equals(resourceType) ? false : !ConfigResource.Type.CLIENT_METRICS.equals(resourceType)))) {
            return "[hidden]";
        }
        return value;
    }

    public java.util.Map<Object, Object> populateSynonyms(java.util.Map<?, ?> input) {
        HashMap<Object, Object> output = new HashMap<Object, Object>(input);
        Object brokerId = output.get("broker.id");
        Object nodeId = output.get("node.id");
        if (brokerId == null && nodeId != null) {
            output.put("broker.id", nodeId);
        } else if (brokerId != null && nodeId == null) {
            output.put("node.id", brokerId);
        }
        return output;
    }

    private KafkaConfig$() {
        MODULE$ = this;
        this.configDef = AbstractKafkaConfig.CONFIG_DEF;
    }
}

