/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.tools.DumpLogSegments$;
import org.apache.kafka.common.message.ConsumerProtocolAssignment;
import org.apache.kafka.common.message.ConsumerProtocolAssignmentJsonConverter;
import org.apache.kafka.common.message.ConsumerProtocolSubscription;
import org.apache.kafka.common.message.ConsumerProtocolSubscriptionJsonConverter;
import org.apache.kafka.common.metadata.MetadataJsonConverters;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.group.CoordinatorRecord;
import org.apache.kafka.coordinator.group.CoordinatorRecordSerde;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentKeyJsonConverter;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentValueJsonConverter;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataKeyJsonConverter;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValueJsonConverter;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataKeyJsonConverter;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataValueJsonConverter;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataKeyJsonConverter;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataValueJsonConverter;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberKeyJsonConverter;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberValueJsonConverter;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataKeyJsonConverter;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataValueJsonConverter;
import org.apache.kafka.coordinator.group.generated.GroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.GroupMetadataKeyJsonConverter;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValueJsonConverter;
import org.apache.kafka.coordinator.group.generated.OffsetCommitKey;
import org.apache.kafka.coordinator.group.generated.OffsetCommitKeyJsonConverter;
import org.apache.kafka.coordinator.group.generated.OffsetCommitValue;
import org.apache.kafka.coordinator.group.generated.OffsetCommitValueJsonConverter;
import org.apache.kafka.coordinator.group.runtime.CoordinatorLoader;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.tools.api.Decoder;
import org.apache.kafka.tools.api.StringDecoder;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r=x!\u0002-Z\u0011\u0003qf!\u00021Z\u0011\u0003\t\u0007\"\u00025\u0002\t\u0003I\u0007\u0002\u00036\u0002\u0005\u0004%\t!W6\t\rQ\f\u0001\u0015!\u0003m\u0011\u0015)\u0018\u0001\"\u0001w\u0011\u001d\t\u0019\"\u0001C\u0005\u0003+Aq!a\n\u0002\t\u0013\tI\u0003\u0003\u0005\u0002.\u0005!\t!WA\u0018\u0011!\ti(\u0001C\u00013\u0006}dACAl\u0003A\u0005\u0019\u0013A.\u0002Z\"9\u0011Q\u001c\u0006\u0007\u0002\u0005}gA\u0002B\u0012\u0003\u0011\u0011)\u0003\u0003\u0006\u000341\u0011\t\u0011)A\u0005\u0005kA!Ba\u0011\r\u0005\u0003\u0005\u000b\u0011\u0002B#\u0011\u0019AG\u0002\"\u0001\u0003H!9\u0011Q\u001c\u0007\u0005B\t=\u0003b\u0002B-\u0003\u0011%!1\f\u0005\b\u0005\u000f\u000bA\u0011\u0002BE\r\u0019\ty)\u0001\u0001\u0002\u0012\"1\u0001n\u0005C\u0001\u0003'C\u0011\"!&\u0014\u0005\u0004%\t!a&\t\u0011\u0005\u00056\u0003)A\u0005\u00033C\u0011\"a)\u0014\u0005\u0004%\t!a&\t\u0011\u0005\u00156\u0003)A\u0005\u00033C\u0011\"a*\u0014\u0005\u0004%\t!a&\t\u0011\u0005%6\u0003)A\u0005\u00033Cq!a+\u0014\t\u0003\ti\u000bC\u0004\u0002:N!\t!a/\t\u000f\u0005\u00157\u0003\"\u0001\u0002H\"9\u00111[\n\u0005\u0002\u0005UgA\u0002BQ\u0003\u0001\u0011\u0019\u000b\u0003\u0004i?\u0011\u0005!q\u0015\u0005\n\u0005W{\"\u0019!C\u0005\u0005[C\u0001Ba0 A\u0003%!q\u0016\u0005\b\u0005\u0003|B\u0011\u0002Bb\u0011\u001d\u0011yn\bC\u0005\u0005CDqaa\u0003 \t\u0013\u0019i\u0001C\u0004\u0002^~!\tea\u0005\u0007\r\rm\u0011\u0001BB\u000f\u0011\u0019Aw\u0005\"\u0001\u0004 !9\u0011Q\\\u0014\u0005B\r\rbABB\u0014\u0003\u0011\u0019I\u0003\u0003\u0004iU\u0011\u000511\u0006\u0005\n\u0007_Q#\u0019!C\u0005\u0007cA\u0001ba\u0010+A\u0003%11\u0007\u0005\b\u0003;TC\u0011IB!\r\u0019\u0019)%\u0001\u0003\u0004H!A1p\fB\u0001B\u0003%A\u0010\u0003\u0004i_\u0011\u00051\u0011\f\u0005\n\u0007?z#\u0019!C\u0005\u0007CB\u0001ba\u001c0A\u0003%11\r\u0005\n\u0007cz#\u0019!C\u0005\u0007CB\u0001ba\u001d0A\u0003%11\r\u0005\n\u0007kz#\u0019!C\u0005\u0007CB\u0001ba\u001e0A\u0003%11\r\u0005\n\u0007sz#\u0019!C\u0005\u0007wB\u0001ba!0A\u0003%1Q\u0010\u0005\n\u0007\u000b{#\u0019!C\u0005\u0007\u000fC\u0001b!%0A\u0003%1\u0011\u0012\u0005\n\u0007'{#\u0019!C\u0005\u0007\u000fC\u0001b!&0A\u0003%1\u0011\u0012\u0005\n\u0007/{#\u0019!C\u0005\u0007CB\u0001b!'0A\u0003%11\r\u0005\n\u00077{#\u0019!C\u0005\u0007;C\u0001b!)0A\u0003%1q\u0014\u0005\n\u0007G{#\u0019!C\u0005\u0007;C\u0001b!*0A\u0003%1q\u0014\u0005\n\u0007O{#\u0019!C\u0005\u0007CB\u0001b!+0A\u0003%11\r\u0005\n\u0007W{#\u0019!C\u0005\u0007CB\u0001b!,0A\u0003%11\r\u0005\n\u0007_{#\u0019!C\u0005\u0007CB\u0001b!-0A\u0003%11\r\u0005\n\u0007g{#\u0019!C\u0005\u0007CB\u0001b!.0A\u0003%11\r\u0005\b\u0007o{C\u0011AB]\u0011)\u0019Ym\fEC\u0002\u0013\u00051Q\u001a\u0005\u000b\u0005\u0003{\u0003R1A\u0005\u0002\r5\u0007B\u0003B5_!\u0015\r\u0011\"\u0001\u0004N\"Q\u0011qH\u0018\t\u0006\u0004%\ta!4\t\u0015\u0005Ur\u0006#b\u0001\n\u0003\u0019i\r\u0003\u0006\u0004P>B)\u0019!C\u0001\u0007#D!\"!\u001e0\u0011\u000b\u0007I\u0011ABj\u0011)\u0011)i\fEC\u0002\u0013\u000511\u001b\u0005\b\u0007+|C\u0011AAk\u0011!\u00199.\u0001C\u00013\u000ee\u0007\u0002CBu\u0003\u0011\u0005\u0011la;\u0002\u001f\u0011+X\u000e\u001d'pON+w-\\3oiNT!AW.\u0002\u000bQ|w\u000e\\:\u000b\u0003q\u000bQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002`\u00035\t\u0011LA\bEk6\u0004Hj\\4TK\u001elWM\u001c;t'\t\t!\r\u0005\u0002dM6\tAMC\u0001f\u0003\u0015\u00198-\u00197b\u0013\t9GM\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\u000bABU3d_J$\u0017J\u001c3f]R,\u0012\u0001\u001c\t\u0003[Jl\u0011A\u001c\u0006\u0003_B\fA\u0001\\1oO*\t\u0011/\u0001\u0003kCZ\f\u0017BA:o\u0005\u0019\u0019FO]5oO\u0006i!+Z2pe\u0012Le\u000eZ3oi\u0002\nA!\\1j]R\u0011qO\u001f\t\u0003GbL!!\u001f3\u0003\tUs\u0017\u000e\u001e\u0005\u0006w\u0016\u0001\r\u0001`\u0001\u0005CJ<7\u000fE\u0002d{~L!A 3\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0005\u0005\u0011q\u0002\b\u0005\u0003\u0007\tY\u0001E\u0002\u0002\u0006\u0011l!!a\u0002\u000b\u0007\u0005%Q,\u0001\u0004=e>|GOP\u0005\u0004\u0003\u001b!\u0017A\u0002)sK\u0012,g-C\u0002t\u0003#Q1!!\u0004e\u00031!W/\u001c9Uq:Le\u000eZ3y)\r9\u0018q\u0003\u0005\b\u000331\u0001\u0019AA\u000e\u0003\u00111\u0017\u000e\\3\u0011\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\tq\u0003\tIw.\u0003\u0003\u0002&\u0005}!\u0001\u0002$jY\u0016\fa\u0003Z;naB\u0013x\u000eZ;dKJLEm\u00158baNDw\u000e\u001e\u000b\u0004o\u0006-\u0002bBA\r\u000f\u0001\u0007\u00111D\u0001\nIVl\u0007/\u00138eKb$2b^A\u0019\u0003g\ti$!\u0011\u0002t!9\u0011\u0011\u0004\u0005A\u0002\u0005m\u0001bBA\u001b\u0011\u0001\u0007\u0011qG\u0001\u0010S:$W\r_*b]&$\u0018p\u00148msB\u00191-!\u000f\n\u0007\u0005mBMA\u0004C_>dW-\u00198\t\u000f\u0005}\u0002\u00021\u0001\u00028\u0005Qa/\u001a:jMf|e\u000e\\=\t\u000f\u0005\r\u0003\u00021\u0001\u0002F\u0005QR.[:NCR\u001c\u0007.Z:G_JLe\u000eZ3y\r&dWm]'baB9\u0011qIA)\u007f\u0006USBAA%\u0015\u0011\tY%!\u0014\u0002\u000f5,H/\u00192mK*\u0019\u0011q\n3\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002T\u0005%#aA'baB1\u0011qKA1\u0003OrA!!\u0017\u0002^9!\u0011QAA.\u0013\u0005)\u0017bAA0I\u00069\u0001/Y2lC\u001e,\u0017\u0002BA2\u0003K\u0012A\u0001T5ti*\u0019\u0011q\f3\u0011\u000f\r\fI'!\u001c\u0002n%\u0019\u00111\u000e3\u0003\rQ+\b\u000f\\33!\r\u0019\u0017qN\u0005\u0004\u0003c\"'\u0001\u0002'p]\u001eDq!!\u001e\t\u0001\u0004\t9(\u0001\bnCblUm]:bO\u0016\u001c\u0016N_3\u0011\u0007\r\fI(C\u0002\u0002|\u0011\u00141!\u00138u\u00035!W/\u001c9US6,\u0017J\u001c3fqRIq/!!\u0002\u0004\u0006\u0015\u0015q\u0011\u0005\b\u00033I\u0001\u0019AA\u000e\u0011\u001d\t)$\u0003a\u0001\u0003oAq!a\u0010\n\u0001\u0004\t9\u0004C\u0004\u0002\n&\u0001\r!a#\u0002'QLW.Z%oI\u0016DH)^7q\u000bJ\u0014xN]:\u0011\u0007\u000555#D\u0001\u0002\u0005M!\u0016.\\3J]\u0012,\u0007\u0010R;na\u0016\u0013(o\u001c:t'\t\u0019\"\r\u0006\u0002\u0002\f\u0006qR.[:NCR\u001c\u0007.Z:G_J$\u0016.\\3J]\u0012,\u0007PR5mKNl\u0015\r]\u000b\u0003\u00033\u0003r!a\u0012\u0002R}\fY\n\u0005\u0004\u0002H\u0005u\u0015qM\u0005\u0005\u0003?\u000bIEA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\u0018aH7jg6\u000bGo\u00195fg\u001a{'\u000fV5nK&sG-\u001a=GS2,7/T1qA\u0005\u0019r.\u001e;PM>\u0013H-\u001a:US6,7\u000f^1na\u0006!r.\u001e;PM>\u0013H-\u001a:US6,7\u000f^1na\u0002\nQc\u001d5bY2|wo\u00144gg\u0016$hj\u001c;G_VtG-\u0001\ftQ\u0006dGn\\<PM\u001a\u001cX\r\u001e(pi\u001a{WO\u001c3!\u0003]\u0011XmY8sI6K7/\\1uG\"$\u0016.\\3J]\u0012,\u0007\u0010F\u0004x\u0003_\u000b\t,!.\t\u000f\u0005e1\u00041\u0001\u0002\u001c!9\u00111W\u000eA\u0002\u00055\u0014AD5oI\u0016DH+[7fgR\fW\u000e\u001d\u0005\b\u0003o[\u0002\u0019AA7\u00031awn\u001a+j[\u0016\u001cH/Y7q\u0003y\u0011XmY8sI>+Ho\u00144Pe\u0012,'/\u00138eKb$\u0016.\\3ti\u0006l\u0007\u000fF\u0004x\u0003{\u000by,!1\t\u000f\u0005eA\u00041\u0001\u0002\u001c!9\u00111\u0017\u000fA\u0002\u00055\u0004bBAb9\u0001\u0007\u0011QN\u0001\u0013aJ,g/\u00138eKb$\u0016.\\3ti\u0006l\u0007/A\u000esK\u000e|'\u000fZ*iC2dwn^(gMN,GOT8u\r>,h\u000e\u001a\u000b\bo\u0006%\u00171ZAh\u0011\u001d\tI\"\ba\u0001\u00037Aq!!4\u001e\u0001\u0004\ti'A\u0006j]\u0012,\u0007p\u00144gg\u0016$\bbBAi;\u0001\u0007\u0011QN\u0001\nY><wJ\u001a4tKR\f1\u0002\u001d:j]R,%O]8sgR\tqOA\u0007NKN\u001c\u0018mZ3QCJ\u001cXM]\u000b\u0007\u00037\fiOa\u0001\u0014\u0005)\u0011\u0017!\u00029beN,G\u0003BAq\u0005\u000f\u0001raYA5\u0003G\fy\u0010E\u0003d\u0003K\fI/C\u0002\u0002h\u0012\u0014aa\u00149uS>t\u0007\u0003BAv\u0003[d\u0001\u0001B\u0004\u0002p*\u0011\r!!=\u0003\u0003-\u000bB!a=\u0002zB\u00191-!>\n\u0007\u0005]HMA\u0004O_RD\u0017N\\4\u0011\u0007\r\fY0C\u0002\u0002~\u0012\u00141!\u00118z!\u0015\u0019\u0017Q\u001dB\u0001!\u0011\tYOa\u0001\u0005\u000f\t\u0015!B1\u0001\u0002r\n\ta\u000bC\u0004\u0003\n-\u0001\rAa\u0003\u0002\rI,7m\u001c:e!\u0011\u0011iAa\b\u000e\u0005\t=!\u0002\u0002B\u0005\u0005#QAAa\u0005\u0003\u0016\u000511m\\7n_:T1\u0001\u0018B\f\u0015\u0011\u0011IBa\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\u0011i\"A\u0002pe\u001eLAA!\t\u0003\u0010\t1!+Z2pe\u0012\u0014A\u0003R3d_\u0012,'/T3tg\u0006<W\rU1sg\u0016\u0014XC\u0002B\u0014\u0005[\u0011\td\u0005\u0003\rE\n%\u0002cBAG\u0015\t-\"q\u0006\t\u0005\u0003W\u0014i\u0003B\u0004\u0002p2\u0011\r!!=\u0011\t\u0005-(\u0011\u0007\u0003\b\u0005\u000ba!\u0019AAy\u0003)YW-\u001f#fG>$WM\u001d\t\u0007\u0005o\u0011yDa\u000b\u000e\u0005\te\"\u0002\u0002B\u001e\u0005{\t1!\u00199j\u0015\rQ&QC\u0005\u0005\u0005\u0003\u0012IDA\u0004EK\u000e|G-\u001a:\u0002\u0019Y\fG.^3EK\u000e|G-\u001a:\u0011\r\t]\"q\bB\u0018)\u0019\u0011IEa\u0013\u0003NA9\u0011Q\u0012\u0007\u0003,\t=\u0002b\u0002B\u001a\u001f\u0001\u0007!Q\u0007\u0005\b\u0005\u0007z\u0001\u0019\u0001B#)\u0011\u0011\tFa\u0016\u0011\u000f\r\fIGa\u0015\u0003VA)1-!:\u0003,A)1-!:\u00030!9!\u0011\u0002\tA\u0002\t-\u0011a\u00023v[Bdun\u001a\u000b\u0010o\nu#q\fB2\u0005O\u0012YGa \u0003\u0004\"9\u0011\u0011D\tA\u0002\u0005m\u0001b\u0002B1#\u0001\u0007\u0011qG\u0001\u000eaJLg\u000e^\"p]R,g\u000e^:\t\u000f\t\u0015\u0014\u00031\u0001\u0002F\u0005\tcn\u001c8D_:\u001cXmY;uSZ,\u0007+Y5sg\u001a{'\u000fT8h\r&dWm]'ba\"9!\u0011N\tA\u0002\u0005]\u0012aD5t\t\u0016,\u0007/\u0013;fe\u0006$\u0018n\u001c8\t\u000f\t5\u0014\u00031\u0001\u0003p\u00051\u0001/\u0019:tKJ\u0004dA!\u001d\u0003v\tm\u0004cBAG\u0015\tM$\u0011\u0010\t\u0005\u0003W\u0014)\b\u0002\u0007\u0003x\t-\u0014\u0011!A\u0001\u0006\u0003\t\tPA\u0002`IE\u0002B!a;\u0003|\u0011a!Q\u0010B6\u0003\u0003\u0005\tQ!\u0001\u0002r\n\u0019q\f\n\u001a\t\u000f\t\u0005\u0015\u00031\u0001\u00028\u0005\u00112o[5q%\u0016\u001cwN\u001d3NKR\fG-\u0019;b\u0011\u001d\u0011))\u0005a\u0001\u0003o\n\u0001\"\\1y\u0005f$Xm]\u0001\u0010aJLg\u000e\u001e\"bi\u000eDG*\u001a<fYR)qOa#\u0003\u001e\"9!Q\u0012\nA\u0002\t=\u0015!\u00022bi\u000eD\u0007\u0003\u0002BI\u0005/sAA!\u0004\u0003\u0014&!!Q\u0013B\b\u0003I1\u0015\u000e\\3M_\u001eLe\u000e];u'R\u0014X-Y7\n\t\te%1\u0014\u0002\u0017\r&dWm\u00115b]:,GNU3d_J$')\u0019;dQ*!!Q\u0013B\b\u0011\u001d\u0011yJ\u0005a\u0001\u0003[\n\u0011#Y2dk6,H.\u0019;jm\u0016\u0014\u0015\u0010^3t\u0005QyeMZ:fiNlUm]:bO\u0016\u0004\u0016M]:feN!qD\u0019BS!\u0015\tiIC@\u0000)\t\u0011I\u000bE\u0002\u0002\u000e~\tQa]3sI\u0016,\"Aa,\u0011\t\tE&1X\u0007\u0003\u0005gSAA!.\u00038\u0006)qM]8va*!!\u0011\u0018B\u000b\u0003-\u0019wn\u001c:eS:\fGo\u001c:\n\t\tu&1\u0017\u0002\u0017\u0007>|'\u000fZ5oCR|'OU3d_J$7+\u001a:eK\u000611/\u001a:eK\u0002\n!\u0002\u001d:fa\u0006\u0014XmS3z)\u0015y(Q\u0019Bk\u0011\u001d\u00119m\ta\u0001\u0005\u0013\fq!\\3tg\u0006<W\r\u0005\u0003\u0003L\nEWB\u0001Bg\u0015\u0011\u0011yM!\u0005\u0002\u0011A\u0014x\u000e^8d_2LAAa5\u0003N\n9Q*Z:tC\u001e,\u0007b\u0002BlG\u0001\u0007!\u0011\\\u0001\bm\u0016\u00148/[8o!\r\u0019'1\\\u0005\u0004\u0005;$'!B*i_J$\u0018!\u00079sKB\f'/Z$s_V\u0004X*\u001a;bI\u0006$\u0018MV1mk\u0016$bAa9\u0003|\u000e%\u0001\u0003\u0002Bs\u0005ol!Aa:\u000b\t\t%(1^\u0001\tI\u0006$\u0018MY5oI*!!Q\u001eBx\u0003\u001dQ\u0017mY6t_:TAA!=\u0003t\u0006Ia-Y:uKJDX\u000e\u001c\u0006\u0003\u0005k\f1aY8n\u0013\u0011\u0011IPa:\u0003\u0011)\u001bxN\u001c(pI\u0016DqAa2%\u0001\u0004\u0011i\u0010\u0005\u0003\u0003\u0000\u000e\u0015QBAB\u0001\u0015\u0011\u0019\u0019Aa-\u0002\u0013\u001d,g.\u001a:bi\u0016$\u0017\u0002BB\u0004\u0007\u0003\u0011!c\u0012:pkBlU\r^1eCR\fg+\u00197vK\"9!q\u001b\u0013A\u0002\te\u0017\u0001\u00049sKB\f'/\u001a,bYV,G#B@\u0004\u0010\rE\u0001b\u0002BdK\u0001\u0007!\u0011\u001a\u0005\b\u0005/,\u0003\u0019\u0001Bm)\u0011\u0019)b!\u0007\u0011\u000f\r\fIga\u0006\u0004\u0018A!1-!:\u0000\u0011\u001d\u0011IA\na\u0001\u0005\u0017\u00111\u0004\u0016:b]N\f7\r^5p]2{w-T3tg\u0006<W\rU1sg\u0016\u00148\u0003B\u0014c\u0005K#\"a!\t\u0011\u0007\u00055u\u0005\u0006\u0003\u0004\u0016\r\u0015\u0002b\u0002B\u0005S\u0001\u0007!1\u0002\u0002 \u00072,8\u000f^3s\u001b\u0016$\u0018\rZ1uC2{w-T3tg\u0006<W\rU1sg\u0016\u00148\u0003\u0002\u0016c\u0005K#\"a!\f\u0011\u0007\u00055%&A\nnKR\fG-\u0019;b%\u0016\u001cwN\u001d3TKJ$W-\u0006\u0002\u00044A!1QGB\u001e\u001b\t\u00199D\u0003\u0003\u0004:\tU\u0011\u0001C7fi\u0006$\u0017\r^1\n\t\ru2q\u0007\u0002\u0014\u001b\u0016$\u0018\rZ1uCJ+7m\u001c:e'\u0016\u0014H-Z\u0001\u0015[\u0016$\u0018\rZ1uCJ+7m\u001c:e'\u0016\u0014H-\u001a\u0011\u0015\t\rU11\t\u0005\b\u0005\u0013q\u0003\u0019\u0001B\u0006\u0005Y!U/\u001c9M_\u001e\u001cVmZ7f]R\u001cx\n\u001d;j_:\u001c8cA\u0018\u0004JA!11JB+\u001b\t\u0019iE\u0003\u0003\u0004P\rE\u0013\u0001B;uS2TAaa\u0015\u0003\u0016\u000511/\u001a:wKJLAaa\u0016\u0004N\t)2i\\7nC:$G)\u001a4bk2$x\n\u001d;j_:\u001cH\u0003BB.\u0007;\u00022!!$0\u0011\u0015Y\u0018\u00071\u0001}\u0003!\u0001(/\u001b8u\u001fB$XCAB2!\u0011\u0019)ga\u001b\u000e\u0005\r\u001d$BAB5\u0003)Qw\u000e\u001d;tS6\u0004H.Z\u0005\u0005\u0007[\u001a9GA\tPaRLwN\\*qK\u000e\u0014U/\u001b7eKJ\f\u0011\u0002\u001d:j]R|\u0005\u000f\u001e\u0011\u0002\u0013Y,'/\u001b4z\u001fB$\u0018A\u0003<fe&4\u0017p\u00149uA\u0005q\u0011N\u001c3fqN\u000bg.\u001b;z\u001fB$\u0018aD5oI\u0016D8+\u00198jif|\u0005\u000f\u001e\u0011\u0002\u0011\u0019LG.Z:PaR,\"a! \u0011\u000b\r\u00154qP@\n\t\r\u00055q\r\u0002\u001c\u0003J<W/\\3oi\u0006\u001b7-\u001a9uS:<w\n\u001d;j_:\u001c\u0006/Z2\u0002\u0013\u0019LG.Z:PaR\u0004\u0013!E7bq6+7o]1hKNK'0Z(qiV\u00111\u0011\u0012\t\u0007\u0007K\u001ayha#\u0011\u00075\u001ci)C\u0002\u0004\u0010:\u0014q!\u00138uK\u001e,'/\u0001\nnCblUm]:bO\u0016\u001c\u0016N_3PaR\u0004\u0013aC7bq\nKH/Z:PaR\fA\"\\1y\u0005f$Xm](qi\u0002\n\u0001\u0003Z3fa&#XM]1uS>tw\n\u001d;\u0002#\u0011,W\r]%uKJ\fG/[8o\u001fB$\b%A\bwC2,X\rR3d_\u0012,'o\u00149u+\t\u0019y\nE\u0003\u0004f\r}D.\u0001\twC2,X\rR3d_\u0012,'o\u00149uA\u0005i1.Z=EK\u000e|G-\u001a:PaR\fab[3z\t\u0016\u001cw\u000eZ3s\u001fB$\b%\u0001\u0006pM\u001a\u001cX\r^:PaR\f1b\u001c4gg\u0016$8o\u00149uA\u0005\tBO]1og\u0006\u001cG/[8o\u0019><w\n\u001d;\u0002%Q\u0014\u0018M\\:bGRLwN\u001c'pO>\u0003H\u000fI\u0001\u0013G2,8\u000f^3s\u001b\u0016$\u0018\rZ1uC>\u0003H/A\ndYV\u001cH/\u001a:NKR\fG-\u0019;b\u001fB$\b%A\u000btW&\u0004(+Z2pe\u0012lU\r^1eCR\fw\n\u001d;\u0002-M\\\u0017\u000e\u001d*fG>\u0014H-T3uC\u0012\fG/Y(qi\u0002\nQ\"\\3tg\u0006<W\rU1sg\u0016\u0014XCAB^a\u0019\u0019il!1\u0004HB9\u0011Q\u0012\u0006\u0004@\u000e\u0015\u0007\u0003BAv\u0007\u0003$1ba1M\u0003\u0003\u0005\tQ!\u0001\u0002r\n\u0019q\fJ\u001a\u0011\t\u0005-8q\u0019\u0003\f\u0007\u0013d\u0015\u0011!A\u0001\u0006\u0003\t\tPA\u0002`IQ\n!c\u001d5pk2$\u0007K]5oi\u0012\u000bG/\u0019'pOV\u0011\u0011qG\u0001\u0006M&dWm]\u000b\u0002yV\u0011\u0011qO\u0001\nG\",7m[!sON\f!B\\3x\t\u0016\u001cw\u000eZ3s)\u0011\u0019Yn!:1\t\ru7\u0011\u001d\t\u0007\u0005o\u0011yda8\u0011\t\u0005-8\u0011\u001d\u0003\f\u0007G4\u0016\u0011!A\u0001\u0006\u0003\t\tPA\u0002`IUBaaa:W\u0001\u0004y\u0018!C2mCN\u001ch*Y7f\u0003u\u0019wN\u001c<feR$U\r\u001d:fG\u0006$X\r\u001a#fG>$WM]\"mCN\u001cHcA@\u0004n\"11q],A\u0002}\u0004")
public final class DumpLogSegments {
    public static void main(String[] stringArray) {
        DumpLogSegments$.MODULE$.main(stringArray);
    }

    private static class ClusterMetadataLogMessageParser
    implements MessageParser<String, String> {
        private final MetadataRecordSerde metadataRecordSerde = new MetadataRecordSerde();

        private MetadataRecordSerde metadataRecordSerde() {
            return this.metadataRecordSerde;
        }

        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            String string;
            try {
                ApiMessageAndVersion messageAndVersion = this.metadataRecordSerde().read((Readable)new ByteBufferAccessor(record.value()), record.valueSize());
                ObjectNode json = new ObjectNode(JsonNodeFactory.instance);
                json.set("type", (JsonNode)new TextNode(MetadataRecordType.fromId((short)messageAndVersion.message().apiKey()).toString()));
                json.set("version", (JsonNode)new IntNode((int)messageAndVersion.version()));
                json.set("data", MetadataJsonConverters.writeJson((ApiMessage)messageAndVersion.message(), (short)messageAndVersion.version()));
                string = json.toString();
            }
            catch (Throwable e) {
                string = new StringBuilder(21).append("Error at ").append(record.offset()).append(", skipping. ").append(e.getMessage()).toString();
            }
            String output = string;
            return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)output));
        }
    }

    private static class DecoderMessageParser<K, V>
    implements MessageParser<K, V> {
        private final Decoder<K> keyDecoder;
        private final Decoder<V> valueDecoder;

        @Override
        public Tuple2<Option<K>, Option<V>> parse(Record record) {
            None$ key;
            Object object = key = record.hasKey() ? new Some(this.keyDecoder.fromBytes(Utils.readBytes((ByteBuffer)record.key()))) : None$.MODULE$;
            if (!record.hasValue()) {
                return new Tuple2((Object)key, (Object)None$.MODULE$);
            }
            Some payload = new Some(this.valueDecoder.fromBytes(Utils.readBytes((ByteBuffer)record.value())));
            return new Tuple2((Object)key, (Object)payload);
        }

        public DecoderMessageParser(Decoder<K> keyDecoder, Decoder<V> valueDecoder) {
            this.keyDecoder = keyDecoder;
            this.valueDecoder = valueDecoder;
        }
    }

    private static class DumpLogSegmentsOptions
    extends CommandDefaultOptions {
        private boolean shouldPrintDataLog;
        private boolean skipRecordMetadata;
        private boolean isDeepIteration;
        private boolean verifyOnly;
        private boolean indexSanityOnly;
        private String[] files;
        private int maxMessageSize;
        private int maxBytes;
        private OptionSpecBuilder printOpt;
        private OptionSpecBuilder verifyOpt;
        private OptionSpecBuilder indexSanityOpt;
        private final ArgumentAcceptingOptionSpec<String> filesOpt;
        private ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt;
        private ArgumentAcceptingOptionSpec<Integer> maxBytesOpt;
        private OptionSpecBuilder deepIterationOpt;
        private final ArgumentAcceptingOptionSpec<String> valueDecoderOpt;
        private final ArgumentAcceptingOptionSpec<String> keyDecoderOpt;
        private final OptionSpecBuilder offsetsOpt;
        private final OptionSpecBuilder transactionLogOpt;
        private final OptionSpecBuilder clusterMetadataOpt;
        private OptionSpecBuilder skipRecordMetadataOpt;
        private volatile byte bitmap$0;

        private OptionSpecBuilder printOpt() {
            return this.printOpt;
        }

        private OptionSpecBuilder verifyOpt() {
            return this.verifyOpt;
        }

        private OptionSpecBuilder indexSanityOpt() {
            return this.indexSanityOpt;
        }

        private ArgumentAcceptingOptionSpec<String> filesOpt() {
            return this.filesOpt;
        }

        private ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt() {
            return this.maxMessageSizeOpt;
        }

        private ArgumentAcceptingOptionSpec<Integer> maxBytesOpt() {
            return this.maxBytesOpt;
        }

        private OptionSpecBuilder deepIterationOpt() {
            return this.deepIterationOpt;
        }

        private ArgumentAcceptingOptionSpec<String> valueDecoderOpt() {
            return this.valueDecoderOpt;
        }

        private ArgumentAcceptingOptionSpec<String> keyDecoderOpt() {
            return this.keyDecoderOpt;
        }

        private OptionSpecBuilder offsetsOpt() {
            return this.offsetsOpt;
        }

        private OptionSpecBuilder transactionLogOpt() {
            return this.transactionLogOpt;
        }

        private OptionSpecBuilder clusterMetadataOpt() {
            return this.clusterMetadataOpt;
        }

        private OptionSpecBuilder skipRecordMetadataOpt() {
            return this.skipRecordMetadataOpt;
        }

        public MessageParser<?, ?> messageParser() {
            if (this.options.has((OptionSpec)this.offsetsOpt())) {
                return new OffsetsMessageParser();
            }
            if (this.options.has((OptionSpec)this.transactionLogOpt())) {
                return new TransactionLogMessageParser();
            }
            if (this.options.has((OptionSpec)this.clusterMetadataOpt())) {
                return new ClusterMetadataLogMessageParser();
            }
            Decoder<?> valueDecoder = DumpLogSegments$.MODULE$.newDecoder((String)this.options.valueOf(this.valueDecoderOpt()));
            Decoder<?> keyDecoder = DumpLogSegments$.MODULE$.newDecoder((String)this.options.valueOf(this.keyDecoderOpt()));
            return new DecoderMessageParser(keyDecoder, valueDecoder);
        }

        private boolean shouldPrintDataLog$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.shouldPrintDataLog = this.options.has((OptionSpec)this.printOpt()) || this.options.has((OptionSpec)this.offsetsOpt()) || this.options.has((OptionSpec)this.transactionLogOpt()) || this.options.has((OptionSpec)this.clusterMetadataOpt()) || this.options.has(this.valueDecoderOpt()) || this.options.has(this.keyDecoderOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            this.printOpt = null;
            return this.shouldPrintDataLog;
        }

        public boolean shouldPrintDataLog() {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                return this.shouldPrintDataLog$lzycompute();
            }
            return this.shouldPrintDataLog;
        }

        private boolean skipRecordMetadata$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.skipRecordMetadata = this.options.has((OptionSpec)this.skipRecordMetadataOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            this.skipRecordMetadataOpt = null;
            return this.skipRecordMetadata;
        }

        public boolean skipRecordMetadata() {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                return this.skipRecordMetadata$lzycompute();
            }
            return this.skipRecordMetadata;
        }

        private boolean isDeepIteration$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 4) == 0) {
                    this.isDeepIteration = this.options.has((OptionSpec)this.deepIterationOpt()) || this.shouldPrintDataLog();
                    this.bitmap$0 = (byte)(this.bitmap$0 | 4);
                }
            }
            this.deepIterationOpt = null;
            return this.isDeepIteration;
        }

        public boolean isDeepIteration() {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                return this.isDeepIteration$lzycompute();
            }
            return this.isDeepIteration;
        }

        private boolean verifyOnly$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 8) == 0) {
                    this.verifyOnly = this.options.has((OptionSpec)this.verifyOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 8);
                }
            }
            this.verifyOpt = null;
            return this.verifyOnly;
        }

        public boolean verifyOnly() {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                return this.verifyOnly$lzycompute();
            }
            return this.verifyOnly;
        }

        private boolean indexSanityOnly$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x10) == 0) {
                    this.indexSanityOnly = this.options.has((OptionSpec)this.indexSanityOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
                }
            }
            this.indexSanityOpt = null;
            return this.indexSanityOnly;
        }

        public boolean indexSanityOnly() {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                return this.indexSanityOnly$lzycompute();
            }
            return this.indexSanityOnly;
        }

        private String[] files$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x20) == 0) {
                    this.files = ((String)this.options.valueOf(this.filesOpt())).split(",");
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
                }
            }
            return this.files;
        }

        public String[] files() {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                return this.files$lzycompute();
            }
            return this.files;
        }

        private int maxMessageSize$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x40) == 0) {
                    this.maxMessageSize = (Integer)this.options.valueOf(this.maxMessageSizeOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
                }
            }
            this.maxMessageSizeOpt = null;
            return this.maxMessageSize;
        }

        public int maxMessageSize() {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                return this.maxMessageSize$lzycompute();
            }
            return this.maxMessageSize;
        }

        private int maxBytes$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x80) == 0) {
                    this.maxBytes = (Integer)this.options.valueOf(this.maxBytesOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x80);
                }
            }
            this.maxBytesOpt = null;
            return this.maxBytes;
        }

        public int maxBytes() {
            if ((byte)(this.bitmap$0 & 0x80) == 0) {
                return this.maxBytes$lzycompute();
            }
            return this.maxBytes;
        }

        public void checkArgs() {
            CommandLineUtils.checkRequiredArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec[])new OptionSpec[]{this.filesOpt()});
        }

        public DumpLogSegmentsOptions(String[] args) {
            super(args);
            this.printOpt = this.parser.accepts("print-data-log", "if set, printing the messages content when dumping data logs. Automatically set if any decoder option is specified.");
            this.verifyOpt = this.parser.accepts("verify-index-only", "if set, just verify the index log without printing its content.");
            this.indexSanityOpt = this.parser.accepts("index-sanity-check", "if set, just checks the index sanity without printing its content. This is the same check that is executed on broker startup to determine if an index needs rebuilding or not.");
            this.filesOpt = this.parser.accepts("files", "REQUIRED: The comma separated list of data and index log files to be dumped.").withRequiredArg().describedAs("file1, file2, ...").ofType(String.class);
            this.maxMessageSizeOpt = this.parser.accepts("max-message-size", "Size of largest message.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x500000), (Object[])new Integer[0]);
            this.maxBytesOpt = this.parser.accepts("max-bytes", "Limit the amount of total batches read in bytes avoiding reading the whole .log file(s).").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(Integer.MAX_VALUE), (Object[])new Integer[0]);
            this.deepIterationOpt = this.parser.accepts("deep-iteration", "if set, uses deep instead of shallow iteration. Automatically set if print-data-log is enabled.");
            this.valueDecoderOpt = this.parser.accepts("value-decoder-class", "if set, used to deserialize the messages. This class should implement org.apache.kafka.tools.api.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)StringDecoder.class.getName(), (Object[])new String[0]);
            this.keyDecoderOpt = this.parser.accepts("key-decoder-class", "if set, used to deserialize the keys. This class should implement org.apache.kafka.tools.api.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)StringDecoder.class.getName(), (Object[])new String[0]);
            this.offsetsOpt = this.parser.accepts("offsets-decoder", "if set, log data will be parsed as offset data from the __consumer_offsets topic.");
            this.transactionLogOpt = this.parser.accepts("transaction-log-decoder", "if set, log data will be parsed as transaction metadata from the __transaction_state topic.");
            this.clusterMetadataOpt = this.parser.accepts("cluster-metadata-decoder", "if set, log data will be parsed as cluster metadata records.");
            this.skipRecordMetadataOpt = this.parser.accepts("skip-record-metadata", "whether to skip printing metadata for each record.");
            this.options = this.parser.parse(args);
        }
    }

    public static interface MessageParser<K, V> {
        public Tuple2<Option<K>, Option<V>> parse(Record var1);
    }

    public static class OffsetsMessageParser
    implements MessageParser<String, String> {
        private final CoordinatorRecordSerde serde = new CoordinatorRecordSerde();

        private CoordinatorRecordSerde serde() {
            return this.serde;
        }

        private String prepareKey(Message message, short version) {
            JsonNode jsonNode;
            if (message instanceof OffsetCommitKey) {
                jsonNode = OffsetCommitKeyJsonConverter.write((OffsetCommitKey)((OffsetCommitKey)message), (short)version);
            } else if (message instanceof GroupMetadataKey) {
                jsonNode = GroupMetadataKeyJsonConverter.write((GroupMetadataKey)((GroupMetadataKey)message), (short)version);
            } else if (message instanceof ConsumerGroupMetadataKey) {
                jsonNode = ConsumerGroupMetadataKeyJsonConverter.write((ConsumerGroupMetadataKey)((ConsumerGroupMetadataKey)message), (short)version);
            } else if (message instanceof ConsumerGroupPartitionMetadataKey) {
                jsonNode = ConsumerGroupPartitionMetadataKeyJsonConverter.write((ConsumerGroupPartitionMetadataKey)((ConsumerGroupPartitionMetadataKey)message), (short)version);
            } else if (message instanceof ConsumerGroupMemberMetadataKey) {
                jsonNode = ConsumerGroupMemberMetadataKeyJsonConverter.write((ConsumerGroupMemberMetadataKey)((ConsumerGroupMemberMetadataKey)message), (short)version);
            } else if (message instanceof ConsumerGroupTargetAssignmentMetadataKey) {
                jsonNode = ConsumerGroupTargetAssignmentMetadataKeyJsonConverter.write((ConsumerGroupTargetAssignmentMetadataKey)((ConsumerGroupTargetAssignmentMetadataKey)message), (short)version);
            } else if (message instanceof ConsumerGroupTargetAssignmentMemberKey) {
                jsonNode = ConsumerGroupTargetAssignmentMemberKeyJsonConverter.write((ConsumerGroupTargetAssignmentMemberKey)((ConsumerGroupTargetAssignmentMemberKey)message), (short)version);
            } else if (message instanceof ConsumerGroupCurrentMemberAssignmentKey) {
                jsonNode = ConsumerGroupCurrentMemberAssignmentKeyJsonConverter.write((ConsumerGroupCurrentMemberAssignmentKey)((ConsumerGroupCurrentMemberAssignmentKey)message), (short)version);
            } else {
                throw new CoordinatorLoader.UnknownRecordTypeException(version);
            }
            JsonNode messageAsJson = jsonNode;
            ObjectNode json = new ObjectNode(JsonNodeFactory.instance);
            json.set("type", (JsonNode)new TextNode(Short.toString(version)));
            json.set("data", messageAsJson);
            return json.toString();
        }

        private JsonNode prepareGroupMetadataValue(GroupMetadataValue message, short version) {
            JsonNode json = GroupMetadataValueJsonConverter.write((GroupMetadataValue)message, (short)version);
            Option$.MODULE$.apply((Object)json.get("protocolType")).foreach((Function1 & Serializable & scala.Serializable)protocolTypeNode -> {
                OffsetsMessageParser.$anonfun$prepareGroupMetadataValue$2(json, protocolTypeNode);
                return BoxedUnit.UNIT;
            });
            return json;
        }

        private String prepareValue(Message message, short version) {
            JsonNode jsonNode;
            if (message instanceof OffsetCommitValue) {
                jsonNode = OffsetCommitValueJsonConverter.write((OffsetCommitValue)((OffsetCommitValue)message), (short)version);
            } else if (message instanceof GroupMetadataValue) {
                GroupMetadataValue groupMetadataValue = (GroupMetadataValue)message;
                jsonNode = this.prepareGroupMetadataValue(groupMetadataValue, version);
            } else if (message instanceof ConsumerGroupMetadataValue) {
                jsonNode = ConsumerGroupMetadataValueJsonConverter.write((ConsumerGroupMetadataValue)((ConsumerGroupMetadataValue)message), (short)version);
            } else if (message instanceof ConsumerGroupPartitionMetadataValue) {
                jsonNode = ConsumerGroupPartitionMetadataValueJsonConverter.write((ConsumerGroupPartitionMetadataValue)((ConsumerGroupPartitionMetadataValue)message), (short)version);
            } else if (message instanceof ConsumerGroupMemberMetadataValue) {
                jsonNode = ConsumerGroupMemberMetadataValueJsonConverter.write((ConsumerGroupMemberMetadataValue)((ConsumerGroupMemberMetadataValue)message), (short)version);
            } else if (message instanceof ConsumerGroupTargetAssignmentMetadataValue) {
                jsonNode = ConsumerGroupTargetAssignmentMetadataValueJsonConverter.write((ConsumerGroupTargetAssignmentMetadataValue)((ConsumerGroupTargetAssignmentMetadataValue)message), (short)version);
            } else if (message instanceof ConsumerGroupTargetAssignmentMemberValue) {
                jsonNode = ConsumerGroupTargetAssignmentMemberValueJsonConverter.write((ConsumerGroupTargetAssignmentMemberValue)((ConsumerGroupTargetAssignmentMemberValue)message), (short)version);
            } else if (message instanceof ConsumerGroupCurrentMemberAssignmentValue) {
                jsonNode = ConsumerGroupCurrentMemberAssignmentValueJsonConverter.write((ConsumerGroupCurrentMemberAssignmentValue)((ConsumerGroupCurrentMemberAssignmentValue)message), (short)version);
            } else {
                throw new IllegalStateException(new StringBuilder(32).append("Message value ").append(message.getClass().getSimpleName()).append(" is not supported.").toString());
            }
            JsonNode messageAsJson = jsonNode;
            ObjectNode json = new ObjectNode(JsonNodeFactory.instance);
            json.set("version", (JsonNode)new TextNode(Short.toString(version)));
            json.set("data", messageAsJson);
            return json.toString();
        }

        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            if (!record.hasKey()) {
                throw new RuntimeException(new StringBuilder(90).append("Failed to decode message at offset ").append(record.offset()).append(" using offset ").append("topic decoder (message had a missing key)").toString());
            }
            try {
                CoordinatorRecord r = this.serde().deserialize(record.key(), record.value());
                return new Tuple2((Object)new Some((Object)this.prepareKey((Message)r.key().message(), r.key().version())), (Object)Option$.MODULE$.apply((Object)r.value()).map((Function1 & Serializable & scala.Serializable)v -> this.prepareValue((Message)v.message(), v.version())).orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)"<DELETE>")));
            }
            catch (CoordinatorLoader.UnknownRecordTypeException e) {
                return new Tuple2((Object)new Some((Object)new StringBuilder(42).append("Unknown record type ").append(e.unknownType()).append(" at offset ").append(record.offset()).append(", skipping.").toString()), (Object)None$.MODULE$);
            }
            catch (Throwable e) {
                return new Tuple2((Object)new Some((Object)new StringBuilder(28).append("Error at offset ").append(record.offset()).append(", skipping. ").append(e.getMessage()).toString()), (Object)None$.MODULE$);
            }
        }

        private static final void replace$1(JsonNode node, String field, Function2 reader, Function2 writer) {
            Option$.MODULE$.apply((Object)node.get(field)).foreach((Function1 & Serializable & scala.Serializable)filedNode -> {
                try {
                    ByteBuffer buffer = ByteBuffer.wrap(filedNode.binaryValue());
                    ByteBufferAccessor accessor = new ByteBufferAccessor(buffer);
                    short version = accessor.readShort();
                    Object data = reader.apply((Object)accessor, (Object)BoxesRunTime.boxToShort((short)version));
                    return ((ObjectNode)node).replace(field, (JsonNode)writer.apply(data, (Object)BoxesRunTime.boxToShort((short)version)));
                }
                catch (RuntimeException runtimeException) {
                    return BoxedUnit.UNIT;
                }
            });
        }

        public static final /* synthetic */ ConsumerProtocolSubscription $anonfun$prepareGroupMetadataValue$5(Readable readable, short version) {
            return new ConsumerProtocolSubscription(readable, version);
        }

        public static final /* synthetic */ JsonNode $anonfun$prepareGroupMetadataValue$6(ConsumerProtocolSubscription x$1, short x$2) {
            return ConsumerProtocolSubscriptionJsonConverter.write((ConsumerProtocolSubscription)x$1, (short)x$2);
        }

        public static final /* synthetic */ ConsumerProtocolAssignment $anonfun$prepareGroupMetadataValue$7(Readable readable, short version) {
            return new ConsumerProtocolAssignment(readable, version);
        }

        public static final /* synthetic */ JsonNode $anonfun$prepareGroupMetadataValue$8(ConsumerProtocolAssignment x$1, short x$2) {
            return ConsumerProtocolAssignmentJsonConverter.write((ConsumerProtocolAssignment)x$1, (short)x$2);
        }

        public static final /* synthetic */ void $anonfun$prepareGroupMetadataValue$3(JsonNode membersNode) {
            if (membersNode.isArray()) {
                membersNode.forEach(memberNode -> {
                    void replace$1_writer;
                    void replace$1_reader;
                    void replace$1_writer2;
                    Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$1, x$2) -> OffsetsMessageParser.$anonfun$prepareGroupMetadataValue$6(x$1, BoxesRunTime.unboxToShort((Object)x$2));
                    Function2 & Serializable & scala.Serializable replace$1_reader2 = (Function2 & Serializable & scala.Serializable)(readable, version) -> OffsetsMessageParser.$anonfun$prepareGroupMetadataValue$5(readable, BoxesRunTime.unboxToShort((Object)version));
                    String replace$1_field = "subscription";
                    Option$.MODULE$.apply((Object)memberNode.get(replace$1_field)).foreach(arg_0 -> OffsetsMessageParser.$anonfun$prepareGroupMetadataValue$1(replace$1_reader2, memberNode, replace$1_field, (Function2)replace$1_writer2, arg_0));
                    Function2 & Serializable & scala.Serializable intersect2 = (Function2 & Serializable & scala.Serializable)(x$1, x$2) -> OffsetsMessageParser.$anonfun$prepareGroupMetadataValue$8(x$1, BoxesRunTime.unboxToShort((Object)x$2));
                    Function2 & Serializable & scala.Serializable intersect3 = (Function2 & Serializable & scala.Serializable)(readable, version) -> OffsetsMessageParser.$anonfun$prepareGroupMetadataValue$7(readable, BoxesRunTime.unboxToShort((Object)version));
                    String replace$1_field2 = "assignment";
                    Option$.MODULE$.apply((Object)memberNode.get(replace$1_field2)).foreach(arg_0 -> OffsetsMessageParser.$anonfun$prepareGroupMetadataValue$1((Function2)replace$1_reader, memberNode, replace$1_field2, (Function2)replace$1_writer, arg_0));
                });
                return;
            }
        }

        public static final /* synthetic */ void $anonfun$prepareGroupMetadataValue$2(JsonNode json$1, JsonNode protocolTypeNode) {
            String string = protocolTypeNode.asText();
            String string2 = "consumer";
            if (string == null) {
                return;
            }
            if (string.equals(string2)) {
                Option$.MODULE$.apply((Object)json$1.get("members")).foreach((Function1 & Serializable & scala.Serializable)membersNode -> {
                    OffsetsMessageParser.$anonfun$prepareGroupMetadataValue$3(membersNode);
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
    }

    public static class TimeIndexDumpErrors {
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap() {
            return this.misMatchesForTimeIndexFilesMap;
        }

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp() {
            return this.outOfOrderTimestamp;
        }

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound() {
            return this.shallowOffsetNotFound;
        }

        public void recordMismatchTimeIndex(File file, long indexTimestamp, long logTimestamp) {
            ArrayBuffer misMatchesSeq = (ArrayBuffer)this.misMatchesForTimeIndexFilesMap().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
            if (misMatchesSeq.isEmpty()) {
                this.misMatchesForTimeIndexFilesMap().put((Object)file.getAbsolutePath(), (Object)misMatchesSeq);
            }
            misMatchesSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexTimestamp, logTimestamp));
        }

        public void recordOutOfOrderIndexTimestamp(File file, long indexTimestamp, long prevIndexTimestamp) {
            ArrayBuffer outOfOrderSeq = (ArrayBuffer)this.outOfOrderTimestamp().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
            if (outOfOrderSeq.isEmpty()) {
                this.outOfOrderTimestamp().put((Object)file.getAbsolutePath(), (Object)outOfOrderSeq);
            }
            outOfOrderSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexTimestamp, prevIndexTimestamp));
        }

        public void recordShallowOffsetNotFound(File file, long indexOffset, long logOffset) {
            ArrayBuffer shallowOffsetNotFoundSeq = (ArrayBuffer)this.shallowOffsetNotFound().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
            if (shallowOffsetNotFoundSeq.isEmpty()) {
                this.shallowOffsetNotFound().put((Object)file.getAbsolutePath(), (Object)shallowOffsetNotFoundSeq);
            }
            shallowOffsetNotFoundSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexOffset, logOffset));
        }

        public void printErrors() {
            this.misMatchesForTimeIndexFilesMap().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$1(x0$1);
                return BoxedUnit.UNIT;
            });
            this.outOfOrderTimestamp().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$3(x0$2);
                return BoxedUnit.UNIT;
            });
            this.shallowOffsetNotFound().values().foreach((Function1 & Serializable & scala.Serializable)listOfShallowOffsetNotFound -> {
                TimeIndexDumpErrors.$anonfun$printErrors$5(listOfShallowOffsetNotFound);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ void $anonfun$printErrors$1(Tuple2 x0$1) {
            if (x0$1 != null) {
                String fileName = (String)x0$1._1();
                ArrayBuffer listOfMismatches = (ArrayBuffer)x0$1._2();
                System.err.println(new StringBuilder(29).append("Found timestamp mismatch in :").append(fileName).toString());
                listOfMismatches.foreach((Function1 & Serializable & scala.Serializable)m -> {
                    System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index timestamp: %d, log timestamp: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printErrors$3(Tuple2 x0$2) {
            if (x0$2 != null) {
                String fileName = (String)x0$2._1();
                ArrayBuffer outOfOrderTimestamps = (ArrayBuffer)x0$2._2();
                System.err.println(new StringBuilder(33).append("Found out of order timestamp in :").append(fileName).toString());
                outOfOrderTimestamps.foreach((Function1 & Serializable & scala.Serializable)m -> {
                    System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index timestamp: %d, Previously indexed timestamp: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printErrors$6(Tuple2 x0$3) {
            if (x0$3 != null) {
                long indexedOffset = x0$3._1$mcJ$sp();
                long logOffset = x0$3._2$mcJ$sp();
                System.err.println(new StringBuilder(36).append("Indexed offset: ").append(indexedOffset).append(", found log offset: ").append(logOffset).toString());
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printErrors$5(ArrayBuffer listOfShallowOffsetNotFound) {
            System.err.println("The following indexed offsets are not found in the log.");
            listOfShallowOffsetNotFound.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$6(x0$3);
                return BoxedUnit.UNIT;
            });
        }
    }

    private static class TransactionLogMessageParser
    implements MessageParser<String, String> {
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            return TransactionLog$.MODULE$.formatRecordKeyAndValue(record);
        }
    }
}

