/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.RocksDBSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBTimestampedSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBTimestampedWindowStore;
import org.apache.kafka.streams.state.internals.RocksDBWindowStore;
import org.apache.kafka.streams.state.internals.WindowKeySchema;

public class RocksDbWindowBytesStoreSupplier
implements WindowBytesStoreSupplier {
    private final String name;
    private final long retentionPeriod;
    private final long segmentInterval;
    private final long windowSize;
    private final boolean retainDuplicates;
    private final WindowStoreTypes windowStoreType;

    public RocksDbWindowBytesStoreSupplier(String name, long retentionPeriod, long segmentInterval, long windowSize, boolean retainDuplicates, boolean returnTimestampedStore) {
        this(name, retentionPeriod, segmentInterval, windowSize, retainDuplicates, returnTimestampedStore ? WindowStoreTypes.TIMESTAMPED_WINDOW_STORE : WindowStoreTypes.DEFAULT_WINDOW_STORE);
    }

    public RocksDbWindowBytesStoreSupplier(String name, long retentionPeriod, long segmentInterval, long windowSize, boolean retainDuplicates, WindowStoreTypes windowStoreType) {
        this.name = name;
        this.retentionPeriod = retentionPeriod;
        this.segmentInterval = segmentInterval;
        this.windowSize = windowSize;
        this.retainDuplicates = retainDuplicates;
        this.windowStoreType = windowStoreType;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public WindowStore<Bytes, byte[]> get() {
        switch (this.windowStoreType) {
            case DEFAULT_WINDOW_STORE: {
                return new RocksDBWindowStore(new RocksDBSegmentedBytesStore(this.name, this.metricsScope(), this.retentionPeriod, this.segmentInterval, new WindowKeySchema()), this.retainDuplicates, this.windowSize);
            }
            case TIMESTAMPED_WINDOW_STORE: {
                return new RocksDBTimestampedWindowStore(new RocksDBTimestampedSegmentedBytesStore(this.name, this.metricsScope(), this.retentionPeriod, this.segmentInterval, new WindowKeySchema()), this.retainDuplicates, this.windowSize);
            }
        }
        throw new IllegalArgumentException("invalid window store type: " + (Object)((Object)this.windowStoreType));
    }

    @Override
    public String metricsScope() {
        return "rocksdb-window";
    }

    @Override
    public long segmentIntervalMs() {
        return this.segmentInterval;
    }

    @Override
    public long windowSize() {
        return this.windowSize;
    }

    @Override
    public boolean retainDuplicates() {
        return this.retainDuplicates;
    }

    @Override
    public long retentionPeriod() {
        return this.retentionPeriod;
    }

    public String toString() {
        return "RocksDbWindowBytesStoreSupplier{name='" + this.name + '\'' + ", retentionPeriod=" + this.retentionPeriod + ", segmentInterval=" + this.segmentInterval + ", windowSize=" + this.windowSize + ", retainDuplicates=" + this.retainDuplicates + ", windowStoreType=" + (Object)((Object)this.windowStoreType) + '}';
    }

    public static enum WindowStoreTypes {
        DEFAULT_WINDOW_STORE,
        TIMESTAMPED_WINDOW_STORE;

    }
}

