/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.state.WindowStore;

class KStreamJoinWindow<K, V>
implements ProcessorSupplier<K, V, K, V> {
    private final String windowName;

    KStreamJoinWindow(String windowName) {
        this.windowName = windowName;
    }

    @Override
    public Processor<K, V, K, V> get() {
        return new KStreamJoinWindowProcessor();
    }

    private class KStreamJoinWindowProcessor
    extends ContextualProcessor<K, V, K, V> {
        private WindowStore<K, V> window;

        private KStreamJoinWindowProcessor() {
        }

        @Override
        public void init(ProcessorContext<K, V> context) {
            super.init(context);
            this.window = (WindowStore)context.getStateStore(KStreamJoinWindow.this.windowName);
        }

        @Override
        public void process(Record<K, V> record) {
            this.context().forward(record);
            if (record.key() != null) {
                this.window.put(record.key(), record.value(), record.timestamp());
            }
        }
    }
}

