/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.Punctuator;
import org.apache.kafka.streams.processor.api.FixedKeyProcessor;
import org.apache.kafka.streams.processor.api.InternalFixedKeyRecordFactory;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;

public class ProcessorNode<KIn, VIn, KOut, VOut> {
    private final List<ProcessorNode<KOut, VOut, ?, ?>> children;
    private final Map<String, ProcessorNode<KOut, VOut, ?, ?>> childByName;
    private final Processor<KIn, VIn, KOut, VOut> processor;
    private final FixedKeyProcessor<KIn, VIn, VOut> fixedKeyProcessor;
    private final String name;
    public final Set<String> stateStores;
    private InternalProcessorContext<KOut, VOut> internalProcessorContext;
    private String threadId;
    private boolean closed = true;

    public ProcessorNode(String name) {
        this(name, (Processor)null, null);
    }

    public ProcessorNode(String name, Processor<KIn, VIn, KOut, VOut> processor, Set<String> stateStores) {
        this.name = name;
        this.processor = processor;
        this.fixedKeyProcessor = null;
        this.children = new ArrayList();
        this.childByName = new HashMap();
        this.stateStores = stateStores;
    }

    public ProcessorNode(String name, FixedKeyProcessor<KIn, VIn, VOut> processor, Set<String> stateStores) {
        this.name = name;
        this.processor = null;
        this.fixedKeyProcessor = processor;
        this.children = new ArrayList();
        this.childByName = new HashMap();
        this.stateStores = stateStores;
    }

    public final String name() {
        return this.name;
    }

    public List<ProcessorNode<KOut, VOut, ?, ?>> children() {
        return this.children;
    }

    ProcessorNode<KOut, VOut, ?, ?> getChild(String childName) {
        return this.childByName.get(childName);
    }

    public void addChild(ProcessorNode<KOut, VOut, ?, ?> child) {
        this.children.add(child);
        this.childByName.put(child.name, child);
    }

    public void init(InternalProcessorContext<KOut, VOut> context) {
        if (!this.closed) {
            throw new IllegalStateException("The processor is not closed");
        }
        try {
            this.threadId = Thread.currentThread().getName();
            this.internalProcessorContext = context;
            if (this.processor != null) {
                this.processor.init(context);
            }
            if (this.fixedKeyProcessor != null) {
                InternalProcessorContext<KOut, VOut> fixedKeyProcessorContext = context;
                this.fixedKeyProcessor.init(fixedKeyProcessorContext);
            }
        }
        catch (Exception e) {
            throw new StreamsException(String.format("failed to initialize processor %s", this.name), e);
        }
        this.closed = false;
    }

    public void close() {
        this.throwIfClosed();
        try {
            if (this.processor != null) {
                this.processor.close();
            }
            if (this.fixedKeyProcessor != null) {
                this.fixedKeyProcessor.close();
            }
            this.internalProcessorContext.metrics().removeAllNodeLevelSensors(this.threadId, this.internalProcessorContext.taskId().toString(), this.name);
        }
        catch (Exception e) {
            throw new StreamsException(String.format("failed to close processor %s", this.name), e);
        }
        this.closed = true;
    }

    protected void throwIfClosed() {
        if (this.closed) {
            throw new IllegalStateException("The processor is already closed");
        }
    }

    public void process(Record<KIn, VIn> record) {
        block4: {
            this.throwIfClosed();
            try {
                if (this.processor != null) {
                    this.processor.process(record);
                    break block4;
                }
                if (this.fixedKeyProcessor != null) {
                    this.fixedKeyProcessor.process(InternalFixedKeyRecordFactory.create(record));
                    break block4;
                }
                throw new IllegalStateException("neither the processor nor the fixed key processor were set.");
            }
            catch (ClassCastException e) {
                String keyClass = record.key() == null ? "unknown because key is null" : record.key().getClass().getName();
                String valueClass = record.value() == null ? "unknown because value is null" : record.value().getClass().getName();
                throw new StreamsException(String.format("ClassCastException invoking processor: %s. Do the Processor's input types match the deserialized types? Check the Serde setup and change the default Serdes in StreamConfig or provide correct Serdes via method parameters. Make sure the Processor can accept the deserialized input of type key: %s, and value: %s.%nNote that although incorrect Serdes are a common cause of error, the cast exception might have another cause (in user code, for example). For example, if a processor wires in a store, but casts the generics incorrectly, a class cast exception could be raised during processing, but the cause would not be wrong Serdes.", this.name(), keyClass, valueClass), e);
            }
        }
    }

    public void punctuate(long timestamp, Punctuator punctuator) {
        punctuator.punctuate(timestamp);
    }

    public boolean isTerminalNode() {
        return this.children.isEmpty();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder(indent + this.name + ":\n");
        if (this.stateStores != null && !this.stateStores.isEmpty()) {
            sb.append(indent).append("\tstates:\t\t[");
            for (String store : this.stateStores) {
                sb.append(store);
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append("]\n");
        }
        return sb.toString();
    }
}

