/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client.remote;

import java.util.Optional;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.ParameterInfo;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.http.annotation.Content;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.PathRemainder;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartType;

public class RemoteOperationArg {
    private static final AnnotationProvider AP = AnnotationProvider.INSTANCE;
    private final int index;
    private final HttpPartType partType;
    private final Optional<HttpPartSerializer> serializer;
    private final HttpPartSchema schema;

    static RemoteOperationArg create(ParameterInfo mpi) {
        int i = mpi.getIndex();
        if (AP.has(Header.class, mpi, new AnnotationTraversal[0])) {
            return new RemoteOperationArg(i, HttpPartType.HEADER, HttpPartSchema.create(Header.class, (ParameterInfo)mpi));
        }
        if (AP.has(Query.class, mpi, new AnnotationTraversal[0])) {
            return new RemoteOperationArg(i, HttpPartType.QUERY, HttpPartSchema.create(Query.class, (ParameterInfo)mpi));
        }
        if (AP.has(FormData.class, mpi, new AnnotationTraversal[0])) {
            return new RemoteOperationArg(i, HttpPartType.FORMDATA, HttpPartSchema.create(FormData.class, (ParameterInfo)mpi));
        }
        if (AP.has(PathRemainder.class, mpi, new AnnotationTraversal[0])) {
            HttpPartSchema schema = HttpPartSchema.create(PathRemainder.class, (ParameterInfo)mpi);
            return new RemoteOperationArg(i, HttpPartType.PATH, schema, "/*");
        }
        if (AP.has(Path.class, mpi, new AnnotationTraversal[0])) {
            return new RemoteOperationArg(i, HttpPartType.PATH, HttpPartSchema.create(Path.class, (ParameterInfo)mpi));
        }
        if (AP.has(Content.class, mpi, new AnnotationTraversal[0])) {
            return new RemoteOperationArg(i, HttpPartType.BODY, HttpPartSchema.create(Content.class, (ParameterInfo)mpi));
        }
        return null;
    }

    RemoteOperationArg(int index, HttpPartType partType, HttpPartSchema schema) {
        this.index = index;
        this.partType = partType;
        this.serializer = BeanCreator.of(HttpPartSerializer.class).type(schema.getSerializer()).execute();
        this.schema = schema;
    }

    RemoteOperationArg(int index, HttpPartType partType, HttpPartSchema schema, String overrideName) {
        this.index = index;
        this.partType = partType;
        this.serializer = BeanCreator.of(HttpPartSerializer.class).type(schema.getSerializer()).execute();
        this.schema = HttpPartSchema.create().name(overrideName).build();
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.schema.getName();
    }

    public HttpPartType getPartType() {
        return this.partType;
    }

    public HttpPartSchema getSchema() {
        return this.schema;
    }

    public Optional<HttpPartSerializer> getSerializer() {
        return this.serializer;
    }

    public boolean isSkipIfEmpty() {
        return this.schema.isSkipIfEmpty();
    }
}

