/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.uon;

import java.io.IOException;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.parser.ParserReader;

public class UonReader
extends ParserReader {
    private final boolean decodeChars;
    private final char[] buff;
    private int iCurrent;
    private int iEnd;

    private static int fromHexChar(int c) throws IOException {
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        if (c >= 97 && c <= 102) {
            return 10 + c - 97;
        }
        if (c >= 65 && c <= 70) {
            return 10 + c - 65;
        }
        throw ThrowableUtils.ioex((String)"Invalid hex character ''{0}'' found in escape pattern.", (Object[])new Object[]{c});
    }

    public UonReader(ParserPipe pipe, boolean decodeChars) throws IOException {
        super(pipe);
        String in;
        this.decodeChars = decodeChars;
        this.buff = pipe.isString() ? new char[(in = pipe.getInputAsString()).length() < 1024 ? in.length() : 1024] : new char[1024];
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (!this.decodeChars) {
            return super.read(cbuf, off, len);
        }
        int remainder = this.iEnd - this.iCurrent;
        if (remainder > 0) {
            System.arraycopy(this.buff, this.iCurrent, this.buff, 0, remainder);
        }
        this.iCurrent = 0;
        int expected = this.buff.length - remainder;
        int x = super.read(this.buff, remainder, expected);
        if (x == -1 && remainder == 0) {
            return -1;
        }
        this.iEnd = remainder + (x == -1 ? 0 : x);
        int i = 0;
        while (i < len) {
            int cx;
            char c;
            if (this.iCurrent >= this.iEnd) {
                return i;
            }
            if ((c = this.buff[this.iCurrent++]) == '+') {
                cbuf[off + i++] = 32;
                continue;
            }
            if (c == '&') {
                cbuf[off + i++] = '\u0001';
                continue;
            }
            if (c == '=') {
                cbuf[off + i++] = 2;
                continue;
            }
            if (c != '%') {
                cbuf[off + i++] = c;
                continue;
            }
            int iMark = this.iCurrent - 1;
            if (iMark + 2 >= this.iEnd || i + 2 > len) {
                --this.iCurrent;
                return i;
            }
            int b0 = this.readEncodedByte();
            if (b0 < 128) {
                cx = b0;
            } else {
                if (b0 < 192) {
                    throw ThrowableUtils.ioex((String)"Invalid hex value for first escape pattern in UTF-8 sequence: {0}", (Object[])new Object[]{b0});
                }
                if (b0 < 224) {
                    cx = this.readUTF8(b0 - 192, 1);
                    if (cx == -1) {
                        this.iCurrent = iMark;
                        return i;
                    }
                } else if (b0 < 240) {
                    cx = this.readUTF8(b0 - 224, 2);
                    if (cx == -1) {
                        this.iCurrent = iMark;
                        return i;
                    }
                } else if (b0 < 248) {
                    cx = this.readUTF8(b0 - 240, 3);
                    if (cx == -1) {
                        this.iCurrent = iMark;
                        return i;
                    }
                } else {
                    throw ThrowableUtils.ioex((String)"Invalid hex value for first escape pattern in UTF-8 sequence: {0}", (Object[])new Object[]{b0});
                }
            }
            if (cx < 65536) {
                cbuf[off + i++] = (char)cx;
                continue;
            }
            cbuf[off + i++] = (char)(55296 + ((cx -= 65536) >> 10));
            cbuf[off + i++] = (char)(56320 + (cx & 0x3FF));
        }
        return i;
    }

    @Override
    public UonReader unread() throws IOException {
        super.unread();
        return this;
    }

    private int readEncodedByte() throws IOException {
        if (this.iEnd <= this.iCurrent + 1) {
            throw ThrowableUtils.ioex((String)"Incomplete trailing escape pattern", (Object[])new Object[0]);
        }
        int h = this.buff[this.iCurrent++];
        int l = this.buff[this.iCurrent++];
        h = UonReader.fromHexChar(h);
        l = UonReader.fromHexChar(l);
        return (h << 4) + l;
    }

    private int readHex() throws IOException {
        char c;
        if ((c = this.buff[this.iCurrent++]) != '%') {
            throw ThrowableUtils.ioex((String)"Did not find expected '%' character in UTF-8 sequence.", (Object[])new Object[0]);
        }
        return this.readEncodedByte();
    }

    private int readUTF8(int n, int numBytes) throws IOException {
        if (this.iCurrent + numBytes * 3 > this.iEnd) {
            return -1;
        }
        for (int i = 0; i < numBytes; ++i) {
            n <<= 6;
            n += this.readHex() - 128;
        }
        return n;
    }
}

