/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMapEntry;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanMetaFiltered;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanSession;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;

public class DelegateBeanMap<T>
extends BeanMap<T> {
    private Set<String> keys = CollectionUtils.set((Object[])new String[0]);
    private JsonMap overrideValues = new JsonMap();

    public DelegateBeanMap(T bean, BeanSession session) {
        super(session, bean, session.getBeanMeta(bean.getClass()));
    }

    public void addKey(String key) {
        this.keys.add(key);
    }

    @Override
    public synchronized Set<Map.Entry<String, Object>> entrySet() {
        LinkedHashSet s = CollectionUtils.set((Object[])new Map.Entry[0]);
        this.keys.forEach((? super T k) -> {
            BeanMapEntry bme = this.overrideValues.containsKey(k) ? new BeanMapEntryOverride(this, this.getPropertyMeta((String)k), this.overrideValues.get(k)) : this.getProperty((String)k);
            if (bme == null) {
                throw ThrowableUtils.bex((Class)super.getClassMeta().inner(), (String)"Property ''{0}'' not found on class.", (Object[])new Object[]{k});
            }
            s.add(bme);
        });
        return s;
    }

    public DelegateBeanMap<T> filterKeys(List<String> keys) {
        this.keys.clear();
        this.keys.addAll(keys);
        return this;
    }

    @Override
    public BeanMap<T> forEachProperty(Predicate<BeanPropertyMeta> filter, Consumer<BeanPropertyMeta> action) {
        this.getProperties().forEach((? super T x) -> {
            if (filter == null || filter.test((BeanPropertyMeta)x)) {
                action.accept((BeanPropertyMeta)x);
            }
        });
        return this;
    }

    @Override
    public Object get(Object key) {
        if (this.overrideValues.containsKey(key)) {
            return this.overrideValues.get(key);
        }
        return super.get(key);
    }

    @Override
    public BeanMeta<T> getMeta() {
        return new BeanMetaFiltered(super.getMeta(), this.keys);
    }

    @Override
    public Collection<BeanPropertyMeta> getProperties() {
        ArrayList<BeanPropertyMeta> l = new ArrayList<BeanPropertyMeta>(this.keys.size());
        this.keys.forEach((? super T k) -> {
            BeanPropertyMeta p = this.getPropertyMeta((String)k);
            if (this.overrideValues.containsKey(k)) {
                p = BeanPropertyMeta.builder(this.meta, k).overrideValue(this.overrideValues.get(k)).delegateFor(p).build();
            }
            if (p == null) {
                p = BeanPropertyMeta.builder(this.meta, k).overrideValue(null).build();
            }
            l.add(p);
        });
        return l;
    }

    @Override
    public Set<String> keySet() {
        return this.keys;
    }

    @Override
    public Object put(String key, Object val) {
        this.overrideValues.put(key, val);
        this.keys.add(key);
        return null;
    }

    @Override
    public Object remove(Object key) {
        this.keys.remove(key);
        return null;
    }

    class BeanMapEntryOverride
    extends BeanMapEntry {
        Object value;

        BeanMapEntryOverride(BeanMap<?> bm, BeanPropertyMeta bpm, Object value) {
            super(bm, bpm, bpm.getName());
            this.value = value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }
}

