/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.juneau.commons.io.NoCloseOutputStream;
import org.apache.juneau.commons.io.NoCloseWriter;
import org.apache.juneau.commons.io.StringBuilderWriter;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.serializer.SerializeException;

public class SerializerPipe
implements Closeable {
    private final Object output;
    private final boolean autoClose;
    private OutputStream outputStream;
    private Writer writer;
    private Charset charset;

    SerializerPipe(Object output) {
        this.output = output;
        this.autoClose = false;
        this.charset = null;
    }

    SerializerPipe(Object output, Charset streamCharset, Charset fileCharset) {
        Charset cs;
        boolean isFile = output instanceof File;
        this.output = output;
        this.autoClose = isFile;
        Charset charset = cs = isFile ? fileCharset : streamCharset;
        if (cs == null) {
            cs = isFile ? Charset.defaultCharset() : IoUtils.UTF8;
        }
        this.charset = cs;
    }

    @Override
    public void close() {
        try {
            IoUtils.flush(this.writer, this.outputStream);
            if (this.autoClose) {
                IoUtils.close(this.writer, this.outputStream);
            }
        }
        catch (IOException e) {
            throw ThrowableUtils.bex(e);
        }
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.output == null) {
            throw ThrowableUtils.ioex("Output cannot be null.", new Object[0]);
        }
        Object object = this.output;
        if (object instanceof OutputStream) {
            OutputStream output2;
            this.outputStream = output2 = (OutputStream)object;
        } else {
            object = this.output;
            if (object instanceof File) {
                File output2 = (File)object;
                this.outputStream = new BufferedOutputStream(new FileOutputStream(output2));
            } else {
                throw ThrowableUtils.ioex("Cannot convert object of type {0} to an OutputStream.", Utils.cn(this.output));
            }
        }
        return new NoCloseOutputStream(this.outputStream);
    }

    public Object getRawOutput() {
        return this.output;
    }

    public Writer getWriter() throws SerializeException {
        block7: {
            if (this.output == null) {
                throw new SerializeException("Output cannot be null.", new Object[0]);
            }
            try {
                Object object = this.output;
                if (object instanceof Writer) {
                    Writer output2;
                    this.writer = output2 = (Writer)object;
                    break block7;
                }
                object = this.output;
                if (object instanceof OutputStream) {
                    OutputStream output2 = (OutputStream)object;
                    this.writer = new OutputStreamWriter(output2, this.charset);
                    break block7;
                }
                object = this.output;
                if (object instanceof File) {
                    File output2 = (File)object;
                    this.writer = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(output2)));
                    break block7;
                }
                object = this.output;
                if (object instanceof StringBuilder) {
                    StringBuilder output2 = (StringBuilder)object;
                    this.writer = new StringBuilderWriter(output2);
                    break block7;
                }
                throw new SerializeException("Cannot convert object of type " + Utils.cn(this.output) + " to a Writer.", new Object[0]);
            }
            catch (FileNotFoundException e) {
                throw ThrowableUtils.castException(SerializeException.class, e);
            }
        }
        return new NoCloseWriter(this.writer);
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }
}

