/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.json.JsonException;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import org.apache.johnzon.mapper.MapperConfig;
import org.apache.johnzon.mapper.MapperException;
import org.apache.johnzon.mapper.MappingGeneratorImpl;
import org.apache.johnzon.mapper.MappingParserImpl;
import org.apache.johnzon.mapper.Mappings;
import org.apache.johnzon.mapper.ReaderHandler;
import org.apache.johnzon.mapper.internal.JsonPointerTracker;
import org.apache.johnzon.mapper.internal.Streams;
import org.apache.johnzon.mapper.reflection.JohnzonCollectionType;

public class Mapper
implements Closeable {
    protected final MapperConfig config;
    protected final Mappings mappings;
    protected final JsonReaderFactory readerFactory;
    protected final JsonGeneratorFactory generatorFactory;
    protected final ReaderHandler readerHandler;
    protected final Collection<Closeable> closeables;
    protected final Charset charset;

    Mapper(JsonReaderFactory readerFactory, JsonGeneratorFactory generatorFactory, MapperConfig config, Collection<Closeable> closeables) {
        this.readerFactory = readerFactory;
        this.generatorFactory = generatorFactory;
        this.config = config;
        this.mappings = new Mappings(config);
        this.readerHandler = ReaderHandler.create(readerFactory);
        this.closeables = closeables;
        this.charset = config.getEncoding();
    }

    public <T> void writeArray(Object object, OutputStream stream) {
        this.writeObject(Arrays.asList((Object[])object), stream);
    }

    public <T> void writeArray(T[] object, OutputStream stream) {
        this.writeObject(Arrays.asList(object), stream);
    }

    public <T> void writeArray(T[] object, Writer stream) {
        this.writeObject(Arrays.asList(object), stream);
    }

    public <T> void writeArray(Collection<T> object, OutputStream stream) {
        this.writeArray(object, (Writer)new OutputStreamWriter(stream, this.config.getEncoding()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void writeArray(Collection<T> object, Writer stream) {
        JsonGenerator generator = this.generatorFactory.createGenerator(this.stream(stream));
        try {
            boolean dedup = Boolean.TRUE.equals(this.config.isDeduplicateObjects());
            this.writeObject(object, generator, null, dedup ? new JsonPointerTracker(null, "/") : null);
        }
        finally {
            generator.close();
        }
    }

    public <T> void writeIterable(Iterable<T> object, OutputStream stream) {
        this.writeIterable(object, new OutputStreamWriter(stream, this.config.getEncoding()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void writeIterable(Iterable<T> object, Writer stream) {
        JsonGenerator generator = this.generatorFactory.createGenerator(this.stream(stream));
        try {
            boolean dedup = Boolean.TRUE.equals(this.config.isDeduplicateObjects());
            this.writeObject(object, generator, null, dedup ? new JsonPointerTracker(null, "/") : null);
        }
        finally {
            generator.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObject(Object object, Writer stream) {
        if (JsonValue.class.isInstance(object) || Boolean.class.isInstance(object) || String.class.isInstance(object) || Number.class.isInstance(object) || object == null) {
            try {
                String valueOf = String.valueOf(object);
                stream.write(this.config.isEnforceQuoteString() && String.class.isInstance(object) && !valueOf.startsWith("\"") ? '\"' + valueOf + '\"' : valueOf);
            }
            catch (IOException e) {
                throw new MapperException(e);
            }
            finally {
                if (this.config.isClose()) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                } else {
                    try {
                        stream.flush();
                    }
                    catch (IOException iOException) {}
                }
            }
            return;
        }
        JsonGenerator generator = this.generatorFactory.createGenerator(this.stream(stream));
        RuntimeException originalException = null;
        try {
            this.writeObject(object, generator);
        }
        catch (RuntimeException e) {
            originalException = e;
        }
        finally {
            try {
                generator.close();
            }
            catch (JsonException e) {
                if (originalException != null) {
                    throw originalException;
                }
                throw e;
            }
        }
    }

    private void writeObject(Object object, JsonGenerator generator) {
        this.writeObject(object, generator, null, this.isDeduplicateObjects(object.getClass()) ? new JsonPointerTracker(null, "/") : null);
    }

    private boolean isDeduplicateObjects(Class<?> rootType) {
        Mappings.ClassMapping classMapping;
        Boolean dedup = this.config.isDeduplicateObjects();
        if (dedup == null && (classMapping = this.mappings.findOrCreateClassMapping(rootType)) != null) {
            dedup = classMapping.isDeduplicateObjects();
        }
        return dedup != null ? dedup : false;
    }

    public void writeObject(Object object, OutputStream stream) {
        Charset charset = this.config.getEncoding();
        if (charset == null) {
            this.writeObject(object, new OutputStreamWriter(stream));
        } else {
            this.writeObject(object, new OutputStreamWriter(stream));
        }
    }

    private void writeObject(Object object, JsonGenerator generator, Collection<String> ignored, JsonPointerTracker jsonPointer) {
        MappingGeneratorImpl mappingGenerator = new MappingGeneratorImpl(this.config, generator, this.mappings, jsonPointer != null);
        mappingGenerator.doWriteObject(object, generator, true, ignored, jsonPointer);
    }

    public String writeArrayAsString(Collection<?> instance) {
        StringWriter writer = new StringWriter();
        this.writeArray(instance, (Writer)writer);
        return writer.toString();
    }

    public <T> String writeArrayAsString(T[] instance) {
        StringWriter writer = new StringWriter();
        this.writeArray(instance, (Writer)writer);
        return writer.toString();
    }

    public String writeObjectAsString(Object instance) {
        StringWriter writer = new StringWriter();
        this.writeObject(instance, writer);
        return writer.toString();
    }

    public <T> T readObject(String string, Type clazz) {
        return this.readObject(new StringReader(string), clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readObject(Reader stream, Type clazz) {
        JsonReader reader = this.readerFactory.createReader(this.stream(stream));
        try {
            T t = this.mapObject(clazz, reader);
            return t;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readObject(InputStream stream, Type clazz) {
        JsonReader reader = this.charset == null ? this.readerFactory.createReader(this.stream(stream)) : this.readerFactory.createReader(this.stream(stream), this.charset);
        try {
            T t = this.mapObject(clazz, reader);
            return t;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Collection<T> readCollection(InputStream stream, ParameterizedType genericType) {
        JsonReader reader = this.charset == null ? this.readerFactory.createReader(this.stream(stream)) : this.readerFactory.createReader(this.stream(stream), this.charset);
        try {
            Collection collection = (Collection)this.mapObject(genericType, reader);
            return collection;
        }
        finally {
            reader.close();
        }
    }

    public <T> T readJohnzonCollection(InputStream stream, JohnzonCollectionType<T> genericType) {
        return (T)this.readCollection(stream, genericType);
    }

    public <T> T readJohnzonCollection(Reader stream, JohnzonCollectionType<T> genericType) {
        return (T)this.readCollection(stream, genericType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Collection<T> readCollection(Reader stream, ParameterizedType genericType) {
        JsonReader reader = this.readerFactory.createReader(this.stream(stream));
        try {
            Collection collection = (Collection)this.mapObject(genericType, reader);
            return collection;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T[] readArray(Reader stream, Class<T> clazz) {
        JsonReader reader = this.readerFactory.createReader(this.stream(stream));
        try {
            Object[] objectArray = (Object[])this.mapArray(clazz, reader);
            return objectArray;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readTypedArray(InputStream stream, Class<?> elementType, Class<T> arrayType) {
        JsonReader reader = this.charset == null ? this.readerFactory.createReader(this.stream(stream)) : this.readerFactory.createReader(this.stream(stream), this.charset);
        try {
            T t = arrayType.cast(this.mapArray(elementType, reader));
            return t;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readTypedArray(Reader stream, Class<?> elementType, Class<T> arrayType) {
        JsonReader reader = this.readerFactory.createReader(this.stream(stream));
        try {
            T t = arrayType.cast(this.mapArray(elementType, reader));
            return t;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T[] readArray(InputStream stream, Class<T> clazz) {
        JsonReader reader = this.charset == null ? this.readerFactory.createReader(this.stream(stream)) : this.readerFactory.createReader(this.stream(stream), this.charset);
        try {
            Object[] objectArray = (Object[])this.mapArray(clazz, reader);
            return objectArray;
        }
        finally {
            reader.close();
        }
    }

    private Object mapArray(Class<?> clazz, JsonReader reader) {
        return this.mapObject(Array.newInstance(clazz, 0).getClass(), reader);
    }

    private <T> T mapObject(Type clazz, JsonReader reader) {
        boolean dedup = false;
        if (clazz instanceof Class) {
            dedup = this.isDeduplicateObjects((Class)clazz);
        }
        return new MappingParserImpl(this.config, this.mappings, reader, dedup).readObject(clazz);
    }

    private Reader stream(Reader stream) {
        return !this.config.isClose() ? Streams.noClose(stream) : stream;
    }

    private Writer stream(Writer stream) {
        return !this.config.isClose() ? Streams.noClose(stream) : stream;
    }

    private InputStream stream(InputStream stream) {
        return !this.config.isClose() ? Streams.noClose(stream) : stream;
    }

    @Override
    public synchronized void close() {
        ArrayList<IOException> errors = null;
        for (Closeable c : this.closeables) {
            try {
                c.close();
            }
            catch (IOException e) {
                if (errors == null) {
                    errors = new ArrayList<IOException>();
                }
                errors.add(e);
            }
        }
        this.closeables.clear();
        if (errors != null) {
            throw new IllegalStateException(((Object)errors).toString());
        }
    }
}

