/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.web;

import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.web.MediaType;

public class ContentType {
    private MediaType mediaType;

    public static ContentType create(String string) {
        if (string == null) {
            return null;
        }
        ContentType ct = new ContentType(MediaType.create(string));
        return ct;
    }

    public static ContentType create(String ctString, String charset) {
        MediaType.ParsedMediaType x = MediaType.parse(ctString);
        x.params.put("charset", charset);
        return new ContentType(new MediaType(x));
    }

    private ContentType(MediaType m) {
        this.mediaType = m;
    }

    public String getContentTypeStr() {
        return this.mediaType.getContentTypeStr();
    }

    public String getCharset() {
        return this.mediaType.getCharset();
    }

    public String getType() {
        return this.mediaType.getType();
    }

    public String getSubType() {
        return this.mediaType.getSubType();
    }

    public boolean agreesWith(MediaType mt) {
        return Lib.equalsIgnoreCase((String)this.mediaType.getType(), (String)mt.getType()) && Lib.equalsIgnoreCase((String)this.mediaType.getSubType(), (String)mt.getSubType());
    }

    public String toHeaderString() {
        return this.mediaType.toHeaderString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mediaType == null ? 0 : this.mediaType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentType other = (ContentType)obj;
        return !(this.mediaType == null ? other.mediaType != null : !this.mediaType.equals(other.mediaType));
    }

    public String toString() {
        return this.mediaType.toString();
    }
}

