/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j;

import java.util.concurrent.TimeUnit;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.field.AddressListField;
import org.apache.james.mime4j.dom.field.ContentDispositionField;
import org.apache.james.mime4j.dom.field.ContentTypeField;
import org.apache.james.mime4j.dom.field.DateTimeField;
import org.apache.james.mime4j.field.AddressListFieldImpl;
import org.apache.james.mime4j.field.AddressListFieldLenientImpl;
import org.apache.james.mime4j.field.ContentDispositionFieldImpl;
import org.apache.james.mime4j.field.ContentDispositionFieldLenientImpl;
import org.apache.james.mime4j.field.ContentTypeFieldImpl;
import org.apache.james.mime4j.field.ContentTypeFieldLenientImpl;
import org.apache.james.mime4j.field.DateTimeFieldImpl;
import org.apache.james.mime4j.field.DateTimeFieldLenientImpl;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.RawField;
import org.junit.Test;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;

public class JMHFieldBench {
    @Test
    public void launchBenchmark() throws Exception {
        Options opt = new OptionsBuilder().include(this.getClass().getName() + ".*").mode(Mode.AverageTime).timeUnit(TimeUnit.MICROSECONDS).warmupTime(TimeValue.seconds((long)5L)).warmupIterations(3).measurementTime(TimeValue.seconds((long)2L)).measurementIterations(5).threads(1).forks(1).shouldFailOnError(true).shouldDoGC(true).build();
        new Runner(opt).run();
    }

    @Benchmark
    public void dateLenient(Blackhole bh) {
        bh.consume((Object)((DateTimeField)DateTimeFieldLenientImpl.PARSER.parse((Field)new RawField("Date", "Tue, 26 Apr 2022 02:27:54 +0000"), DecodeMonitor.SILENT)).getDate());
    }

    @Benchmark
    public void dateStrict(Blackhole bh) {
        bh.consume((Object)((DateTimeField)DateTimeFieldImpl.PARSER.parse((Field)new RawField("Date", "Tue, 26 Apr 2022 02:27:54 +0000"), DecodeMonitor.SILENT)).getDate());
    }

    @Benchmark
    public void mailboxLenient(Blackhole bh) {
        bh.consume((Object)((AddressListField)AddressListFieldLenientImpl.PARSER.parse((Field)new RawField("From", "Me <me@example.com>, \"You\" <you@exemple.com>"), DecodeMonitor.SILENT)).getAddressList());
    }

    @Benchmark
    public void mailboxStrict(Blackhole bh) {
        bh.consume((Object)((AddressListField)AddressListFieldImpl.PARSER.parse((Field)new RawField("From", "Me <me@example.com>, \"You\" <you@exemple.com>"), DecodeMonitor.SILENT)).getAddressList());
    }

    @Benchmark
    public void contentTypeLenient(Blackhole bh) {
        bh.consume((Object)((ContentTypeField)ContentTypeFieldLenientImpl.PARSER.parse((Field)new RawField("Content-Type", "multipart/mixed; boundary=\"------------090404080405080108000909\""), DecodeMonitor.SILENT)).getBoundary());
    }

    @Benchmark
    public void contentTypeLenientFolded(Blackhole bh) {
        bh.consume((Object)((ContentTypeField)ContentTypeFieldLenientImpl.PARSER.parse((Field)new RawField("Content-Type", "multipart/mixed;\r\n boundary=\"------------090404080405080108000909\""), DecodeMonitor.SILENT)).getBoundary());
    }

    @Benchmark
    public void contentTypeStrictFolded(Blackhole bh) {
        bh.consume((Object)((ContentTypeField)ContentTypeFieldImpl.PARSER.parse((Field)new RawField("Content-Type", "multipart/mixed;\r\n boundary=\"------------090404080405080108000909\""), DecodeMonitor.SILENT)).getBoundary());
    }

    @Benchmark
    public void contentTypeStrict(Blackhole bh) {
        bh.consume((Object)((ContentTypeField)ContentTypeFieldImpl.PARSER.parse((Field)new RawField("Content-Type", "multipart/mixed; boundary=\"------------090404080405080108000909\""), DecodeMonitor.SILENT)).getBoundary());
    }

    @Benchmark
    public void contentDispositionLenient(Blackhole bh) {
        bh.consume((Object)((ContentDispositionField)ContentDispositionFieldLenientImpl.PARSER.parse((Field)new RawField("Content-Disposition", "attachment; filename=blob.png"), DecodeMonitor.SILENT)).getFilename());
    }

    @Benchmark
    public void contentDispositionStrict(Blackhole bh) {
        bh.consume((Object)((ContentDispositionField)ContentDispositionFieldImpl.PARSER.parse((Field)new RawField("Content-Disposition", "attachment; filename=blob.png"), DecodeMonitor.SILENT)).getFilename());
    }
}

