/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.HelpFormatter;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.ValueConverter;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.InternalProfiler;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.profile.ProfilerOptionFormatter;
import org.openjdk.jmh.profile.ProfilerUtils;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ResultRole;
import org.openjdk.jmh.runner.options.IntegerValueConverter;
import org.openjdk.jmh.util.HashMultiset;
import org.openjdk.jmh.util.Multiset;
import org.openjdk.jmh.util.Multisets;

public class StackProfiler
implements InternalProfiler {
    private static final String[] IGNORED_THREADS = new String[]{"Finalizer", "Signal Dispatcher", "Reference Handler", "main", "Sampling Thread", "Attach Listener"};
    private final int stackLines;
    private final int topStacks;
    private final int periodMsec;
    private final boolean sampleLine;
    private final Set<String> excludePackageNames;
    private volatile SamplingTask samplingTask;

    public StackProfiler(String initLine) throws ProfilerException {
        OptionParser parser = new OptionParser();
        parser.formatHelpWith((HelpFormatter)new ProfilerOptionFormatter(StackProfiler.class.getCanonicalName()));
        ArgumentAcceptingOptionSpec optStackLines = parser.accepts("lines", "Number of stack lines to save in each stack trace. Larger values provide more insight into who is calling the top stack method, as the expense of more stack trace shapes to collect.").withRequiredArg().withValuesConvertedBy((ValueConverter)IntegerValueConverter.POSITIVE).describedAs("int").defaultsTo((Object)1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optTopStacks = parser.accepts("top", "Number of top stacks to show in the profiling results. Larger values may catch some stack traces that linger in the distribution tail.").withRequiredArg().withValuesConvertedBy((ValueConverter)IntegerValueConverter.POSITIVE).describedAs("int").defaultsTo((Object)10, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optSamplePeriod = parser.accepts("period", "Sampling period, in milliseconds. Smaller values improve accuracy, at the expense of more profiling overhead.").withRequiredArg().withValuesConvertedBy((ValueConverter)IntegerValueConverter.POSITIVE).describedAs("int").defaultsTo((Object)10, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optDetailLine = parser.accepts("detailLine", "Record detailed source line info. This adds the line numbers to the recorded stack traces.").withRequiredArg().ofType(Boolean.class).describedAs("bool").defaultsTo((Object)false, (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec optExclude = parser.accepts("excludePackages", "Enable package filtering. Use excludePackages option to control what packages are filtered").withRequiredArg().ofType(Boolean.class).describedAs("bool").defaultsTo((Object)false, (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec optExcludeClasses = parser.accepts("excludePackageNames", "Filter there packages. This is expected to be a comma-separated list\nof the fully qualified package names to be excluded. Every stack line that starts with the provided\npatterns will be excluded.").withRequiredArg().withValuesSeparatedBy(",").ofType(String.class).describedAs("package+").defaultsTo((Object)"java.", (Object[])new String[]{"javax.", "sun.", "sunw.", "com.sun.", "org.openjdk.jmh."});
        OptionSet set = ProfilerUtils.parseInitLine(initLine, parser);
        try {
            this.sampleLine = (Boolean)set.valueOf((OptionSpec)optDetailLine);
            this.periodMsec = (Integer)set.valueOf((OptionSpec)optSamplePeriod);
            this.topStacks = (Integer)set.valueOf((OptionSpec)optTopStacks);
            this.stackLines = (Integer)set.valueOf((OptionSpec)optStackLines);
            boolean excludePackages = (Boolean)set.valueOf((OptionSpec)optExclude);
            this.excludePackageNames = excludePackages ? new HashSet(set.valuesOf((OptionSpec)optExcludeClasses)) : Collections.emptySet();
        }
        catch (OptionException e) {
            throw new ProfilerException(e.getMessage());
        }
    }

    @Override
    public void beforeIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        this.samplingTask = new SamplingTask();
        this.samplingTask.start();
    }

    @Override
    public Collection<? extends Result> afterIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams, IterationResult result) {
        this.samplingTask.stop();
        return Collections.singleton(new StackResult(this.samplingTask.stacks, this.topStacks));
    }

    @Override
    public String getDescription() {
        return "Simple and naive Java stack profiler";
    }

    static String dottedLine(String header) {
        int HEADER_WIDTH = 100;
        StringBuilder sb = new StringBuilder();
        sb.append("....");
        if (header != null) {
            header = "[" + header + "]";
            sb.append(header);
        } else {
            header = "";
        }
        for (int c = 0; c < 96 - header.length(); ++c) {
            sb.append(".");
        }
        sb.append("\n");
        return sb.toString();
    }

    public static class StackResultAggregator
    implements Aggregator<StackResult> {
        @Override
        public StackResult aggregate(Collection<StackResult> results) {
            int topStacks = 0;
            EnumMap<Thread.State, Multiset<StackRecord>> sum = new EnumMap<Thread.State, Multiset<StackRecord>>(Thread.State.class);
            for (StackResult r : results) {
                for (Map.Entry entry : r.stacks.entrySet()) {
                    if (!sum.containsKey(entry.getKey())) {
                        sum.put((Thread.State)((Object)entry.getKey()), new HashMultiset());
                    }
                    Multiset sumSet = (Multiset)sum.get(entry.getKey());
                    for (StackRecord rec : ((Multiset)entry.getValue()).keys()) {
                        sumSet.add(rec, ((Multiset)entry.getValue()).count(rec));
                    }
                }
                topStacks = r.topStacks;
            }
            return new StackResult(sum, topStacks);
        }
    }

    public static class StackResult
    extends Result<StackResult> {
        private static final long serialVersionUID = 2609170863630346073L;
        private final Map<Thread.State, Multiset<StackRecord>> stacks;
        private final int topStacks;

        public StackResult(Map<Thread.State, Multiset<StackRecord>> stacks, int topStacks) {
            super(ResultRole.SECONDARY, "\u00b7stack", StackResult.of(Double.NaN), "---", AggregationPolicy.AVG);
            this.stacks = stacks;
            this.topStacks = topStacks;
        }

        @Override
        protected Aggregator<StackResult> getThreadAggregator() {
            return new StackResultAggregator();
        }

        @Override
        protected Aggregator<StackResult> getIterationAggregator() {
            return new StackResultAggregator();
        }

        @Override
        public String toString() {
            return "<delayed till summary>";
        }

        @Override
        public String extendedInfo() {
            return this.getStack(this.stacks);
        }

        public String getStack(final Map<Thread.State, Multiset<StackRecord>> stacks) {
            ArrayList<Thread.State> sortedStates = new ArrayList<Thread.State>(stacks.keySet());
            Collections.sort(sortedStates, new Comparator<Thread.State>(){

                private long stateSize(Thread.State state) {
                    Multiset set = (Multiset)stacks.get((Object)state);
                    return set == null ? 0L : set.size();
                }

                @Override
                public int compare(Thread.State s1, Thread.State s2) {
                    return Long.compare(this.stateSize(s2), this.stateSize(s1));
                }
            });
            long totalSize = this.getTotalSize(stacks);
            StringBuilder builder = new StringBuilder();
            builder.append("Stack profiler:\n\n");
            builder.append(StackProfiler.dottedLine("Thread state distributions"));
            for (Thread.State state : sortedStates) {
                if (!this.isSignificant(stacks.get((Object)state).size(), totalSize)) continue;
                builder.append(String.format("%5.1f%% %7s %s%n", new Object[]{(double)stacks.get((Object)state).size() * 100.0 / (double)totalSize, "", state}));
            }
            builder.append("\n");
            for (Thread.State state : sortedStates) {
                Multiset<StackRecord> stateStacks = stacks.get((Object)state);
                if (!this.isSignificant(stateStacks.size(), totalSize)) continue;
                builder.append(StackProfiler.dottedLine("Thread state: " + state.toString()));
                int totalDisplayed = 0;
                for (StackRecord s : Multisets.countHighest(stateStacks, this.topStacks)) {
                    List<String> lines = s.lines;
                    if (lines.isEmpty()) continue;
                    totalDisplayed = (int)((long)totalDisplayed + stateStacks.count(s));
                    builder.append(String.format("%5.1f%% %5.1f%% %s%n", (double)stateStacks.count(s) * 100.0 / (double)totalSize, (double)stateStacks.count(s) * 100.0 / (double)stateStacks.size(), lines.get(0)));
                    if (lines.size() <= 1) continue;
                    for (int i = 1; i < lines.size(); ++i) {
                        builder.append(String.format("%13s %s%n", "", lines.get(i)));
                    }
                    builder.append("\n");
                }
                if (this.isSignificant(stateStacks.size() - (long)totalDisplayed, stateStacks.size())) {
                    builder.append(String.format("%5.1f%% %5.1f%% %s%n", (double)(stateStacks.size() - (long)totalDisplayed) * 100.0 / (double)totalSize, (double)(stateStacks.size() - (long)totalDisplayed) * 100.0 / (double)stateStacks.size(), "<other>"));
                }
                builder.append("\n");
            }
            return builder.toString();
        }

        private boolean isSignificant(long part, long total) {
            return part * 1000L >= total;
        }

        private long getTotalSize(Map<Thread.State, Multiset<StackRecord>> stacks) {
            long sum = 0L;
            for (Multiset<StackRecord> set : stacks.values()) {
                sum += set.size();
            }
            return sum;
        }
    }

    private static class StackRecord
    implements Serializable {
        private static final long serialVersionUID = -1829626661894754733L;
        public final List<String> lines;

        private StackRecord(List<String> lines) {
            this.lines = lines;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StackRecord that = (StackRecord)o;
            return this.lines.equals(that.lines);
        }

        public int hashCode() {
            return this.lines.hashCode();
        }
    }

    public class SamplingTask
    implements Runnable {
        private final Thread thread;
        private final Map<Thread.State, Multiset<StackRecord>> stacks = new EnumMap<Thread.State, Multiset<StackRecord>>(Thread.State.class);

        public SamplingTask() {
            for (Thread.State s : Thread.State.values()) {
                this.stacks.put(s, new HashMultiset());
            }
            this.thread = new Thread(this);
            this.thread.setName("Sampling Thread");
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                ThreadInfo[] infos;
                block3: for (ThreadInfo info : infos = ManagementFactory.getThreadMXBean().dumpAllThreads(false, false)) {
                    for (String ignore : IGNORED_THREADS) {
                        if (info.getThreadName().equalsIgnoreCase(ignore)) continue block3;
                    }
                    StackTraceElement[] stack = info.getStackTrace();
                    ArrayList<String> lines = new ArrayList<String>();
                    for (StackTraceElement l : stack) {
                        String className = l.getClassName();
                        if (this.isExcluded(className)) continue;
                        lines.add(className + '.' + l.getMethodName() + (StackProfiler.this.sampleLine ? ":" + l.getLineNumber() : ""));
                        if (lines.size() >= StackProfiler.this.stackLines) break;
                    }
                    if (lines.isEmpty()) {
                        lines.add("<stack is empty, everything is filtered?>");
                    }
                    Thread.State state = info.getThreadState();
                    this.stacks.get((Object)state).add(new StackRecord(lines));
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(StackProfiler.this.periodMsec);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }

        public void start() {
            this.thread.start();
        }

        public void stop() {
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        private boolean isExcluded(String className) {
            for (String p : StackProfiler.this.excludePackageNames) {
                if (!className.startsWith(p)) continue;
                return true;
            }
            return false;
        }
    }
}

