/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.enumerated.AxisScaleEnumeration;
import org.eclipse.milo.opcua.stack.core.types.structured.EUInformation;
import org.eclipse.milo.opcua.stack.core.types.structured.Range;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class AxisInformation
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12079");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12081");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12089");
    private final EUInformation engineeringUnits;
    private final Range euRange;
    private final LocalizedText title;
    private final AxisScaleEnumeration axisScaleType;
    private final Double[] axisSteps;

    public AxisInformation(EUInformation engineeringUnits, Range euRange, LocalizedText title, AxisScaleEnumeration axisScaleType, Double[] axisSteps) {
        this.engineeringUnits = engineeringUnits;
        this.euRange = euRange;
        this.title = title;
        this.axisScaleType = axisScaleType;
        this.axisSteps = axisSteps;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public EUInformation getEngineeringUnits() {
        return this.engineeringUnits;
    }

    public Range getEuRange() {
        return this.euRange;
    }

    public LocalizedText getTitle() {
        return this.title;
    }

    public AxisScaleEnumeration getAxisScaleType() {
        return this.axisScaleType;
    }

    public Double[] getAxisSteps() {
        return this.axisSteps;
    }

    protected AxisInformation(AxisInformationBuilder<?, ?> b) {
        super(b);
        this.engineeringUnits = ((AxisInformationBuilder)b).engineeringUnits;
        this.euRange = ((AxisInformationBuilder)b).euRange;
        this.title = ((AxisInformationBuilder)b).title;
        this.axisScaleType = ((AxisInformationBuilder)b).axisScaleType;
        this.axisSteps = ((AxisInformationBuilder)b).axisSteps;
    }

    public static AxisInformationBuilder<?, ?> builder() {
        return new AxisInformationBuilderImpl();
    }

    public AxisInformationBuilder<?, ?> toBuilder() {
        return new AxisInformationBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AxisInformation)) {
            return false;
        }
        AxisInformation other = (AxisInformation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EUInformation this$engineeringUnits = this.getEngineeringUnits();
        EUInformation other$engineeringUnits = other.getEngineeringUnits();
        if (this$engineeringUnits == null ? other$engineeringUnits != null : !((Object)this$engineeringUnits).equals(other$engineeringUnits)) {
            return false;
        }
        Range this$euRange = this.getEuRange();
        Range other$euRange = other.getEuRange();
        if (this$euRange == null ? other$euRange != null : !((Object)this$euRange).equals(other$euRange)) {
            return false;
        }
        LocalizedText this$title = this.getTitle();
        LocalizedText other$title = other.getTitle();
        if (this$title == null ? other$title != null : !((Object)this$title).equals(other$title)) {
            return false;
        }
        AxisScaleEnumeration this$axisScaleType = this.getAxisScaleType();
        AxisScaleEnumeration other$axisScaleType = other.getAxisScaleType();
        if (this$axisScaleType == null ? other$axisScaleType != null : !this$axisScaleType.equals(other$axisScaleType)) {
            return false;
        }
        return Arrays.deepEquals(this.getAxisSteps(), other.getAxisSteps());
    }

    protected boolean canEqual(Object other) {
        return other instanceof AxisInformation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EUInformation $engineeringUnits = this.getEngineeringUnits();
        result = result * 59 + ($engineeringUnits == null ? 43 : ((Object)$engineeringUnits).hashCode());
        Range $euRange = this.getEuRange();
        result = result * 59 + ($euRange == null ? 43 : ((Object)$euRange).hashCode());
        LocalizedText $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : ((Object)$title).hashCode());
        AxisScaleEnumeration $axisScaleType = this.getAxisScaleType();
        result = result * 59 + ($axisScaleType == null ? 43 : $axisScaleType.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getAxisSteps());
        return result;
    }

    @Override
    public String toString() {
        return "AxisInformation(engineeringUnits=" + this.getEngineeringUnits() + ", euRange=" + this.getEuRange() + ", title=" + this.getTitle() + ", axisScaleType=" + this.getAxisScaleType() + ", axisSteps=" + Arrays.deepToString(this.getAxisSteps()) + ")";
    }

    private static final class AxisInformationBuilderImpl
    extends AxisInformationBuilder<AxisInformation, AxisInformationBuilderImpl> {
        private AxisInformationBuilderImpl() {
        }

        @Override
        protected AxisInformationBuilderImpl self() {
            return this;
        }

        @Override
        public AxisInformation build() {
            return new AxisInformation(this);
        }
    }

    public static abstract class AxisInformationBuilder<C extends AxisInformation, B extends AxisInformationBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private EUInformation engineeringUnits;
        private Range euRange;
        private LocalizedText title;
        private AxisScaleEnumeration axisScaleType;
        private Double[] axisSteps;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AxisInformationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(AxisInformation instance, AxisInformationBuilder<?, ?> b) {
            b.engineeringUnits(instance.engineeringUnits);
            b.euRange(instance.euRange);
            b.title(instance.title);
            b.axisScaleType(instance.axisScaleType);
            b.axisSteps(instance.axisSteps);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B engineeringUnits(EUInformation engineeringUnits) {
            this.engineeringUnits = engineeringUnits;
            return (B)this.self();
        }

        public B euRange(Range euRange) {
            this.euRange = euRange;
            return (B)this.self();
        }

        public B title(LocalizedText title) {
            this.title = title;
            return (B)this.self();
        }

        public B axisScaleType(AxisScaleEnumeration axisScaleType) {
            this.axisScaleType = axisScaleType;
            return (B)this.self();
        }

        public B axisSteps(Double[] axisSteps) {
            this.axisSteps = axisSteps;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "AxisInformation.AxisInformationBuilder(super=" + super.toString() + ", engineeringUnits=" + this.engineeringUnits + ", euRange=" + this.euRange + ", title=" + this.title + ", axisScaleType=" + this.axisScaleType + ", axisSteps=" + Arrays.deepToString(this.axisSteps) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<AxisInformation> {
        @Override
        public Class<AxisInformation> getType() {
            return AxisInformation.class;
        }

        @Override
        public AxisInformation decode(SerializationContext context, UaDecoder decoder) {
            EUInformation engineeringUnits = (EUInformation)decoder.readStruct("EngineeringUnits", EUInformation.TYPE_ID);
            Range euRange = (Range)decoder.readStruct("EURange", Range.TYPE_ID);
            LocalizedText title = decoder.readLocalizedText("Title");
            AxisScaleEnumeration axisScaleType = decoder.readEnum("AxisScaleType", AxisScaleEnumeration.class);
            Double[] axisSteps = decoder.readDoubleArray("AxisSteps");
            return new AxisInformation(engineeringUnits, euRange, title, axisScaleType, axisSteps);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, AxisInformation value) {
            encoder.writeStruct("EngineeringUnits", (Object)value.getEngineeringUnits(), EUInformation.TYPE_ID);
            encoder.writeStruct("EURange", (Object)value.getEuRange(), Range.TYPE_ID);
            encoder.writeLocalizedText("Title", value.getTitle());
            encoder.writeEnum("AxisScaleType", value.getAxisScaleType());
            encoder.writeDoubleArray("AxisSteps", value.getAxisSteps());
        }
    }
}

