/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.fileSystem.fileInputFactory;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.fileSystem.fileInputFactory.FileInputFactory;
import org.apache.tsfile.read.reader.TsFileInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSFileInputFactory
implements FileInputFactory {
    private static final Logger logger = LoggerFactory.getLogger(OSFileInputFactory.class);
    private Constructor constructor;

    public OSFileInputFactory() {
        try {
            Class<?> clazz = Class.forName(TSFileDescriptor.getInstance().getConfig().getObjectStorageTsFileInput());
            this.constructor = clazz.getConstructor(String.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            logger.error("Failed to get OSInput in object storage. Please check your dependency of object storage module.", (Throwable)e);
        }
    }

    @Override
    public TsFileInput getTsFileInput(String filePath) throws IOException {
        try {
            return (TsFileInput)this.constructor.newInstance(filePath);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IOException(String.format("Failed to get TsFile input of file: %s. Please check your dependency of object storage module.", filePath), e);
        }
    }
}

