/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.compress.IUnCompressor;
import org.apache.tsfile.encoding.decoder.Decoder;
import org.apache.tsfile.encrypt.EncryptParameter;
import org.apache.tsfile.encrypt.IDecryptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.reader.chunk.ChunkReader;
import org.apache.tsfile.read.reader.page.PageReader;
import org.apache.tsfile.utils.Pair;

public class CompactionChunkReader {
    private final ChunkHeader chunkHeader;
    private ByteBuffer chunkDataBuffer;
    private final IUnCompressor unCompressor;
    private final EncryptParameter encryptParam;
    private final Decoder timeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);
    private final Statistics chunkStatistic;
    private final List<TimeRange> deleteIntervalList;

    public CompactionChunkReader(Chunk chunk) {
        this.chunkHeader = chunk.getHeader();
        this.chunkDataBuffer = chunk.getData();
        this.unCompressor = IUnCompressor.getUnCompressor((CompressionType)this.chunkHeader.getCompressionType());
        this.deleteIntervalList = chunk.getDeleteIntervalList();
        this.chunkStatistic = chunk.getChunkStatistic();
        this.encryptParam = chunk.getEncryptParam();
    }

    public ByteBuffer readPageDataWithoutUncompressing(PageHeader pageHeader) throws IOException {
        return CompactionChunkReader.readCompressedPageData(pageHeader, this.chunkDataBuffer);
    }

    public List<Pair<PageHeader, ByteBuffer>> readPageDataWithoutUncompressing() throws IOException {
        ArrayList<Pair<PageHeader, ByteBuffer>> pages = new ArrayList<Pair<PageHeader, ByteBuffer>>();
        while (this.chunkDataBuffer.remaining() > 0) {
            PageHeader pageHeader = (byte)(this.chunkHeader.getChunkType() & 0x3F) == 5 ? PageHeader.deserializeFrom((ByteBuffer)this.chunkDataBuffer, (Statistics)this.chunkStatistic) : PageHeader.deserializeFrom((ByteBuffer)this.chunkDataBuffer, (TSDataType)this.chunkHeader.getDataType());
            if (pageHeader.getCompressedSize() == 0) {
                pages.add(null);
                continue;
            }
            ByteBuffer compressedPageData = CompactionChunkReader.readCompressedPageData(pageHeader, this.chunkDataBuffer);
            Pair page = new Pair((Object)pageHeader, (Object)compressedPageData);
            pages.add((Pair<PageHeader, ByteBuffer>)page);
        }
        this.chunkDataBuffer = null;
        return pages;
    }

    public static ByteBuffer readCompressedPageData(PageHeader pageHeader, ByteBuffer chunkBuffer) throws IOException {
        int compressedPageBodyLength = pageHeader.getCompressedSize();
        if (compressedPageBodyLength > chunkBuffer.remaining()) {
            throw new IOException("do not have a complete page body. Expected:" + compressedPageBodyLength + ". Actual:" + chunkBuffer.remaining());
        }
        ByteBuffer pageBodyBuffer = chunkBuffer.slice();
        pageBodyBuffer.limit(compressedPageBodyLength);
        chunkBuffer.position(chunkBuffer.position() + compressedPageBodyLength);
        return pageBodyBuffer;
    }

    public TsBlock readPageData(PageHeader pageHeader, ByteBuffer compressedPageData) throws IOException {
        IDecryptor decryptor = IDecryptor.getDecryptor((EncryptParameter)this.encryptParam);
        ByteBuffer pageData = ChunkReader.decryptAndUncompressPageData((PageHeader)pageHeader, (IUnCompressor)this.unCompressor, (ByteBuffer)compressedPageData, (IDecryptor)decryptor);
        TSDataType dataType = this.chunkHeader.getDataType();
        Decoder valueDecoder = Decoder.getDecoderByType((TSEncoding)this.chunkHeader.getEncodingType(), (TSDataType)dataType);
        PageReader pageReader = new PageReader(pageHeader, pageData, dataType, valueDecoder, this.timeDecoder, null);
        pageReader.setDeleteIntervalList(this.deleteIntervalList);
        return pageReader.getAllSatisfiedData();
    }
}

