#A UCI Archive dataset. See this link for more detailed information: https://archive.ics.uci.edu/ml/datasets/Japanese+Vowels
#Paper: M. Kudo, J. Toyama and M. Shimbo. (1999). "Multidimensional Curve Classification Using Passing-Through Regions". Pattern Recognition Letters, Vol. 20, No. 11--13, pages 1103--1111.
#
#
#9 Japanese-male speakers were recorded saying the vowels 'a' and 'e'. A '12-degree linear prediction analysis' is applied to the raw recordings to obtain time-series with 12 dimensions and series lengths between 7 and 29. The classification task is to predict the speaker. Therefore, each instance is a transformed utterance, 12*29 values with a single class label attached, [1...9].
#
#The given training set is comprised of 30 utterances for each speaker, however the test set has a varied distribution based on external factors of timing and experimental availability, between 24 and 88 instances per speaker.
@problemName JapaneseVowels
@timeStamps false
@missing false
@univariate false
@dimensions 12
@equalLength false
@classLabel true 1 2 3 4 5 6 7 8 9
@data
1.635533,1.547694,1.602593,1.672665,1.748497,1.870264,1.682187,1.745937,1.453572,1.416367,1.466251,1.515589,1.321718,1.297911,1.487302,1.547938,1.546531,1.508858,1.388998:0.024848,0.008754,-0.21052,-0.343458,-0.404425,-0.547399,-0.401484,-0.417672,-0.286032,-0.410469,-0.38535,-0.370543,-0.311942,-0.398088,-0.562759,-0.579402,-0.556976,-0.700941,-0.728562:0.432087,0.319101,0.280175,0.263109,0.238913,0.248318,0.093114,0.179397,0.186518,0.352763,0.294102,0.357567,0.462991,0.596941,0.821156,0.765664,0.712057,0.839349,0.801037:-0.361914,-0.29744,-0.233207,-0.167267,-0.152473,-0.170991,-0.119936,-0.282905,-0.237188,-0.211245,-0.109096,-0.050578,0.144054,0.122182,0.022307,0.04268,0.07276,0.134621,0.101208:-0.074776,-0.007617,-0.024576,0.043357,0.135756,0.121421,0.102706,0.235438,0.32285,0.354378,0.418092,0.379828,0.260473,0.33553,0.372292,0.355656,0.338227,0.281151,0.287227:-0.693481,-0.636042,-0.592074,-0.564522,-0.513615,-0.418381,-0.358395,-0.350983,-0.24516,-0.16526,-0.220405,-0.207061,-0.18642,-0.230978,-0.282325,-0.275494,-0.271046,-0.296476,-0.065235:-0.229621,-0.29648,-0.239185,-0.286775,-0.339162,-0.276134,-0.204987,-0.195268,-0.276801,-0.328168,-0.328038,-0.33324,-0.406317,-0.400463,-0.476835,-0.424934,-0.331239,-0.324758,-0.36335:0.261503,0.2627,0.253176,0.230736,0.22183,0.177995,0.17281,0.154338,0.069911,-0.044124,-0.092659,-0.103308,-0.180396,-0.166666,-0.110096,-0.126804,-0.159139,-0.136773,-0.138497:-0.089421,-0.118514,-0.104336,-0.122032,-0.143803,-0.131599,-0.108218,-0.193545,-0.206899,-0.182794,-0.184805,-0.170728,-0.062192,-0.108452,-0.18034,-0.227243,-0.248844,-0.219273,-0.127783:-0.020431,-0.085128,-0.093679,-0.099552,-0.099815,-0.132569,-0.204713,-0.193992,-0.195329,-0.192191,-0.142367,-0.140336,-0.176076,-0.163514,-0.185136,-0.186781,-0.159776,-0.09592,-0.235129:-0.008612,0.030408,-0.004921,0.001257,0.002327,-0.066062,-0.148013,-0.202009,-0.126377,-0.103902,-0.13488,-0.1415,-0.102425,-0.093735,-0.109658,-0.059158,-0.064375,-0.14807,-0.06768:0.139754,0.118123,0.130402,0.113616,0.065812,0.058135,0.060795,0.072734,0.04813,0.10329,0.077458,0.029781,0.001619,0.015284,0.097182,0.117885,0.133143,0.06949,0.108629:1
1.346025,1.383691,1.405958,1.412603,1.446064,1.400231,1.376047,1.387501,1.361794,1.054153,0.894543,0.839384,0.755131,0.722792,0.630548,0.560397,0.569919:-0.519155,-0.598065,-0.555516,-0.671019,-0.936608,-0.68394,-0.595044,-0.662854,-0.702082,-0.569813,-0.52929,-0.513709,-0.580494,-0.507053,-0.423411,-0.376657,-0.426436:0.651902,0.647915,0.752111,0.589594,0.490718,0.489114,0.40442,0.476828,0.674177,0.945773,1.042762,1.122638,1.185302,1.199358,1.170455,1.122267,1.328993:-0.296536,-0.217294,-0.216131,-0.230615,-0.338223,-0.321042,-0.081591,0.063931,0.142675,0.186283,0.147954,0.222671,0.267167,0.24945,0.288878,0.419521,0.32298:-0.112782,-0.068715,0.065364,0.063027,0.046952,0.127285,0.162077,0.162819,0.210557,0.324873,0.352601,0.35727,0.424501,0.463566,0.393472,0.314551,0.412969:-0.099619,-0.083936,-0.09879,0.018982,0.14993,0.097517,0.135335,0.187999,0.069994,-0.126414,-0.03029,-0.038884,0.014358,0.093622,0.166311,0.141812,0.133677:-0.115291,-0.131485,-0.23063,-0.144944,-0.112616,-0.130539,-0.161962,-0.219977,-0.225654,-0.268446,-0.206615,-0.202166,-0.233749,-0.152855,-0.055463,-0.014792,-0.113957:0.339611,0.236828,0.131239,0.133128,0.121433,0.091988,-0.044528,-0.057997,-0.06681,-0.016307,-0.042117,0.0214,0.033737,-0.069479,-0.183218,-0.189027,-0.083313:-0.003044,-0.085273,-0.160727,-0.178021,-0.139627,-0.198951,-0.204831,-0.238385,-0.285646,-0.274511,-0.308631,-0.283823,-0.267625,-0.288076,-0.28337,-0.216243,-0.161285:-0.363407,-0.309786,-0.230074,-0.30834,-0.357133,-0.387992,-0.384834,-0.424237,-0.307568,-0.155997,-0.126849,-0.167173,-0.135804,-0.023773,0.082538,0.083488,0.085044:-0.026334,0.053105,0.070663,-0.052759,-0.085795,-0.120141,-0.071462,-0.004846,0.080081,0.066983,0.099367,0.089642,0.092472,0.070651,0.020099,-0.035698,-0.053023:0.038856,0.041171,0.047138,0.07614,0.089443,0.106324,0.171193,0.192549,0.086813,-0.075748,-0.129332,-0.173624,-0.243628,-0.258437,-0.294943,-0.278659,-0.32384:1
1.512185,1.65564,1.661793,1.737399,1.795333,1.838254,1.697602,1.679164,1.615161,1.675849,1.684496,1.63315,1.634308,1.565723,1.473596,1.490078,1.484179,1.693701,1.576104:-0.3335,-0.391342,-0.402195,-0.482062,-0.491939,-0.444471,-0.38798,-0.329484,-0.467865,-0.580061,-0.545537,-0.600808,-0.575518,-0.508004,-0.585602,-0.653257,-0.616083,-0.790498,-0.862274:0.471234,0.517804,0.549835,0.598729,0.601682,0.590472,0.464788,0.355374,0.38928,0.418193,0.324973,0.385462,0.479257,0.446035,0.414287,0.446414,0.375652,0.489733,0.464136:-0.384034,-0.464914,-0.48232,-0.503786,-0.474496,-0.513551,-0.473392,-0.432256,-0.40799,-0.438228,-0.348659,-0.282592,-0.206515,-0.087381,0.024195,0.066392,0.089378,0.013031,0.081487:-0.210589,-0.156108,-0.161172,-0.149053,-0.161039,-0.119136,-0.036916,0.035113,0.030288,0.117972,0.236719,0.323339,0.478854,0.556704,0.455399,0.480976,0.53717,0.543174,0.552183:-0.370054,-0.360399,-0.339728,-0.306979,-0.292658,-0.267148,-0.263292,-0.197815,-0.04834,-0.038801,-0.135704,-0.154308,-0.187659,-0.204583,-0.139916,-0.103687,-0.10176,-0.052558,-0.013068:-0.181539,-0.254421,-0.247079,-0.276269,-0.269059,-0.311558,-0.303874,-0.315694,-0.314698,-0.353876,-0.415676,-0.484589,-0.618975,-0.588855,-0.456419,-0.43608,-0.469218,-0.539118,-0.522814:0.350905,0.32373,0.310328,0.264726,0.2184,0.22734,0.261366,0.272385,0.145797,0.092082,0.111234,0.083154,0.041107,0.001088,-0.018831,-0.011642,-0.017098,-0.010876,-0.013132:-0.01802,-0.035221,-0.090744,-0.137306,-0.10058,-0.030144,-0.062113,-0.088523,-0.084252,-0.13377,-0.206977,-0.23647,-0.201508,-0.202275,-0.264412,-0.300611,-0.265656,-0.243402,-0.230202:-0.189616,-0.23407,-0.234772,-0.235484,-0.254699,-0.324015,-0.390673,-0.421688,-0.35266,-0.329098,-0.31368,-0.285848,-0.221438,-0.156315,-0.206895,-0.229628,-0.239227,-0.268864,-0.300179:0.043861,0.050662,0.070845,0.077018,0.004863,-0.077397,-0.05436,-0.059489,-0.110036,-0.114842,-0.043395,0.004798,0.018803,0.015014,0.089552,0.131973,0.090342,0.083907,0.072618:0.071755,0.099892,0.064375,0.054427,0.106071,0.153465,0.137128,0.059995,0.002565,0.004687,-0.020386,-0.024854,-0.054331,-0.06466,-0.003693,-0.006097,-0.014393,-0.037409,-0.04654:1
1.418749,1.609693,1.591019,1.548898,1.519423,1.34785,1.380883,1.595615,1.62313,1.818151,1.562489,1.569343,1.546906,1.654228,1.46608,1.224867,1.367969,1.412283:0.129034,-0.148622,-0.205715,-0.255381,-0.298427,-0.187577,-0.311086,-0.405964,-0.396171,-0.631091,-0.483535,-0.646485,-0.69087,-0.744388,-0.656361,-0.605818,-0.759905,-0.773601:0.47528,0.525358,0.406879,0.446795,0.396608,0.226653,0.314027,0.397954,0.31412,0.305914,0.179471,0.399544,0.517581,0.482276,0.328352,0.324949,0.343694,0.382423:-0.400347,-0.388008,-0.372406,-0.471757,-0.470015,-0.387164,-0.468865,-0.573797,-0.462358,-0.282813,-0.014985,-0.122317,-0.246222,-0.103008,0.245393,0.328868,0.34163,0.372458:0.040541,-0.032264,-0.081218,-0.028981,-0.019213,-0.00983,0.047159,0.093352,0.141207,0.131719,0.138767,0.287202,0.355258,0.371685,0.2306,0.283269,0.340157,0.346481:-0.57686,-0.43117,-0.429341,-0.507287,-0.519322,-0.500333,-0.442642,-0.372592,-0.343424,-0.311154,-0.31303,-0.270242,-0.138949,-0.098752,-0.024142,-0.039681,0.024921,0.085014:-0.259998,-0.279059,-0.212728,-0.256749,-0.213676,-0.199827,-0.214191,-0.251626,-0.24678,-0.231564,-0.308714,-0.35826,-0.411818,-0.399082,-0.368349,-0.403851,-0.413321,-0.424451:0.180785,0.158753,0.212601,0.346326,0.348197,0.335775,0.349855,0.385366,0.326121,0.229033,0.135085,0.091973,0.082902,-0.006719,-0.048351,-0.019427,-0.044715,-0.058962:-0.036081,-0.094318,-0.076819,-0.131395,-0.146555,-0.111405,-0.142855,-0.18489,-0.20835,-0.224699,-0.152757,-0.204986,-0.242703,-0.264387,-0.247093,-0.236947,-0.205051,-0.17258:-0.098609,-0.071577,-0.096227,-0.156897,-0.141138,-0.162382,-0.202872,-0.250792,-0.270211,-0.225312,-0.23004,-0.226961,-0.300254,-0.256436,-0.302349,-0.297585,-0.299596,-0.317765:0.020065,0.052514,0.021305,0.040591,-0.004335,-0.024837,-0.012366,0.005091,0.022227,-0.016932,-0.013431,-0.015025,-0.005285,0.013164,0.097602,0.097801,0.108457,0.103472:0.133878,0.068214,0.049853,0.059085,0.069171,0.069645,0.082244,0.075927,0.095935,0.064074,0.076996,0.09697,0.107785,0.054601,0.067372,0.064015,0.064431,0.078916:1
1.441249,1.570194,1.55428,1.4297,1.407488,1.433324,1.366628,1.406246,1.405271,1.616638,1.344652,1.308726,1.330481,1.379264,1.226955,1.233381,1.407183,1.532635,1.446407,1.378834,1.436548,1.58033,1.586679,1.505987:-0.19691,-0.320125,-0.317436,-0.244747,-0.181479,-0.225448,-0.287229,-0.418003,-0.439407,-0.541645,-0.36141,-0.506875,-0.590703,-0.551017,-0.421396,-0.414197,-0.605374,-0.66687,-0.728952,-0.694198,-0.598839,-0.758505,-0.734318,-0.65448:0.480571,0.547031,0.573071,0.529617,0.420993,0.443481,0.478141,0.51642,0.498032,0.576921,0.407062,0.549703,0.573636,0.540382,0.416109,0.394049,0.423808,0.455949,0.562946,0.51823,0.428103,0.449784,0.449024,0.545702:-0.446748,-0.460288,-0.485027,-0.48104,-0.422055,-0.393436,-0.36214,-0.344242,-0.275687,-0.319906,-0.174721,-0.126479,-0.044766,-0.072216,0.016116,0.067595,0.197096,0.226852,0.152003,0.152827,0.140897,0.176902,0.21974,0.181495:-0.118123,-0.154588,-0.142375,-0.075284,-0.042099,-0.102964,-0.109434,-0.040601,0.007325,0.007402,0.005037,-0.065794,-0.06911,0.090368,0.18639,0.144318,0.090429,0.162902,0.282742,0.31479,0.33602,0.370277,0.402146,0.433807:-0.372871,-0.308658,-0.301735,-0.33235,-0.361966,-0.31561,-0.247138,-0.208681,-0.162858,-0.139067,-0.10663,0.020474,-0.008311,-0.127407,-0.17545,-0.143461,-0.052413,-0.040818,0.041037,0.038999,0.057906,0.063632,0.027734,0.031308:-0.162448,-0.142441,-0.117745,-0.141365,-0.061584,0.050606,0.018957,-0.036404,-0.060018,-0.038571,-0.004148,-0.042475,-0.018955,-0.024221,-0.039263,-0.00922,-0.107892,-0.156986,-0.301462,-0.298125,-0.277271,-0.331968,-0.3363,-0.360886:0.387664,0.362066,0.348652,0.336681,0.294788,0.233166,0.264414,0.282986,0.224104,0.186664,0.16929,0.136345,0.128942,0.074735,-0.127736,-0.236112,-0.167047,-0.184608,-0.137123,-0.072498,-0.115518,-0.092505,-0.097275,-0.096912:-0.082049,-0.143885,-0.189732,-0.203517,-0.20211,-0.225583,-0.275269,-0.293459,-0.286211,-0.329239,-0.364764,-0.349928,-0.382053,-0.420617,-0.358387,-0.303605,-0.331144,-0.300219,-0.260861,-0.308671,-0.285343,-0.260174,-0.251187,-0.244822:-0.192631,-0.239804,-0.21683,-0.22564,-0.208838,-0.199348,-0.241578,-0.307119,-0.39628,-0.409586,-0.426486,-0.476416,-0.474327,-0.403357,-0.341525,-0.338016,-0.315017,-0.280398,-0.271987,-0.309463,-0.291894,-0.301183,-0.285776,-0.278578:0.033554,0.087423,0.101555,0.121011,0.055656,-0.012613,0.011817,-0.004674,-0.048553,-0.078115,-0.035836,-0.008219,-0.011133,-0.034252,-0.015245,-0.020634,0.044318,0.051838,0.101131,0.148453,0.106559,0.109651,0.094954,0.120958:-0.008581,-9.63E-4,-0.006452,0.026731,0.062087,0.064897,0.004772,0.022589,0.113528,0.151639,0.111327,0.116695,0.120227,0.152192,0.235838,0.265982,0.192592,0.194279,0.124019,0.108892,0.111491,0.084185,0.082922,0.059299:1
1.500345,1.439003,1.57216,1.71262,1.760028,1.625381,1.899547,1.588128,1.737175,1.749562,1.792961,1.487892,1.444345,1.49818,1.515002,1.387288,1.325515:0.071545,-0.025286,-0.218886,-0.344893,-0.358188,-0.146109,-0.39235,-0.288736,-0.526325,-0.38726,-0.299038,-0.167758,-0.200262,-0.339891,-0.49175,-0.582257,-0.605534:0.588714,0.662779,0.798033,0.762456,0.702555,0.456262,0.587188,0.546924,0.669194,0.479944,0.265968,0.248618,0.235823,0.266016,0.472252,0.714046,0.744111:-0.204872,-0.270059,-0.347939,-0.303574,-0.232237,-0.088439,-0.199909,-0.129422,-0.264779,-0.125294,-0.04494,-0.109985,-0.085263,0.018302,-0.043529,-0.049027,0.020154:-0.50566,-0.4067,-0.24973,-0.183667,-0.196851,-0.274514,-0.282198,-0.273624,-0.098381,-0.062533,0.019714,0.105091,0.235726,0.28121,0.330324,0.316291,0.283795:-0.318105,-0.292976,-0.348335,-0.344504,-0.342045,-0.360362,-0.28265,-0.253622,-0.178226,-0.124175,-0.167782,-0.087711,-0.047464,-0.06495,-0.028194,0.017595,0.009961:-0.054164,-0.074927,-0.150359,-0.211212,-0.18834,-0.06733,-0.111491,-0.156791,-0.225852,-0.208718,-0.111708,-0.129348,-0.188115,-0.223262,-0.310908,-0.352213,-0.341384:0.24602,0.268998,0.310668,0.317592,0.29487,0.246222,0.290761,0.217581,0.161268,0.151514,0.145198,0.041006,-0.045274,-0.060338,-0.0715,-0.094813,-0.106758:8.86E-4,0.00573,-0.073741,-0.089635,-0.067772,-0.047889,-0.067809,-0.04495,-0.075025,-0.0851,-0.189304,-0.136961,-0.138264,-0.264617,-0.238322,-0.263307,-0.264783:-0.132745,-0.223457,-0.226842,-0.251808,-0.256098,-0.239884,-0.305509,-0.318827,-0.350797,-0.447409,-0.421589,-0.477298,-0.420646,-0.352943,-0.358486,-0.299053,-0.290922:0.161809,0.118485,0.113925,0.128402,0.109758,0.041829,0.063673,0.049879,-0.011518,-0.009381,-0.065233,-0.099822,-0.121175,-0.020135,-0.002014,0.089892,0.132792:0.048633,0.075352,0.100098,0.116893,0.136111,0.133483,0.102956,0.15275,0.211395,0.235726,0.191466,0.222562,0.201782,0.175192,0.186489,0.126886,0.106179:1
1.29813,1.337119,1.364151,1.335037,1.49081,1.340545,1.397495,1.437529,1.450619,1.390144,1.399804,1.178201,1.318923,1.243483,1.053522,1.061075,1.021913:-0.204391,-0.229271,-0.238987,-0.215495,-0.319745,-0.351848,-0.503843,-0.498636,-0.600333,-0.727075,-0.762135,-0.641641,-0.761397,-0.710449,-0.471727,-0.460571,-0.51678:0.800532,0.695718,0.689878,0.522437,0.305777,0.372448,0.47041,0.464379,0.597372,0.676456,0.670546,0.652039,1.016823,1.005393,0.759131,0.813745,0.91066:-0.493828,-0.35941,-0.402667,-0.293138,-0.334538,-0.299475,-0.226597,-0.120649,-0.166175,-0.124334,-0.046879,0.080602,-0.102251,-0.142041,0.020565,0.048167,0.029619:-0.308468,-0.383559,-0.300774,-0.1865,0.05518,0.065352,0.101205,0.131203,0.180316,0.275883,0.405863,0.374931,0.279588,0.362583,0.457681,0.419348,0.470729:-0.326608,-0.262643,-0.198337,-0.198758,-0.262746,-0.174786,-0.098027,-0.084186,-0.006712,0.054657,0.043897,0.104423,0.242179,0.276969,0.143749,0.155399,0.130612:0.044441,0.047956,-0.052395,-0.088247,-0.063942,-0.086333,-0.132705,-0.078565,-0.143253,-0.305154,-0.364629,-0.320441,-0.33482,-0.396695,-0.336466,-0.276565,-0.27869:0.286279,0.229711,0.251273,0.176662,0.188418,0.261406,0.155955,-2.91E-4,-0.023537,-0.088756,-0.148214,-0.15926,-0.175908,-0.154795,-0.119017,-0.167083,-0.135459:-0.102278,-0.072884,-0.079161,-0.127825,-0.208838,-0.255937,-0.265749,-0.281004,-0.358986,-0.2902,-0.250067,-0.302562,-0.340134,-0.292704,-0.298213,-0.324046,-0.383654:-0.150698,-0.209177,-0.328278,-0.326404,-0.306459,-0.37392,-0.354398,-0.304538,-0.259923,-0.262234,-0.217774,-0.169468,-0.16225,-0.184427,-0.202367,-0.167682,-0.124564:-0.045042,-0.026791,0.041034,0.040614,-0.061151,0.002202,0.026417,0.001474,0.0598,0.071029,0.020494,0.139489,0.217224,0.201919,0.192552,0.195957,0.205316:0.088014,0.090419,0.131728,0.165957,0.203205,0.158061,0.190298,0.25029,0.138772,0.130958,0.162642,0.012541,-0.078935,-0.09483,-0.094816,-0.130637,-0.196275:1
1.422172,1.499488,1.493844,1.501792,1.493543,1.49631,1.651963,1.688679,1.55675,1.613734,1.747215,1.839419,1.82105,1.757152,1.753599,1.541588,1.454483,1.424217,1.544482,1.524076,1.585026,1.54572,1.528965,1.488734,1.385034,1.576915,1.369768,1.291924,1.249188:0.151471,0.136153,0.151059,0.013546,-0.074407,-0.058366,-0.115097,-0.139786,-0.143745,-0.252662,-0.396344,-0.489197,-0.601919,-0.635962,-0.556013,-0.503199,-0.539285,-0.454892,-0.644589,-0.682402,-0.775596,-0.700667,-0.709956,-0.630423,-0.524682,-0.685441,-0.728,-0.821126,-0.71255:0.596082,0.607501,0.599481,0.607684,0.596393,0.503373,0.51023,0.427906,0.320272,0.264353,0.25918,0.27857,0.331047,0.34642,0.208722,0.169608,0.263371,0.236055,0.368806,0.362086,0.305845,0.273063,0.405092,0.338485,0.189633,0.313678,0.368243,0.460128,0.424194:-0.437178,-0.414268,-0.435213,-0.485441,-0.458022,-0.366392,-0.462003,-0.438038,-0.333953,-0.235197,-0.188462,-0.166276,-0.152144,-0.186251,-0.114878,-0.094662,-0.11897,-0.029452,0.016939,0.139947,0.284166,0.300405,0.196884,0.246102,0.33527,0.299567,0.385336,0.364637,0.363984:-0.129344,-0.186741,-0.209622,-0.158471,-0.137346,-0.12415,7.96E-4,0.018666,0.090555,0.16707,0.157482,0.14658,0.144223,0.189446,0.258535,0.362958,0.32499,0.180999,0.159249,0.141573,0.172454,0.260834,0.264607,0.223613,0.228664,0.242515,0.132781,0.169548,0.199327:-0.613048,-0.588344,-0.580975,-0.551184,-0.52204,-0.444358,-0.393514,-0.306422,-0.313863,-0.296811,-0.140522,-0.013372,0.052251,0.095796,0.106956,0.047232,0.106863,0.174979,0.076282,-0.023388,-0.098639,-0.20232,-0.143951,-0.080439,-0.136782,-0.179818,-0.074013,-0.089278,-0.164907:-0.019315,-0.018361,-0.021653,-0.047396,-0.0759,-0.127737,-0.189805,-0.214542,-0.236285,-0.250401,-0.265837,-0.254795,-0.273436,-0.285257,-0.298591,-0.289207,-0.315349,-0.321694,-0.30464,-0.252953,-0.229124,-0.209602,-0.279675,-0.370117,-0.34169,-0.32568,-0.350153,-0.351085,-0.3109:0.182442,0.146542,0.162263,0.184225,0.158902,0.137048,0.173542,0.158781,0.160335,0.080677,-0.007257,-0.083041,-0.143815,-0.175216,-0.218251,-0.183827,-0.181119,-0.197277,-0.181368,-0.20243,-0.212211,-0.277939,-0.270672,-0.214908,-0.224318,-0.267335,-0.235446,-0.220266,-0.2367:-0.195741,-0.168774,-0.115507,-0.138207,-0.10831,-0.05885,-0.13887,-0.135136,-0.135894,-0.14874,-0.102737,-0.089606,-0.081869,-0.092517,-0.068613,-0.119343,-0.115588,-0.142157,-0.167866,-0.191419,-0.222275,-0.198271,-0.200066,-0.174226,-0.177842,-0.161799,-0.163599,-0.19076,-0.23126:-0.029516,-0.060293,-0.102577,-0.076991,-0.090392,-0.232269,-0.26414,-0.306049,-0.316078,-0.287756,-0.342129,-0.414679,-0.408935,-0.368766,-0.338255,-0.306867,-0.336404,-0.353095,-0.301994,-0.222347,-0.168744,-0.123858,-0.145391,-0.237475,-0.213175,-0.168325,-0.219638,-0.217849,-0.177717:0.019961,0.026363,0.025254,-0.03743,-0.087862,-0.047289,-0.070056,-0.059075,-0.068192,-0.119977,-0.167164,-0.195927,-0.192904,-0.179215,-0.17701,-0.150699,-0.114374,-0.028514,-0.029146,-0.054509,-0.046916,-0.0858,-0.0578,0.01381,-0.005409,-0.061567,-0.014635,0.021894,0.048325:0.101176,0.113644,0.127344,0.118888,0.138978,0.157446,0.141656,0.110898,0.095423,0.113836,0.155689,0.255325,0.300369,0.279319,0.238587,0.182273,0.181145,0.156145,0.094563,0.028225,-0.022362,0.005472,0.022725,0.015536,-0.010767,-0.008448,-0.014682,-0.03787,-0.073199:1
1.434674,1.526055,1.488735,1.583783,1.400809,1.305122,1.415502,1.541037,1.534406,1.479637,1.372593,1.247187,1.270744,1.275714,1.194817,0.971841,1.018332:-0.076164,-0.114201,-0.217296,-0.232954,-0.213388,-0.146757,-0.231552,-0.392737,-0.527813,-0.521097,-0.544259,-0.570349,-0.606895,-0.662664,-0.644733,-0.597312,-0.605518:0.501317,0.486037,0.45928,0.475231,0.463449,0.384763,0.39539,0.519311,0.584211,0.625163,0.582953,0.521336,0.62233,0.69785,0.756816,0.743277,0.736603:-0.445557,-0.436262,-0.381398,-0.414967,-0.380626,-0.31596,-0.250305,-0.240197,-0.171878,-0.097252,5.8E-4,0.059979,0.140819,0.180912,0.177003,0.261866,0.252793:-0.196755,-0.155911,-0.084179,-0.016502,0.042543,0.077302,0.10936,0.157116,0.204799,0.163948,0.302688,0.457169,0.542111,0.486693,0.440973,0.452168,0.451198:-0.43776,-0.382819,-0.32335,-0.274545,-0.233329,-0.201513,-0.166219,-0.13924,-0.062479,-0.026745,-0.030911,-0.024804,-0.011489,0.040325,0.017718,0.044718,0.046084:0.084429,0.088281,0.030877,5.21E-4,-0.027286,-0.049643,-0.058585,-0.098398,-0.126635,-0.088173,-0.232192,-0.340564,-0.374397,-0.301945,-0.273847,-0.28689,-0.260791:0.277612,0.274656,0.290289,0.312453,0.338321,0.32598,0.255279,0.175056,0.094224,0.002192,-0.033382,-0.023571,-0.019385,-0.070273,-0.049389,-0.017722,-0.019076:-0.236675,-0.233286,-0.21936,-0.268651,-0.304849,-0.315737,-0.314097,-0.252966,-0.293406,-0.340114,-0.332305,-0.299615,-0.230698,-0.265625,-0.305747,-0.332654,-0.389233:-0.146709,-0.226012,-0.280648,-0.342981,-0.362635,-0.373952,-0.353636,-0.334749,-0.303334,-0.290686,-0.298857,-0.284912,-0.259715,-0.189216,-0.177675,-0.199664,-0.199808:0.040942,0.010427,-0.022396,-0.021563,-0.010654,-0.013419,-0.047847,-0.132596,-0.126414,-0.05952,0.065516,0.097339,0.062815,0.063806,0.08694,0.143094,0.194042:0.054929,0.101381,0.121299,0.11387,0.070505,0.053269,0.059066,0.100093,0.070024,0.079615,0.08291,0.050907,0.032935,-0.033491,-0.103785,-0.140823,-0.156308:1
1.565251,1.476022,1.389361,1.51817,1.500486,1.393941,1.283423,1.233503,1.394239,1.43342,1.650866,1.667053,1.6184,1.641653,1.40774,1.291911,1.222872,1.138087,1.183276,1.266827,1.296984,1.283262,1.270721:0.041818,0.014134,0.015225,-0.117353,-0.170499,-0.224181,-0.180371,-0.101751,-0.269341,-0.353826,-0.549444,-0.522931,-0.538103,-0.678485,-0.733839,-0.720321,-0.660868,-0.653923,-0.76871,-0.785473,-0.909159,-0.845536,-0.802692:0.686958,0.495687,0.426657,0.522708,0.528804,0.501645,0.398693,0.344913,0.409369,0.393166,0.526003,0.392483,0.462638,0.597245,0.584121,0.559112,0.55459,0.519587,0.624813,0.687856,0.779768,0.703597,0.651076:-0.557199,-0.492308,-0.365413,-0.420882,-0.452345,-0.366471,-0.227096,-0.271318,-0.280619,-0.253941,-0.329895,-0.126057,-0.067358,-0.027996,0.009003,0.059119,0.136743,0.288444,0.295512,0.258223,0.249093,0.356229,0.424542:-0.304664,-0.348115,-0.314519,-0.185771,-0.044726,-0.02613,-0.061299,0.037411,0.069211,0.121526,0.20226,0.206593,0.238743,0.258757,0.319003,0.314883,0.293635,0.211088,0.173752,0.161743,0.170531,0.196833,0.19591:-0.446723,-0.453957,-0.455878,-0.446085,-0.417028,-0.347102,-0.294717,-0.277024,-0.226342,-0.179036,-0.103046,-0.089804,-0.075426,0.015911,0.077679,0.093926,0.109943,0.070132,0.041093,0.086635,0.045238,0.011877,-0.036187:0.108951,0.178747,0.167896,0.019109,-0.142913,-0.087742,-0.062662,-0.050364,-0.028677,-0.053476,-0.212613,-0.216085,-0.260208,-0.274645,-0.277303,-0.288478,-0.323635,-0.301792,-0.272356,-0.306455,-0.325195,-0.301048,-0.257766:0.145401,0.134743,0.164595,0.208319,0.210408,0.104466,0.111935,0.168463,0.147196,0.098822,0.115263,0.099977,0.025663,-0.103213,-0.135238,-0.132188,-0.128554,-0.132416,-0.147752,-0.143399,-0.132334,-0.136343,-0.190651:-0.239657,-0.250135,-0.280009,-0.315249,-0.316019,-0.367455,-0.369874,-0.445531,-0.485328,-0.476129,-0.408174,-0.357249,-0.331406,-0.322404,-0.300211,-0.289804,-0.260102,-0.251518,-0.234849,-0.200068,-0.198293,-0.219837,-0.220398:0.049959,0.052755,-0.069689,-0.13863,-0.170948,-0.169425,-0.258063,-0.329444,-0.356074,-0.363448,-0.417548,-0.441173,-0.381045,-0.273256,-0.246405,-0.266903,-0.277112,-0.252273,-0.240623,-0.268244,-0.26407,-0.242036,-0.167435:-0.015421,-0.01608,0.025848,0.04989,0.069617,0.096432,0.132211,0.126563,0.093792,0.05494,0.024489,0.057439,0.104549,0.120348,0.086371,0.102927,0.112401,0.08268,0.044577,0.02579,0.03679,0.036929,-0.004513:-0.040004,-0.089233,-0.045817,0.016287,0.04384,0.079614,0.086022,0.081074,0.106921,0.128705,0.151895,0.156108,0.140901,0.09473,0.054284,0.017528,-0.034845,-0.067928,-0.086706,-0.091401,-0.11411,-0.122511,-0.155951:1
1.281205,1.483741,1.560664,1.483741,1.678927,1.61509,1.686658,1.653012,1.564425,1.435659,1.568572,1.448708,1.530596,1.526886,1.543432,1.449085,1.522763,1.481827,1.308073,1.216185:-0.376679,-0.478717,-0.411558,-0.521314,-0.57344,-0.219044,-0.311085,-0.281934,-0.521224,-0.525472,-0.363897,-0.367905,-0.649683,-0.753381,-0.55257,-0.497414,-0.614594,-0.65075,-0.652099,-0.547918:0.469486,0.586492,0.443417,0.233083,0.287046,0.199216,0.236376,0.130227,0.155951,0.172465,0.235155,0.445529,0.685855,0.621243,0.593724,0.648541,0.726917,0.742857,0.840391,0.872284:-0.549247,-0.585147,-0.330719,-0.136927,-0.238049,-0.317139,-0.293336,-0.160865,0.011383,0.095666,0.10727,0.008481,0.070036,0.245258,0.231812,0.180151,0.185139,0.201997,0.157879,0.14422:0.097194,0.003409,-0.078276,-0.139636,-0.081163,0.060077,0.123663,0.139172,0.216085,0.2087,0.146703,0.147957,0.199452,0.208845,0.299543,0.351167,0.314463,0.338111,0.332201,0.346811:-0.25517,-0.191509,-0.146011,-0.100666,-0.059355,-0.115192,-0.084012,-0.022605,-0.109312,-0.079752,0.001142,0.168112,0.06679,0.066246,0.00519,0.054097,0.13272,0.089048,0.133879,0.161598:-0.230035,-0.258692,-0.229023,-0.202756,-0.241884,-0.224946,-0.207018,-0.238133,-0.266337,-0.289628,-0.262599,-0.316357,-0.374636,-0.362179,-0.34872,-0.364103,-0.354006,-0.314515,-0.298925,-0.322975:0.24779,0.298047,0.243427,0.160043,0.16328,0.08174,-0.092571,-0.12893,-0.122736,-0.165072,-0.223589,-0.295658,-0.227339,-0.159446,-0.142338,-0.151392,-0.164213,-0.096298,-0.13018,-0.16401:-0.086393,-0.06134,-0.001668,-0.105713,-0.077186,-0.10395,-0.083355,-0.06979,-0.186496,-0.162179,-0.130822,-0.169087,-0.195041,-0.210556,-0.242362,-0.230353,-0.223631,-0.272202,-0.272617,-0.23629:-0.334335,-0.372563,-0.397912,-0.351744,-0.403787,-0.412919,-0.379234,-0.384574,-0.255777,-0.291114,-0.32877,-0.204705,-0.218632,-0.25489,-0.24527,-0.241537,-0.233484,-0.273296,-0.246499,-0.232485:-0.181931,-0.169937,-0.131857,-0.085928,-0.049169,-0.012227,-0.062413,-0.03682,0.007954,-0.008501,-0.029691,0.045708,0.123853,0.163883,0.158185,0.157642,0.145068,0.150552,0.135688,0.120199:0.133763,0.125673,0.127504,0.128758,0.159453,0.244241,0.367367,0.32991,0.212715,0.213645,0.232091,0.103071,0.071601,0.048558,0.019113,-0.025602,-0.068729,-0.055373,-0.077689,-0.107251:1
0.782225,0.728289,0.772465,0.987085,1.029552,1.012066,1.02116,0.937483,0.937338,0.845396,0.715118,0.64993,0.722642,0.824928:0.156349,0.044614,0.028717,-0.112233,-0.013803,-0.021166,-0.073157,-0.119662,-0.279052,-0.210409,-0.281487,-0.320075,-0.271583,-0.293186:0.126031,0.173925,0.222493,0.372049,0.31273,0.312083,0.281727,0.31982,0.361338,0.341529,0.403324,0.438087,0.456064,0.42555:-0.297001,-0.371333,-0.389297,-0.375791,-0.341266,-0.3976,-0.36127,-0.18767,-0.038193,0.012874,0.088865,0.169676,0.291553,0.38105:-0.254736,-0.226487,-0.106965,-0.02395,-0.013693,0.08378,0.246599,0.323706,0.384119,0.53737,0.627527,0.616824,0.555207,0.509824:-0.436808,-0.418688,-0.485427,-0.439617,-0.349137,-0.254674,-0.261959,-0.318908,-0.206187,-0.1548,-0.162874,-0.22282,-0.269254,-0.268582:0.116083,0.088249,0.074354,0.047053,-0.005204,-0.078382,-0.170642,-0.212644,-0.287148,-0.347767,-0.383102,-0.353333,-0.304377,-0.27966:0.116246,0.129505,0.184269,0.190476,0.157611,0.201416,0.175875,0.09604,0.05803,-0.017222,-0.061408,-0.101678,-0.153224,-0.206298:-0.01362,-0.075709,-0.091195,-0.165435,-0.164847,-0.199321,-0.191361,-0.177975,-0.16047,-0.192569,-0.201905,-0.138472,-0.03496,0.058708:-0.308773,-0.257612,-0.238403,-0.255345,-0.384397,-0.376998,-0.321867,-0.22326,-0.20889,-0.197685,-0.142482,-0.161768,-0.257026,-0.292748:0.171139,0.127724,0.032638,0.038963,0.149811,0.126316,0.067722,0.064146,0.052855,0.069121,0.038218,0.009083,0.045477,0.003902:0.10801,0.108312,0.198328,0.280815,0.252863,0.216497,0.213349,0.191908,0.132153,0.053223,0.00402,0.008598,0.017513,0.021691:1
0.733796,0.656458,0.608997,0.64579,0.702899,0.771904,0.911272,1.042758,1.08416,1.072942,0.98798,0.948423,0.986473,0.954482,0.941842,0.884917:0.3138,0.229648,0.216917,0.220033,0.16021,0.110438,0.032931,-0.06453,-0.16431,-0.19548,-0.293669,-0.339891,-0.353195,-0.342018,-0.299121,-0.350548:0.519066,0.494479,0.482839,0.416549,0.374029,0.336901,0.278038,0.446341,0.554122,0.524181,0.619754,0.537143,0.525047,0.570187,0.493804,0.518573:-0.428349,-0.445037,-0.467782,-0.431869,-0.458545,-0.482479,-0.487422,-0.42717,-0.279785,-0.210005,-0.120584,0.034703,0.046292,-0.010228,0.092324,0.183053:-0.111646,-0.082493,-0.054747,-0.013558,0.058324,0.123442,0.196167,0.214259,0.303371,0.381639,0.455315,0.525977,0.576955,0.636702,0.55925,0.491476:-0.543495,-0.509621,-0.49075,-0.44497,-0.410072,-0.344262,-0.305435,-0.227749,-0.141154,-0.199947,-0.199441,-0.15576,-0.119954,-0.091401,-0.074471,-0.045943:-0.009259,0.022758,0.058939,0.078242,0.071827,0.009709,-0.005384,-0.076586,-0.148808,-0.096073,-0.196548,-0.264984,-0.280143,-0.296947,-0.2429,-0.232468:0.283381,0.257784,0.270367,0.252093,0.248476,0.225037,0.239845,0.255618,0.117579,0.131493,0.148848,0.055061,0.002578,-0.06157,-0.165056,-0.190253:-0.096207,-0.165681,-0.214722,-0.212515,-0.212445,-0.195525,-0.241037,-0.333115,-0.395519,-0.449187,-0.432486,-0.350664,-0.347824,-0.367587,-0.323326,-0.303542:-0.067635,-0.067883,-0.024082,-0.104694,-0.202121,-0.259561,-0.28916,-0.28163,-0.259447,-0.321487,-0.272756,-0.219805,-0.204378,-0.18308,-0.217454,-0.237745:0.064,0.084588,0.091692,0.023135,0.007736,0.006332,-0.010988,0.011456,0.091531,0.065646,0.062567,0.029645,0.041311,0.083037,0.102466,0.11556:0.11024,0.07852,0.02508,0.089328,0.121079,0.104772,0.062388,0.015429,0.039691,0.129865,0.065351,0.024245,-0.014289,-0.038964,-0.010645,-0.014303:1
1.318772,1.306231,1.584388,1.597896,1.40605,1.298795,1.350008,1.237384,1.191268,1.1336,1.037323,1.006107,0.962016,0.980646,1.102571,1.114957,0.85789:-0.492045,-0.446116,-0.531861,-0.637359,-0.619899,-0.625023,-0.630733,-0.510523,-0.544804,-0.628062,-0.639322,-0.650952,-0.704762,-0.732755,-0.738523,-0.767476,-0.698744:0.494615,0.444882,0.434411,0.407268,0.359289,0.41603,0.472417,0.36097,0.31879,0.451288,0.479639,0.478811,0.518194,0.569897,0.582871,0.597599,0.573067:-0.420964,-0.424154,-0.394312,-0.42653,-0.394977,-0.324793,-0.254397,-0.187588,-0.038257,-0.173953,-0.163838,-0.115425,-0.071295,0.021438,0.169776,0.273712,0.260127:-0.085345,-0.052017,-0.073619,-0.019369,0.055196,0.042603,0.061382,0.233576,0.324971,0.273732,0.378829,0.432202,0.402589,0.418486,0.365729,0.379324,0.425611:-0.322296,-0.322153,-0.227699,-0.123217,-0.085734,-0.053124,-0.021562,-0.113671,-0.11459,0.048858,4.48E-4,-0.032035,-0.032208,-0.046423,0.029876,-0.047057,-0.093319:-0.133281,-0.109557,-0.083576,-0.139699,-0.213177,-0.15906,-0.204925,-0.270326,-0.267356,-0.292511,-0.34301,-0.361069,-0.350869,-0.409694,-0.400692,-0.332744,-0.397332:0.278574,0.27875,0.195876,0.198263,0.178208,0.118814,0.115827,0.009368,-0.126101,-0.126727,-0.054292,-0.081733,-0.086237,-0.061938,-0.12896,-0.172832,-0.140139:-0.057916,-0.034538,-0.00682,-0.04361,-0.017697,-0.091955,-0.105298,-0.150611,-0.185195,-0.242645,-0.282967,-0.251289,-0.202952,-0.170444,-0.212985,-0.259072,-0.204125:-0.202664,-0.225544,-0.26806,-0.288721,-0.330694,-0.367553,-0.454447,-0.369138,-0.228677,-0.301488,-0.32811,-0.286325,-0.329958,-0.363001,-0.324526,-0.209871,-0.233966:-0.10533,-0.143109,-0.169576,-0.126683,-0.072841,-0.059054,-0.0762,0.012995,-0.020787,0.054174,0.09548,0.070498,0.044652,0.03818,0.085332,0.054837,0.015279:0.170675,0.206543,0.268095,0.174805,0.157773,0.18922,0.214493,0.197501,0.133158,0.132368,0.104426,0.068907,0.098854,0.084554,0.02955,-0.036341,-0.052425:1
1.360509,1.291126,1.378514,1.348834,1.262361,1.259591,1.202321,1.257783,1.480535,1.513321,1.529261,1.537035,1.490019,1.754244,1.597145,1.280147,1.198193,1.038767:0.072095,0.068776,0.015724,-0.091816,-0.296065,-0.318508,-0.283573,-0.404659,-0.459641,-0.400342,-0.369852,-0.478982,-0.489891,-0.792709,-0.786701,-0.516637,-0.549254,-0.531076:0.809619,0.896932,0.875981,0.801448,0.798051,0.73269,0.616884,0.613498,0.565469,0.441303,0.370379,0.385859,0.268718,0.40963,0.458342,0.418396,0.559925,0.580894:-0.32074,-0.294521,-0.334586,-0.317407,-0.381559,-0.402071,-0.387359,-0.447173,-0.450111,-0.329886,-0.303295,-0.286145,-0.144519,-0.131743,-0.123142,-0.129277,-0.136951,-0.02717:0.251872,0.233098,0.263393,0.20721,0.164152,0.183608,0.11147,0.047093,0.130934,0.193528,0.261045,0.319882,0.310471,0.310014,0.288378,0.320517,0.34655,0.369281:-0.399844,-0.428556,-0.388604,-0.255564,-0.17537,-0.118322,-0.043097,0.009162,-0.015084,-0.023284,-0.042112,-0.003482,0.075064,0.127156,0.190994,0.156778,0.031977,-0.091734:-0.388361,-0.411853,-0.405186,-0.323608,-0.32924,-0.304756,-0.290444,-0.354686,-0.366796,-0.35305,-0.33048,-0.318938,-0.304262,-0.336097,-0.390162,-0.400547,-0.459136,-0.505662:0.262445,0.254375,0.266404,0.112503,0.130741,0.139784,0.189323,0.24171,0.224959,0.147058,0.154938,0.10406,0.001354,-0.104216,-0.119662,-0.097812,-0.066797,-0.060091:-0.161754,-0.150382,-0.178577,-0.149851,-0.130199,-0.170644,-0.114724,-0.035688,-0.071986,-0.169978,-0.242366,-0.257085,-0.248334,-0.177086,-0.123473,-0.137921,-0.119714,-0.072243:-0.199694,-0.234686,-0.260021,-0.220415,-0.24107,-0.259897,-0.378463,-0.427174,-0.403235,-0.343379,-0.363276,-0.331184,-0.292737,-0.276426,-0.347847,-0.374169,-0.368886,-0.368388:0.033438,0.020957,0.026702,-0.029487,-0.081145,-0.064108,-0.077682,-0.121588,-0.112563,-0.016814,0.018692,-0.021509,-0.034277,-0.094175,-0.091365,-0.066322,-0.042798,-0.040956:0.01532,0.063724,0.0591,0.091872,0.108023,0.080082,0.058401,-0.002249,-0.023569,-0.023527,0.001909,0.009661,0.015039,0.051088,0.082844,0.074724,0.054251,0.040749:1
0.856142,1.04741,1.225615,1.263908,1.235635,1.447759,1.427649,1.439454,1.244844,1.19224,1.081263,1.090852,0.965461:0.308497,0.336246,0.047536,-0.08385,-0.053692,-0.170219,-0.338176,-0.424536,-0.325525,-0.347839,-0.400506,-0.631899,-0.54687:0.198341,0.248383,0.391823,0.45435,0.388033,0.313654,0.347535,0.411812,0.368714,0.387669,0.516263,0.733682,0.793074:-0.420037,-0.382609,-0.416373,-0.471002,-0.410285,-0.426782,-0.311427,-0.246816,-0.111391,0.016863,0.076383,0.006398,-0.065665:-0.071435,-0.095124,-0.094276,0.00913,0.211241,0.429226,0.397086,0.356316,0.346173,0.405729,0.49079,0.534456,0.547639:-0.550555,-0.468017,-0.332086,-0.243589,-0.230998,-0.17509,-0.020506,0.029065,0.086975,-0.019369,-0.146077,-0.100038,-0.028969:-0.031398,-0.059318,-0.118424,-0.191004,-0.248868,-0.362516,-0.408365,-0.415882,-0.385433,-0.37015,-0.438907,-0.556482,-0.556828:0.325652,0.314964,0.243748,0.189324,0.131612,0.117689,-0.011141,-0.078475,-0.145894,-0.099066,-0.052452,-0.007768,-0.031138:-0.028001,0.02762,0.091958,0.079851,-0.023973,-0.164488,-0.140495,-0.198666,-0.242496,-0.221782,-0.133099,-0.125338,-0.17275:-0.270186,-0.288403,-0.319556,-0.349622,-0.312011,-0.289149,-0.302277,-0.3005,-0.283038,-0.303271,-0.27205,-0.241401,-0.178572:-0.05621,-0.081207,-0.180759,-0.217839,-0.185855,-0.150228,-0.122009,-0.015867,0.084416,0.076193,0.009551,-0.002691,0.037178:-0.004226,0.018217,0.118244,0.154666,0.106239,0.01215,0.043477,0.064545,0.082779,0.107406,0.045942,-0.028342,-0.135015:1
1.319136,1.471378,1.587682,1.601294,1.572381,1.546417,1.538674,1.504163,1.404836,1.231321,1.078887,1.194569,1.16453,1.231724,1.171887,1.280911,1.241929,1.265061,1.022368:-0.263841,-0.327257,-0.481388,-0.553931,-0.62394,-0.619441,-0.599502,-0.641297,-0.881744,-0.964072,-0.866163,-0.984321,-0.891079,-0.885307,-0.909964,-0.932225,-0.922407,-1.074515,-0.877198:0.257415,0.245489,0.32225,0.308314,0.336461,0.39574,0.472856,0.43951,0.658876,0.715917,0.736942,0.820284,0.656098,0.626427,0.642336,0.695986,0.757066,0.908089,0.699087:-0.27158,-0.298627,-0.361626,-0.311712,-0.328932,-0.327957,-0.220182,-0.024301,0.029998,0.085806,0.202825,0.169449,0.187285,0.203215,0.23049,0.284295,0.324821,0.34028,0.525043:-0.134386,-0.093787,-0.039358,0.004868,0.070172,0.164851,0.172065,0.121429,0.165262,0.277358,0.276886,0.312583,0.405744,0.441582,0.456234,0.447448,0.380679,0.324145,0.245565:-0.421578,-0.295236,-0.279507,-0.2379,-0.134723,0.017785,0.110648,0.168302,0.236732,0.213157,0.26752,0.229432,0.146533,0.142586,0.135642,0.1426,0.145838,0.15408,0.146197:-0.022822,-0.030282,0.015308,-0.001664,-0.003448,-0.045093,-0.110294,-0.22972,-0.405327,-0.46491,-0.464403,-0.484847,-0.513092,-0.529258,-0.542688,-0.507125,-0.44507,-0.443926,-0.458618:0.232325,0.213114,0.196615,0.179583,0.048695,-0.122221,-0.200767,-0.22852,-0.261652,-0.251291,-0.278585,-0.229575,-0.19794,-0.206287,-0.174781,-0.157742,-0.133795,-0.148635,-0.162676:0.037027,0.033934,-0.028742,-0.083984,-0.176489,-0.236859,-0.203248,-0.118824,-0.036439,-0.033184,-0.019719,-0.053415,-0.069798,-0.054861,-0.07789,-0.122015,-0.175827,-0.129216,-0.086359:-0.069692,-0.198578,-0.200421,-0.189362,-0.111709,-0.086601,-0.220904,-0.311815,-0.230544,-0.205472,-0.208431,-0.258252,-0.272297,-0.27773,-0.300069,-0.279725,-0.294514,-0.292238,-0.290039:-0.200048,-0.168678,-0.255888,-0.275253,-0.296203,-0.285092,-0.229857,-0.127682,-0.068331,-0.040164,-0.055675,-0.015877,-0.015682,-0.044835,-0.016125,0.026842,0.086841,0.04403,0.001808:0.125256,0.177098,0.189391,0.106716,0.037165,0.055319,0.188394,0.213003,0.078449,0.022501,6.37E-4,-0.013503,-0.021551,-0.011528,-0.017205,-0.051512,-0.04962,-0.038266,0.008386:1
1.468739,1.838311,1.871822,1.694926,1.69434,1.662596,1.686471,1.565628,1.577347,1.543534,1.434415,1.325398,1.48728,1.491716,1.343653,1.261134,1.387506:-0.720948,-0.711605,-0.642933,-0.49704,-0.757375,-1.012125,-0.811039,-0.5166,-0.540059,-0.588013,-0.526407,-0.597707,-0.787765,-0.828782,-0.79558,-0.811981,-0.829786:0.576898,0.63696,0.536285,0.430179,0.578454,0.616406,0.555215,0.293509,0.367852,0.364039,0.336232,0.34472,0.430186,0.516537,0.499099,0.431172,0.510295:-0.214658,-0.201476,-0.113826,-0.096841,-0.298712,-0.374439,-0.205861,-0.039328,-0.093034,-0.042124,0.056359,0.122411,0.049083,0.005267,0.114245,0.241796,0.238469:-0.531025,-0.447516,-0.386391,-0.337184,-0.261557,-0.196026,-0.110588,-0.071116,-0.042081,0.009408,0.042395,0.184292,0.328063,0.363333,0.337493,0.358327,0.376507:-0.031477,-0.068257,-0.048006,-0.032963,0.009521,0.0479,0.075922,0.125877,0.146677,0.148713,0.146364,0.19528,0.230045,0.284656,0.220848,0.231476,0.247943:-0.012811,-0.127285,-0.166358,-0.161065,-0.220756,-0.359982,-0.364625,-0.329557,-0.315188,-0.329056,-0.33372,-0.401584,-0.430279,-0.468866,-0.442922,-0.49483,-0.532263:0.118581,0.068982,0.026851,0.012689,0.045232,0.00501,-0.089355,-0.156904,-0.19585,-0.234776,-0.249134,-0.278927,-0.312177,-0.290884,-0.275754,-0.274156,-0.23337:0.173086,0.218484,0.234321,0.209272,0.131622,0.133028,0.1138,0.023562,0.017157,-0.003796,-0.058699,-0.052479,-0.056066,-0.063758,-0.053718,-0.011201,0.010482:-0.173132,-0.16643,-0.182749,-0.223919,-0.284729,-0.315092,-0.316214,-0.307376,-0.350606,-0.342396,-0.329843,-0.259967,-0.19049,-0.230996,-0.230026,-0.238127,-0.297864:-0.22238,-0.244348,-0.286299,-0.346177,-0.290291,-0.266574,-0.290001,-0.26486,-0.253764,-0.227204,-0.138363,-0.110452,-0.106433,-0.055405,-0.09443,-0.111739,-0.074684:0.075368,0.121264,0.132699,0.122297,0.061446,0.055506,0.085385,0.096708,0.153632,0.181393,0.198171,0.161157,0.092998,0.09592,0.092694,0.073874,0.069495:1
1.413662,1.458401,1.306065,1.241711,1.162975,1.234981,1.554258,1.601111,1.560923,1.450161,1.447307,1.44374,1.515381,1.439091,1.532901,1.493309:-0.47731,-0.402869,-0.322308,-0.24811,-0.235986,-0.238298,-0.430154,-0.486692,-0.442483,-0.517474,-0.643112,-0.717693,-0.905736,-0.890831,-1.042354,-1.165916:0.759672,0.732723,0.693145,0.577114,0.392406,0.333325,0.329266,0.261646,0.24177,0.318081,0.387824,0.499804,0.449848,0.319216,0.370889,0.560322:-0.303058,-0.365525,-0.37451,-0.405381,-0.360919,-0.315667,-0.216658,-0.180623,-0.192847,-0.1433,-0.114091,-0.125664,0.014842,0.157626,0.206777,0.159092:-0.637269,-0.485988,-0.44871,-0.348131,-0.271118,-0.241711,-0.307802,-0.263865,-0.063311,0.077521,0.137498,0.110139,0.187394,0.281923,0.41147,0.397236:-0.1386,-0.246825,-0.225458,-0.216412,-0.256223,-0.237246,-0.152247,-0.041063,0.081203,0.225913,0.285743,0.335503,0.279289,0.180224,0.037492,0.11104:0.048928,0.075483,0.105204,0.104084,0.076098,0.069969,0.061486,-0.006335,-0.135041,-0.245159,-0.302327,-0.263308,-0.2955,-0.313514,-0.369659,-0.483271:0.155573,0.125406,0.118194,0.090499,0.020137,-0.007909,-0.045631,-0.09653,-0.214041,-0.272774,-0.260767,-0.271785,-0.286387,-0.250362,-0.151857,-0.16233:0.091147,-0.010715,-0.018794,0.015122,0.068017,0.083028,-0.008072,-0.064998,-0.067265,-0.102382,-0.094921,-0.133679,-0.127985,-0.192235,-0.251258,-0.145688:-0.165079,-0.152123,-0.170239,-0.256374,-0.356396,-0.42574,-0.396433,-0.416826,-0.388537,-0.315085,-0.325721,-0.315136,-0.234965,-0.2012,-0.21683,-0.27867:-0.051125,-0.073411,-0.080069,-0.129756,-0.168443,-0.2162,-0.28279,-0.246285,-0.220187,-0.160391,-0.143647,-0.100805,-0.080612,-0.014276,0.041018,0.011686:0.033716,0.089511,0.072546,0.131035,0.243819,0.262637,0.231968,0.230318,0.253969,0.227115,0.228323,0.189598,0.064566,-0.013198,-0.051861,-0.020872:1
1.186043,1.24499,1.147099,1.036991,1.190096,1.254704,1.224938,1.290992,1.368004,1.363349,1.275895,1.363326,1.481268,1.248242,1.259984,1.40735,1.403385,1.280409:-0.172526,-0.102121,-0.074593,0.008503,-0.113453,-0.372825,-0.497523,-0.396101,-0.449654,-0.55142,-0.621881,-0.724245,-0.795681,-0.796845,-0.829193,-0.777336,-0.801059,-0.7683:0.817455,0.838958,0.836326,0.795077,0.754763,0.781944,0.796277,0.684179,0.542787,0.476139,0.430707,0.449584,0.569069,0.723702,0.73203,0.589207,0.659047,0.516842:-0.472485,-0.563446,-0.578337,-0.689165,-0.668237,-0.61906,-0.586684,-0.558288,-0.572027,-0.541531,-0.517482,-0.488545,-0.439455,-0.340705,-0.240183,-0.065227,-0.035096,0.16171:-0.079361,-0.05456,-0.106845,-0.033405,-0.047704,-0.087573,-0.014432,0.106448,0.272698,0.287613,0.308983,0.35228,0.381887,0.377425,0.422093,0.379922,0.442497,0.534153:-0.37668,-0.371272,-0.327827,-0.317936,-0.209375,-0.142079,-0.175979,-0.105931,-0.09165,-0.03218,0.075173,0.065981,0.057323,0.063303,0.065756,-0.045849,-0.133564,-0.159369:-0.208734,-0.189012,-0.133247,-0.149038,-0.253829,-0.350547,-0.452302,-0.408153,-0.386484,-0.361767,-0.386273,-0.421057,-0.484039,-0.474766,-0.504924,-0.365613,-0.437229,-0.410562:0.396747,0.442677,0.384164,0.332263,0.304358,0.290232,0.284026,0.254178,0.242942,0.212419,0.119149,0.099887,0.084482,0.046401,0.014454,-0.027066,-0.019641,-0.010775:-0.224903,-0.262359,-0.234269,-0.21313,-0.122832,-0.059178,-0.08223,-0.123124,-0.241799,-0.279557,-0.257719,-0.29357,-0.292945,-0.28444,-0.268091,-0.310493,-0.32301,-0.38023:-0.253333,-0.2578,-0.229752,-0.222235,-0.277462,-0.36424,-0.38325,-0.394777,-0.428961,-0.453021,-0.408259,-0.391678,-0.402932,-0.368781,-0.338351,-0.284655,-0.20334,-0.175202:0.098387,0.057034,-0.009833,-0.071214,-0.088438,-0.09122,-0.045221,-0.065655,-0.050302,-0.04836,-0.030964,0.039405,0.079637,0.083572,0.090614,0.030788,0.032216,0.096314:-0.05589,-0.127025,-0.143463,-0.104472,-0.083736,-0.023872,0.001322,-0.016846,0.02341,0.030963,0.003378,0.020556,0.079272,0.064423,0.008675,0.015442,-0.066877,-0.129963:1
1.343719,1.477326,1.484747,1.401365,1.42412,1.480695,1.643098,1.488843,1.579327,1.611059,1.504497,1.395483,1.226496,1.295962,1.214085,1.263946,1.304049,1.144995:-0.27459,-0.332008,-0.293989,-0.379031,-0.48668,-0.536443,-0.682561,-0.673018,-0.751912,-0.817229,-0.84759,-0.76116,-0.70198,-0.904501,-0.880259,-0.882753,-0.836772,-0.810089:0.498772,0.55551,0.478377,0.432996,0.354002,0.356969,0.452609,0.393696,0.398677,0.426707,0.518167,0.512605,0.468644,0.733417,0.789198,0.779485,0.760122,0.762634:-0.377738,-0.380893,-0.374658,-0.350367,-0.313138,-0.332649,-0.267082,-0.0994,-0.032316,0.040304,0.018438,-0.009801,0.108432,0.024133,0.060479,0.092706,0.10945,0.108827:-0.040293,-0.071421,-0.025307,-0.020553,0.024403,0.03072,0.027551,0.09975,0.160295,0.181371,0.136741,0.105857,0.092956,0.098223,0.092166,0.15689,0.196945,0.279154:-0.286514,-0.290979,-0.310476,-0.279934,-0.273206,-0.282323,-0.237235,-0.133793,-0.126659,-0.138424,-0.021889,0.050881,0.046958,0.032393,-0.005221,-0.023195,-0.047981,-0.041934:0.174393,0.160206,0.146588,0.089712,0.025889,0.011842,-0.045609,-0.102514,-0.104571,-0.123358,-0.212174,-0.201126,-0.16806,-0.210975,-0.199408,-0.248598,-0.24225,-0.264794:0.304019,0.330134,0.331849,0.307476,0.274451,0.188007,0.10894,-0.00637,-0.100371,-0.150019,-0.173797,-0.220376,-0.229138,-0.185079,-0.232158,-0.284512,-0.328072,-0.309962:-0.288013,-0.351737,-0.418442,-0.422538,-0.384343,-0.352077,-0.395225,-0.384401,-0.39626,-0.382172,-0.289681,-0.232698,-0.214839,-0.241676,-0.248522,-0.24436,-0.257399,-0.239382:-0.224133,-0.22889,-0.25496,-0.301505,-0.343032,-0.348009,-0.307279,-0.306269,-0.235332,-0.184026,-0.238839,-0.269645,-0.306271,-0.274942,-0.209945,-0.153136,-0.101217,-0.129102:-0.134055,-0.07156,-0.05563,-0.03681,-0.054157,-0.092036,-0.029742,0.0502,0.032367,0.029266,0.046434,2.32E-4,-0.013688,-0.022922,-0.025716,-0.01359,-0.033775,-0.039992:-0.008237,-0.021318,-0.026678,-0.024021,0.036083,0.139468,0.149558,0.175925,0.197507,0.183786,0.179999,0.178728,0.17438,0.114413,0.061212,0.027821,0.008703,0.030197:1
1.179022,1.27748,1.320935,1.182336,1.149182,1.208574,1.188991,1.26027,1.414046,1.34677,1.199,1.241012,1.262274,1.040313,1.005873,1.064344,1.031473,1.211622,1.24823:-0.187891,-0.188244,-0.254262,-0.337006,-0.407328,-0.430654,-0.432489,-0.524813,-0.694008,-0.736668,-0.724858,-0.811797,-0.773512,-0.722807,-0.766853,-0.724118,-0.706103,-0.842079,-0.782104:0.405189,0.30019,0.251739,0.33529,0.333993,0.313356,0.287169,0.381819,0.524056,0.558226,0.504256,0.549696,0.569528,0.619818,0.701966,0.690315,0.625887,0.729342,0.727942:-0.252152,-0.16401,-0.091713,-0.212143,-0.286698,-0.282209,-0.215513,-0.237132,-0.240757,-0.204798,-0.048639,-0.066229,-0.011084,-0.008035,-0.036273,-0.024941,0.087235,0.097746,0.051681:-0.041295,-0.16297,-0.178611,-0.074231,-0.071788,-0.073666,-0.032639,0.047849,0.137556,0.220175,0.221292,0.335268,0.464447,0.5062,0.534641,0.568582,0.553565,0.507289,0.532622:-0.429274,-0.381619,-0.317924,-0.296209,-0.279159,-0.190427,-0.073311,-0.023836,0.01117,-0.017467,-0.026194,-0.02289,-0.116185,-0.087624,-0.00792,-0.053447,-0.088849,-0.06708,-0.100753:0.081279,0.118698,0.114873,0.076294,0.037215,0.020075,-0.092017,-0.179761,-0.278632,-0.344889,-0.29317,-0.344647,-0.347592,-0.38809,-0.465796,-0.409842,-0.343944,-0.330072,-0.337791:0.107952,0.028879,-0.03081,-0.036972,-0.024282,-0.019408,-0.020087,-0.026274,-0.046988,-0.055899,-0.112457,-0.091678,-0.084573,-0.045015,-0.056102,-0.075513,-0.051795,-0.094019,-0.123165:-0.140674,-0.037631,-0.007479,-0.086249,-0.09375,-0.135777,-0.215502,-0.265116,-0.268821,-0.239443,-0.213502,-0.230122,-0.307576,-0.304014,-0.258068,-0.309899,-0.374963,-0.356963,-0.343484:-0.124007,-0.190059,-0.295896,-0.296853,-0.346539,-0.420436,-0.425233,-0.412387,-0.39505,-0.360308,-0.293439,-0.24228,-0.148904,-0.187905,-0.222276,-0.181283,-0.183224,-0.157209,-0.135272:-0.090637,-0.129471,-0.120982,-0.056632,-0.064178,-0.065099,0.038973,0.080417,0.076507,0.051938,0.001486,0.010818,0.026605,0.06607,0.080304,0.066652,0.105642,0.041005,-0.014299:0.190455,0.174722,0.233498,0.33698,0.367302,0.332377,0.253902,0.238584,0.24908,0.237021,0.200236,0.129176,0.079841,0.04988,0.037214,0.047209,-0.001572,0.017773,0.043105:1
1.857175,1.821688,1.815971,1.922503,1.74872,1.567299,1.605604,1.757725,1.569864,1.527556,1.52368,1.579503,1.534153,1.44603,1.537053,1.495145,1.333623,1.162717,1.34161,1.131266,1.359027,1.294486:0.037577,-0.107967,-0.124513,-0.131358,-0.023634,0.072551,-0.039165,-0.293167,-0.508023,-0.605922,-0.643918,-0.708699,-0.888564,-0.985707,-1.021175,-1.015268,-0.902786,-0.768094,-0.989078,-0.850396,-1.042243,-1.051258:0.450556,0.452461,0.307278,0.121297,0.008908,0.025831,0.062297,0.068107,0.322103,0.482894,0.442982,0.444259,0.655308,0.70811,0.567625,0.54709,0.584471,0.615934,0.789578,0.686603,0.788586,0.778014:-0.257939,-0.237058,-0.182076,-0.064366,-0.241831,-0.347554,-0.273415,-0.113874,-0.103996,-0.157751,-0.0825,0.018899,0.051023,0.068797,0.090479,0.07358,0.182821,0.18454,0.088219,0.179857,0.079155,0.128963:-0.124359,-0.242226,-0.246316,-0.115012,-0.061589,-0.00584,0.01817,-0.111543,-0.189688,-0.112235,0.017197,-0.022685,-0.076622,-0.020737,0.049637,0.10025,0.045307,-0.005539,0.064852,0.086483,0.165093,0.191628:-0.441793,-0.395222,-0.353763,-0.442741,-0.287173,-0.221684,-0.159173,-0.041571,0.083466,0.067275,-0.026929,-0.025369,0.022449,0.049759,0.069154,0.112521,0.082179,0.068263,0.070046,0.071415,0.102162,0.113706:-0.400214,-0.374091,-0.379602,-0.275862,-0.238979,-0.268486,-0.275587,-0.274152,-0.2619,-0.262967,-0.348099,-0.317285,-0.285852,-0.311885,-0.325253,-0.356462,-0.371148,-0.355089,-0.342179,-0.350543,-0.3677,-0.360218:0.16829,0.218877,0.215759,0.141285,0.162419,0.209561,0.208781,0.096114,0.022613,0.03376,0.048699,0.029971,-0.025407,-0.02788,-0.042998,-0.084265,-0.071736,-0.042563,-0.067035,-0.052412,-0.076297,-0.09726:-0.012736,0.070579,0.080989,0.005277,0.002002,-0.028085,-0.078718,-0.020608,-0.038453,-0.075027,-0.083728,-0.09094,-0.094625,-0.12031,-0.139264,-0.122729,-0.085781,-0.116129,-0.16456,-0.186676,-0.216628,-0.229632:-0.103467,-0.185543,-0.232605,-0.20748,-0.35808,-0.385312,-0.374794,-0.390189,-0.375805,-0.399763,-0.405969,-0.395845,-0.392952,-0.422494,-0.434381,-0.418966,-0.399465,-0.393219,-0.391446,-0.395619,-0.397941,-0.385922:-0.013094,-0.047894,-0.090966,-0.163136,-0.212957,-0.173553,-0.174135,-0.228064,-0.191427,-0.132173,-0.076815,-0.076108,-0.069133,-0.025621,-0.012477,-0.032207,-0.0649,-0.04388,0.020533,0.04137,0.077244,0.087421:-0.037197,-0.009041,0.001524,0.016091,0.01035,-0.052013,-0.033492,0.052881,0.065007,0.053789,0.076752,0.090192,0.114314,0.140393,0.150419,0.145242,0.116193,0.085538,0.070245,0.058955,0.064491,0.06753:1
1.028095,1.167541,1.512927,1.670877,1.872787,1.542646,1.653064,1.630326,1.506177,1.665148,1.742994,1.668651,1.593208,1.698739,1.551883,1.402619,1.398282:-0.01126,-0.225956,-0.305422,-0.124607,-0.147103,-0.065177,-0.147401,-0.042771,-0.028096,-0.346198,-0.390771,-0.464887,-0.537919,-0.669112,-0.645818,-0.596803,-0.584394:0.565499,0.353536,0.434537,0.563517,0.431287,0.421546,0.455516,0.31028,0.26005,0.398822,0.428615,0.434093,0.481547,0.573436,0.505366,0.508378,0.535142:-0.555177,-0.582134,-0.578103,-0.602132,-0.506835,-0.421348,-0.549107,-0.469301,-0.377908,-0.34498,-0.238958,-0.130837,-0.035749,-0.064486,0.006721,0.027865,0.037574:0.160742,0.260398,0.123878,0.086286,0.061009,0.013243,0.118278,0.159095,0.128188,0.123063,0.069036,0.128839,0.202876,0.262148,0.28234,0.31885,0.365286:-0.502633,-0.424802,-0.356449,-0.349694,-0.300208,-0.24189,-0.149488,-0.120853,-0.089197,-0.052683,-0.116029,-0.116643,-0.084086,-0.067987,-0.026226,0.002593,-0.009179:-0.246988,-0.190912,-0.286346,-0.35017,-0.313903,-0.261399,-0.242039,-0.217813,-0.195862,-0.179894,-0.08903,-0.165769,-0.250517,-0.260094,-0.289147,-0.297799,-0.23837:0.438153,0.471899,0.445305,0.384559,0.286305,0.211546,0.223052,0.249898,0.253581,0.231593,0.18118,0.149591,0.102015,0.058521,0.021019,-0.018523,-0.06424:0.038414,0.049489,0.032688,0.001449,-0.009104,0.008031,-0.085476,-0.092181,-0.136336,-0.194647,-0.235081,-0.271484,-0.296322,-0.352805,-0.323223,-0.315718,-0.342176:-0.035945,-0.047505,-0.158888,-0.237356,-0.251882,-0.249581,-0.292353,-0.321381,-0.408609,-0.436268,-0.387309,-0.411425,-0.419606,-0.373155,-0.364772,-0.343416,-0.30049:-0.037627,-0.080686,-0.11975,-0.080243,-0.095278,-0.081354,-0.11032,-0.140011,-0.107693,-0.123319,-0.155802,-0.077198,0.018099,0.051475,0.104808,0.140657,0.127702:3.14E-4,-0.037614,-0.094798,-0.021109,0.001124,0.013563,-0.010133,-0.079776,-0.042802,-0.017848,0.005166,0.037566,0.067803,0.072989,0.063911,0.060486,0.088519:1
1.027887,1.116756,1.150432,1.010091,0.992636,1.047732,1.059199,1.065812,1.061119,0.96727,0.945505,0.971092,0.863153,0.880214,0.788902,0.882078,0.861664,0.578996,0.643121:0.10798,0.068768,-0.045783,-0.013191,-0.003691,-0.12045,-0.170897,-0.276191,-0.285413,-0.301874,-0.360944,-0.416604,-0.44672,-0.412817,-0.448583,-0.469512,-0.452738,-0.395023,-0.396123:0.553628,0.554899,0.527064,0.532835,0.470179,0.536595,0.572155,0.551197,0.453893,0.354571,0.331918,0.306195,0.346222,0.459225,0.44797,0.525566,0.556526,0.518669,0.561025:-0.615951,-0.598373,-0.553701,-0.491216,-0.459628,-0.503321,-0.532844,-0.451114,-0.367636,-0.351721,-0.302521,-0.212046,-0.182611,-0.260679,-0.122933,-0.097309,-0.075502,-0.017894,0.015011:0.013634,0.008984,-0.030972,-0.022686,0.005603,0.102444,0.222539,0.207503,0.18433,0.22798,0.208533,0.174819,0.165489,0.299378,0.340796,0.335436,0.259689,0.284219,0.29068:-0.605362,-0.550347,-0.514688,-0.551883,-0.532828,-0.494826,-0.494136,-0.374093,-0.260871,-0.19847,-0.158116,-0.088769,-0.088881,-0.134454,-0.12126,-0.072778,0.016832,-0.080374,-0.063597:-0.193321,-0.200604,-0.189648,-0.125067,-0.057103,-0.169133,-0.232696,-0.184823,-0.086037,-0.051143,-0.005343,-0.02291,-0.056906,-0.13051,-0.161795,-0.165177,-0.237909,-0.191341,-0.173455:0.344977,0.382678,0.366324,0.303068,0.254285,0.284693,0.319029,0.248083,0.042857,2.07E-4,-0.055585,-0.136161,-0.117438,-0.039259,-0.144899,-0.16869,-0.141346,-0.193579,-0.224895:-0.149009,-0.144609,-0.13138,-0.176634,-0.211955,-0.258045,-0.298759,-0.284894,-0.217813,-0.18792,-0.150714,-0.129152,-0.23817,-0.334127,-0.293552,-0.326803,-0.326641,-0.28131,-0.270112:-0.087472,-0.128469,-0.13451,-0.113293,-0.100754,-0.097345,-0.111099,-0.128366,-0.116928,-0.201624,-0.321823,-0.346467,-0.29863,-0.291549,-0.238391,-0.2248,-0.227245,-0.180103,-0.186491:0.059131,0.081545,0.050712,0.052202,0.043773,0.089078,0.10454,0.092947,-0.017844,-0.06979,-0.086457,-0.11163,8.96E-4,0.093107,0.053534,0.070798,0.157854,0.159172,0.135691:0.088067,0.061082,0.061515,0.115432,0.133555,0.094622,0.106631,0.127073,0.207804,0.303592,0.3867,0.351362,0.227644,0.163074,0.178343,0.162805,0.024024,-0.021908,0.00959:1
1.46357,1.680828,1.487493,1.724061,1.548609,1.476997,1.454293,1.441154,1.268166,1.252486,1.233207,1.235257,1.153223,0.965407,0.836499:-0.091366,-0.17775,-0.2459,-0.51798,-0.395852,-0.340477,-0.367577,-0.507687,-0.378553,-0.455359,-0.54963,-0.594054,-0.646749,-0.587426,-0.408787:0.606119,0.61178,0.61902,0.720827,0.430163,0.427313,0.446946,0.562203,0.506159,0.665079,0.735617,0.799466,0.852024,0.791897,0.621503:-0.50253,-0.526829,-0.458685,-0.491753,-0.370181,-0.499404,-0.43876,-0.322844,-0.219547,-0.161266,-0.079614,-0.093598,-0.07554,0.049977,0.137621:-0.031237,0.084044,0.024362,0.018313,0.131139,0.298888,0.272587,0.168882,0.228489,0.285273,0.302559,0.361688,0.384296,0.36028,0.397523:-0.373244,-0.288873,-0.126851,-0.004737,-0.014093,0.028735,0.055565,0.128449,0.093396,0.006084,0.046873,0.084647,0.123778,0.134138,0.061317:-0.157421,-0.301339,-0.353774,-0.42105,-0.346828,-0.339908,-0.341862,-0.317933,-0.29699,-0.274824,-0.288952,-0.314657,-0.317341,-0.253636,-0.23053:0.331465,0.297169,0.179671,0.143713,0.054198,4.82E-4,-0.041426,-0.110053,-0.134091,-0.117969,-0.100279,-0.088146,-0.101492,-0.113585,-0.089801:-0.046141,-0.035003,0.026191,0.039051,-0.013478,-0.122845,-0.136346,-0.210914,-0.274417,-0.374488,-0.385374,-0.402544,-0.375244,-0.347725,-0.346905:-0.208316,-0.258928,-0.261372,-0.322047,-0.30158,-0.259053,-0.27668,-0.210795,-0.157398,-0.179042,-0.259958,-0.265885,-0.254916,-0.256627,-0.221605:-0.02195,-0.033619,0.008659,0.001805,0.010145,0.026019,0.042234,0.10995,0.123749,0.205048,0.269133,0.280551,0.241763,0.221969,0.231903:0.143628,0.156082,0.142957,0.192642,0.220486,0.216762,0.20243,0.104125,0.027861,0.026329,0.057567,0.043416,0.048555,0.043789,-0.047172:1
1.482768,1.817195,1.745,1.720759,1.827924,1.853412,1.819416,1.643331,1.449144,1.389639,1.39698,1.311547,1.243233,1.159148:-0.124894,-0.286967,-0.28893,-0.329536,-0.446744,-0.565355,-0.612843,-0.570023,-0.508827,-0.616142,-0.705398,-0.720416,-0.696817,-0.732947:0.573752,0.625139,0.663354,0.539693,0.505982,0.662257,0.553689,0.520455,0.552238,0.631728,0.851664,0.778788,0.718701,0.663187:-0.262642,-0.319714,-0.30513,-0.282105,-0.310774,-0.29267,-0.286866,-0.283296,-0.265278,-0.188338,-0.236651,-0.099664,0.091412,0.218:-0.043429,0.043902,-0.047376,0.06568,0.163399,0.056213,0.166702,0.268819,0.219058,0.224976,0.227458,0.29026,0.271793,0.254335:-0.326884,-0.314675,-0.205313,-0.219773,-0.084752,-0.004248,0.066323,0.15874,0.237387,0.236703,0.246351,0.177151,0.128967,0.070795:-0.259947,-0.247156,-0.239749,-0.229438,-0.301455,-0.331644,-0.351123,-0.337799,-0.310583,-0.387834,-0.429551,-0.387568,-0.360914,-0.294169:0.101963,0.125322,-0.029479,-0.042303,0.001326,-0.054574,-0.081458,-0.094458,-0.174189,-0.163597,-0.110611,-0.086708,-0.125689,-0.20682:-0.008893,-0.123669,-0.035896,-0.044778,-0.149856,-0.115019,-0.100075,-0.16102,-0.192188,-0.144169,-0.142699,-0.204241,-0.195768,-0.213149:-0.069691,-0.146629,-0.138298,-0.14762,-0.197757,-0.234736,-0.293914,-0.329397,-0.320975,-0.31071,-0.350157,-0.376472,-0.323241,-0.224211:-0.113352,-0.128601,-0.18725,-0.257499,-0.1463,-0.122544,-0.155033,-0.108259,-0.027117,0.005966,0.045893,0.095563,0.090065,0.043025:0.044541,0.070182,0.111714,0.118467,5.82E-4,0.042477,0.113744,0.123308,0.151665,0.10688,0.105927,0.111702,0.049967,0.016488:1
1.240129,1.257687,1.327516,1.396311,1.350236,1.331112,1.459863,1.445012,1.580351,1.657124,1.571426,1.462704:-0.191028,-0.154022,-0.160138,-0.181995,-0.167682,-0.303744,-0.414777,-0.547597,-0.644887,-0.681507,-0.653356,-0.69514:0.298426,0.334941,0.278216,0.299634,0.237738,0.329994,0.331581,0.552713,0.705852,0.63009,0.676752,0.803643:-0.203089,-0.183081,-0.128647,-0.095233,-0.038768,-0.063735,0.02252,-0.063076,-0.132887,0.039001,0.12711,0.118761:-0.344858,-0.267329,-0.14778,-0.053392,0.035465,0.140143,0.158602,0.085978,0.085601,0.087586,0.015909,0.011255:-0.139866,-0.112124,-0.056096,-0.010585,-0.031948,0.007809,0.028665,0.075115,0.084489,0.039304,0.106395,0.131562:-0.159241,-0.178024,-0.164521,-0.164948,-0.225328,-0.3093,-0.358245,-0.2807,-0.26289,-0.196646,-0.186454,-0.222778:0.147014,0.145034,-0.005433,-0.071867,-0.035091,-0.019939,-0.026027,-0.095199,-0.176328,-0.175869,-0.185343,-0.17886:0.024322,-0.021484,-0.043786,-0.13631,-0.179914,-0.195018,-0.20552,-0.28427,-0.377097,-0.383765,-0.302983,-0.251469:-0.379586,-0.399561,-0.440315,-0.456632,-0.468645,-0.411622,-0.394947,-0.30035,-0.241837,-0.242499,-0.271927,-0.273721:-0.084236,-0.055051,-0.008545,0.088084,0.115339,0.09798,0.075713,0.105544,0.187134,0.180711,0.141081,0.115114:0.189229,0.186738,0.279869,0.330101,0.299773,0.225047,0.179156,0.059459,0.02612,0.060393,0.064114,0.008981:1
1.561182,1.464189,1.535188,1.544737,1.570983,1.465835,1.487552,1.434067,1.319605,1.172349,1.196024,1.154107,1.040333,1.070966,1.163078,1.141713,1.087853,0.98663,0.977013:0.091719,0.053217,0.116987,0.19769,0.087092,0.114182,0.006384,-0.033376,-0.096329,-0.09582,-0.121467,-0.232998,-0.228803,-0.232325,-0.330648,-0.296437,-0.400562,-0.438889,-0.348809:0.369037,0.389357,0.448857,0.308297,0.413925,0.280217,0.265084,0.409016,0.501044,0.443434,0.552196,0.636905,0.569232,0.536288,0.585083,0.619903,0.785272,0.769833,0.707327:-0.369046,-0.24935,-0.38291,-0.390524,-0.430416,-0.231807,-0.136454,-0.234394,-0.235735,-0.080443,-0.084498,-0.046495,0.098072,0.163456,0.149937,0.114614,0.081629,0.197498,0.216012:0.093993,0.165755,0.214408,0.246699,0.256349,0.189004,0.227395,0.367146,0.387307,0.372723,0.47689,0.474789,0.458688,0.467069,0.55294,0.599561,0.55669,0.46965,0.533745:-0.408484,-0.321796,-0.288978,-0.18836,-0.163892,-0.143358,-0.177883,-0.27261,-0.231242,-0.185339,-0.207985,-0.196517,-0.225161,-0.170314,-0.130194,-0.11008,-0.071217,0.04074,-0.004777:-0.214892,-0.225504,-0.097607,-0.118288,-0.107942,-0.030019,0.008963,0.021112,0.031329,0.005411,-0.044813,-0.023221,5.68E-4,0.010233,-0.077449,-0.134846,-0.159991,-0.1587,-0.167701:0.265464,0.120788,0.096976,0.049998,0.049579,0.014563,-0.027721,0.033469,0.06329,0.027799,-0.001877,0.017988,-0.045244,-0.089671,-0.046821,-0.032396,-0.061384,-0.12842,-0.106995:-0.127507,-0.245839,-0.389723,-0.36579,-0.420094,-0.474293,-0.445209,-0.554132,-0.581137,-0.53474,-0.541312,-0.557556,-0.484826,-0.434072,-0.446469,-0.463742,-0.43404,-0.363025,-0.386168:-0.103555,-0.071939,-0.104037,-0.171895,-0.18986,-0.190302,-0.252063,-0.259289,-0.274133,-0.245293,-0.171009,-0.142335,-0.117562,-0.133358,-0.12606,-0.104702,-0.066978,-0.105483,-0.128815:0.008649,0.066911,0.069911,0.067986,0.071963,0.091005,0.056,0.039715,0.051049,0.076201,0.094597,0.095569,0.08445,0.075532,0.090969,0.112586,0.073364,0.094352,0.135459:0.020026,0.014287,0.058384,0.066837,0.068591,0.058625,0.133831,0.174952,0.151391,0.087217,0.062647,0.038903,0.024105,0.03112,-0.007796,-0.085121,-0.140097,-0.148382,-0.14589:1
1.534961,1.701557,1.860463,1.920867,1.753441,1.683414,1.756765,1.644043,1.53987,1.477207,1.478094,1.399998,1.442162,1.381959,1.68229,1.390464:0.135152,0.066036,-0.202317,-0.272178,-0.214586,-0.213188,-0.287502,-0.326705,-0.409918,-0.37428,-0.369848,-0.335895,-0.393047,-0.380126,-0.531203,-0.189923:0.359434,0.248507,0.344489,0.490347,0.506086,0.346652,0.243834,0.270861,0.438086,0.510631,0.453775,0.444292,0.513679,0.353789,0.497479,0.28837:-0.40684,-0.437872,-0.463496,-0.428007,-0.391525,-0.327435,-0.218437,-0.160928,-0.198798,-0.156237,-0.038946,0.095378,0.149568,0.289633,0.147362,0.210164:-0.159842,-0.010863,0.077126,0.130544,0.215818,0.255305,0.25949,0.266212,0.314485,0.351701,0.371426,0.300141,0.208843,0.262134,0.318714,0.256048:-0.254233,-0.259732,-0.204577,-0.142373,-0.115978,-0.06388,-0.044579,-0.030165,-0.03111,-0.091565,-0.128359,-0.057681,-0.046576,-0.131958,-0.190578,-0.082466:-0.264098,-0.258079,-0.199175,-0.284972,-0.349483,-0.345861,-0.36924,-0.338055,-0.339614,-0.386565,-0.465544,-0.436984,-0.293036,-0.183052,-0.148361,-0.135809:0.281291,0.275764,0.166969,0.166529,0.208772,0.173926,0.112511,-0.016417,0.014123,0.018046,-0.008206,-0.038792,-0.108885,-0.141991,-0.209818,-0.265367:0.122439,0.083108,-0.04946,-0.079196,-0.127544,-0.182883,-0.223656,-0.206232,-0.252998,-0.222903,-0.153874,-0.196565,-0.352369,-0.386113,-0.438608,-0.411463:-0.232343,-0.324214,-0.277803,-0.319992,-0.346808,-0.428078,-0.47231,-0.4382,-0.388685,-0.354811,-0.318694,-0.304746,-0.211463,-0.163749,-0.093579,-0.08959:0.023277,-0.040315,-0.124622,-0.13487,-0.080518,-0.052652,0.003528,0.010627,0.051742,0.049845,0.026675,0.088485,0.168846,0.10516,0.053821,0.076639:0.014731,0.04022,0.115523,0.076008,-0.030246,0.009506,0.104225,0.196844,0.159288,0.117032,0.046016,-0.004839,-0.071472,-0.044367,-0.027706,-0.094045:1
1.103336,1.1181,1.224558,1.132339,1.121599,1.084756,0.977183,1.148462,1.23971,1.138961,1.17755,1.100724,1.074002,1.064703,0.958702:0.109662,0.05053,-0.045954,2.3E-5,-0.078963,-0.158023,-0.171669,-0.289968,-0.416242,-0.455763,-0.519356,-0.511956,-0.565281,-0.637375,-0.54976:0.636015,0.574748,0.511294,0.372392,0.337845,0.367227,0.390637,0.472022,0.593415,0.641822,0.695525,0.642864,0.642205,0.681013,0.657031:-0.401023,-0.445782,-0.469661,-0.41721,-0.341637,-0.345787,-0.243227,-0.164605,-0.192928,-0.149541,-0.111054,-0.020074,0.003944,0.056152,0.092834:0.131212,0.111535,0.14965,0.182271,0.177134,0.257385,0.288333,0.257448,0.238826,0.24695,0.280666,0.326456,0.413466,0.399688,0.429399:-0.538618,-0.513456,-0.4268,-0.387085,-0.305758,-0.226802,-0.221358,-0.179853,-0.039152,0.01699,0.026432,0.050264,0.050038,0.129649,0.134715:-0.169496,-0.164088,-0.195121,-0.176289,-0.187209,-0.211311,-0.22562,-0.193169,-0.125921,-0.141716,-0.203242,-0.214036,-0.230335,-0.278884,-0.323939:0.265325,0.308073,0.299746,0.294164,0.29767,0.242328,0.142716,0.050227,-0.018482,0.011811,-0.013604,-0.107523,-0.10386,-0.134287,-0.130533:-0.148216,-0.120553,-0.136924,-0.14197,-0.123466,-0.112484,-0.11527,-0.114388,-0.197954,-0.229672,-0.241366,-0.241159,-0.278011,-0.232115,-0.212284:-0.065743,-0.114298,-0.145733,-0.141764,-0.187645,-0.240109,-0.256693,-0.261365,-0.329565,-0.391195,-0.354618,-0.301212,-0.282415,-0.306314,-0.314132:0.046169,0.037148,0.021655,-0.026271,-0.070074,-0.099311,-0.07324,-0.092354,-0.061167,-0.022486,0.013127,0.051211,0.072008,0.064786,0.0901:0.153564,0.1512,0.132454,0.096377,0.081622,0.090135,0.133995,0.182572,0.261859,0.227583,0.188256,0.168885,0.146023,0.146175,0.098219:1
1.105692,1.046695,1.103291,1.075526,1.132385,1.216862,1.205992,1.135162,1.114878,1.135884,1.040194,0.998969,1.040983,0.905315,0.923658,0.918812,0.948481:-0.315867,-0.27389,-0.317054,-0.295049,-0.34779,-0.487498,-0.557708,-0.50375,-0.513524,-0.618915,-0.559593,-0.646662,-0.823361,-0.674279,-0.709223,-0.874999,-1.101815:0.290203,0.186767,0.083564,-0.024025,-0.036327,9.52E-4,-0.01265,-0.003081,0.083679,0.174471,0.188998,0.27553,0.35907,0.345858,0.38005,0.48964,0.64122:-0.769009,-0.717103,-0.659359,-0.635336,-0.581913,-0.510174,-0.422516,-0.398548,-0.39666,-0.335241,-0.291866,-0.229727,-0.039262,-0.00776,0.001691,0.027088,0.081363:-0.053136,-0.001089,0.095073,0.204939,0.259926,0.29152,0.400992,0.497813,0.583013,0.589547,0.669009,0.662269,0.577049,0.593962,0.605453,0.560291,0.430033:-0.296672,-0.27612,-0.301002,-0.274136,-0.244659,-0.19995,-0.240608,-0.266283,-0.256074,-0.213664,-0.22545,-0.207052,-0.239763,-0.327698,-0.318078,-0.226548,-0.130921:-0.19378,-0.198809,-0.201165,-0.165661,-0.202151,-0.259033,-0.285295,-0.32208,-0.383816,-0.445338,-0.452738,-0.467217,-0.408408,-0.345858,-0.374702,-0.39858,-0.387595:0.238334,0.1758,0.163279,0.044227,0.020708,0.006113,0.004268,-0.04994,-0.0611,-0.018145,-0.031998,-0.052519,-0.095881,-0.09003,-0.064274,-0.076376,-0.087358:-0.073043,-0.047999,-0.078007,-0.093644,-0.114423,-0.156058,-0.290385,-0.311858,-0.325669,-0.326788,-0.329486,-0.340874,-0.354976,-0.38328,-0.368006,-0.324832,-0.304633:-0.269639,-0.287424,-0.344222,-0.356617,-0.378126,-0.384447,-0.297735,-0.267522,-0.245454,-0.240422,-0.199146,-0.149634,-0.087184,-0.087676,-0.079857,-0.058549,-0.063734:-0.073771,-0.113034,-0.131487,-0.15891,-0.183383,-0.169901,-0.135362,-0.093682,-0.045037,0.012009,0.005887,-0.00505,-0.043876,-0.030707,-0.030614,-0.029728,0.019434:0.102068,0.107567,0.130517,0.178418,0.170611,0.178299,0.127934,0.156947,0.149563,0.078205,0.016447,-0.052947,-0.07826,-0.040547,-0.073986,-0.122019,-0.184223:2
0.407083,0.427013,0.4532,0.546605,0.645384,0.61298,0.584168,0.601282,0.558224,0.466493,0.400928,0.33774,0.258591,0.217281,0.200392:-0.965201,-0.941585,-0.924575,-0.966436,-1.050109,-1.047103,-1.069127,-1.128262,-1.131261,-1.110196,-1.116119,-1.13291,-1.112441,-1.126157,-1.147712:0.494425,0.431336,0.386087,0.348749,0.360824,0.361869,0.356684,0.344707,0.33226,0.325444,0.352352,0.417092,0.47114,0.516915,0.550345:-0.811934,-0.772243,-0.747992,-0.696195,-0.661624,-0.624687,-0.601208,-0.555417,-0.51248,-0.466772,-0.423267,-0.374899,-0.345132,-0.317244,-0.268757:-0.213926,-0.16442,-0.106285,-0.044006,0.035787,0.132774,0.228036,0.304401,0.361472,0.416269,0.471474,0.509729,0.558634,0.596432,0.601351:-0.223933,-0.226428,-0.237052,-0.233719,-0.196354,-0.169323,-0.145201,-0.15131,-0.135721,-0.130243,-0.139558,-0.151893,-0.171128,-0.19887,-0.226233:-0.198688,-0.209453,-0.219099,-0.236414,-0.299479,-0.341115,-0.376442,-0.41148,-0.434717,-0.442981,-0.46288,-0.477137,-0.493158,-0.507946,-0.505173:0.299522,0.268353,0.242788,0.205047,0.160587,0.105664,0.068606,0.034387,-0.024807,-0.067131,-0.078082,-0.063657,-0.037046,-0.008256,0.001287:-0.171709,-0.16433,-0.172258,-0.19058,-0.201342,-0.227557,-0.261811,-0.280891,-0.293974,-0.305282,-0.317773,-0.341152,-0.37442,-0.407955,-0.425558:-0.335435,-0.345693,-0.345464,-0.337274,-0.308622,-0.301393,-0.306898,-0.286172,-0.257996,-0.241852,-0.21305,-0.194404,-0.188006,-0.178293,-0.158907:0.029597,-0.015832,-0.041582,-0.045769,-0.063267,-0.063819,-0.059241,-0.052978,-0.024969,-0.009181,0.009601,0.027826,0.051911,0.077574,0.088071:0.163757,0.196763,0.231454,0.243891,0.232726,0.257115,0.261977,0.232622,0.23164,0.220336,0.17567,0.107958,0.037291,-0.034312,-0.091669:2
0.123788,0.145563,0.149967,0.227408,0.173546,0.266297,0.324333,0.318371,0.318929,0.298179,0.271437,0.304637,0.247462,0.188087,0.172129,0.159354,0.062085:-0.815576,-0.838868,-0.840318,-0.899526,-0.799179,-0.846869,-0.930829,-0.975903,-1.025543,-1.072388,-1.11246,-1.131654,-1.098201,-1.08678,-1.067717,-1.108166,-1.080117:0.55096,0.52385,0.475913,0.475565,0.397273,0.372403,0.34441,0.311221,0.319718,0.347828,0.372147,0.413109,0.455395,0.46947,0.482826,0.504088,0.528594:-0.803699,-0.793164,-0.786561,-0.807752,-0.768921,-0.751052,-0.730384,-0.669759,-0.616811,-0.569743,-0.492863,-0.421391,-0.357781,-0.319696,-0.259631,-0.254141,-0.222688:-0.322865,-0.29172,-0.237241,-0.154466,-0.07464,0.029932,0.125697,0.215715,0.304548,0.40138,0.481446,0.53152,0.57794,0.628025,0.631265,0.645378,0.63415:-0.34645,-0.339685,-0.331002,-0.325077,-0.306803,-0.280699,-0.253848,-0.256184,-0.231608,-0.203074,-0.201326,-0.211923,-0.253418,-0.294191,-0.338329,-0.350643,-0.351651:-0.196159,-0.203384,-0.207769,-0.241294,-0.237455,-0.25378,-0.259015,-0.271945,-0.314027,-0.362058,-0.38453,-0.423385,-0.47443,-0.5067,-0.498401,-0.519563,-0.494934:0.352055,0.349304,0.338879,0.347336,0.310929,0.280042,0.24317,0.204048,0.163145,0.127895,0.110814,0.083776,0.06255,0.054374,0.035431,0.050015,0.033708:-0.091918,-0.095303,-0.101694,-0.120609,-0.151348,-0.202975,-0.258918,-0.301676,-0.356801,-0.411336,-0.443197,-0.4461,-0.448113,-0.466457,-0.470076,-0.47663,-0.475057:-0.257448,-0.277426,-0.289209,-0.293223,-0.314965,-0.324266,-0.328931,-0.332981,-0.340457,-0.339973,-0.331975,-0.286898,-0.229783,-0.177125,-0.132843,-0.11685,-0.08124:0.049375,0.030153,-0.003567,-0.029406,-0.043422,-0.038769,-0.042701,-0.054098,-0.018517,0.024596,0.041215,0.056769,0.073267,0.091851,0.090544,0.113499,0.115896:0.130279,0.142595,0.15152,0.157458,0.193343,0.216487,0.227737,0.225643,0.228825,0.217512,0.177652,0.118797,0.047353,-0.029811,-0.061925,-0.096879,-0.134155:2
-0.12072,-0.103246,-0.064884,-0.010262,0.045308,0.019173,0.034676,0.120406,0.132261,0.1487,0.107665,0.02895,-0.004667,-0.047412,-0.085351:-0.530613,-0.567652,-0.586597,-0.587205,-0.650345,-0.688535,-0.745043,-0.818459,-0.793155,-0.813031,-0.878581,-0.941286,-0.968241,-0.94932,-0.940661:0.5371,0.501765,0.439994,0.391194,0.39839,0.370883,0.303248,0.266691,0.217531,0.240607,0.269841,0.29802,0.314091,0.369656,0.424328:-0.775858,-0.772455,-0.758783,-0.739271,-0.718859,-0.676546,-0.632173,-0.558117,-0.485091,-0.462406,-0.409889,-0.343514,-0.277334,-0.18242,-0.118531:-0.19392,-0.160634,-0.130255,-0.085919,-0.025684,0.076082,0.191734,0.299097,0.395567,0.454097,0.532316,0.598261,0.650486,0.696799,0.708583:-0.488139,-0.46354,-0.455062,-0.458599,-0.439377,-0.396107,-0.351493,-0.32678,-0.267092,-0.272808,-0.287326,-0.310041,-0.397795,-0.422858,-0.421565:-0.224763,-0.200626,-0.14992,-0.131125,-0.140597,-0.172146,-0.205095,-0.239981,-0.272747,-0.303456,-0.338476,-0.384291,-0.378954,-0.366134,-0.344853:0.321457,0.332874,0.333054,0.320415,0.286418,0.196387,0.12621,0.076971,0.016947,0.011391,-0.025534,-0.051553,-0.028263,-0.028627,-0.043279:-0.060211,-0.086042,-0.105649,-0.116455,-0.15113,-0.181221,-0.213026,-0.25402,-0.308802,-0.353094,-0.388765,-0.424307,-0.457194,-0.438245,-0.433491:-0.182948,-0.232275,-0.272089,-0.280514,-0.279718,-0.285632,-0.316069,-0.327009,-0.334644,-0.312583,-0.251832,-0.186621,-0.108635,-0.035892,-0.008171:-0.014524,-0.049763,-0.086203,-0.10804,-0.107708,-0.126383,-0.158751,-0.140951,-0.09791,-0.066344,-0.035628,-0.003159,0.007613,-0.00914,-0.015759:0.134734,0.144645,0.170181,0.190126,0.202837,0.229881,0.270092,0.284613,0.276387,0.24763,0.202738,0.140516,0.055097,-0.048522,-0.097655:2
-0.250898,-0.228699,-0.242686,-0.279768,-0.26148,-0.17895,-0.080492,-0.02589,-0.009817,-0.034001,-0.066462,-0.155759,-0.202669,-0.237334,-0.279925,-0.320669,-0.325639:-0.475274,-0.563966,-0.594216,-0.577068,-0.603838,-0.657197,-0.738406,-0.811474,-0.830176,-0.853977,-0.877063,-0.843909,-0.840576,-0.856871,-0.913214,-0.929429,-0.925286:0.360424,0.377227,0.349415,0.267089,0.210609,0.195864,0.196706,0.211019,0.205443,0.201207,0.211711,0.23155,0.255984,0.30254,0.350762,0.410157,0.441583:-0.760944,-0.754653,-0.732024,-0.67094,-0.632839,-0.605619,-0.568162,-0.536297,-0.492043,-0.439796,-0.381583,-0.306704,-0.269904,-0.213076,-0.133257,-0.082526,-0.077574:-0.168786,-0.117495,-0.069244,0.012777,0.107397,0.180692,0.277019,0.372565,0.471517,0.522295,0.576007,0.639415,0.701788,0.740532,0.773044,0.751521,0.737248:-0.456987,-0.43543,-0.41638,-0.383661,-0.353967,-0.364647,-0.363311,-0.334759,-0.335913,-0.354656,-0.393246,-0.445753,-0.460491,-0.444825,-0.451377,-0.461333,-0.470609:-0.072131,-0.056484,-0.060165,-0.096476,-0.130747,-0.150216,-0.17425,-0.200517,-0.24018,-0.269355,-0.30339,-0.340794,-0.344768,-0.306114,-0.275401,-0.269565,-0.275996:0.288298,0.29591,0.277355,0.216453,0.157263,0.131645,0.095876,0.058897,0.010431,-0.032235,-0.05915,-0.079987,-0.072881,-0.074927,-0.077676,-0.082196,-0.078931:-0.155751,-0.211398,-0.224883,-0.206883,-0.228916,-0.255721,-0.29939,-0.342955,-0.410864,-0.435689,-0.440231,-0.435121,-0.45153,-0.465505,-0.475957,-0.466373,-0.463848:-0.210396,-0.260267,-0.292405,-0.310619,-0.330268,-0.333557,-0.317502,-0.290242,-0.254854,-0.22289,-0.177195,-0.114149,-0.073912,-0.046665,-0.015353,-0.006645,-0.004695:0.005659,-0.02616,-0.052374,-0.079459,-0.09612,-0.09552,-0.092175,-0.097732,-0.038529,0.001266,0.028845,0.048763,0.04604,0.02251,-0.020763,-0.042994,-0.053092:0.135641,0.145826,0.180288,0.224094,0.270699,0.300682,0.306603,0.270593,0.251128,0.242396,0.207776,0.151884,0.103687,0.036682,-0.044797,-0.096569,-0.125205:2
0.874774,0.866473,1.031039,1.241234,1.301898,1.277762,1.234181,1.163515,1.043853,0.940848,0.77687,0.675692,0.678212:-0.305363,-0.316127,-0.426662,-0.597584,-0.737536,-1.000355,-1.103993,-1.162442,-1.170744,-1.197528,-1.191898,-1.189214,-1.27144:0.303361,0.172322,0.152994,0.185954,0.071743,0.194303,0.252703,0.292481,0.313917,0.37183,0.433745,0.50406,0.616429:-0.762491,-0.645828,-0.639722,-0.676402,-0.458221,-0.408907,-0.39079,-0.345305,-0.288343,-0.244109,-0.179923,-0.092482,-0.047243:-0.084527,-0.030585,0.065516,0.153707,0.177034,0.181727,0.228438,0.306336,0.385639,0.438143,0.464281,0.468505,0.467326:-0.279895,-0.262859,-0.276086,-0.244404,-0.287143,-0.179619,-0.114742,-0.092818,-0.122139,-0.164706,-0.203113,-0.219103,-0.17611:-0.074561,-0.104473,-0.127,-0.181608,-0.14137,-0.236234,-0.326887,-0.395652,-0.43037,-0.460648,-0.466679,-0.439719,-0.426045:0.229832,0.200011,0.198792,0.189813,0.126472,0.065877,0.044963,0.013325,-0.027378,-0.031135,-0.025151,-0.01363,0.009244:-0.186641,-0.212763,-0.273037,-0.304624,-0.385185,-0.39189,-0.373009,-0.36264,-0.375192,-0.38623,-0.390595,-0.37155,-0.333305:-0.286696,-0.314334,-0.329528,-0.333932,-0.277992,-0.318365,-0.352445,-0.332396,-0.269483,-0.207578,-0.156485,-0.114604,-0.108721:-0.019252,-0.014233,-0.022845,-0.057035,-0.034195,0.031296,0.072303,0.09033,0.089584,0.083308,0.088208,0.075246,0.046378:0.084325,0.085088,0.121439,0.161878,0.15748,0.176863,0.16878,0.131997,0.086389,0.025433,-0.045731,-0.120303,-0.173873:2
0.505731,0.773173,0.703102,0.643126,0.854973,0.842185,0.855469,0.784337,0.566928,0.372264,0.272352,0.188923,0.099729,0.105163,0.111056,0.066446,-0.028971,-0.133053:-0.602379,-0.559436,-0.549696,-0.579417,-0.610673,-0.664344,-0.772423,-0.843356,-0.839938,-0.830732,-0.86047,-0.876657,-0.858451,-0.867614,-0.845245,-0.827924,-0.822381,-0.813806:0.317313,0.224484,0.18911,0.193395,0.110245,0.084707,0.111432,0.139163,0.153871,0.160599,0.176827,0.219608,0.261516,0.319923,0.36763,0.40882,0.444085,0.491495:-0.779016,-0.727391,-0.623961,-0.600539,-0.540449,-0.500551,-0.43255,-0.394388,-0.35754,-0.269691,-0.185801,-0.128047,-0.081903,-0.056164,-0.026076,0.009427,0.037669,0.076518:-0.192919,-0.123887,-0.04891,0.030045,0.083668,0.17945,0.214848,0.280073,0.402871,0.514444,0.556532,0.573773,0.579942,0.544872,0.504349,0.50566,0.55033,0.575301:-0.382196,-0.393568,-0.366431,-0.35006,-0.321981,-0.309454,-0.273555,-0.263397,-0.322575,-0.384014,-0.419643,-0.46019,-0.490169,-0.486897,-0.48608,-0.492806,-0.493791,-0.488117:0.054884,0.060471,0.027513,0.012732,-0.007487,-0.084007,-0.13458,-0.18502,-0.227325,-0.230677,-0.232412,-0.244493,-0.242392,-0.243716,-0.228112,-0.219664,-0.188112,-0.138248:0.249567,0.214198,0.173851,0.153596,0.086329,0.076494,0.030319,-0.010145,-0.036042,-0.073592,-0.095201,-0.119204,-0.147757,-0.157197,-0.166074,-0.138451,-0.103156,-0.098865:-0.260515,-0.287083,-0.289195,-0.318819,-0.302256,-0.350379,-0.402324,-0.412762,-0.401077,-0.438611,-0.448297,-0.435992,-0.425596,-0.414837,-0.39562,-0.35451,-0.33018,-0.32819:-0.185928,-0.212606,-0.267371,-0.3046,-0.314075,-0.305654,-0.27782,-0.252772,-0.215909,-0.146895,-0.111364,-0.076577,-0.045456,-0.024556,-0.004755,-6.57E-4,0.00676,0.018664:0.017664,0.03069,0.033017,0.018906,-0.022023,0.024163,0.08984,0.091203,0.060339,0.05789,0.040919,0.028908,0.019952,0.006712,-0.004787,-0.041194,-0.08328,-0.118864:0.125582,0.177814,0.240855,0.284844,0.310622,0.280373,0.263116,0.254568,0.226182,0.174202,0.103964,0.045017,0.011976,-0.015674,-0.045588,-0.079626,-0.123159,-0.166061:2
0.02502,0.082999,0.078928,0.14867,0.190199,0.145568,0.05317,0.058621,0.056427,0.048287,0.082129,0.136695,0.140508,0.177852,0.155808,0.193985,0.194091,0.196233:-0.665521,-0.709692,-0.68391,-0.719982,-0.717804,-0.746869,-0.785455,-0.853558,-0.865516,-0.843724,-0.824349,-0.857444,-0.860506,-0.896654,-0.923583,-0.937871,-0.90974,-0.897276:0.276949,0.255108,0.224741,0.199839,0.152577,0.139544,0.124579,0.127213,0.125467,0.141954,0.150762,0.172465,0.175874,0.137849,0.119242,0.135832,0.213529,0.261565:-0.796809,-0.78396,-0.746853,-0.708202,-0.656109,-0.618606,-0.567077,-0.539733,-0.512414,-0.457266,-0.397606,-0.376199,-0.33952,-0.293112,-0.23599,-0.180354,-0.11235,-0.067575:-0.042466,0.007934,0.054868,0.11117,0.143468,0.199661,0.256066,0.318595,0.373072,0.434081,0.493884,0.514649,0.526122,0.549779,0.555051,0.510487,0.449263,0.444974:-0.454755,-0.420994,-0.414619,-0.416303,-0.389656,-0.376456,-0.39288,-0.412483,-0.411077,-0.430598,-0.421708,-0.408094,-0.423896,-0.438193,-0.454828,-0.456868,-0.449344,-0.430018:0.006449,-0.023652,-0.048534,-0.074008,-0.07643,-0.109783,-0.134529,-0.169518,-0.188444,-0.207344,-0.217124,-0.240038,-0.254343,-0.260253,-0.263918,-0.25444,-0.241303,-0.208671:0.240018,0.215795,0.200084,0.17325,0.105632,0.060524,0.01883,0.004884,-0.005572,-0.018536,-0.047813,-0.069321,-0.10292,-0.13461,-0.161835,-0.195627,-0.226703,-0.22716:-0.261964,-0.270957,-0.265711,-0.269557,-0.255998,-0.258764,-0.268337,-0.295268,-0.3318,-0.362827,-0.391362,-0.413485,-0.422638,-0.429364,-0.420435,-0.386486,-0.335252,-0.282067:-0.196587,-0.230277,-0.265998,-0.277953,-0.290082,-0.302912,-0.293532,-0.27649,-0.268008,-0.246616,-0.237849,-0.2183,-0.188181,-0.162912,-0.13682,-0.109392,-0.0837,-0.07117:0.014225,0.013613,-0.001516,-0.009105,-0.02933,-0.057824,-0.051905,-0.020103,0.013996,0.043534,0.052635,0.06937,0.092995,0.100115,0.100446,0.08377,0.062071,0.018154:0.232199,0.276159,0.318875,0.350343,0.374225,0.380643,0.372717,0.375098,0.367577,0.338836,0.298547,0.268393,0.242305,0.215647,0.18117,0.15907,0.128921,0.089543:2
0.28476,0.131918,8.23E-4,-0.012026,0.024477,0.058934,0.020033,0.023612,0.006993,0.012267,-0.061628,-0.119962,-0.146022,-0.163992,-0.173673,-0.198993,-0.22026,-0.235707:-0.629487,-0.53006,-0.434284,-0.465129,-0.548637,-0.618717,-0.636318,-0.699694,-0.754563,-0.785885,-0.80018,-0.805887,-0.809878,-0.80062,-0.767237,-0.767722,-0.805721,-0.829455:0.372553,0.263069,0.127474,0.114444,0.133365,0.138744,0.110804,0.125766,0.152735,0.159795,0.167265,0.189939,0.234707,0.281597,0.327258,0.373557,0.413866,0.45089:-0.835579,-0.716293,-0.60979,-0.590891,-0.591911,-0.579909,-0.508597,-0.419789,-0.346539,-0.276252,-0.21028,-0.152749,-0.114868,-0.084146,-0.043469,0.019597,0.062374,0.086794:-0.017716,0.023313,0.077167,0.131488,0.187263,0.252204,0.335583,0.414206,0.470377,0.494487,0.512227,0.531851,0.534883,0.531387,0.55631,0.572435,0.587509,0.597724:-0.468847,-0.493288,-0.449278,-0.418718,-0.413669,-0.407261,-0.403529,-0.386292,-0.361212,-0.365005,-0.391669,-0.442627,-0.472353,-0.4671,-0.436833,-0.426642,-0.422511,-0.436836:-0.009528,0.038827,0.011913,-1.97E-4,-0.005406,-0.014068,-0.066947,-0.123331,-0.151261,-0.164558,-0.17136,-0.187552,-0.205703,-0.20741,-0.192549,-0.198455,-0.189561,-0.182478:0.343397,0.248177,0.163058,0.113684,0.072159,0.028062,-0.024867,-0.094529,-0.153064,-0.190332,-0.235924,-0.251984,-0.245852,-0.24093,-0.236757,-0.237925,-0.229027,-0.207583:-0.324469,-0.315762,-0.293459,-0.323965,-0.358317,-0.396979,-0.364653,-0.364582,-0.378015,-0.369128,-0.362315,-0.367291,-0.367118,-0.346573,-0.307048,-0.268969,-0.280229,-0.293822:-0.189101,-0.202816,-0.239986,-0.256019,-0.260606,-0.257027,-0.282283,-0.27646,-0.259661,-0.236259,-0.187059,-0.124019,-0.086038,-0.070634,-0.052285,-0.035053,-0.023636,-0.023811:0.010935,-0.013884,0.003086,0.020851,0.015928,0.014072,-0.014314,0.012568,0.030943,0.035895,0.020738,0.029124,0.040289,0.039275,0.018383,-0.041337,-0.085763,-0.113344:0.11741,0.175027,0.248714,0.313423,0.329135,0.325313,0.346869,0.354418,0.32103,0.263804,0.209523,0.141559,0.08784,0.043768,-0.003827,-0.033786,-0.076427,-0.110896:2
0.340216,0.484561,0.550872,0.60838,0.602317,0.59246,0.569079,0.528475,0.512223,0.570955,0.606515,0.63374,0.583391,0.442473,0.341111,0.257084:-0.729865,-0.777275,-0.775679,-0.782584,-0.832186,-0.891436,-0.89944,-0.900369,-0.932479,-0.98561,-0.975485,-1.010961,-1.036567,-1.008526,-1.017842,-1.072479:0.5605,0.522891,0.465033,0.384982,0.324201,0.301627,0.277537,0.270233,0.255506,0.227397,0.251145,0.298306,0.372112,0.423647,0.450426,0.489223:-0.909362,-0.89398,-0.87191,-0.859185,-0.802552,-0.733489,-0.670261,-0.626432,-0.582952,-0.532593,-0.464966,-0.395752,-0.330355,-0.246634,-0.17508,-0.126058:-0.078328,-0.024151,0.024096,0.110513,0.201437,0.289426,0.427379,0.52282,0.563144,0.574488,0.580768,0.556454,0.549145,0.592241,0.619311,0.634441:-0.381175,-0.344226,-0.31992,-0.318184,-0.320977,-0.2956,-0.279921,-0.278463,-0.277153,-0.293566,-0.315524,-0.312643,-0.316386,-0.353834,-0.3609,-0.341134:-0.20755,-0.211033,-0.205051,-0.217411,-0.238449,-0.281951,-0.344171,-0.367898,-0.386988,-0.410045,-0.445149,-0.464848,-0.474116,-0.457006,-0.396104,-0.356267:0.432695,0.429683,0.399222,0.373215,0.348483,0.291963,0.243122,0.205869,0.16123,0.115535,0.071005,0.038547,0.026911,0.023877,-0.007508,-0.024079:-0.323221,-0.374135,-0.394073,-0.406176,-0.432361,-0.449803,-0.479756,-0.527202,-0.547954,-0.539507,-0.521422,-0.501322,-0.47702,-0.453458,-0.441155,-0.452568:-0.260977,-0.319446,-0.35534,-0.36415,-0.378232,-0.363385,-0.346123,-0.323124,-0.288934,-0.23832,-0.180756,-0.146866,-0.109782,-0.065695,-0.037856,-0.02108:0.138401,0.143885,0.114706,0.071154,0.061443,0.070354,0.076825,0.088229,0.102108,0.115798,0.144653,0.156848,0.15188,0.105098,0.030823,-0.002717:0.037627,0.055799,0.082807,0.10657,0.130345,0.132398,0.140131,0.1302,0.110098,0.089746,0.054975,0.02394,-0.035487,-0.1023,-0.138106,-0.191261:2
-0.155496,-0.06352,-0.041934,-0.093335,-0.095703,-0.084038,-0.069857,-0.063045,-0.044031,-0.084328,-0.081209,-0.097406,-0.143428,-0.154904,-0.16657,-0.224896,-0.264438,-0.269369:-0.671077,-0.738407,-0.79106,-0.816345,-0.836828,-0.835662,-0.83253,-0.849428,-0.839078,-0.862424,-0.921331,-0.968097,-0.959346,-0.942473,-0.939357,-0.940378,-0.926582,-0.91307:0.291899,0.322223,0.326683,0.319764,0.315358,0.302885,0.303063,0.320109,0.322153,0.35258,0.377387,0.406234,0.434954,0.467181,0.503293,0.554962,0.601696,0.613782:-0.742481,-0.733575,-0.722948,-0.715195,-0.68014,-0.628099,-0.58917,-0.551691,-0.521909,-0.465824,-0.418013,-0.380608,-0.343903,-0.290838,-0.23227,-0.179044,-0.163148,-0.156027:-0.151516,-0.088584,-0.02268,0.043488,0.117563,0.21046,0.281697,0.343179,0.393278,0.439025,0.469129,0.476973,0.491685,0.520098,0.560979,0.591568,0.58741,0.584185:-0.307418,-0.294672,-0.293018,-0.279697,-0.289696,-0.287469,-0.286017,-0.289276,-0.313032,-0.344861,-0.368765,-0.368103,-0.367087,-0.36864,-0.363241,-0.365022,-0.374882,-0.386437:-0.101425,-0.11061,-0.115032,-0.134008,-0.152354,-0.193233,-0.213961,-0.229842,-0.239012,-0.259338,-0.285079,-0.309917,-0.328985,-0.325413,-0.314037,-0.301627,-0.289155,-0.272071:0.243629,0.237151,0.207784,0.178982,0.145307,0.103167,0.070189,0.04275,0.018131,-0.014756,-0.048686,-0.084437,-0.107219,-0.113072,-0.109515,-0.112536,-0.127739,-0.136581:-0.160676,-0.211422,-0.254683,-0.276401,-0.31954,-0.37174,-0.424898,-0.470392,-0.503164,-0.534396,-0.548283,-0.542432,-0.51883,-0.488992,-0.491809,-0.506164,-0.509787,-0.510514:-0.286498,-0.309701,-0.306505,-0.309802,-0.302514,-0.287329,-0.273076,-0.247115,-0.197591,-0.142765,-0.090723,-0.044417,-0.006799,0.026297,0.030873,0.04029,0.067116,0.092265:0.010644,-0.007559,-0.027064,-0.031593,-0.006098,0.04169,0.07855,0.102087,0.121169,0.132851,0.144458,0.157963,0.15109,0.118815,0.081384,0.042028,0.007757,-0.020198:0.240941,0.242073,0.247078,0.25401,0.274061,0.296773,0.300972,0.267349,0.214872,0.156543,0.11204,0.071362,0.033445,-0.011401,-0.076089,-0.140778,-0.188369,-0.226113:2
0.126633,0.125344,0.125443,0.163474,0.146955,0.188675,0.167121,0.143383,0.101677,0.025527,-8.71E-4,-0.024848,-0.049926,-0.061908,-0.129878,-0.133312:-0.715534,-0.746034,-0.766636,-0.804196,-0.788589,-0.825185,-0.869384,-0.889143,-0.887435,-0.903709,-0.965633,-0.977445,-0.928151,-0.905822,-0.942983,-0.972373:0.406398,0.375056,0.349522,0.309247,0.261328,0.216911,0.191937,0.188031,0.202752,0.217868,0.218079,0.254997,0.320141,0.382607,0.444707,0.492373:-0.901806,-0.867893,-0.824174,-0.780504,-0.733535,-0.683894,-0.617236,-0.549874,-0.456971,-0.391721,-0.328501,-0.272374,-0.222948,-0.159124,-0.063905,-0.018671:-0.005216,0.045603,0.084531,0.16963,0.268961,0.353565,0.405986,0.475902,0.587012,0.66941,0.693521,0.695226,0.688629,0.68312,0.718177,0.691673:-0.421515,-0.429486,-0.421098,-0.389797,-0.361312,-0.367678,-0.368373,-0.36303,-0.378474,-0.380927,-0.412007,-0.449924,-0.470599,-0.462042,-0.430738,-0.41677:-0.18255,-0.170187,-0.147397,-0.166022,-0.225814,-0.234383,-0.232454,-0.257255,-0.314023,-0.344215,-0.332019,-0.343762,-0.35398,-0.327956,-0.277083,-0.244039:0.416014,0.406395,0.365409,0.303711,0.243636,0.202073,0.141677,0.080953,0.031928,-0.009993,-0.028888,-0.043424,-0.058307,-0.056132,-0.051707,-0.081007:-0.250553,-0.266774,-0.287181,-0.308089,-0.321175,-0.375633,-0.402597,-0.422628,-0.453734,-0.489458,-0.509156,-0.500107,-0.479334,-0.453848,-0.430248,-0.41411:-0.265751,-0.283456,-0.286801,-0.29023,-0.310857,-0.32197,-0.32036,-0.288562,-0.214339,-0.181426,-0.15142,-0.102299,-0.051842,-0.014512,-0.006723,-0.0057:0.006087,-0.023817,-0.035543,-0.046085,-0.055194,-0.040815,-0.031024,-0.017119,0.008576,0.027544,0.02419,0.035956,0.041924,0.016064,-0.03024,-0.05917:0.128534,0.146087,0.16081,0.180588,0.228289,0.260676,0.27484,0.257546,0.198838,0.164598,0.123667,0.063371,-0.002446,-0.061303,-0.122807,-0.146659:2
0.061186,0.07072,0.102783,0.092701,0.186948,0.213914,0.228303,0.184677,0.118861,0.134997,0.113071,0.111707,0.093938:-0.630197,-0.659269,-0.712534,-0.744065,-0.812765,-0.897449,-0.910316,-0.912981,-0.924663,-0.966274,-0.964493,-0.94052,-0.962248:0.133238,0.095412,0.105226,0.124571,0.147722,0.179951,0.192122,0.22905,0.265734,0.336322,0.410055,0.459281,0.490215:-0.649901,-0.61175,-0.567655,-0.513441,-0.461922,-0.405015,-0.337555,-0.283253,-0.22917,-0.147422,-0.109836,-0.069343,-0.05617:0.16667,0.275402,0.372713,0.446859,0.512713,0.539288,0.574406,0.581225,0.597006,0.615333,0.600459,0.556771,0.538278:-0.380016,-0.348052,-0.334728,-0.322629,-0.335094,-0.342577,-0.367406,-0.396683,-0.42524,-0.419602,-0.427373,-0.46162,-0.44091:-0.118068,-0.169692,-0.221307,-0.252598,-0.283357,-0.305731,-0.327299,-0.331575,-0.324828,-0.298502,-0.278731,-0.26634,-0.252979:0.170164,0.104308,0.058906,0.023568,-7.42E-4,-0.048546,-0.109463,-0.124369,-0.10929,-0.085914,-0.079988,-0.089837,-0.11651:-0.225958,-0.248997,-0.280878,-0.323815,-0.37645,-0.403018,-0.421716,-0.442598,-0.437057,-0.410168,-0.399872,-0.38904,-0.392243:-0.266667,-0.266693,-0.263201,-0.259914,-0.259426,-0.228027,-0.152944,-0.098155,-0.063411,-0.044873,-0.040872,-0.037025,-0.027154:-0.063232,-0.083197,-0.088247,-0.072434,-0.045189,-0.023847,0.021407,0.0471,0.04118,-0.006326,-0.040383,-0.063626,-0.077194:0.26126,0.281135,0.287306,0.269452,0.262233,0.246483,0.213518,0.170977,0.11635,0.042595,-0.016249,-0.037528,-0.062828:2
0.562239,0.479534,0.463009,0.456653,0.396707,0.40876,0.404983,0.360236,0.317299,0.278,0.221533,0.078363,0.00893,-0.024202:-0.66025,-0.72973,-0.712628,-0.742182,-0.740548,-0.762213,-0.826327,-0.83556,-0.858207,-0.851669,-0.848124,-0.7838,-0.786269,-0.78122:0.193376,0.174621,0.145631,0.115538,0.089343,0.07908,0.119424,0.142161,0.153601,0.238313,0.337428,0.342587,0.395295,0.448409:-0.755163,-0.743697,-0.720011,-0.669518,-0.614147,-0.532372,-0.426234,-0.334053,-0.223629,-0.103698,-0.014903,0.071247,0.117787,0.161935:0.059553,0.114838,0.167562,0.24879,0.344088,0.432181,0.520399,0.558495,0.553641,0.519135,0.508833,0.521248,0.529025,0.511592:-0.453043,-0.421814,-0.42648,-0.413531,-0.374918,-0.354771,-0.346081,-0.350372,-0.378266,-0.400513,-0.360223,-0.335369,-0.348007,-0.35728:-0.101627,-0.130567,-0.136102,-0.159072,-0.187817,-0.218027,-0.258391,-0.286066,-0.290083,-0.285963,-0.255675,-0.199078,-0.174844,-0.166272:0.264355,0.248541,0.223375,0.161363,0.071004,0.007159,-0.036348,-0.074446,-0.120556,-0.170002,-0.182586,-0.175952,-0.188874,-0.206417:-0.156848,-0.150092,-0.161998,-0.207357,-0.265975,-0.302033,-0.359313,-0.376773,-0.381677,-0.374197,-0.354012,-0.349082,-0.348739,-0.336524:-0.299425,-0.315592,-0.331463,-0.31323,-0.297628,-0.290371,-0.268743,-0.240336,-0.188052,-0.10012,-0.037641,-0.011119,0.015036,0.048875:-0.165016,-0.185823,-0.189488,-0.152139,-0.106895,-0.09234,-0.047149,-0.023021,0.005364,0.030999,0.019949,-0.00306,-0.067324,-0.111781:0.215542,0.229977,0.24234,0.255008,0.284187,0.289922,0.256543,0.209438,0.148525,0.063781,-0.027881,-0.125079,-0.191449,-0.237463:2
-0.048936,0.047679,0.004969,0.011024,0.021487,3.69E-4,0.005295,0.003179,-0.002155,-0.018566,-0.023729,-0.049334,-0.128557,-0.191325,-0.187916:-0.319252,-0.387743,-0.374006,-0.421777,-0.463489,-0.40983,-0.404235,-0.430814,-0.490842,-0.542705,-0.580772,-0.605998,-0.654304,-0.636885,-0.68183:0.25491,0.282565,0.25989,0.273527,0.270523,0.232556,0.226865,0.245457,0.273805,0.293744,0.346894,0.38793,0.436004,0.466877,0.523758:-0.764382,-0.768108,-0.724319,-0.694634,-0.670915,-0.634583,-0.585265,-0.520752,-0.486569,-0.432281,-0.341215,-0.243258,-0.158007,-0.117185,-0.108263:-0.162027,-0.080508,0.001738,0.057475,0.131422,0.213609,0.256986,0.324984,0.415508,0.481007,0.578098,0.663171,0.6931,0.691751,0.697581:-0.442659,-0.405294,-0.385659,-0.372641,-0.341265,-0.329958,-0.32914,-0.323642,-0.31569,-0.336012,-0.349083,-0.348015,-0.370422,-0.385709,-0.403718:-0.05307,-0.090992,-0.128902,-0.126923,-0.130326,-0.140543,-0.149384,-0.185151,-0.215601,-0.22543,-0.258888,-0.313012,-0.371271,-0.398591,-0.405056:0.332276,0.322869,0.285526,0.23949,0.192638,0.168346,0.130383,0.078192,0.049787,0.026657,0.010238,-0.019806,-0.027145,-0.029568,-0.013562:-0.186515,-0.206675,-0.226949,-0.273785,-0.316599,-0.353962,-0.374897,-0.413101,-0.465223,-0.474046,-0.469827,-0.464901,-0.419987,-0.392906,-0.387168:-0.246356,-0.277643,-0.309101,-0.332705,-0.358783,-0.36929,-0.362975,-0.34091,-0.331687,-0.293325,-0.235378,-0.184592,-0.152796,-0.133104,-0.10012:0.024721,-0.020731,-0.056655,-0.061772,-0.068809,-0.073863,-0.067354,-0.021535,0.021476,0.028401,0.032222,0.042274,0.014752,-0.001395,-0.020545:0.130327,0.148059,0.178905,0.205902,0.224446,0.230737,0.233956,0.242698,0.247533,0.223411,0.150451,0.064604,-0.009609,-0.042732,-0.084465:2
-0.034259,-0.038433,-0.025789,-0.023575,-0.008899,0.03563,0.095271,0.121658,0.124652,0.111237,0.133764,0.008567,-0.05431,-0.062549:-0.247761,-0.279378,-0.307584,-0.361099,-0.424772,-0.478692,-0.541773,-0.614571,-0.686487,-0.738156,-0.75819,-0.779521,-0.745953,-0.7325:0.19845,0.142743,0.094708,0.075825,0.041428,-2.7E-5,-0.002912,0.029915,0.056836,0.08702,0.098329,0.138319,0.181859,0.223273:-0.683767,-0.625099,-0.544793,-0.481326,-0.459393,-0.453691,-0.407704,-0.368543,-0.298381,-0.191035,-0.105406,-0.073019,-0.026761,0.018956:-0.208057,-0.164394,-0.080436,-0.0012,0.062413,0.139584,0.207405,0.286928,0.382406,0.481307,0.52819,0.576462,0.590426,0.581096:-0.516124,-0.503848,-0.466914,-0.430883,-0.4007,-0.363062,-0.362809,-0.354558,-0.338587,-0.34978,-0.379014,-0.431461,-0.482685,-0.49427:0.130134,0.129106,0.09292,0.071685,0.042034,-0.006047,-0.044484,-0.066956,-0.09189,-0.134865,-0.157914,-0.176228,-0.181737,-0.161702:0.143293,0.118755,0.07543,0.017654,-0.022079,-0.068426,-0.113278,-0.151879,-0.170983,-0.204023,-0.237322,-0.218104,-0.206023,-0.20104:-0.090442,-0.083921,-0.071444,-0.122525,-0.146099,-0.167993,-0.209697,-0.282673,-0.314921,-0.315674,-0.338472,-0.361774,-0.340277,-0.319599:-0.288231,-0.350852,-0.406823,-0.439162,-0.463357,-0.462954,-0.434993,-0.378677,-0.33126,-0.278309,-0.208433,-0.158892,-0.123526,-0.087745:0.015801,0.003179,-0.010446,0.012043,0.009259,0.008945,0.046865,0.087298,0.066718,0.045742,0.031841,0.014489,0.006008,-2.25E-4:0.150653,0.17169,0.209466,0.247801,0.269155,0.29011,0.315512,0.338322,0.3077,0.251312,0.198886,0.120155,0.05366,0.007235:2
-0.128499,-1.2E-4,-0.02195,0.089602,0.196066,0.265017,0.318649,0.417684,0.469854,0.483254,0.461097,0.414465:-0.47492,-0.528631,-0.488259,-0.608071,-0.700954,-0.736445,-0.785789,-0.805514,-0.862672,-0.917533,-0.942213,-0.978572:0.345514,0.308186,0.184855,0.215011,0.229576,0.219187,0.225054,0.191549,0.155137,0.160562,0.198487,0.265338:-0.788319,-0.755783,-0.662713,-0.681711,-0.685599,-0.636259,-0.607634,-0.561484,-0.504849,-0.484089,-0.433567,-0.345171:-0.256053,-0.185151,-0.149936,-0.069234,0.032584,0.105688,0.205726,0.302972,0.379865,0.461488,0.509862,0.55798:-0.448288,-0.419074,-0.380302,-0.340255,-0.309895,-0.296301,-0.27678,-0.271309,-0.280429,-0.297921,-0.318565,-0.317425:0.006189,-0.024627,-0.037101,-0.042328,-0.077346,-0.120271,-0.171826,-0.232398,-0.287728,-0.35356,-0.386764,-0.392037:0.26143,0.247769,0.235613,0.215178,0.183915,0.134898,0.072899,0.030992,-0.018675,-0.032889,-0.034441,-0.033205:-0.119831,-0.127261,-0.111789,-0.155464,-0.208769,-0.261633,-0.303744,-0.318343,-0.343126,-0.384228,-0.410117,-0.429566:-0.16001,-0.191878,-0.261993,-0.269314,-0.269466,-0.284954,-0.308,-0.313691,-0.264124,-0.211444,-0.178563,-0.128993:-0.00108,-0.006413,-0.003328,-0.038014,-0.067393,-0.063792,-0.065557,-0.059013,-0.027268,0.046882,0.092384,0.10783:0.164009,0.223216,0.243111,0.248301,0.245768,0.259653,0.291361,0.302444,0.271738,0.236551,0.208861,0.123573:2
0.308507,0.278817,0.25199,0.356255,0.404286,0.419176,0.388442,0.435932,0.437297,0.358281,0.286623,0.144738,0.030681,0.003872:-0.877969,-0.841188,-0.749094,-0.863011,-0.954789,-0.998484,-1.03998,-1.080302,-1.100054,-1.07499,-1.05784,-1.065321,-1.058453,-1.054271:0.375125,0.312274,0.23949,0.254456,0.257897,0.24902,0.272147,0.280884,0.279201,0.301692,0.369951,0.49082,0.544598,0.576287:-0.827867,-0.792045,-0.711084,-0.70103,-0.674914,-0.598272,-0.543701,-0.511643,-0.46226,-0.395383,-0.330907,-0.248644,-0.178337,-0.136398:-0.027238,0.018781,0.073232,0.174113,0.268091,0.352814,0.423407,0.473589,0.516531,0.549049,0.584886,0.623327,0.630406,0.622776:-0.346347,-0.326027,-0.277696,-0.224737,-0.196475,-0.177792,-0.17793,-0.190193,-0.214601,-0.252027,-0.275799,-0.260871,-0.290263,-0.323319:-0.22542,-0.228981,-0.197029,-0.243985,-0.294485,-0.312767,-0.338261,-0.377682,-0.430785,-0.457588,-0.476356,-0.465196,-0.446891,-0.428645:0.306842,0.272204,0.201757,0.150326,0.103356,0.032217,0.011975,0.011885,7.34E-4,-0.014085,9.2E-4,0.005877,-0.007308,-0.002261:-0.156603,-0.142559,-0.164272,-0.224989,-0.279403,-0.315928,-0.364966,-0.400311,-0.398567,-0.395279,-0.388965,-0.397672,-0.401979,-0.408409:-0.238069,-0.244838,-0.270576,-0.281231,-0.293569,-0.291566,-0.299935,-0.287706,-0.256054,-0.207505,-0.157032,-0.126587,-0.090885,-0.072883:-0.016032,-0.032321,-0.038245,-0.040606,-0.053868,-0.080211,-0.063835,-0.023502,0.01066,0.040745,0.068494,0.045076,0.012714,-0.00324:0.24053,0.259339,0.287269,0.276616,0.274754,0.271888,0.23603,0.190976,0.156003,0.123939,0.059218,-0.054545,-0.123235,-0.160623:2
0.23312,0.274697,0.283307,0.287855,0.289967,0.289505,0.307691,0.226874,0.100855,0.032091,-0.006324,-0.103091,-0.222336,-0.199291,-0.093075,-0.050856:-0.638038,-0.678777,-0.693147,-0.713798,-0.783143,-0.82242,-0.852371,-0.812343,-0.757142,-0.737233,-0.763027,-0.726446,-0.676937,-0.740519,-0.879007,-0.968492:0.341546,0.342927,0.344072,0.332388,0.294734,0.259034,0.242138,0.22765,0.212918,0.217487,0.249509,0.253632,0.222632,0.285035,0.375698,0.434429:-0.765106,-0.742191,-0.717348,-0.718911,-0.698016,-0.658042,-0.618134,-0.54113,-0.437294,-0.343402,-0.251497,-0.127004,-0.028832,-0.039012,-0.069317,-0.0498:0.014326,0.0591,0.089005,0.141535,0.205774,0.270088,0.352781,0.422397,0.460484,0.491308,0.523893,0.521102,0.521267,0.553599,0.597442,0.61561:-0.405575,-0.377837,-0.371094,-0.341457,-0.321346,-0.320395,-0.311691,-0.283203,-0.239423,-0.214094,-0.239089,-0.256718,-0.263002,-0.292197,-0.338826,-0.356038:-0.136665,-0.166742,-0.165732,-0.181444,-0.208533,-0.241414,-0.2843,-0.296293,-0.271071,-0.266694,-0.270117,-0.315548,-0.360308,-0.362413,-0.343391,-0.315913:0.29553,0.272183,0.246794,0.209845,0.173264,0.155381,0.13474,0.084259,0.039062,0.003766,-0.033145,-0.08395,-0.121727,-0.132967,-0.102864,-0.062122:-0.189404,-0.19971,-0.233401,-0.261006,-0.269216,-0.275966,-0.310469,-0.346409,-0.36683,-0.397871,-0.421686,-0.396513,-0.35815,-0.362668,-0.38592,-0.37965:-0.290526,-0.319647,-0.324107,-0.330207,-0.335114,-0.35184,-0.350873,-0.334839,-0.312995,-0.305872,-0.276237,-0.224683,-0.178741,-0.124071,-0.083159,-0.059367:-0.093515,-0.110118,-0.103005,-0.11139,-0.139012,-0.140752,-0.094682,-0.025511,0.019858,0.042953,0.053247,0.056919,0.019254,-6.64E-4,-0.003581,-0.009343:0.160508,0.188081,0.18876,0.189956,0.194654,0.223481,0.245141,0.250893,0.221621,0.165583,0.101845,0.039164,-3.09E-4,-0.0156,-0.028906,-0.056275:2
0.321597,0.317553,0.277474,0.239092,0.274756,0.297252,0.292695,0.272164,0.243337,0.213672,0.193311,0.189864:-0.768245,-0.855279,-0.871742,-0.893231,-0.953811,-0.993155,-1.030821,-1.084132,-1.130131,-1.158036,-1.175994,-1.178047:0.336667,0.3372,0.327644,0.332608,0.332302,0.333294,0.354945,0.36578,0.363756,0.392454,0.457879,0.51346:-0.846579,-0.845906,-0.805238,-0.751481,-0.717174,-0.655012,-0.58073,-0.52048,-0.48083,-0.403153,-0.321211,-0.270302:0.054859,0.117647,0.196881,0.260386,0.322656,0.388462,0.437564,0.46237,0.503333,0.507337,0.528771,0.553191:-0.295161,-0.28031,-0.27642,-0.270237,-0.259342,-0.252601,-0.234958,-0.22795,-0.241438,-0.2476,-0.266854,-0.280978:-0.15828,-0.196341,-0.212729,-0.228953,-0.282155,-0.340979,-0.399418,-0.424405,-0.433247,-0.435794,-0.442205,-0.44233:0.357423,0.364285,0.346149,0.296054,0.251141,0.184648,0.107489,0.056268,0.041432,0.027081,0.0227,0.010451:-0.286576,-0.302529,-0.348624,-0.411433,-0.43998,-0.463117,-0.470867,-0.486789,-0.509689,-0.475874,-0.448911,-0.453262:-0.278497,-0.304705,-0.330539,-0.350314,-0.345529,-0.304405,-0.258911,-0.226212,-0.192991,-0.163488,-0.126643,-0.085449:0.052467,0.032613,0.029169,0.038875,0.049056,0.098624,0.145151,0.175504,0.190627,0.164486,0.129948,0.114353:0.177495,0.160824,0.167358,0.179985,0.168995,0.157548,0.155491,0.159792,0.134399,0.091695,0.008191,-0.078034:2
-0.166384,-0.096584,0.021482,0.149681,0.107313,0.056773,0.121224,0.115516,0.131143,0.183213,0.256616,0.186666,0.143563,0.063955:-0.693914,-0.711299,-0.784591,-0.904787,-0.938387,-0.906165,-0.938215,-0.96633,-1.031407,-1.056094,-1.053248,-1.059223,-1.070854,-1.081502:0.379033,0.373796,0.364432,0.353273,0.346516,0.319027,0.3177,0.325108,0.33171,0.341702,0.33819,0.41684,0.478837,0.524645:-0.849392,-0.837145,-0.81144,-0.777807,-0.738948,-0.6639,-0.59905,-0.537383,-0.49824,-0.482234,-0.437308,-0.34392,-0.287425,-0.25522:-0.111795,-0.085448,-0.008589,0.102326,0.179053,0.262398,0.353542,0.416494,0.463167,0.479004,0.485448,0.50945,0.546448,0.563987:-0.337382,-0.335457,-0.33275,-0.317769,-0.287103,-0.298136,-0.306793,-0.311961,-0.318164,-0.306484,-0.31294,-0.278363,-0.287038,-0.317655:-0.08985,-0.106939,-0.141657,-0.184398,-0.224323,-0.224146,-0.261915,-0.308414,-0.340547,-0.360579,-0.351327,-0.344664,-0.35841,-0.374231:0.317058,0.311039,0.295277,0.258683,0.205085,0.168049,0.120636,0.062569,0.030136,-4.63E-4,-0.024182,-0.043114,-0.042757,-0.039603:-0.24401,-0.264124,-0.277598,-0.317319,-0.338578,-0.385909,-0.437838,-0.478176,-0.521144,-0.549611,-0.557445,-0.535276,-0.540125,-0.543508:-0.229042,-0.2251,-0.220255,-0.223953,-0.257776,-0.284908,-0.271073,-0.233523,-0.19801,-0.155732,-0.101494,-0.080996,-0.060356,-0.041424:0.089077,0.110951,0.106237,0.090522,0.051726,0.043607,0.067704,0.11353,0.152106,0.204423,0.222296,0.174195,0.139466,0.120992:0.138708,0.168363,0.194349,0.210347,0.229826,0.242824,0.229695,0.22067,0.20611,0.163786,0.118179,0.041718,-0.046249,-0.10978:2
0.022793,0.023236,0.063921,0.139243,0.310083,0.477441,0.541047,0.635386,0.636552,0.559947,0.499462,0.429659,0.348818,0.33436,0.250509:-0.470658,-0.435934,-0.477587,-0.548131,-0.663293,-0.743728,-0.790427,-0.84542,-0.914897,-0.946213,-0.986091,-1.041735,-1.036816,-0.998728,-0.982366:0.250383,0.20089,0.202541,0.216529,0.244975,0.231757,0.206565,0.182754,0.215751,0.294112,0.360681,0.427733,0.495694,0.554845,0.650457:-0.741145,-0.671027,-0.636271,-0.621947,-0.638195,-0.640778,-0.603179,-0.569751,-0.499728,-0.419489,-0.342724,-0.25748,-0.194677,-0.137239,-0.023001:-0.069657,-0.019103,0.054715,0.150345,0.252654,0.300384,0.349782,0.425931,0.496495,0.581471,0.634325,0.639283,0.648547,0.604948,0.569475:-0.377747,-0.366957,-0.352187,-0.329289,-0.305841,-0.266684,-0.256551,-0.273721,-0.252383,-0.22116,-0.207775,-0.22751,-0.269284,-0.30042,-0.327177:-0.036504,-0.051194,-0.065495,-0.116618,-0.165371,-0.194153,-0.23103,-0.283929,-0.361776,-0.410183,-0.399425,-0.404644,-0.422888,-0.373781,-0.311688:0.232172,0.202145,0.183186,0.162429,0.154072,0.131841,0.094685,0.08983,0.05177,0.032532,0.022558,0.011441,0.021517,0.023757,0.041654:-0.11065,-0.134645,-0.188651,-0.233475,-0.300477,-0.347593,-0.375568,-0.407179,-0.412541,-0.422465,-0.447706,-0.438981,-0.417859,-0.409419,-0.372482:-0.241393,-0.290998,-0.349578,-0.378425,-0.38448,-0.382727,-0.363908,-0.343165,-0.277848,-0.219096,-0.183003,-0.148843,-0.116519,-0.069098,-0.012404:-0.103097,-0.122689,-0.117027,-0.126447,-0.11766,-0.099128,-0.080411,-0.050756,-0.002091,0.036651,0.034587,0.013778,-0.005744,-0.020038,-0.051101:0.171522,0.19723,0.21711,0.242834,0.258337,0.22892,0.22031,0.222738,0.179264,0.098247,0.006461,-0.067407,-0.126435,-0.176092,-0.21914:2
0.428103,0.420462,0.45441,0.49465,0.494595,0.525684,0.558421,0.563235,0.531736,0.512339,0.553748,0.496532,0.440738,0.332176:-0.700495,-0.765121,-0.83842,-0.864715,-0.890348,-0.956392,-1.017857,-1.059385,-1.052739,-1.047181,-1.085156,-1.07224,-1.028411,-0.998443:0.426403,0.419376,0.369949,0.320224,0.293451,0.274349,0.246187,0.263525,0.303719,0.31776,0.348382,0.389634,0.479921,0.551443:-0.90474,-0.871632,-0.861648,-0.80144,-0.736231,-0.70055,-0.662507,-0.579451,-0.506112,-0.439932,-0.376565,-0.323164,-0.270478,-0.203004:-0.123021,-0.04409,0.044261,0.138429,0.211156,0.291215,0.3902,0.473874,0.539511,0.577195,0.590333,0.615115,0.612852,0.626661:-0.376909,-0.346964,-0.305335,-0.267291,-0.232768,-0.207795,-0.193293,-0.174676,-0.159767,-0.185306,-0.225093,-0.265448,-0.268141,-0.273612:-0.128314,-0.16733,-0.184892,-0.229695,-0.274966,-0.317254,-0.359712,-0.413972,-0.450576,-0.469204,-0.505381,-0.517365,-0.506602,-0.479152:0.404427,0.372475,0.346522,0.283416,0.224259,0.191985,0.148281,0.096197,0.040238,0.006662,-1.28E-4,0.005382,0.017166,0.038404:-0.21155,-0.253316,-0.292386,-0.288362,-0.300307,-0.336675,-0.370035,-0.380824,-0.399572,-0.407339,-0.395305,-0.410366,-0.399131,-0.383451:-0.203319,-0.234604,-0.270461,-0.298556,-0.315645,-0.329907,-0.312636,-0.286335,-0.267236,-0.24611,-0.211461,-0.154121,-0.119033,-0.094118:0.084126,0.105802,0.081822,0.034174,0.018958,0.011077,0.015651,0.035864,0.039392,0.033078,0.041308,0.060664,0.079172,0.059736:0.1178,0.158232,0.170246,0.198511,0.217572,0.216333,0.207528,0.180754,0.151453,0.125538,0.07543,0.004533,-0.05591,-0.128694:2
-0.270143,-0.229814,-0.057057,0.073645,0.280538,0.509739,0.489005,0.38355,0.414409,0.477241,0.529181,0.41867,0.35412:-0.576956,-0.618452,-0.688325,-0.71964,-0.785392,-0.818389,-0.945761,-0.9997,-1.025672,-1.025142,-1.02364,-0.972721,-0.950547:0.38032,0.307758,0.267355,0.208908,0.211258,0.119612,0.172652,0.236439,0.329792,0.360272,0.388703,0.490611,0.58812:-0.779134,-0.742717,-0.726166,-0.674847,-0.630758,-0.502057,-0.448987,-0.37142,-0.268235,-0.149297,-0.086627,-0.042799,-0.058983:-0.235364,-0.143598,-0.048409,0.032205,0.130064,0.241397,0.376664,0.505282,0.55456,0.530427,0.495495,0.518364,0.546597:-0.374481,-0.34496,-0.327117,-0.291036,-0.244239,-0.230233,-0.229406,-0.240569,-0.278096,-0.308382,-0.347753,-0.328292,-0.313226:-0.057735,-0.09817,-0.132545,-0.17435,-0.230152,-0.264003,-0.341997,-0.403212,-0.467574,-0.447779,-0.390563,-0.348718,-0.343533:0.280862,0.234959,0.200458,0.159049,0.112216,-3.5E-5,0.001774,-0.022414,-0.038247,-0.075882,-0.091359,-0.071928,-0.052556:-0.109754,-0.117008,-0.148192,-0.166976,-0.20213,-0.223748,-0.321743,-0.346947,-0.343205,-0.348616,-0.35171,-0.338055,-0.358309:-0.246344,-0.284135,-0.294444,-0.330469,-0.330156,-0.330212,-0.265606,-0.230635,-0.1784,-0.125394,-0.051093,-0.006644,0.015074:-0.021104,-0.044853,-0.046654,-0.041369,-0.028732,0.004808,0.046035,0.047131,0.043889,0.035384,0.006557,-0.022906,-0.045069:0.191781,0.257299,0.302534,0.320659,0.299239,0.322438,0.249035,0.188615,0.097112,0.01951,-0.048844,-0.174902,-0.264137:2
0.278333,0.331678,0.256839,0.189565,0.146713,0.192872,0.267303,0.245647,0.216214,0.167165,0.130669,0.05686,0.005149,-0.052697,-0.095201:-0.611921,-0.642802,-0.666328,-0.693724,-0.747029,-0.846921,-0.929295,-0.964387,-1.008033,-1.043139,-1.030742,-0.999397,-1.013836,-0.983933,-0.926294:0.228576,0.195875,0.16953,0.16959,0.183767,0.221249,0.2432,0.254945,0.279513,0.330709,0.402652,0.449814,0.497543,0.536763,0.54356:-0.703493,-0.663742,-0.614323,-0.597328,-0.55476,-0.507187,-0.442285,-0.382086,-0.348169,-0.302566,-0.208325,-0.127948,-0.095185,-0.092144,-0.08538:0.032515,0.097705,0.1512,0.217778,0.310929,0.426761,0.515526,0.556058,0.57953,0.596286,0.622651,0.633201,0.643807,0.636609,0.611601:-0.39917,-0.369598,-0.331402,-0.296389,-0.250685,-0.224383,-0.225106,-0.238402,-0.250926,-0.27013,-0.289233,-0.300921,-0.313748,-0.325996,-0.328577:-0.132561,-0.153361,-0.154953,-0.167969,-0.205621,-0.251481,-0.311061,-0.349462,-0.36584,-0.391349,-0.382096,-0.346157,-0.329015,-0.324609,-0.309522:0.176506,0.13645,0.095877,0.061876,0.020642,8.87E-4,-0.031859,-0.073703,-0.080024,-0.057073,-0.038601,-0.049638,-0.061367,-0.074455,-0.111812:-0.073359,-0.094865,-0.153444,-0.197898,-0.23673,-0.287168,-0.329297,-0.354633,-0.394078,-0.394189,-0.361253,-0.358624,-0.396486,-0.42469,-0.422266:-0.266728,-0.283984,-0.305547,-0.318275,-0.314405,-0.312513,-0.292341,-0.256578,-0.221817,-0.198114,-0.149928,-0.107807,-0.073414,-0.038832,-0.004932:-0.196165,-0.198229,-0.16326,-0.168872,-0.176377,-0.169427,-0.119435,-0.075907,-0.033567,7.3E-4,-0.01022,-0.03935,-0.045676,-0.034427,-0.042241:0.263251,0.281091,0.289218,0.286026,0.271465,0.251641,0.249236,0.234319,0.190693,0.133834,0.043263,-0.004557,-0.063076,-0.134939,-0.169361:2
0.089629,0.081461,0.079236,0.05924,0.075567,0.079006,0.108426,0.130096,0.182321,0.195653,0.181332,0.156827,0.175676:-0.649119,-0.666005,-0.699193,-0.723691,-0.78259,-0.858494,-0.910573,-0.948194,-1.000604,-1.006103,-1.012249,-0.977038,-0.962677:0.043973,0.039389,0.045424,0.060778,0.10422,0.151788,0.216548,0.291157,0.346911,0.407132,0.449873,0.496765,0.541054:-0.622276,-0.59186,-0.538722,-0.480342,-0.425836,-0.347357,-0.276192,-0.240273,-0.21881,-0.158126,-0.121436,-0.081103,-0.093608:0.08028,0.154738,0.251792,0.317721,0.378973,0.442666,0.50353,0.519899,0.50085,0.458694,0.448089,0.455322,0.485833:-0.383465,-0.367,-0.35816,-0.359762,-0.350493,-0.356055,-0.359333,-0.354688,-0.358374,-0.386675,-0.406907,-0.388529,-0.362956:-0.036962,-0.067918,-0.124239,-0.157176,-0.187785,-0.23226,-0.269598,-0.296922,-0.311578,-0.30425,-0.30857,-0.265581,-0.251426:-0.007335,-0.037456,-0.060804,-0.084235,-0.108071,-0.123285,-0.14456,-0.15277,-0.162571,-0.189035,-0.173092,-0.154348,-0.130865:-0.112744,-0.144208,-0.178327,-0.22454,-0.287108,-0.30859,-0.341524,-0.368325,-0.373732,-0.344477,-0.325497,-0.331345,-0.352096:-0.251045,-0.235768,-0.226798,-0.229726,-0.214721,-0.188109,-0.150585,-0.128266,-0.098694,-0.044687,-0.004689,0.037099,0.05648:-0.089069,-0.068982,-0.067237,-0.051398,-0.020739,5.06E-4,0.0224,0.027834,0.018918,-0.030371,-0.044815,-0.059115,-0.083246:0.409918,0.394769,0.382603,0.372701,0.347176,0.311527,0.240426,0.180689,0.129067,0.089594,0.035301,-0.041041,-0.132033:2
0.291832,0.32914,0.352639,0.421651,0.483277,0.570541,0.677881,0.659637,0.521894,0.48245,0.464264,0.277103,0.112673,0.044238,-0.03657:-0.642238,-0.685617,-0.686158,-0.68417,-0.738669,-0.862708,-0.971917,-0.96833,-0.88237,-0.872675,-0.925438,-0.88383,-0.860093,-0.857271,-0.782193:0.399506,0.342152,0.288148,0.227791,0.233074,0.268815,0.26841,0.227024,0.148983,0.104233,0.149604,0.211952,0.269396,0.318756,0.314184:-0.641647,-0.639094,-0.642183,-0.607196,-0.590805,-0.595202,-0.555095,-0.426766,-0.300522,-0.20987,-0.170823,-0.105269,-0.044651,-0.02724,0.027853:-0.479811,-0.414073,-0.327664,-0.251858,-0.158132,-0.031927,0.103252,0.193244,0.237465,0.263267,0.306806,0.335812,0.390637,0.433018,0.427374:-0.198944,-0.204681,-0.195213,-0.184613,-0.156943,-0.148561,-0.137257,-0.141419,-0.147147,-0.15485,-0.184589,-0.198397,-0.194388,-0.227355,-0.258041:-0.129014,-0.145075,-0.171348,-0.171772,-0.183993,-0.210835,-0.264575,-0.301119,-0.317622,-0.341127,-0.363511,-0.383656,-0.344973,-0.293233,-0.263868:0.279341,0.253289,0.247879,0.246691,0.238566,0.189481,0.121775,0.037005,-0.031988,-0.075532,-0.104951,-0.118786,-0.126428,-0.162023,-0.191363:-0.130719,-0.104772,-0.092633,-0.105976,-0.140238,-0.189315,-0.242254,-0.283573,-0.330433,-0.348288,-0.338436,-0.332565,-0.347707,-0.379335,-0.386615:-0.298509,-0.299631,-0.317507,-0.332613,-0.356994,-0.350756,-0.337718,-0.324083,-0.302641,-0.276237,-0.23542,-0.164518,-0.106652,-0.077551,-0.058499:0.169799,0.141259,0.107468,0.07819,0.042913,0.007609,-0.008507,0.005506,0.05249,0.076037,0.074839,0.087163,0.081444,0.073294,0.071814:0.125984,0.158117,0.188951,0.206092,0.208691,0.195882,0.19774,0.217325,0.201323,0.172341,0.144822,0.069768,-0.023101,-0.08519,-0.13412:2
0.112933,0.104743,0.102969,0.125982,0.18161,0.277667,0.327299,0.36978,0.429319,0.456193,0.446421,0.385167,0.293875,0.324123,0.170979,0.125002,0.088262:-0.576973,-0.633553,-0.670548,-0.716557,-0.772491,-0.800084,-0.850938,-0.906224,-0.961157,-0.955999,-0.97074,-0.964287,-0.91396,-0.889914,-0.85502,-0.888217,-0.910129:0.434879,0.427702,0.387034,0.35205,0.329925,0.315886,0.309164,0.27768,0.27055,0.306852,0.346563,0.357311,0.344571,0.357219,0.405139,0.46473,0.509355:-0.917487,-0.873008,-0.806687,-0.783097,-0.763667,-0.726629,-0.677891,-0.641928,-0.587991,-0.5196,-0.453609,-0.381973,-0.293276,-0.230639,-0.104643,-0.063833,-0.042848:-0.272764,-0.221169,-0.15969,-0.082488,-0.009997,0.040099,0.105428,0.201298,0.299461,0.398329,0.463186,0.478448,0.511555,0.536629,0.568716,0.626269,0.654203:-0.357251,-0.313377,-0.294984,-0.269468,-0.262139,-0.264102,-0.261897,-0.241992,-0.22431,-0.197061,-0.181979,-0.196134,-0.239387,-0.271416,-0.253196,-0.262128,-0.281529:-0.011109,-0.04792,-0.073467,-0.114312,-0.157438,-0.178015,-0.198671,-0.218957,-0.269899,-0.293317,-0.321465,-0.336055,-0.340271,-0.354412,-0.336237,-0.32625,-0.325073:0.272384,0.254601,0.217996,0.179921,0.18308,0.175247,0.132606,0.078162,0.060077,0.027225,-0.013301,-0.048239,-0.064132,-0.0668,-0.079486,-0.08156,-0.080196:-0.081544,-0.10069,-0.108097,-0.135974,-0.16831,-0.190338,-0.226234,-0.277628,-0.317669,-0.388303,-0.442087,-0.459836,-0.456546,-0.428494,-0.394527,-0.4122,-0.426042:-0.090044,-0.147255,-0.197509,-0.235124,-0.281095,-0.310714,-0.306453,-0.29194,-0.293787,-0.289591,-0.278886,-0.25895,-0.213831,-0.144331,-0.088723,-0.063128,-0.033832:0.005403,-0.020669,-0.065963,-0.094728,-0.108662,-0.106541,-0.096265,-0.077343,-0.038969,0.013768,0.041064,0.051889,0.059129,0.086176,0.081246,0.039529,0.009842:0.120904,0.149553,0.189216,0.215632,0.238003,0.28145,0.282169,0.277496,0.285586,0.268669,0.221337,0.182122,0.115296,0.048472,-0.040019,-0.103019,-0.148376:2
0.233229,0.23034,0.334678,0.393846,0.489386,0.484127,0.431716,0.370683,0.356193,0.270427,0.111568,0.035421,-0.023519,-0.011035,-0.028197,0.043182:-0.792475,-0.822865,-0.897102,-0.904536,-0.908473,-0.949256,-0.957757,-0.953254,-0.95744,-0.901177,-0.771756,-0.67992,-0.619273,-0.661468,-0.694694,-0.776313:0.34075,0.31974,0.332614,0.275838,0.249563,0.262267,0.273339,0.311549,0.371228,0.443878,0.4375,0.405618,0.397778,0.465122,0.490614,0.54617:-0.699821,-0.693623,-0.671591,-0.61799,-0.57774,-0.538021,-0.464761,-0.383833,-0.308765,-0.228727,-0.118215,-0.031971,-0.001489,-0.020882,-0.007948,-0.011083:-0.064863,0.0021,0.070251,0.201612,0.286269,0.338302,0.414626,0.488107,0.570707,0.553021,0.514311,0.48314,0.464287,0.46254,0.436976,0.429819:-0.337204,-0.288141,-0.284561,-0.253607,-0.2464,-0.249397,-0.245776,-0.241936,-0.258939,-0.290902,-0.315619,-0.332653,-0.342165,-0.334946,-0.323816,-0.328545:-0.151966,-0.178111,-0.211407,-0.233709,-0.235706,-0.249765,-0.272372,-0.267282,-0.289874,-0.280056,-0.242139,-0.220705,-0.224462,-0.228714,-0.208991,-0.187716:0.232452,0.192755,0.180006,0.109528,0.074426,0.051717,-0.00654,-0.027761,-0.023944,-0.073749,-0.146866,-0.18265,-0.189026,-0.180162,-0.182498,-0.180857:-0.150849,-0.156178,-0.17955,-0.238017,-0.296305,-0.333786,-0.371087,-0.406739,-0.432896,-0.453502,-0.459438,-0.457242,-0.455635,-0.452929,-0.427856,-0.406873:-0.286569,-0.305558,-0.3029,-0.317861,-0.35775,-0.356144,-0.317775,-0.291194,-0.245566,-0.177883,-0.13559,-0.101873,-0.077677,-0.048077,-0.008738,0.025119:-0.135482,-0.186827,-0.199671,-0.176287,-0.159585,-0.135576,-0.079773,-0.044429,-0.020548,0.016465,0.038236,0.043459,0.064524,0.073964,0.081327,0.03756:0.200547,0.224209,0.229237,0.295615,0.341187,0.330304,0.320634,0.278231,0.171264,0.099591,0.064953,0.02014,-0.025352,-0.055843,-0.089774,-0.116504:2
0.346519,0.29457,0.2994,0.336238,0.294325,0.267938,0.247142,0.193463,0.091526,0.066465,0.061174,0.039121,0.147115,0.134501,0.062466,0.087033,5.08E-4:-0.63851,-0.689687,-0.731168,-0.768221,-0.809882,-0.841188,-0.863824,-0.867915,-0.766927,-0.760437,-0.769284,-0.773336,-0.916903,-0.969533,-0.927924,-0.973002,-0.927712:0.262799,0.238237,0.209545,0.192078,0.203188,0.221537,0.253459,0.28086,0.224844,0.214875,0.237636,0.282282,0.396613,0.45649,0.43529,0.464735,0.437052:-0.754287,-0.735694,-0.720724,-0.6895,-0.628551,-0.553905,-0.472124,-0.395739,-0.300544,-0.239849,-0.151092,-0.088199,-0.128482,-0.088962,-0.022873,-0.02102,0.031437:0.031907,0.110232,0.192371,0.283182,0.340103,0.405367,0.472861,0.502482,0.500499,0.494427,0.492473,0.542954,0.613363,0.619933,0.579683,0.564538,0.544961:-0.38427,-0.361836,-0.323865,-0.297278,-0.286137,-0.266584,-0.249601,-0.233139,-0.23319,-0.23784,-0.233891,-0.220566,-0.244674,-0.256566,-0.270862,-0.27394,-0.297747:-0.12297,-0.148138,-0.166305,-0.180912,-0.184786,-0.200472,-0.233723,-0.297622,-0.324924,-0.339004,-0.352489,-0.371443,-0.414714,-0.412076,-0.406785,-0.411562,-0.393144:0.197268,0.179523,0.149187,0.12258,0.105482,0.071379,0.010444,-0.044963,-0.091164,-0.103766,-0.098161,-0.08723,-0.036691,-0.027087,-0.061773,-0.077766,-0.103802:-0.094754,-0.133021,-0.188094,-0.259059,-0.314484,-0.362476,-0.403351,-0.410643,-0.383144,-0.375968,-0.352166,-0.3032,-0.323028,-0.356923,-0.35698,-0.362145,-0.357397:-0.244432,-0.280232,-0.306161,-0.342618,-0.371563,-0.369765,-0.32539,-0.29742,-0.28907,-0.267138,-0.231527,-0.198671,-0.178526,-0.182808,-0.169821,-0.146371,-0.116126:-0.156522,-0.166155,-0.160675,-0.135643,-0.115095,-0.084103,-0.038359,-0.00852,0.013452,0.034618,0.058552,0.044519,0.016502,0.006225,0.008807,0.012191,-0.003418:0.25418,0.284392,0.294758,0.315883,0.308533,0.275649,0.235798,0.20786,0.187934,0.157443,0.096835,0.032063,-0.00607,-0.033745,-0.070783,-0.087934,-0.100756:2
0.192224,0.130152,0.110738,0.07521,0.082307,0.113391,0.082044,0.016698,-0.021985,-0.053901,-0.102262,-0.147569,-0.183312,-0.192962:-0.667203,-0.738962,-0.802652,-0.814422,-0.858261,-0.939842,-0.982229,-0.995274,-1.00321,-1.018351,-1.011206,-0.983498,-0.97092,-0.952884:0.215836,0.242157,0.255697,0.252827,0.296106,0.349179,0.387364,0.412471,0.427724,0.489642,0.561569,0.605193,0.632592,0.66498:-0.613009,-0.589277,-0.565733,-0.502875,-0.432017,-0.381147,-0.320108,-0.268795,-0.220725,-0.155873,-0.078474,-0.035504,-0.030957,-0.042185:-0.002985,0.129185,0.247941,0.350324,0.436453,0.5217,0.57967,0.614671,0.659615,0.693681,0.71619,0.73247,0.734254,0.710473:-0.363196,-0.30169,-0.280192,-0.259873,-0.247361,-0.242268,-0.271213,-0.304857,-0.334871,-0.335499,-0.346475,-0.371402,-0.379479,-0.390487:-0.033778,-0.087886,-0.152999,-0.183838,-0.214341,-0.283915,-0.337362,-0.367864,-0.362494,-0.334304,-0.301412,-0.288229,-0.287028,-0.284226:0.121938,0.073384,0.048378,0.006231,-0.006299,-0.030212,-0.055342,-0.066255,-0.049521,-0.00747,0.005425,0.00459,-0.004002,-0.007616:-0.136049,-0.212731,-0.266222,-0.3215,-0.365378,-0.426764,-0.461862,-0.462659,-0.45986,-0.434392,-0.428356,-0.44491,-0.455338,-0.451613:-0.318841,-0.337139,-0.335429,-0.317375,-0.277132,-0.233984,-0.186071,-0.136477,-0.089351,-0.04329,-0.006322,0.032523,0.064034,0.083289:-0.103648,-0.103177,-0.107691,-0.057852,-0.005552,0.037783,0.072185,0.074717,0.057479,0.042644,0.012793,-0.019331,-0.048191,-0.072174:0.322133,0.330277,0.33562,0.323839,0.263146,0.182708,0.113577,0.061335,-0.001515,-0.094013,-0.170409,-0.240534,-0.292374,-0.325031:2
0.127829,0.288105,0.813501,0.923862,0.795307,0.779221,0.787814,0.667821,0.597809,0.419144,0.196952,0.042361:-0.830983,-0.638032,-0.703046,-0.828119,-0.801497,-0.851132,-0.967964,-1.029644,-1.076918,-1.05521,-1.031141,-1.049752:0.330256,0.197292,-0.059509,0.014515,0.080565,0.159283,0.304177,0.326426,0.354765,0.417943,0.482958,0.532426:-0.760286,-0.669381,-0.435452,-0.459344,-0.473085,-0.414735,-0.451013,-0.402667,-0.325892,-0.239394,-0.154652,-0.133956:-0.016945,0.040474,0.042471,0.122062,0.27107,0.377365,0.452362,0.493886,0.535755,0.587583,0.63229,0.658503:-0.205883,-0.22076,-0.213883,-0.170585,-0.197878,-0.185283,-0.15647,-0.177333,-0.213686,-0.243998,-0.300617,-0.320683:-0.250666,-0.220322,-0.162137,-0.255137,-0.301001,-0.360635,-0.43336,-0.424114,-0.406216,-0.356947,-0.321211,-0.305477:0.237574,0.166187,0.003607,0.025396,0.004709,-0.041383,-0.034448,-0.050933,-0.042878,-0.012564,-0.019982,-0.03855:-0.157167,-0.153832,-0.135795,-0.190462,-0.249055,-0.298001,-0.374676,-0.415088,-0.428345,-0.443703,-0.464153,-0.501207:-0.355975,-0.364828,-0.410143,-0.417031,-0.329939,-0.272549,-0.223871,-0.194446,-0.167017,-0.116509,-0.056816,-0.010508:-0.027558,-0.048198,-0.063945,-0.047291,-0.029335,0.029141,0.073605,0.073116,0.063139,0.062896,0.031055,0.010193:0.229664,0.264437,0.302873,0.292437,0.277588,0.233652,0.167413,0.127427,0.084363,-0.026469,-0.126474,-0.194154:2
0.267999,0.250295,0.24897,0.185291,0.170638,0.147636,0.122921,0.127854,0.015041,-0.075023,-0.11376,-0.136588,-0.155103:-0.43807,-0.503691,-0.580321,-0.723166,-0.797092,-0.83433,-0.89261,-0.969634,-1.005537,-0.999137,-0.985113,-0.986082,-0.987705:0.12304,0.12626,0.125208,0.185436,0.212113,0.269219,0.32039,0.325965,0.372413,0.430961,0.488635,0.533023,0.552141:-0.596942,-0.563908,-0.558728,-0.578374,-0.529269,-0.470258,-0.410508,-0.364173,-0.283223,-0.19108,-0.13162,-0.099433,-0.080087:0.056767,0.136869,0.233316,0.362203,0.466177,0.527852,0.580525,0.613623,0.655724,0.739438,0.753298,0.735717,0.730848:-0.371142,-0.346615,-0.32215,-0.27231,-0.248092,-0.256052,-0.301272,-0.339002,-0.360547,-0.381292,-0.405871,-0.410767,-0.426233:-0.038803,-0.057814,-0.092638,-0.170878,-0.190443,-0.222054,-0.278706,-0.286159,-0.279563,-0.277387,-0.305554,-0.312067,-0.310105:0.139372,0.095138,0.080622,0.077138,0.019444,-0.027603,-0.01526,0.006945,0.011896,0.03531,0.027196,0.011526,-2.71E-4:-0.118989,-0.194084,-0.254064,-0.297019,-0.372742,-0.465866,-0.519277,-0.543774,-0.541983,-0.529757,-0.524748,-0.524146,-0.526435:-0.395189,-0.416109,-0.422998,-0.381334,-0.32416,-0.249686,-0.225437,-0.193692,-0.121372,-0.062109,-0.026332,-0.009255,0.012307:-0.135496,-0.129513,-0.143995,-0.161068,-0.123119,-0.023079,0.046768,0.055338,0.03537,0.004753,3.67E-4,-0.00122,-0.009506:0.288155,0.318519,0.300971,0.258722,0.197596,0.150401,0.144113,0.095597,9.86E-4,-0.09054,-0.147744,-0.177658,-0.210682:2
0.118772,0.261419,0.262124,0.322642,0.368852,0.456398,0.530882,0.437399,0.351477,0.283057,0.210169,0.10892,0.016512,-0.061712:-0.751338,-0.83765,-0.82298,-0.887603,-0.937445,-0.947114,-1.016568,-1.025179,-1.078278,-1.139614,-1.115865,-1.123305,-1.138299,-1.085341:0.496478,0.503784,0.469132,0.456735,0.441791,0.405129,0.408613,0.413525,0.422624,0.455456,0.506856,0.547887,0.590148,0.646416:-0.850396,-0.840002,-0.79138,-0.762066,-0.742697,-0.694298,-0.630842,-0.553478,-0.479503,-0.390645,-0.286493,-0.179128,-0.13655,-0.117156:-0.163303,-0.09779,-0.029348,0.04609,0.115086,0.205759,0.295368,0.379747,0.452706,0.522824,0.581851,0.620888,0.634981,0.619257:-0.353831,-0.310731,-0.306626,-0.276718,-0.25408,-0.237809,-0.206439,-0.21119,-0.222499,-0.227741,-0.235774,-0.260578,-0.296409,-0.339458:-0.068735,-0.104522,-0.123011,-0.160895,-0.196394,-0.235951,-0.309244,-0.356952,-0.410854,-0.437807,-0.431356,-0.401875,-0.399741,-0.388392:0.26966,0.284972,0.262313,0.237064,0.227565,0.203731,0.171914,0.112824,0.069653,0.056241,0.037651,0.00767,0.006325,0.011524:-0.252959,-0.294244,-0.317717,-0.376505,-0.412962,-0.424765,-0.439576,-0.462743,-0.455877,-0.435886,-0.432667,-0.454098,-0.464911,-0.464524:-0.195513,-0.259628,-0.307394,-0.333817,-0.343281,-0.339624,-0.333085,-0.296907,-0.246099,-0.2063,-0.163038,-0.109124,-0.067606,-0.024863:0.027841,0.012896,-0.010341,0.019166,0.049763,0.061584,0.091473,0.117723,0.122543,0.099906,0.074537,0.038684,0.011508,-0.00641:0.157728,0.157469,0.17856,0.199862,0.200932,0.187477,0.15835,0.148052,0.111357,0.051846,-0.027528,-0.105537,-0.176032,-0.234747:2
0.27046,0.344722,0.478448,0.510053,0.5442,0.608566,0.668311,0.750979,0.737107,0.78081,0.805838,0.770168,0.604282,0.495739,0.421333,0.36774:-0.462038,-0.506089,-0.610884,-0.621928,-0.662756,-0.743052,-0.767637,-0.835254,-0.811561,-0.853659,-0.901414,-0.92402,-0.917493,-0.913289,-0.883872,-0.886132:0.243496,0.268304,0.280331,0.237784,0.229743,0.259398,0.263613,0.255607,0.22059,0.262394,0.340006,0.392096,0.466998,0.539982,0.550479,0.546911:-0.670295,-0.649026,-0.664228,-0.664153,-0.645285,-0.608015,-0.561725,-0.52858,-0.459962,-0.432384,-0.392216,-0.340781,-0.270676,-0.25304,-0.21659,-0.196018:-0.076578,-0.004991,0.06457,0.126229,0.21256,0.285453,0.347652,0.439298,0.49164,0.52061,0.536991,0.559465,0.561268,0.556016,0.564381,0.577749:-0.395247,-0.370625,-0.309401,-0.262177,-0.209919,-0.160395,-0.106312,-0.117171,-0.157721,-0.172557,-0.178907,-0.15561,-0.18807,-0.214823,-0.258955,-0.297562:-0.081721,-0.143502,-0.180782,-0.185032,-0.224258,-0.278192,-0.323984,-0.393922,-0.413452,-0.446821,-0.476931,-0.45424,-0.406995,-0.382984,-0.368175,-0.360916:0.225695,0.205454,0.188397,0.140971,0.093527,0.067245,0.01816,0.004178,-0.031918,-0.035395,-0.018724,-0.01983,-0.021279,-0.021912,-0.032602,-0.030516:-0.11476,-0.133486,-0.180224,-0.227893,-0.257831,-0.290792,-0.327717,-0.345554,-0.363453,-0.390854,-0.393851,-0.393292,-0.427947,-0.463948,-0.466383,-0.4631:-0.322634,-0.332708,-0.352806,-0.354269,-0.353605,-0.353199,-0.326816,-0.317228,-0.279553,-0.233331,-0.200157,-0.166142,-0.133941,-0.101771,-0.073189,-0.057204:-0.085393,-0.092153,-0.124224,-0.126313,-0.137068,-0.11722,-0.084716,-0.045112,0.002169,0.04194,0.069861,0.064983,0.060705,0.063027,0.035293,0.009936:0.189085,0.22589,0.224213,0.208384,0.215546,0.217136,0.157077,0.131686,0.118519,0.087697,0.049061,-0.007196,-0.071885,-0.128743,-0.160823,-0.173164:2
0.271724,0.219021,0.252684,0.2695,0.347877,0.335908,0.289547,0.250036,0.24273,0.242714,0.230709,0.243444,0.312431,0.206448,0.124116,0.035397,-0.064047,-0.119184,-0.182932:-0.221893,-0.271235,-0.327589,-0.375965,-0.462135,-0.479741,-0.463183,-0.471506,-0.516904,-0.533033,-0.5641,-0.588032,-0.645422,-0.614072,-0.58225,-0.570347,-0.56538,-0.591884,-0.591436:0.064484,0.05624,0.066691,0.080349,0.094372,0.068412,0.06399,0.07812,0.143728,0.221496,0.278177,0.313272,0.396696,0.433971,0.460937,0.520639,0.586221,0.592314,0.604936:-0.676904,-0.651954,-0.606676,-0.546363,-0.49505,-0.405802,-0.321164,-0.250892,-0.222268,-0.147168,-0.065408,-8.8E-4,0.080138,0.129245,0.146894,0.161334,0.192878,0.197662,0.198668:-0.174411,-0.140621,-0.077795,-0.045612,-0.029023,-0.008663,0.03461,0.09995,0.157586,0.205312,0.246157,0.260331,0.26399,0.314236,0.357719,0.383754,0.394834,0.411173,0.443782:-0.533266,-0.492729,-0.441011,-0.389551,-0.332753,-0.321973,-0.34836,-0.355573,-0.298129,-0.258623,-0.220732,-0.192461,-0.206763,-0.212056,-0.243055,-0.280987,-0.297915,-0.313801,-0.334918:0.240623,0.230312,0.205537,0.190449,0.180658,0.165687,0.159113,0.143563,0.101297,0.063108,0.033219,0.020835,0.036371,0.039068,0.028318,0.004147,-0.021821,-0.021664,-0.019186:0.073875,0.06102,0.019872,-0.03605,-0.107829,-0.185892,-0.242734,-0.290099,-0.340231,-0.3772,-0.398883,-0.427384,-0.41513,-0.407436,-0.395394,-0.372238,-0.347476,-0.319219,-0.296996:-0.204006,-0.219091,-0.2652,-0.31059,-0.345587,-0.331811,-0.347782,-0.379292,-0.389392,-0.383936,-0.361402,-0.32661,-0.318364,-0.295876,-0.275426,-0.259484,-0.247642,-0.238125,-0.223278:-0.082263,-0.120449,-0.162482,-0.190288,-0.207593,-0.187216,-0.133968,-0.071075,-0.022036,-0.012825,-0.014866,-0.006984,0.012885,0.048087,0.070124,0.082867,0.102132,0.098673,0.098023:-0.032233,-0.001714,0.012282,0.020895,0.035056,0.053632,0.066582,0.076613,0.071714,0.068143,0.043651,0.032005,0.003761,-0.03186,-0.073068,-0.118627,-0.147315,-0.168029,-0.193908:0.124454,0.149598,0.176636,0.195883,0.201579,0.202233,0.229753,0.224188,0.147534,0.074735,-0.016397,-0.064748,-0.065365,-0.122683,-0.156014,-0.194218,-0.244875,-0.260174,-0.256149:3
1.155802,1.118158,1.12791,1.302057,1.193935,1.085469,1.097119,1.10575,1.009946,0.998034,1.153454,1.170545,1.012392,0.855927,0.756374,0.642591,0.521025:-0.090588,-0.10394,-0.12885,-0.206345,-0.249372,-0.27862,-0.374844,-0.426319,-0.352165,-0.373944,-0.445501,-0.358138,-0.403358,-0.399218,-0.388493,-0.394173,-0.357791:0.079864,0.040637,-0.046986,-0.218223,-0.099185,-0.066689,-0.08657,-0.121101,-0.113547,-0.047093,-0.10412,-0.12807,0.01225,0.109291,0.169127,0.232906,0.293059:-0.790386,-0.745114,-0.7016,-0.491783,-0.559907,-0.564914,-0.454258,-0.384461,-0.380159,-0.298486,-0.006464,0.102413,0.186626,0.236866,0.260132,0.270343,0.233402:-0.107499,-0.08442,-0.028056,-0.023121,0.004413,0.070379,0.099178,0.106899,0.12455,0.161302,0.165021,0.208447,0.304755,0.352871,0.370312,0.365,0.393305:-0.652507,-0.63037,-0.618321,-0.624271,-0.541123,-0.489993,-0.435739,-0.355846,-0.313936,-0.302403,-0.327612,-0.305005,-0.318068,-0.329775,-0.341635,-0.333341,-0.334494:0.052065,0.089332,0.106165,0.145937,0.111033,0.089516,0.08953,0.053547,0.031848,0.053735,0.16837,0.204905,0.186465,0.139201,0.100429,0.07636,0.054795:0.319471,0.292186,0.260325,0.156347,0.12973,0.115312,0.035237,-0.03655,-0.101791,-0.187922,-0.328908,-0.394359,-0.395714,-0.395987,-0.405241,-0.410435,-0.401632:-0.234667,-0.247188,-0.239363,-0.207477,-0.231444,-0.290845,-0.31465,-0.351531,-0.373855,-0.40699,-0.397777,-0.400536,-0.407518,-0.387505,-0.355067,-0.33397,-0.324653:-0.069178,-0.108245,-0.14436,-0.17884,-0.237924,-0.254939,-0.266969,-0.270263,-0.258325,-0.192162,-0.149245,-0.125018,-0.066323,-0.023042,-0.004532,8.38E-4,0.024258:-0.067643,-0.097541,-0.15737,-0.203477,-0.151639,-0.122459,-0.119733,-0.064241,0.015051,0.048513,0.040297,0.042814,-0.009007,-0.030848,-0.040143,-0.037332,-0.045706:0.035266,0.061322,0.10211,0.186095,0.207632,0.225753,0.27349,0.25415,0.235728,0.2234,0.199368,0.115054,0.074709,0.012324,-0.041738,-0.084872,-0.113055:3
0.548909,0.6629,0.748848,0.720141,0.835711,0.839441,0.749378,0.646771,0.562712,0.455283,0.357557,0.235292,0.1326,0.029741,-0.055906:-0.334113,-0.369197,-0.389125,-0.240107,-0.324405,-0.342116,-0.33749,-0.335123,-0.372494,-0.344217,-0.241427,-0.191549,-0.171614,-0.14474,-0.125931:0.051513,0.042098,0.044788,-0.00456,9.77E-4,-0.019468,0.005933,0.015591,0.082903,0.148228,0.179857,0.193633,0.247628,0.284541,0.29846:-0.649942,-0.627482,-0.534763,-0.437415,-0.333139,-0.256988,-0.220266,-0.12342,-0.058297,-0.040856,-0.074149,-0.043807,-0.023157,-0.007839,0.009788:0.040899,0.034893,0.052336,0.113346,0.055995,0.050938,0.150553,0.186079,0.183921,0.265477,0.390816,0.440591,0.482356,0.539634,0.616959:-0.444153,-0.425525,-0.399815,-0.428879,-0.315749,-0.280727,-0.301231,-0.287267,-0.302813,-0.327612,-0.32841,-0.357276,-0.354513,-0.353668,-0.386945:0.065766,0.04798,0.058983,0.089966,0.038075,0.048611,0.052297,0.06776,0.083961,0.034487,-0.033429,-0.041473,-0.08742,-0.122676,-0.132006:0.147683,0.132501,0.092362,0.04887,-0.035234,-0.161503,-0.244901,-0.315512,-0.346028,-0.334941,-0.331034,-0.333599,-0.331412,-0.320031,-0.291942:-0.248014,-0.274351,-0.323262,-0.355973,-0.315841,-0.266285,-0.280657,-0.325608,-0.372851,-0.386365,-0.37981,-0.383569,-0.348618,-0.316859,-0.299691:-0.226063,-0.256207,-0.306468,-0.315378,-0.34761,-0.375081,-0.341295,-0.256609,-0.179055,-0.144216,-0.104855,-0.05501,-0.036932,-0.025066,-0.006699:-0.018767,0.003493,-0.005868,0.008125,0.048718,0.074134,0.074114,0.057902,0.076572,0.101973,0.091479,0.065823,0.048088,0.027604,0.00434:0.14606,0.184514,0.224218,0.232503,0.230233,0.259132,0.28423,0.252767,0.193444,0.133665,0.061051,-0.019412,-0.079069,-0.117893,-0.134983:3
1.144792,0.913235,0.841715,0.77036,0.737591,0.71267,0.679668,0.729003,0.679321,0.574787,0.508732,0.478275,0.386972,0.330204:-0.0683,-0.238747,-0.279938,0.033115,0.029004,-0.039344,-0.150883,-0.295048,-0.226573,-0.174175,-0.150406,-0.131085,-0.079611,-0.068683:-0.207295,-0.023086,0.064002,-0.165708,-0.22739,-0.210885,-0.171436,-0.206035,-0.180067,-0.052545,0.090997,0.072768,0.075823,0.09564:-0.497998,-0.499494,-0.51954,-0.540547,-0.508501,-0.444341,-0.351833,-0.160404,-0.148791,-0.144364,-0.132552,-0.057985,0.039493,0.090494:-0.189399,-0.13389,-0.086862,0.081716,0.146889,0.164229,0.164646,0.164008,0.247496,0.331461,0.368712,0.442065,0.478438,0.502994:-0.491552,-0.388744,-0.352095,-0.389425,-0.438162,-0.430478,-0.391359,-0.376255,-0.362191,-0.326729,-0.295417,-0.359341,-0.375337,-0.382338:0.085427,0.112331,0.074236,0.028167,0.052159,0.07744,0.115802,0.110054,0.064355,0.015123,-0.039936,-0.012087,0.024622,0.028887:0.092188,0.084074,0.083693,0.063551,0.011073,-0.065044,-0.139767,-0.197671,-0.220854,-0.267661,-0.320846,-0.342484,-0.36341,-0.355166:0.044091,-0.130014,-0.193746,-0.05478,-0.134166,-0.210361,-0.29491,-0.32337,-0.327703,-0.323532,-0.282725,-0.321004,-0.313147,-0.286383:-0.358663,-0.24788,-0.198044,-0.298389,-0.272413,-0.252587,-0.229779,-0.233598,-0.26932,-0.246847,-0.168218,-0.065467,-0.046875,-0.045514:-0.033564,-0.10234,-0.136288,-0.059284,-0.053718,-0.036069,-0.007904,0.014447,0.059319,0.072099,0.06352,0.042588,0.028814,0.002495:0.187799,0.170001,0.169248,0.142151,0.171438,0.212712,0.222551,0.221784,0.200952,0.146614,0.061686,0.012064,-0.034934,-0.085706:3
0.303677,0.564058,0.581931,0.617749,0.854972,0.854833,0.506685,0.395954,0.365166,0.164377,0.167613,0.439545,0.377055:0.344401,0.266057,0.268178,0.128821,-0.225581,-0.463489,-0.426003,-0.459168,-0.551046,-0.533653,-0.54601,-0.588765,-0.51635:-0.057191,-0.212469,-0.300981,-0.347492,-0.309518,-0.122715,-0.109249,-0.10078,-0.061476,-0.040167,-0.028612,-0.060429,-0.003438:-0.747382,-0.722911,-0.760683,-0.673068,-0.482672,-0.489387,-0.50077,-0.469523,-0.352779,-0.196185,-0.074422,0.264695,0.338376:-2.22E-4,0.070524,0.094405,0.142226,0.03029,0.062225,0.169527,0.230472,0.284766,0.283803,0.317253,0.284906,0.309719:-0.678334,-0.676922,-0.595927,-0.565154,-0.47691,-0.401549,-0.365287,-0.355409,-0.335057,-0.321719,-0.310331,-0.232214,-0.254541:-0.002814,-0.002838,0.037201,-0.011392,6.87E-4,-0.022905,-0.043286,-0.036131,-0.059435,-0.043925,-0.051623,0.071014,0.015275:0.175393,0.179998,0.127092,0.11808,0.018272,0.07724,0.03351,-0.018832,-0.083643,-0.200527,-0.263412,-0.336412,-0.355951:0.023568,0.076482,0.01263,0.017595,0.051829,-0.165303,-0.224419,-0.293441,-0.33175,-0.267137,-0.237498,-0.172879,-0.182402:-0.128862,-0.163128,-0.161888,-0.218736,-0.339751,-0.314744,-0.340385,-0.330591,-0.32514,-0.323474,-0.285681,-0.201157,-0.210774:-0.035579,-0.091233,-0.087835,-0.121749,-0.141698,-0.121534,-0.060443,0.010248,0.067814,0.094942,0.113815,0.086197,0.066828:0.0138,0.013362,-0.019129,0.001861,0.17633,0.234665,0.18748,0.173556,0.215845,0.217254,0.186915,0.067152,-0.060087:3
0.364022,0.428645,0.400469,0.238167,0.265804,0.245164,0.14624,0.096064,0.093156,0.112854,0.087773,0.014868,-0.065145:-0.101043,-0.187693,-0.205624,-0.312234,-0.322144,-0.326905,-0.327098,-0.358245,-0.503676,-0.585945,-0.639926,-0.613608,-0.561425:-0.143133,-0.172482,-0.164944,-0.1093,-0.140404,-0.161973,-0.121509,-0.062424,0.041409,0.097645,0.156443,0.211514,0.253569:-0.663067,-0.668813,-0.618795,-0.572497,-0.52404,-0.472842,-0.389827,-0.262038,-0.140997,-0.012934,0.074604,0.130018,0.183835:0.074103,0.132472,0.138067,0.120509,0.159915,0.19958,0.24511,0.280334,0.339698,0.402441,0.426546,0.436631,0.437879:-0.697229,-0.643795,-0.539071,-0.469639,-0.466806,-0.444544,-0.399231,-0.346734,-0.303999,-0.289054,-0.288412,-0.316353,-0.352196:-0.033823,-0.042425,-0.022711,-0.006765,0.004741,0.019433,0.032907,0.052273,0.054188,0.03405,0.017527,-0.006195,-0.017335:0.245288,0.252805,0.192159,0.112224,0.060091,-0.023001,-0.112598,-0.178062,-0.221753,-0.275115,-0.311427,-0.337144,-0.354413:-0.009624,-0.044539,-0.066416,-0.100625,-0.162739,-0.238124,-0.330321,-0.367914,-0.38204,-0.383762,-0.363831,-0.322232,-0.291747:-0.099216,-0.131039,-0.212377,-0.218835,-0.234364,-0.224491,-0.204089,-0.210755,-0.200549,-0.143055,-0.094804,-0.057053,-0.02359:-0.140027,-0.172648,-0.194839,-0.172203,-0.141269,-0.080941,0.017645,0.079257,0.043208,0.027813,0.001415,-0.022373,-0.053023:0.0871,0.067933,0.061303,0.074305,0.157006,0.210401,0.223824,0.206811,0.14029,0.061873,-0.01045,-0.080063,-0.13385:3
0.434426,0.45713,0.447209,0.362702,0.38602,0.384543,0.364642,0.357528,0.357236,0.301104,0.277565,0.315305,0.453881,0.55851,0.498458,0.363553,0.320124,0.277046:-0.170757,-0.247079,-0.286505,-0.253924,-0.331179,-0.36768,-0.388837,-0.420108,-0.446609,-0.47955,-0.514898,-0.560425,-0.659295,-0.703333,-0.694999,-0.675233,-0.642713,-0.628987:-0.042581,-0.052847,-0.051505,-0.042349,-0.012705,-0.020162,-0.033215,-0.031274,-0.004622,0.040515,0.069601,0.081148,0.150973,0.181875,0.216617,0.246627,0.215178,0.271102:-0.637755,-0.604387,-0.576264,-0.561163,-0.537602,-0.51398,-0.470443,-0.402248,-0.345827,-0.283249,-0.225969,-0.163049,-0.090209,0.030024,0.132093,0.179633,0.222841,0.267932:-0.049544,-0.029418,-0.02229,-0.001007,-0.005795,0.02512,0.056626,0.083435,0.11776,0.167386,0.222539,0.268391,0.280121,0.310427,0.31773,0.349895,0.421226,0.417927:-0.614386,-0.57065,-0.517661,-0.486709,-0.456811,-0.439077,-0.406309,-0.368916,-0.350836,-0.315539,-0.287935,-0.279906,-0.271783,-0.277058,-0.26121,-0.26697,-0.316963,-0.328885:0.043129,0.050457,0.062955,0.085278,0.083898,0.096028,0.129034,0.152217,0.161166,0.143619,0.139845,0.145488,0.126813,0.086331,0.077607,0.06814,0.040977,0.029137:0.197321,0.175935,0.168949,0.131319,0.092253,0.032966,-0.040582,-0.111374,-0.145207,-0.186874,-0.217978,-0.228535,-0.250151,-0.290907,-0.346896,-0.365378,-0.329675,-0.32977:-0.0283,-0.052576,-0.076573,-0.081037,-0.101753,-0.13161,-0.180211,-0.257281,-0.337543,-0.37463,-0.403989,-0.436364,-0.437245,-0.423489,-0.383998,-0.351283,-0.341407,-0.327706:-0.249444,-0.288957,-0.335767,-0.360858,-0.344412,-0.317031,-0.302307,-0.278343,-0.235425,-0.239586,-0.249305,-0.226869,-0.183222,-0.125897,-0.101331,-0.079854,-0.048373,-0.018907:-0.046981,-0.050688,-0.053376,-0.063745,-0.067939,-0.068419,-0.081003,-0.075958,-0.053583,-0.019158,-8.01E-4,-0.006936,-0.031449,-0.021562,-0.017902,-0.026332,-0.042183,-0.05689:0.122955,0.129308,0.154952,0.159264,0.150101,0.173998,0.208425,0.234661,0.225965,0.231142,0.224053,0.196841,0.171325,0.132958,0.096307,0.043147,-0.018231,-0.059063:3
0.416466,0.33465,0.290664,0.258449,0.183054,0.177907,0.169239,0.150689,0.123205,0.110797,0.047303,-0.04022:0.057932,-0.069765,-0.114502,-0.037943,0.026884,-0.032853,-0.063916,-0.058648,-0.128908,-0.259189,-0.285423,-0.238131:-0.16022,-0.10746,-0.089002,-0.098076,-0.058022,-0.098286,-0.108572,-0.088084,0.008399,0.09685,0.136143,0.173322:-0.599846,-0.587807,-0.581196,-0.545858,-0.514134,-0.468365,-0.379102,-0.311816,-0.216087,-0.123459,-0.038329,0.01404:-0.053616,-0.047128,0.003024,0.106636,0.172803,0.210021,0.238744,0.334282,0.379024,0.446101,0.495365,0.547478:-0.530113,-0.456959,-0.405204,-0.384625,-0.331775,-0.247442,-0.231141,-0.276901,-0.283224,-0.345378,-0.368142,-0.370875:0.102725,0.0897,0.081822,0.071107,0.039517,-0.016124,-0.059759,-0.101453,-0.14146,-0.103991,-0.071558,-0.090024:0.147978,0.113265,0.06317,-0.012712,-0.082223,-0.222589,-0.27461,-0.269856,-0.280356,-0.256634,-0.2617,-0.271086:-0.007709,-0.056539,-0.113416,-0.169073,-0.176785,-0.179851,-0.2031,-0.258367,-0.288522,-0.351837,-0.365011,-0.317638:-0.339704,-0.38284,-0.395527,-0.370405,-0.348275,-0.299298,-0.284275,-0.23603,-0.196441,-0.138941,-0.095545,-0.077373:0.043659,0.07623,0.101326,0.114242,0.079714,0.114662,0.168798,0.19719,0.262883,0.205792,0.131847,0.07405:0.121368,0.144348,0.161905,0.201929,0.260925,0.24109,0.210996,0.147239,0.042316,0.001183,-0.040522,-0.104697:3
-0.070382,-0.075689,-0.095315,-0.069289,0.016217,0.009188,0.039082,0.001237,-0.145058,-0.179808,-0.207593,-0.273939,-0.383859:-0.311974,-0.384783,-0.395797,-0.394587,-0.502479,-0.66182,-0.736086,-0.583569,-0.617962,-0.695008,-0.728335,-0.710282,-0.670237:0.037957,0.019673,-0.030736,-0.092232,-0.034108,0.113999,0.21697,0.227373,0.258676,0.315068,0.380108,0.430122,0.450614:-0.697713,-0.648809,-0.589313,-0.517358,-0.469857,-0.480453,-0.426181,-0.246197,-0.175556,-0.133702,-0.078896,-0.031723,-0.003778:0.156027,0.189611,0.231844,0.275158,0.30642,0.266695,0.326034,0.394453,0.436778,0.488412,0.541403,0.578293,0.599651:-0.445643,-0.393097,-0.368432,-0.371157,-0.354814,-0.264901,-0.235066,-0.355465,-0.357605,-0.345888,-0.346496,-0.358848,-0.36668:-0.137353,-0.143054,-0.113409,-0.043309,-0.046044,-0.100591,-0.120495,-0.142245,-0.14876,-0.152613,-0.163922,-0.168598,-0.153203:0.202437,0.139813,0.071398,-0.033117,-0.086273,-0.126181,-0.106319,-0.128002,-0.170953,-0.180149,-0.168281,-0.154373,-0.174154:-0.176948,-0.195757,-0.226831,-0.278365,-0.383433,-0.41975,-0.451841,-0.415496,-0.398924,-0.398239,-0.383499,-0.368562,-0.361553:-0.223283,-0.227938,-0.235851,-0.184724,-0.148627,-0.115624,-0.121362,-0.129593,-0.102984,-0.083523,-0.064286,-0.046613,-0.020808:-0.118465,-0.110248,-0.104948,-0.08317,-0.011334,0.044962,0.07323,0.062437,0.05479,0.01567,4.82E-4,0.005273,-0.011923:0.169902,0.200641,0.222576,0.193228,0.160744,0.155817,0.143088,0.104292,0.042643,0.002518,-0.053651,-0.104653,-0.138118:3
0.28058,0.232723,0.141308,0.272958,0.254118,0.119264,0.102508,0.231582,0.142277,0.017058,-0.013237,0.005512,0.021907,-0.042505:0.184354,0.135967,0.023157,-0.069031,-0.274167,-0.374229,-0.47619,-0.493544,-0.5544,-0.605337,-0.681236,-0.74071,-0.721899,-0.655475:-0.015359,-0.030782,-0.004947,-0.102162,-0.109556,-0.117926,-0.107893,-0.045583,0.099414,0.155234,0.197742,0.278382,0.332941,0.295808:-0.736667,-0.766208,-0.794431,-0.763162,-0.674309,-0.608126,-0.514531,-0.451825,-0.269775,-0.143442,0.006893,0.101644,0.177671,0.228628:0.237551,0.203328,0.188935,0.259899,0.226108,0.276492,0.319104,0.297507,0.28365,0.33975,0.368436,0.424484,0.441219,0.45316:-0.893234,-0.805781,-0.706677,-0.664601,-0.570044,-0.575899,-0.544062,-0.508102,-0.457923,-0.433314,-0.407885,-0.3879,-0.389973,-0.411314:0.02311,0.068308,0.106954,0.138831,0.110484,0.107596,0.095564,0.08322,0.03239,0.042389,0.062994,0.025799,-0.009001,-0.014776:0.243531,0.228627,0.193473,0.159368,0.077298,0.001543,-0.050736,-0.070666,-0.161997,-0.217922,-0.264767,-0.294308,-0.308634,-0.356124:-0.151622,-0.198498,-0.271805,-0.328619,-0.352787,-0.416233,-0.490675,-0.527092,-0.466166,-0.475235,-0.476384,-0.42644,-0.386396,-0.336936:0.034998,-0.006117,-0.021724,-0.066298,-0.080851,-0.057012,-0.103694,-0.124126,-0.072423,-0.053636,-0.047703,0.002379,0.046367,0.069517:-0.240933,-0.218123,-0.191001,-0.204065,-0.162013,-0.110879,-0.024646,0.029783,0.042241,0.032359,0.007348,-0.02028,-0.042058,-0.071522:0.149877,0.147128,0.134976,0.176724,0.170696,0.198181,0.280227,0.301962,0.216416,0.169166,0.101753,0.002836,-0.084867,-0.141175:3
-0.064283,-0.007209,0.061213,0.103031,0.127853,0.128187,0.135464,0.296772,0.248016,0.260556,0.302878,0.097812:-0.084137,-0.129046,-0.209821,-0.321245,-0.416867,-0.461228,-0.481788,-0.498077,-0.482006,-0.496804,-0.5262,-0.435935:0.009606,0.012457,-0.041502,-0.017117,0.027415,0.080294,0.112837,0.183566,0.123971,0.142595,0.205188,0.21928:-0.684918,-0.672675,-0.587186,-0.512442,-0.445808,-0.403868,-0.366605,-0.282063,-0.143624,-0.076749,-0.01248,0.017996:-0.010976,0.012981,0.055234,0.053563,0.073998,0.11666,0.162817,0.132097,0.20824,0.268081,0.305107,0.390843:-0.515461,-0.475929,-0.470949,-0.405302,-0.372457,-0.368042,-0.343315,-0.289281,-0.318688,-0.333111,-0.317013,-0.335837:0.087,0.101325,0.127106,0.163301,0.156994,0.142912,0.142657,0.119756,0.071138,0.051121,0.025043,0.009539:0.118117,0.069495,0.035849,-0.038398,-0.068981,-0.107201,-0.167633,-0.253514,-0.317999,-0.349753,-0.364984,-0.346882:-0.093014,-0.141459,-0.189391,-0.269052,-0.332172,-0.386219,-0.435036,-0.429327,-0.413195,-0.424956,-0.432534,-0.433261:-0.129443,-0.137416,-0.174362,-0.166568,-0.170399,-0.158063,-0.147853,-0.140368,-0.107439,-0.064819,-0.01767,-0.00519:-0.097517,-0.084566,-0.070722,-0.021521,0.002225,0.004008,0.007638,0.03,0.061214,0.053938,0.052553,0.076024:0.103082,0.126306,0.172995,0.169055,0.150558,0.145196,0.156625,0.176067,0.133898,0.104407,0.048002,-0.020511:3
0.614239,0.570857,0.563615,0.617004,0.602282,0.590186,0.61644,0.602664,0.549573,0.507021,0.509939,0.511341,0.530023,0.511469,0.508976:-0.245396,-0.232404,-0.282965,-0.334506,-0.396481,-0.468018,-0.506674,-0.516771,-0.524633,-0.534241,-0.565807,-0.579494,-0.65905,-0.713897,-0.750186:-0.113583,-0.176603,-0.146279,-0.150331,-0.143044,-0.114676,-0.101591,-0.072188,-0.006283,0.018678,0.03928,0.116217,0.164882,0.235826,0.336688:-0.667863,-0.659629,-0.68409,-0.650249,-0.54649,-0.45927,-0.368534,-0.255022,-0.130625,-0.036913,0.016195,0.051481,0.090563,0.115205,0.144546:-0.032263,0.02794,0.068711,0.09479,0.120838,0.193065,0.264391,0.322726,0.323441,0.342922,0.382019,0.400646,0.407324,0.421573,0.425196:-0.603141,-0.587606,-0.545256,-0.484552,-0.443919,-0.398887,-0.365716,-0.345823,-0.329747,-0.345665,-0.376878,-0.386568,-0.377927,-0.390179,-0.3926:-0.013589,-0.019784,-0.034539,-0.021218,0.017547,0.032331,0.037427,0.034716,0.041743,0.03461,1.53E-4,-0.033019,-0.049529,-0.09592,-0.143792:0.236239,0.238251,0.230797,0.167774,0.108145,0.038524,-0.066752,-0.154173,-0.231287,-0.255873,-0.267616,-0.2952,-0.319338,-0.286887,-0.25596:-0.069071,-0.076646,-0.107287,-0.127979,-0.178407,-0.238714,-0.286352,-0.341108,-0.367061,-0.384462,-0.371536,-0.357328,-0.342937,-0.330003,-0.310109:-0.17179,-0.208883,-0.207864,-0.234579,-0.281407,-0.317838,-0.326217,-0.304004,-0.28546,-0.261402,-0.211073,-0.157864,-0.119873,-0.078958,-0.04659:-0.053771,-0.06247,-0.080522,-0.090369,-0.09325,-0.099504,-0.081961,-0.050328,-0.022642,-0.012545,-0.020409,-0.009596,-0.016822,-0.030363,-0.041769:0.088838,0.098219,0.11894,0.165464,0.209967,0.2265,0.257481,0.273456,0.285746,0.257314,0.189116,0.13669,0.102431,0.036403,-0.019126:3
0.366807,0.352173,0.353764,0.414168,0.200024,0.10988,0.185869,0.24883,0.092149,0.028373,0.140297,-0.114721,-0.297572:0.126989,0.060012,0.004183,-0.105848,-0.286721,-0.309755,-0.355168,-0.580935,-0.485563,-0.458042,-0.636746,-0.665239,-0.698998:-0.019801,-0.047931,-0.11514,-0.189935,-0.110989,-0.080706,-0.055682,-0.119909,-0.057796,-0.003431,0.057108,0.150091,0.274379:-0.778992,-0.768983,-0.745489,-0.660632,-0.609995,-0.555816,-0.470786,-0.310462,-0.278525,-0.24538,-0.146892,-0.056302,0.026633:0.073868,0.099655,0.125343,0.12479,0.132307,0.187796,0.166429,0.189613,0.227039,0.28645,0.303426,0.3871,0.41603:-0.841959,-0.826748,-0.765038,-0.668792,-0.581827,-0.544239,-0.490141,-0.404158,-0.424273,-0.436617,-0.389907,-0.34296,-0.310972:0.047922,0.07461,0.106655,0.07898,0.066098,0.077794,0.066623,-0.007671,-0.004419,-0.022514,-0.010341,-0.027948,-0.065247:0.330353,0.291944,0.244591,0.22582,0.17642,0.110952,-0.015406,-0.136618,-0.163265,-0.217153,-0.263273,-0.29454,-0.303736:-0.102896,-0.12374,-0.125945,-0.130005,-0.203293,-0.276913,-0.246703,-0.192114,-0.269152,-0.330872,-0.370691,-0.35352,-0.308066:0.006544,-0.012734,-0.06145,-0.191583,-0.23471,-0.27227,-0.269322,-0.285087,-0.21277,-0.109279,-0.035782,-0.031075,-0.038216:-0.116546,-0.124725,-0.154449,-0.133626,-0.076095,-0.046396,-0.001869,0.041539,0.006575,0.012746,0.033113,0.055002,0.033663:0.131585,0.149446,0.151283,0.16153,0.180922,0.221149,0.225047,0.239327,0.276434,0.25242,0.175063,0.050937,-0.021223:3
0.446281,0.371962,0.197503,0.29689,0.125457,0.036336,0.163669,0.083057,0.043522:-0.092418,-0.070224,0.01604,-0.21045,-0.418305,-0.422011,-0.442687,-0.437141,-0.473523:-0.099867,-0.068564,-0.110563,-0.182053,-0.12311,-0.140784,-0.096229,0.01387,0.062804:-0.746163,-0.791969,-0.799933,-0.733502,-0.666357,-0.586931,-0.474899,-0.324733,-0.173583:0.118036,0.175077,0.266648,0.268851,0.281711,0.331581,0.317939,0.364422,0.419828:-0.713173,-0.69149,-0.638364,-0.551226,-0.464004,-0.442868,-0.392059,-0.42368,-0.464829:-0.022224,-0.04524,-0.027647,-0.029042,-0.113348,-0.131923,-0.082293,-0.072017,-0.079212:0.278668,0.300168,0.222825,0.14487,0.103162,0.035597,-0.130488,-0.215512,-0.259164:-0.097617,-0.133332,-0.178798,-0.185909,-0.204342,-0.240504,-0.245428,-0.298142,-0.326684:-0.107728,-0.126361,-0.126188,-0.175155,-0.204403,-0.232332,-0.2041,-0.104446,-0.03916:-0.152938,-0.167125,-0.163572,-0.11655,-0.058913,-0.008274,0.009499,-0.012314,0.001538:0.149174,0.146686,0.144432,0.164549,0.17231,0.218618,0.297111,0.312361,0.217977:3
0.007937,0.070589,0.059886,0.077313,0.234166,0.310951,0.317241,0.341493,0.452421,0.196335,0.018039,-0.041531,-0.115768,-0.231207,-0.344153,-0.451102,-0.52373,-0.533087:0.017163,-0.26196,-0.320168,-0.341588,-0.427823,-0.499062,-0.527713,-0.588455,-0.735076,-0.595552,-0.475552,-0.453026,-0.461242,-0.427772,-0.403717,-0.410489,-0.421469,-0.471843:-0.085049,-0.019591,-0.071089,-0.076312,-0.036697,-0.037656,-0.026683,0.037494,0.180322,0.223631,0.272191,0.305356,0.305786,0.312858,0.33986,0.363458,0.369635,0.427111:-0.564587,-0.412852,-0.467419,-0.484741,-0.453951,-0.367022,-0.204773,-0.100418,-0.068264,0.093092,0.209348,0.253104,0.286387,0.325714,0.335396,0.353936,0.377199,0.365562:-0.007136,-0.064218,0.049563,0.108379,0.171519,0.187688,0.202691,0.264136,0.334425,0.366062,0.394722,0.443018,0.453901,0.464863,0.512813,0.552499,0.561191,0.566653:-0.568189,-0.53183,-0.472141,-0.454372,-0.397414,-0.358768,-0.319871,-0.300742,-0.292887,-0.300727,-0.332008,-0.383713,-0.403197,-0.430072,-0.47094,-0.499036,-0.512542,-0.513584:0.121911,0.096602,0.100534,0.074902,-0.014071,0.004581,-0.00707,-0.02168,-0.019743,0.012726,-0.007483,-0.022104,-0.023856,-0.020465,0.00486,0.020154,0.018788,0.001782:0.114209,0.084597,0.060813,0.040015,-0.011524,-0.138506,-0.251337,-0.280886,-0.273316,-0.339362,-0.350242,-0.325267,-0.309057,-0.27428,-0.241886,-0.218224,-0.198756,-0.169221:-0.096551,-0.102528,-0.233773,-0.293622,-0.307818,-0.333104,-0.311005,-0.345301,-0.407519,-0.359619,-0.322209,-0.325281,-0.299616,-0.251637,-0.218006,-0.206414,-0.202549,-0.206923:-0.226823,-0.255001,-0.304382,-0.341687,-0.355309,-0.303848,-0.270799,-0.214533,-0.128142,-0.078339,-0.02841,0.016596,0.030639,0.041823,0.066989,0.063794,0.050726,0.048607:-0.008044,0.021126,0.072829,0.098122,0.122641,0.139539,0.151127,0.122182,0.042707,0.018091,-3.73E-4,-0.039406,-0.078784,-0.117754,-0.144854,-0.16023,-0.165207,-0.189242:0.06407,0.070919,0.136131,0.177184,0.215937,0.246748,0.240848,0.195058,0.13332,0.01466,-0.11186,-0.168274,-0.202334,-0.234823,-0.24617,-0.250591,-0.2568,-0.240596:3
0.359208,0.31586,0.317127,0.268419,0.363292,0.374259,0.324606,0.281109,0.306438,0.517923,0.390827,0.347156,0.336986,0.277938,0.20406,0.148251,0.064086,-0.029862,-0.133294,-0.213064:-0.27587,-0.310181,-0.381165,-0.432176,-0.467336,-0.517052,-0.556385,-0.56057,-0.547487,-0.556249,-0.549795,-0.558961,-0.514654,-0.403477,-0.355985,-0.252744,-0.332165,-0.343822,-0.288682,-0.26136:0.155743,0.115741,0.107238,0.140821,0.135156,0.148338,0.148484,0.17605,0.216038,0.1972,0.216579,0.212024,0.132433,0.042129,0.047079,0.036159,0.118234,0.167388,0.196818,0.219525:-0.747204,-0.754865,-0.760341,-0.731719,-0.671419,-0.638185,-0.610046,-0.559036,-0.498208,-0.400638,-0.30398,-0.282594,-0.187979,-0.03651,0.041976,0.064842,0.097979,0.102962,0.094989,0.109584:-0.142893,-0.135011,-0.119629,-0.073071,-0.045847,-0.023224,0.001589,0.02511,0.0464,0.048668,0.077387,0.158684,0.211722,0.260053,0.325412,0.410326,0.378906,0.390806,0.438935,0.467203:-0.636306,-0.582472,-0.532421,-0.510395,-0.48259,-0.426781,-0.409352,-0.397876,-0.370937,-0.320094,-0.294853,-0.293461,-0.27051,-0.31913,-0.383164,-0.452728,-0.439518,-0.464012,-0.503933,-0.544083:0.066262,0.120789,0.134014,0.120087,0.095191,0.063339,0.051597,0.033373,0.003727,-0.011878,-6.21E-4,-0.009035,-0.009544,0.038951,0.039008,0.009087,-0.003233,-0.010519,-0.010041,-0.009951:0.255904,0.23291,0.173727,0.141383,0.112319,0.075599,0.025854,-0.031624,-0.083458,-0.138901,-0.183023,-0.216315,-0.292856,-0.39506,-0.404629,-0.395293,-0.383304,-0.373793,-0.371228,-0.345956:-0.154895,-0.17813,-0.207165,-0.270775,-0.289176,-0.3243,-0.341975,-0.358458,-0.375613,-0.394114,-0.403517,-0.405419,-0.383278,-0.356944,-0.345789,-0.322991,-0.299593,-0.280465,-0.277522,-0.279372:-0.052998,-0.090734,-0.113811,-0.160448,-0.187646,-0.20789,-0.203434,-0.193458,-0.180787,-0.159305,-0.134514,-0.149963,-0.15374,-0.100932,-0.054653,-0.020304,-0.01559,0.008937,0.039717,0.040547:0.027734,0.029556,0.033351,0.028612,0.043017,0.070298,0.07664,0.106661,0.153748,0.189596,0.165548,0.156855,0.165793,0.133571,0.078092,0.033428,6.48E-4,-0.046842,-0.082159,-0.106431:0.118639,0.126568,0.131213,0.132649,0.143682,0.147419,0.16997,0.205106,0.227949,0.224236,0.179373,0.136565,0.063796,0.016166,-0.013412,-0.044591,-0.100056,-0.152603,-0.189414,-0.19607:3
0.338609,0.427357,0.535588,0.444896,0.467828,0.5632,0.54943,0.666697,0.743518,0.580823,0.393997,0.358441,0.366271,0.345139,0.250499,0.19881,0.198802,0.223119,0.187649,0.133987,0.061107:-0.008674,-0.061698,-0.211297,-0.233757,-0.261901,-0.309032,-0.289015,-0.359461,-0.416885,-0.388819,-0.367905,-0.359051,-0.36913,-0.389966,-0.400691,-0.414713,-0.440302,-0.466152,-0.436783,-0.435388,-0.372015:0.171015,0.107198,0.103426,0.026315,-0.002175,-0.027443,-0.092247,-0.140075,-0.131708,-0.117309,-0.068751,-0.047724,-0.033312,-0.005697,0.020359,0.038896,0.07004,0.118366,0.144419,0.147719,0.151888:-0.840933,-0.840062,-0.795149,-0.712193,-0.741155,-0.7145,-0.65936,-0.614556,-0.490334,-0.396116,-0.318682,-0.261597,-0.206176,-0.155352,-0.084831,-0.051439,0.009479,0.086412,0.128757,0.175608,0.203996:-0.060604,-0.016425,-0.006657,0.051672,0.11114,0.136766,0.179003,0.225203,0.158947,0.131726,0.165254,0.223915,0.272006,0.31499,0.361584,0.3961,0.417016,0.426407,0.451566,0.451829,0.491496:-0.748846,-0.739313,-0.676105,-0.614392,-0.622967,-0.56431,-0.547017,-0.490967,-0.384586,-0.341899,-0.359039,-0.379199,-0.408163,-0.434066,-0.434613,-0.417147,-0.400027,-0.388847,-0.393355,-0.399398,-0.432126:-0.031048,0.009701,-0.002662,0.005176,0.016104,0.00633,0.013687,0.007376,-0.009756,0.049657,0.097249,0.105865,0.116421,0.093087,0.066535,0.06149,0.054617,0.043697,0.032725,0.04426,0.032795:0.411823,0.388299,0.347649,0.268043,0.27847,0.2357,0.207429,0.143898,0.028003,-0.13906,-0.242893,-0.27968,-0.274529,-0.269851,-0.301279,-0.303559,-0.303622,-0.304579,-0.30723,-0.326746,-0.323963:-0.158545,-0.15733,-0.185649,-0.165316,-0.196428,-0.22793,-0.242974,-0.317928,-0.31811,-0.250494,-0.283339,-0.370298,-0.440593,-0.445561,-0.430152,-0.443528,-0.434747,-0.403376,-0.368196,-0.33805,-0.323892:0.002443,-0.033691,-0.092953,-0.149344,-0.162038,-0.211647,-0.277623,-0.305758,-0.350376,-0.397212,-0.297019,-0.206567,-0.162331,-0.139312,-0.122227,-0.108511,-0.092375,-0.082576,-0.075858,-0.062286,-0.045198:-0.028045,-0.072702,-0.081689,-0.099446,-0.117315,-0.10508,-0.079825,-0.044682,5.38E-4,0.019963,-0.011806,0.022953,0.041856,0.043533,0.059811,0.055334,0.042312,0.030157,0.016704,-0.001442,-0.008123:0.047198,0.066587,0.067012,0.07931,0.100941,0.138551,0.159529,0.192281,0.230053,0.278907,0.294677,0.277982,0.238786,0.178359,0.12874,0.094452,0.061244,0.02136,-0.030175,-0.067955,-0.106079:3
0.794343,0.850033,0.825171,0.784147,0.876907,0.895273,0.702495,0.482777,0.356167,0.142579,0.007678,-0.045463:0.239662,0.133727,0.011174,-0.166306,-0.323969,-0.319785,-0.223292,-0.201197,-0.22629,-0.117392,0.040137,0.103112:-0.285268,-0.331298,-0.310001,-0.26882,-0.215835,-0.221787,-0.197142,-0.098546,-0.037074,0.045449,0.031284,0.00818:-0.760525,-0.711969,-0.641843,-0.549089,-0.445469,-0.183821,-0.1765,-0.183035,-0.085021,0.007906,0.069206,0.108191:0.178469,0.179567,0.171235,0.202931,0.206926,0.175772,0.273449,0.37765,0.412052,0.441543,0.49379,0.522038:-0.803803,-0.746435,-0.615992,-0.538369,-0.463964,-0.401624,-0.424868,-0.478476,-0.477059,-0.453431,-0.46016,-0.463645:0.038664,0.03954,0.027317,0.048506,0.035242,0.048142,0.061397,0.049934,0.045015,0.057569,0.086846,0.094787:0.211978,0.170479,0.118845,0.032414,-0.080237,-0.207627,-0.231303,-0.241132,-0.281875,-0.352653,-0.409371,-0.441517:-0.012359,-0.025346,-0.037672,-0.081291,-0.15297,-0.234052,-0.368928,-0.419278,-0.411352,-0.395693,-0.352051,-0.300753:-0.097134,-0.184423,-0.275637,-0.293667,-0.322757,-0.296225,-0.200124,-0.12726,-0.118471,-0.076588,-0.016889,0.003027:-0.145628,-0.113577,-0.070738,-0.119911,-0.097139,-0.014415,0.008821,0.057822,0.063158,0.056094,0.028183,-0.009463:0.130924,0.174985,0.204683,0.306565,0.359179,0.355767,0.310105,0.20135,0.121185,0.051086,-0.061744,-0.121026:3
0.102493,0.293118,0.407984,0.225888,0.192148,0.275759,0.381506,0.385328,0.344774,0.279064,0.120631,-0.068183,-0.197404:0.041724,-0.059664,-0.190052,-0.208896,-0.274475,-0.356395,-0.329397,-0.252019,-0.250197,-0.243559,-0.134234,-0.089776,-0.05771:-0.075662,-0.064883,-0.084427,-0.086864,-0.12437,-0.132339,-0.199693,-0.325405,-0.268522,-0.188604,-0.162897,-0.045032,0.153932:-0.614913,-0.708999,-0.712918,-0.660559,-0.600261,-0.533145,-0.414382,-0.318341,-0.202622,-0.126884,-0.06567,0.018951,0.053754:-0.270558,-0.197618,-0.134025,-0.071894,-0.002933,0.069963,0.120239,0.20407,0.23426,0.326466,0.453964,0.472192,0.491626:-0.683226,-0.666531,-0.626039,-0.587785,-0.548695,-0.508171,-0.47663,-0.491964,-0.461098,-0.458766,-0.495307,-0.512324,-0.505627:0.126195,0.123647,0.129194,0.13646,0.140537,0.137753,0.141762,0.147828,0.100541,0.05976,0.039277,0.043635,0.052093:0.191778,0.218657,0.196285,0.131774,0.062199,-0.009197,-0.105308,-0.208353,-0.302037,-0.313671,-0.322288,-0.377456,-0.402745:0.011791,-0.023533,-0.059879,-0.105035,-0.174459,-0.251598,-0.291519,-0.344974,-0.35615,-0.363494,-0.34758,-0.324044,-0.314423:-0.168248,-0.163756,-0.201767,-0.237858,-0.266826,-0.283904,-0.300127,-0.241867,-0.167996,-0.158156,-0.136112,-0.036671,0.070384:0.144973,0.096935,0.060395,0.018146,0.02936,0.037463,0.058727,0.0719,0.096778,0.102488,0.035147,-0.009426,-0.068222:0.02235,0.072722,0.137562,0.204737,0.26219,0.31095,0.320448,0.27889,0.240873,0.181049,0.090229,-0.022394,-0.131386:3
0.679613,0.552053,0.446176,0.488143,0.517589,0.50262,0.473202,0.361101,0.348605,0.291503,0.127816,0.033313,0.009841,-0.06397,-0.150525:0.076128,-0.040046,-0.075352,-0.129934,-0.18847,-0.230653,-0.231882,-0.249058,-0.224884,-0.136881,-0.027505,0.042678,0.032604,0.008127,-0.026334:-0.042808,-0.081643,-0.106565,-0.118612,-0.138072,-0.164154,-0.167,-0.12025,-0.103051,-0.107037,-0.006889,0.099802,0.152932,0.227823,0.225704:-0.828663,-0.823202,-0.801461,-0.766906,-0.70213,-0.623396,-0.543637,-0.501952,-0.425851,-0.271104,-0.159411,-0.092339,-0.097287,-0.042943,0.028894:0.153964,0.184718,0.220035,0.228035,0.242841,0.312178,0.387828,0.44674,0.492513,0.524151,0.607625,0.643807,0.640154,0.654813,0.66773:-0.806056,-0.78717,-0.748178,-0.698259,-0.626333,-0.572663,-0.560233,-0.55267,-0.5626,-0.579368,-0.577612,-0.552941,-0.543608,-0.567198,-0.572958:-0.077759,-0.067209,-0.040901,-0.009395,-0.009088,-0.009018,-0.003287,-0.008979,0.005539,0.017448,0.014414,0.007073,0.032524,0.031744,0.01789:0.30539,0.308652,0.271883,0.238804,0.170932,0.082634,-0.003179,-0.046533,-0.077833,-0.144053,-0.227118,-0.268805,-0.303287,-0.317698,-0.326273:-0.068711,-0.092529,-0.125694,-0.165132,-0.182194,-0.238404,-0.325727,-0.404812,-0.438275,-0.415788,-0.437977,-0.401365,-0.376306,-0.378347,-0.367568:-0.024016,-0.064984,-0.105946,-0.165347,-0.207878,-0.222855,-0.213968,-0.180702,-0.168513,-0.150764,-0.091985,-0.03493,0.027893,0.075148,0.084649:-0.179419,-0.185049,-0.179167,-0.157682,-0.15576,-0.162022,-0.131746,-0.081046,-0.065423,-0.046258,-0.032386,-0.056733,-0.110463,-0.13912,-0.142195:0.098164,0.118063,0.147047,0.18848,0.217894,0.266008,0.319018,0.324034,0.294335,0.217448,0.157823,0.076663,-0.017129,-0.065814,-0.098584:3
0.480113,0.624272,0.752889,0.714272,0.774714,0.809943,0.789277,0.660834,0.37617,0.249115,0.208406,0.235429,0.24231,0.191434:0.183511,0.099384,-0.063174,-0.19236,-0.304822,-0.411119,-0.41996,-0.399017,-0.376303,-0.396319,-0.460195,-0.550417,-0.605471,-0.626195:-0.183561,-0.266521,-0.243257,-0.170979,-0.185336,-0.166281,-0.143416,-0.086325,-0.059958,0.001134,0.063069,0.131757,0.215122,0.270364:-0.746952,-0.698655,-0.641547,-0.673441,-0.638782,-0.588874,-0.536269,-0.487767,-0.468887,-0.38008,-0.267304,-0.141105,-0.03351,0.054447:0.189924,0.199798,0.145254,0.15477,0.150194,0.138543,0.192724,0.245696,0.368645,0.463658,0.518033,0.519606,0.488187,0.474818:-0.841909,-0.779052,-0.670543,-0.625734,-0.568869,-0.522787,-0.498746,-0.463534,-0.490173,-0.468789,-0.419928,-0.375264,-0.388306,-0.397349:0.079081,0.060411,0.024495,0.013106,-0.001261,-0.008461,-0.01327,7.79E-4,0.034005,0.017058,-0.004186,-0.021949,-0.053705,-0.069743:0.2147,0.181188,0.143743,0.150765,0.110493,0.071657,0.008671,-0.038875,-0.065808,-0.128992,-0.18398,-0.216489,-0.233082,-0.268561:-0.058693,-0.050027,-0.0348,-0.101223,-0.1069,-0.151327,-0.229935,-0.328299,-0.421679,-0.475945,-0.492147,-0.461298,-0.404787,-0.369363:-0.031515,-0.088143,-0.155963,-0.165649,-0.187096,-0.174393,-0.162864,-0.175403,-0.171692,-0.158562,-0.143551,-0.127714,-0.07024,-0.023441:-0.231301,-0.245249,-0.241547,-0.242198,-0.251142,-0.229611,-0.148663,-0.04259,0.001285,0.036743,0.039768,0.007738,-0.025924,-0.03866:0.130245,0.139049,0.167719,0.199366,0.229053,0.245836,0.293467,0.311103,0.26527,0.222569,0.172439,0.100989,-0.011424,-0.087711:3
0.473245,0.460252,0.427321,0.364768,0.336562,0.294393,0.213608,0.23954,0.157721,0.081597,-0.060423,-0.156181,-0.206027:0.012674,0.018879,0.027633,0.008781,-0.030572,-0.079093,-0.094529,-0.014107,-0.079365,-0.198468,-0.210661,-0.1738,-0.193926:0.075177,0.044509,0.023014,0.016525,0.021788,0.004832,-0.035551,0.028425,0.140361,0.181961,0.276965,0.321776,0.362871:-0.890248,-0.887141,-0.826814,-0.762717,-0.68292,-0.579393,-0.566496,-0.513526,-0.373905,-0.277865,-0.117842,-0.01728,0.016966:0.143053,0.211243,0.244242,0.251223,0.270704,0.340511,0.469009,0.561404,0.619578,0.659214,0.668051,0.687802,0.70381:-0.776101,-0.772369,-0.733515,-0.667942,-0.614219,-0.577463,-0.557677,-0.561438,-0.529271,-0.513,-0.509745,-0.514355,-0.537558:-0.149575,-0.143388,-0.111461,-0.088242,-0.075361,-0.047743,-0.031827,-0.044902,-0.074198,-0.080156,-0.079652,-0.002775,0.019566:0.364176,0.360049,0.320468,0.261604,0.184982,0.066196,0.003568,-0.027085,-0.103545,-0.140928,-0.207552,-0.241228,-0.250593:-0.111669,-0.128878,-0.137634,-0.147561,-0.17734,-0.273711,-0.390929,-0.442939,-0.476711,-0.481309,-0.427979,-0.410562,-0.39345:0.013618,-0.023633,-0.104205,-0.172235,-0.207786,-0.194518,-0.179225,-0.153343,-0.107845,-0.089669,-0.012511,0.051573,0.103711:-0.142183,-0.165597,-0.169072,-0.175152,-0.199595,-0.184605,-0.170638,-0.130173,-0.060054,-0.057078,-0.067226,-0.119872,-0.170066:0.055009,0.090351,0.153209,0.201852,0.23279,0.251871,0.260119,0.260912,0.202314,0.137709,0.026717,-0.064511,-0.130104:3
0.66505,0.619983,0.577306,0.783251,0.849704,0.681795,0.498102,0.413802,0.395623,0.423405,0.370025,0.254633:0.210634,0.128482,-0.150913,-0.35256,-0.373785,-0.286821,-0.174755,-0.090193,-0.135713,-0.188089,-0.23175,-0.244661:-0.434521,-0.406645,-0.286986,-0.262001,-0.262026,-0.269328,-0.231359,-0.141716,-0.09158,-0.086978,-0.036883,0.044131:-0.565059,-0.552796,-0.441663,-0.255254,-0.237433,-0.288299,-0.293545,-0.192523,-0.074335,0.00504,0.08714,0.150569:0.159337,0.198899,0.157294,0.22996,0.270492,0.383765,0.497734,0.528408,0.477952,0.459709,0.451613,0.491357:-0.71597,-0.678918,-0.550524,-0.452023,-0.429219,-0.435183,-0.492577,-0.536822,-0.515979,-0.504737,-0.522384,-0.56271:0.228607,0.206631,0.129785,0.067194,0.036772,0.02224,0.030749,0.028484,0.021554,0.012691,-0.008591,-0.052888:0.032756,0.006126,-0.00641,-0.107207,-0.186679,-0.192821,-0.204678,-0.252433,-0.297776,-0.31426,-0.305124,-0.293214:-0.16992,-0.204571,-0.189552,-0.257909,-0.283675,-0.36208,-0.423115,-0.424803,-0.413921,-0.392418,-0.363684,-0.317294:-0.213484,-0.208597,-0.205259,-0.20247,-0.214174,-0.19978,-0.161207,-0.093392,-0.05941,-0.05164,-0.025773,0.002872:-0.163444,-0.126604,-0.098726,-0.095519,-0.072455,-0.035247,-0.011812,0.00802,0.040436,0.023127,-0.011642,-0.045008:0.290301,0.316798,0.35332,0.335385,0.332125,0.276402,0.209645,0.130086,0.049078,0.020972,-0.036002,-0.099422:3
0.639932,0.746872,0.697675,0.70731,0.696873,0.412881,0.477312,0.363918,0.132816,0.018449,0.192206,0.423536,0.437417:0.260007,0.312989,0.239834,0.228649,0.078921,-0.073063,-0.198304,-0.357849,-0.433568,-0.48256,-0.46476,-0.616105,-0.458333:-0.100174,-0.078304,-0.04808,-0.091034,-0.074559,-0.062642,-0.057155,0.095301,0.139707,0.173888,0.181617,0.297948,0.306641:-0.684213,-0.656239,-0.687264,-0.712414,-0.76455,-0.718571,-0.632711,-0.485583,-0.38231,-0.272191,-0.141637,-0.06227,0.001138:0.122232,0.09662,0.130327,0.195644,0.207225,0.276866,0.33455,0.307311,0.387417,0.47571,0.488617,0.496678,0.558223:-0.727524,-0.679738,-0.588733,-0.570142,-0.549035,-0.535911,-0.4864,-0.331217,-0.304678,-0.325265,-0.321551,-0.32483,-0.429295:-0.03006,0.006288,0.003528,0.020249,0.073816,0.113446,0.05112,-0.006704,0.009906,0.007542,0.009364,-0.051752,-0.08185:0.163171,0.147594,0.138382,0.11499,0.075261,0.038783,0.036086,-0.021711,-0.089233,-0.13476,-0.172243,-0.158339,-0.165387:0.057252,0.008787,-0.054029,-0.112593,-0.275983,-0.383416,-0.3766,-0.41621,-0.457986,-0.467867,-0.430696,-0.384883,-0.361588:-0.126142,-0.141988,-0.158113,-0.168025,-0.157792,-0.16483,-0.215597,-0.259219,-0.260287,-0.231581,-0.199932,-0.125157,-0.070774:-0.176829,-0.154615,-0.173297,-0.185831,-0.143448,-0.103623,-0.087539,0.020386,0.045743,0.050435,0.067089,-0.011802,-0.035624:0.092198,0.087447,0.092123,0.097734,0.137737,0.169361,0.1871,0.178979,0.151549,0.117658,0.063786,-0.002716,-0.054655:3
0.553673,0.484577,0.478159,0.482038,0.380419,0.196127,0.074147,-0.040075,-0.092419,-0.204959,-0.284478:-0.051318,-0.09599,-0.127298,-0.142229,-0.118461,-6.34E-4,-0.042769,-0.093134,-0.108524,-0.092937,-0.102026:0.259447,0.25091,0.235715,0.220312,0.227365,0.313142,0.464937,0.553454,0.649437,0.728999,0.774613:-0.698848,-0.666567,-0.639477,-0.641125,-0.595083,-0.518623,-0.479653,-0.501641,-0.377536,-0.300345,-0.254169:0.095548,0.101342,0.11823,0.187463,0.262511,0.325375,0.359168,0.420399,0.450987,0.462002,0.475746:-0.635772,-0.582162,-0.550637,-0.567098,-0.557182,-0.511734,-0.466271,-0.345265,-0.357201,-0.383408,-0.390061:-0.037062,-0.004493,0.019175,0.016177,-0.022676,-0.061761,-0.067867,0.02351,0.046753,0.045267,0.032638:0.283289,0.255753,0.23932,0.224799,0.128685,-0.012535,-0.073136,-0.174796,-0.190434,-0.167321,-0.18091:-0.273078,-0.308851,-0.354887,-0.433877,-0.458883,-0.448535,-0.463514,-0.596429,-0.614606,-0.57782,-0.54989:-0.159817,-0.201385,-0.228559,-0.208171,-0.143042,-0.051244,-0.004067,0.056607,0.09266,0.087123,0.100697:-0.061517,-0.085618,-0.107457,-0.08736,-0.034228,0.002966,-0.014967,-0.012323,-0.010366,-0.061564,-0.095677:0.155126,0.201319,0.235362,0.225836,0.215738,0.139663,0.043411,-0.036752,-0.105888,-0.156057,-0.189256:3
0.732277,0.693401,0.846429,0.812841,0.789829,0.832746,0.786374,0.71533,0.667769,0.596026,0.482383,0.374257,0.253155,0.131946:-0.250787,-0.254098,-0.297737,-0.321318,-0.333271,-0.374586,-0.341391,-0.364765,-0.430056,-0.462758,-0.455414,-0.443122,-0.456447,-0.437762:-0.114015,-0.123603,-0.081669,-0.059411,-0.047549,-0.011545,0.004945,0.031456,0.081796,0.126839,0.152003,0.215609,0.285888,0.344733:-0.646441,-0.608259,-0.587864,-0.55956,-0.535809,-0.498811,-0.433985,-0.386701,-0.292963,-0.179675,-0.077357,0.02361,0.101852,0.155788:0.072699,0.095199,0.087789,0.078975,0.100388,0.126656,0.175643,0.298132,0.367913,0.407381,0.451007,0.49261,0.525971,0.567369:-0.371841,-0.378342,-0.339364,-0.33691,-0.33187,-0.298544,-0.268662,-0.270018,-0.257862,-0.254575,-0.284701,-0.348874,-0.401833,-0.442918:-0.151306,-0.129608,-0.119395,-0.06083,-0.03905,-0.05323,-0.044299,-0.025351,-0.024108,-0.027731,-0.023343,-0.05419,-0.074908,-0.073074:0.088475,0.073685,0.056579,0.021655,0.004183,0.001682,-0.044717,-0.07643,-0.099131,-0.138068,-0.174568,-0.187537,-0.192606,-0.17776:0.038275,-7.82E-4,-0.060677,-0.145019,-0.195066,-0.244657,-0.286222,-0.351723,-0.38163,-0.381622,-0.362979,-0.323559,-0.293374,-0.289064:-0.289835,-0.306201,-0.3276,-0.330915,-0.357419,-0.376864,-0.38299,-0.359726,-0.358201,-0.338419,-0.295868,-0.222503,-0.150025,-0.098233:-0.158362,-0.15316,-0.144103,-0.106688,-0.080316,-0.057721,-0.008695,-0.012287,-0.002171,0.010443,0.004275,-0.014455,-0.02925,-0.034827:0.039424,0.049119,0.092007,0.116445,0.146607,0.16755,0.174216,0.179231,0.182138,0.161028,0.112247,0.0326,-0.054447,-0.108626:3
0.44708,0.449491,0.505537,0.505986,0.519071,0.398584,0.345562,0.291158,0.260774,0.312255,0.164522,0.021008,0.008972,0.008357:0.074589,0.051698,-0.0164,-0.080125,-0.16027,-0.182004,-0.164886,-0.133952,-0.136816,-0.299268,-0.260637,-0.228105,-0.240885,-0.257353:0.044697,0.029745,0.030363,0.050474,0.079177,0.075222,0.1171,0.163586,0.239672,0.21168,0.345055,0.456997,0.493973,0.504634:-0.746618,-0.772902,-0.749262,-0.707119,-0.660834,-0.530803,-0.403603,-0.319098,-0.252638,-0.228987,-0.151649,-0.028082,0.02041,0.016273:0.187961,0.242155,0.309925,0.312614,0.288987,0.331575,0.411962,0.503112,0.554898,0.573427,0.620297,0.66552,0.657939,0.651856:-0.637912,-0.604709,-0.543749,-0.466292,-0.427946,-0.482833,-0.524885,-0.517009,-0.522046,-0.484213,-0.426399,-0.437562,-0.48515,-0.444648:-0.168289,-0.117728,-0.100396,-0.07543,-0.031707,-0.028368,-0.044816,-0.047119,-0.061153,-0.033481,-0.058359,-0.060421,-0.041946,-0.058811:0.273687,0.239205,0.186037,0.120732,0.068793,0.024874,-0.039442,-0.080912,-0.121392,-0.157791,-0.190452,-0.17879,-0.157553,-0.201002:-0.141737,-0.217037,-0.287476,-0.33752,-0.376167,-0.418816,-0.470954,-0.511427,-0.49404,-0.515221,-0.487293,-0.438484,-0.427542,-0.398313:-0.068913,-0.083306,-0.118555,-0.1632,-0.195022,-0.180367,-0.128392,-0.114193,-0.073279,-0.061512,-0.045681,-0.009894,-0.007521,0.028426:-0.190001,-0.197934,-0.174945,-0.157623,-0.15536,-0.129755,-0.047368,-0.013968,-0.031083,-0.021867,-0.011917,-0.04483,-0.087204,-0.102048:0.019629,0.064514,0.116485,0.148898,0.172875,0.188029,0.208703,0.201303,0.126239,0.088411,0.045347,-0.033414,-0.073624,-0.126511:3
0.857432,0.935051,1.023812,1.103025,1.085795,0.939948,0.789958,0.613011,0.437186,0.199361,0.070958,0.026641,0.017467,-0.023463,-0.110539:0.192668,0.141262,0.133889,0.150716,-0.032678,-0.04967,-0.072579,-0.04649,-0.1273,-0.16823,-0.165511,-0.210672,-0.232322,-0.255704,-0.304356:0.064112,0.120263,-0.029988,-0.269646,-0.112816,0.016639,0.168574,0.205107,0.309549,0.443535,0.447163,0.478837,0.489268,0.517967,0.662131:-0.834667,-0.829673,-0.760957,-0.736992,-0.767549,-0.614728,-0.439016,-0.365239,-0.253769,-0.207355,-0.145212,-0.085599,-0.070052,-0.056001,0.01003:0.262606,0.242933,0.266897,0.371405,0.326277,0.354676,0.389053,0.409028,0.408492,0.43911,0.549699,0.60372,0.617864,0.59328,0.531872:-0.715457,-0.653239,-0.564033,-0.580816,-0.459752,-0.469802,-0.523907,-0.518913,-0.51132,-0.437643,-0.435208,-0.449988,-0.439174,-0.421446,-0.4327:-0.308633,-0.299812,-0.240267,-0.174326,-0.173142,-0.213423,-0.250573,-0.155075,-0.136285,-0.076184,-0.045433,-0.076517,-0.123218,-0.134137,-0.131102:0.280921,0.294789,0.176453,0.07946,0.06267,0.049893,-0.006963,-0.053332,-0.076379,-0.131974,-0.177958,-0.20004,-0.234258,-0.267237,-0.235898:-1.92E-4,-0.009864,0.004818,-0.024056,-0.128914,-0.123757,-0.165141,-0.253835,-0.271789,-0.371104,-0.432569,-0.403921,-0.350425,-0.319678,-0.312682:0.061013,0.002734,-0.05416,-0.031361,-0.106151,-0.145652,-0.091143,-0.107426,-0.146306,-0.138494,-0.067728,-0.009254,0.031578,0.059262,0.039195:-0.202913,-0.199906,-0.208282,-0.266928,-0.207156,-0.200947,-0.119482,-0.043412,-0.076299,-0.035103,-0.022788,-0.062024,-0.112091,-0.143996,-0.154583:-0.046015,-0.024768,-0.001587,-0.001471,0.082925,0.149054,0.199282,0.209,0.173046,0.117751,0.032141,-0.058394,-0.128551,-0.167683,-0.180064:3
0.540107,0.562405,0.531946,0.46796,0.433419,0.370308,0.238221,0.173458,0.178095,0.164096,0.143209,0.049052,-0.033841:0.0894,-0.010208,-0.081535,-0.103155,-0.062816,-0.044674,-0.100239,-0.162669,-0.194363,-0.12685,-0.0585,-0.063258,-0.051169:0.209297,0.193214,0.064352,0.056628,0.094472,-0.008625,-0.041022,-0.071294,-0.079359,-0.080659,-0.042846,0.09823,0.173718:-0.802844,-0.810615,-0.78468,-0.784564,-0.804994,-0.784211,-0.637105,-0.541832,-0.468986,-0.303308,-0.232466,-0.173372,-0.084328:0.057749,0.113657,0.172533,0.183527,0.196529,0.286356,0.338408,0.413526,0.510095,0.619333,0.724048,0.711796,0.734901:-0.744278,-0.724622,-0.741148,-0.696466,-0.585781,-0.509757,-0.474392,-0.443847,-0.448077,-0.47458,-0.48536,-0.473102,-0.519529:-0.128873,-0.118332,-0.067527,-0.080749,-0.05188,-0.023122,-0.020655,-0.046664,-0.039451,-0.020793,0.001627,0.036334,0.012512:0.305346,0.365374,0.323552,0.303767,0.216308,0.071533,-0.002207,-0.069443,-0.123894,-0.219263,-0.276135,-0.30279,-0.314632:-0.139703,-0.169286,-0.209894,-0.197957,-0.235311,-0.260745,-0.308052,-0.356713,-0.394372,-0.387197,-0.416283,-0.435783,-0.383392:0.036801,-0.028559,-0.044243,-0.082043,-0.117687,-0.111769,-0.168264,-0.164898,-0.140676,-0.079794,-0.0109,0.042082,0.082257:-0.115377,-0.133633,-0.131686,-0.121486,-0.081413,-0.106562,-0.082295,-0.047125,-0.0235,-0.04165,-0.053662,-0.059743,-0.116509:0.087974,0.105547,0.140734,0.150831,0.156432,0.181968,0.257236,0.274511,0.240073,0.198312,0.125222,0.014961,-0.072174:3
0.444567,0.509059,0.628796,0.736088,0.661253,0.557547,0.367005,0.311307,0.392415,0.342302,0.21208,0.154214,0.097388,-0.018626:-0.214847,-0.164402,-0.110918,-0.389816,-0.600776,-0.623465,-0.621969,-0.604974,-0.612846,-0.580324,-0.496625,-0.536255,-0.474467,-0.452533:-0.040146,-0.127118,-0.184944,-0.105861,0.079697,0.09139,0.103311,0.11057,0.118806,0.156585,0.153572,0.187777,0.156418,0.170497:-0.631234,-0.606295,-0.537485,-0.359066,-0.36231,-0.247649,-0.202341,-0.154296,-0.016791,0.089645,0.087202,0.108498,0.124043,0.108756:0.059356,0.096096,0.120965,0.040519,0.08094,0.127357,0.212403,0.281316,0.286962,0.314758,0.382259,0.405404,0.441447,0.48555:-0.562464,-0.577947,-0.554665,-0.437515,-0.414066,-0.397707,-0.373803,-0.370274,-0.364728,-0.371547,-0.40426,-0.395647,-0.429471,-0.459441:0.19273,0.217908,0.185508,0.147783,0.126053,0.094073,0.05567,0.047593,0.040586,0.017443,0.013128,-0.027867,-0.017878,-0.018009:0.07313,0.03912,-0.012788,-0.090515,-0.116422,-0.169995,-0.205022,-0.251115,-0.312797,-0.354921,-0.360305,-0.352416,-0.356101,-0.339325:-0.39985,-0.416363,-0.379936,-0.318316,-0.374338,-0.383614,-0.403538,-0.436007,-0.405456,-0.373218,-0.37882,-0.37233,-0.369999,-0.376311:-0.116777,-0.163868,-0.205584,-0.230231,-0.177255,-0.145192,-0.137185,-0.133693,-0.132305,-0.09341,-0.047941,-0.023253,-0.016937,-6.4E-5:0.020407,0.045374,0.052915,0.023217,-0.008618,0.01415,0.02423,0.032601,0.03838,0.035995,0.026228,0.013504,0.014315,0.00227:0.218533,0.272337,0.315596,0.361031,0.390745,0.36567,0.291656,0.24103,0.176886,0.075348,-0.007286,-0.064806,-0.087674,-0.111444:3
0.621313,0.584283,0.607984,0.552618,0.492379,0.488327,0.551144,0.380105,0.138315,-0.039752,-0.129227,-0.212954,-0.333849,-0.398426,-0.471905:0.126047,0.081344,-0.039156,-0.098718,-0.167652,-0.196663,-0.315117,-0.404347,-0.378998,-0.421415,-0.487212,-0.515695,-0.497839,-0.510039,-0.509498:-0.104917,-0.156168,-0.153546,-0.139274,-0.183437,-0.236304,-0.221827,-0.131269,-0.017343,0.063525,0.158835,0.258824,0.316089,0.382268,0.435746:-0.843583,-0.858857,-0.882868,-0.875161,-0.827642,-0.776448,-0.741603,-0.666254,-0.560458,-0.380235,-0.195661,-0.088744,0.008572,0.059527,0.121029:0.182258,0.200542,0.237455,0.271696,0.306827,0.335722,0.36981,0.45803,0.475096,0.509634,0.575239,0.651933,0.653139,0.64942,0.672453:-0.824533,-0.769694,-0.707654,-0.616402,-0.558653,-0.511205,-0.445498,-0.427145,-0.366924,-0.359013,-0.399623,-0.459347,-0.489226,-0.503443,-0.467031:-0.132514,-0.142813,-0.159522,-0.171178,-0.135425,-0.113479,-0.101918,-0.135254,-0.130856,-0.05129,-0.016961,-0.0368,-0.032449,-0.018267,0.020084:0.224834,0.221558,0.240875,0.227083,0.194554,0.143135,0.083415,0.024265,-0.076543,-0.151967,-0.193236,-0.199244,-0.223746,-0.236518,-0.227658:-0.017022,-0.004812,-0.033531,-0.060233,-0.109062,-0.145187,-0.233797,-0.331277,-0.376595,-0.409165,-0.418374,-0.447325,-0.420283,-0.391943,-0.328027:0.053164,0.038996,0.011111,-0.042233,-0.103871,-0.13348,-0.161142,-0.166465,-0.15637,-0.145162,-0.072139,0.007134,0.044776,0.103623,0.147662:-0.14689,-0.157786,-0.178449,-0.189743,-0.208061,-0.217602,-0.188352,-0.132728,-0.064296,-0.054568,-0.072085,-0.074158,-0.090478,-0.119794,-0.151839:0.039767,0.009275,0.012804,0.037089,0.076782,0.100307,0.139246,0.172808,0.183292,0.111241,0.003513,-0.065447,-0.125669,-0.180247,-0.229853:3
0.973324,0.916993,0.879633,0.83748,0.47256,0.540087,0.5527,0.417217,0.295108,0.187845:-0.337384,-0.413955,-0.465775,-0.49993,-0.551169,-0.560127,-0.48401,-0.372615,-0.266791,-0.25393:-0.247533,-0.309062,-0.307144,-0.309414,-0.175566,-0.089046,-0.009919,0.042006,0.057912,0.118866:-0.872453,-0.808679,-0.776561,-0.64963,-0.659961,-0.543641,-0.39943,-0.256761,-0.117589,-0.064131:0.141342,0.211384,0.301856,0.277839,0.360884,0.352523,0.37331,0.486916,0.595546,0.580846:-0.47295,-0.394422,-0.389749,-0.359636,-0.358915,-0.372178,-0.382391,-0.447857,-0.468326,-0.422593:-0.170159,-0.193596,-0.212132,-0.20346,-0.238236,-0.218626,-0.222812,-0.229722,-0.201416,-0.161918:0.224112,0.107263,0.082504,0.050699,-0.003585,-0.062098,-0.091438,-0.102095,-0.179457,-0.265363:0.01477,-0.02967,-0.074637,-0.078773,-0.20061,-0.294837,-0.301867,-0.273775,-0.293543,-0.298328:-0.02865,-0.019272,-0.00841,-0.050716,-0.044563,-0.056975,-0.089329,-0.067126,-0.048337,0.019082:-0.103938,-0.078125,-0.081495,-0.083824,-0.044837,0.032117,0.075302,0.045298,-0.02102,-0.064442:0.115092,0.151762,0.189739,0.191822,0.184408,0.264207,0.282926,0.166245,0.041979,-0.091275:3
0.827546,0.431729,0.22583,0.158707,0.32523,0.550772,0.583335,0.548656,0.560249,0.472122,0.340555,0.262448,0.317042,0.495835:-0.199303,-0.156898,-0.167624,-0.200618,-0.263588,-0.322458,-0.219049,-0.081018,-0.184445,-0.032844,0.071084,-0.013567,-0.151409,-0.319531:0.066374,0.045148,0.010567,-0.013254,-0.050657,-0.081039,-0.209331,-0.27022,-0.20504,-0.22318,-0.09335,0.032328,0.022412,-0.036515:-0.67658,-0.664459,-0.67487,-0.673927,-0.621069,-0.530101,-0.414557,-0.298983,-0.132499,-0.149535,-0.156915,-0.109499,0.002867,0.27048:-0.11695,-0.055455,0.010915,0.060978,0.097177,0.125236,0.200367,0.264771,0.238622,0.474668,0.668057,0.693729,0.59879,0.485622:-0.611915,-0.586149,-0.545603,-0.512099,-0.472546,-0.43413,-0.4079,-0.408817,-0.382367,-0.4608,-0.434942,-0.410915,-0.464771,-0.496178:-0.146631,-0.132245,-0.12917,-0.099722,-0.049212,-0.057916,-0.075047,-0.038891,0.001127,0.003862,-0.050093,-0.073655,-0.085182,-0.061186:0.311535,0.266806,0.239519,0.240944,0.194676,0.144033,0.071737,-0.037758,-0.13026,-0.204241,-0.256706,-0.248327,-0.23996,-0.286369:0.081067,0.039578,-0.01568,-0.072805,-0.134595,-0.201467,-0.276979,-0.322948,-0.348074,-0.369697,-0.374506,-0.358127,-0.272691,-0.202169:-0.08575,-0.142682,-0.160941,-0.184107,-0.229053,-0.258388,-0.289386,-0.278166,-0.230085,-0.172067,-0.115365,-0.093347,-0.068696,-0.072983:-0.09571,-0.123627,-0.153197,-0.182602,-0.170775,-0.153061,-0.06884,0.00559,-0.004685,-0.017433,-0.024305,-0.040308,-0.112438,-0.145966:0.095946,0.116209,0.132597,0.128636,0.167419,0.186628,0.210971,0.241564,0.229043,0.169482,0.094296,0.019759,-0.067681,-0.06875:3
0.471402,0.565934,0.72918,0.670273,0.490161,0.427689,0.468415,0.47226,0.507428,0.47636,0.398791,0.26271,0.121391:0.250239,0.221117,0.114366,0.184531,0.14626,0.05756,-0.056904,-0.057275,0.046371,-0.025993,-0.102563,-0.130805,-0.174295:-0.184982,-0.21669,-0.306338,-0.289461,-0.193955,-0.163483,-0.072171,-0.032524,-0.011811,-0.025704,-0.041016,0.148367,0.388871:-0.438353,-0.507051,-0.551429,-0.572605,-0.506226,-0.456868,-0.555434,-0.57397,-0.577889,-0.405337,-0.274941,-0.319533,-0.202171:-0.051867,-0.037812,-0.005144,0.002192,-0.080363,0.006373,0.1959,0.337892,0.462667,0.42346,0.421346,0.534797,0.488016:-0.77707,-0.689965,-0.63135,-0.570221,-0.499257,-0.479274,-0.459279,-0.417779,-0.422165,-0.446428,-0.389573,-0.339098,-0.375817:-0.091551,-0.01004,0.039462,0.026447,0.041608,0.021655,0.002944,-0.039555,-0.026326,0.055686,0.09634,0.066989,0.013631:0.179628,0.223193,0.260327,0.206832,0.145674,0.13743,0.110194,0.050279,-0.013054,-0.122783,-0.210234,-0.22422,-0.239727:0.022765,-0.039119,-0.123606,-0.121709,-0.131911,-0.191003,-0.273632,-0.310513,-0.383697,-0.428656,-0.419566,-0.435389,-0.380948:-0.096356,-0.119763,-0.168683,-0.192891,-0.242145,-0.269281,-0.213096,-0.182885,-0.125103,-0.099545,-0.114148,-0.04995,2.66E-4:-0.002054,-0.032233,-0.095171,-0.108299,-0.092852,-0.121046,-0.161687,-0.157915,-0.109765,-0.037977,-0.038344,-0.069235,-0.083678:0.110016,0.08678,0.073497,0.034462,0.048683,0.136054,0.207732,0.221106,0.210425,0.165196,0.101596,-0.013754,-0.126563:3
-0.071941,-0.008456,0.114693,0.209422,0.234029,0.147556,0.099413,0.259934,0.304783,0.243419:0.081219,0.067476,-0.048027,-0.118661,-0.161816,-0.298479,-0.417938,-0.361276,-0.328606,-0.467275:0.007764,-0.104276,-0.134261,-0.108387,-0.114159,-0.125028,-0.053669,-0.038234,0.045554,0.232997:-0.413553,-0.275993,-0.268473,-0.235612,-0.205641,-0.154364,2.76E-4,0.123631,0.172595,0.164659:-0.159765,-0.043621,0.003833,0.018765,0.078129,0.175765,0.270166,0.426903,0.511786,0.492782:-0.511387,-0.459552,-0.411233,-0.399162,-0.409029,-0.327918,-0.271394,-0.36979,-0.417863,-0.373476:0.138129,0.12358,0.177868,0.193751,0.191394,0.132776,0.076462,0.065845,0.015904,-0.002985:0.056243,-0.044573,-0.106623,-0.127276,-0.167401,-0.266588,-0.278643,-0.288999,-0.338103,-0.379694:-0.241564,-0.296115,-0.355815,-0.379205,-0.405702,-0.384641,-0.382238,-0.361598,-0.309286,-0.300736:-0.154763,-0.224022,-0.261098,-0.277639,-0.209945,-0.104805,-0.097835,-0.087839,-0.021802,0.057797:0.031939,0.147049,0.139149,0.124724,0.099593,0.076404,0.091998,0.032615,-0.039588,-0.111236:0.130391,0.159015,0.23866,0.295725,0.334286,0.229262,0.111548,0.068337,0.008232,-0.071327:3
0.387923,0.37783,0.326538,0.277818,0.27908,0.295977,0.266843,0.286329,0.180155,0.040538,0.007514,-0.093604,-0.204306:0.142633,-0.072823,-0.139712,-0.160288,-0.271339,-0.285327,-0.322991,-0.410843,-0.413604,-0.38979,-0.395192,-0.402856,-0.452921:-0.038609,-0.079668,-0.074412,-0.065254,-0.039349,0.056571,0.124566,0.144081,0.161847,0.253638,0.303659,0.34045,0.429438:-0.937047,-0.741797,-0.69851,-0.746764,-0.687155,-0.589913,-0.427342,-0.339414,-0.214783,-0.067741,3.54E-4,0.054987,0.10008:0.199018,0.217513,0.269203,0.343616,0.398832,0.404362,0.409152,0.497028,0.558384,0.571265,0.549686,0.532612,0.546154:-0.49039,-0.585282,-0.566032,-0.473226,-0.489633,-0.456079,-0.413322,-0.397578,-0.39294,-0.451865,-0.483488,-0.492957,-0.447502:0.027482,0.025158,-0.001945,-0.028205,-0.039416,-0.058431,-0.083256,-0.104455,-0.079037,-0.08407,-0.063314,-0.023987,-0.006473:0.171472,0.195251,0.141592,0.066637,0.052499,-0.00264,-0.083766,-0.14457,-0.230383,-0.250398,-0.25424,-0.264367,-0.256688:-0.253358,-0.262352,-0.304521,-0.368011,-0.42972,-0.454267,-0.436615,-0.429081,-0.435644,-0.420985,-0.402862,-0.385582,-0.343546:-0.022416,-0.107103,-0.115269,-0.088782,-0.096459,-0.089959,-0.092307,-0.065868,-0.001169,0.027408,0.051361,0.084714,0.114247:-0.141447,-0.139642,-0.102433,-0.072669,-0.037182,0.019998,0.044602,0.010036,-0.013037,-0.025823,-0.055516,-0.087309,-0.115686:0.061261,0.152033,0.20395,0.209525,0.246564,0.252069,0.216465,0.121973,0.012216,-0.057096,-0.116748,-0.167147,-0.210402:3
0.50375,0.809297,0.747819,0.398349,0.485611,0.381538,0.189902,0.124529,0.122364,0.026896,-0.047593,-0.073653:0.077598,0.157902,0.086134,-0.019193,0.059635,0.051254,0.069103,0.068625,0.052966,-0.038602,-0.066218,-0.126682:-0.115861,-0.206395,-0.201262,-0.215466,-0.230109,-0.232193,-0.139609,-0.066259,-0.116541,-0.033186,0.025377,0.043972:-0.713022,-0.696541,-0.702611,-0.679889,-0.589808,-0.562631,-0.500652,-0.360591,-0.227702,-0.118989,-0.007512,0.096119:-0.022649,-0.044528,-0.038048,0.116921,0.230532,0.316284,0.360211,0.411641,0.53408,0.549501,0.572293,0.603574:-0.803377,-0.74773,-0.575559,-0.575076,-0.555124,-0.502581,-0.485943,-0.480744,-0.512234,-0.498529,-0.497908,-0.533679:0.045676,0.132562,0.127062,0.104251,0.084239,0.064363,0.080446,0.063879,0.044838,0.048404,0.04367,0.026992:0.271113,0.193788,0.084383,0.084417,0.074333,-0.008633,-0.106412,-0.153474,-0.246396,-0.292592,-0.315614,-0.314776:0.026258,-0.009323,-0.05671,-0.125199,-0.150455,-0.247056,-0.337686,-0.367111,-0.37361,-0.395898,-0.360525,-0.305868:-0.026584,-0.045402,-0.05191,-0.116669,-0.203248,-0.213854,-0.196555,-0.211322,-0.172051,-0.142772,-0.099258,-0.06679:-0.085022,-0.095244,-0.114281,-0.145682,-0.173882,-0.124394,-0.048138,0.017971,0.029873,0.046289,0.019051,-0.025514:0.184738,0.191309,0.190419,0.221709,0.24363,0.211383,0.224757,0.23911,0.206433,0.155937,0.058248,-0.042338:3
0.843274,0.911254,0.814579,0.809149,0.845465,0.762876,0.604725,0.471059,0.409927,0.331212,0.253237,0.166405,-0.052208,-0.146011:0.285925,0.219924,0.262743,0.156626,0.072443,0.024387,-0.011959,0.101299,-0.002424,-0.161552,-0.286202,-0.311593,-0.350143,-0.594047:-0.142612,-0.217983,-0.207594,-0.229346,-0.242479,-0.192414,-0.112648,-0.058364,-0.043042,-0.013692,0.070704,0.147449,0.275974,0.448643:-0.746645,-0.768468,-0.741864,-0.71665,-0.680684,-0.581741,-0.487957,-0.42757,-0.247778,-0.006072,0.17897,0.290986,0.330912,0.359705:0.14544,0.102638,0.19421,0.283934,0.349156,0.404856,0.490949,0.574768,0.673422,0.666648,0.580281,0.506487,0.476642,0.489493:-0.679366,-0.638018,-0.62272,-0.61042,-0.591131,-0.547442,-0.470228,-0.388794,-0.411143,-0.543362,-0.547102,-0.518366,-0.427291,-0.39753:-0.03134,0.078138,0.026904,0.005388,0.01346,0.018441,-0.0213,-0.027241,-0.089375,-0.049777,-0.039653,-0.029215,-0.018663,-0.006491:0.126324,0.058215,0.070735,0.052801,0.010338,-0.060734,-0.125117,-0.211724,-0.270467,-0.253362,-0.285854,-0.307748,-0.291424,-0.240877:0.018978,-0.057333,-0.037646,-0.115416,-0.232905,-0.311524,-0.316299,-0.344354,-0.300294,-0.287409,-0.245691,-0.183721,-0.10557,-0.103947:-0.012501,-0.061596,-0.085375,-0.132375,-0.164005,-0.176889,-0.192725,-0.176389,-0.111655,-0.082892,-0.063769,-0.055879,-0.054316,-0.014791:-0.207464,-0.205723,-0.241935,-0.214009,-0.157531,-0.082945,-0.039777,-0.040612,-0.057017,-0.07443,-0.104796,-0.110182,-0.099163,-0.179589:0.097581,0.133169,0.108098,0.140643,0.223733,0.279461,0.248453,0.151848,0.051225,-0.006045,-0.053988,-0.118,-0.196472,-0.193101:3
1.166602,0.920438,0.827825,0.734214,0.677307,0.579767,0.428439,0.401414,0.347298,0.232804:-0.213504,-0.271986,-0.400069,-0.340788,-0.369967,-0.398961,-0.242837,-0.213909,-0.387,-0.402311:-0.32865,-0.214644,-0.134889,-0.121021,0.028409,0.160563,0.178533,0.049933,0.29332,0.504822:-0.481546,-0.344502,-0.360272,-0.273586,-0.158696,-0.306855,-0.241158,-0.130282,0.031753,0.134418:0.014203,0.046522,0.070929,0.069512,0.153954,0.331659,0.537162,0.664337,0.491805,0.421738:-0.475785,-0.493127,-0.443173,-0.420673,-0.377667,-0.327061,-0.396955,-0.414447,-0.364077,-0.424374:0.034667,0.094439,0.068837,0.06444,0.007181,0.023703,-0.044934,-0.123686,-0.059855,-0.096157:0.14333,0.066252,-0.041727,-0.099111,-0.176225,-0.129686,-0.147518,-0.221311,-0.236444,-0.224722:-0.106612,-0.195336,-0.209383,-0.236297,-0.327468,-0.434732,-0.470637,-0.37611,-0.431211,-0.353679:-0.267087,-0.226299,-0.199837,-0.17447,-0.053792,0.01503,0.008408,0.013831,-0.004219,0.025737:-0.129335,-0.157209,-0.138236,-0.099484,0.077545,0.130416,0.04696,-0.032368,-0.002773,-0.072514:0.228376,0.331884,0.37267,0.360319,0.31954,0.206497,0.049206,0.009749,-0.020874,-0.135477:3
0.717415,0.747466,0.810211,0.82846,0.609893,0.602706,0.769958,0.809813,0.537145,0.376666,0.228622,0.178113,0.263046,0.448812,0.290705:0.133263,-0.061634,-0.163828,-0.312728,-0.415437,-0.513481,-0.517204,-0.636403,-0.770452,-0.708459,-0.692904,-0.666213,-0.52098,-0.586138,-0.707355:-0.059673,-0.078651,-0.168234,-0.126574,0.015689,0.096375,0.084849,-0.004758,0.184493,0.24052,0.258136,0.276721,0.22985,0.300488,0.506972:-0.716782,-0.707652,-0.644299,-0.61317,-0.611567,-0.580559,-0.511542,-0.221097,-0.171638,-0.208506,-0.14773,-0.007558,0.105625,0.225621,0.22023:0.026682,0.041155,0.02849,0.05037,0.137071,0.211683,0.308635,0.449632,0.508017,0.522223,0.588419,0.575869,0.561497,0.512521,0.559259:-0.695885,-0.529943,-0.475184,-0.429113,-0.389592,-0.341299,-0.335143,-0.378974,-0.315422,-0.323678,-0.38147,-0.446374,-0.488281,-0.456113,-0.406593:0.013981,-0.057132,-0.073933,-0.085637,-0.120048,-0.115521,-0.091928,-0.07739,-0.101822,-0.113983,-0.12967,-0.135849,-0.116636,-0.091665,-0.122833:0.321837,0.280054,0.247529,0.190389,0.137094,0.092394,0.060622,0.035377,-0.037856,-0.138939,-0.166581,-0.198563,-0.242611,-0.25232,-0.106664:-0.16256,-0.166845,-0.146211,-0.137586,-0.188086,-0.265554,-0.303615,-0.354526,-0.413738,-0.466978,-0.463555,-0.402816,-0.337352,-0.259904,-0.28301:-0.073591,-0.117122,-0.198464,-0.259328,-0.258331,-0.252473,-0.212152,-0.130466,-0.147027,-0.100573,-0.053021,-0.023369,-0.006909,-0.007522,-0.007336:-0.078265,-0.079429,-0.064596,-0.058469,-0.047143,-0.030442,-0.041416,-0.072433,-0.060145,-0.020202,-0.03138,-0.067305,-0.08256,-0.098848,-0.095251:0.065369,0.070355,0.094083,0.169388,0.249825,0.326786,0.312738,0.169022,0.109232,0.062909,0.006834,-0.023397,-0.03194,-0.028592,-0.084315:3
0.472134,0.416167,0.360687,0.365451,0.409847,0.418452,0.168447,0.196856,0.486249,0.415167,0.276209,0.209951,0.115426,-0.015986,0.045477:0.060641,-0.008393,-0.072634,-0.207679,-0.249859,-0.227552,-0.207174,-0.192002,-0.408134,-0.349032,-0.223026,-0.197809,-0.088791,0.019494,0.05168:0.033432,0.017531,-3.3E-4,0.075129,0.164506,0.190009,0.253496,0.347394,0.477437,0.488011,0.439012,0.500184,0.505898,0.557652,0.507912:-0.678265,-0.667906,-0.58619,-0.574942,-0.521721,-0.284071,-0.078198,0.093979,0.141395,0.044955,-0.017223,-0.027623,-0.09634,-0.07865,-0.048558:0.088008,0.182137,0.145982,0.174235,0.250332,0.260438,0.205267,0.246281,0.248807,0.352992,0.44499,0.386107,0.479864,0.504955,0.558542:-0.345462,-0.337786,-0.342086,-0.316974,-0.284422,-0.325379,-0.465643,-0.510573,-0.378367,-0.318927,-0.364924,-0.39389,-0.400886,-0.393449,-0.377526:-0.054221,-0.088113,-0.053369,-0.072603,-0.138282,-0.137452,-0.033432,0.019155,0.091941,-0.010736,-0.033252,-0.005152,-0.023805,-0.024913,-0.047406:0.094372,0.15445,0.18555,0.116381,0.059548,-0.02369,-0.082222,-0.122536,-0.271439,-0.290772,-0.242261,-0.249394,-0.307511,-0.267031,-0.230486:-0.040389,-0.095568,-0.149989,-0.225653,-0.276128,-0.24766,-0.258912,-0.307708,-0.343619,-0.353549,-0.38348,-0.362772,-0.342523,-0.319573,-0.252049:-0.186362,-0.234338,-0.30871,-0.26968,-0.243463,-0.268356,-0.138149,-0.07155,-0.014653,-0.037544,-0.091117,-0.093984,-0.017848,-0.048811,-0.060885:0.033227,0.003123,0.035256,0.020089,0.030298,0.103493,0.01526,-0.013967,-0.054973,-0.013476,0.003832,-0.031661,-0.067475,-0.071263,-0.078381:0.066772,0.098517,0.149036,0.178521,0.220205,0.249711,0.171746,0.104598,0.081871,0.001063,-0.016368,-0.046194,-0.092018,-0.089678,-0.087816:3
0.453036,0.425987,0.494358,0.648423,0.75221,0.54916,0.311602,0.226823,0.282344,0.124578,-0.040149,-0.13295,-0.161554,-0.117133:-0.015938,-0.1721,-0.1359,-0.284541,-0.372991,-0.274379,-0.219511,-0.242712,-0.270729,-0.230873,-0.073187,0.024258,-0.030873,-0.216466:-0.162128,-0.076534,-0.167517,-0.157996,-0.100064,0.030259,0.119356,0.180142,0.111039,0.250071,0.295442,0.293881,0.333524,0.370746:-0.627743,-0.723955,-0.704431,-0.712339,-0.732808,-0.683147,-0.551954,-0.364895,-0.254572,-0.231669,-0.219672,-0.15907,-0.014241,0.118116:0.00401,0.063853,0.145532,0.238907,0.355679,0.390488,0.417247,0.549905,0.659283,0.697075,0.752798,0.806684,0.788239,0.660531:-0.563334,-0.514648,-0.469438,-0.494852,-0.488275,-0.393968,-0.359395,-0.425884,-0.493659,-0.402302,-0.383785,-0.410193,-0.48823,-0.537044:-0.160298,-0.164379,-0.130329,-0.086784,-0.106715,-0.091399,-0.098112,-0.167755,-0.148945,-0.173366,-0.146974,-0.130095,-0.099453,-0.040676:0.250855,0.29122,0.231042,0.178077,0.137743,0.04683,-0.067115,-0.140426,-0.140362,-0.180304,-0.248089,-0.273212,-0.257633,-0.227777:-6.32E-4,-0.039894,-0.081023,-0.170027,-0.304068,-0.399107,-0.430431,-0.427928,-0.428188,-0.394153,-0.354496,-0.303436,-0.28787,-0.298823:-0.059452,-0.106512,-0.122979,-0.142087,-0.16674,-0.159676,-0.145979,-0.082628,-0.071813,-0.033206,0.057846,0.095715,0.090511,0.060363:-0.072872,-0.137207,-0.171922,-0.182956,-0.154993,-0.084559,-0.037551,0.019368,0.028411,-0.021929,-0.080266,-0.141778,-0.170853,-0.14497:0.08164,0.105341,0.124113,0.164458,0.20954,0.208948,0.216094,0.199307,0.164422,0.053696,-0.06872,-0.130302,-0.172116,-0.210539:3
0.303067,0.242576,0.216712,0.115204,0.120312,0.192042,0.283243,0.277756,0.242471,0.286164,0.155302,-0.082838,-0.204398,-0.241973:0.131329,0.009794,-0.157524,-0.257076,-0.300561,-0.328628,-0.371834,-0.477433,-0.489653,-0.459905,-0.511095,-0.544281,-0.536642,-0.524807:-0.075538,-0.121262,-0.159636,-0.177711,-0.189494,-0.193729,-0.200535,-0.144188,-0.114368,-0.068359,0.016181,0.123872,0.187984,0.238971:-0.736519,-0.739109,-0.755569,-0.749333,-0.721153,-0.655886,-0.507227,-0.446971,-0.316381,-0.219151,-0.091936,0.07076,0.157409,0.207357:-0.004716,0.052413,0.107813,0.159754,0.204705,0.208523,0.157669,0.23048,0.239909,0.354709,0.441821,0.468952,0.455983,0.432375:-0.754888,-0.75294,-0.710342,-0.641486,-0.596236,-0.526921,-0.39631,-0.369942,-0.335734,-0.33399,-0.362261,-0.395871,-0.427141,-0.45292:0.030892,0.027211,-0.003538,-0.021899,-0.02486,-0.035637,-0.045451,-0.042735,0.009064,0.024158,0.015448,-0.002782,-0.017176,-0.034021:0.194471,0.235089,0.264825,0.243611,0.211829,0.149773,0.029282,-0.069287,-0.194985,-0.189308,-0.170859,-0.219791,-0.270185,-0.305698:-0.033773,-0.036842,-0.032113,-0.048885,-0.097264,-0.162338,-0.181991,-0.209558,-0.262024,-0.343528,-0.400234,-0.367814,-0.326181,-0.282148:-0.059171,-0.090774,-0.112721,-0.153318,-0.193604,-0.245521,-0.345216,-0.325124,-0.222352,-0.181944,-0.160876,-0.134239,-0.104822,-0.082907:-0.023867,-0.065176,-0.107084,-0.130924,-0.130102,-0.070966,0.042185,0.034685,0.021803,0.002535,0.010719,-0.009188,-0.032302,-0.057993:0.03363,0.059962,0.083655,0.093995,0.122298,0.17934,0.242059,0.334641,0.35414,0.279607,0.12739,0.022261,-0.035286,-0.081475:3
0.493118,0.504516,0.430233,0.199667,0.065272,-0.034886,-0.083774,-0.098368,-0.27517:-0.537114,-0.544104,-0.491185,-0.524258,-0.487495,-0.492333,-0.493944,-0.493429,-0.470904:0.08426,0.07916,0.07577,0.155374,0.189049,0.252924,0.328725,0.419851,0.470527:-0.64372,-0.60087,-0.513692,-0.41761,-0.31641,-0.168649,-0.002762,0.11563,0.103976:0.266698,0.326725,0.355132,0.358502,0.425976,0.489844,0.517707,0.47865,0.537942:-0.349262,-0.342706,-0.312587,-0.292633,-0.295367,-0.313921,-0.339012,-0.373894,-0.410621:-0.119392,-0.142901,-0.138794,-0.120517,-0.099782,-0.078796,-0.047398,-0.034208,-0.050594:0.12434,0.049224,-0.097986,-0.191608,-0.205835,-0.220741,-0.225643,-0.222565,-0.235517:-0.314967,-0.311499,-0.327331,-0.365267,-0.370821,-0.34405,-0.336634,-0.319728,-0.320532:-0.32611,-0.327514,-0.237624,-0.139497,-0.124189,-0.080068,-0.045828,-0.045059,0.014203:-0.056247,-0.051935,-0.00937,0.033316,0.023849,-0.009109,-0.019352,-0.021382,-0.071704:0.247136,0.284726,0.282978,0.259043,0.174257,0.054562,-0.037776,-0.110057,-0.174321:3
0.575931,0.52696,0.558071,0.313535,0.249958,0.182391,0.130674,0.079607,0.050536,-0.003901,-0.100719,-0.250659,-0.333682:-0.0581,-0.199876,-0.323385,-0.314701,-0.313859,-0.260132,-0.294375,-0.247605,-0.169511,-0.109388,-0.123456,-0.154103,-0.174545:0.040478,0.02017,-0.045142,0.029688,0.050248,0.065995,0.145312,0.148794,0.197,0.228734,0.292916,0.326917,0.35925:-0.782311,-0.796158,-0.625077,-0.544637,-0.479192,-0.397345,-0.326386,-0.184803,-0.102416,-0.069003,-0.03351,0.065214,0.121423:0.130958,0.215876,0.172539,0.210767,0.33001,0.416513,0.537741,0.630242,0.680588,0.690093,0.686678,0.694647,0.717391:-0.414612,-0.478104,-0.484833,-0.497511,-0.524174,-0.525544,-0.518515,-0.536549,-0.562824,-0.563788,-0.570589,-0.57636,-0.565269:-0.130053,-0.128577,-0.065861,-0.052083,-0.062985,-0.003118,-0.004105,0.008753,0.01471,0.023611,-0.016191,-0.04369,-0.070119:0.261973,0.268217,0.152326,0.069796,0.011162,-0.051331,-0.07107,-0.14015,-0.169829,-0.19543,-0.207003,-0.220337,-0.206695:-0.174123,-0.218906,-0.185753,-0.239292,-0.346866,-0.463821,-0.524435,-0.505503,-0.486429,-0.468134,-0.411602,-0.357833,-0.314234:-0.159355,-0.209224,-0.285387,-0.233988,-0.175354,-0.126263,-0.136842,-0.105091,-0.068168,-0.052918,-0.025145,-0.007477,0.007316:-0.037535,-0.066122,-0.123088,-0.199254,-0.115419,-0.02411,-0.004601,-0.002213,-0.019768,-0.046931,-0.081749,-0.081815,-0.079555:0.069027,0.112847,0.240608,0.310113,0.29245,0.196774,0.146217,0.103356,0.050623,0.005483,-0.051046,-0.096263,-0.131612:3
0.660528,0.798209,0.724114,0.602364,0.52835,0.567118,0.655007,0.587444,0.367983,0.329728,0.332724,0.263327,0.146692,0.082056:-0.023513,-0.083046,-0.155616,-0.170511,-0.185113,-0.286577,-0.395898,-0.484577,-0.536944,-0.627659,-0.655638,-0.724358,-0.712194,-0.609457:0.249569,0.236953,0.132274,0.103071,0.07408,-0.006815,-0.0018,0.099209,0.22323,0.248961,0.356995,0.475796,0.494251,0.469784:-0.834548,-0.850798,-0.940372,-0.977701,-0.908238,-0.74381,-0.583123,-0.404271,-0.339305,-0.173954,-0.005191,0.059225,0.124498,0.242412:0.001118,0.045534,0.143977,0.202806,0.265532,0.327494,0.314368,0.341775,0.472724,0.508217,0.513382,0.519558,0.515036,0.484184:-0.73465,-0.653551,-0.537467,-0.520734,-0.48793,-0.441323,-0.391828,-0.344494,-0.351751,-0.360877,-0.362216,-0.348902,-0.386946,-0.433011:-0.100288,-0.113819,-0.048798,-0.03013,-0.037516,-0.071461,-0.048098,-0.087143,-0.091859,-0.074516,-0.104237,-0.104171,-0.081636,-0.049102:0.339452,0.377856,0.314683,0.286379,0.229881,0.112021,-0.044635,-0.101921,-0.105433,-0.131151,-0.182071,-0.207843,-0.220201,-0.267659:-0.099657,-0.098049,-0.249667,-0.32619,-0.376199,-0.346275,-0.343414,-0.46759,-0.548425,-0.509217,-0.424218,-0.407797,-0.382974,-0.321878:-0.012012,-0.084762,-0.087622,-0.083131,-0.109417,-0.16791,-0.201857,-0.136653,-0.100477,-0.091064,-0.026319,0.028179,0.056186,0.079585:-0.101173,-0.134954,-0.12492,-0.126291,-0.091098,-0.077027,-0.059688,0.03516,0.060424,0.016328,-0.021726,-0.065162,-0.111849,-0.154588:0.118349,0.110152,0.081436,0.075678,0.095948,0.187528,0.281766,0.196295,0.119043,0.042281,-0.055719,-0.117473,-0.160218,-0.188633:3
0.320565,0.567868,0.493001,0.35014,0.266577,0.245936,0.207729,0.191986,0.180168,0.167528,0.067213,0.029935,-0.05022:-0.040902,-0.010102,-0.054412,-0.150638,-0.253871,-0.318397,-0.266893,-0.27401,-0.33321,-0.41502,-0.372677,-0.418443,-0.384321:-0.152415,-0.176226,-0.029003,-0.01439,-0.02737,-0.023214,0.030899,0.022382,0.044374,0.147041,0.258613,0.262876,0.285407:-0.823575,-0.782292,-0.773218,-0.712051,-0.615753,-0.47867,-0.362751,-0.249077,-0.104156,-0.034355,0.008032,0.072818,0.116008:0.220594,0.284712,0.312724,0.398989,0.46588,0.53727,0.561509,0.571266,0.585818,0.636612,0.669043,0.662912,0.657595:-0.571103,-0.487659,-0.417003,-0.360107,-0.370479,-0.410202,-0.385818,-0.365027,-0.37599,-0.370295,-0.385539,-0.411565,-0.430091:-0.033471,-0.060215,-0.074478,-0.142335,-0.130122,-0.100881,-0.065936,-0.048066,-0.066454,-0.114509,-0.136156,-0.146119,-0.155512:0.223625,0.16772,0.147567,0.081737,0.023929,-0.045498,-0.131574,-0.225252,-0.253028,-0.242404,-0.254187,-0.238784,-0.246131:-0.179833,-0.210038,-0.302073,-0.323836,-0.364706,-0.427043,-0.450588,-0.417543,-0.368603,-0.360811,-0.35131,-0.309764,-0.266402:-0.125069,-0.150542,-0.142626,-0.141273,-0.165119,-0.171152,-0.171057,-0.120372,-0.079514,-0.058826,-0.019124,-0.053025,-0.052736:-0.11435,-0.090062,-0.037293,-0.03108,-0.043587,-0.032715,-0.002357,-0.00194,-0.007535,-0.018465,-0.05769,-0.071471,-0.100062:0.088312,0.137238,0.165169,0.177887,0.189068,0.198379,0.190096,0.112171,0.018708,-0.0212,-0.055389,-0.080846,-0.105407:3
0.879957,0.838093,0.82391,0.648352,0.472897,0.188614,-0.013007,-0.044965,-0.264966,-0.285629,-0.312237:0.003114,-0.183256,-0.308282,-0.273282,-0.332382,-0.354161,-0.350328,-0.387695,-0.376381,-0.440175,-0.458846:-0.076939,-0.021134,-0.047218,-0.106044,-0.082208,-0.085948,-0.109792,-0.063719,0.023104,0.085864,0.148596:-0.639252,-0.641674,-0.568107,-0.459,-0.336571,-0.246618,-0.138192,-0.101994,-0.055225,-0.022014,0.02009:-0.110175,-0.039031,0.051281,0.146464,0.203008,0.320573,0.465792,0.607393,0.657534,0.670601,0.693263:-0.504503,-0.403055,-0.356147,-0.343582,-0.299119,-0.34749,-0.418057,-0.435673,-0.44709,-0.453881,-0.479215:0.024032,-0.025615,-0.081396,-0.065099,-0.037592,0.016708,0.019006,-0.029473,-0.017487,-0.013917,-0.030836:0.261141,0.243428,0.231609,0.130847,0.01259,-0.041581,-0.085963,-0.137234,-0.218166,-0.243923,-0.239576:-0.132873,-0.191269,-0.22344,-0.196992,-0.204346,-0.324173,-0.405125,-0.43376,-0.461541,-0.468704,-0.430924:-0.293648,-0.285074,-0.325993,-0.394229,-0.399818,-0.30036,-0.237112,-0.190493,-0.110213,-0.072218,-0.038572:0.03688,-0.002781,-0.021316,0.005791,0.019234,-0.055936,-0.086732,-0.054774,-0.01582,0.003892,-0.003589:0.064665,0.086994,0.121998,0.202869,0.277684,0.27645,0.204865,0.129656,0.051488,1.74E-4,-0.060263:3
1.051461,1.040685,0.817407,0.654627,0.623607,0.553797,0.557037,0.586279,0.670497,0.668781:-0.36852,-0.493996,-0.55334,-0.538099,-0.546987,-0.6188,-0.634456,-0.655263,-0.66859,-0.739257:-0.005679,-0.081317,-0.036297,-0.055106,-0.035156,0.040922,0.093976,0.164558,0.204137,0.317675:-0.604618,-0.418561,-0.343103,-0.335755,-0.301165,-0.242767,-0.168046,-0.033998,0.116277,0.15457:0.088862,0.11101,0.20938,0.335542,0.513686,0.609931,0.646165,0.598649,0.54773,0.539927:-0.347324,-0.305446,-0.282725,-0.262119,-0.315949,-0.304163,-0.331424,-0.368784,-0.359097,-0.319415:-0.191096,-0.145239,-0.114816,-0.123044,-0.141243,-0.140518,-0.137115,-0.1655,-0.184864,-0.218528:0.161382,0.046641,0.002187,-0.032766,-0.024253,-0.048665,-0.046286,-0.073707,-0.118919,-0.097973:-0.026202,-0.106468,-0.301237,-0.406624,-0.457571,-0.470326,-0.456571,-0.389983,-0.357611,-0.365947:-0.409728,-0.328558,-0.183747,-0.178278,-0.211082,-0.213371,-0.214735,-0.179383,-0.151106,-0.114078:-0.138274,-0.151864,-0.160584,-0.099374,-0.058128,-0.047601,-0.053021,-0.063441,-0.051961,-0.027965:0.21353,0.237867,0.175099,0.14186,0.159399,0.141509,0.110842,0.059226,0.031916,-0.038965:3
0.276812,0.304615,0.296316,0.405486,0.722733,0.78046,0.620749,0.412447,0.284841,0.289663,0.26548,0.017893,-0.147463,-0.263767:0.040146,-0.137895,-0.369705,-0.352062,-0.439555,-0.494872,-0.713058,-0.646383,-0.554479,-0.546346,-0.571631,-0.477699,-0.403351,-0.465408:0.088842,0.078746,0.04684,-0.0059,-0.085069,-0.10201,0.029421,0.025004,0.012913,0.024009,0.101016,0.12839,0.120383,0.169577:-0.80542,-0.800225,-0.751817,-0.714321,-0.659306,-0.596807,-0.483024,-0.424138,-0.320628,-0.168411,0.017274,0.110292,0.163034,0.227422:-0.057851,-0.048971,8.77E-4,0.077253,0.141576,0.172237,0.211988,0.306349,0.439205,0.502377,0.514816,0.557613,0.570193,0.561204:-0.546187,-0.514158,-0.497249,-0.495069,-0.483307,-0.405367,-0.337116,-0.366662,-0.391685,-0.380447,-0.376898,-0.443847,-0.476851,-0.474725:0.03653,0.014486,-0.027155,-0.030429,-0.006966,-1.39E-4,-0.055777,-0.053035,-0.035257,-0.057905,-0.099974,-0.066307,-0.053257,-0.065256:0.16776,0.164006,0.155018,0.139505,0.068888,-0.035985,-0.088579,-0.12259,-0.150765,-0.180899,-0.206121,-0.227047,-0.254746,-0.260207:-0.011435,-0.003956,-0.006064,-0.052462,-0.145278,-0.255054,-0.398569,-0.459444,-0.507461,-0.4554,-0.360381,-0.335884,-0.310805,-0.278156:-0.179479,-0.215273,-0.262541,-0.301251,-0.286083,-0.179943,-0.09968,-0.118288,-0.140319,-0.159348,-0.120102,-0.091145,-0.084813,-0.062669:-0.089869,-0.119396,-0.146885,-0.12743,-0.10838,-0.065352,-0.010113,0.039224,0.073655,0.070148,0.017095,-0.002153,4.7E-4,-0.032171:0.193236,0.218653,0.255447,0.288981,0.350923,0.335587,0.266843,0.258616,0.189507,0.118434,0.039872,-0.060635,-0.130244,-0.160819:3
0.436376,0.574705,0.38459,0.262566,0.224862,0.193176,0.189651,0.266833,0.211596,0.129647,0.106663,0.122875,0.031977:0.078889,-0.082328,-0.281731,-0.410672,-0.505442,-0.572397,-0.650108,-0.687129,-0.719668,-0.782723,-0.78187,-0.776041,-0.761005:-0.228641,-0.228037,-0.212291,-0.105311,-0.015776,0.062092,0.10078,0.117907,0.265296,0.345266,0.380559,0.392734,0.37988:-0.659975,-0.621624,-0.564302,-0.536587,-0.499887,-0.402551,-0.300618,-0.17729,-0.185206,-0.106831,-0.024117,0.01976,0.081225:0.028792,0.064787,0.095603,0.153664,0.238368,0.318834,0.410916,0.45634,0.505634,0.504458,0.493956,0.496319,0.501163:-0.516601,-0.468812,-0.386136,-0.324799,-0.312858,-0.334796,-0.374759,-0.401904,-0.396862,-0.414596,-0.432572,-0.437647,-0.467185:-0.100063,-0.129587,-0.155332,-0.218034,-0.212753,-0.136505,-0.098588,-0.070135,-0.13528,-0.165337,-0.171582,-0.169845,-0.166807:0.299855,0.303356,0.237886,0.16766,0.062063,-0.053105,-0.083435,-0.118933,-0.136322,-0.162149,-0.20094,-0.22506,-0.230311:-0.087075,-0.136569,-0.174398,-0.188847,-0.236397,-0.317688,-0.408176,-0.479407,-0.470292,-0.416483,-0.368883,-0.345513,-0.296615:-0.176211,-0.170665,-0.207211,-0.276595,-0.284265,-0.188161,-0.123435,-0.108327,-0.094479,-0.070788,-0.051754,-0.04587,-0.062372:0.035142,0.006074,0.002518,0.006265,0.010118,-0.045403,-0.04562,-0.006699,0.01497,-0.018896,-0.036744,-0.049797,-0.080788:0.029055,0.081998,0.130405,0.168645,0.244901,0.317485,0.273919,0.183088,0.08494,0.018914,-0.014759,-0.031205,-0.056707:3
0.470457,0.553491,0.46509,0.347138,0.266798,0.168469,0.248179,0.140874,0.036607,0.19203,0.118686,-0.06694,-0.261595,-0.391591,-0.435367,-0.445716,-0.497836:0.156992,0.058552,-0.160662,-0.199526,-0.235486,-0.238105,-0.164035,-0.32046,-0.354565,-0.325703,-0.199775,-0.156883,-0.114157,-0.023184,0.049099,0.00739,-0.014792:-0.327779,-0.326716,-0.230322,-0.228454,-0.256847,-0.280041,-0.261508,-0.111456,-0.050856,-0.022427,0.045105,0.130698,0.214512,0.253696,0.268958,0.323009,0.35045:-0.637829,-0.646306,-0.600809,-0.518759,-0.485315,-0.477218,-0.397631,-0.279135,-0.153235,0.04694,0.168121,0.220041,0.244125,0.2915,0.29123,0.331568,0.401629:0.077648,0.146261,0.134649,0.203482,0.32142,0.425307,0.435771,0.506537,0.593163,0.554095,0.563201,0.5851,0.598939,0.592775,0.587575,0.561786,0.556245:-0.624435,-0.570383,-0.474753,-0.449908,-0.473245,-0.494639,-0.497466,-0.484823,-0.472096,-0.45868,-0.537327,-0.580925,-0.603588,-0.606728,-0.558815,-0.563199,-0.595684:-0.083579,-0.08153,-0.100546,-0.075639,-0.021099,0.033859,0.036423,-0.024667,-0.038774,-0.049656,-0.012557,-0.016847,-0.007633,0.007752,0.018995,0.06934,0.10427:0.054267,0.038188,-0.025825,-0.058946,-0.07408,-0.109302,-0.134183,-0.152216,-0.168919,-0.191771,-0.22914,-0.248642,-0.240825,-0.235989,-0.257478,-0.230022,-0.192331:0.17258,0.142069,0.129302,0.027442,-0.139828,-0.299707,-0.313206,-0.359642,-0.372277,-0.29744,-0.267891,-0.26336,-0.272192,-0.237215,-0.167434,-0.165196,-0.158645:-0.120078,-0.166447,-0.22309,-0.26327,-0.263433,-0.247677,-0.279692,-0.234946,-0.239018,-0.24478,-0.186531,-0.127101,-0.110463,-0.101233,-0.051585,-0.025627,-0.037637:-0.149145,-0.18985,-0.21433,-0.209452,-0.16649,-0.099283,-0.052925,0.017597,0.03467,0.052154,0.007762,-0.007322,-0.010918,-0.023221,-0.05971,-0.068749,-0.090329:0.058381,0.101245,0.194825,0.246473,0.259156,0.250076,0.247082,0.172048,0.113181,0.015201,-0.064029,-0.150736,-0.18692,-0.220797,-0.266449,-0.299107,-0.287307:3
0.501937,0.322234,0.335903,0.308691,0.259389,0.269822,0.284546,0.121716,0.010009,0.037627:-0.254571,-0.205478,-0.249757,-0.267536,-0.300067,-0.335055,-0.406414,-0.489968,-0.474249,-0.548013:0.138899,0.111748,0.052976,0.025283,0.027431,-0.008815,-0.030327,0.018409,0.078116,0.206315:-0.776787,-0.792538,-0.760347,-0.708546,-0.605561,-0.550385,-0.476918,-0.393918,-0.297683,-0.102634:-0.123485,-0.035957,0.074212,0.088787,0.103467,0.176896,0.257646,0.328726,0.411375,0.381091:-0.672805,-0.605011,-0.627342,-0.601594,-0.559839,-0.506325,-0.440111,-0.33539,-0.264377,-0.242311:-0.050941,-0.059453,-0.034208,-0.020684,-0.032219,-0.00506,-0.033706,-0.078645,-0.098879,-0.091002:0.294695,0.258737,0.271885,0.233496,0.13257,0.026599,-0.044194,-0.157978,-0.231498,-0.285943:-0.096542,-0.122167,-0.168176,-0.183908,-0.193311,-0.264233,-0.312773,-0.307734,-0.290457,-0.241242:-0.065558,-0.110915,-0.184828,-0.215298,-0.187298,-0.177939,-0.203617,-0.174978,-0.129093,-0.111455:0.001542,-0.014587,-0.046078,-0.050325,-0.014667,0.010559,0.011137,0.0294,0.035141,-0.010218:0.121952,0.132545,0.211419,0.241652,0.244889,0.26295,0.291813,0.231173,0.13054,0.041372:3
0.204297,0.424248,0.389266,0.256771,0.143734,0.049348,0.131812,0.079597,-0.022431,-0.055119,0.077456:-0.342137,-0.50551,-0.561724,-0.640265,-0.675111,-0.665621,-0.676851,-0.76911,-0.769903,-0.764363,-0.739598:0.005248,0.069106,0.095896,0.115255,0.131812,0.144842,0.131549,0.217216,0.369738,0.448348,0.440496:-0.79581,-0.831015,-0.824975,-0.713751,-0.598742,-0.421898,-0.177964,-0.030574,0.035986,0.089674,0.167647:0.143087,0.210771,0.288288,0.306435,0.320856,0.298661,0.316246,0.38768,0.459371,0.536771,0.587295:-0.621124,-0.526772,-0.47513,-0.436148,-0.38576,-0.334629,-0.319679,-0.307354,-0.319293,-0.353689,-0.436896:-0.089121,-0.125239,-0.160147,-0.171013,-0.183808,-0.147917,-0.12891,-0.144953,-0.128466,-0.099832,-0.092105:0.3447,0.318754,0.302965,0.215497,0.124198,-0.011696,-0.135202,-0.174592,-0.183479,-0.185295,-0.148792:-0.157286,-0.245569,-0.343153,-0.379465,-0.380673,-0.37042,-0.379883,-0.408013,-0.412862,-0.395774,-0.353946:-0.093912,-0.149151,-0.197781,-0.210966,-0.24407,-0.231506,-0.224596,-0.161335,-0.063544,-0.025822,-0.030839:-0.16682,-0.118547,-0.071762,0.017443,0.024099,0.011229,0.066522,0.052276,0.004265,-0.033586,-0.101216:0.133851,0.149058,0.159962,0.228121,0.264681,0.295802,0.2167,0.095103,0.001818,-0.051839,-0.069457:3
0.379748,0.411375,0.495953,0.580772,0.471845,0.443725,0.456174,0.430017,0.314381,0.157937,0.07527,-0.075811,-0.187839:0.352781,0.270148,0.185146,0.042297,-0.138248,-0.218284,-0.249443,-0.15222,-0.077467,-0.0496,-0.098744,-0.112497,-0.079445:-0.346528,-0.379518,-0.439301,-0.434075,-0.273333,-0.191936,-0.177221,-0.191669,-0.049676,0.094864,0.184292,0.276177,0.315809:-0.661536,-0.689085,-0.709853,-0.684276,-0.580666,-0.517017,-0.428787,-0.32083,-0.260257,-0.240171,-0.128107,-0.013459,0.078839:0.204712,0.262971,0.30195,0.283359,0.200808,0.280043,0.379327,0.560273,0.636357,0.591969,0.620816,0.630157,0.643293:-0.895842,-0.804203,-0.709252,-0.614542,-0.510361,-0.447959,-0.4781,-0.608355,-0.523115,-0.456784,-0.490078,-0.480163,-0.497231:0.024099,0.003125,-0.027146,-0.069824,-0.082469,-0.068853,-0.032553,-0.037758,-0.03434,0.046359,0.054959,0.02721,0.020659:0.125581,0.108877,0.095609,0.09991,0.147004,0.026357,-0.091498,-0.141796,-0.241842,-0.306818,-0.281393,-0.314837,-0.339317:0.064844,0.028091,0.00286,-0.042349,-0.181977,-0.275107,-0.333164,-0.396878,-0.439673,-0.476867,-0.436383,-0.368498,-0.349596:-0.00832,-0.024349,-0.043208,-0.100279,-0.19003,-0.208659,-0.179372,-0.094987,-0.044453,-8.01E-4,0.001251,0.031751,0.047666:-0.200431,-0.221393,-0.226776,-0.163615,-0.072613,-0.047693,-0.059772,-0.048554,-0.011889,0.016942,-0.012198,-0.054616,-0.058168:0.139206,0.129423,0.097496,0.078514,0.140873,0.243615,0.333551,0.31492,0.200039,0.08626,0.003001,-0.098155,-0.147762:3
0.242699,0.305639,0.390425,0.427273,0.249287,0.144606,0.051841,-0.02101,-0.066762,-0.098366,0.022494,0.117453,-0.091796:-0.062605,-0.095272,-0.14575,-0.139346,-0.201608,-0.235774,-0.224326,-0.211742,-0.246373,-0.288995,-0.399651,-0.371652,-0.234453:-0.071707,-0.132562,-0.166484,-0.174256,-0.138529,-0.099211,-0.038727,-0.059409,-0.01404,0.003652,0.008294,0.005082,0.049454:-0.732564,-0.692532,-0.669554,-0.640968,-0.555497,-0.487322,-0.441502,-0.349169,-0.214181,-0.077197,0.066236,0.20058,0.220653:0.079824,0.132082,0.18405,0.191478,0.161179,0.203606,0.303102,0.461389,0.529967,0.591307,0.591112,0.537546,0.607633:-0.772949,-0.682037,-0.618818,-0.589677,-0.565251,-0.562579,-0.516704,-0.494485,-0.443583,-0.446684,-0.454592,-0.453275,-0.521074:-0.025713,-0.006755,-0.029326,-0.021708,-0.001261,-0.012687,0.008352,0.07991,0.078619,0.046496,-0.001404,-0.06332,-0.072971:0.256324,0.203826,0.169683,0.132431,0.049003,-0.023636,-0.109449,-0.164361,-0.204862,-0.236723,-0.270232,-0.301143,-0.293347:0.031102,-0.002004,-0.020409,-0.04921,-0.084719,-0.153516,-0.283865,-0.407614,-0.426389,-0.399915,-0.326742,-0.223252,-0.20475:-0.0799,-0.177713,-0.262242,-0.293903,-0.28259,-0.218546,-0.121284,-0.14616,-0.1859,-0.174862,-0.145622,-0.146314,-0.084783:-0.130514,-0.160063,-0.176021,-0.164215,-0.140283,-0.082676,-0.005207,0.022966,0.024424,-0.008001,-0.039572,-0.042965,-0.079611:0.106782,0.113072,0.146953,0.17572,0.240137,0.283188,0.244135,0.196216,0.159308,0.110246,0.032483,-0.051058,-0.116421:3
0.847285,0.851994,0.959322,0.90458,0.672411,0.670857,0.519365,0.365173,0.237601:0.074357,-0.210291,-0.364886,-0.429542,-0.438457,-0.458527,-0.440685,-0.405859,-0.380412:-0.535942,-0.319156,-0.084491,0.079065,0.081846,0.066657,0.117727,0.169069,0.217266:-0.413348,-0.317904,-0.36572,-0.419942,-0.347215,-0.185475,-0.161352,-0.061506,0.092553:0.036287,0.024366,0.091905,0.16535,0.231982,0.224023,0.330669,0.37664,0.349855:-0.547849,-0.504317,-0.504816,-0.444935,-0.420885,-0.385995,-0.335496,-0.314113,-0.327374:0.007471,-0.010064,-0.00613,-0.038427,-0.027209,0.051507,0.025711,0.033157,0.067663:0.109911,0.05959,0.017497,-0.055987,-0.133429,-0.250385,-0.291771,-0.365677,-0.423553:-0.108764,-0.19428,-0.221084,-0.245371,-0.294151,-0.321337,-0.365459,-0.347164,-0.30694:-0.220606,-0.166893,-0.19842,-0.207807,-0.186764,-0.163103,-0.10501,-0.036499,0.010367:-0.08029,-0.074887,-0.083504,-0.055074,0.022922,0.02338,-0.006639,-0.038235,-0.046209:0.170725,0.222502,0.306235,0.381554,0.36562,0.304883,0.147827,0.002297,-0.122471:3
1.185688,1.115726,0.951992,0.99149,0.960064,0.951986,0.939223,0.869404,0.813912,0.718923,0.571658:0.064233,0.20524,0.207633,0.233358,0.314703,0.195946,0.034792,7.88E-4,-0.01304,-0.11101,-0.131312:0.145229,0.025671,-0.09623,-0.138328,-0.123796,-0.193892,-0.29666,-0.287971,-0.1518,-0.030003,0.071848:-0.547276,-0.785868,-0.768626,-0.807866,-0.859429,-0.699619,-0.470766,-0.37611,-0.320091,-0.264997,-0.186998:-0.230043,-0.07687,-0.028943,0.04395,0.119031,0.258916,0.35858,0.462808,0.543373,0.520349,0.534051:-0.511974,-0.531134,-0.474239,-0.392435,-0.302933,-0.350453,-0.491044,-0.529409,-0.515642,-0.465404,-0.458026:9.62E-4,0.066052,0.11501,0.106451,0.118965,0.116181,0.115575,0.070406,-0.006295,-0.027573,-0.052167:0.249961,0.239834,0.154671,0.051131,-0.088767,-0.13466,-0.12303,-0.158167,-0.213246,-0.247013,-0.267051:-0.037909,-0.17168,-0.216891,-0.254939,-0.255468,-0.281294,-0.350527,-0.388429,-0.412368,-0.423491,-0.395098:-0.132973,-0.091681,-0.128715,-0.15409,-0.161637,-0.170847,-0.204175,-0.198961,-0.126478,-0.079566,-0.048682:0.01058,-0.053708,-0.064735,-0.084225,-0.107745,-0.135129,-0.139541,-0.105916,-0.064213,-0.029118,-0.006634:0.062445,0.013627,0.044848,0.088579,0.166133,0.212588,0.266354,0.267962,0.207339,0.125586,0.042236:3
0.493487,0.523721,0.503687,0.328064,0.269005,0.242158,0.118097,0.182042,0.182009,0.116553,0.054011,-0.073501,-0.192102,-0.26596,-0.30839,-0.34479:0.10973,0.011435,-0.129566,-0.239161,-0.230946,-0.250529,-0.330741,-0.326893,-0.31098,-0.32869,-0.199639,-0.153996,-0.120449,-0.102511,-0.110669,-0.14342:-0.047373,-0.056992,-0.037912,0.029546,0.015954,-0.009345,-0.004234,0.006555,0.030232,0.103337,0.180435,0.272089,0.334878,0.35212,0.34796,0.379073:-0.8211,-0.850577,-0.799167,-0.794843,-0.763986,-0.66602,-0.561725,-0.441807,-0.234411,-0.136579,-0.116414,-0.049506,0.034336,0.095849,0.130228,0.15478:0.190127,0.251268,0.247888,0.253737,0.27541,0.283548,0.363943,0.389545,0.400312,0.487437,0.585032,0.640127,0.674339,0.693208,0.697476,0.683617:-0.695557,-0.713722,-0.633545,-0.511173,-0.470838,-0.395664,-0.384247,-0.397491,-0.395642,-0.40224,-0.411418,-0.484217,-0.508726,-0.52173,-0.540331,-0.539279:-0.135924,-0.135489,-0.157534,-0.182932,-0.167437,-0.115212,-0.117303,-0.087465,-0.034662,-0.013251,0.047488,0.088985,0.058596,0.042107,0.038797,0.018963:0.319546,0.320148,0.234217,0.159932,0.11622,0.01151,-0.056016,-0.137011,-0.241264,-0.265982,-0.288324,-0.270735,-0.276413,-0.275422,-0.261019,-0.228944:-0.068744,-0.087092,-0.081011,-0.121247,-0.14147,-0.173392,-0.249713,-0.299737,-0.321142,-0.375469,-0.458092,-0.491192,-0.459125,-0.432022,-0.402141,-0.349189:-0.014089,-0.032981,-0.105585,-0.155954,-0.200446,-0.239124,-0.269931,-0.241776,-0.192806,-0.13011,-0.033315,0.019081,0.028577,0.023142,0.013601,-0.006056:-0.150704,-0.194325,-0.172065,-0.13561,-0.13913,-0.148698,-0.136064,-0.069634,-0.03841,-0.061578,-0.030162,-0.023866,-0.01936,-0.009948,-0.014082,-0.027394:0.050135,0.069834,0.125021,0.17765,0.218512,0.261885,0.274404,0.296763,0.259243,0.178648,0.057615,-0.042157,-0.097493,-0.122201,-0.133375,-0.151392:3
0.385123,0.387623,0.527903,0.399388,0.292609,0.228809,0.060025,0.016197,-0.04286,-0.138269,-0.086049,0.001622,0.018479,-0.012858:-0.146529,0.004831,-0.259326,-0.540738,-0.550858,-0.482038,-0.475921,-0.488993,-0.505777,-0.482841,-0.547951,-0.563224,-0.556266,-0.548898:-0.047156,-0.089795,-0.130455,-0.021153,-0.017455,-0.06564,-0.102442,-0.066785,0.01197,0.140662,0.222265,0.316368,0.392682,0.417802:-0.676218,-0.642633,-0.59993,-0.5426,-0.475335,-0.406427,-0.272833,-0.220994,-0.134413,-0.006257,0.061504,0.139935,0.224946,0.285567:0.007068,0.095452,0.065144,0.105757,0.158185,0.194635,0.318512,0.414738,0.47967,0.501223,0.509667,0.507792,0.51001,0.506159:-0.620386,-0.581423,-0.494469,-0.426057,-0.395589,-0.342471,-0.419325,-0.44443,-0.441519,-0.41476,-0.389242,-0.408075,-0.40435,-0.394038:0.040127,-0.027384,-0.089402,-0.099899,-0.09504,-0.049163,-0.041318,-0.087816,-0.103068,-0.071626,-0.056435,-0.080647,-0.105143,-0.092858:0.258426,0.175161,0.15141,0.129306,0.06357,-0.111446,-0.159645,-0.162641,-0.183763,-0.223691,-0.20345,-0.166214,-0.167171,-0.19056:-0.147774,-0.103907,-0.110541,-0.220363,-0.265922,-0.253769,-0.322769,-0.369954,-0.392034,-0.390512,-0.361962,-0.314404,-0.281367,-0.254952:-0.157514,-0.158915,-0.169416,-0.185322,-0.242624,-0.280764,-0.19706,-0.159725,-0.12147,-0.082052,-0.09072,-0.067205,-0.037675,-0.034923:-0.093129,-0.034441,0.010387,-0.020911,-0.015643,0.038378,0.004635,0.018818,0.037842,0.05565,0.022088,-0.02332,-0.051643,-0.075017:0.170885,0.176865,0.21149,0.228791,0.23332,0.252801,0.250646,0.211147,0.105652,-0.034625,-0.081509,-0.131185,-0.181101,-0.203725:3
0.314184,0.382398,0.476752,0.628776,0.484798,0.421536,0.535997,0.789318,0.623608,0.473431,0.320688,0.123648,0.029523,0.043531:0.184592,0.099179,-0.143854,-0.440167,-0.39655,-0.445846,-0.579427,-0.776309,-0.42638,-0.184473,-0.129529,-0.01345,-0.054889,-0.001822:-0.196382,-0.284227,-0.26218,-0.145078,-0.100772,-0.038123,0.047443,0.054787,-0.103523,-0.156197,-0.10176,0.027997,0.16498,0.06471:-0.605856,-0.606097,-0.591901,-0.645729,-0.641495,-0.537646,-0.449225,-0.251492,-0.085301,-0.061678,-0.030727,-0.070748,0.043332,0.095474:-0.213254,-0.154944,-0.124343,-0.06076,0.047401,0.13963,0.232532,0.236051,0.323566,0.411727,0.473865,0.651332,0.643574,0.626956:-0.698485,-0.621982,-0.511682,-0.469982,-0.513447,-0.476912,-0.430817,-0.390447,-0.440108,-0.461824,-0.478245,-0.498071,-0.517135,-0.566465:0.035939,0.019811,-0.003602,0.0216,0.017883,-0.023381,-0.064839,-0.042225,-0.019172,-0.010614,-0.003514,-0.036568,-0.020428,0.005245:0.20445,0.195041,0.200754,0.167323,0.094987,0.015737,-0.050876,-0.184133,-0.247229,-0.296503,-0.314178,-0.312384,-0.287211,-0.291458:0.03621,0.021382,-0.087681,-0.194028,-0.176915,-0.243827,-0.346805,-0.38253,-0.399117,-0.391122,-0.384255,-0.366846,-0.338364,-0.253615:-0.069043,-0.086076,-0.097255,-0.124165,-0.183671,-0.204658,-0.181796,-0.129469,-0.110393,-0.039085,-1.92E-4,0.048229,0.067864,0.049298:0.175289,0.164093,0.119142,0.029797,0.014239,0.039745,0.045507,-0.005069,0.051472,0.04795,0.023916,-0.03447,-0.059125,-0.107426:0.034527,0.047187,0.100811,0.178838,0.269074,0.325718,0.341223,0.301337,0.238169,0.094839,-0.030389,-0.082596,-0.156998,-0.194014:3
0.891029,0.878455,0.965377,0.97299,1.047852,1.034217,0.856542,0.663833,0.529394:-0.123037,-0.16129,-0.170767,-0.166062,-0.200669,-0.419027,-0.572011,-0.609885,-0.631421:0.225527,0.170885,0.065283,0.047148,-0.068341,-0.072732,0.032634,0.108712,0.186172:-0.846797,-0.866286,-0.850278,-0.796522,-0.717163,-0.580752,-0.444015,-0.338981,-0.174727:0.132471,0.198655,0.270791,0.280929,0.279073,0.275152,0.390168,0.524342,0.51885:-0.625875,-0.60206,-0.606577,-0.496432,-0.414061,-0.421885,-0.39356,-0.372252,-0.317923:-0.178621,-0.206269,-0.163584,-0.135606,-0.137093,-0.105385,-0.195473,-0.237471,-0.201605:0.35008,0.343571,0.338752,0.267816,0.154868,0.095837,0.035871,0.005241,-0.05655:-0.157436,-0.167482,-0.197661,-0.209324,-0.199523,-0.276781,-0.334428,-0.377862,-0.415626:-0.101278,-0.105274,-0.123262,-0.183012,-0.233648,-0.2215,-0.16946,-0.148085,-0.112182:-0.12071,-0.153936,-0.2015,-0.189946,-0.173384,-0.187863,-0.131073,-0.082707,-0.026688:0.112757,0.10694,0.124789,0.15018,0.159279,0.231553,0.214093,0.135146,0.056282:3
0.301151,0.347257,0.299408,0.260817,0.258932,0.376241,0.15448,0.029142,-0.02546,-0.115147:-0.592762,-0.515353,-0.669139,-0.740615,-0.701701,-0.714511,-0.59784,-0.582958,-0.571775,-0.549142:0.15638,0.095802,0.144305,0.16282,0.141344,0.11607,0.069385,0.126949,0.207534,0.272961:-0.765473,-0.673797,-0.558871,-0.529698,-0.431243,-0.312707,-0.123061,-0.018442,0.096883,0.183343:0.07254,0.133813,0.158865,0.222024,0.266766,0.331248,0.415896,0.430832,0.420504,0.465693:-0.434564,-0.392264,-0.309973,-0.305218,-0.291811,-0.289035,-0.319115,-0.359395,-0.379006,-0.410114:-0.196727,-0.180933,-0.146647,-0.155922,-0.121186,-0.108383,-0.031258,-0.025258,-0.015192,-0.01618:0.301915,0.212392,0.083578,0.055352,-0.058712,-0.138205,-0.206934,-0.244471,-0.27232,-0.253379:-0.158216,-0.186571,-0.255492,-0.308668,-0.327745,-0.377107,-0.38956,-0.368891,-0.326184,-0.304718:-0.21333,-0.233595,-0.276738,-0.329735,-0.293294,-0.193136,-0.163859,-0.144656,-0.109947,-0.093789:-0.100951,-0.087982,-0.033544,-0.03566,-0.047923,-0.009548,-0.001435,-0.02793,-0.051307,-0.077725:0.116247,0.165806,0.21064,0.253833,0.322501,0.282938,0.16773,0.117509,0.064344,0.011507:3
0.594918,0.619423,0.639799,0.669271,0.645609,0.656147,0.542182,0.493125,0.491337,0.439134,0.329904,0.288455,0.2145,0.091812,0.102001:0.218607,0.097563,0.0351,-0.083372,-0.148162,-0.181629,-0.14577,-0.203602,-0.24684,-0.241979,-0.350721,-0.376333,-0.298556,-0.361015,-0.35541:0.182929,0.129488,0.005894,-0.068891,-0.097316,-0.093478,-0.044161,-0.005092,-0.044839,0.069762,0.173808,0.224915,0.363232,0.433101,0.38679:-0.921648,-0.904199,-0.944198,-0.892532,-0.81392,-0.760416,-0.66037,-0.517688,-0.442579,-0.382217,-0.18261,-0.043832,-0.048514,0.014634,0.097489:0.202676,0.27354,0.358743,0.420525,0.44885,0.511097,0.593859,0.627357,0.662285,0.696997,0.656064,0.621492,0.60965,0.610288,0.654699:-0.854669,-0.76266,-0.65843,-0.605515,-0.548087,-0.513452,-0.495518,-0.444279,-0.395092,-0.33806,-0.402208,-0.424934,-0.39766,-0.418314,-0.458245:-0.227145,-0.214139,-0.170914,-0.155855,-0.139605,-0.140767,-0.150939,-0.145706,-0.084229,-0.102485,-0.113799,-0.110818,-0.131437,-0.139122,-0.121235:0.331907,0.319934,0.304091,0.253897,0.191075,0.146453,0.064294,-0.033614,-0.125399,-0.152464,-0.15879,-0.183747,-0.2099,-0.198412,-0.171889:-0.119997,-0.160622,-0.189345,-0.217112,-0.250602,-0.316296,-0.38384,-0.431704,-0.477423,-0.481302,-0.436709,-0.385624,-0.353408,-0.316739,-0.260658:0.123966,0.05585,-0.007593,-0.083901,-0.157173,-0.179266,-0.155425,-0.148389,-0.117631,-0.105497,-0.083734,-0.084313,-0.045325,0.003034,0.01389:-0.121585,-0.142416,-0.205378,-0.234017,-0.248586,-0.255854,-0.206811,-0.126666,-0.090839,-0.074107,-0.050379,-0.037126,-0.053207,-0.076283,-0.098882:0.048525,0.041248,0.020705,0.070894,0.123992,0.144533,0.159496,0.173161,0.150435,0.101863,0.01915,-0.019788,-0.075408,-0.132023,-0.146666:3
1.036457,0.831356,0.742795,0.804851,0.828334,0.721911,0.626135,0.611881,0.596787,0.455696,0.384313,0.410223,0.248612,0.128025,0.064759,-0.090509:0.057159,0.055493,0.015298,-0.078085,-0.179323,-0.22533,-0.150225,-0.082943,-0.181256,-0.271921,-0.338314,-0.341833,-0.168364,-0.114587,-0.143728,-0.134556:-0.001732,0.007268,-0.042371,-0.034844,-0.055396,-0.090782,-0.090859,-0.024106,0.063238,0.130314,0.174421,0.225705,0.346236,0.375781,0.372011,0.477152:-0.816424,-0.890514,-0.890494,-0.923681,-0.866042,-0.739718,-0.667937,-0.626269,-0.497755,-0.403267,-0.179076,-0.015579,-0.069186,0.010787,0.094272,0.118132:0.182654,0.264493,0.308512,0.351168,0.393124,0.455042,0.550544,0.662102,0.666832,0.672586,0.628797,0.597293,0.719892,0.754137,0.733047,0.745528:-0.776354,-0.713842,-0.617929,-0.552876,-0.501017,-0.474116,-0.499194,-0.496443,-0.477911,-0.467837,-0.45784,-0.43879,-0.537896,-0.586355,-0.600816,-0.588329:-0.238404,-0.241088,-0.203259,-0.205298,-0.172046,-0.129704,-0.115314,-0.153841,-0.142164,-0.081965,-0.018879,-0.002201,-0.035553,-0.076796,-0.060536,-0.055938:0.284256,0.299501,0.275865,0.290588,0.222186,0.116601,0.074173,0.016987,-0.062461,-0.124132,-0.194985,-0.226624,-0.19307,-0.2037,-0.204069,-0.18869:0.00156,-0.081844,-0.14476,-0.212545,-0.24009,-0.325682,-0.39872,-0.450294,-0.505821,-0.547492,-0.512112,-0.466102,-0.445485,-0.342363,-0.307349,-0.295726:0.063667,0.069652,0.021515,-0.025737,-0.118886,-0.147628,-0.150745,-0.093368,-0.050659,0.006707,0.054095,0.062242,0.113525,0.117699,0.106859,0.117291:-0.246465,-0.232468,-0.223906,-0.211762,-0.22021,-0.224934,-0.230295,-0.202414,-0.101573,-0.058356,-0.040654,-0.040333,-0.112926,-0.197585,-0.209529,-0.214089:0.030432,-0.01508,-0.010963,-0.016563,0.078812,0.161283,0.192306,0.151241,0.123782,0.045158,-0.040732,-0.092844,-0.146455,-0.179357,-0.180866,-0.193896:3
0.648856,0.619089,0.66357,0.726437,0.730501,0.793505,0.647553,0.57615,0.527186,0.498117:0.050377,-0.03887,-0.113536,-0.164019,-0.224089,-0.232092,-0.254935,-0.463623,-0.520378,-0.520833:0.153368,0.11356,0.05522,0.038,0.010547,-0.132608,-0.083317,0.010402,0.057757,0.078638:-0.969153,-0.926972,-0.936917,-0.922259,-0.828025,-0.722721,-0.584947,-0.350922,-0.116027,0.017363:0.035453,0.069378,0.121299,0.179243,0.222912,0.241062,0.299968,0.341217,0.359212,0.375642:-0.60666,-0.593255,-0.505266,-0.398618,-0.403652,-0.440854,-0.419691,-0.388586,-0.376172,-0.338747:-8.6E-4,-0.005813,-0.055055,-0.091966,-0.047935,0.010552,-0.001924,-0.045245,-0.048138,0.013422:0.304341,0.298605,0.239656,0.177568,0.134081,0.049984,-0.068219,-0.186177,-0.262311,-0.344174:-0.159142,-0.177505,-0.177478,-0.208679,-0.262757,-0.304114,-0.312569,-0.326464,-0.365932,-0.381722:-0.001884,-0.066671,-0.092437,-0.128531,-0.199669,-0.241546,-0.215488,-0.1168,-0.0326,-0.012059:-0.040067,-0.057921,-0.063865,-0.061084,-0.061325,-0.020527,0.003668,-0.01471,-0.020826,-0.021511:0.049997,0.076893,0.08414,0.113896,0.189616,0.233671,0.299371,0.273605,0.149337,0.048372:3
0.255026,0.487676,0.565623,0.5341,0.497953,0.629371,0.651697,0.533847,0.319784:0.149177,0.119498,-0.010981,-0.111043,-0.145944,-0.230839,-0.38554,-0.310766,-0.080022:0.041696,-0.129092,-0.132827,-0.121262,-0.145676,-0.146957,-0.058199,-0.018785,-0.006623:-0.816603,-0.81501,-0.748332,-0.752166,-0.75751,-0.667611,-0.556203,-0.466923,-0.350625:-0.155711,-0.112911,-0.048824,0.064447,0.176504,0.226471,0.236049,0.287716,0.359072:-0.773834,-0.752828,-0.668811,-0.601087,-0.549381,-0.574604,-0.458826,-0.457865,-0.533159:0.212684,0.285086,0.130013,0.031668,0.008805,0.036042,-0.030645,-0.034335,0.006781:0.285153,0.220496,0.233296,0.221144,0.157482,0.095771,-0.031365,-0.104911,-0.19332:-0.07608,-0.110645,-0.028566,-0.072185,-0.162182,-0.26612,-0.285849,-0.331541,-0.365614:0.022779,0.027194,-0.082796,-0.13328,-0.138965,-0.177364,-0.215735,-0.169854,-0.046595:0.062214,0.029752,-0.018127,-0.040453,-0.037205,0.035068,0.065974,0.072321,0.086142:0.128095,0.147858,0.199191,0.222838,0.250834,0.321331,0.35469,0.349821,0.2643:3
0.305609,0.449935,0.439723,0.332051,0.233998,0.304867,0.434883,0.469186,0.348989,0.493038,0.378867,0.305709,0.288265,0.254111:0.166626,0.006186,-0.098569,-0.117336,-0.12761,-0.229387,-0.269013,-0.216676,-0.110723,-0.129708,-0.075465,-0.075969,-0.112233,-0.163531:0.097241,0.099956,0.06091,0.020439,0.002071,-0.004265,-0.082776,-0.120113,-0.082874,-0.155241,-0.19796,-0.122452,-0.066462,-0.027145:-0.73665,-0.805664,-0.830353,-0.812476,-0.768664,-0.704594,-0.578844,-0.466369,-0.440544,-0.347545,-0.139091,-0.020003,0.037717,0.086376:-0.130587,-0.050488,0.015618,0.058526,0.123271,0.188071,0.268855,0.323692,0.45515,0.550459,0.547031,0.608596,0.665235,0.639283:-0.755174,-0.715814,-0.679207,-0.657643,-0.604731,-0.511771,-0.491027,-0.496424,-0.473097,-0.494568,-0.469397,-0.491725,-0.547198,-0.595704:0.07791,0.035314,0.041463,0.05764,0.058154,0.056628,0.056945,0.052394,-0.004071,-0.017974,-0.010124,-0.042741,-0.049447,-0.023661:0.236115,0.260746,0.281505,0.257509,0.15174,0.072466,-0.005249,-0.081319,-0.154088,-0.209945,-0.315973,-0.319659,-0.278257,-0.270882:-0.106616,-0.10232,-0.135269,-0.169055,-0.224059,-0.290266,-0.342621,-0.36203,-0.370682,-0.386915,-0.320308,-0.287805,-0.286354,-0.293016:0.030716,-0.001405,-0.063753,-0.105421,-0.115498,-0.166936,-0.23073,-0.249252,-0.173091,-0.122679,-0.125003,-0.092024,-0.051419,-0.019782:-0.037027,-0.068956,-0.072739,-0.076888,-0.05184,-0.023765,-0.019506,-0.014073,-0.027624,-0.012878,-0.009286,-0.033531,-0.0767,-0.112501:0.121584,0.14966,0.180509,0.206666,0.236902,0.28141,0.314289,0.342333,0.294445,0.203681,0.130763,0.04941,-0.033815,-0.073934:3
0.385381,0.252245,0.326686,0.535274,0.566547,0.389531,0.391504,0.523975,0.562403,0.511241,0.471845,0.380904,0.338026,0.174005,0.00712,-0.10576,-0.182833:0.035296,0.051343,0.018082,-0.057096,-0.118945,-0.251372,-0.223681,-0.329407,-0.489819,-0.576606,-0.644725,-0.714024,-0.739389,-0.690649,-0.673661,-0.688979,-0.698897:-0.082487,-0.172776,-0.213458,-0.227365,-0.257718,-0.196672,-0.201264,-0.130887,-0.039095,0.027969,0.110391,0.242134,0.324857,0.368482,0.351548,0.37631,0.458316:-0.731078,-0.714438,-0.729071,-0.744837,-0.716752,-0.648696,-0.56681,-0.469196,-0.338853,-0.187213,-0.058852,0.036767,0.070375,0.154266,0.240998,0.305393,0.309248:0.151201,0.178633,0.221285,0.267168,0.343253,0.397117,0.472945,0.539413,0.536946,0.550506,0.541777,0.536647,0.57242,0.591777,0.595036,0.597401,0.60933:-0.700742,-0.669871,-0.637688,-0.601393,-0.59473,-0.535577,-0.507758,-0.419752,-0.334915,-0.301977,-0.298587,-0.318132,-0.340672,-0.380418,-0.408437,-0.417135,-0.440811:-0.092344,-0.052596,-0.039646,-0.044475,-0.042162,-0.078648,-0.103026,-0.133569,-0.110735,-0.103051,-0.091726,-0.126228,-0.167096,-0.135384,-0.048456,3.46E-4,0.00589:0.192395,0.183244,0.158359,0.131887,0.097061,0.044876,-0.008843,-0.084287,-0.126547,-0.149107,-0.145541,-0.180971,-0.190131,-0.207031,-0.213015,-0.17613,-0.129943:0.036943,0.014176,-0.012174,-0.064434,-0.158443,-0.221967,-0.246476,-0.303505,-0.361458,-0.380862,-0.379541,-0.32403,-0.290231,-0.272077,-0.259628,-0.235971,-0.218839:-0.04994,-0.082455,-0.085402,-0.085731,-0.098913,-0.134379,-0.155568,-0.170222,-0.239357,-0.255714,-0.241153,-0.171229,-0.12118,-0.063015,-0.009778,0.003306,0.013231:-0.234071,-0.275554,-0.298786,-0.302278,-0.276541,-0.233089,-0.211097,-0.137598,-0.073325,-0.04285,-0.023416,-0.038335,-0.051473,-0.061865,-0.078335,-0.10506,-0.137053:0.084809,0.080078,0.078979,0.074997,0.101755,0.158726,0.190747,0.210096,0.226508,0.200196,0.11463,0.029316,-0.02815,-0.080544,-0.106799,-0.131757,-0.151658:3
0.660505,0.875461,0.741471,0.447137,0.287206,0.215998,0.219094,0.126348,0.040817,-0.043766,-0.123458,-0.115535,-0.103144,-0.056776,0.034359,0.066982,0.014151,-0.096753,-0.152774,-0.178849,-0.208491,-0.212267,-0.134278:-0.272529,-0.203211,-0.390663,-0.345863,-0.280377,-0.286033,-0.353713,-0.30889,-0.300289,-0.296863,-0.265348,-0.27715,-0.305503,-0.371632,-0.469924,-0.517464,-0.521977,-0.488868,-0.516305,-0.549264,-0.569275,-0.610443,-0.646159:-0.299477,-0.321361,-0.195487,-0.185521,-0.174791,-0.101869,-0.067715,-0.118441,-0.102471,-0.043844,-0.024534,-0.001518,0.036447,0.08439,0.122321,0.148603,0.175988,0.196276,0.218661,0.248784,0.277779,0.308131,0.305757:-0.542866,-0.53075,-0.548592,-0.531638,-0.565991,-0.579723,-0.547035,-0.49697,-0.460384,-0.404902,-0.324317,-0.246301,-0.152684,-0.049666,0.008827,0.062429,0.116479,0.162477,0.184954,0.201329,0.212663,0.24028,0.275687:-0.073995,-0.025008,0.10877,0.088949,0.08788,0.124657,0.144096,0.198035,0.258599,0.327633,0.370573,0.432578,0.492649,0.551432,0.588394,0.595715,0.634166,0.644015,0.661288,0.681119,0.726131,0.767351,0.778687:-0.401384,-0.397078,-0.439012,-0.375142,-0.381319,-0.407435,-0.402496,-0.374277,-0.34558,-0.320674,-0.281211,-0.276914,-0.290033,-0.314541,-0.322069,-0.324935,-0.353268,-0.360692,-0.374343,-0.393182,-0.407591,-0.405512,-0.4091:0.02157,-0.006523,-0.004703,-0.050384,-0.051589,-0.044436,-0.022893,-0.016811,-0.030849,-0.039337,-0.013886,-0.013462,-0.020271,-0.051314,-0.082723,-0.112436,-0.154614,-0.173376,-0.18222,-0.186713,-0.179422,-0.187646,-0.177231:0.112002,0.075498,0.086583,0.043746,0.027484,0.027783,0.033281,-0.031536,-0.066045,-0.08934,-0.124185,-0.145135,-0.1794,-0.207732,-0.212045,-0.210931,-0.212817,-0.216765,-0.204596,-0.170423,-0.120842,-0.085622,-0.06912:0.075367,0.015477,-0.038011,-0.085452,-0.111091,-0.145442,-0.214559,-0.24714,-0.293985,-0.330757,-0.339111,-0.3515,-0.357618,-0.343189,-0.334814,-0.297126,-0.260258,-0.241587,-0.223826,-0.206648,-0.192946,-0.15807,-0.141796:-0.142889,-0.155525,-0.159668,-0.171568,-0.190891,-0.17694,-0.185546,-0.233981,-0.271843,-0.302817,-0.34024,-0.341215,-0.304854,-0.248246,-0.221814,-0.21689,-0.185245,-0.178347,-0.168572,-0.148833,-0.129752,-0.132174,-0.126176:-0.079985,-0.087839,-0.161691,-0.109421,-0.055986,-0.042056,-0.06639,-0.037647,-0.016733,-0.005352,-0.006764,-0.012891,-0.012291,-0.015317,-0.031444,-0.048636,-0.062851,-0.048913,-0.056425,-0.072784,-0.06874,-0.074045,-0.086261:0.022712,0.095936,0.233148,0.19472,0.189745,0.166642,0.142264,0.133622,0.149959,0.160126,0.145561,0.130449,0.107685,0.074054,0.061451,0.034034,-0.010029,-0.03834,-0.055314,-0.069993,-0.093732,-0.108236,-0.118348:3
0.509959,0.386351,0.468775,0.656603,0.546353,0.188519,0.199965:-0.049608,0.01683,-0.153963,-0.274699,-0.455591,-0.536002,-0.501187:0.158102,0.156877,-0.024743,-0.153219,0.076341,0.216728,0.254293:-0.787188,-0.701496,-0.497173,-0.314807,-0.205943,-0.162746,-0.048653:0.0577,0.119104,0.267501,0.242163,0.328083,0.539212,0.558547:-0.523417,-0.503677,-0.511065,-0.459309,-0.377111,-0.377635,-0.381648:0.008608,-0.017363,-0.022678,-0.00244,-0.065239,-0.094244,-0.089546:0.260585,0.239739,0.082557,-0.058315,-0.136447,-0.134081,-0.168692:-0.276093,-0.301414,-0.400205,-0.374361,-0.391358,-0.44699,-0.429687:-0.124931,-0.160539,-0.183772,-0.246718,-0.125978,-0.070789,-0.042533:-0.060812,-0.042638,0.05837,0.080333,0.080058,0.021187,-0.00871:0.114477,0.160946,0.257393,0.307473,0.236898,0.069746,-0.002902:3
0.649261,0.509224,0.374519,0.316719,0.155922,0.061117,-0.004984,-0.10708,-0.155256:-0.350042,-0.252957,-0.188915,-0.091184,0.008405,-0.003539,-0.00916,0.050289,0.030461:-0.143477,-0.177833,-0.069315,-0.006743,0.098737,0.163862,0.254195,0.338258,0.357977:-0.558243,-0.476937,-0.485599,-0.437888,-0.455601,-0.364018,-0.231491,-0.183692,-0.111278:-0.046641,0.056214,0.158269,0.249186,0.375794,0.411985,0.436084,0.460111,0.444784:-0.517727,-0.532097,-0.488903,-0.476331,-0.381113,-0.333709,-0.329074,-0.331578,-0.377583:0.127807,0.134911,0.099971,0.091467,0.033994,0.006081,-0.01303,-0.040613,-0.032756:0.103785,0.011058,-0.056561,-0.103931,-0.176282,-0.260801,-0.305776,-0.321431,-0.300158:-0.190967,-0.254149,-0.338855,-0.370959,-0.372283,-0.368427,-0.357236,-0.309953,-0.294413:-0.263383,-0.242579,-0.191928,-0.156841,-0.137934,-0.12873,-0.101496,-0.070757,-0.090121:-0.007764,0.021647,0.062824,0.091854,0.057484,0.047187,0.026497,-0.050102,-0.076675:0.209166,0.230582,0.238777,0.224263,0.1417,0.071339,-0.001702,-0.056587,-0.079713:3
0.945619,0.848678,0.74592,0.785374,0.660927,0.533278,0.500277,0.476048,0.500636,0.492911,0.374743,0.268458,0.156585,0.075874,-0.062994:0.132719,0.075512,0.025291,-0.025555,-0.116857,-0.051361,0.069887,0.052636,0.040291,-0.018796,-0.046079,-0.067354,-0.058449,-0.091514,-0.15889:0.242173,0.317367,0.288049,0.234314,0.175161,0.013512,-0.015738,-0.022292,-0.076455,-0.057093,0.065037,0.160558,0.32085,0.375495,0.434812:-0.567142,-0.773326,-0.784974,-0.751222,-0.772428,-0.709144,-0.66539,-0.565156,-0.436201,-0.321575,-0.239249,-0.154443,-0.115812,-0.032358,0.04669:-0.343944,-0.141321,-0.060891,-0.060883,-0.049657,0.142025,0.297397,0.375497,0.494513,0.590206,0.614273,0.621742,0.645682,0.699963,0.708043:-0.651499,-0.671619,-0.640206,-0.547382,-0.498302,-0.542214,-0.53264,-0.520012,-0.532462,-0.519751,-0.496923,-0.524582,-0.482773,-0.508728,-0.50369:-0.03184,-0.015667,0.019259,0.043944,0.034435,0.088459,0.094016,0.149185,0.147381,0.080486,0.064387,0.06364,0.01951,-0.026333,0.020421:0.311059,0.350849,0.366187,0.289721,0.212955,0.090715,0.014198,-0.075375,-0.150272,-0.186882,-0.224022,-0.266582,-0.290228,-0.225408,-0.176011:-0.154435,-0.197586,-0.250039,-0.266764,-0.262257,-0.33793,-0.37345,-0.449221,-0.495513,-0.481256,-0.48463,-0.477391,-0.469341,-0.41056,-0.367597:-0.062321,-0.06314,-0.116658,-0.155727,-0.143546,-0.157087,-0.169612,-0.159103,-0.148738,-0.122242,-0.062707,0.021123,0.066983,0.060803,0.097039:0.120228,0.031612,-0.016952,-0.046647,-0.03785,-0.039741,-0.071275,-0.042473,-0.044503,-0.041009,-0.007221,-0.020828,-0.032623,-0.059399,-0.064498:-0.00483,0.01679,0.032874,0.0523,0.06523,0.170551,0.231494,0.253194,0.233806,0.178204,0.051877,-0.042485,-0.100917,-0.126051,-0.172347:3
0.659939,0.641048,0.616719,0.672074,0.706956,0.54403,0.60829,0.63402,0.418851,0.28395,0.18446,0.033688,-0.0741,-0.128381,-0.116456:-0.054208,-0.118455,-0.054755,-0.125343,-0.25635,-0.308937,-0.380015,-0.331409,-0.36263,-0.418639,-0.417905,-0.432711,-0.47535,-0.447314,-0.406193:-0.245361,-0.343844,-0.337289,-0.309606,-0.302367,-0.307973,-0.301918,-0.253671,-0.188287,-0.118648,-0.067287,0.032794,0.145634,0.184655,0.204815:-0.877839,-0.790454,-0.749688,-0.639944,-0.513879,-0.413502,-0.281909,-0.183813,-0.128967,-0.056836,0.032367,0.070253,0.131203,0.206027,0.26568:0.107139,0.12306,0.117531,0.146507,0.22153,0.273241,0.179739,0.12067,0.313473,0.443185,0.473506,0.522043,0.534807,0.518912,0.505339:-0.701066,-0.629944,-0.573017,-0.517272,-0.48734,-0.439625,-0.365208,-0.352447,-0.411201,-0.441447,-0.455393,-0.473923,-0.463347,-0.482101,-0.517374:-0.01827,-0.018061,-0.001041,-0.026695,-0.062848,-0.079488,-0.094665,-0.028354,-0.070517,-0.092132,-0.066707,-0.064101,-0.056844,-0.047355,-0.052795:0.227511,0.187153,0.13562,0.058846,-0.006678,-0.062443,-0.12412,-0.231356,-0.227408,-0.24246,-0.293478,-0.271251,-0.269123,-0.276541,-0.270098:-0.019894,0.008564,-0.048078,-0.095162,-0.147164,-0.195755,-0.194051,-0.192921,-0.258792,-0.283525,-0.298754,-0.329414,-0.313642,-0.277145,-0.236211:-0.044647,-0.148103,-0.196638,-0.240288,-0.298204,-0.349423,-0.360904,-0.302691,-0.150341,-0.140398,-0.11559,-0.064524,-0.048591,-0.054198,-0.066456:-0.085033,-0.096032,-0.035296,-0.004488,0.014602,0.05069,0.074031,0.102156,0.056746,0.014414,-4.07E-4,-0.015349,-0.051999,-0.077113,-0.100545:0.111664,0.13934,0.15675,0.222073,0.284633,0.27502,0.283814,0.286746,0.196346,0.137919,0.080672,0.007079,-0.063837,-0.115434,-0.147918:3
0.357399,0.187605,0.235704,0.397875,0.385402,0.306452,0.311398,0.40174,0.619698,0.828353,0.861483,0.530696,0.274948,0.072724,0.078265,0.073977,-0.002347:-0.202992,-0.191349,-0.26328,-0.435987,-0.528466,-0.558224,-0.603648,-0.572573,-0.363519,-0.270461,-0.435731,-0.345395,-0.153917,-0.109622,-0.191564,-0.291745,-0.329467:0.225954,0.112292,0.109292,0.175955,0.185397,0.200082,0.232368,0.200131,0.110779,-0.091177,0.086993,0.273972,0.398381,0.522133,0.512837,0.54578,0.565593:-0.815643,-0.776565,-0.791755,-0.817476,-0.781765,-0.683145,-0.552941,-0.446936,-0.334538,-0.042545,0.108189,0.058432,-0.065662,-0.069865,-0.012302,0.031053,0.069497:-0.088697,-0.084555,-0.04559,0.010514,0.1036,0.152278,0.230727,0.307176,0.392504,0.357204,0.379439,0.478136,0.630957,0.669492,0.691083,0.669188,0.650819:-0.781712,-0.730926,-0.638959,-0.531332,-0.471829,-0.432308,-0.40116,-0.396169,-0.433098,-0.396293,-0.351458,-0.356262,-0.441497,-0.413354,-0.443068,-0.420043,-0.414494:-0.069645,0.00687,-0.00304,-0.073414,-0.085493,-0.086695,-0.081759,-0.067461,-0.040998,-0.006846,0.019668,0.012068,-0.012253,-0.028069,-0.048064,-0.062111,-0.046299:0.348864,0.302673,0.294793,0.285689,0.244622,0.177577,0.0752,-0.019498,-0.090991,-0.217258,-0.266982,-0.268194,-0.245399,-0.235101,-0.184309,-0.170896,-0.167424:-0.117249,-0.091899,-0.11256,-0.175264,-0.285286,-0.332644,-0.416152,-0.515404,-0.544377,-0.501723,-0.472035,-0.450811,-0.471929,-0.46553,-0.43996,-0.402548,-0.383793:0.023681,-0.030348,-0.104983,-0.172983,-0.230735,-0.263467,-0.244321,-0.194381,-0.149248,-0.051508,-6.13E-4,0.03386,0.117885,0.125783,0.12178,0.132893,0.136377:0.041576,-0.013727,-0.055692,-0.058288,-0.046952,-0.051312,-0.008068,0.057492,0.082366,0.010633,-0.024134,-0.017531,-0.058727,-0.107028,-0.114281,-0.105453,-0.109891:0.156223,0.151812,0.165042,0.186099,0.227387,0.256551,0.266047,0.246345,0.220941,0.131177,0.001781,-0.086727,-0.167774,-0.169214,-0.168459,-0.179525,-0.191915:3
0.423486,0.29007,0.386318,0.429051,0.436389,0.502334,0.37219,0.284001,0.328148,0.419814,0.327478,0.122439,0.026483,0.045824:-0.210054,-0.239766,-0.319787,-0.345069,-0.324045,-0.408365,-0.464109,-0.507615,-0.582791,-0.686832,-0.738761,-0.667297,-0.531051,-0.503119:0.256219,0.181359,0.112465,0.121043,0.084343,0.062222,0.131449,0.168994,0.220181,0.285708,0.358635,0.417417,0.429874,0.380413:-0.949897,-0.930408,-0.851954,-0.830916,-0.762827,-0.590089,-0.537345,-0.471026,-0.351508,-0.184124,-0.002766,0.077905,0.136944,0.189148:-0.025279,0.007917,-0.00501,0.022115,0.053147,0.065374,0.132812,0.145857,0.198487,0.255045,0.31221,0.391788,0.438131,0.428847:-0.638159,-0.614443,-0.57777,-0.570186,-0.57282,-0.471882,-0.375057,-0.323743,-0.290311,-0.273624,-0.282742,-0.303028,-0.355746,-0.382448:0.020051,0.051505,0.070161,0.079678,0.097417,0.083375,0.048269,0.019328,0.018163,0.029021,0.022134,0.002043,-0.016702,-0.008539:0.379201,0.383724,0.335501,0.302612,0.23699,0.062978,-0.084549,-0.134391,-0.191084,-0.226108,-0.287132,-0.34035,-0.349855,-0.364653:-0.261012,-0.269411,-0.277883,-0.324728,-0.34314,-0.327556,-0.375386,-0.386915,-0.408486,-0.429947,-0.388627,-0.362731,-0.337055,-0.294787:-0.004253,-0.064373,-0.133051,-0.156844,-0.171085,-0.194167,-0.210469,-0.202218,-0.128514,-0.04936,-0.012338,0.057564,0.07594,0.061861:0.03405,0.010747,0.019845,0.028747,0.048748,0.101883,0.091899,0.100817,0.08184,0.022354,-0.048734,-0.071249,-0.088346,-0.110936:0.049255,0.084606,0.135936,0.177571,0.202654,0.250778,0.309605,0.32008,0.26663,0.155374,0.032049,-0.063966,-0.138673,-0.170652:3
0.592295,0.648353,0.670852,0.702519,0.594231,0.599277,0.500612,0.355682,0.506391,0.523492:0.182164,0.060699,-0.036315,-0.150705,-0.241331,-0.346353,-0.319691,-0.286552,-0.291721,-0.111912:-0.005639,0.004406,0.012367,-0.059079,0.062191,0.115727,0.217471,0.350669,0.423952,0.401524:-0.702271,-0.697171,-0.676682,-0.504903,-0.524826,-0.539012,-0.358998,-0.158581,-0.007826,-0.113576:-0.094608,0.059408,0.126251,0.057709,0.041465,0.115551,0.173548,0.262487,0.338239,0.426826:-0.794047,-0.760732,-0.710559,-0.647569,-0.439481,-0.407053,-0.434103,-0.478634,-0.408823,-0.370942:0.127735,0.118804,0.071436,0.071516,0.024686,-0.03257,-0.027971,-0.015483,-0.00892,0.02214:0.284923,0.275943,0.223725,0.081596,0.074253,0.049665,-0.04968,-0.074654,-0.21694,-0.295687:-0.131838,-0.207174,-0.236913,-0.20785,-0.201938,-0.224462,-0.226289,-0.238193,-0.294323,-0.448738:-0.01561,-0.067657,-0.117949,-0.125384,-0.271228,-0.272065,-0.239157,-0.167347,-0.090505,0.025334:1.76E-4,-0.017679,0.022957,0.057327,0.049148,-0.007915,0.042418,0.029914,0.002575,0.028251:0.131501,0.214291,0.252282,0.283447,0.306817,0.341068,0.353581,0.265846,0.110656,-0.063306:3
0.431445,0.533511,0.65353,0.622154,0.68508,0.648215,0.619035,0.540705,0.264383,0.103927,0.119311,0.30296,0.297353,0.251671,0.141509:0.302207,0.23775,0.151327,0.07085,0.046385,-0.004444,-0.057006,-0.089082,-0.125504,-0.451054,-0.397057,-0.115907,-0.056172,-0.122641,-0.083658:-0.085034,-0.219045,-0.221599,-0.195817,-0.249525,-0.189594,-0.18162,-0.185529,-0.075639,0.041552,0.110112,0.193437,0.252062,0.309422,0.359774:-0.852825,-0.811612,-0.745349,-0.709119,-0.704046,-0.728598,-0.688251,-0.494195,-0.350647,-0.227689,-0.130439,-0.069266,0.027175,0.073602,0.130158:0.050466,0.074622,0.14698,0.318244,0.387816,0.422008,0.48372,0.559913,0.663896,0.653079,0.699411,0.737541,0.734359,0.723408,0.687508:-0.753013,-0.740434,-0.747973,-0.67277,-0.661747,-0.584952,-0.545842,-0.537224,-0.49604,-0.434486,-0.427838,-0.505668,-0.609946,-0.619174,-0.620374:0.027733,0.069035,0.016118,-0.019972,0.013177,0.039957,0.046542,0.0093,-0.045369,-0.069075,-0.066623,-0.064662,-0.073712,-0.068177,-0.024628:0.162801,0.155835,0.212466,0.190888,0.123858,0.079275,0.039019,-0.054285,-0.119898,-0.145059,-0.140118,-0.172727,-0.183842,-0.177945,-0.195212:-0.038891,-0.039107,-0.033695,-0.124593,-0.232137,-0.342626,-0.393479,-0.388806,-0.413801,-0.407051,-0.396179,-0.367259,-0.332405,-0.32965,-0.299357:0.04323,0.009147,-0.040703,-0.114039,-0.108906,-0.121926,-0.151028,-0.170514,-0.159278,-0.131913,-0.12444,-0.037831,0.031857,0.042148,0.056839:-0.117636,-0.147845,-0.20481,-0.215643,-0.172235,-0.123042,-0.125672,-0.118401,-0.111191,-0.079553,-0.065786,-0.103381,-0.146766,-0.147674,-0.161363:0.087302,0.097876,0.143879,0.217136,0.251917,0.27114,0.267792,0.263479,0.227163,0.109629,0.071556,-8.22E-4,-0.083076,-0.098427,-0.11758:3
0.83051,1.078536,1.056156,0.907242,0.870992,0.959646,0.912247,0.902255,0.815314,0.660903,0.376106,0.315463,0.381318,0.40339,0.301672,0.272333:-0.002024,-0.18869,-0.341192,-0.508153,-0.498748,-0.314818,-0.270344,-0.299385,-0.23698,-0.111437,-0.068367,-0.159733,-0.276713,-0.279859,-0.176942,-0.15327:0.088538,-0.063062,-0.065362,0.036216,-0.004705,-0.240441,-0.287281,-0.309741,-0.276222,-0.091383,0.075266,0.093775,0.135107,0.158249,0.209991,0.272457:-0.658396,-0.646882,-0.582386,-0.684593,-0.711723,-0.601227,-0.496452,-0.460132,-0.386665,-0.257636,-0.145424,-0.034374,0.098432,0.263482,0.217673,0.264372:-0.09617,-0.146681,-0.143152,-0.03362,0.044621,0.093015,0.176848,0.267183,0.321807,0.291931,0.388598,0.471981,0.502095,0.444596,0.445917,0.39296:-0.743279,-0.699992,-0.625003,-0.494759,-0.509862,-0.53023,-0.525672,-0.489318,-0.447691,-0.354819,-0.391718,-0.436845,-0.443376,-0.43009,-0.461491,-0.442807:0.048553,0.041126,0.033994,-0.015618,-0.030364,0.078086,0.117669,0.089488,0.020599,-0.019826,-0.003133,-0.020908,-0.04581,-0.01933,-0.02121,-0.032451:0.31424,0.350494,0.325592,0.293758,0.296537,0.141824,0.01124,-0.075362,-0.158797,-0.289232,-0.31686,-0.269536,-0.245444,-0.33405,-0.324306,-0.372964:-0.137369,-0.147325,-0.162654,-0.198363,-0.258022,-0.270061,-0.273292,-0.354042,-0.389121,-0.350274,-0.383029,-0.351863,-0.280758,-0.219597,-0.232488,-0.169825:-0.025289,-0.055114,-0.082498,-0.141461,-0.185041,-0.265613,-0.266245,-0.232491,-0.195569,-0.153267,-0.081576,-0.061782,-0.020065,-9.66E-4,0.025749,0.037751:-0.059148,-0.066653,-0.075612,-0.08241,-0.068653,-0.054529,-0.101266,-0.061943,0.005214,0.102254,0.121384,0.050935,-0.037458,-0.088231,-0.099064,-0.131007:0.123436,0.101603,0.093693,0.101518,0.138577,0.262235,0.320321,0.319378,0.286559,0.204432,0.086479,-0.011173,-0.107197,-0.152372,-0.206408,-0.24318:3
0.589425,0.523386,0.398583,0.379209,0.468785,0.613215,0.494599,0.346037,0.242201,0.216131,0.359527,0.358112,0.417074,0.419721,0.195552,-0.01374,-0.141825,-0.268344:0.18863,0.110413,0.031779,-0.076044,-0.095463,-0.159145,-0.228737,-0.265784,-0.305063,-0.409159,-0.557555,-0.502225,-0.486578,-0.551095,-0.477741,-0.450663,-0.51897,-0.516431:0.002332,0.046525,0.075404,0.08849,-0.046906,-0.093742,-0.017065,-0.013563,0.011567,0.084222,0.159615,0.223734,0.275733,0.310361,0.386818,0.500923,0.546316,0.554378:-0.743813,-0.778074,-0.817593,-0.806903,-0.754487,-0.729442,-0.692132,-0.624682,-0.455096,-0.270215,-0.111165,-0.016012,0.180319,0.361829,0.374625,0.342765,0.312899,0.305368:0.113106,0.140491,0.171566,0.194351,0.292945,0.364904,0.416472,0.503341,0.610208,0.615146,0.547939,0.544814,0.482836,0.37178,0.390576,0.451551,0.518629,0.572311:-0.878015,-0.800349,-0.740916,-0.667854,-0.624344,-0.601457,-0.508137,-0.39282,-0.366348,-0.345901,-0.280407,-0.309103,-0.343406,-0.336054,-0.385934,-0.429042,-0.437535,-0.455855:0.006359,-0.039694,-0.02064,0.01132,0.020178,0.010718,-0.003487,-0.041278,-0.049276,-0.066039,-0.042532,-0.067316,-0.104594,-0.054073,-0.035341,-0.042669,-0.022076,0.009392:0.281887,0.304824,0.336741,0.315692,0.242664,0.186834,0.097133,-0.022813,-0.081914,-0.144419,-0.209471,-0.18672,-0.228046,-0.304318,-0.299151,-0.228746,-0.155643,-0.120117:-0.092187,-0.122616,-0.214186,-0.292509,-0.307481,-0.352335,-0.452433,-0.46985,-0.490125,-0.482347,-0.441149,-0.424803,-0.351677,-0.288135,-0.230298,-0.190452,-0.198876,-0.208327:0.007153,-0.027075,-0.075914,-0.132988,-0.172933,-0.215742,-0.192867,-0.15273,-0.157416,-0.125019,-0.073815,-0.045922,-0.012328,-0.01314,-0.013234,0.006582,0.041647,0.065587:-0.152793,-0.158547,-0.171238,-0.170282,-0.190782,-0.180112,-0.104584,-0.074976,-0.066825,-0.034882,-0.042268,-0.044167,-0.066926,-0.078074,-0.108594,-0.153124,-0.177828,-0.198848:0.118165,0.099857,0.097765,0.105766,0.151706,0.220185,0.245316,0.199702,0.156875,0.105571,0.056656,-0.062079,-0.13103,-0.157592,-0.166253,-0.181001,-0.212905,-0.232426:3
0.808542,0.894269,0.87474,0.687301,0.679988,0.519217,0.443574,0.376554,0.328759,0.291456,0.272372,0.202625,0.096161,-0.06954,-0.190853,-0.185984:-0.029669,-0.143238,-0.2417,-0.226162,-0.186097,-0.216887,-0.347954,-0.507277,-0.599007,-0.57633,-0.464621,-0.410527,-0.441796,-0.346849,-0.241598,-0.25567:-0.108267,-0.159701,-0.1272,-0.065611,-0.040169,-0.007413,-0.013241,0.026118,0.108212,0.157746,0.143393,0.181312,0.284056,0.348866,0.413662,0.464685:-0.82366,-0.760707,-0.770613,-0.739912,-0.68577,-0.572169,-0.45731,-0.312013,-0.181821,-0.088318,-0.008063,0.068111,0.180008,0.195726,0.196807,0.2117:0.074612,0.065646,0.133717,0.213085,0.262309,0.311027,0.454866,0.521101,0.536656,0.556239,0.580711,0.581325,0.573101,0.615049,0.64932,0.629854:-0.724408,-0.625373,-0.564114,-0.529334,-0.527296,-0.44024,-0.355826,-0.307853,-0.305153,-0.353862,-0.449324,-0.49676,-0.469828,-0.498768,-0.515829,-0.496781:-0.09786,-0.136753,-0.164416,-0.135447,-0.059652,-0.050675,-0.05961,-0.067756,-0.112203,-0.136776,-0.127505,-0.106133,-0.073847,-0.069888,-0.047924,-0.034551:0.306985,0.257874,0.26082,0.23836,0.196209,0.088539,-0.020139,-0.085754,-0.123841,-0.147935,-0.165284,-0.182048,-0.203256,-0.182409,-0.177888,-0.168449:-0.035487,-0.006748,-0.075758,-0.167426,-0.236216,-0.26771,-0.349215,-0.412319,-0.43326,-0.413705,-0.356563,-0.324555,-0.259818,-0.246971,-0.239741,-0.204683:0.008744,-0.04074,-0.13222,-0.194585,-0.211224,-0.179838,-0.155131,-0.175373,-0.156876,-0.11865,-0.100597,-0.044245,-0.011215,-0.001531,0.027375,0.035381:-0.170591,-0.18071,-0.136654,-0.095645,-0.090577,-0.081921,-0.093772,-0.088342,-0.052707,-0.056776,-0.086697,-0.091248,-0.095906,-0.103402,-0.148935,-0.193707:0.048472,0.055168,0.097171,0.178642,0.238763,0.220653,0.175136,0.125245,0.073807,0.023018,3.01E-4,-0.059478,-0.110404,-0.147777,-0.170137,-0.191762:3
0.546442,0.561831,0.53545,0.503923,0.617328,0.589804,0.488477,0.411921,0.326376,0.228452:0.048596,0.023117,-0.053437,-0.177061,-0.258904,-0.227491,-0.187526,-0.177921,-0.190031,-0.093734:0.108241,0.066014,0.060651,0.096058,0.13021,0.111239,0.073818,0.056107,0.114095,0.179984:-0.753359,-0.705731,-0.651105,-0.598681,-0.544268,-0.461558,-0.317266,-0.11799,-0.024976,-0.023549:-0.044055,0.003615,0.025335,0.061382,0.085267,0.189712,0.353383,0.525075,0.626571,0.680505:-0.744411,-0.700867,-0.667123,-0.616941,-0.46066,-0.36163,-0.339916,-0.361121,-0.401045,-0.472584:0.099557,0.073635,0.066442,0.048977,-0.00835,-0.038855,-0.004101,0.004317,-0.027864,-0.026861:0.257036,0.241984,0.199604,0.156862,0.134162,0.044919,-0.075594,-0.179239,-0.196305,-0.234007:-0.218009,-0.221594,-0.253394,-0.308096,-0.355799,-0.371643,-0.345029,-0.351355,-0.371438,-0.348872:-0.136259,-0.196996,-0.230759,-0.245794,-0.301151,-0.331245,-0.323197,-0.200997,-0.114953,-0.043776:-0.002814,-0.001075,0.019203,0.034372,0.049784,0.11711,0.1189,-0.002577,-0.039774,-0.050367:0.071432,0.088259,0.112663,0.151674,0.183795,0.207371,0.195262,0.153542,0.053447,-0.068556:3
0.467387,0.415464,0.465051,0.432231,0.462539,0.476048,0.354798,0.323518,0.352272,0.371314,0.289688,0.255186,0.261357,0.192579,0.115838,0.043856:0.392927,0.333631,0.21531,0.118967,0.058659,-0.032883,0.06821,0.006606,0.028593,0.056433,0.007498,-0.029645,-0.018139,-0.070169,-0.133627,-0.36787:0.142906,0.086782,0.102102,0.148698,0.19416,0.215777,0.200822,0.103352,-0.028331,-0.055269,0.045308,0.092475,0.066379,0.114305,0.1618,0.226387:-0.519943,-0.57568,-0.65089,-0.684645,-0.629358,-0.594734,-0.610321,-0.404817,-0.312443,-0.254033,-0.171226,-0.087786,-0.005674,0.067103,0.102634,0.133157:0.079642,0.12107,0.135373,0.165758,0.217233,0.271665,0.33305,0.396774,0.545842,0.620715,0.642197,0.690875,0.779852,0.763828,0.760081,0.701491:-0.817738,-0.775999,-0.666271,-0.599605,-0.54961,-0.458985,-0.307984,-0.28596,-0.351373,-0.429136,-0.416574,-0.487325,-0.607686,-0.608155,-0.579751,-0.483818:0.01404,0.068774,0.088227,0.09709,0.055669,-0.00138,-0.011458,-0.012682,0.031533,0.066386,0.036386,7.41E-4,-0.002857,0.014386,-0.006045,-0.028684:0.179195,0.190267,0.173553,0.173908,0.176486,0.079879,-0.141206,-0.213712,-0.268088,-0.306897,-0.319938,-0.295061,-0.268911,-0.265402,-0.242859,-0.216641:-0.18431,-0.216449,-0.259679,-0.32256,-0.354417,-0.357226,-0.334582,-0.262215,-0.360255,-0.41738,-0.400629,-0.380346,-0.367523,-0.369662,-0.342354,-0.299124:-0.054081,-0.098076,-0.140923,-0.173624,-0.253361,-0.290494,-0.232933,-0.255114,-0.156285,-0.056741,-0.003634,0.03326,0.044928,0.039081,0.028412,0.019938:-0.077447,-0.11129,-0.117837,-0.118042,-0.090469,-0.039087,-0.015311,-0.112114,-0.119014,-0.084558,-0.086283,-0.112021,-0.136656,-0.114894,-0.11497,-0.100403:0.155267,0.154785,0.139936,0.156745,0.201189,0.238515,0.219941,0.273793,0.205165,0.143685,0.060355,-0.004044,-0.006441,-0.031276,-0.053535,-0.085671:3
0.767089,0.639514,0.586641,0.562357,0.646778,0.400302,0.212698,0.125042,-0.012344,-0.057548,-0.077688,-0.150415,-0.226966,-0.27378,-0.278597,-0.337335,-0.384846,-0.40802:0.095595,0.015729,-0.096142,-0.149413,-0.18212,-0.160716,-0.050118,0.061655,0.080507,0.111556,0.106024,0.056202,5.88E-4,-0.028457,-0.058155,-0.067174,-0.079797,-0.12906:0.163542,0.139808,0.145786,0.22218,0.28324,0.334631,0.272668,0.281444,0.367011,0.445858,0.498968,0.584603,0.634262,0.625894,0.639126,0.649064,0.640409,0.658516:-0.543858,-0.556727,-0.584456,-0.570649,-0.410676,-0.394053,-0.355727,-0.338894,-0.243641,-0.160145,-0.144896,-0.07178,0.01342,0.064697,0.081719,0.098055,0.114077,0.121399:0.058456,0.136229,0.210095,0.274573,0.289562,0.447278,0.583674,0.64556,0.595218,0.624977,0.682647,0.687829,0.689301,0.722604,0.741775,0.751315,0.76041,0.752045:-0.615795,-0.57631,-0.548796,-0.449938,-0.365997,-0.416628,-0.45207,-0.440561,-0.381611,-0.415214,-0.411535,-0.415167,-0.436459,-0.462562,-0.46513,-0.444332,-0.455245,-0.470122:0.078271,0.036612,0.040429,0.042339,0.008958,-0.016765,0.029129,0.072806,0.090978,0.057647,0.022764,0.03707,0.047506,0.055188,0.028211,0.023846,0.026767,0.037321:0.155446,0.159534,0.13889,0.068987,-0.033092,-0.084771,-0.102774,-0.176682,-0.211617,-0.24585,-0.286034,-0.261653,-0.197916,-0.155334,-0.143725,-0.140534,-0.123748,-0.093415:-0.151634,-0.180176,-0.323783,-0.493187,-0.487426,-0.51881,-0.575188,-0.597247,-0.528086,-0.451151,-0.43548,-0.46385,-0.448684,-0.411678,-0.383958,-0.357645,-0.325307,-0.305707:-0.213122,-0.250834,-0.262658,-0.223313,-0.194656,-0.12794,-0.098708,-0.027967,-0.012314,0.033654,0.099301,0.112994,0.097494,0.105048,0.109603,0.111394,0.099701,0.083333:-0.132949,-0.171242,-0.109744,-0.009103,0.032908,0.064652,0.01578,-0.034759,-0.052386,-0.116781,-0.150885,-0.122309,-0.094145,-0.102612,-0.116785,-0.123009,-0.149392,-0.176419:0.244398,0.26225,0.282419,0.274824,0.295585,0.268548,0.214142,0.121954,0.017175,-0.057545,-0.102976,-0.127921,-0.134493,-0.134889,-0.153208,-0.171284,-0.172366,-0.17397:3
0.276026,0.121937,0.282279,0.36387,0.271404,0.292796,0.4883,0.420535,0.335801,0.343757,0.332205,0.288029,0.161922:-0.169026,-0.272249,-0.384905,-0.396881,-0.435482,-0.573319,-0.654155,-0.787892,-0.750028,-0.652926,-0.574091,-0.470676,-0.307634:0.02704,0.076235,0.074486,0.042182,0.050652,0.108777,0.141469,0.218867,0.212574,0.182011,0.194092,0.157781,0.083035:-0.70821,-0.694435,-0.670298,-0.613273,-0.51897,-0.494292,-0.366619,-0.169798,-0.026546,0.14555,0.232516,0.262391,0.27442:-0.056931,0.038107,0.099353,0.06361,0.115568,0.215048,0.215709,0.199741,0.221874,0.191264,0.226824,0.243576,0.260889:-0.653781,-0.630145,-0.57169,-0.50747,-0.422402,-0.392906,-0.335847,-0.275604,-0.259897,-0.232846,-0.280385,-0.32534,-0.375672:0.150414,0.090202,0.079875,0.078295,0.025863,-0.019034,-0.00806,0.065616,0.05287,0.043644,0.064976,0.07832,0.084131:0.232766,0.203671,0.183877,0.13014,0.015293,-0.025606,-0.168021,-0.368714,-0.428923,-0.509249,-0.553348,-0.552773,-0.53131:-0.180232,-0.228608,-0.349625,-0.349498,-0.36396,-0.456743,-0.434386,-0.402419,-0.366204,-0.275229,-0.268691,-0.267633,-0.245122:-0.017699,-0.006737,-0.106237,-0.170965,-0.177679,-0.156575,-0.114994,-0.064959,-0.028617,-0.021671,0.046061,0.085175,0.088505:0.012131,0.023805,0.011063,0.019656,0.061655,0.102792,0.109846,0.031906,0.026473,0.02642,-0.033713,-0.080666,-0.110324:0.130671,0.138189,0.188383,0.222553,0.236054,0.230794,0.239434,0.189154,0.054353,-0.082516,-0.140772,-0.172356,-0.198792:3
0.580121,0.471607,0.466493,0.611135,0.563828,0.439344,0.323985,0.228305,0.22841,0.198588,0.189629,0.084346,-0.022524:0.00637,-0.035123,-0.015096,0.036256,0.001659,-0.088595,-0.043288,-0.094531,-0.178601,-0.089415,-0.309836,-0.314042,-0.315674:0.193946,0.219365,0.192321,0.090213,-0.043402,-0.131211,-0.055777,0.023346,0.043066,0.142657,0.278484,0.342269,0.382668:-0.672667,-0.770729,-0.781761,-0.856806,-0.843409,-0.580115,-0.437661,-0.301036,-0.169819,-0.129082,-0.016073,0.028273,0.063742:-0.066814,0.052114,0.122471,0.159691,0.265307,0.347546,0.502104,0.580163,0.648386,0.759222,0.684126,0.712905,0.729098:-0.560562,-0.534149,-0.475423,-0.35662,-0.33284,-0.379997,-0.38618,-0.408646,-0.451139,-0.471838,-0.478049,-0.490932,-0.53555:-0.032386,-0.060067,-0.048855,0.012737,0.043627,0.051569,-0.029637,-0.038085,-0.010381,-0.028217,-0.062531,-0.073553,-0.057606:0.341026,0.366987,0.320039,0.13952,0.027036,-0.048538,-0.089789,-0.140041,-0.168587,-0.190079,-0.182582,-0.180278,-0.132813:-0.172262,-0.244971,-0.30772,-0.372593,-0.438327,-0.46728,-0.471464,-0.505208,-0.528645,-0.493838,-0.452635,-0.439542,-0.40854:-0.209097,-0.195117,-0.210179,-0.157268,-0.120857,-0.159518,-0.169354,-0.126956,-0.086358,-0.017266,0.053418,0.053298,0.049692:-0.019026,-0.058543,-0.066796,-0.086167,-0.111059,-0.054379,-0.028537,0.014907,0.022831,-0.051906,-0.067282,-0.071182,-0.109546:0.041786,0.036576,0.0565,0.042951,0.079703,0.133221,0.144635,0.1009,0.082104,0.026107,-0.118629,-0.132554,-0.138601:3
0.707889,0.627659,0.499002,0.399139,0.315763,0.334036,0.327185,0.254825,0.191843,0.060523,-0.073191:-0.100922,-0.06276,-0.071079,-0.241454,-0.295425,-0.38218,-0.470092,-0.211245,-0.098863,-0.114179,-0.010051:0.07366,0.014961,0.055249,0.11335,0.107049,0.104048,0.109187,0.083626,0.032353,0.139281,0.279898:-0.700594,-0.67672,-0.687276,-0.626805,-0.515065,-0.468691,-0.399629,-0.255467,-0.130581,-0.100633,-0.190642:-0.12199,-0.053602,0.051308,0.132453,0.193741,0.219107,0.241949,0.335095,0.459061,0.529452,0.597746:-0.641534,-0.612218,-0.524841,-0.469094,-0.423867,-0.383486,-0.364452,-0.381719,-0.451423,-0.431678,-0.316064:0.01216,0.024829,-0.019906,-0.067043,-0.089628,-0.069835,-0.044185,0.006305,0.029687,-2.38E-4,-0.041749:0.294513,0.260416,0.206343,0.117982,0.025261,-0.048184,-0.129708,-0.194067,-0.261851,-0.267939,-0.329851:-0.06959,-0.113063,-0.133993,-0.173991,-0.227016,-0.272903,-0.268999,-0.305323,-0.351448,-0.378521,-0.343277:-0.171439,-0.214072,-0.266033,-0.310972,-0.330753,-0.326816,-0.323109,-0.28615,-0.148094,-0.12908,-0.036866:-0.027618,-0.03894,-0.059437,-0.032045,0.010341,0.003443,0.005648,0.039561,0.03895,0.044402,-0.006854:0.123416,0.124756,0.164918,0.251694,0.288242,0.326003,0.364399,0.346218,0.199272,0.132587,0.01424:3
0.348821,0.439543,0.732423,0.737641,0.587877,0.537347,0.46113,0.494958,0.399235,0.212765,0.161026:0.35859,0.320683,0.280853,0.150703,0.075757,-3.02E-4,0.022787,-0.091901,-0.017868,0.049035,0.027386:0.22001,0.123945,-0.085813,-0.040752,0.072267,0.13997,0.170731,0.225211,0.282595,0.351223,0.360731:-0.80547,-0.810175,-0.752229,-0.753928,-0.628486,-0.607301,-0.616281,-0.47402,-0.329103,-0.115571,-0.03435:-0.194775,-0.152229,-0.124727,-0.120963,-0.064451,0.018866,0.111975,0.156874,0.254735,0.323217,0.417253:-0.752879,-0.682058,-0.767036,-0.611039,-0.512074,-0.511301,-0.474397,-0.440234,-0.437742,-0.517681,-0.463333:0.14763,0.144188,0.235926,0.186147,0.12336,0.085657,0.080508,0.051341,0.078619,0.044179,0.033747:0.193879,0.196211,0.180211,0.142095,0.139313,0.146623,0.058659,-0.026636,-0.099935,-0.193209,-0.255661:-0.065525,-0.042817,-0.115804,-0.129377,-0.146291,-0.204456,-0.302482,-0.386788,-0.41749,-0.342857,-0.368926:0.044829,-0.019878,-0.048011,-0.143139,-0.265199,-0.286786,-0.219348,-0.211972,-0.170428,-0.077698,-0.064498:0.077535,0.047145,0.002888,0.038769,0.036418,0.015117,0.027664,0.112289,0.127338,0.053708,0.044011:0.02869,0.043182,0.114237,0.115713,0.183772,0.248683,0.237365,0.264488,0.258463,0.086755,0.016646:3
1.186421,1.213674,1.202263,1.23176,1.225704,1.209788,1.378555,1.345984,1.246307,1.136988,1.087832,0.959859,0.730784,0.60099,0.512012,0.507976,0.432082,0.402356,0.390381,0.302911,0.306064,0.323943,0.341106:-0.656251,-0.674691,-0.67208,-0.764323,-0.82715,-0.83377,-0.966325,-0.957924,-1.028161,-1.077329,-1.12365,-1.102289,-1.053564,-1.088298,-1.087818,-1.074915,-1.086323,-1.073623,-1.029607,-1.016956,-1.119652,-1.140921,-1.139893:0.295011,0.251351,0.198244,0.201715,0.193103,0.156209,0.185009,0.141114,0.168899,0.149559,0.158797,0.197688,0.242629,0.300837,0.360502,0.391054,0.452368,0.500798,0.531515,0.618582,0.744695,0.75513,0.743218:-0.590821,-0.613967,-0.568805,-0.590689,-0.585653,-0.541635,-0.601609,-0.554785,-0.54258,-0.481793,-0.42546,-0.3561,-0.303716,-0.257337,-0.216681,-0.209501,-0.23491,-0.224004,-0.173886,-0.158556,-0.136349,-0.112995,-0.107433:-0.358783,-0.337344,-0.371153,-0.317186,-0.263116,-0.238843,-0.150009,-0.099052,-0.054021,-0.036757,-0.01056,0.052572,0.145766,0.19707,0.207679,0.201776,0.214211,0.219425,0.177364,0.196862,0.228285,0.245911,0.259037:-0.353274,-0.322241,-0.237237,-0.212794,-0.199138,-0.160832,-0.11615,-0.074099,-0.041093,-0.001492,0.015653,0.011503,0.007686,0.040068,0.048196,0.05435,0.047948,0.04657,0.099099,0.138297,0.199576,0.203485,0.19053:-0.298514,-0.297771,-0.294298,-0.289867,-0.281971,-0.267456,-0.279789,-0.256853,-0.257175,-0.262602,-0.269687,-0.273385,-0.239585,-0.201803,-0.20635,-0.19852,-0.187596,-0.183375,-0.177696,-0.176864,-0.217453,-0.202881,-0.193909:0.167205,0.163003,0.151554,0.152122,0.14643,0.112625,0.080738,0.012692,-0.02388,-0.090677,-0.136832,-0.179691,-0.215274,-0.246383,-0.276677,-0.30335,-0.317388,-0.335643,-0.362956,-0.355999,-0.307701,-0.301802,-0.315684:0.149569,0.146068,0.162374,0.152641,0.125621,0.097855,0.023391,-0.04484,-0.108161,-0.125874,-0.160027,-0.205959,-0.257789,-0.302546,-0.322466,-0.341928,-0.351788,-0.330741,-0.283402,-0.253984,-0.238063,-0.226033,-0.229449:-0.208678,-0.215579,-0.25112,-0.280016,-0.314652,-0.34962,-0.364919,-0.402341,-0.409522,-0.401687,-0.392217,-0.371847,-0.346027,-0.342539,-0.333597,-0.305449,-0.259952,-0.216636,-0.195172,-0.149924,-0.121461,-0.11072,-0.095135:-0.067995,-0.077074,-0.10885,-0.159882,-0.193856,-0.201334,-0.191362,-0.172088,-0.147786,-0.115588,-0.065283,-0.012664,0.018172,0.02369,0.032003,0.048594,0.040337,0.025563,0.03795,0.033831,0.029837,0.003147,-0.014614:0.126588,0.121764,0.103299,0.112733,0.130851,0.14686,0.195078,0.255136,0.272667,0.283157,0.307575,0.326709,0.300194,0.245804,0.218287,0.184282,0.147558,0.116365,0.073142,0.022931,-0.040678,-0.056922,-0.070811:4
1.048705,1.094423,1.165206,1.291714,1.312871,1.381158,1.385545,1.224171,1.0423,0.841505,0.668477,0.499336,0.399042:-0.364807,-0.410847,-0.472041,-0.584246,-0.61005,-0.619273,-0.58999,-0.543328,-0.602763,-0.659199,-0.687106,-0.696349,-0.728751:0.315698,0.293615,0.256875,0.25356,0.22886,0.198867,0.153716,0.048193,0.058758,0.083833,0.123326,0.167617,0.248691:-0.707838,-0.689179,-0.709541,-0.753077,-0.729563,-0.690637,-0.638376,-0.579672,-0.574426,-0.520357,-0.481148,-0.426318,-0.386551:-0.349006,-0.366731,-0.340184,-0.288171,-0.246214,-0.187759,-0.156843,-0.122969,0.003095,0.084946,0.13634,0.189111,0.220634:-0.458071,-0.367177,-0.309414,-0.257152,-0.186269,-0.146733,-0.128975,-0.102382,-0.128741,-0.121396,-0.117251,-0.125375,-0.088963:-0.218779,-0.273794,-0.272669,-0.269839,-0.263497,-0.265814,-0.244475,-0.212963,-0.171306,-0.162612,-0.166125,-0.166258,-0.159168:0.121151,0.158383,0.170697,0.178288,0.14754,0.136283,0.106641,0.03238,-0.034194,-0.098426,-0.149581,-0.202116,-0.243348:0.216744,0.24148,0.223057,0.170277,0.11805,0.063467,0.009413,-0.021479,-0.084853,-0.141494,-0.190124,-0.220516,-0.26569:-0.166113,-0.195906,-0.225399,-0.258275,-0.314939,-0.387968,-0.437868,-0.446661,-0.445509,-0.44319,-0.416936,-0.388289,-0.365274:-0.078752,-0.094279,-0.105723,-0.119058,-0.123501,-0.130392,-0.107931,-0.075751,-0.076034,-0.037516,0.018587,0.052866,0.063216:0.236759,0.174556,0.148838,0.154284,0.175804,0.212427,0.257762,0.271295,0.316361,0.345601,0.373463,0.395464,0.360115:4
1.052541,0.944114,0.982937,0.923052,0.781606,0.634326,0.534068,0.47844,0.398717,0.30905,0.221352,0.120193,0.027318,0.055621,0.081486:-0.709708,-0.691734,-0.738926,-0.717367,-0.668166,-0.670416,-0.724525,-0.788025,-0.843681,-0.896397,-0.893465,-0.846683,-0.873569,-0.891111,-0.922806:0.275104,0.198755,0.182901,0.173234,0.188367,0.202722,0.21319,0.230149,0.256054,0.293985,0.322151,0.346892,0.417282,0.467942,0.517509:-0.632121,-0.620121,-0.659427,-0.671038,-0.674221,-0.637392,-0.586697,-0.54575,-0.490665,-0.405259,-0.293104,-0.211357,-0.189906,-0.205114,-0.207474:-0.441593,-0.381119,-0.280907,-0.181603,-0.103006,-0.041478,0.019622,0.100334,0.157701,0.172757,0.162474,0.197907,0.272272,0.277509,0.279667:-0.299923,-0.272637,-0.25232,-0.228948,-0.191798,-0.139979,-0.131437,-0.119093,-0.101873,-0.067624,-0.033024,-0.010011,0.029175,0.055175,0.065885:-0.264348,-0.249896,-0.245397,-0.244013,-0.244279,-0.227805,-0.22864,-0.266099,-0.309563,-0.342048,-0.335073,-0.313763,-0.324083,-0.342533,-0.348645:0.176542,0.159791,0.154263,0.148192,0.126757,0.06786,0.036387,-0.025885,-0.084009,-0.144625,-0.219364,-0.289185,-0.332699,-0.352537,-0.371464:0.235524,0.20427,0.140365,0.066712,-0.020667,-0.087539,-0.138366,-0.193541,-0.237117,-0.256978,-0.252231,-0.235922,-0.255015,-0.265035,-0.269942:-0.200809,-0.2419,-0.282972,-0.33142,-0.348363,-0.375274,-0.394678,-0.372996,-0.346978,-0.317963,-0.285663,-0.242541,-0.213589,-0.186656,-0.162719:-0.086577,-0.100335,-0.116917,-0.119654,-0.087642,-0.0804,-0.069684,-0.024948,0.038162,0.096101,0.131591,0.128799,0.092998,0.085749,0.073239:0.168115,0.151086,0.171528,0.200625,0.219279,0.250495,0.253992,0.264892,0.27369,0.252832,0.213856,0.161588,0.09356,0.049873,0.020084:4
0.466637,0.430895,0.40743,0.395603,0.383369,0.347605,0.386843,0.427924,0.39687,0.34317,0.272297,0.273391,0.223417,0.217827,0.272116,0.266858,0.243803,0.18904,0.132691,0.085905,0.036682:-0.174182,-0.233191,-0.293588,-0.354783,-0.415115,-0.438903,-0.48988,-0.555175,-0.590188,-0.609514,-0.596134,-0.618123,-0.63949,-0.683301,-0.735567,-0.742059,-0.759755,-0.755517,-0.733447,-0.719569,-0.731871:0.067343,0.009192,-0.004456,7.16E-4,4.55E-4,0.017194,0.059868,0.081846,0.134744,0.199085,0.223428,0.200343,0.202548,0.23928,0.278736,0.326788,0.387915,0.44768,0.505671,0.55267,0.612849:-0.714592,-0.664289,-0.643803,-0.647254,-0.618584,-0.581413,-0.53855,-0.472208,-0.416871,-0.404447,-0.39731,-0.366072,-0.359507,-0.369405,-0.354299,-0.300441,-0.247462,-0.208305,-0.194373,-0.171366,-0.156771:-0.020414,0.021457,0.048301,0.077599,0.113751,0.148189,0.178642,0.222302,0.282026,0.312566,0.334141,0.34193,0.360033,0.358311,0.338174,0.335305,0.340292,0.351136,0.36187,0.379551,0.404832:-0.530718,-0.494674,-0.444098,-0.384098,-0.330679,-0.291099,-0.259389,-0.236299,-0.213592,-0.173479,-0.151188,-0.141065,-0.123216,-0.114319,-0.127712,-0.152188,-0.149679,-0.136029,-0.137842,-0.153067,-0.15934:-0.123507,-0.100379,-0.084689,-0.07307,-0.068901,-0.082583,-0.096511,-0.106615,-0.139874,-0.171975,-0.195219,-0.195251,-0.210608,-0.206349,-0.18554,-0.19277,-0.21663,-0.234345,-0.24128,-0.245793,-0.251434:0.108676,0.083223,0.063669,0.027187,-0.024162,-0.051823,-0.077955,-0.121395,-0.170171,-0.19789,-0.233038,-0.296515,-0.334512,-0.357111,-0.359311,-0.333482,-0.286964,-0.263819,-0.253312,-0.249798,-0.228626:0.070209,0.06803,0.046819,-0.001773,-0.041785,-0.066586,-0.070057,-0.081147,-0.144401,-0.219244,-0.251383,-0.222478,-0.212586,-0.224137,-0.231917,-0.23544,-0.244574,-0.247816,-0.250112,-0.251623,-0.268278:-0.137172,-0.19158,-0.238061,-0.277752,-0.313798,-0.344016,-0.385299,-0.424069,-0.402405,-0.368538,-0.329782,-0.331659,-0.31248,-0.27358,-0.250961,-0.251804,-0.249297,-0.228492,-0.209855,-0.187974,-0.15783:-0.212119,-0.262422,-0.290567,-0.277819,-0.274629,-0.274331,-0.270649,-0.231491,-0.165567,-0.11424,-0.089764,-0.082596,-0.083377,-0.082539,-0.066763,-0.042641,-0.022791,-0.008193,-0.003023,-0.001996,-0.011538:0.131895,0.175669,0.216775,0.250199,0.280099,0.313158,0.35382,0.363088,0.362998,0.357633,0.352758,0.367806,0.351161,0.324568,0.297503,0.291012,0.2605,0.21182,0.175229,0.141047,0.093765:4
0.202009,0.215342,0.248793,0.298133,0.310019,0.320185,0.339698,0.349831,0.375142,0.422714,0.402558,0.379542,0.334032,0.312447,0.305099,0.253857,0.19242,0.133317,0.111378,0.125639,0.125941,0.123145,0.139694,0.165527:-0.125533,-0.160415,-0.212733,-0.285335,-0.341772,-0.401563,-0.443935,-0.509587,-0.563514,-0.633177,-0.673827,-0.729008,-0.761978,-0.771592,-0.77742,-0.789351,-0.799804,-0.802044,-0.813192,-0.809849,-0.79826,-0.813712,-0.835857,-0.847085:0.151161,0.105971,0.095783,0.085661,0.056967,0.03478,0.019342,0.03444,0.080826,0.149359,0.196566,0.234265,0.273383,0.339815,0.405193,0.430756,0.473544,0.544254,0.592481,0.620237,0.654431,0.690485,0.726365,0.767039:-0.811764,-0.802513,-0.822018,-0.844362,-0.816335,-0.765719,-0.707044,-0.652883,-0.616492,-0.549288,-0.456292,-0.414172,-0.401339,-0.384998,-0.325661,-0.280785,-0.2538,-0.224309,-0.205278,-0.221858,-0.213538,-0.171048,-0.131199,-0.109209:-0.073961,-0.059616,-0.026771,0.014184,0.056468,0.087688,0.107742,0.147025,0.207665,0.277195,0.324725,0.344244,0.37007,0.357632,0.356163,0.386475,0.399842,0.419397,0.456135,0.469406,0.459675,0.448614,0.437297,0.429007:-0.571221,-0.540912,-0.494476,-0.432181,-0.368245,-0.297915,-0.233294,-0.187658,-0.15,-0.140512,-0.133255,-0.114913,-0.108206,-0.120023,-0.147638,-0.147582,-0.133148,-0.093522,-0.05342,-0.027131,-0.026424,-0.030712,-0.032044,-0.04021:-0.20706,-0.196091,-0.196352,-0.197458,-0.182538,-0.170113,-0.153463,-0.164362,-0.181697,-0.20119,-0.217598,-0.227108,-0.248434,-0.241326,-0.257412,-0.285755,-0.296979,-0.303731,-0.288431,-0.266082,-0.230941,-0.215914,-0.23347,-0.253785:0.180995,0.201337,0.204866,0.170406,0.099402,0.017452,-0.056846,-0.098588,-0.117593,-0.145903,-0.189654,-0.219873,-0.266158,-0.306936,-0.320783,-0.324729,-0.312325,-0.287649,-0.273571,-0.289884,-0.307628,-0.30423,-0.290423,-0.271093:0.062343,0.06719,0.069739,0.063158,0.030906,-0.002727,-0.026006,-0.043168,-0.071376,-0.112614,-0.153564,-0.181223,-0.196817,-0.225509,-0.251279,-0.263957,-0.270349,-0.261432,-0.244972,-0.232773,-0.226445,-0.218305,-0.207494,-0.195185:-0.013538,-0.044386,-0.073397,-0.093857,-0.124702,-0.169185,-0.219099,-0.26506,-0.284622,-0.288465,-0.301576,-0.313711,-0.27239,-0.223543,-0.194969,-0.182784,-0.168333,-0.142757,-0.113243,-0.0735,-0.046082,-0.048511,-0.054559,-0.048869:-0.139886,-0.188085,-0.221303,-0.233496,-0.237928,-0.25791,-0.282659,-0.289766,-0.270452,-0.221179,-0.171779,-0.154672,-0.135871,-0.079761,-0.01213,0.025217,0.042719,0.038148,0.009891,-0.023744,-0.046282,-0.058993,-0.067595,-0.092384:0.093111,0.086005,0.083484,0.086567,0.105701,0.177372,0.262953,0.312582,0.32325,0.348614,0.374645,0.365761,0.321841,0.264375,0.229158,0.20098,0.167683,0.120615,0.073194,0.032228,0.004337,-0.016174,-0.044885,-0.076633:4
0.385138,0.404117,0.455619,0.414612,0.37966,0.344882,0.31783,0.257945,0.156439,0.091039,0.060025,-0.001071,-0.017773,0.034411,0.019009,-0.048092,-0.126608,-0.146339,-0.122065,-0.098677:-0.674578,-0.682754,-0.721622,-0.719434,-0.750607,-0.808173,-0.84824,-0.851258,-0.811168,-0.81876,-0.85136,-0.823198,-0.824461,-0.858612,-0.848206,-0.817601,-0.79844,-0.764682,-0.761513,-0.79365:0.39735,0.360637,0.382138,0.325766,0.266476,0.274401,0.311861,0.33195,0.326831,0.332959,0.408173,0.462636,0.537417,0.620475,0.638938,0.645518,0.661918,0.688762,0.728039,0.768425:-0.621713,-0.641688,-0.669222,-0.646789,-0.617582,-0.597724,-0.568986,-0.50193,-0.393332,-0.290508,-0.283568,-0.291292,-0.268017,-0.248932,-0.203482,-0.139011,-0.087654,-0.118798,-0.158638,-0.184382:-0.674309,-0.594013,-0.528702,-0.430759,-0.318289,-0.23314,-0.154713,-0.046054,0.025732,0.057793,0.09401,0.097113,0.095264,0.11978,0.15554,0.20328,0.246724,0.279672,0.306634,0.332076:-0.253673,-0.24421,-0.190582,-0.14668,-0.128958,-0.092962,-0.070639,-0.047466,-0.022686,-0.016327,-0.021601,-0.03803,-0.053108,-0.041269,0.02176,0.07137,0.074575,0.046369,0.048362,0.064815:-0.21465,-0.236342,-0.248945,-0.255549,-0.236494,-0.25046,-0.271232,-0.294155,-0.281432,-0.277203,-0.314142,-0.311443,-0.324602,-0.354772,-0.323307,-0.27979,-0.270349,-0.272775,-0.287689,-0.294023:0.222689,0.255855,0.264241,0.235405,0.181836,0.153069,0.115313,0.027504,-0.085501,-0.163165,-0.184747,-0.242438,-0.274536,-0.272163,-0.2895,-0.308685,-0.325967,-0.344981,-0.352423,-0.359523:0.17833,0.165934,0.130069,0.080096,0.026246,-0.030886,-0.088701,-0.159451,-0.220575,-0.241456,-0.255091,-0.23664,-0.217963,-0.207125,-0.181548,-0.166369,-0.15736,-0.152234,-0.152287,-0.161745:-0.194393,-0.236477,-0.264629,-0.291644,-0.335316,-0.384367,-0.398791,-0.376572,-0.360437,-0.359847,-0.32318,-0.262357,-0.203412,-0.155569,-0.136287,-0.137814,-0.138138,-0.117073,-0.091364,-0.067039:0.02075,0.012059,0.010364,-6.54E-4,-0.019588,-0.018787,-7.92E-4,0.032464,0.076213,0.087363,0.076607,0.054855,0.045807,0.038061,0.015033,-0.012973,-0.036737,-0.065322,-0.096257,-0.122864:0.173664,0.184037,0.185099,0.205795,0.236847,0.253313,0.263055,0.26854,0.271693,0.256161,0.204413,0.143309,0.081527,0.033507,-0.007966,-0.044985,-0.073465,-0.09219,-0.11963,-0.13747:4
0.280856,0.307777,0.304888,0.274917,0.297299,0.334458,0.319361,0.26587,0.24477,0.244756,0.241573,0.244961,0.219099,0.1743,0.135504,0.102954,0.080403,0.069548,0.050223,0.033022,-0.02921,-0.069773:-0.267909,-0.328611,-0.348791,-0.328105,-0.381949,-0.44658,-0.48943,-0.543875,-0.59854,-0.632159,-0.676152,-0.716675,-0.746432,-0.767399,-0.773804,-0.771648,-0.780143,-0.820355,-0.839998,-0.862719,-0.86981,-0.866063:0.355794,0.321202,0.280936,0.226919,0.203589,0.173746,0.151051,0.115471,0.103578,0.122493,0.175304,0.230824,0.266409,0.297834,0.344998,0.395311,0.448154,0.490834,0.535543,0.566015,0.619966,0.671486:-0.746511,-0.757082,-0.746788,-0.720301,-0.705535,-0.697161,-0.683135,-0.633561,-0.609059,-0.577827,-0.533089,-0.458181,-0.384764,-0.340476,-0.325634,-0.293677,-0.251275,-0.203175,-0.159097,-0.139475,-0.107281,-0.068762:-0.053324,-0.016308,0.013531,0.048265,0.088574,0.13506,0.186374,0.245773,0.302371,0.332734,0.350022,0.37399,0.413955,0.461835,0.492024,0.490925,0.489192,0.486819,0.4784,0.470372,0.47234,0.46468:-0.562096,-0.512273,-0.493801,-0.497758,-0.477414,-0.434772,-0.392581,-0.368428,-0.344758,-0.320079,-0.284323,-0.24686,-0.223235,-0.215219,-0.215984,-0.221036,-0.218657,-0.217517,-0.215463,-0.19888,-0.183882,-0.169154:-0.190323,-0.197327,-0.184916,-0.151263,-0.132476,-0.135882,-0.150037,-0.158768,-0.188986,-0.211586,-0.228818,-0.232619,-0.231098,-0.257579,-0.299507,-0.325802,-0.347661,-0.361457,-0.367039,-0.35147,-0.323483,-0.268996:0.279695,0.273819,0.273316,0.24841,0.204388,0.158707,0.118082,0.062856,0.040408,0.011104,-0.027057,-0.086289,-0.124602,-0.133631,-0.135141,-0.156093,-0.190046,-0.224863,-0.245491,-0.243998,-0.217987,-0.195687:-0.126106,-0.138567,-0.129502,-0.129411,-0.137477,-0.161163,-0.202389,-0.225203,-0.249963,-0.255315,-0.270127,-0.279635,-0.291371,-0.309255,-0.323744,-0.30977,-0.286453,-0.254778,-0.237634,-0.231594,-0.228485,-0.211802:-0.149951,-0.151198,-0.181846,-0.211294,-0.239334,-0.26136,-0.272771,-0.288261,-0.279733,-0.265149,-0.250327,-0.248991,-0.263665,-0.259008,-0.230854,-0.198455,-0.158473,-0.128469,-0.10484,-0.092199,-0.075395,-0.066079:-0.071486,-0.111425,-0.17327,-0.211077,-0.216489,-0.181405,-0.146665,-0.156861,-0.171792,-0.184364,-0.173304,-0.149971,-0.123624,-0.102996,-0.090215,-0.093713,-0.10656,-0.127965,-0.118581,-0.106889,-0.097974,-0.100774:0.117287,0.112947,0.137937,0.165406,0.193106,0.206457,0.210908,0.241228,0.253993,0.27652,0.290784,0.315765,0.303156,0.256605,0.205541,0.171689,0.142372,0.132355,0.114015,0.088805,0.048522,0.022765:4
0.767797,0.774028,0.786511,0.782487,0.764559,0.741473,0.724056,0.745631,0.739643,0.734534,0.709654,0.666633,0.599016,0.482231,0.354315,0.299435,0.290559,0.241283,0.175018,0.10162,0.064255,0.089721,0.044506,-0.008376,-0.093153:-0.533544,-0.493358,-0.503977,-0.521781,-0.535199,-0.540955,-0.55004,-0.60791,-0.656228,-0.706166,-0.767639,-0.829048,-0.865615,-0.832092,-0.769506,-0.725732,-0.744376,-0.778069,-0.814137,-0.822454,-0.848189,-0.871663,-0.88284,-0.89045,-0.850756:0.355356,0.254529,0.207327,0.153615,0.117269,0.124713,0.141517,0.131063,0.096899,0.062945,0.052116,0.07446,0.09261,0.122065,0.143692,0.173935,0.220189,0.261101,0.309586,0.372146,0.422412,0.485509,0.536135,0.587111,0.61905:-0.65896,-0.639928,-0.62493,-0.594022,-0.551458,-0.534643,-0.515327,-0.481804,-0.414202,-0.346586,-0.311728,-0.308765,-0.27186,-0.247661,-0.208652,-0.176325,-0.162725,-0.12694,-0.108505,-0.123249,-0.123803,-0.110724,-0.090437,-0.070927,-0.050902:-0.31444,-0.277591,-0.220911,-0.186191,-0.156557,-0.096043,-0.033975,-0.010985,0.002231,0.020119,0.052103,0.108658,0.159365,0.236664,0.325698,0.384196,0.413802,0.431896,0.430283,0.415355,0.3996,0.348229,0.342252,0.351954,0.359449:-0.513075,-0.490609,-0.449882,-0.410264,-0.362575,-0.341792,-0.328086,-0.301317,-0.266258,-0.21609,-0.182869,-0.174039,-0.14968,-0.145528,-0.147191,-0.132703,-0.11852,-0.119219,-0.109019,-0.094112,-0.093877,-0.098804,-0.099627,-0.100559,-0.102811:-0.145355,-0.081868,-0.06771,-0.050352,-0.030148,-0.008729,-0.00155,-0.008159,-0.020856,-0.046521,-0.062978,-0.079328,-0.097706,-0.101642,-0.110601,-0.131889,-0.168219,-0.201867,-0.224911,-0.230953,-0.210172,-0.165226,-0.161193,-0.169464,-0.164914:0.097674,0.043697,0.033166,0.00549,-0.028638,-0.053211,-0.086349,-0.119144,-0.169452,-0.225968,-0.265689,-0.292532,-0.330467,-0.37473,-0.390766,-0.390391,-0.400311,-0.407707,-0.409235,-0.425174,-0.450398,-0.466617,-0.460011,-0.435901,-0.429547:0.169759,0.194387,0.167927,0.150057,0.126601,0.083667,0.035699,0.003793,-0.007412,-0.01721,-0.037036,-0.072355,-0.089512,-0.102963,-0.133563,-0.136575,-0.128137,-0.123205,-0.129038,-0.142796,-0.15808,-0.178584,-0.185608,-0.191486,-0.181755:-0.060088,-0.098612,-0.156279,-0.212955,-0.259093,-0.287559,-0.319383,-0.348221,-0.377606,-0.398839,-0.387349,-0.350727,-0.335854,-0.284915,-0.225466,-0.218314,-0.222052,-0.220018,-0.201332,-0.152755,-0.113472,-0.086572,-0.067618,-0.053845,-0.043033:-0.235705,-0.278358,-0.315481,-0.32636,-0.344759,-0.374517,-0.377798,-0.339354,-0.284402,-0.238458,-0.22579,-0.22562,-0.208037,-0.206809,-0.196972,-0.17703,-0.165589,-0.166582,-0.174037,-0.178847,-0.165774,-0.137515,-0.124858,-0.114199,-0.106012:0.251879,0.267675,0.25525,0.263643,0.278871,0.314098,0.365654,0.392951,0.412188,0.415687,0.411964,0.419491,0.409504,0.394088,0.35647,0.333542,0.306402,0.275238,0.237779,0.178912,0.134493,0.11444,0.09446,0.072902,0.050994:4
0.664065,0.721716,0.776509,0.758245,0.789216,0.730233,0.749678,0.710451,0.647256,0.558593,0.494799,0.472846,0.461781,0.426646,0.34608,0.284372,0.254418,0.231637,0.231568,0.232597,0.211419,0.174352,0.152198,0.146869:-0.225805,-0.245889,-0.298804,-0.32627,-0.396626,-0.461858,-0.562139,-0.632577,-0.698719,-0.759492,-0.811,-0.849327,-0.857121,-0.883566,-0.900721,-0.925719,-0.955765,-0.950975,-0.961459,-0.956684,-0.93469,-0.915803,-0.900209,-0.894956:0.548138,0.504351,0.460121,0.411301,0.349971,0.276785,0.253704,0.243957,0.2321,0.233135,0.259523,0.314255,0.364523,0.418875,0.45783,0.490319,0.53591,0.584585,0.604399,0.61106,0.633581,0.658087,0.670302,0.677483:-0.80913,-0.769779,-0.765905,-0.770812,-0.781042,-0.756064,-0.741297,-0.720284,-0.677146,-0.626696,-0.585426,-0.533021,-0.470934,-0.442324,-0.406384,-0.414879,-0.422541,-0.385158,-0.34501,-0.324335,-0.315786,-0.309867,-0.292525,-0.267127:-0.167046,-0.128681,-0.110462,-0.098367,-0.067626,-0.036188,0.019517,0.087025,0.116378,0.146247,0.209743,0.272938,0.312779,0.345331,0.339365,0.321513,0.296927,0.269197,0.274436,0.28875,0.301108,0.322186,0.340772,0.359405:-0.520921,-0.469533,-0.42735,-0.38473,-0.340218,-0.293972,-0.260239,-0.223855,-0.190117,-0.160257,-0.143449,-0.115796,-0.096504,-0.063838,-0.039465,0.006929,0.040802,0.025569,-0.002102,-0.008326,-2.87E-4,0.002377,0.008066,0.021346:-0.312524,-0.298117,-0.2543,-0.215703,-0.195658,-0.183126,-0.180233,-0.192154,-0.189486,-0.192365,-0.21019,-0.228719,-0.242051,-0.257924,-0.255879,-0.242983,-0.209827,-0.173539,-0.174471,-0.188698,-0.200895,-0.205427,-0.200341,-0.188843:0.263477,0.254749,0.24257,0.214317,0.170053,0.114934,0.078457,0.046366,-0.003963,-0.051249,-0.064519,-0.087288,-0.130825,-0.160163,-0.212583,-0.274752,-0.328519,-0.328088,-0.299386,-0.306505,-0.335094,-0.347791,-0.360984,-0.375823:-0.042392,-0.022997,-0.009349,0.00451,0.021269,0.031698,-0.01384,-0.089864,-0.140801,-0.173035,-0.205004,-0.243801,-0.271609,-0.309734,-0.322546,-0.336501,-0.364533,-0.390237,-0.384658,-0.3477,-0.317871,-0.310156,-0.292804,-0.265307:-0.079627,-0.127698,-0.160879,-0.192634,-0.225506,-0.262605,-0.288415,-0.312577,-0.344065,-0.361444,-0.355393,-0.343304,-0.308015,-0.281099,-0.25866,-0.213334,-0.167621,-0.158872,-0.164017,-0.140793,-0.096282,-0.060764,-0.033403,-0.010975:-0.052545,-0.125117,-0.199687,-0.251483,-0.287043,-0.300744,-0.295987,-0.276504,-0.247375,-0.22634,-0.225273,-0.206276,-0.1787,-0.146068,-0.134405,-0.120462,-0.094223,-0.059061,-0.050244,-0.070917,-0.084912,-0.08918,-0.098009,-0.11382:0.07718,0.105952,0.126803,0.14296,0.154631,0.165114,0.199592,0.251767,0.313049,0.351516,0.356756,0.344803,0.320815,0.27115,0.258524,0.221533,0.190832,0.187514,0.188934,0.16766,0.129776,0.103938,0.08528,0.065552:4
1.016291,0.854631,0.805802,0.783076,0.71003,0.60731,0.492628,0.436803,0.406174,0.333324,0.273218,0.224553,0.20144,0.138555,0.065008,0.036373,0.006156,-0.021147,-0.060743,-0.091007,-0.136543:-0.576641,-0.478066,-0.468507,-0.44922,-0.384624,-0.347923,-0.355411,-0.394535,-0.434483,-0.447514,-0.473139,-0.549061,-0.621556,-0.628457,-0.632952,-0.666151,-0.669558,-0.680383,-0.689564,-0.70173,-0.661161:0.561039,0.443188,0.365437,0.301456,0.220781,0.175714,0.146876,0.130436,0.126259,0.120108,0.113216,0.126945,0.181044,0.221271,0.252197,0.300943,0.365728,0.423135,0.472534,0.508256,0.513785:-0.893911,-0.868363,-0.850218,-0.839948,-0.813095,-0.742912,-0.661003,-0.62238,-0.553592,-0.472217,-0.406975,-0.314117,-0.251535,-0.226056,-0.201023,-0.195335,-0.22444,-0.211496,-0.147873,-0.120644,-0.127847:-0.284196,-0.208982,-0.133915,-0.069682,-0.008086,0.045213,0.106928,0.145805,0.177651,0.216366,0.262636,0.301578,0.347073,0.391395,0.432385,0.441555,0.421911,0.417485,0.422908,0.42174,0.432676:-0.252246,-0.269364,-0.295688,-0.29447,-0.295588,-0.280585,-0.249077,-0.224514,-0.210428,-0.200094,-0.203602,-0.163617,-0.098721,-0.057644,-0.064466,-0.063099,-0.041301,-0.058183,-0.0978,-0.110233,-0.105305:-0.477148,-0.420333,-0.357561,-0.320883,-0.262313,-0.22916,-0.224292,-0.226787,-0.231493,-0.214831,-0.202493,-0.238324,-0.267059,-0.259835,-0.275965,-0.285523,-0.286521,-0.303792,-0.324859,-0.323802,-0.30093:0.27497,0.280033,0.298548,0.284713,0.209737,0.132284,0.089564,0.047137,-0.028063,-0.130791,-0.212328,-0.251259,-0.281158,-0.342064,-0.371948,-0.398721,-0.429251,-0.421488,-0.394598,-0.380624,-0.396325:0.116889,0.088132,0.042484,0.012174,-0.010031,-0.040272,-0.09709,-0.149035,-0.180517,-0.193657,-0.177146,-0.15976,-0.182836,-0.200724,-0.184388,-0.168822,-0.150909,-0.134215,-0.123909,-0.113118,-0.075041:-0.212878,-0.235266,-0.282068,-0.302622,-0.307609,-0.340853,-0.389462,-0.409737,-0.410214,-0.418291,-0.413711,-0.381847,-0.330249,-0.290935,-0.272989,-0.239671,-0.194503,-0.165271,-0.151222,-0.135942,-0.11692:0.076772,0.014676,-0.040983,-0.07183,-0.090601,-0.081847,-0.066529,-0.035918,0.013216,0.067592,0.093494,0.101538,0.098925,0.088386,0.055287,0.017826,-0.009633,-0.025398,-0.024087,-0.029304,-0.052585:0.028329,0.033824,0.056274,0.067369,0.092231,0.127732,0.161399,0.201729,0.243571,0.29177,0.302275,0.243307,0.166909,0.107332,0.093588,0.074041,0.029675,-0.008713,-0.030991,-0.038934,-0.036131:4
0.742594,0.773386,0.731127,0.626446,0.66118,0.718354,0.75946,0.712249,0.595896,0.504282,0.428726,0.342112,0.291649,0.27639,0.299376,0.265992,0.19995,0.200561,0.221245,0.183726,0.171907,0.196421:-0.339609,-0.355357,-0.32468,-0.245741,-0.289293,-0.39011,-0.519917,-0.62703,-0.708704,-0.717404,-0.738633,-0.757576,-0.795328,-0.808764,-0.844309,-0.875394,-0.868466,-0.898371,-0.913335,-0.868922,-0.852348,-0.855351:0.258824,0.182216,0.147856,0.121095,0.089469,0.07777,0.119614,0.135853,0.132548,0.144286,0.200463,0.204025,0.257777,0.325226,0.347133,0.366802,0.388113,0.403666,0.445214,0.453522,0.4608,0.492223:-0.692041,-0.664889,-0.652391,-0.622069,-0.634812,-0.626014,-0.604069,-0.558807,-0.505577,-0.452056,-0.406487,-0.33125,-0.277509,-0.259894,-0.246135,-0.23276,-0.206901,-0.146136,-0.109772,-0.0778,-0.073709,-0.055702:-0.32673,-0.299017,-0.252899,-0.204652,-0.116217,-0.058157,-0.001907,0.028194,0.068763,0.136881,0.217322,0.272756,0.298051,0.307013,0.315925,0.341323,0.354537,0.354029,0.36131,0.374946,0.383164,0.380903:-0.547963,-0.521488,-0.473321,-0.398837,-0.35767,-0.308261,-0.233504,-0.164584,-0.145036,-0.152461,-0.156706,-0.112225,-0.066158,-0.066315,-0.082168,-0.081816,-0.079762,-0.083872,-0.070199,-0.070346,-0.059151,-0.047502:-0.155454,-0.139554,-0.099623,-0.07599,-0.079792,-0.107608,-0.160196,-0.190458,-0.208279,-0.224469,-0.225034,-0.225732,-0.219648,-0.216829,-0.244576,-0.281633,-0.295827,-0.313394,-0.336325,-0.318385,-0.30699,-0.315367:0.166534,0.164236,0.147301,0.122782,0.108225,0.107798,0.096143,0.057879,0.011608,-0.04707,-0.098695,-0.154639,-0.192673,-0.211882,-0.224655,-0.233991,-0.251956,-0.23992,-0.224447,-0.246586,-0.251557,-0.235795:0.193362,0.202291,0.153888,0.105881,0.067603,0.009171,-0.101548,-0.172721,-0.207642,-0.232958,-0.276066,-0.277288,-0.302907,-0.325076,-0.30518,-0.285086,-0.255168,-0.22974,-0.213601,-0.191976,-0.19557,-0.2047:-0.202289,-0.262215,-0.332706,-0.414191,-0.451049,-0.465495,-0.471068,-0.490311,-0.489039,-0.455213,-0.410027,-0.403653,-0.39114,-0.365631,-0.331735,-0.307919,-0.283993,-0.278435,-0.257244,-0.238602,-0.229291,-0.217671:-0.036889,-0.046533,-0.04875,-0.052549,-0.080786,-0.079537,-0.040801,-0.018917,0.006337,0.055507,0.095019,0.097473,0.098146,0.092403,0.068048,0.053623,0.041056,0.051885,0.068219,0.064712,0.072181,0.090789:0.203623,0.21216,0.214836,0.199452,0.200612,0.207398,0.231767,0.255042,0.267516,0.281614,0.299311,0.264988,0.213088,0.188197,0.165927,0.137228,0.101148,0.083399,0.0615,0.049848,0.032311,0.006987:4
0.753101,0.750742,0.721296,0.612932,0.486874,0.443259,0.38593,0.324519,0.347251,0.374213,0.328189,0.20229,0.131596,0.120771,0.09941,0.065592,0.010015,-0.021797,-0.03108,-0.056146,-0.110838,-0.17016,-0.222086,-0.255006,-0.284147,-0.303983:-0.248233,-0.254259,-0.321257,-0.359796,-0.335685,-0.3587,-0.388717,-0.442642,-0.513559,-0.582719,-0.61727,-0.618384,-0.648712,-0.682934,-0.690026,-0.669253,-0.631388,-0.634815,-0.670139,-0.686293,-0.684219,-0.67376,-0.633193,-0.603081,-0.604102,-0.609258:0.414914,0.341544,0.309136,0.260971,0.191129,0.154145,0.119031,0.11556,0.147815,0.183487,0.177258,0.153539,0.158976,0.175372,0.205797,0.259728,0.294066,0.324738,0.371204,0.395836,0.399249,0.414209,0.439572,0.454221,0.490965,0.532165:-0.895113,-0.895805,-0.909231,-0.894288,-0.835119,-0.776493,-0.714302,-0.666875,-0.629886,-0.594469,-0.55926,-0.498909,-0.450989,-0.427116,-0.393706,-0.350661,-0.275723,-0.215787,-0.173712,-0.146193,-0.125856,-0.098526,-0.085443,-0.07644,-0.076305,-0.078003:-0.181762,-0.135579,-0.10216,-0.062091,-0.011738,0.062422,0.107773,0.146517,0.155622,0.161722,0.220441,0.275642,0.297839,0.315386,0.332729,0.338405,0.351353,0.369688,0.406851,0.453006,0.490538,0.499958,0.499373,0.502653,0.485904,0.473319:-0.60596,-0.575051,-0.531486,-0.479983,-0.448324,-0.399636,-0.341865,-0.304306,-0.265112,-0.236106,-0.228311,-0.219765,-0.212615,-0.222301,-0.240185,-0.238392,-0.231497,-0.205017,-0.183357,-0.173712,-0.170209,-0.177496,-0.18393,-0.189229,-0.178521,-0.179636:-0.257194,-0.268405,-0.280148,-0.279601,-0.249296,-0.218366,-0.189266,-0.179812,-0.21067,-0.234624,-0.225513,-0.221967,-0.232998,-0.237249,-0.246412,-0.245808,-0.241387,-0.244966,-0.259573,-0.254024,-0.233839,-0.224188,-0.223782,-0.222537,-0.212307,-0.198876:0.295889,0.297231,0.308326,0.285906,0.249993,0.222833,0.179438,0.146829,0.143782,0.110476,0.035537,-0.046836,-0.088145,-0.113199,-0.141147,-0.1773,-0.196366,-0.198107,-0.193193,-0.216895,-0.248491,-0.270912,-0.285009,-0.293801,-0.319857,-0.330145:0.101263,0.121661,0.09763,0.088033,0.069337,0.001365,-0.055481,-0.109994,-0.16039,-0.20263,-0.258221,-0.298815,-0.319463,-0.317129,-0.303401,-0.313521,-0.317167,-0.314952,-0.318529,-0.305357,-0.287601,-0.266285,-0.258363,-0.26617,-0.258072,-0.259894:-0.046489,-0.076046,-0.097074,-0.132593,-0.195905,-0.279066,-0.363622,-0.421543,-0.450593,-0.439532,-0.417871,-0.410571,-0.401115,-0.37777,-0.331249,-0.274457,-0.260457,-0.25031,-0.225257,-0.21738,-0.218401,-0.220763,-0.207238,-0.190335,-0.165615,-0.142835:-0.039476,-0.090475,-0.116031,-0.14489,-0.155607,-0.15523,-0.155051,-0.146219,-0.103019,-0.043643,0.012901,0.069742,0.100439,0.101727,0.105576,0.150993,0.191203,0.194761,0.174858,0.147265,0.120749,0.10161,0.097321,0.095952,0.070534,0.053278:0.172115,0.147003,0.104398,0.078796,0.081053,0.121658,0.162776,0.181471,0.180634,0.186373,0.208864,0.232301,0.246465,0.243487,0.203344,0.14181,0.112309,0.07601,0.043901,0.030218,0.007669,-0.018309,-0.056685,-0.084396,-0.109963,-0.137906:4
0.891052,0.844105,0.803888,0.73106,0.686201,0.662702,0.619959,0.528714,0.504797,0.483895,0.443112,0.388568,0.316379,0.199976,0.117722,0.041589,-0.002439,-0.005687:-0.258864,-0.296489,-0.373333,-0.379645,-0.393117,-0.413924,-0.418754,-0.42667,-0.526098,-0.615737,-0.678589,-0.691658,-0.699173,-0.711451,-0.745173,-0.772579,-0.818917,-0.813753:0.625761,0.59294,0.546366,0.456662,0.373687,0.31104,0.294578,0.314037,0.3173,0.306301,0.315694,0.341036,0.371589,0.404826,0.451478,0.501478,0.553033,0.58707:-0.838257,-0.855716,-0.878021,-0.864773,-0.845381,-0.800397,-0.737887,-0.651943,-0.568442,-0.522668,-0.510294,-0.451762,-0.346208,-0.24622,-0.204578,-0.195334,-0.178892,-0.183427:-0.393065,-0.342357,-0.299188,-0.247496,-0.155211,-0.068648,0.040261,0.170981,0.236481,0.27169,0.314855,0.336517,0.353396,0.394576,0.436541,0.477964,0.517487,0.523158:-0.573798,-0.558837,-0.479183,-0.406952,-0.403971,-0.406366,-0.369748,-0.321868,-0.260542,-0.213737,-0.190094,-0.186341,-0.18933,-0.173754,-0.142114,-0.110342,-0.091636,-0.098754:-0.305428,-0.277625,-0.246635,-0.204185,-0.166005,-0.141519,-0.143644,-0.155214,-0.162338,-0.186094,-0.208731,-0.220963,-0.217561,-0.226563,-0.231664,-0.232646,-0.232094,-0.237427:0.277834,0.302592,0.311967,0.309959,0.310969,0.288009,0.238903,0.156516,0.080501,0.016647,-0.052137,-0.150282,-0.202707,-0.196169,-0.185512,-0.175121,-0.158399,-0.162838:0.041567,0.022982,-0.009775,-0.032164,-0.075449,-0.104784,-0.146606,-0.228055,-0.2903,-0.337441,-0.366534,-0.341003,-0.320042,-0.29769,-0.280162,-0.273977,-0.284707,-0.286631:-0.072765,-0.098355,-0.14831,-0.225482,-0.286199,-0.347962,-0.389879,-0.409192,-0.458241,-0.453049,-0.384948,-0.305276,-0.268476,-0.270789,-0.256743,-0.223084,-0.203957,-0.18385:0.144608,0.102648,0.06771,0.016878,-0.042162,-0.088245,-0.108886,-0.094972,-0.083219,-0.040808,-0.01152,0.017547,0.051759,0.052602,0.015959,-0.026355,-0.049809,-0.059103:0.144173,0.12455,0.083587,0.062635,0.079492,0.12587,0.155112,0.203374,0.250004,0.263135,0.248371,0.236179,0.234107,0.203248,0.140171,0.066698,0.027914,0.012877:4
1.194663,1.426735,1.344589,1.288881,1.228793,1.049223,0.913994,0.753744,0.610282,0.461082,0.368881,0.319736,0.270816,0.24172,0.16545,0.135959,0.076476,0.046167,0.050443,0.104355,0.134409,0.100671:-0.802397,-0.984486,-0.945631,-0.969153,-0.993567,-0.931362,-0.883663,-0.829531,-0.858554,-0.89129,-0.886589,-0.881815,-0.87436,-0.884231,-0.865221,-0.841569,-0.827491,-0.810873,-0.792138,-0.806835,-0.816962,-0.786571:0.50369,0.519611,0.43906,0.346003,0.265652,0.200334,0.212306,0.226076,0.213834,0.232147,0.251124,0.283511,0.355343,0.416831,0.462463,0.479147,0.46461,0.466567,0.486713,0.48275,0.480686,0.501193:-0.717898,-0.82581,-0.848168,-0.862134,-0.827828,-0.760585,-0.706151,-0.63518,-0.5534,-0.483052,-0.423412,-0.34674,-0.282288,-0.249261,-0.21791,-0.208427,-0.186115,-0.187075,-0.201313,-0.202943,-0.197177,-0.183894:-0.415246,-0.373613,-0.331639,-0.252583,-0.144771,-0.01535,0.085839,0.173918,0.220784,0.25559,0.279202,0.292609,0.321073,0.370283,0.4013,0.396446,0.40803,0.429645,0.428247,0.396051,0.376129,0.368751:-0.259013,-0.182284,-0.158027,-0.131794,-0.112799,-0.106682,-0.063987,-0.064931,-0.072145,-0.080822,-0.109005,-0.109984,-0.077648,-0.035376,-0.028891,-0.036331,-0.026747,-0.032378,-0.049661,-0.063485,-0.063536,-0.064787:-0.41736,-0.479288,-0.42969,-0.404507,-0.385323,-0.335507,-0.329171,-0.31665,-0.295967,-0.307212,-0.297577,-0.296524,-0.299925,-0.255597,-0.225805,-0.219088,-0.200745,-0.210854,-0.213312,-0.186047,-0.169967,-0.17998:0.221952,0.27904,0.296534,0.282093,0.252982,0.182383,0.093762,0.013163,-0.065833,-0.133157,-0.200145,-0.242339,-0.247805,-0.270931,-0.331211,-0.392154,-0.444408,-0.455781,-0.455574,-0.457893,-0.462091,-0.473885:0.204032,0.216448,0.194182,0.148015,0.074292,-0.028595,-0.130382,-0.214066,-0.252728,-0.264211,-0.263939,-0.25827,-0.272023,-0.278527,-0.262688,-0.236582,-0.209641,-0.2013,-0.197441,-0.186283,-0.1863,-0.16868:-0.210581,-0.273292,-0.287299,-0.296637,-0.336073,-0.361987,-0.375983,-0.377764,-0.378739,-0.358598,-0.313073,-0.276337,-0.244453,-0.198983,-0.150006,-0.106829,-0.095841,-0.081641,-0.065791,-0.080474,-0.082074,-0.068725:0.005132,0.015903,-0.01389,-0.039989,-0.063185,-0.082967,-0.044408,-0.017449,-0.010015,0.006006,0.028097,0.066599,0.100432,0.072869,0.02314,-0.01064,-0.035354,-0.059924,-0.087039,-0.097132,-0.087064,-0.086742:0.132201,0.120884,0.097944,0.08237,0.092439,0.145173,0.200597,0.245126,0.261511,0.268316,0.274417,0.247949,0.184295,0.113216,0.068771,0.040014,0.005086,-0.018199,-0.019901,-3.4E-4,-0.003248,-0.025953:4
0.714761,0.691395,0.594975,0.548202,0.522044,0.485331,0.446711,0.394169,0.327942,0.255584,0.161845,0.109412,0.08016,0.01233,-0.040293,-0.138772,-0.167304,-0.216257,-0.19718,-0.19401:-0.551968,-0.57256,-0.559109,-0.580038,-0.577213,-0.587706,-0.596451,-0.620137,-0.620171,-0.608617,-0.597075,-0.583051,-0.600912,-0.583271,-0.577684,-0.560499,-0.574818,-0.56791,-0.604249,-0.64091:0.780754,0.700792,0.600682,0.530302,0.476297,0.43846,0.401543,0.358173,0.308796,0.29239,0.303217,0.30791,0.31432,0.316668,0.339466,0.379643,0.405262,0.425051,0.497998,0.583978:-0.930275,-0.9329,-0.921137,-0.879674,-0.824133,-0.808089,-0.804419,-0.736411,-0.660577,-0.603821,-0.5249,-0.403045,-0.311497,-0.253569,-0.235234,-0.219502,-0.203913,-0.18367,-0.182845,-0.198917:-0.382592,-0.345882,-0.287133,-0.232373,-0.173039,-0.104336,-0.058526,-0.029651,0.018555,0.095462,0.158385,0.183549,0.19851,0.207183,0.220079,0.227024,0.236637,0.242384,0.260052,0.301008:-0.357582,-0.341599,-0.320147,-0.316495,-0.283326,-0.211326,-0.158643,-0.134763,-0.129253,-0.098083,-0.052113,-0.033312,-0.048674,-0.066089,-0.074733,-0.05773,-0.048528,-0.040339,-0.026952,-0.028191:-0.444225,-0.427251,-0.420831,-0.408443,-0.409042,-0.407373,-0.380905,-0.347111,-0.31343,-0.296689,-0.261631,-0.245766,-0.262944,-0.285927,-0.29215,-0.313498,-0.318864,-0.333293,-0.36045,-0.36901:0.439481,0.442198,0.426807,0.423166,0.374464,0.323368,0.284542,0.228206,0.157834,0.059211,-0.050304,-0.125494,-0.182443,-0.23757,-0.294479,-0.315235,-0.334783,-0.334367,-0.315845,-0.301904:0.006042,0.015314,0.026007,0.017761,-0.008547,-0.051665,-0.10196,-0.152938,-0.208942,-0.265229,-0.308805,-0.335466,-0.34477,-0.326216,-0.308131,-0.313172,-0.303826,-0.286923,-0.258418,-0.235595:-0.234448,-0.246275,-0.256883,-0.282248,-0.29005,-0.30253,-0.320463,-0.350561,-0.358408,-0.338849,-0.325979,-0.322695,-0.293918,-0.257523,-0.216012,-0.175484,-0.154642,-0.132898,-0.104467,-0.064305:0.239565,0.191482,0.131375,0.098939,0.086179,0.079043,0.079069,0.081089,0.088062,0.109029,0.125862,0.163851,0.189882,0.207158,0.213968,0.211492,0.205079,0.188397,0.143745,0.096822:-0.001643,-0.002075,0.004049,0.024028,0.046052,0.062612,0.090047,0.129917,0.149976,0.161211,0.148732,0.13764,0.109156,0.052758,0.00221,-0.034096,-0.053333,-0.089698,-0.114087,-0.143184:4
0.526792,0.540545,0.552329,0.545899,0.486072,0.38372,0.363994,0.373951,0.349857,0.341215,0.397015,0.418825,0.38377,0.316936,0.237869,0.159411,0.102571,0.047825,-0.003501,-0.02721,-0.033474,-0.006178,-0.018047,-0.03252:0.033949,0.045381,0.022119,-0.052435,-0.12216,-0.171934,-0.240872,-0.314896,-0.377873,-0.422713,-0.512399,-0.619399,-0.654797,-0.658962,-0.681323,-0.714013,-0.732352,-0.732544,-0.745964,-0.745184,-0.7428,-0.76868,-0.757046,-0.749883:0.222016,0.125791,0.039424,0.010093,-0.009009,-0.038436,-0.003247,0.072369,0.14175,0.148433,0.130526,0.126685,0.149932,0.184195,0.258726,0.323822,0.389126,0.436417,0.492022,0.547355,0.567689,0.601278,0.621051,0.637658:-0.795987,-0.806991,-0.810117,-0.809561,-0.78973,-0.731645,-0.695763,-0.619673,-0.532602,-0.509141,-0.466406,-0.42372,-0.402695,-0.386022,-0.36181,-0.316145,-0.271651,-0.225825,-0.19698,-0.181507,-0.161449,-0.14715,-0.122862,-0.106403:-0.307206,-0.246545,-0.21062,-0.172823,-0.096025,-0.026972,-0.005285,0.009947,0.045126,0.092697,0.112198,0.139777,0.172394,0.182974,0.189354,0.187513,0.193118,0.196592,0.198211,0.211047,0.211368,0.188366,0.171981,0.167683:-0.604154,-0.56909,-0.52705,-0.468187,-0.398326,-0.3449,-0.308953,-0.281366,-0.256466,-0.234114,-0.200148,-0.182155,-0.177302,-0.151264,-0.13463,-0.135548,-0.14198,-0.131878,-0.120705,-0.119946,-0.121248,-0.114144,-0.099594,-0.086847:-0.112771,-0.088727,-0.062314,-0.052755,-0.0588,-0.070506,-0.076101,-0.101074,-0.119177,-0.111218,-0.130519,-0.165521,-0.202211,-0.227558,-0.260602,-0.276131,-0.282852,-0.280903,-0.271628,-0.284105,-0.283731,-0.283828,-0.280183,-0.253929:0.225128,0.21292,0.1859,0.169165,0.138752,0.092444,0.056473,0.037535,-0.021949,-0.123071,-0.199321,-0.246436,-0.291332,-0.343201,-0.344762,-0.334292,-0.326007,-0.3342,-0.337857,-0.32043,-0.309527,-0.300392,-0.307362,-0.325603:0.161533,0.159883,0.15914,0.123746,0.059018,0.002274,-0.043657,-0.092668,-0.121361,-0.135792,-0.161302,-0.185179,-0.192643,-0.189381,-0.201677,-0.204831,-0.206074,-0.205699,-0.209766,-0.211347,-0.203072,-0.189075,-0.173117,-0.160818:-0.065087,-0.114546,-0.13802,-0.162191,-0.216785,-0.299559,-0.322627,-0.324327,-0.332854,-0.333805,-0.344708,-0.339347,-0.285792,-0.234377,-0.202638,-0.19273,-0.177895,-0.161561,-0.147919,-0.136524,-0.13939,-0.138778,-0.140715,-0.143099:0.096171,0.076937,0.045086,0.005196,-0.03658,-0.050971,-0.052611,-0.048721,-0.027939,0.008389,0.065264,0.093051,0.112304,0.127211,0.130037,0.122776,0.115025,0.114677,0.108698,0.098816,0.079419,0.052961,0.039299,0.016179:0.127369,0.081771,0.075493,0.090794,0.125682,0.181745,0.226606,0.263843,0.312793,0.328852,0.306242,0.281406,0.250536,0.213517,0.188575,0.179638,0.16431,0.136355,0.102762,0.078091,0.062197,0.033651,0.008864,-0.005697:4
0.609433,0.633656,0.724933,0.823883,0.817062,0.821894,0.78789,0.762018,0.866938,0.947314,0.867813,0.84058,0.814185,0.814916,0.87083,0.89725,0.848481,0.769449,0.661611,0.598131,0.543613,0.498038,0.458954,0.42724,0.361118:-0.838054,-0.859213,-0.963617,-1.092491,-1.120678,-1.17142,-1.243569,-1.331991,-1.450218,-1.505962,-1.49549,-1.564247,-1.592492,-1.606353,-1.661862,-1.69252,-1.637817,-1.581463,-1.541801,-1.541908,-1.553294,-1.545425,-1.565322,-1.566352,-1.517149:0.185931,0.108583,0.061229,0.04539,0.004499,-9.36E-4,-0.005216,-0.015778,0.002039,-0.003988,-0.005609,0.079188,0.154874,0.178935,0.236576,0.286288,0.281831,0.258313,0.258997,0.261289,0.276391,0.320209,0.377581,0.430471,0.493694:-0.578186,-0.579491,-0.56154,-0.520424,-0.475003,-0.467454,-0.442552,-0.410383,-0.361872,-0.285444,-0.243608,-0.212524,-0.199983,-0.149668,-0.106857,-0.051416,-0.012155,-0.005172,-0.002823,0.011173,0.004876,-0.002905,0.01952,-0.004957,-0.042444:-0.369376,-0.316099,-0.268723,-0.246547,-0.221241,-0.168119,-0.105312,-0.045013,-0.026117,-0.034134,-0.006351,-0.017423,-0.028977,-0.02576,-0.02486,-0.004638,0.026204,0.059223,0.085108,0.105844,0.134736,0.1366,0.094652,0.063751,0.074075:-0.528161,-0.502398,-0.452912,-0.382083,-0.318681,-0.281069,-0.271694,-0.278125,-0.248227,-0.211666,-0.21159,-0.181326,-0.153163,-0.152694,-0.134653,-0.123274,-0.121278,-0.14546,-0.180967,-0.191565,-0.19223,-0.191107,-0.155338,-0.114593,-0.134593:-0.030302,0.012566,0.016621,-0.002622,-0.016703,-0.048556,-0.075341,-0.099428,-0.160308,-0.191558,-0.202834,-0.246485,-0.279158,-0.296988,-0.314544,-0.325422,-0.327263,-0.314735,-0.28573,-0.280869,-0.301735,-0.325146,-0.338203,-0.324801,-0.308937:0.246326,0.227137,0.202074,0.166521,0.1138,0.095093,0.060004,0.032898,0.030223,-0.033305,-0.100349,-0.1181,-0.131601,-0.14691,-0.148154,-0.159157,-0.194439,-0.224081,-0.255698,-0.286876,-0.30698,-0.322111,-0.355471,-0.392935,-0.393829:-0.004034,-0.009023,-0.019197,-0.047267,-0.06857,-0.107219,-0.137486,-0.1609,-0.194223,-0.210306,-0.224062,-0.241405,-0.246091,-0.23994,-0.248682,-0.258068,-0.254178,-0.254524,-0.269572,-0.270011,-0.2566,-0.235188,-0.230129,-0.248408,-0.263988:-0.086037,-0.113871,-0.143355,-0.168705,-0.203907,-0.223291,-0.24008,-0.240444,-0.234933,-0.22017,-0.195207,-0.190304,-0.186352,-0.176678,-0.181213,-0.187801,-0.183505,-0.169238,-0.138855,-0.120992,-0.110365,-0.089464,-0.046992,0.00756,0.052477:-0.010743,-0.060784,-0.086651,-0.080122,-0.059896,-0.0526,-0.057314,-0.048205,0.010925,0.069551,0.097314,0.147041,0.181988,0.183123,0.18693,0.170463,0.137908,0.0981,0.069097,0.053966,0.043113,0.035586,0.047331,0.063582,0.050895:0.152866,0.178928,0.192097,0.205331,0.244499,0.270678,0.300307,0.322739,0.30357,0.310983,0.339465,0.329543,0.310508,0.282009,0.233187,0.188681,0.164684,0.160417,0.154342,0.143541,0.140194,0.125936,0.063287,-0.009387,-0.043564:4
1.263261,1.206788,1.219585,1.060222,0.937747,0.876592,0.84808,0.733371,0.625681,0.537274,0.459203,0.388962,0.235967,0.179657,0.188586,0.2385,0.248814,0.187431,0.105677,0.057979:-0.607686,-0.61763,-0.666204,-0.596447,-0.562027,-0.575353,-0.619758,-0.651252,-0.676534,-0.693122,-0.692548,-0.744793,-0.783359,-0.785082,-0.803206,-0.845032,-0.856728,-0.822146,-0.776719,-0.718799:0.542194,0.467943,0.405612,0.314101,0.228339,0.144705,0.085603,0.063817,0.05912,0.068788,0.102534,0.173168,0.223837,0.241942,0.273056,0.32652,0.410924,0.485961,0.543268,0.581183:-0.902864,-0.906223,-0.959623,-0.969001,-0.964774,-0.930809,-0.858534,-0.768133,-0.70014,-0.610711,-0.452892,-0.363004,-0.330534,-0.317938,-0.307559,-0.296997,-0.26013,-0.20931,-0.172469,-0.157957:-0.479126,-0.426072,-0.343413,-0.280673,-0.188516,-0.09121,-0.012052,0.05466,0.103691,0.139706,0.158353,0.190669,0.241094,0.24772,0.226074,0.178549,0.152698,0.172559,0.203446,0.224884:-0.227122,-0.233509,-0.225832,-0.174667,-0.175108,-0.204731,-0.225177,-0.232298,-0.227681,-0.222958,-0.213953,-0.19135,-0.170482,-0.165535,-0.155627,-0.133725,-0.126215,-0.125366,-0.108468,-0.107692:-0.362142,-0.323084,-0.287724,-0.246669,-0.2159,-0.185636,-0.153077,-0.140365,-0.153003,-0.169332,-0.179627,-0.179748,-0.200614,-0.215323,-0.229424,-0.234387,-0.241101,-0.231783,-0.213087,-0.204705:0.212587,0.252902,0.301809,0.263286,0.220931,0.168709,0.096036,0.019537,-0.039342,-0.111362,-0.215404,-0.287078,-0.33921,-0.388527,-0.422737,-0.446932,-0.455344,-0.475117,-0.505521,-0.528303:0.136199,0.1195,0.077683,0.068564,0.02338,-0.031631,-0.088905,-0.134237,-0.159175,-0.170165,-0.165625,-0.192623,-0.226078,-0.209281,-0.180879,-0.15956,-0.155483,-0.137677,-0.105958,-0.089749:-0.132237,-0.157934,-0.191618,-0.199662,-0.214036,-0.231434,-0.263984,-0.303201,-0.315114,-0.301012,-0.290007,-0.25729,-0.221033,-0.18742,-0.159156,-0.11929,-0.080976,-0.04695,-0.010429,0.022974:0.140597,0.108173,0.076556,0.033759,-0.005014,-0.021492,-0.021648,-0.011418,0.014095,0.051018,0.106572,0.096841,0.071739,0.058748,0.045209,0.033446,0.031896,0.008887,-0.038017,-0.079279:0.074924,0.071754,0.074623,0.073261,0.093798,0.159336,0.268849,0.363567,0.406262,0.403917,0.381415,0.333839,0.285115,0.263028,0.227581,0.160304,0.108107,0.075007,0.033511,0.011659:4
1.150993,1.056008,1.009101,0.952334,0.764957,0.735012,0.676851,0.639818,0.57551,0.502472,0.379985,0.255143,0.222194,0.19928,0.13111,0.071253,0.044981:-0.681847,-0.700765,-0.72334,-0.713138,-0.606676,-0.657946,-0.659942,-0.66309,-0.668929,-0.688181,-0.688499,-0.660257,-0.649196,-0.661907,-0.695822,-0.722163,-0.724185:0.427736,0.345633,0.233161,0.13619,0.058633,0.101966,0.068562,-0.004569,-0.033839,-0.021168,0.013485,0.092102,0.185071,0.23783,0.265576,0.268841,0.297576:-0.827537,-0.824854,-0.802295,-0.758565,-0.671762,-0.653679,-0.581505,-0.498965,-0.431232,-0.380266,-0.322073,-0.243404,-0.147426,-0.066879,-0.029554,-0.035126,-0.015673:-0.382827,-0.317976,-0.251712,-0.198328,-0.140177,-0.033418,0.016138,0.044691,0.079113,0.093137,0.073905,0.041218,0.016736,0.047703,0.074522,0.092518,0.085928:-0.270423,-0.23742,-0.214258,-0.192736,-0.177432,-0.166579,-0.148625,-0.147149,-0.149824,-0.147236,-0.116957,-0.10499,-0.110941,-0.101928,-0.051436,-0.007838,-0.018034:-0.271309,-0.247801,-0.227825,-0.215508,-0.189808,-0.195466,-0.181103,-0.147803,-0.13876,-0.150727,-0.180597,-0.191581,-0.178246,-0.187027,-0.193253,-0.206326,-0.217118:0.256462,0.231881,0.177348,0.120726,0.039232,-0.023839,-0.116863,-0.238972,-0.33827,-0.392406,-0.441003,-0.495971,-0.49599,-0.495474,-0.517161,-0.547794,-0.575827:0.139927,0.116682,0.102892,0.083794,0.045397,-0.030633,-0.052853,-0.059112,-0.075152,-0.084608,-0.069115,-0.042339,-0.034871,-0.035882,-0.064805,-0.064947,-0.044303:-0.197407,-0.232383,-0.249834,-0.276103,-0.308648,-0.307555,-0.325562,-0.336688,-0.323928,-0.299166,-0.268343,-0.238416,-0.240677,-0.237103,-0.227111,-0.218094,-0.201746:-0.044197,-0.087892,-0.12607,-0.119608,-0.088337,-0.080075,-0.06724,-0.029263,0.03436,0.073877,0.100209,0.13064,0.128971,0.101116,0.080167,0.063068,0.052861:0.147766,0.164372,0.186073,0.218373,0.272576,0.342354,0.375109,0.388366,0.391214,0.383759,0.328309,0.271249,0.216552,0.145981,0.071762,0.016168,0.005645:4
1.192907,1.181634,1.242859,1.197659,1.135035,1.133423,1.093854,1.069915,0.944864,0.884051,0.787155,0.726658,0.671978,0.598808,0.559194,0.509739,0.479998,0.464062,0.449756,0.46007,0.441833,0.386315:-0.932675,-0.997667,-1.091921,-1.068394,-1.023156,-1.017542,-1.016719,-1.065327,-1.05523,-1.093668,-1.04914,-1.03434,-1.038101,-1.054611,-1.080544,-1.074682,-1.074925,-1.096068,-1.12828,-1.159555,-1.146677,-1.113436:0.547477,0.474718,0.476437,0.449457,0.388545,0.346051,0.323764,0.301675,0.257995,0.26867,0.260415,0.286345,0.350478,0.414584,0.430483,0.43131,0.446097,0.4704,0.499133,0.519234,0.524763,0.53529:-0.711912,-0.703916,-0.771713,-0.809628,-0.814406,-0.800456,-0.764216,-0.741235,-0.698681,-0.663837,-0.576178,-0.533615,-0.547324,-0.514899,-0.478288,-0.465621,-0.447027,-0.415024,-0.397452,-0.388149,-0.396774,-0.372361:-0.531699,-0.488891,-0.413289,-0.359338,-0.303128,-0.249206,-0.193962,-0.129645,-0.068228,-0.022301,-0.006109,0.010206,0.078689,0.140388,0.159231,0.150459,0.147746,0.144124,0.135301,0.133394,0.164138,0.170974:-0.205377,-0.189729,-0.159556,-0.131741,-0.116394,-0.084933,-0.045304,-0.023939,-0.026349,-0.0222,-0.004566,0.017337,0.017378,0.030473,0.02178,0.01109,0.005846,0.004602,0.006061,0.00865,-0.012884,-0.032732:-0.345491,-0.345885,-0.379106,-0.379832,-0.350085,-0.326933,-0.321345,-0.327325,-0.302132,-0.301531,-0.292662,-0.288176,-0.279543,-0.295593,-0.288975,-0.261296,-0.249793,-0.257706,-0.273903,-0.296185,-0.295591,-0.278396:0.185992,0.177087,0.201791,0.204864,0.181404,0.149733,0.112374,0.077626,0.011713,-0.042159,-0.118309,-0.157235,-0.154151,-0.172919,-0.212164,-0.261655,-0.295171,-0.31032,-0.318852,-0.320876,-0.327432,-0.35193:0.239892,0.241263,0.2059,0.184493,0.14895,0.096546,0.045019,-0.00921,-0.070289,-0.131316,-0.16165,-0.201191,-0.264955,-0.309224,-0.328427,-0.332268,-0.333237,-0.335234,-0.330451,-0.325988,-0.342352,-0.34424:-0.174112,-0.177333,-0.19501,-0.196042,-0.191043,-0.222868,-0.271477,-0.297833,-0.281777,-0.263942,-0.266551,-0.267594,-0.251743,-0.245043,-0.218819,-0.178204,-0.155233,-0.14876,-0.138355,-0.125955,-0.091415,-0.064498:-0.063785,-0.076022,-0.05542,-0.056144,-0.074953,-0.086278,-0.093257,-0.091046,-0.080967,-0.028941,0.027486,0.069187,0.077002,0.077677,0.059693,0.039062,0.030165,0.034422,0.036186,0.043261,0.041897,0.038018:0.12371,0.136302,0.134716,0.12369,0.119007,0.140604,0.178422,0.214864,0.250186,0.292001,0.341141,0.345796,0.314744,0.279893,0.256526,0.234295,0.2084,0.183596,0.15902,0.135465,0.116221,0.109189:4
0.667318,0.632111,0.643877,0.699259,0.75656,0.820028,0.87761,0.936225,0.980997,0.92393,0.854934,0.707623,0.628133,0.524933,0.442638,0.40262,0.358723,0.334023,0.329058,0.314325:-0.337197,-0.348521,-0.383982,-0.4438,-0.479208,-0.494658,-0.546407,-0.639865,-0.704629,-0.759866,-0.857602,-0.866493,-0.871536,-0.878308,-0.884614,-0.889005,-0.891644,-0.904535,-0.928445,-0.942463:0.376041,0.306374,0.242755,0.192043,0.136308,0.09015,0.064645,0.072914,0.037812,-0.010233,0.005272,5.0E-5,0.013978,0.076643,0.107551,0.124257,0.159432,0.16899,0.18195,0.218612:-0.647877,-0.625767,-0.609214,-0.607791,-0.614995,-0.626177,-0.649829,-0.678803,-0.648979,-0.585497,-0.549164,-0.470651,-0.401538,-0.318856,-0.243104,-0.190556,-0.164411,-0.133218,-0.098576,-0.079936:-0.431389,-0.410319,-0.389838,-0.353907,-0.306024,-0.241788,-0.181193,-0.126545,-0.075405,-0.008997,0.104007,0.148028,0.178749,0.242212,0.321787,0.37127,0.382815,0.366555,0.31752,0.275733:-0.533536,-0.527532,-0.519165,-0.498301,-0.469852,-0.444509,-0.39464,-0.308196,-0.254416,-0.226706,-0.192935,-0.156866,-0.129301,-0.124916,-0.146999,-0.159208,-0.142435,-0.116587,-0.088104,-0.088968:-0.238977,-0.229053,-0.214262,-0.208915,-0.210514,-0.207623,-0.204645,-0.231059,-0.237906,-0.223237,-0.237064,-0.230557,-0.219755,-0.231294,-0.249171,-0.281972,-0.322436,-0.341382,-0.322222,-0.265865:0.209355,0.194049,0.187222,0.180809,0.168119,0.14541,0.13464,0.139104,0.117453,0.051351,-0.010405,-0.084108,-0.132999,-0.179899,-0.245495,-0.302964,-0.337201,-0.362448,-0.383527,-0.395093:0.143062,0.185365,0.208744,0.208452,0.208231,0.196989,0.157571,0.101032,0.063538,0.018705,-0.062997,-0.087148,-0.106844,-0.133839,-0.131286,-0.121469,-0.115714,-0.108187,-0.117556,-0.134133:-0.167339,-0.192483,-0.223433,-0.236697,-0.242299,-0.257796,-0.268721,-0.276123,-0.313044,-0.34723,-0.371872,-0.395073,-0.414079,-0.401071,-0.363956,-0.330726,-0.30444,-0.284421,-0.263761,-0.244626:0.087067,0.040798,0.008716,-0.019058,-0.054031,-0.092541,-0.123321,-0.146032,-0.160884,-0.156655,-0.144823,-0.12555,-0.094734,-0.072336,-0.07578,-0.069195,-0.047404,-0.029976,-0.005066,0.016929:0.140784,0.152455,0.161756,0.161623,0.16917,0.200499,0.214451,0.198586,0.206544,0.230233,0.290538,0.324822,0.332911,0.320554,0.304792,0.284549,0.264207,0.234832,0.188843,0.150037:4
0.830158,0.832589,0.807688,0.743391,0.703671,0.666048,0.654962,0.626289,0.563063,0.52824,0.469451,0.389179,0.31142,0.33167,0.31613,0.239867,0.194267,0.162729,0.086473,0.035626,0.012922,-0.006906,-0.042356,-0.069752:-0.250109,-0.273007,-0.311658,-0.299424,-0.277272,-0.271062,-0.344073,-0.422991,-0.453802,-0.488577,-0.519642,-0.534477,-0.56468,-0.615345,-0.629244,-0.638983,-0.662192,-0.660233,-0.665336,-0.688455,-0.719232,-0.733202,-0.72343,-0.731994:0.339173,0.209825,0.120985,0.061094,-0.011582,-0.097539,-0.121065,-0.091689,-0.034162,0.047379,0.102502,0.106223,0.140722,0.240627,0.282759,0.293259,0.311391,0.331945,0.382485,0.47437,0.54618,0.562981,0.577972,0.607446:-0.781473,-0.82198,-0.769285,-0.729654,-0.732427,-0.692422,-0.633434,-0.613837,-0.613356,-0.549114,-0.452796,-0.343643,-0.310582,-0.330576,-0.302984,-0.258968,-0.235502,-0.231443,-0.224903,-0.234521,-0.240442,-0.198929,-0.137322,-0.093631:-0.186224,-0.050719,-0.018612,-0.009013,0.055256,0.096478,0.120579,0.160124,0.187981,0.193109,0.231502,0.271926,0.273249,0.237037,0.253565,0.304311,0.326026,0.333199,0.330557,0.320577,0.334463,0.355655,0.350753,0.353082:-0.627233,-0.642183,-0.605392,-0.566393,-0.529694,-0.481533,-0.429554,-0.362661,-0.280919,-0.2142,-0.17335,-0.149968,-0.111095,-0.079316,-0.107631,-0.120064,-0.098161,-0.078778,-0.066394,-0.046805,-0.04039,-0.056514,-0.071246,-0.074445:-0.265893,-0.253908,-0.231784,-0.191664,-0.166928,-0.135936,-0.103691,-0.086338,-0.071027,-0.086808,-0.101444,-0.108951,-0.116265,-0.084574,-0.081692,-0.12488,-0.153396,-0.164719,-0.168722,-0.176766,-0.181416,-0.167147,-0.139705,-0.123976:0.312538,0.343212,0.307498,0.265144,0.22046,0.152398,0.093321,0.019023,-0.0759,-0.144226,-0.190389,-0.262717,-0.351539,-0.419163,-0.428735,-0.442084,-0.465897,-0.46983,-0.461023,-0.447276,-0.433781,-0.431914,-0.439586,-0.436634:0.035589,-0.006886,-0.003076,-0.00663,-0.036828,-0.051734,-0.078677,-0.118235,-0.167831,-0.18508,-0.186387,-0.170804,-0.149114,-0.207914,-0.232716,-0.212962,-0.19709,-0.187459,-0.188542,-0.199238,-0.214069,-0.210942,-0.193674,-0.170778:-0.021238,-0.050876,-0.077748,-0.121453,-0.160672,-0.196223,-0.221889,-0.242387,-0.237178,-0.225452,-0.255692,-0.306267,-0.292914,-0.22863,-0.214291,-0.20026,-0.177199,-0.149165,-0.113808,-0.070835,-0.033204,-0.018564,-0.017126,-0.012625:-0.04822,-0.056706,-0.107085,-0.139905,-0.149452,-0.169346,-0.207305,-0.219644,-0.213612,-0.228987,-0.221528,-0.187987,-0.161653,-0.096304,-0.075585,-0.079098,-0.085217,-0.093938,-0.098504,-0.102489,-0.110832,-0.124293,-0.132397,-0.145696:0.066535,0.025217,0.029751,0.069437,0.092888,0.109093,0.139423,0.177264,0.220761,0.286081,0.326533,0.334534,0.30471,0.259226,0.261234,0.265749,0.254382,0.221798,0.176244,0.135269,0.105106,0.093035,0.080423,0.055356:4
1.344349,1.486293,1.261923,1.434652,1.422373,1.309431,1.299825,1.295022,1.205766,1.170177,1.075412,1.049538,1.035993,0.975341,0.904896,0.813283,0.718683,0.609866,0.530428,0.428576:-0.671935,-0.842489,-0.659938,-0.822723,-0.861317,-0.8199,-0.847321,-0.910587,-0.893669,-0.952379,-0.999809,-1.09195,-1.137816,-1.122556,-1.111792,-1.088195,-1.06602,-1.055623,-1.079773,-1.113894:0.483195,0.514112,0.390157,0.421387,0.388417,0.302825,0.229779,0.206584,0.167983,0.157877,0.139968,0.144662,0.17886,0.224667,0.243438,0.244129,0.264827,0.29142,0.319798,0.375161:-0.645371,-0.750411,-0.675079,-0.793462,-0.810966,-0.779481,-0.763361,-0.751631,-0.707574,-0.660209,-0.572871,-0.544355,-0.508942,-0.459859,-0.437796,-0.397112,-0.341793,-0.286554,-0.260874,-0.2456:-0.476847,-0.409786,-0.3634,-0.275866,-0.219746,-0.155465,-0.089487,-0.058125,-0.024038,0.028304,0.043904,0.076254,0.09265,0.126496,0.192738,0.235933,0.272493,0.290012,0.292277,0.284156:-0.382074,-0.339988,-0.340484,-0.291184,-0.248047,-0.230911,-0.229815,-0.203608,-0.185735,-0.152501,-0.121404,-0.102388,-0.077262,-0.072674,-0.087351,-0.083677,-0.088949,-0.089503,-0.075894,-0.055795:-0.317246,-0.353481,-0.341794,-0.384991,-0.369241,-0.309793,-0.262729,-0.242986,-0.222358,-0.214373,-0.211957,-0.227175,-0.257037,-0.269185,-0.2377,-0.191308,-0.180305,-0.191849,-0.182025,-0.166214:0.218408,0.264495,0.240685,0.266004,0.245571,0.199914,0.16417,0.119699,0.057948,-0.003619,-0.062529,-0.085485,-0.108582,-0.145388,-0.185408,-0.244892,-0.286801,-0.320677,-0.355844,-0.396075:0.174035,0.120188,0.146257,0.082405,0.035543,0.004631,-0.027782,-0.048324,-0.072025,-0.12926,-0.14771,-0.17507,-0.193824,-0.225719,-0.27539,-0.291914,-0.292995,-0.284233,-0.277605,-0.29561:-0.112807,-0.126449,-0.135478,-0.168669,-0.177594,-0.169679,-0.17873,-0.202567,-0.222171,-0.256869,-0.299901,-0.30806,-0.302935,-0.270368,-0.223409,-0.196083,-0.175335,-0.166652,-0.152019,-0.111858:-0.040073,-0.035018,-0.064708,-0.057015,-0.079285,-0.149532,-0.228067,-0.267898,-0.249741,-0.233369,-0.21108,-0.192575,-0.147299,-0.102287,-0.102274,-0.113021,-0.112826,-0.109129,-0.125161,-0.126857:0.083813,0.043303,0.024331,0.021813,0.024197,0.032319,0.068727,0.119679,0.174032,0.262281,0.312942,0.33131,0.329272,0.325745,0.32988,0.331076,0.323653,0.304237,0.27497,0.210722:4
0.582364,0.529225,0.453353,0.460267,0.451581,0.414949,0.382936,0.404452,0.414858,0.421477,0.358463,0.316325,0.269212,0.248834,0.225916,0.196818,0.150229,0.07776,1.03E-4,-0.058104:-0.351759,-0.377366,-0.34331,-0.383586,-0.405097,-0.427667,-0.461389,-0.522812,-0.579042,-0.656204,-0.677905,-0.716951,-0.770222,-0.82814,-0.846709,-0.831608,-0.845864,-0.858802,-0.834962,-0.811976:0.765193,0.697074,0.592649,0.542182,0.506466,0.478608,0.435742,0.403426,0.368262,0.331768,0.295022,0.318426,0.401376,0.479064,0.548136,0.647421,0.706331,0.736151,0.737085,0.758214:-0.877975,-0.894249,-0.864782,-0.85813,-0.834332,-0.788554,-0.742237,-0.702155,-0.644316,-0.577643,-0.499018,-0.435731,-0.383952,-0.336339,-0.282165,-0.218974,-0.168259,-0.128347,-0.094912,-0.06998:-0.43491,-0.384762,-0.368391,-0.331249,-0.280608,-0.195808,-0.125176,-0.076897,-0.001338,0.083872,0.14355,0.214739,0.262828,0.281191,0.266294,0.246246,0.252296,0.249666,0.227583,0.229373:-0.411382,-0.414722,-0.416518,-0.419144,-0.405977,-0.378636,-0.340442,-0.288961,-0.260807,-0.235048,-0.199681,-0.157839,-0.105075,-0.062093,-0.069273,-0.099014,-0.089248,-0.076298,-0.08278,-0.096382:-0.355019,-0.340227,-0.32625,-0.314222,-0.308729,-0.30553,-0.289811,-0.287767,-0.287873,-0.279837,-0.26703,-0.272466,-0.300875,-0.317461,-0.347074,-0.391019,-0.413465,-0.411088,-0.380649,-0.3521:0.369945,0.382506,0.397526,0.40504,0.382908,0.335188,0.304479,0.264104,0.208253,0.140307,0.053249,-0.025553,-0.065946,-0.093316,-0.115945,-0.14047,-0.177921,-0.207102,-0.232262,-0.249378:-0.02379,-0.030112,-0.010174,-0.015197,-0.02985,-0.06752,-0.115816,-0.149267,-0.180056,-0.229959,-0.275408,-0.334293,-0.379682,-0.385513,-0.345949,-0.299283,-0.288845,-0.278645,-0.244176,-0.202257:-0.166307,-0.180166,-0.20634,-0.220791,-0.230554,-0.248539,-0.283457,-0.309414,-0.333321,-0.366112,-0.361414,-0.337605,-0.317832,-0.308557,-0.288488,-0.234675,-0.196618,-0.177155,-0.167216,-0.138313:0.221716,0.182327,0.158153,0.137754,0.112651,0.093351,0.084612,0.082879,0.078892,0.091103,0.12844,0.176634,0.197882,0.182175,0.146973,0.123441,0.122446,0.109412,0.075517,0.03799:0.00298,-0.005898,0.007261,0.016252,0.029627,0.067538,0.097738,0.124859,0.167872,0.216169,0.236437,0.241287,0.207028,0.152682,0.100469,0.032155,-0.01792,-0.048394,-0.061136,-0.083402:4
0.316969,0.35002,0.338711,0.270609,0.278893,0.275798,0.298449,0.327659,0.291235,0.282815,0.266035,0.187009,0.140986,0.14951,0.09079:-0.27099,-0.323608,-0.33794,-0.297085,-0.321873,-0.39774,-0.487407,-0.568364,-0.608589,-0.638735,-0.644505,-0.646167,-0.685822,-0.739683,-0.759586:0.284787,0.247581,0.191207,0.112057,0.078733,0.070504,0.047625,0.031334,0.023399,0.026807,0.051045,0.126676,0.199894,0.30274,0.396825:-0.656901,-0.633485,-0.601307,-0.554794,-0.510701,-0.452736,-0.431434,-0.437536,-0.395118,-0.297151,-0.217735,-0.154192,-0.106454,-0.054847,-0.031222:-0.350342,-0.299692,-0.250851,-0.179692,-0.100594,-0.017887,0.071333,0.154067,0.194744,0.218896,0.282528,0.323041,0.298361,0.236531,0.225075:-0.566417,-0.536008,-0.490746,-0.469533,-0.451787,-0.405243,-0.306176,-0.210235,-0.166688,-0.128785,-0.126197,-0.135483,-0.110445,-0.087027,-0.09491:-0.115456,-0.110738,-0.113745,-0.139596,-0.163616,-0.185759,-0.216182,-0.229166,-0.199415,-0.184455,-0.18303,-0.203588,-0.221578,-0.258059,-0.285787:0.138066,0.12663,0.106295,0.072471,0.057498,0.011272,-0.03216,-0.093246,-0.170456,-0.24383,-0.295087,-0.343893,-0.380252,-0.374632,-0.380139:0.196482,0.172265,0.147668,0.164881,0.149638,0.107913,0.030469,-0.028533,-0.052249,-0.066857,-0.093081,-0.096555,-0.09298,-0.095181,-0.077617:-0.247832,-0.287269,-0.33372,-0.381236,-0.419659,-0.438576,-0.447628,-0.445697,-0.458102,-0.448805,-0.424661,-0.388853,-0.356381,-0.318964,-0.257673:0.034037,0.019854,0.01897,0.010484,0.005348,0.010293,0.006651,-0.028041,-0.037975,-0.005785,0.037098,0.027451,0.004415,-0.007239,-0.043343:0.208702,0.226031,0.23263,0.240349,0.258004,0.27363,0.287925,0.320409,0.337239,0.326218,0.291186,0.279808,0.252081,0.196305,0.14054:4
0.739159,0.790315,0.668796,0.563708,0.465313,0.398377,0.394246,0.297762,0.131784,0.016047,-0.049201,-0.087764,-0.13365,-0.183871:-0.500015,-0.56899,-0.547106,-0.533334,-0.541353,-0.580021,-0.678016,-0.723072,-0.707829,-0.691998,-0.692481,-0.677414,-0.630735,-0.619652:0.461349,0.478623,0.397479,0.307341,0.286693,0.326148,0.38175,0.401334,0.400752,0.424057,0.488878,0.570919,0.645427,0.709744:-0.785959,-0.828708,-0.81579,-0.761036,-0.70648,-0.639641,-0.533425,-0.41277,-0.290636,-0.206376,-0.135282,-0.101607,-0.101267,-0.089471:-0.328913,-0.2524,-0.174723,-0.063928,0.023041,0.069613,0.118333,0.136925,0.178947,0.213922,0.224039,0.209324,0.189214,0.1955:-0.159231,-0.096761,-0.113038,-0.129301,-0.113512,-0.102893,-0.038734,-0.023932,-0.065671,-0.085492,-0.072474,-0.039702,-0.030268,-0.028366:-0.488328,-0.486461,-0.433792,-0.37181,-0.349729,-0.347666,-0.391889,-0.408033,-0.364777,-0.284233,-0.254335,-0.25532,-0.216612,-0.222213:0.274879,0.289196,0.273026,0.2228,0.173843,0.123067,0.04415,-0.039601,-0.143463,-0.231612,-0.286302,-0.340951,-0.415276,-0.426596:0.22317,0.171214,0.083853,-0.017232,-0.100144,-0.155847,-0.205646,-0.216341,-0.22616,-0.224125,-0.189637,-0.170037,-0.172773,-0.191682:-0.26775,-0.332822,-0.345621,-0.365903,-0.395738,-0.397414,-0.39699,-0.367039,-0.308232,-0.280221,-0.260533,-0.213969,-0.156022,-0.11305:-0.015509,-0.016818,-0.023374,-0.023888,-0.007765,0.027807,0.088255,0.110095,0.137697,0.137601,0.092291,0.051138,0.031561,0.023641:0.061777,0.062077,0.067694,0.118037,0.172583,0.19853,0.235695,0.229348,0.204167,0.168258,0.105559,0.031189,-0.014332,-0.057467:4
0.848693,0.956276,0.994712,0.975094,0.91158,0.845766,0.80877,0.788988,0.794918,0.753418,0.66958,0.550564,0.37251,0.315851,0.38196,0.324171,0.208456,0.145519:-0.253028,-0.337728,-0.360313,-0.376777,-0.401918,-0.406662,-0.412817,-0.452343,-0.546552,-0.596046,-0.611431,-0.63033,-0.629982,-0.65557,-0.733021,-0.715217,-0.684405,-0.679555:0.653282,0.640026,0.579622,0.503448,0.468818,0.41025,0.360027,0.342567,0.342317,0.328826,0.310001,0.358399,0.395949,0.442789,0.560817,0.570184,0.587233,0.601714:-0.828556,-0.875577,-0.875544,-0.866215,-0.875215,-0.859993,-0.870152,-0.85855,-0.81981,-0.74003,-0.623767,-0.483052,-0.40225,-0.372369,-0.351308,-0.291761,-0.201309,-0.147768:-0.272284,-0.243455,-0.222258,-0.191151,-0.142479,-0.078296,0.019118,0.064558,0.117521,0.172741,0.236838,0.350081,0.410774,0.415625,0.430905,0.43088,0.441132,0.458211:-0.375166,-0.34533,-0.309081,-0.288735,-0.23313,-0.176221,-0.150337,-0.119031,-0.060974,0.001037,0.014607,0.01104,0.054153,0.042399,-0.011632,-0.040582,-0.03133,-0.014036:-0.560029,-0.564563,-0.55541,-0.541907,-0.548998,-0.525588,-0.481103,-0.454652,-0.443837,-0.462332,-0.462725,-0.460094,-0.43995,-0.423104,-0.429847,-0.39348,-0.363776,-0.340281:0.34663,0.351128,0.337227,0.31058,0.295374,0.280314,0.276652,0.241925,0.173832,0.102,0.03032,-0.046986,-0.130141,-0.172265,-0.157705,-0.176327,-0.186023,-0.181038:0.105956,0.125911,0.147331,0.14938,0.141997,0.105391,0.023358,-0.035975,-0.107862,-0.150578,-0.17849,-0.219307,-0.256803,-0.266091,-0.285818,-0.256578,-0.215459,-0.190234:-0.206379,-0.209096,-0.214272,-0.209447,-0.227433,-0.269933,-0.316351,-0.34835,-0.377518,-0.404157,-0.391117,-0.332437,-0.306503,-0.27557,-0.221482,-0.188576,-0.171588,-0.163527:0.122207,0.094174,0.051876,0.014976,-0.014333,-0.058054,-0.105492,-0.11939,-0.094159,-0.061859,-0.04058,-0.020632,-0.016597,-0.013961,-0.008526,-0.031072,-0.026909,-0.019073:0.024462,0.004798,-0.013742,-0.02989,-0.043904,-0.037487,-0.034734,-0.023926,0.023503,0.073944,0.10762,0.099682,0.059575,0.037114,0.01412,0.012886,0.00539,-0.009068:4
0.804022,0.695794,0.64981,0.613612,0.560146,0.567052,0.527478,0.417893,0.34686,0.313568,0.203439,0.102479,-0.006356,-0.070754,-0.098253:-0.287596,-0.360517,-0.443206,-0.476411,-0.461295,-0.492669,-0.554672,-0.637565,-0.682905,-0.659216,-0.635488,-0.623097,-0.584873,-0.575776,-0.56109:0.277053,0.266087,0.236491,0.200046,0.127353,0.111655,0.065591,0.036427,0.064891,0.132532,0.232338,0.297024,0.342667,0.423261,0.451493:-0.848394,-0.85078,-0.822825,-0.815499,-0.754489,-0.699763,-0.618803,-0.534495,-0.476947,-0.43255,-0.352843,-0.33184,-0.362259,-0.324508,-0.284544:-0.16797,-0.145244,-0.126365,-0.074203,0.003421,0.084476,0.124775,0.160202,0.201636,0.261412,0.323953,0.33392,0.304314,0.273691,0.252115:-0.551721,-0.512785,-0.462828,-0.419368,-0.38456,-0.345137,-0.306135,-0.266265,-0.231897,-0.194917,-0.110862,-0.04382,-0.009025,-0.033959,-0.036544:-0.258783,-0.258979,-0.264613,-0.235202,-0.202291,-0.201009,-0.170292,-0.156126,-0.167753,-0.197456,-0.272948,-0.315463,-0.243824,-0.184267,-0.16131:0.317095,0.34218,0.350412,0.326197,0.260523,0.225731,0.146294,0.061772,-0.003155,-0.060206,-0.102017,-0.177459,-0.306557,-0.361863,-0.381555:0.066154,0.05132,0.034431,-0.034518,-0.087946,-0.161524,-0.21319,-0.257682,-0.286614,-0.309924,-0.352456,-0.351792,-0.343663,-0.342427,-0.298062:-0.165564,-0.208458,-0.26625,-0.295338,-0.343124,-0.385486,-0.429517,-0.451465,-0.433224,-0.372377,-0.326497,-0.274072,-0.204243,-0.169577,-0.160348:0.031547,0.004855,-0.016633,-0.014486,-0.008338,0.018377,0.050153,0.079479,0.105025,0.1305,0.16751,0.166712,0.153667,0.156738,0.149571:0.102907,0.092716,0.094078,0.102998,0.150822,0.2107,0.25634,0.255926,0.234764,0.198999,0.125266,0.06207,-0.008068,-0.043166,-0.071931:4
0.469329,0.492048,0.569592,0.630393,0.601596,0.490573,0.461532,0.467321,0.440218,0.322108,0.281544,0.28843,0.219517,0.148845,0.090478,0.044417,0.050476,0.129152,0.128647,0.117524,0.112678:-0.093799,-0.084362,-0.123735,-0.133191,-0.141051,-0.147165,-0.213263,-0.284738,-0.340476,-0.382744,-0.458384,-0.542075,-0.551716,-0.553851,-0.575058,-0.592621,-0.589769,-0.614067,-0.597418,-0.586315,-0.596421:0.36867,0.333689,0.327606,0.246304,0.147954,0.104378,0.131487,0.111211,0.107625,0.164589,0.227264,0.303248,0.315416,0.339984,0.364826,0.398811,0.463491,0.501983,0.487604,0.475747,0.492626:-0.690652,-0.69094,-0.717955,-0.73775,-0.68868,-0.618192,-0.559046,-0.482268,-0.407154,-0.362964,-0.34607,-0.293572,-0.238154,-0.195185,-0.168059,-0.139306,-0.132271,-0.099788,-0.056089,-0.028237,-0.025378:-0.075925,-0.057452,-0.034641,0.056954,0.100712,0.187163,0.255531,0.277111,0.362298,0.420691,0.372064,0.3478,0.368643,0.401372,0.421888,0.420966,0.428905,0.422105,0.432763,0.45882,0.458625:-0.595326,-0.553031,-0.47223,-0.459437,-0.430234,-0.424637,-0.330286,-0.280572,-0.233742,-0.123248,-0.005121,-0.014635,-0.07473,-0.101911,-0.097506,-0.089439,-0.092233,-0.110707,-0.162219,-0.161038,-0.143577:-0.322909,-0.30517,-0.287652,-0.259112,-0.239402,-0.217779,-0.230196,-0.20237,-0.203896,-0.237468,-0.241878,-0.231922,-0.221325,-0.255355,-0.273278,-0.276983,-0.277633,-0.275832,-0.226259,-0.210208,-0.213315:0.306512,0.303448,0.301671,0.302988,0.257168,0.188133,0.133753,0.067748,-0.030484,-0.111323,-0.162889,-0.175848,-0.197432,-0.22753,-0.252908,-0.24192,-0.214583,-0.189534,-0.19983,-0.213521,-0.217325:-0.007129,-0.013484,-0.05206,-0.074735,-0.055107,-0.077971,-0.162181,-0.200905,-0.226421,-0.288192,-0.353773,-0.375826,-0.353938,-0.303883,-0.266059,-0.26566,-0.288093,-0.266565,-0.210866,-0.171928,-0.165574:-0.230581,-0.251868,-0.273796,-0.297698,-0.332708,-0.376427,-0.428018,-0.455203,-0.434987,-0.388036,-0.3629,-0.357088,-0.334596,-0.289858,-0.253231,-0.23217,-0.203471,-0.205599,-0.219788,-0.215018,-0.206427:0.035992,0.027613,0.014628,-0.046767,-0.093173,-0.102599,-0.078912,-0.035746,0.00415,0.051671,0.09964,0.119542,0.109913,0.100895,0.096837,0.117037,0.136631,0.12406,0.093231,0.080115,0.065382:0.091386,0.084914,0.060864,0.048606,0.048361,0.080976,0.139201,0.159374,0.168144,0.123731,0.067419,0.074604,0.070337,0.038934,0.017366,-7.74E-4,-0.026288,-0.029132,-0.004331,-0.003799,-0.008841:4
1.098016,1.084315,1.060661,0.939942,0.865245,0.770718,0.674509,0.625519,0.61902,0.616936,0.548505,0.456483,0.417306,0.370387,0.290172,0.255433,0.242863,0.238696,0.20356,0.170822:-0.56132,-0.568229,-0.55487,-0.514223,-0.53355,-0.547325,-0.56296,-0.590979,-0.643786,-0.707877,-0.699308,-0.675197,-0.680864,-0.691871,-0.668494,-0.651513,-0.650235,-0.638014,-0.642547,-0.662896:0.488913,0.421902,0.331344,0.234242,0.158986,0.11831,0.115798,0.131506,0.188039,0.255817,0.227423,0.243317,0.363897,0.457843,0.491649,0.515377,0.563037,0.61387,0.693443,0.760796:-0.765028,-0.796442,-0.819398,-0.803569,-0.773981,-0.729462,-0.662134,-0.569612,-0.461169,-0.392676,-0.313578,-0.222,-0.15632,-0.103264,-0.059694,-0.015694,0.001134,0.005544,0.021277,0.021255:-0.350648,-0.305172,-0.241176,-0.196205,-0.140643,-0.076527,-0.024289,0.00891,0.045368,0.077694,0.109219,0.149004,0.184004,0.218289,0.229033,0.189901,0.166667,0.148965,0.142857,0.169253:-0.306385,-0.294163,-0.271221,-0.248807,-0.236962,-0.209466,-0.158758,-0.104117,-0.070723,-0.049321,-0.046683,-0.028004,-0.020231,-0.008102,-0.011563,-0.016423,-0.014205,0.009378,0.046269,0.059478:-0.418422,-0.382238,-0.349138,-0.308481,-0.263286,-0.230178,-0.24168,-0.263066,-0.281131,-0.298729,-0.301827,-0.30253,-0.273259,-0.288598,-0.284898,-0.25264,-0.235053,-0.217519,-0.212076,-0.19369:0.191432,0.180587,0.163421,0.141145,0.10698,0.060985,0.029566,-0.004881,-0.056223,-0.094536,-0.149678,-0.231234,-0.292869,-0.315481,-0.359392,-0.409887,-0.440284,-0.457875,-0.440777,-0.42327:0.22065,0.200301,0.188616,0.189506,0.162661,0.106279,0.033796,-0.034712,-0.09584,-0.157872,-0.178345,-0.18193,-0.210399,-0.224142,-0.208442,-0.178588,-0.154203,-0.141273,-0.130556,-0.115969:-0.139764,-0.141446,-0.151666,-0.186207,-0.228655,-0.279608,-0.336533,-0.375766,-0.389392,-0.397497,-0.399674,-0.352998,-0.272407,-0.249906,-0.233504,-0.211625,-0.1727,-0.125963,-0.092322,-0.064886:-0.041476,-0.081145,-0.126109,-0.157167,-0.170134,-0.161068,-0.121634,-0.061843,-0.013665,0.019985,0.050685,0.062331,0.075898,0.075574,0.059943,0.044028,0.023655,0.02041,0.010324,-0.017075:0.112959,0.107214,0.106222,0.114583,0.138805,0.189298,0.237794,0.283403,0.333458,0.346088,0.320961,0.258856,0.151537,0.092752,0.076106,0.05203,0.015346,-0.028107,-0.060655,-0.078089:4
1.097986,1.276503,1.201774,1.182,1.258265,1.117435,1.154636,1.101687,1.095183,1.05396,1.035081,1.086777,0.967118,0.844264,0.61985,0.557337,0.431988,0.324207,0.224604,0.205923:-0.663998,-0.833921,-0.821942,-0.841085,-0.905651,-0.806859,-0.885564,-0.868096,-0.915492,-0.962362,-1.011324,-1.077538,-1.01016,-0.987106,-0.932953,-0.953929,-0.901228,-0.913206,-0.933792,-0.923109:0.903225,0.935724,0.887335,0.845338,0.799598,0.69225,0.656995,0.589163,0.507085,0.41837,0.373745,0.349033,0.338226,0.385262,0.444579,0.488526,0.513928,0.59375,0.630165,0.627159:-0.64337,-0.717593,-0.710617,-0.719153,-0.768886,-0.770638,-0.791962,-0.796545,-0.789789,-0.764616,-0.7224,-0.673542,-0.559221,-0.47709,-0.358249,-0.294204,-0.26028,-0.259122,-0.239492,-0.201524:-0.635208,-0.585159,-0.52427,-0.475466,-0.419983,-0.332869,-0.242991,-0.131927,0.006334,0.117715,0.163442,0.197791,0.291494,0.427626,0.51032,0.524275,0.502495,0.494186,0.506464,0.508457:-0.192439,-0.149152,-0.129885,-0.125307,-0.105365,-0.097764,-0.082568,-0.062407,-0.001368,0.007515,0.012238,0.018311,-0.010024,-0.042238,-0.046443,-0.064135,-0.090751,-0.092073,-0.099762,-0.132912:-0.460882,-0.482991,-0.484919,-0.48245,-0.48912,-0.476025,-0.475695,-0.443515,-0.424287,-0.420618,-0.418252,-0.430792,-0.432781,-0.444541,-0.416745,-0.39417,-0.367922,-0.367973,-0.36423,-0.351515:0.151853,0.157549,0.179987,0.212549,0.232669,0.226312,0.247949,0.228793,0.179147,0.147348,0.111978,0.067872,-0.023802,-0.036633,-0.069579,-0.100527,-0.140922,-0.135645,-0.143044,-0.181009:0.235181,0.206204,0.20894,0.195205,0.164861,0.157778,0.099335,3.36E-4,-0.113531,-0.161764,-0.17592,-0.192042,-0.22357,-0.277141,-0.279126,-0.268859,-0.270518,-0.308523,-0.31601,-0.293337:-0.252857,-0.282832,-0.319739,-0.354812,-0.374862,-0.367988,-0.399486,-0.405328,-0.435473,-0.442377,-0.44279,-0.428667,-0.360762,-0.293191,-0.258741,-0.233441,-0.195479,-0.164212,-0.144036,-0.123519:0.051058,0.06304,0.007259,-0.016436,-0.009785,-0.084326,-0.10852,-0.118795,-0.123566,-0.165491,-0.179015,-0.140785,-0.100531,-0.096371,-0.12433,-0.137616,-0.127418,-0.099241,-0.103346,-0.114132:0.166437,0.14005,0.116933,0.111248,0.085807,0.036815,-0.004668,-0.008478,0.042522,0.078813,0.103515,0.130687,0.180361,0.1683,0.149942,0.137186,0.111412,0.045819,0.004685,0.008727:4
1.030091,1.015401,0.92764,0.870934,0.783539,0.719515,0.672349,0.576461,0.414782,0.238075,0.14386,0.099648,0.089454,0.036163:-0.62666,-0.692796,-0.700269,-0.760198,-0.813562,-0.831725,-0.847274,-0.8728,-0.865911,-0.84443,-0.831125,-0.834304,-0.856419,-0.85151:0.483213,0.416355,0.314075,0.235788,0.143882,0.11973,0.156511,0.19101,0.246069,0.320199,0.396377,0.464699,0.540883,0.567213:-0.724966,-0.730449,-0.686487,-0.656244,-0.575852,-0.499548,-0.436253,-0.348183,-0.231754,-0.19386,-0.179833,-0.128367,-0.120487,-0.084282:-0.390453,-0.337758,-0.249293,-0.134337,-0.050257,0.026379,0.122775,0.221067,0.281958,0.263208,0.225163,0.230999,0.249179,0.288578:-0.371888,-0.338224,-0.299792,-0.244967,-0.190986,-0.139718,-0.129747,-0.122419,-0.107061,-0.050199,-0.03784,-0.062689,-0.050602,-0.044657:-0.253494,-0.2499,-0.205759,-0.153987,-0.142771,-0.162312,-0.155568,-0.134843,-0.178384,-0.202223,-0.170001,-0.178905,-0.171797,-0.131787:0.195715,0.212613,0.175387,0.110905,0.014903,-0.059237,-0.123405,-0.198909,-0.312458,-0.412255,-0.439121,-0.37341,-0.326745,-0.331588:0.099243,0.095979,0.055536,-0.030616,-0.066017,-0.120056,-0.179222,-0.21713,-0.205423,-0.211154,-0.241599,-0.249049,-0.245439,-0.222299:-0.179291,-0.227046,-0.284856,-0.351229,-0.401261,-0.427875,-0.411548,-0.381207,-0.314193,-0.237559,-0.207867,-0.215467,-0.185541,-0.166937:-0.057342,-0.098023,-0.132061,-0.176483,-0.180446,-0.127375,-0.103629,-0.107429,-0.071262,-0.020678,0.027381,0.041537,0.024519,-0.007562:0.163783,0.1543,0.17799,0.236268,0.279599,0.341655,0.390747,0.367567,0.306553,0.227476,0.188918,0.183497,0.140742,0.116818:4
0.480284,0.443858,0.458235,0.481414,0.464963,0.490255,0.511163,0.45156,0.328057,0.227306,0.185355,0.134503,0.106789,0.081468,0.042505,-0.004848,-0.056901,-0.103696,-0.13051,-0.15705,-0.151475,-0.161265:-0.224322,-0.254852,-0.310489,-0.390788,-0.461826,-0.513549,-0.543311,-0.530606,-0.49967,-0.511011,-0.577038,-0.638831,-0.671632,-0.679791,-0.688565,-0.706799,-0.705577,-0.700895,-0.715759,-0.718008,-0.728236,-0.704065:0.066987,0.04298,0.033369,0.014949,-0.03305,-0.067808,-0.044222,0.004186,0.032742,0.028077,0.04762,0.090185,0.160765,0.206728,0.237104,0.291671,0.368766,0.425018,0.485581,0.578872,0.654297,0.688736:-0.798511,-0.790458,-0.804344,-0.798778,-0.749409,-0.701732,-0.652791,-0.594316,-0.553669,-0.5079,-0.480557,-0.45367,-0.4213,-0.353175,-0.271907,-0.219855,-0.186212,-0.155325,-0.126527,-0.095326,-0.071288,-0.050232:-0.034378,0.025896,0.08476,0.152131,0.221135,0.275548,0.327387,0.391678,0.474881,0.516536,0.521183,0.502746,0.462352,0.458,0.462827,0.466652,0.475269,0.486967,0.496886,0.47887,0.466537,0.452321:-0.503631,-0.459489,-0.380509,-0.326933,-0.310631,-0.295876,-0.264558,-0.210063,-0.165964,-0.143439,-0.133938,-0.12248,-0.122942,-0.163462,-0.194587,-0.201622,-0.174765,-0.135232,-0.091887,-0.071603,-0.073591,-0.089076:-0.21676,-0.202675,-0.21268,-0.222123,-0.222666,-0.216536,-0.198862,-0.195508,-0.199008,-0.22285,-0.237818,-0.234108,-0.206871,-0.203354,-0.212339,-0.20658,-0.19103,-0.151645,-0.120448,-0.137688,-0.145617,-0.118654:0.221181,0.182736,0.157906,0.136127,0.097586,0.055478,-0.007236,-0.078413,-0.140669,-0.198568,-0.237417,-0.271231,-0.305144,-0.301338,-0.300363,-0.296078,-0.285509,-0.301443,-0.312356,-0.30166,-0.298828,-0.325378:0.074642,0.045178,-0.001209,-0.045942,-0.070519,-0.104681,-0.169082,-0.26449,-0.324018,-0.31616,-0.324724,-0.339366,-0.360118,-0.350799,-0.310425,-0.299184,-0.315618,-0.309886,-0.317388,-0.336495,-0.343928,-0.322965:-0.166854,-0.179972,-0.212057,-0.264867,-0.314391,-0.322193,-0.29037,-0.237966,-0.23192,-0.243251,-0.214929,-0.175891,-0.13114,-0.131584,-0.138734,-0.124697,-0.096543,-0.088871,-0.070237,-0.041131,-0.019745,-0.011632:-0.105854,-0.143031,-0.154655,-0.163261,-0.176506,-0.177781,-0.178733,-0.162612,-0.139516,-0.116908,-0.102991,-0.096582,-0.07638,-0.058847,-0.072477,-0.068606,-0.053804,-0.044611,-0.03801,-0.029521,-0.045487,-0.074243:0.037925,0.052767,0.084206,0.11608,0.142792,0.165607,0.207909,0.228606,0.214848,0.199815,0.178984,0.146059,0.129045,0.145547,0.173871,0.16331,0.121325,0.07892,0.012202,-0.054736,-0.076122,-0.073955:4
0.444027,0.436612,0.427944,0.387065,0.375575,0.410436,0.428818,0.431786,0.374871,0.303764,0.276204,0.286187,0.252275,0.16765,0.096071,0.0363,-0.008187,0.003125,0.011507:-0.253146,-0.276738,-0.327617,-0.370065,-0.410954,-0.505574,-0.576121,-0.632204,-0.671897,-0.696113,-0.740169,-0.783435,-0.800508,-0.795087,-0.791538,-0.79834,-0.791866,-0.781292,-0.771751:0.393407,0.377047,0.355616,0.316371,0.288278,0.278273,0.265524,0.272767,0.302033,0.37839,0.439297,0.453622,0.479944,0.490035,0.502329,0.536629,0.581396,0.596756,0.618086:-0.70207,-0.716594,-0.726612,-0.719088,-0.713651,-0.690981,-0.634651,-0.554335,-0.45837,-0.374915,-0.314936,-0.283323,-0.249178,-0.221302,-0.203351,-0.185129,-0.150795,-0.121483,-0.087952:-0.40668,-0.400241,-0.343295,-0.252436,-0.158498,-0.086017,-0.006846,0.069447,0.134652,0.203945,0.268941,0.277009,0.267442,0.27211,0.276032,0.285351,0.286894,0.268035,0.251981:-0.455932,-0.413691,-0.379738,-0.339127,-0.261313,-0.218447,-0.202376,-0.165741,-0.145514,-0.153718,-0.152054,-0.149225,-0.141632,-0.145379,-0.153962,-0.164413,-0.176028,-0.167987,-0.153286:-0.119686,-0.111443,-0.126276,-0.132375,-0.153976,-0.159202,-0.158538,-0.184173,-0.20006,-0.237316,-0.260769,-0.27335,-0.293328,-0.302088,-0.305595,-0.302279,-0.284857,-0.246757,-0.229489:0.098511,0.098927,0.120753,0.121781,0.125423,0.09678,0.029319,-0.038994,-0.095491,-0.150502,-0.20377,-0.255886,-0.299489,-0.325847,-0.332126,-0.325012,-0.320247,-0.323489,-0.31602:0.095739,0.097526,0.087796,0.054488,-0.010724,-0.071567,-0.125521,-0.171733,-0.188952,-0.201811,-0.23,-0.241294,-0.238474,-0.215295,-0.192445,-0.170417,-0.141641,-0.122396,-0.113881:-0.081503,-0.118499,-0.169309,-0.216532,-0.287068,-0.329184,-0.324466,-0.321374,-0.326808,-0.284515,-0.230944,-0.204912,-0.179601,-0.164725,-0.152798,-0.136258,-0.122973,-0.13089,-0.142336:-0.057647,-0.067927,-0.071831,-0.06441,-0.056485,-0.057747,-0.038226,-0.007474,-0.003649,0.008006,0.014162,0.028134,0.04169,0.022176,-7.84E-4,-0.031555,-0.058293,-0.066041,-0.060078:0.188592,0.182225,0.191497,0.205899,0.209494,0.227634,0.258623,0.275557,0.275948,0.257462,0.211981,0.189579,0.159249,0.146337,0.131497,0.11093,0.088745,0.07003,0.039641:4
0.745339,0.781831,0.761704,0.727351,0.793799,0.831872,0.816118,0.751733,0.691257,0.662793,0.630536,0.594449,0.519399,0.403446,0.325551,0.266273,0.228713,0.183894,0.124984,0.088482,0.087346,0.105162,0.093285:-0.577084,-0.609763,-0.630892,-0.601592,-0.617399,-0.598528,-0.569408,-0.564154,-0.582606,-0.610532,-0.65933,-0.708923,-0.715743,-0.708073,-0.719827,-0.750312,-0.781994,-0.820502,-0.796349,-0.781843,-0.787991,-0.803711,-0.804301:0.597073,0.530915,0.452404,0.356687,0.277321,0.185619,0.129248,0.128382,0.086095,0.044776,0.055728,0.056273,0.051723,0.082089,0.179536,0.239295,0.243678,0.275368,0.3068,0.32182,0.336691,0.356944,0.379689:-0.68904,-0.697004,-0.682976,-0.69915,-0.727312,-0.708854,-0.68087,-0.668621,-0.63712,-0.592082,-0.549267,-0.504587,-0.441939,-0.385629,-0.352781,-0.271919,-0.220973,-0.203259,-0.204973,-0.214728,-0.201654,-0.164135,-0.131592:-0.439571,-0.38263,-0.344911,-0.290811,-0.214844,-0.148431,-0.057305,0.06073,0.147005,0.212094,0.292321,0.355487,0.380904,0.388905,0.367967,0.391846,0.405914,0.423285,0.432455,0.439655,0.423607,0.387703,0.369024:-0.50546,-0.474305,-0.455412,-0.420777,-0.398791,-0.372087,-0.330755,-0.288513,-0.265379,-0.24863,-0.22379,-0.196935,-0.159449,-0.113617,-0.107374,-0.130675,-0.118577,-0.115923,-0.125136,-0.124371,-0.128814,-0.147173,-0.155363:-0.257689,-0.263895,-0.247305,-0.239303,-0.249803,-0.234313,-0.206556,-0.200493,-0.190384,-0.181322,-0.194911,-0.218951,-0.253223,-0.250735,-0.201763,-0.209876,-0.233569,-0.258867,-0.26616,-0.259286,-0.246831,-0.229708,-0.225388:0.184554,0.1978,0.204568,0.209863,0.219624,0.201435,0.159705,0.122106,0.052384,-0.026495,-0.085091,-0.126297,-0.196681,-0.288211,-0.316104,-0.315054,-0.338177,-0.351172,-0.367102,-0.387209,-0.400651,-0.401939,-0.398242:0.096003,0.116914,0.123729,0.127834,0.124418,0.111375,0.052023,-0.033378,-0.062002,-0.080971,-0.143674,-0.172613,-0.14152,-0.130142,-0.193566,-0.206823,-0.183136,-0.189898,-0.204878,-0.207981,-0.190013,-0.170062,-0.153291:-0.075119,-0.104583,-0.155803,-0.202141,-0.233772,-0.281085,-0.316795,-0.343834,-0.361576,-0.362391,-0.346768,-0.341324,-0.327275,-0.272819,-0.233848,-0.250085,-0.260854,-0.229962,-0.189609,-0.162904,-0.159885,-0.167835,-0.175624:0.016625,-0.03566,-0.074622,-0.120215,-0.156323,-0.177482,-0.193303,-0.202577,-0.208387,-0.178434,-0.147929,-0.145701,-0.129362,-0.101512,-0.028178,-0.016465,-0.030638,-0.04116,-0.037951,-0.049722,-0.059427,-0.055448,-0.050108:0.157483,0.157805,0.165238,0.157985,0.158144,0.167938,0.187517,0.229767,0.277743,0.315679,0.345221,0.338326,0.308037,0.249692,0.207695,0.225343,0.195094,0.144424,0.110242,0.096633,0.098167,0.096895,0.087637:4
1.096916,1.063108,1.259152,1.299894,1.18135,1.134848,1.002047,0.995327,0.966875,0.918704,0.851084,0.782576,0.655626,0.580275,0.538268,0.502627,0.479937,0.504575,0.52345,0.53221,0.588484:-0.574719,-0.543457,-0.696762,-0.700795,-0.602469,-0.578072,-0.553801,-0.598091,-0.617507,-0.648803,-0.652898,-0.616942,-0.588241,-0.615429,-0.624938,-0.615388,-0.616573,-0.681394,-0.724924,-0.750152,-0.790202:0.812504,0.720995,0.694773,0.583844,0.467003,0.36983,0.247109,0.141839,0.108156,0.153799,0.175806,0.180913,0.241094,0.305756,0.4069,0.477269,0.501426,0.503048,0.482083,0.467109,0.473467:-0.574998,-0.531326,-0.636702,-0.673111,-0.649598,-0.695042,-0.655633,-0.634087,-0.596469,-0.568803,-0.52079,-0.45593,-0.415179,-0.383316,-0.407338,-0.382744,-0.312917,-0.227914,-0.165854,-0.125461,-0.12246:-0.688579,-0.682685,-0.56036,-0.432989,-0.309208,-0.197309,-0.125689,-0.040652,0.079562,0.21731,0.329452,0.42676,0.471457,0.442971,0.394661,0.3979,0.446206,0.492771,0.515649,0.519323,0.520751:-0.405403,-0.353806,-0.361028,-0.354425,-0.314223,-0.280006,-0.248798,-0.21589,-0.15937,-0.147083,-0.128721,-0.099958,-0.032692,-0.008708,0.019625,0.014991,0.002727,-0.016767,-0.03103,-0.035692,-0.040283:-0.204375,-0.239149,-0.255321,-0.238269,-0.201559,-0.188121,-0.165191,-0.147458,-0.164675,-0.187222,-0.193055,-0.199936,-0.248061,-0.24632,-0.221005,-0.212062,-0.225796,-0.23115,-0.241231,-0.269666,-0.28585:0.092805,0.123819,0.162208,0.1711,0.147497,0.135685,0.08609,0.009647,-0.075571,-0.102138,-0.124027,-0.20914,-0.309294,-0.347053,-0.35017,-0.336833,-0.339403,-0.328428,-0.319911,-0.310452,-0.286026:0.077559,0.139245,0.117402,0.093113,0.084306,0.051955,0.047261,0.02812,-0.033741,-0.113979,-0.16697,-0.207918,-0.210091,-0.226045,-0.247232,-0.222174,-0.176173,-0.141132,-0.11926,-0.115868,-0.132057:-0.032132,-0.096463,-0.110384,-0.141448,-0.21081,-0.23437,-0.289613,-0.330991,-0.334133,-0.316485,-0.300865,-0.246214,-0.193185,-0.170078,-0.13532,-0.100392,-0.055107,-0.067364,-0.100592,-0.119025,-0.12102:-0.015228,-0.04523,-0.084141,-0.155573,-0.229172,-0.270146,-0.295257,-0.296305,-0.284346,-0.289349,-0.276906,-0.255409,-0.234802,-0.208416,-0.180858,-0.177018,-0.17349,-0.194133,-0.189272,-0.166437,-0.155166:0.141628,0.137464,0.128624,0.154399,0.192136,0.179025,0.190598,0.232927,0.29183,0.346642,0.33785,0.278277,0.245457,0.224395,0.179926,0.147875,0.107042,0.105831,0.113531,0.095584,0.070201:4
1.131542,1.041387,0.98316,0.889563,0.843711,0.854484,0.811201,0.713002,0.622158,0.535054,0.41705,0.313633,0.245973,0.216232,0.19806,0.176128,0.116716,0.051257,0.028391,0.037593:-0.63091,-0.567575,-0.539488,-0.470487,-0.443311,-0.480568,-0.511696,-0.539613,-0.588452,-0.653386,-0.64461,-0.649459,-0.690826,-0.734838,-0.767623,-0.776977,-0.788957,-0.784255,-0.760279,-0.760271:0.65081,0.553004,0.492621,0.420138,0.367276,0.35639,0.358134,0.332081,0.296626,0.328359,0.392549,0.450922,0.517656,0.576178,0.616257,0.63127,0.614033,0.600411,0.589016,0.578463:-0.813859,-0.812047,-0.825273,-0.822917,-0.807446,-0.762338,-0.713812,-0.699205,-0.683544,-0.661147,-0.606105,-0.471493,-0.360054,-0.279911,-0.216251,-0.169799,-0.158728,-0.162695,-0.144046,-0.108769:-0.316537,-0.216396,-0.098817,0.004066,0.085548,0.142544,0.245325,0.371839,0.440504,0.417178,0.402242,0.455474,0.497696,0.516715,0.536965,0.558973,0.607085,0.643546,0.65067,0.633371:-0.411676,-0.399535,-0.348931,-0.320309,-0.286623,-0.229939,-0.157771,-0.12596,-0.102276,-0.035452,-0.034719,-0.088264,-0.082775,-0.070528,-0.07239,-0.082041,-0.10144,-0.1283,-0.146535,-0.144648:-0.409123,-0.389402,-0.350787,-0.309008,-0.279791,-0.238627,-0.257226,-0.316314,-0.348597,-0.331757,-0.297068,-0.321462,-0.338942,-0.333683,-0.32336,-0.316394,-0.319639,-0.325325,-0.329721,-0.333121:0.3485,0.358103,0.37412,0.357117,0.311034,0.212853,0.111329,0.101381,0.076038,-0.027023,-0.109551,-0.114955,-0.13283,-0.158616,-0.169508,-0.163042,-0.12864,-0.100947,-0.10727,-0.130063:0.013847,0.00257,-0.074996,-0.125475,-0.143749,-0.177932,-0.267355,-0.363863,-0.388805,-0.382768,-0.389754,-0.359283,-0.317251,-0.299242,-0.295761,-0.295898,-0.313025,-0.332962,-0.330369,-0.312957:-0.131746,-0.172873,-0.257525,-0.285806,-0.278397,-0.267742,-0.281698,-0.313848,-0.312428,-0.263368,-0.189838,-0.152184,-0.12108,-0.099318,-0.085937,-0.082856,-0.084929,-0.086099,-0.081242,-0.079485:0.027701,-0.026243,-0.064199,-0.130156,-0.204323,-0.263252,-0.216732,-0.123393,-0.110663,-0.122668,-0.093527,-0.069902,-0.078934,-0.093967,-0.100385,-0.101814,-0.101932,-0.093659,-0.09281,-0.106949:-0.051047,-0.038231,-0.026659,-0.021882,-0.02054,0.017397,0.073654,0.074648,0.065945,0.080022,0.078353,0.074027,0.064873,0.054272,0.033164,0.0052,-0.050429,-0.095806,-0.110589,-0.103833:4
1.167035,1.010386,1.090084,1.0595,1.066355,1.057675,0.998657,0.947977,0.855752,0.792008,0.723009,0.648188,0.560489,0.498385,0.467275,0.41527,0.414161,0.406246,0.394695,0.388116,0.329512:-0.510272,-0.425641,-0.503781,-0.528166,-0.586268,-0.630905,-0.672827,-0.703978,-0.719559,-0.766128,-0.820667,-0.824397,-0.815405,-0.811374,-0.816437,-0.815718,-0.83825,-0.847379,-0.860169,-0.880498,-0.891368:0.807452,0.695004,0.615197,0.486689,0.375406,0.288564,0.196982,0.127903,0.137634,0.163275,0.200932,0.25014,0.279371,0.324297,0.36775,0.394923,0.423229,0.412567,0.407662,0.421313,0.459757:-0.803611,-0.784233,-0.840113,-0.820344,-0.805923,-0.770673,-0.723546,-0.659119,-0.573071,-0.489011,-0.404742,-0.326058,-0.275166,-0.249902,-0.213,-0.17658,-0.150837,-0.105277,-0.054089,-0.024526,-0.035281:-0.400269,-0.369665,-0.304714,-0.230378,-0.112842,-0.018319,0.056477,0.150557,0.236653,0.298615,0.381691,0.441542,0.469944,0.466194,0.464297,0.485135,0.497763,0.506322,0.507656,0.501616,0.517071:-0.411579,-0.432713,-0.42753,-0.421042,-0.382352,-0.339074,-0.304584,-0.267192,-0.196255,-0.145676,-0.136359,-0.149154,-0.156599,-0.146809,-0.135479,-0.14763,-0.152193,-0.162288,-0.165023,-0.148685,-0.126045:-0.43644,-0.347315,-0.295343,-0.244518,-0.215443,-0.192191,-0.164812,-0.160179,-0.202653,-0.242063,-0.249587,-0.264126,-0.286963,-0.317181,-0.350638,-0.347368,-0.331519,-0.292755,-0.271772,-0.268683,-0.27623:0.314509,0.321034,0.341888,0.308906,0.269869,0.230701,0.159873,0.067954,-0.016078,-0.055572,-0.116065,-0.184927,-0.226899,-0.236682,-0.235517,-0.243996,-0.240271,-0.257419,-0.274553,-0.270098,-0.245412:0.0346,0.033152,-0.012427,-0.013727,-0.046069,-0.080922,-0.10163,-0.137028,-0.16401,-0.174012,-0.204871,-0.219808,-0.216211,-0.201796,-0.180649,-0.166334,-0.150451,-0.11785,-0.091289,-0.090191,-0.109307:-0.177676,-0.180743,-0.201165,-0.222753,-0.276413,-0.34223,-0.363947,-0.367384,-0.382606,-0.408002,-0.382258,-0.318213,-0.277804,-0.254677,-0.230405,-0.192258,-0.162842,-0.14977,-0.146833,-0.149111,-0.139793:0.148603,0.07907,0.020013,-0.071247,-0.149465,-0.216422,-0.250038,-0.240175,-0.21505,-0.199472,-0.181806,-0.148644,-0.136653,-0.133708,-0.130839,-0.133019,-0.127583,-0.1407,-0.158215,-0.155704,-0.148736:0.106556,0.103435,0.090468,0.108723,0.158296,0.209223,0.24454,0.292034,0.34026,0.342612,0.33725,0.318469,0.286421,0.241225,0.201551,0.182217,0.169376,0.170282,0.161087,0.138491,0.108387:4
0.492615,0.500709,0.4917,0.462956,0.456735,0.452761,0.460111,0.482506,0.515678,0.454816,0.348349,0.24158,0.113281,0.021239,-0.056749,-0.116581,-0.105431,-0.04435:-0.26384,-0.272867,-0.279216,-0.291841,-0.337333,-0.374564,-0.41356,-0.467718,-0.529309,-0.580578,-0.634786,-0.672452,-0.68113,-0.682369,-0.662832,-0.674075,-0.694131,-0.731905:0.654573,0.608055,0.54329,0.448935,0.392867,0.349455,0.328746,0.304355,0.258547,0.21726,0.218744,0.277398,0.348855,0.393699,0.455722,0.511708,0.541027,0.583903:-0.804938,-0.810675,-0.815279,-0.803105,-0.790947,-0.772085,-0.736515,-0.716175,-0.695252,-0.602612,-0.527845,-0.427964,-0.316788,-0.269805,-0.219794,-0.177601,-0.114488,-0.064831:-0.397023,-0.347636,-0.292942,-0.232675,-0.1778,-0.101349,0.005665,0.118336,0.215648,0.311161,0.400974,0.497925,0.545842,0.552287,0.521175,0.493844,0.478246,0.471451:-0.500468,-0.498424,-0.476854,-0.450256,-0.400783,-0.363039,-0.326267,-0.274326,-0.233722,-0.180178,-0.144037,-0.135458,-0.148722,-0.16569,-0.185009,-0.182685,-0.185132,-0.176152:-0.216903,-0.196375,-0.180976,-0.15642,-0.152839,-0.163004,-0.178875,-0.18454,-0.206846,-0.2424,-0.275548,-0.300493,-0.307734,-0.304118,-0.318002,-0.314561,-0.307583,-0.288721:0.256066,0.277307,0.282068,0.277612,0.276563,0.271179,0.243465,0.167518,0.062772,-0.057704,-0.122995,-0.195999,-0.250733,-0.250052,-0.230951,-0.225223,-0.222345,-0.236424:0.002131,-0.011389,-0.009348,-0.008223,-0.024643,-0.055039,-0.118957,-0.186049,-0.200196,-0.210376,-0.231724,-0.248344,-0.258345,-0.276764,-0.265849,-0.241082,-0.209233,-0.169783:-0.045595,-0.071312,-0.128807,-0.189556,-0.228427,-0.24946,-0.285903,-0.312691,-0.293859,-0.286181,-0.258662,-0.194647,-0.154643,-0.134148,-0.136591,-0.138911,-0.129415,-0.10273:0.041854,-0.003459,-0.050457,-0.091436,-0.137526,-0.179893,-0.189827,-0.187361,-0.196672,-0.176561,-0.152377,-0.124137,-0.092285,-0.066248,-0.057047,-0.063403,-0.064688,-0.077375:0.114092,0.122434,0.141544,0.148949,0.133865,0.129451,0.184119,0.248549,0.260719,0.283672,0.247006,0.194632,0.139664,0.073617,0.040069,0.019769,0.012874,0.006094:4
1.008557,0.922475,0.804798,0.780059,0.75162,0.780532,0.81823,0.835885,0.616387,0.450877,0.429796,0.375452,0.310874,0.181883,0.09563,0.017065:-0.386928,-0.313679,-0.243411,-0.249111,-0.231978,-0.259317,-0.334395,-0.387608,-0.349335,-0.36409,-0.44965,-0.490768,-0.522861,-0.514435,-0.504788,-0.489186:0.478036,0.369798,0.28982,0.228788,0.164493,0.120614,0.047493,-0.033403,-0.040845,0.004851,0.047793,0.072198,0.103445,0.130005,0.167088,0.191667:-0.864819,-0.844661,-0.820534,-0.796613,-0.785561,-0.773166,-0.715823,-0.682001,-0.601348,-0.48098,-0.402058,-0.310597,-0.206296,-0.149457,-0.10185,-0.07777:-0.22087,-0.126961,-0.039207,0.029506,0.124423,0.228733,0.352582,0.504096,0.612956,0.692946,0.728094,0.750036,0.781585,0.832348,0.848726,0.871567:-0.506863,-0.522898,-0.513675,-0.480107,-0.449915,-0.408081,-0.305365,-0.223107,-0.181511,-0.1283,-0.115623,-0.132738,-0.148722,-0.153419,-0.134372,-0.135727:-0.33674,-0.294765,-0.275094,-0.25452,-0.238058,-0.230619,-0.220296,-0.213002,-0.161928,-0.22307,-0.281666,-0.296273,-0.314567,-0.308249,-0.277055,-0.251306:0.312695,0.310727,0.300621,0.290423,0.238954,0.173068,0.053446,-0.021109,-0.073277,-0.179801,-0.222312,-0.242509,-0.250275,-0.223555,-0.227678,-0.231824:0.078474,0.090137,0.070859,0.037268,0.021552,-0.016863,-0.086459,-0.181756,-0.29016,-0.281386,-0.239484,-0.1914,-0.150952,-0.181864,-0.178932,-0.189598:-0.090171,-0.118472,-0.168827,-0.225765,-0.242959,-0.254113,-0.2673,-0.246806,-0.236552,-0.236444,-0.222015,-0.188654,-0.145904,-0.101487,-0.074917,-0.038857:5.5E-4,-0.073034,-0.142691,-0.192953,-0.257809,-0.299843,-0.319874,-0.31986,-0.25508,-0.195595,-0.192938,-0.192188,-0.162917,-0.132883,-0.124478,-0.141394:0.11669,0.107288,0.082702,0.058733,0.051801,0.066814,0.100042,0.07588,0.04095,0.061182,0.078973,0.071953,0.053875,-0.00346,-0.04149,-0.083439:4
0.640648,0.542614,0.446078,0.394355,0.375231,0.363956,0.327925,0.316377,0.352268,0.303282,0.191205,0.11488,0.063849,0.024379,0.008897,8.34E-4,-0.010481:-0.387186,-0.400939,-0.423135,-0.451058,-0.485427,-0.519136,-0.560324,-0.60329,-0.661197,-0.68707,-0.710891,-0.74989,-0.74936,-0.724979,-0.707178,-0.715787,-0.719749:0.622948,0.554637,0.486961,0.413815,0.355443,0.323897,0.307115,0.303163,0.3118,0.30528,0.281054,0.290369,0.3432,0.407434,0.45034,0.476964,0.474489:-0.87384,-0.878785,-0.875934,-0.858277,-0.82252,-0.754032,-0.641928,-0.577185,-0.557363,-0.494917,-0.421782,-0.395303,-0.384737,-0.320334,-0.236849,-0.166273,-0.110728:-0.357415,-0.295847,-0.23088,-0.174627,-0.094798,0.026715,0.158837,0.238822,0.286335,0.335408,0.355021,0.359051,0.354612,0.347681,0.337033,0.338113,0.360402:-0.433482,-0.398253,-0.355527,-0.313613,-0.282968,-0.248183,-0.185394,-0.167896,-0.157293,-0.121351,-0.068567,-0.063902,-0.087578,-0.124545,-0.14366,-0.134947,-0.122941:-0.398376,-0.333085,-0.258424,-0.230206,-0.226038,-0.218634,-0.229594,-0.252092,-0.294879,-0.371344,-0.413137,-0.371202,-0.302967,-0.269706,-0.267739,-0.275655,-0.304217:0.334849,0.340563,0.34755,0.334303,0.312916,0.259244,0.176408,0.11495,0.050575,-0.036374,-0.143362,-0.232549,-0.265707,-0.23369,-0.188767,-0.184432,-0.201816:0.049678,0.006617,-0.065965,-0.101463,-0.120914,-0.161827,-0.227976,-0.289236,-0.307502,-0.29072,-0.256472,-0.254787,-0.285313,-0.289819,-0.261702,-0.234328,-0.207518:-0.116078,-0.159689,-0.232369,-0.285863,-0.323988,-0.364406,-0.415104,-0.428892,-0.392868,-0.343144,-0.301679,-0.242385,-0.191473,-0.199662,-0.228368,-0.235127,-0.218898:0.159181,0.096267,0.034766,-0.014254,-0.058776,-0.094368,-0.097145,-0.081592,-0.05145,-0.008405,0.007644,-0.002204,0.005351,0.022687,0.023038,0.021831,0.026254:0.018146,-0.004653,-0.005607,6.98E-4,0.014585,0.046298,0.095602,0.152892,0.186127,0.170493,0.160622,0.157668,0.128598,0.114898,0.104236,0.075104,0.03276:4
0.422875,0.3332,0.235187,0.188705,0.19727,0.20141,0.177166,0.145798,0.145722,0.14006,0.146363,0.137526:-0.891486,-0.94371,-0.939986,-0.945203,-0.91673,-0.897821,-0.897506,-0.892442,-0.886331,-0.889511,-0.896078,-0.900781:0.307997,0.354167,0.3629,0.398493,0.428562,0.454418,0.467985,0.456739,0.460446,0.473004,0.486794,0.513701:-0.357643,-0.304803,-0.279515,-0.29379,-0.279712,-0.21414,-0.164318,-0.126051,-0.103814,-0.089893,-0.066202,-0.052:0.303255,0.340604,0.358323,0.366568,0.351381,0.341281,0.358811,0.361948,0.342213,0.327369,0.314807,0.329916:-0.004444,0.033852,0.00471,-0.032931,-0.062339,-0.095689,-0.12246,-0.117262,-0.077761,-0.065926,-0.068642,-0.069154:-0.422677,-0.43786,-0.402997,-0.345616,-0.306226,-0.288343,-0.297581,-0.303459,-0.323908,-0.306011,-0.289289,-0.291873:-0.072378,-0.13594,-0.188342,-0.23157,-0.257489,-0.260179,-0.237727,-0.24968,-0.252987,-0.260227,-0.260151,-0.249839:-0.192728,-0.207093,-0.216649,-0.245385,-0.266176,-0.274161,-0.247535,-0.193226,-0.157811,-0.145429,-0.13386,-0.131397:-0.403994,-0.364786,-0.308999,-0.23895,-0.201385,-0.212517,-0.237769,-0.240759,-0.243124,-0.239285,-0.23501,-0.223737:-0.037159,-0.032923,-0.044137,-0.04467,-0.016682,0.022858,0.007546,-0.02376,-0.022917,-0.025453,-0.029271,-0.032498:0.191721,0.14041,0.089022,0.034934,0.020203,0.049004,0.089561,0.094535,0.056627,0.036783,0.02462,0.013701:4
0.90393,0.921159,0.967731,0.997069,0.927089,0.867723,0.88865,0.863108,0.750813,0.739557,0.708602,0.632331,0.476662,0.349197,0.276741,0.182791,0.151341:-0.557744,-0.580158,-0.612513,-0.64204,-0.616386,-0.603605,-0.65683,-0.696027,-0.691072,-0.751628,-0.794861,-0.803914,-0.815932,-0.838965,-0.802518,-0.748413,-0.748351:0.78112,0.719409,0.648227,0.556663,0.454195,0.349505,0.317105,0.311766,0.28549,0.291974,0.298253,0.263998,0.253351,0.289052,0.401818,0.510853,0.572229:-0.83301,-0.823752,-0.828813,-0.831247,-0.81123,-0.781475,-0.74605,-0.696995,-0.616978,-0.528805,-0.444371,-0.363951,-0.299361,-0.285548,-0.286819,-0.238342,-0.192213:-0.467943,-0.435294,-0.384759,-0.320523,-0.243027,-0.159898,-0.09025,0.021412,0.159815,0.218214,0.226281,0.287889,0.340419,0.330277,0.284173,0.319095,0.360088:-0.406522,-0.39678,-0.356529,-0.295915,-0.273368,-0.287716,-0.247726,-0.192762,-0.144954,-0.09989,-0.117928,-0.162301,-0.170783,-0.169093,-0.176571,-0.209219,-0.196289:-0.362028,-0.343018,-0.319802,-0.301043,-0.283273,-0.252106,-0.269553,-0.280193,-0.290237,-0.319043,-0.346871,-0.351768,-0.369514,-0.359407,-0.318791,-0.290168,-0.272604:0.280628,0.300484,0.303847,0.306524,0.309017,0.290298,0.250411,0.181641,0.098707,0.037232,-0.03441,-0.141587,-0.215317,-0.254977,-0.270255,-0.244103,-0.210283:0.048194,0.053432,0.04239,0.034967,0.027973,0.006185,-0.021683,-0.098726,-0.158338,-0.19555,-0.194662,-0.181044,-0.181793,-0.196446,-0.22612,-0.240868,-0.25243:-0.126538,-0.154134,-0.189249,-0.247191,-0.301236,-0.326562,-0.354024,-0.384721,-0.408745,-0.433475,-0.390006,-0.332258,-0.283127,-0.221475,-0.158943,-0.135227,-0.147856:0.146109,0.114996,0.077371,0.016036,-0.044342,-0.088205,-0.092799,-0.07925,-0.095444,-0.079094,-0.057453,-0.065392,-0.058236,-0.025485,0.037615,0.051923,0.033329:0.106282,0.106988,0.104602,0.103351,0.108537,0.125473,0.141064,0.197902,0.239188,0.239379,0.241864,0.269586,0.250175,0.178496,0.094682,0.081559,0.074901:4
0.79753,0.868466,0.90095,0.901243,0.882175,0.907035,0.935934,0.969891,1.051109,0.985697,0.900601,0.783182,0.703048,0.628299,0.593062,0.554367:-0.370591,-0.424978,-0.469719,-0.494241,-0.519355,-0.571373,-0.590025,-0.616883,-0.700967,-0.699295,-0.71371,-0.718966,-0.784121,-0.789154,-0.758693,-0.735429:0.77569,0.70096,0.625388,0.549443,0.466537,0.401017,0.329116,0.27001,0.269138,0.235622,0.218038,0.212746,0.282452,0.370291,0.415484,0.413527:-0.843765,-0.866615,-0.896485,-0.887245,-0.844868,-0.814325,-0.730557,-0.646221,-0.644889,-0.604982,-0.570781,-0.534661,-0.497743,-0.489614,-0.421804,-0.304582:-0.37332,-0.34069,-0.287879,-0.225428,-0.159056,-0.068673,0.012208,0.06536,0.111877,0.190141,0.275807,0.319491,0.288723,0.242414,0.281376,0.376069:-0.431685,-0.408414,-0.35523,-0.323197,-0.322993,-0.302392,-0.256995,-0.218986,-0.183219,-0.190233,-0.18907,-0.172227,-0.095206,-0.068848,-0.117863,-0.174884:-0.329104,-0.330521,-0.345521,-0.339175,-0.302907,-0.293522,-0.287534,-0.280622,-0.304997,-0.304152,-0.331435,-0.35803,-0.394107,-0.344816,-0.268136,-0.27443:0.259245,0.291782,0.323266,0.341165,0.326492,0.296836,0.221086,0.135914,0.093901,0.013003,-0.034295,-0.084151,-0.154488,-0.214207,-0.23057,-0.228971:-0.003564,0.01663,0.036195,0.043073,0.026116,-0.012575,-0.055868,-0.081081,-0.122038,-0.173876,-0.238625,-0.238885,-0.21937,-0.249257,-0.27408,-0.227858:-0.079648,-0.116211,-0.162768,-0.208916,-0.230876,-0.244897,-0.290091,-0.335388,-0.323107,-0.280593,-0.25424,-0.251048,-0.20684,-0.129293,-0.094856,-0.095062:0.072974,0.054668,0.021233,-0.041709,-0.106226,-0.136014,-0.145503,-0.14508,-0.123808,-0.10865,-0.062154,-0.040147,-0.026316,0.016964,0.010422,-0.068549:0.070469,0.06231,0.028279,0.010125,0.011804,0.021588,0.078318,0.150688,0.167892,0.19223,0.195676,0.205536,0.163505,0.096142,0.101293,0.120958:4
1.51101,1.663605,1.613832,1.620837,1.473025,1.451249,1.481784,1.650905,1.532464,1.710952,1.513545,1.319565,1.27956:-0.283644,-0.44147,-0.502899,-0.495558,-0.408167,-0.479009,-0.577054,-0.892903,-0.929838,-1.158278,-1.076563,-0.914266,-0.837682:-0.181305,-0.224154,-0.099473,-0.121952,-0.213428,-0.15359,-0.123654,0.057501,0.091023,0.322762,0.355798,0.342397,0.343477:-0.379972,-0.277744,-0.393321,-0.430612,-0.292233,-0.156076,-0.059386,-0.047496,0.045824,0.012019,0.08132,0.160821,0.267198:-0.16282,-0.146186,-0.029338,0.059956,0.10486,0.080152,0.07857,0.22918,0.20688,0.209085,0.219338,0.207465,0.164462:-0.178091,-0.255029,-0.279037,-0.132787,-0.127045,-0.097906,-0.063066,-0.086483,-0.048742,-0.049065,-0.101096,-0.114705,-0.095226:-0.072583,0.022134,-0.012637,-0.243021,-0.31625,-0.360829,-0.435646,-0.451426,-0.459039,-0.504478,-0.482787,-0.468597,-0.452269:0.070916,0.002173,0.011869,0.032209,0.003483,-0.074357,-0.066657,-0.138406,-0.217006,-0.202954,-0.144262,-0.14611,-0.158013:0.013861,-0.024104,-0.121138,-0.106567,-0.090119,-0.044098,-0.075271,-0.095534,-0.058389,-0.055916,-0.08781,-0.081676,-0.081719:-0.272128,-0.217514,-0.171656,-0.233654,-0.253862,-0.227165,-0.16363,-0.108437,-0.080095,-0.072079,-0.097948,-0.09698,-0.093892:0.009482,-0.041724,-0.005091,0.112069,0.145544,0.143859,0.156315,0.13859,0.083821,0.07825,0.091305,0.066213,0.047765:0.226182,0.251545,0.287758,0.254655,0.269439,0.299494,0.224009,0.139839,0.10543,0.045369,0.015547,-0.023872,-0.051933:5
1.151579,1.012287,0.934624,0.889226,0.905652,1.191272,1.39589,1.368318,1.046176,1.125058,1.081017:-0.67349,-0.655378,-0.617936,-0.563428,-0.607663,-0.863962,-1.094631,-1.206102,-1.025323,-1.121415,-1.082689:-0.408932,-0.407827,-0.423534,-0.463407,-0.432479,-0.264682,-0.046465,0.213413,0.216658,0.354706,0.358299:-0.383024,-0.412486,-0.371138,-0.322522,-0.196404,-0.066386,-0.043125,-0.013603,0.18452,0.1936,0.236785:0.090533,0.193335,0.286927,0.343659,0.320157,0.336057,0.430271,0.391348,0.312054,0.316049,0.353529:-0.337241,-0.342522,-0.36931,-0.305134,-0.236133,-0.234099,-0.235485,-0.198826,-0.17612,-0.231931,-0.291445:-0.091872,-0.140071,-0.186811,-0.289223,-0.348537,-0.385836,-0.474054,-0.478276,-0.451839,-0.429567,-0.41756:0.038578,0.027749,-0.015087,-0.067345,-0.117929,-0.153762,-0.111864,-0.125989,-0.147814,-0.125177,-0.075503:-0.087524,-0.117714,-0.138371,-0.140094,-0.137564,-0.149998,-0.185592,-0.217514,-0.192913,-0.180522,-0.207421:-0.210588,-0.211734,-0.188237,-0.193915,-0.166481,-0.080528,-0.033726,-0.031391,-0.066216,-0.053202,-0.049751:-0.029371,-0.005491,0.017494,0.099866,0.113242,0.067517,0.057705,0.046993,0.062045,0.021811,0.007021:0.236578,0.241605,0.251388,0.206691,0.184359,0.146175,0.016626,-0.050845,-0.066335,-0.096929,-0.145091:5
1.198331,1.114452,1.11484,1.261094,1.534059,1.498452,1.167362,1.047244,1.053516:-0.533602,-0.544979,-0.570018,-0.763223,-1.052521,-1.118857,-0.92398,-0.880679,-0.944611:-0.333836,-0.325364,-0.266759,-0.136517,0.085452,0.214708,0.156249,0.201248,0.304878:-0.211567,-0.19686,-0.156271,-0.090102,-0.096525,-0.044592,0.103885,0.117976,0.143998:0.002056,0.12609,0.225459,0.295,0.391933,0.402017,0.378685,0.390227,0.398856:-0.184929,-0.157122,-0.147607,-0.098229,-0.144656,-0.175471,-0.19258,-0.216505,-0.235777:-0.08521,-0.185068,-0.271447,-0.403635,-0.463228,-0.515688,-0.499159,-0.476247,-0.46651:-0.126207,-0.15397,-0.217495,-0.137697,-0.114059,-0.093969,-0.09451,-0.080087,-0.057036:-0.049158,-0.060565,-0.057484,-0.168833,-0.217872,-0.190934,-0.165036,-0.157188,-0.146278:-0.264195,-0.237211,-0.178051,-0.112835,-0.062735,-0.071031,-0.100732,-0.090636,-0.077893:0.060188,0.075269,0.07084,0.092659,0.094027,0.071669,0.064638,0.030086,0.00677:0.305575,0.257512,0.214555,0.116467,0.014074,-0.029991,-0.038151,-0.074425,-0.105165:5
1.304739,1.296991,1.505544,1.601942,1.473491,1.489046,1.241315,1.149603,1.252945,1.270483,1.173155:-0.278914,-0.301585,-0.340289,-0.561602,-0.48723,-0.559143,-0.670548,-0.722534,-0.912936,-1.055916,-1.010629:-0.595615,-0.623217,-0.628775,-0.555668,-0.678764,-0.551629,-0.24772,-0.201444,-0.073006,0.077726,0.144195:-0.152142,-0.113619,-0.07759,-0.057569,0.107619,0.162172,0.009352,0.140356,0.294052,0.356525,0.441008:-0.079051,-0.047146,0.015822,0.159046,0.169836,0.073104,0.192438,0.230686,0.26325,0.214046,0.197058:-0.485811,-0.508821,-0.471062,-0.469336,-0.402705,-0.287303,-0.169036,-0.211717,-0.270678,-0.278207,-0.236726:0.164181,0.158053,0.119311,0.090868,0.010952,-0.158589,-0.427845,-0.449452,-0.422198,-0.36775,-0.394754:-0.060376,-0.070195,-0.104617,-0.145653,-0.163449,-0.175027,-0.150611,-0.152279,-0.129633,-0.162741,-0.141724:0.086021,0.042116,-0.024353,-0.116113,-0.137441,-0.137745,-0.057799,-0.067637,-0.114453,-0.092724,-0.088785:-0.252848,-0.255856,-0.228394,-0.150327,-0.174358,-0.154566,-0.152634,-0.104858,-0.047686,-0.045309,-0.076612:0.038754,0.067004,0.076776,0.047813,0.118355,0.128061,0.095986,0.068175,0.050362,0.004447,-0.014196:0.230781,0.273514,0.302961,0.35482,0.324817,0.243444,0.162154,0.103687,0.036506,-0.008117,-0.054559:5
1.092867,0.929892,0.84727,0.786165,0.73256,0.880718,1.172651,1.194546,0.968101,0.960772,1.082266,1.072729,1.0758,1.053749,1.156788:-0.541665,-0.549037,-0.542493,-0.54017,-0.549368,-0.66962,-0.869151,-0.907182,-0.850894,-0.860279,-0.975699,-1.031739,-1.058426,-0.963191,-0.985056:-0.559992,-0.444737,-0.326837,-0.275507,-0.277814,-0.218622,-0.072413,0.047285,0.079422,0.185704,0.253587,0.338021,0.449532,0.438632,0.501501:0.046717,-0.071697,-0.199346,-0.250365,-0.131782,-0.043585,0.114243,0.214373,0.260563,0.325674,0.467272,0.536402,0.541619,0.592275,0.580268:-0.180001,-0.054885,0.029455,0.155881,0.225595,0.265843,0.264389,0.284235,0.313732,0.332521,0.250967,0.220688,0.191174,0.194765,0.223247:-0.401884,-0.391644,-0.342559,-0.316133,-0.275342,-0.201829,-0.116237,-0.155418,-0.197345,-0.234122,-0.234771,-0.231628,-0.226534,-0.279983,-0.261419:0.239727,0.17152,0.062566,-0.078713,-0.204148,-0.309765,-0.44649,-0.436952,-0.425821,-0.389009,-0.337612,-0.298747,-0.254952,-0.206987,-0.23838:-0.152771,-0.174023,-0.155052,-0.102995,-0.144678,-0.131663,-0.077527,-0.14357,-0.137264,-0.178416,-0.183023,-0.16124,-0.141126,-0.116412,-0.067942:-0.037381,-0.09657,-0.144495,-0.200428,-0.12676,-0.125778,-0.181181,-0.132441,-0.120168,-0.08826,-0.070815,-0.066732,-0.0632,-0.085594,-0.1015:-0.313044,-0.253766,-0.269777,-0.261956,-0.261398,-0.237803,-0.1719,-0.124593,-0.134312,-0.112804,-0.102309,-0.094532,-0.093078,-0.08997,-0.104035:0.12668,0.084719,0.105755,0.142134,0.150207,0.101163,0.100733,0.032391,-0.019167,-0.074127,-0.100238,-0.111394,-0.1264,-0.125072,-0.119783:0.203883,0.282104,0.313707,0.263332,0.191578,0.155412,0.069949,0.011116,-0.021577,-0.040972,-0.06917,-0.096756,-0.114601,-0.143392,-0.166489:5
1.285157,1.262186,1.363221,1.44458,1.288953,1.186149,1.305767,1.630679,1.462765,1.319092,1.288994:-0.40461,-0.523063,-0.691098,-0.859158,-0.83161,-0.823297,-0.950081,-1.227405,-1.129911,-1.144128,-1.228692:-0.270791,-0.310285,-0.257828,-0.094619,-0.031395,-0.081933,-0.030373,0.167377,0.119488,0.211292,0.359082:-0.362781,-0.235438,-0.163492,-0.212872,-0.318971,-0.230847,-0.159364,-0.153259,0.045109,0.127738,0.19369:-0.290672,-0.253184,-0.263163,-0.210494,-0.022582,0.078409,0.192949,0.264452,0.262019,0.308149,0.286782:-0.366938,-0.340477,-0.296192,-0.170588,-0.18441,-0.146681,-0.121141,-0.079553,-0.077786,-0.121736,-0.126543:0.132097,0.122594,0.108988,-0.067694,-0.168237,-0.277645,-0.387526,-0.497744,-0.471344,-0.448961,-0.426118:0.096722,0.038301,-0.034665,0.006524,0.038261,0.003899,-0.034843,-0.102973,-0.240637,-0.235114,-0.199794:-0.158539,-0.182203,-0.180739,-0.205565,-0.26618,-0.262303,-0.232236,-0.162276,-0.07326,-0.083779,-0.092931:-0.19055,-0.176823,-0.186331,-0.217022,-0.220357,-0.189784,-0.166137,-0.147981,-0.104767,-0.077369,-0.074331:0.081499,0.082665,0.086537,0.142255,0.195228,0.199078,0.180659,0.118695,-0.016036,-0.066087,-0.078592:0.171961,0.196837,0.244995,0.277965,0.252022,0.193499,0.12704,0.060406,0.057005,-0.004903,-0.068508:5
1.795459,1.653725,1.657337,1.653334,1.767474,1.607988,1.464056,1.275826,1.504254,1.582117,1.376457,1.511138:-0.801968,-0.783135,-0.819437,-0.878391,-1.067043,-1.061686,-1.024388,-0.936863,-1.206423,-1.373572,-1.231802,-1.368164:-0.168952,-0.245386,-0.327266,-0.385758,-0.28359,-0.191572,-0.112298,-0.116987,0.116786,0.314489,0.309037,0.518156:-0.491622,-0.377137,-0.170987,-0.029937,-0.045337,-0.067798,-0.047337,0.079224,0.108303,0.159155,0.284923,0.264074:-0.141732,-0.134176,-0.175404,-0.17037,-0.099231,0.006395,0.180938,0.265911,0.286372,0.239542,0.191571,0.135301:-0.405102,-0.381654,-0.282801,-0.211143,-0.156784,-0.1098,-0.143318,-0.184134,-0.196919,-0.172161,-0.147603,-0.145561:-0.013069,0.001461,-0.052767,-0.108809,-0.17288,-0.28042,-0.360435,-0.376797,-0.395213,-0.434988,-0.392073,-0.364537:0.219017,0.132271,0.062219,-0.030815,-0.134381,-0.206856,-0.200912,-0.210795,-0.198392,-0.179558,-0.216163,-0.186191:-0.173633,-0.16672,-0.169989,-0.172748,-0.15525,-0.127159,-0.152835,-0.162304,-0.165643,-0.145369,-0.113018,-0.116917:-0.155575,-0.173821,-0.208742,-0.198042,-0.175589,-0.142159,-0.109502,-0.06376,-0.03918,-0.055898,-0.070265,-0.056842:-0.02329,-0.009803,0.046292,0.059673,0.055299,0.068881,0.071635,0.039384,-0.00413,-0.018206,-0.038806,-0.062537:0.146099,0.196381,0.225557,0.259399,0.274677,0.245689,0.164368,0.071951,-0.019779,-0.092452,-0.086308,-0.138082:5
1.483986,1.610705,1.49722,1.3799,1.376267,1.620955,1.785076,1.499898,1.595279,1.438358,1.41674:-0.408009,-0.556987,-0.580334,-0.589098,-0.649324,-0.89214,-1.110366,-0.958113,-1.064049,-0.937927,-0.951636:-0.575877,-0.472627,-0.434204,-0.35236,-0.231614,-0.05551,0.208877,0.197492,0.370362,0.337512,0.36313:-0.227402,-0.166847,-0.010796,0.037371,-0.006132,0.037381,0.023951,0.206731,0.22338,0.295486,0.39616:-0.02516,0.045913,0.03982,0.12396,0.241455,0.260823,0.290371,0.232488,0.250326,0.214202,0.197885:-0.226565,-0.194574,-0.198382,-0.166197,-0.098696,0.006608,0.050863,0.054405,-0.021774,-0.051551,-0.07697:-0.125799,-0.218042,-0.227914,-0.354664,-0.498739,-0.565932,-0.548736,-0.51851,-0.486354,-0.449448,-0.388671:-0.078011,-0.090584,-0.228764,-0.221928,-0.161892,-0.165201,-0.211195,-0.194875,-0.15012,-0.133207,-0.120828:-0.097294,-0.129575,-0.057149,-0.063051,-0.102104,-0.0748,-0.066382,-0.083989,-0.082886,-0.086943,-0.12157:-0.217769,-0.170726,-0.162396,-0.137949,-0.122473,-0.162798,-0.173261,-0.171773,-0.177556,-0.160468,-0.161914:0.052611,0.049596,0.037,0.043619,0.075748,0.094287,0.07147,0.057863,0.062174,0.03955,0.01846:0.24916,0.242027,0.233635,0.193722,0.113816,0.083045,0.044044,0.015415,-0.020274,-0.040188,-0.060817:5
1.396676,1.485701,1.492232,1.361976,1.329436,1.414143,1.599903,1.676575,1.420533,1.235483,1.479005:-0.549357,-0.722733,-0.879172,-0.868545,-0.899595,-1.004567,-1.194887,-1.306833,-1.123337,-0.94853,-1.198511:-0.304182,-0.210837,-0.148738,-0.15097,-0.079018,0.066066,0.291403,0.470585,0.438471,0.363541,0.616128:-0.053987,-0.016685,0.027987,0.07964,0.111588,0.170922,0.163816,0.115234,0.176107,0.273337,0.198423:-0.021553,-0.005728,-0.016239,0.051654,0.121599,0.158485,0.192462,0.19369,0.223074,0.198146,0.219308:-0.278737,-0.24118,-0.076688,-0.055295,-0.048181,-0.042679,-0.065495,-0.075378,-0.082351,-0.070631,-0.091218:-0.07188,-0.095597,-0.254807,-0.353682,-0.420689,-0.445676,-0.450439,-0.495701,-0.471256,-0.446531,-0.441485:0.038007,-0.124402,-0.150154,-0.149842,-0.174104,-0.206056,-0.211373,-0.178047,-0.174556,-0.155672,-0.121132:-0.228491,-0.178117,-0.163353,-0.15876,-0.125181,-0.103439,-0.1053,-0.105033,-0.116471,-0.126515,-0.143956:-0.19643,-0.174397,-0.197532,-0.192837,-0.173642,-0.152278,-0.138862,-0.133732,-0.125798,-0.128836,-0.122184:0.015619,0.020865,0.046389,0.062282,0.059434,0.051922,0.040138,0.037293,0.052375,0.048877,0.036376:0.216872,0.237064,0.238477,0.21277,0.162129,0.110736,0.048916,-0.025054,-0.051948,-0.073909,-0.140081:5
1.585297,1.620969,1.571427,1.40812,1.29851,1.341755,1.59013,1.655187,1.634568,1.527419,1.509237,1.493909,1.457354,1.171335:-0.793289,-0.846773,-0.941087,-0.955579,-0.951185,-1.045484,-1.288058,-1.406481,-1.490377,-1.458624,-1.468778,-1.46937,-1.394094,-1.125529:-0.331042,-0.368538,-0.285043,-0.209069,-0.139447,0.012595,0.218129,0.317299,0.372936,0.379943,0.431314,0.488648,0.491453,0.368102:-0.121645,-0.07839,-0.125594,-0.188022,-0.135862,-0.05498,-0.008222,0.028289,0.084903,0.15002,0.18043,0.256069,0.313352,0.43452:-0.043023,-0.115863,-0.015823,0.183836,0.257076,0.281058,0.255951,0.222984,0.191167,0.204148,0.217177,0.20245,0.194131,0.128425:-0.301492,-0.169127,-0.039823,-0.062816,-0.047153,-0.037434,-0.063656,-0.049559,-0.04712,-0.061189,-0.0769,-0.077893,-0.081709,-0.038546:-0.061892,-0.098158,-0.271753,-0.378035,-0.451212,-0.486565,-0.492163,-0.516654,-0.500058,-0.485418,-0.473433,-0.452495,-0.417265,-0.410455:-0.130429,-0.245862,-0.194751,-0.167308,-0.195351,-0.224576,-0.22483,-0.22256,-0.2183,-0.208898,-0.184776,-0.181959,-0.184392,-0.181336:-0.080136,-0.041198,-0.068344,-0.128157,-0.147319,-0.160171,-0.145601,-0.117495,-0.122816,-0.132081,-0.146334,-0.127096,-0.118027,-0.10417:-0.134287,-0.1681,-0.223495,-0.212779,-0.159041,-0.106358,-0.08618,-0.103836,-0.121533,-0.134619,-0.126476,-0.12642,-0.116777,-0.130273:-0.065946,-0.091695,-0.055593,0.022371,0.063882,0.085305,0.055643,0.041375,0.0354,0.037319,0.038533,0.016928,-5.92E-4,-0.006794:0.201761,0.227301,0.246368,0.194221,0.12712,0.069802,0.032117,-0.001529,-0.033982,-0.048049,-0.090495,-0.108477,-0.121095,-0.103719:5
1.630992,1.60316,1.219905,0.920278,0.979151,1.011143,0.890573,0.949109,1.263177,1.346004,1.198209,1.205671,1.155827,1.025884,0.926584:-0.165495,-0.224451,-0.144524,-0.05658,-0.247892,-0.357978,-0.360227,-0.49187,-0.8453,-0.996669,-0.955261,-1.048046,-1.083844,-1.026894,-0.929007:-0.642102,-0.730304,-0.658378,-0.639801,-0.537034,-0.427403,-0.35545,-0.229244,0.067976,0.233384,0.269543,0.415444,0.498174,0.540111,0.544225:-0.146178,0.018861,-0.104325,-0.191962,-0.153793,-0.199947,-0.064295,0.071584,0.183592,0.172696,0.221577,0.23321,0.310377,0.393622,0.462221:0.042244,0.006704,0.13693,0.256796,0.260191,0.379191,0.395469,0.336293,0.33921,0.376173,0.354879,0.358253,0.331025,0.246615,0.189449:-0.442204,-0.36314,-0.366306,-0.347781,-0.206731,-0.183592,-0.135384,-0.05623,-0.075072,-0.074348,-0.067964,-0.097447,-0.12763,-0.092404,-0.091392:0.022514,0.002736,-0.035942,-0.115448,-0.226775,-0.376962,-0.455259,-0.512633,-0.542624,-0.534014,-0.493092,-0.439384,-0.389027,-0.359617,-0.343969:-0.015496,-0.137037,-0.178211,-0.188807,-0.231184,-0.230288,-0.262656,-0.243528,-0.148284,-0.140892,-0.13556,-0.107613,-0.095004,-0.107701,-0.092845:0.051035,0.043338,-0.007654,-0.072372,-0.078451,-0.058961,-0.050687,-0.096087,-0.14518,-0.136716,-0.136865,-0.143404,-0.157632,-0.172969,-0.178439:-0.19134,-0.254559,-0.216279,-0.213075,-0.246047,-0.247614,-0.188002,-0.112804,-0.109045,-0.126154,-0.113112,-0.105507,-0.11144,-0.128621,-0.148417:-0.112933,-0.004056,-0.026747,0.017394,0.056827,0.071831,0.080652,0.037189,0.046619,0.036946,0.012556,-0.010398,-0.036172,-0.022826,-0.032464:0.18571,0.177715,0.21697,0.198996,0.172832,0.11613,0.058332,0.028974,-0.048111,-0.097434,-0.123578,-0.158087,-0.175603,-0.195527,-0.19543:5
1.418907,1.285687,1.381723,1.293974,1.148452,1.132174,1.21324,1.23644,1.369493,1.409987,1.299022:-0.239561,-0.22203,-0.284186,-0.367701,-0.348528,-0.436103,-0.578758,-0.674433,-0.905849,-1.004306,-0.984133:-0.657631,-0.691163,-0.759915,-0.63414,-0.535899,-0.444194,-0.298385,-0.191498,-0.029176,0.143406,0.208144:-0.148134,-0.065997,0.04949,0.024619,-0.020319,-0.037793,-0.05555,0.053207,0.176963,0.183531,0.236761:-0.020965,-0.058451,-0.032492,0.058045,0.14912,0.220777,0.277269,0.259551,0.220322,0.240417,0.219606:-0.399122,-0.297017,-0.305508,-0.311286,-0.281918,-0.245224,-0.206447,-0.136102,-0.094314,-0.124077,-0.145863:0.071935,0.01832,0.044872,0.02062,-0.072398,-0.193575,-0.310624,-0.413314,-0.452738,-0.438723,-0.407674:-0.046333,-0.092263,-0.177718,-0.264946,-0.303581,-0.317759,-0.297266,-0.259326,-0.235576,-0.213582,-0.19421:0.050129,0.028228,0.011443,-0.008132,0.003112,0.004404,-0.026322,-0.073253,-0.106184,-0.125988,-0.140986:-0.298922,-0.310979,-0.312224,-0.269546,-0.263449,-0.234846,-0.174605,-0.119939,-0.087919,-0.089919,-0.093108:-0.070201,-0.001572,0.046178,0.047019,0.069807,0.059761,0.025404,0.029313,0.027327,0.032553,0.029335:0.168524,0.150638,0.15219,0.200318,0.222579,0.205477,0.179569,0.091557,0.021377,-0.015873,-0.041477:5
1.56597,1.593391,1.509787,1.45537,1.311522,1.320075,1.264459,1.047559,0.86217,0.927667,0.838156,0.729215,0.81248,0.780057:-0.764119,-0.840625,-0.873815,-0.972897,-0.986573,-1.059034,-1.129193,-1.096486,-1.079165,-1.180485,-1.139209,-1.095595,-1.218936,-1.247941:-0.171824,-0.181295,-0.175476,-0.059877,0.029557,0.10188,0.21144,0.280847,0.358806,0.516837,0.559857,0.585883,0.711305,0.765592:-0.323373,-0.319699,-0.230187,-0.208629,-0.160738,-0.125601,-0.091645,-0.028699,-0.005692,-0.017351,0.02675,0.075404,0.046295,0.059624:0.05141,0.119905,0.120069,0.085434,0.107164,0.165306,0.251196,0.293783,0.306878,0.320936,0.326732,0.324497,0.301144,0.281346:-0.45056,-0.455574,-0.393049,-0.290343,-0.222346,-0.14381,-0.12144,-0.138466,-0.152345,-0.193065,-0.211459,-0.196916,-0.16398,-0.157705:0.016337,0.021735,-0.017024,-0.102402,-0.221763,-0.353398,-0.4383,-0.433912,-0.401165,-0.422769,-0.427815,-0.417206,-0.404514,-0.356796:0.07745,0.003696,-0.070564,-0.155886,-0.211372,-0.1728,-0.138901,-0.154115,-0.156751,-0.100937,-0.088288,-0.091113,-0.072688,-0.077508:-0.256573,-0.281288,-0.257267,-0.206535,-0.1386,-0.128396,-0.155614,-0.178469,-0.202083,-0.219339,-0.204256,-0.195222,-0.205937,-0.21607:-0.075387,-0.040107,-0.059928,-0.069124,-0.089743,-0.106896,-0.084558,-0.045003,-0.026844,-0.031498,-0.032569,-0.034407,-0.021472,0.014184:-0.032684,-0.067727,-0.022361,-0.007933,0.023475,0.06773,0.093624,0.063169,0.01633,-0.012833,-0.025405,-0.029353,-0.056002,-0.095485:0.22979,0.281206,0.284671,0.286332,0.282681,0.18739,0.055674,-0.029149,-0.089034,-0.118642,-0.138616,-0.166844,-0.215896,-0.265156:5
1.454068,1.50299,1.373376,1.364857,1.439816,1.510672,1.24421,1.097062,1.061084,1.166241,1.130538,1.017337:0.03313,-0.058981,-0.041766,-0.110208,-0.21667,-0.336333,-0.373217,-0.450283,-0.549922,-0.719636,-0.751693,-0.746661:-0.577311,-0.562071,-0.618924,-0.598721,-0.576114,-0.587487,-0.408571,-0.229757,-0.09618,0.105926,0.228476,0.351971:-0.181708,-0.219602,-0.143493,-0.064588,-0.005314,0.083126,0.021403,-0.041761,-0.026351,0.011958,0.116138,0.147105:-0.14875,0.004122,0.023669,-0.02517,-0.016988,0.091045,0.152835,0.316551,0.41958,0.481481,0.4746,0.4328:-0.453125,-0.503512,-0.459893,-0.334285,-0.263594,-0.252474,-0.115218,-0.110302,-0.194818,-0.188385,-0.144882,-0.121189:0.007557,0.051613,0.049811,0.001533,-0.03501,-0.069061,-0.274108,-0.422705,-0.442054,-0.509075,-0.518834,-0.475135:0.067686,0.032756,0.014409,-0.067955,-0.207253,-0.298666,-0.296365,-0.21799,-0.196893,-0.112832,-0.072115,-0.064191:0.075768,0.029199,-0.021217,-0.039862,-0.00696,-0.060507,-0.045903,-0.085824,-0.092727,-0.16156,-0.193505,-0.171897:-0.301632,-0.230046,-0.241169,-0.299291,-0.313097,-0.222304,-0.222169,-0.18232,-0.142882,-0.113746,-0.124038,-0.161299:-0.073956,-0.149947,-0.127884,-0.02897,0.02064,0.047887,0.051208,0.053956,0.025081,0.035108,0.05387,0.030577:0.114837,0.170476,0.19086,0.183899,0.170845,0.161769,0.171896,0.107685,0.062571,-0.023636,-0.089141,-0.091573:5
1.117815,1.298115,1.366333,1.365428,1.61334,1.707942,1.684017,1.544622,1.555252,1.429066,1.39828,1.071119,1.206109:-0.432171,-0.566197,-0.686705,-0.703402,-0.908793,-1.157334,-1.20286,-1.129766,-1.186582,-1.173668,-1.167077,-0.926455,-1.038454:-0.057906,-0.012893,-0.039428,0.015577,0.211948,0.355443,0.383801,0.369839,0.526234,0.616923,0.688985,0.619441,0.843785:-0.244139,-0.252989,-0.25433,-0.286184,-0.261857,-0.280476,-0.158702,-0.02087,-0.020689,0.069025,0.106427,0.227071,0.092677:-0.164002,-0.137663,-0.094716,-0.012103,0.064009,0.166172,0.210048,0.255651,0.277331,0.242521,0.24574,0.260429,0.2996:-0.336672,-0.258402,-0.152517,-0.090948,0.015834,0.070126,0.063622,-0.011487,-0.067095,-0.068088,-0.094741,-0.126358,-0.164973:0.086562,0.005859,-0.139276,-0.238821,-0.393537,-0.541514,-0.571624,-0.528093,-0.532728,-0.484704,-0.463043,-0.37038,-0.4219:-0.115384,-0.205285,-0.223679,-0.192893,-0.147069,-0.147451,-0.180426,-0.218633,-0.183101,-0.155643,-0.116443,-0.14295,-0.076896:-0.004781,0.005498,0.001255,-0.023728,-0.073163,-0.072182,-0.043318,-0.035142,-0.052133,-0.056651,-0.06009,-0.067582,-0.118601:-0.134684,-0.14598,-0.195005,-0.252858,-0.246707,-0.226887,-0.196412,-0.132792,-0.094292,-0.141708,-0.133286,-0.132275,-0.069459:-0.10323,-0.105478,-0.059297,-0.02105,0.054753,0.103844,0.084586,-5.37E-4,-0.065872,-0.061369,-0.07883,-0.084874,-0.119294:0.234494,0.300829,0.332115,0.352496,0.266904,0.160427,0.121204,0.093229,0.028135,0.022263,-0.025369,-0.036538,-0.106021:5
1.633575,1.801052,1.711757,1.722523,1.684915,1.399171,1.367907,1.459931,1.343051,1.320769,1.152766,0.996504,0.973544:-0.613208,-0.685165,-0.71296,-0.91992,-0.998667,-0.880959,-0.96072,-1.136182,-1.092622,-1.141576,-1.071081,-0.932476,-0.900426:-0.265879,-0.192046,-0.161548,0.035917,0.140876,0.113463,0.242607,0.423132,0.42023,0.498377,0.516851,0.476888,0.487098:-0.213825,-0.248396,-0.186713,-0.246397,-0.143965,0.005784,0.031243,0.043555,0.156205,0.186812,0.188974,0.19359,0.25169:0.049373,0.104385,0.183748,0.312745,0.337636,0.328678,0.323101,0.297481,0.273078,0.255537,0.281395,0.298602,0.248369:-0.125174,-0.02451,0.033358,-0.007848,-0.005218,-0.044413,-0.066882,-0.04724,-0.053576,-0.059753,-0.094299,-0.111064,-0.042215:-0.185429,-0.340206,-0.472265,-0.508909,-0.522501,-0.473005,-0.462263,-0.491011,-0.447601,-0.418549,-0.389848,-0.355266,-0.348227:-0.158452,-0.202049,-0.108252,-0.091989,-0.152267,-0.151898,-0.130109,-0.122235,-0.125297,-0.130403,-0.129243,-0.13543,-0.148238:-0.058915,-0.013684,-0.072392,-0.128431,-0.118805,-0.152043,-0.175591,-0.163133,-0.178841,-0.189735,-0.203944,-0.20821,-0.204594:-0.156245,-0.157411,-0.219135,-0.221345,-0.1531,-0.143092,-0.150322,-0.173887,-0.173946,-0.137584,-0.083999,-0.059815,-0.069847:-0.048525,-0.017085,0.09361,0.122499,0.098932,0.088893,0.089998,0.080762,0.087252,0.085451,0.072963,0.048504,0.057793:0.208966,0.213919,0.171703,0.118467,0.058696,0.008592,-0.045611,-0.083569,-0.095982,-0.129477,-0.162887,-0.184223,-0.217455:5
1.61261,1.462146,1.326426,1.229728,1.169893,1.224659,1.351457,1.481436,1.403157,1.311489,1.253396,1.279336,1.221617,1.026124:-0.689174,-0.657401,-0.587077,-0.519825,-0.468367,-0.512724,-0.700416,-0.865952,-0.867474,-0.799918,-0.774532,-0.790014,-0.760432,-0.687863:-0.139083,-0.158796,-0.238958,-0.299759,-0.329336,-0.264337,-0.098656,0.045028,0.140566,0.169271,0.208131,0.247506,0.256234,0.244087:-0.274417,-0.287999,-0.24991,-0.159241,-0.03255,0.066457,0.110963,0.14633,0.185842,0.214028,0.291437,0.3599,0.39911,0.449534:-0.048015,0.039519,0.107336,0.134313,0.134311,0.165097,0.226406,0.244221,0.238241,0.341843,0.291142,0.201727,0.178954,0.186251:-0.030335,-0.021027,-0.010039,0.022314,0.067787,0.099549,0.097243,0.064187,0.042614,-0.019324,0.02421,0.018093,-0.049493,-0.064783:-0.276075,-0.311543,-0.343794,-0.362694,-0.369339,-0.365488,-0.369491,-0.338159,-0.327897,-0.356801,-0.38018,-0.35939,-0.297033,-0.272258:-0.056416,-0.109584,-0.195478,-0.303183,-0.410991,-0.424769,-0.358452,-0.354963,-0.338203,-0.26778,-0.278078,-0.271534,-0.283545,-0.306173:-0.02786,-0.023871,0.004021,0.054452,0.099693,0.00403,-0.143757,-0.165693,-0.153534,-0.177581,-0.135074,-0.108955,-0.080893,-0.056901:-0.296497,-0.296927,-0.286755,-0.291042,-0.277186,-0.150864,-0.057791,-0.06306,-0.089515,-0.07688,-0.086587,-0.111347,-0.120224,-0.128735:-0.083924,-0.072522,-0.053822,-0.039721,-0.034341,-0.062545,-0.031109,-0.03377,-0.062275,-0.050808,-0.049792,-0.037439,-0.059875,-0.070386:0.208938,0.219808,0.209965,0.206984,0.178335,0.119234,0.043574,0.008806,0.004661,-0.048546,-0.049496,-0.026175,-0.019463,-0.052053:5
1.493202,1.549653,1.485886,1.437153,1.330976,1.376213,1.216375,1.188667,1.082764,0.91576,0.917064,1.25247,1.404377,1.377692,1.069568,1.194723,1.195997:-0.646246,-0.674716,-0.710576,-0.796562,-0.81875,-0.900071,-0.875327,-0.955205,-0.87384,-0.74501,-0.812771,-1.179806,-1.295914,-1.31564,-1.090062,-1.182063,-1.112944:0.022686,-0.077018,-0.083088,-0.085464,-0.130716,-0.072797,-0.102004,-0.044428,-0.012313,-0.034545,0.094838,0.451812,0.578077,0.627129,0.503791,0.636603,0.684926:-0.711983,-0.643468,-0.595442,-0.543755,-0.45135,-0.462161,-0.322645,-0.214518,-0.119284,0.082057,0.154069,0.043816,0.073872,0.19773,0.384243,0.333301,0.312346:-0.015204,0.032602,0.063252,0.107772,0.198242,0.26572,0.314999,0.346249,0.352538,0.318785,0.319314,0.36293,0.334863,0.312034,0.297891,0.307774,0.318314:-0.420907,-0.412446,-0.338901,-0.289984,-0.284432,-0.257554,-0.22352,-0.183044,-0.18779,-0.285561,-0.277054,-0.193304,-0.125484,-0.147003,-0.175943,-0.246601,-0.314717:-0.101242,-0.098163,-0.154781,-0.193039,-0.213345,-0.265584,-0.33559,-0.440044,-0.440373,-0.272839,-0.307244,-0.466339,-0.49216,-0.445593,-0.371168,-0.325516,-0.273271:0.335136,0.29967,0.265356,0.222403,0.155032,0.093885,0.027729,-0.014982,-0.136744,-0.387882,-0.346892,-0.136333,-0.11063,-0.065824,-0.077914,-0.06614,-0.055353:-0.199724,-0.247651,-0.247217,-0.280863,-0.328153,-0.359026,-0.340357,-0.289926,-0.164704,0.025753,0.002596,-0.157965,-0.147787,-0.155501,-0.140343,-0.176658,-0.232001:-0.109886,-0.115943,-0.168102,-0.188444,-0.171777,-0.155934,-0.150248,-0.166708,-0.156544,-0.132545,-0.089009,-0.033385,-0.059355,-0.106344,-0.147432,-0.082973,-0.021859:-0.041593,-0.010725,0.035462,0.077505,0.10521,0.117456,0.135451,0.156928,0.076638,-0.052743,-0.094054,-0.065801,-0.061476,-0.040625,-0.05897,-0.126796,-0.158961:0.079989,0.09801,0.106936,0.117355,0.151078,0.150531,0.121764,0.083858,0.124885,0.187526,0.114971,-0.075441,-0.153693,-0.170765,-0.146391,-0.192252,-0.22568:5
1.580197,1.592844,1.568912,1.550451,1.556129,1.556769,1.457028,1.399498,1.16374,1.023146,1.076368,1.265665,1.259207,1.206242,0.92054,0.944102,0.928903,1.002313:-0.137795,-0.210705,-0.310487,-0.324133,-0.354435,-0.331309,-0.248242,-0.317296,-0.302268,-0.298142,-0.438977,-0.711786,-0.760116,-0.722118,-0.558332,-0.595101,-0.549592,-0.51988:-0.524655,-0.578993,-0.542891,-0.557836,-0.564175,-0.611745,-0.691067,-0.536815,-0.336224,-0.261786,-0.091113,0.199966,0.322581,0.344514,0.311484,0.442335,0.50006,0.488459:-0.311963,-0.203042,-0.155155,-0.121271,-0.085435,0.006473,0.101553,0.062166,-0.048967,0.016462,0.061952,-0.008441,0.002496,0.083867,0.183995,0.25291,0.356984,0.376473:0.050713,0.008134,-0.066502,-0.017331,-0.011948,0.029963,0.124193,0.196879,0.327005,0.365458,0.374984,0.436529,0.439691,0.367799,0.272168,0.22587,0.164531,0.232926:-0.516914,-0.457586,-0.334201,-0.329216,-0.25357,-0.217029,-0.23232,-0.181746,-0.084878,-0.042333,-0.017405,0.01962,0.051357,0.097591,0.084873,0.074914,0.029017,-0.008367:0.091535,0.036345,-0.042133,-0.03242,-0.053716,-0.068797,-0.069712,-0.151336,-0.353318,-0.418229,-0.436066,-0.449283,-0.440654,-0.400062,-0.39048,-0.370045,-0.260951,-0.199045:-0.008157,0.004336,-0.032136,-0.076602,-0.193129,-0.28015,-0.324209,-0.424176,-0.375838,-0.329416,-0.28299,-0.20953,-0.206561,-0.236827,-0.242464,-0.239506,-0.289128,-0.261339:-0.01507,-0.017634,-0.014006,-0.08376,-0.079042,-0.053717,-0.039808,0.019516,0.046078,-2.27E-4,-0.054524,-0.137318,-0.164177,-0.183474,-0.168411,-0.184358,-0.177232,-0.213256:-0.147017,-0.192859,-0.238379,-0.233038,-0.24987,-0.258458,-0.263946,-0.214696,-0.248108,-0.208951,-0.130454,-0.081057,-0.060087,-0.052212,-0.012198,-0.002033,-0.015529,0.028526:-0.178715,-0.146807,-0.106407,-0.061649,-0.005875,0.023434,0.048453,0.030071,0.049111,0.034002,-0.037356,-0.037748,-0.037907,-0.042472,-0.086757,-0.072785,-0.073171,-0.082173:0.184975,0.159281,0.144034,0.182793,0.199699,0.184637,0.150408,0.123167,0.120564,0.059482,0.025948,-0.0584,-0.141048,-0.193509,-0.243884,-0.287163,-0.235169,-0.248274:5
1.739582,1.718635,1.674312,1.610891,1.623002,1.559417,1.44045,1.370525,1.219962,1.168914,1.185693,1.3557,1.297624,1.060721,1.012861,0.985052:-0.687854,-0.711965,-0.722686,-0.711187,-0.767007,-0.833483,-0.842749,-0.876978,-0.85915,-0.898338,-0.955195,-1.082304,-1.062943,-0.939167,-0.940413,-0.918013:-0.113803,-0.114157,-0.140017,-0.206271,-0.183534,-0.035236,0.015659,0.091968,0.166779,0.273908,0.386653,0.575115,0.625879,0.598337,0.694766,0.761964:-0.405517,-0.372989,-0.336385,-0.247562,-0.187149,-0.144435,0.039,0.129939,0.178903,0.190855,0.202639,0.122069,0.173854,0.276427,0.294862,0.352264:-0.00416,0.093297,0.167292,0.224267,0.303117,0.352796,0.2245,0.184247,0.209073,0.247563,0.263631,0.287689,0.285904,0.222608,0.169442,0.146101:-0.190947,-0.19783,-0.16413,-0.122104,-0.103808,-0.081157,-0.024829,-0.007069,-0.035605,-0.069558,-0.069057,-0.039254,-0.035363,-0.014495,-0.023243,-0.011044:-0.280873,-0.291804,-0.314164,-0.330363,-0.363233,-0.384509,-0.331687,-0.392809,-0.426689,-0.423972,-0.411343,-0.429503,-0.401903,-0.352244,-0.326059,-0.32308:0.176251,0.151912,0.092079,0.014502,-0.059944,-0.16894,-0.357951,-0.345713,-0.281407,-0.225896,-0.197211,-0.170553,-0.168718,-0.186345,-0.17357,-0.179184:-0.073358,-0.135817,-0.181939,-0.214686,-0.228402,-0.210679,-0.098392,-0.077995,-0.111085,-0.14761,-0.148168,-0.151292,-0.172762,-0.179114,-0.175969,-0.162168:-0.27009,-0.26068,-0.254188,-0.234879,-0.204426,-0.14443,-0.107608,-0.125665,-0.134493,-0.122378,-0.107,-0.100552,-0.089115,-0.091688,-0.098504,-0.094709:-0.059148,-0.049622,-0.01971,-8.11E-4,0.012261,-0.006577,-0.103451,-0.085491,-0.039527,-0.010644,-0.013671,-0.028347,-0.028186,-0.040875,-0.056142,-0.064144:0.041315,0.057719,0.078381,0.09682,0.098222,0.093788,0.122583,0.086786,0.033962,-0.02151,-0.06473,-0.12373,-0.183147,-0.215998,-0.247285,-0.269534:5
1.536647,1.418343,1.448391,1.525428,1.487223,1.650065,1.555303,1.305093,1.081595,1.04924,1.090098,1.345022,1.454511,1.246184,1.311909,1.142119,1.068816,1.028939,1.02787,0.998673,0.997576:-0.287293,-0.313744,-0.379651,-0.474663,-0.516774,-0.780807,-0.826757,-0.724281,-0.624013,-0.634631,-0.681687,-0.93438,-1.09611,-0.956379,-1.028958,-0.950504,-0.951797,-0.954791,-0.950361,-0.974407,-1.012919:-0.47085,-0.45109,-0.451226,-0.449293,-0.424784,-0.272304,-0.202818,-0.192117,-0.283678,-0.288496,-0.253752,-0.05966,0.146193,0.116125,0.257015,0.276866,0.327987,0.360392,0.36891,0.48837,0.585658:-0.346891,-0.368324,-0.410751,-0.403621,-0.349574,-0.319146,-0.34684,-0.377208,-0.288463,-0.174928,-0.051111,0.018817,-0.002049,0.08886,0.097921,0.226765,0.292321,0.369541,0.466976,0.458137,0.466535:-0.163705,-0.134326,-0.055369,-0.01202,0.038492,0.057993,0.131137,0.276024,0.333418,0.336646,0.321688,0.312834,0.334632,0.31424,0.339892,0.284898,0.253247,0.223315,0.175444,0.207248,0.227798:-0.314514,-0.181914,-0.145721,-0.10826,-0.108269,-0.014682,0.033082,-0.004858,-0.053814,-0.037137,-0.030662,8.58E-4,0.073736,0.08594,0.02578,0.003929,0.030095,0.043783,0.024652,0.018847,-0.004744:-0.027883,-0.161955,-0.215837,-0.281512,-0.303519,-0.358915,-0.432339,-0.474062,-0.38835,-0.387068,-0.399505,-0.445928,-0.497956,-0.500635,-0.479979,-0.420974,-0.399094,-0.359049,-0.281615,-0.276958,-0.258403:-0.105903,-0.088992,-0.054852,0.017278,-0.008287,-0.07413,-0.122466,-0.167886,-0.289929,-0.332539,-0.34314,-0.279745,-0.245085,-0.228793,-0.186042,-0.190321,-0.172454,-0.162514,-0.210721,-0.223908,-0.192372:0.317081,0.301307,0.217205,0.088022,-0.007203,-0.031859,-0.020863,-0.027888,0.028225,0.01519,-0.006522,-0.059231,-0.09951,-0.118013,-0.129217,-0.124051,-0.126681,-0.121629,-0.102976,-0.081674,-0.149473:-0.296482,-0.35366,-0.352326,-0.309352,-0.259754,-0.227,-0.227352,-0.203846,-0.22959,-0.202181,-0.15874,-0.123382,-0.141861,-0.160894,-0.174217,-0.155341,-0.150638,-0.149408,-0.125486,-0.10808,-0.068075:-0.160977,-0.103249,-0.098076,-0.086166,-0.028023,-0.002432,0.02803,0.059727,0.022453,0.015159,-0.004236,-0.027585,0.028664,0.040116,0.032474,0.016966,0.019047,0.003909,-0.058026,-0.087887,-0.04533:0.110117,0.149515,0.168917,0.154583,0.162984,0.171315,0.169971,0.152298,0.181232,0.143572,0.095084,0.045702,-0.019973,-0.048056,-0.07477,-0.074131,-0.100214,-0.117223,-0.124899,-0.151297,-0.230929:5
1.517338,1.503757,1.654461,1.453745,1.576376,1.528412,1.408934,1.394904,1.211962,1.170018,1.097935,1.547186,1.469181:-0.525008,-0.583645,-0.82405,-0.720885,-0.870079,-0.94128,-0.947831,-1.040293,-0.988095,-1.033281,-1.006606,-1.374598,-1.29205:-0.287991,-0.28055,-0.225788,-0.37151,-0.306593,-0.25289,-0.234614,-0.100871,-0.007678,0.143311,0.184397,0.507458,0.56245:-0.519586,-0.492873,-0.404684,-0.251248,-0.213857,-0.122185,-0.060756,-0.094941,-0.040024,0.051545,0.151958,-0.020746,0.055669:-0.011306,0.036921,0.018769,0.021432,0.11631,0.099583,0.097754,0.190151,0.266131,0.240976,0.202973,0.21686,0.216227:-0.405751,-0.364912,-0.23256,-0.173112,-0.172767,-0.124706,-0.030959,-0.008787,-0.038495,-0.006707,-0.002499,-0.039247,-0.024802:-0.087975,-0.107838,-0.212397,-0.249554,-0.257912,-0.23322,-0.30095,-0.370966,-0.412827,-0.461205,-0.457022,-0.457981,-0.422085:0.112018,0.094092,0.119435,0.075517,0.005501,-0.158913,-0.242501,-0.276937,-0.282999,-0.249311,-0.228734,-0.155591,-0.171989:-0.027127,-0.082543,-0.138008,-0.176384,-0.220445,-0.184528,-0.142653,-0.129034,-0.121624,-0.123407,-0.129578,-0.170594,-0.173913:-0.205578,-0.224935,-0.250637,-0.250597,-0.235781,-0.193369,-0.192265,-0.171181,-0.118092,-0.129566,-0.131584,-0.097717,-0.092594:-0.172637,-0.153699,-0.041891,-0.003828,0.024089,-0.009398,-0.010072,-0.009285,-0.007734,0.03148,0.043556,0.027698,0.038082:0.147567,0.165092,0.120575,0.149783,0.171127,0.19177,0.18433,0.154352,0.089352,0.033269,-0.012196,-0.11522,-0.129171:5
1.528992,1.492016,1.662149,1.785769,1.428941,1.241511,1.144444,1.122943,1.061054,1.080404,1.084106,1.172169,1.096328,1.297435,1.216123,1.090061,0.939687:-0.466064,-0.518282,-0.781474,-1.062092,-0.933698,-0.900355,-0.897235,-0.850831,-0.830429,-0.906634,-0.94528,-1.038979,-1.044417,-1.249717,-1.162596,-1.115499,-1.00548:-0.53565,-0.526383,-0.431085,-0.260829,-0.26124,-0.207635,-0.182244,-0.148051,-0.145247,-0.080017,0.008093,0.114912,0.173313,0.375036,0.378954,0.400598,0.354126:-0.191694,-0.172762,-0.119427,-0.13839,-0.159502,-0.215257,-0.182389,-0.139342,-0.042188,-0.013454,0.068683,0.120645,0.167256,0.106384,0.176333,0.225765,0.287461:-0.219823,-0.154347,-0.024371,0.014128,0.040266,0.13686,0.208268,0.253256,0.226398,0.2144,0.168903,0.156499,0.14775,0.173772,0.106709,0.0974,0.089831:-0.106434,-0.099131,-0.137817,-0.096082,-0.013003,-0.006443,-0.047402,-0.074001,-0.06307,-0.047157,-0.006713,0.047313,0.079851,0.092269,0.108278,0.107181,0.096217:-0.114829,-0.138477,-0.183009,-0.177868,-0.243291,-0.275094,-0.251023,-0.27245,-0.276791,-0.282334,-0.354478,-0.410351,-0.416173,-0.387266,-0.324067,-0.2971,-0.261771:-0.081176,-0.07595,-0.024938,-0.107573,-0.145351,-0.171842,-0.256641,-0.298248,-0.325025,-0.319356,-0.253701,-0.210479,-0.217562,-0.249544,-0.25285,-0.241502,-0.22796:0.153612,0.073815,-0.055003,-0.085919,-0.051505,-0.051636,-0.068995,-0.048365,-0.051387,-0.093777,-0.138607,-0.174087,-0.186556,-0.177458,-0.206497,-0.204172,-0.206217:-0.271486,-0.277057,-0.199673,-0.158743,-0.231368,-0.274472,-0.21812,-0.206602,-0.20395,-0.189081,-0.195995,-0.205559,-0.180389,-0.148538,-0.120817,-0.121945,-0.119601:-0.137045,-0.098049,-0.063775,-0.050067,-0.046678,-0.033387,-0.046916,-0.057507,-0.037511,-0.025994,0.031147,0.078137,0.082882,0.086052,0.114865,0.106646,0.077436:0.144343,0.183285,0.176848,0.183022,0.233525,0.247381,0.22589,0.218651,0.175531,0.141776,0.088756,0.04849,0.01011,-0.041526,-0.081265,-0.084864,-0.094429:5
1.811815,1.808463,1.745243,1.6375,1.825152,1.762401,1.600525,1.587631,1.427858,1.60419,1.572684,1.60562,1.556225,1.526958:-0.300852,-0.445045,-0.456344,-0.471636,-0.736452,-0.777435,-0.795911,-0.920917,-0.901099,-1.101289,-1.135462,-1.252711,-1.299914,-1.281884:-0.238377,-0.19642,-0.229618,-0.341069,-0.256335,-0.316464,-0.245985,-0.076617,0.017906,0.212992,0.305864,0.464217,0.537942,0.564478:-0.496062,-0.506753,-0.451099,-0.305001,-0.269078,-0.100922,-0.110287,-0.174833,-0.127602,-0.068851,0.010116,0.034849,0.091211,0.100437:-0.046489,-0.002307,0.063664,0.06942,0.153022,0.074573,0.190975,0.34954,0.391105,0.375114,0.330791,0.265221,0.249601,0.259937:-0.438242,-0.40049,-0.379248,-0.280035,-0.233942,-0.157444,-0.064229,-0.080804,-0.078427,-0.082268,-0.099308,-0.126778,-0.17391,-0.154754:-0.12117,-0.138399,-0.165848,-0.222146,-0.246003,-0.228327,-0.376668,-0.440023,-0.45036,-0.47817,-0.482365,-0.47404,-0.429673,-0.425686:0.302573,0.240509,0.191072,0.108333,0.038504,-0.146013,-0.138189,-0.125107,-0.160375,-0.150659,-0.12124,-0.107324,-0.107534,-0.086156:-0.152057,-0.147529,-0.177557,-0.188745,-0.206724,-0.140853,-0.151871,-0.211359,-0.228188,-0.205439,-0.194533,-0.208019,-0.241903,-0.232317:-0.150568,-0.163405,-0.193893,-0.20991,-0.193043,-0.177875,-0.196166,-0.152121,-0.095913,-0.101838,-0.150203,-0.133665,-0.07536,-0.083623:-0.039768,-0.045407,-0.038273,0.024226,0.052549,0.017014,0.060917,0.088166,0.082601,0.037218,0.041029,0.040202,0.03174,0.044775:0.075202,0.111374,0.162749,0.197764,0.20811,0.227067,0.180309,0.07775,-0.005096,-0.054795,-0.077499,-0.12378,-0.160337,-0.175183:5
1.764475,1.857519,1.816499,1.74741,1.626178,1.411033,1.202859,1.311814,1.300342,1.18662:-0.787655,-0.902599,-1.070502,-1.127231,-1.114944,-1.102736,-1.115948,-1.333426,-1.419684,-1.357813:-0.283605,-0.253172,-0.135617,-0.092264,-0.059286,0.078761,0.181003,0.377778,0.45725,0.482558:-0.30954,-0.284545,-0.263647,-0.190803,-0.075041,-0.072144,0.003614,-0.023326,0.009325,0.069663:0.041181,0.127589,0.127568,0.116903,0.118808,0.220903,0.222638,0.207164,0.195493,0.212995:-0.304222,-0.307052,-0.262379,-0.168849,-0.079801,-0.128253,-0.132179,-0.120727,-0.114631,-0.159799:-0.16165,-0.164183,-0.19776,-0.287414,-0.393395,-0.417708,-0.42265,-0.437956,-0.41118,-0.348557:0.100728,0.028551,-0.047134,-0.117,-0.161942,-0.146724,-0.151581,-0.141141,-0.144353,-0.157822:-0.176463,-0.244352,-0.272582,-0.212217,-0.142897,-0.169998,-0.174068,-0.180703,-0.196733,-0.229383:-0.17557,-0.134414,-0.099053,-0.125223,-0.158565,-0.114766,-0.101611,-0.091354,-0.083326,-0.04764:0.029846,0.034172,0.06336,0.099856,0.13655,0.126208,0.108549,0.066225,0.023036,-0.014745:0.189705,0.210485,0.206005,0.204851,0.192995,0.095455,0.018438,-0.049334,-0.101255,-0.118952:5
1.450155,1.416866,1.519822,1.54397,1.569825,1.621353,1.615214,1.564768,1.507524,1.264947,1.194816,1.176227,1.340611:-0.082035,-0.069797,-0.143393,-0.20789,-0.299414,-0.470707,-0.542045,-0.577889,-0.665876,-0.610907,-0.60449,-0.671735,-0.858142:-0.690488,-0.698788,-0.712459,-0.764345,-0.755855,-0.602164,-0.528958,-0.492274,-0.359535,-0.222379,-0.163638,-0.119889,-0.025186:-0.137844,-0.159628,-0.149295,-0.059713,0.023363,0.038706,0.020602,0.090441,0.10342,0.139475,0.281793,0.401591,0.450602:-0.022954,-0.018244,0.074968,0.096689,0.110102,0.194518,0.318513,0.389791,0.40463,0.328634,0.30468,0.265256,0.226096:-0.435848,-0.401082,-0.427031,-0.393503,-0.347895,-0.338358,-0.3645,-0.37307,-0.365317,-0.286697,-0.267803,-0.232457,-0.189149:-0.014966,-0.00805,0.003639,0.00785,0.005072,-0.008513,-0.025815,-0.068007,-0.107237,-0.161682,-0.173324,-0.177683,-0.190942:-0.122232,-0.135217,-0.144406,-0.207156,-0.273491,-0.303523,-0.389755,-0.415364,-0.436204,-0.472683,-0.470221,-0.418359,-0.334225:0.136675,0.10984,0.051765,0.041027,0.015103,-0.07965,-0.108802,-0.130422,-0.122498,-0.028443,-0.009096,-0.068417,-0.154798:-0.229277,-0.264199,-0.243615,-0.266564,-0.277757,-0.196143,-0.116538,-0.090909,-0.056004,-0.111242,-0.137937,-0.109689,-0.054599:-0.099052,-0.085299,-0.113608,-0.067187,-0.012979,-0.025438,-0.047632,-0.040913,-0.076969,-0.05145,-0.044228,-0.033897,-0.021927:0.077682,0.094941,0.158603,0.158381,0.163552,0.213878,0.228046,0.212696,0.17801,0.120483,0.057309,-0.011267,-0.053056:5
1.234265,1.289484,1.486949,1.569452,1.488247,1.246134,1.127349,1.123136,1.215138,1.251415,1.196762,1.208546,1.087061:-0.352782,-0.47451,-0.668314,-0.821615,-0.840469,-0.782109,-0.785164,-0.816548,-0.902939,-1.011715,-1.003255,-1.05944,-1.004254:-0.409192,-0.404988,-0.33473,-0.240979,-0.21658,-0.192755,-0.179833,-0.129573,-0.001505,0.141561,0.2079,0.331586,0.31479:-0.339402,-0.326764,-0.263384,-0.220467,-0.182897,-0.198502,-0.066532,0.061644,0.143348,0.199513,0.229761,0.260911,0.343351:-0.084149,-0.015095,0.066174,0.05847,0.095882,0.328201,0.34654,0.321684,0.282027,0.252255,0.235219,0.231107,0.218261:-0.290722,-0.259611,-0.212396,-0.121786,-0.061737,-0.1223,-0.103297,-0.056391,-0.035071,-0.03946,-0.035783,-0.033853,-0.049747:-0.178887,-0.175717,-0.223111,-0.243394,-0.281874,-0.340865,-0.409007,-0.463995,-0.423486,-0.375446,-0.350411,-0.334044,-0.293305:0.076634,0.058243,0.065996,-0.056232,-0.216695,-0.240541,-0.228163,-0.225264,-0.234469,-0.222795,-0.210953,-0.191855,-0.209435:0.071346,-0.014131,-0.125971,-0.116262,-0.06809,-0.110724,-0.149791,-0.161192,-0.165918,-0.199287,-0.211942,-0.219728,-0.214002:-0.316735,-0.291169,-0.221393,-0.225718,-0.213604,-0.148518,-0.135447,-0.119366,-0.103589,-0.110097,-0.135344,-0.152643,-0.105694:-0.102333,-0.114816,-0.090532,-0.075775,-0.089396,-0.072408,-0.008557,0.027591,0.032048,0.054158,0.062298,0.068689,0.040707:0.095703,0.119809,0.10098,0.141133,0.200279,0.147251,0.096069,0.058205,0.024587,-0.006943,-0.014289,-0.037253,-0.080772:5
1.29441,1.285068,1.31259,1.190992,1.23824,1.186982,1.183708,1.228933,1.380815,1.444979:-0.456651,-0.558715,-0.668934,-0.679952,-0.859317,-0.995868,-1.032562,-1.092674,-1.277915,-1.349012:-0.34529,-0.351457,-0.360778,-0.371486,-0.212418,-0.0396,-0.060895,0.033113,0.341593,0.413439:-0.470935,-0.423085,-0.34379,-0.257651,-0.260035,-0.28125,-0.020042,0.122148,0.016415,0.072906:-0.063406,-0.013068,0.039491,0.077493,0.198244,0.308615,0.239907,0.200954,0.283366,0.220914:-0.301438,-0.265972,-0.202731,-0.146537,-0.150772,-0.165071,-0.117139,-0.053755,-0.088229,-0.121184:-0.127217,-0.141778,-0.168579,-0.234496,-0.30423,-0.354033,-0.367942,-0.422148,-0.482484,-0.440391:0.226067,0.17991,0.095327,0.041075,-0.002775,-0.06076,-0.177136,-0.209856,-0.145342,-0.124867:-0.145752,-0.19114,-0.239445,-0.246985,-0.274897,-0.284226,-0.207623,-0.162731,-0.200441,-0.205638:-0.26229,-0.278523,-0.286331,-0.293346,-0.245818,-0.17599,-0.152304,-0.134445,-0.096499,-0.129067:-0.001326,0.017411,0.052893,0.074874,0.123136,0.120197,0.095012,0.082356,0.104838,0.085589:0.110825,0.14607,0.189601,0.194533,0.161425,0.130748,0.11785,0.057045,-0.085868,-0.085734:5
1.556188,1.799154,1.982559,1.788647,1.61528,1.567858,1.438674,1.591148,1.585711,1.532581,1.631886,1.415463,1.539206:-0.508737,-0.832615,-1.021243,-0.909355,-0.835874,-0.867153,-0.812854,-1.008021,-1.066275,-1.097271,-1.175505,-1.002535,-1.168432:-0.288269,-0.173113,-0.076081,-0.157697,-0.135949,-0.152771,-0.145161,0.109809,0.261779,0.323469,0.451026,0.359801,0.529528:-0.403316,-0.348603,-0.297395,-0.168571,-0.232273,-0.055998,0.048733,-0.024943,0.009807,0.150977,0.097447,0.203023,0.160549:-0.011892,0.08769,0.121078,0.043324,0.145907,0.192317,0.233062,0.298215,0.258399,0.228397,0.23605,0.207432,0.200531:-0.204865,-0.197078,-0.206887,-0.07975,-0.026764,-0.080992,-0.060583,-0.033368,-0.044552,-0.051175,-0.071926,-0.059462,-0.067159:-0.22151,-0.242401,-0.234093,-0.302853,-0.439632,-0.425195,-0.446732,-0.458482,-0.429593,-0.431038,-0.444963,-0.406371,-0.391369:0.129939,0.112012,0.039136,-0.107687,-0.150611,-0.19371,-0.199805,-0.203294,-0.222745,-0.197226,-0.158182,-0.162546,-0.137793:-0.190746,-0.251881,-0.279482,-0.147473,-0.077026,-0.094951,-0.13242,-0.173754,-0.186682,-0.178182,-0.181506,-0.163536,-0.171577:-0.22102,-0.200193,-0.14995,-0.184274,-0.186607,-0.136676,-0.116837,-0.101845,-0.076963,-0.122788,-0.112106,-0.125644,-0.119031:0.088888,0.159357,0.147611,0.111461,0.105001,0.064036,0.07014,0.094788,0.071921,0.096975,0.093651,0.084579,0.07386:0.182615,0.182679,0.18569,0.241147,0.19117,0.140142,0.075971,-0.009522,-0.052546,-0.045325,-0.084298,-0.075878,-0.106643:5
1.363641,1.356381,1.335774,1.220544,1.282138,1.27907,1.188746,1.176478,1.135973,1.120789,1.084305,1.076796,0.968076,0.867449,0.88589,0.951456:-0.857357,-0.917703,-0.921287,-0.848258,-1.017974,-1.08129,-1.108431,-1.176966,-1.205583,-1.21742,-1.217276,-1.289599,-1.299901,-1.298835,-1.365468,-1.410594:0.433479,0.429165,0.436101,0.369077,0.407058,0.419934,0.398965,0.415514,0.42117,0.445953,0.476396,0.515768,0.51898,0.522142,0.57303,0.622492:-0.561207,-0.5643,-0.510569,-0.456191,-0.509721,-0.498598,-0.425799,-0.429518,-0.387681,-0.331399,-0.252129,-0.200795,-0.127626,-0.058738,-0.043716,-0.002878:-0.410652,-0.378362,-0.324963,-0.25463,-0.221277,-0.17929,-0.102895,-0.047051,0.003294,0.034313,0.044633,0.043969,0.065262,0.0822,0.109014,0.117071:-0.330171,-0.303611,-0.27875,-0.282908,-0.221554,-0.167344,-0.137603,-0.103649,-0.079032,-0.043215,-0.018452,-0.014993,-0.048749,-0.083168,-0.108412,-0.135264:0.168229,0.161072,0.125256,0.109059,0.085842,0.037318,-0.034322,-0.082543,-0.113643,-0.112582,-0.10306,-0.120055,-0.136025,-0.155989,-0.206333,-0.248687:0.083465,0.081611,0.077279,0.077588,0.060372,0.039791,0.006276,-0.028589,-0.095296,-0.172958,-0.214189,-0.220206,-0.221984,-0.225992,-0.212691,-0.209129:-0.360318,-0.380236,-0.391617,-0.391444,-0.447399,-0.463259,-0.43667,-0.447269,-0.448752,-0.476005,-0.498373,-0.503564,-0.494513,-0.457463,-0.419098,-0.390506:-0.058169,-0.087546,-0.14314,-0.195718,-0.193301,-0.220384,-0.270647,-0.265112,-0.214579,-0.14909,-0.129323,-0.121356,-0.118448,-0.113385,-0.08766,-0.053525:-0.045096,-0.060918,-0.046178,-0.029334,-0.029588,-0.011509,0.001079,0.014069,0.02234,0.047781,0.087974,0.109084,0.108887,0.084114,0.049277,0.0337:0.005623,0.030856,0.064571,0.09401,0.091612,0.09073,0.145417,0.167092,0.157854,0.116452,0.072998,0.029559,0.007131,-0.013204,-0.057117,-0.102117:6
1.506518,1.432682,1.289578,1.55428,1.473513,1.468968,1.599739,1.358473,1.237094,1.178909,1.256547,1.302987,1.106886,1.326539:-0.47758,-0.47895,-0.414913,-0.627803,-0.631608,-0.677049,-0.784729,-0.600054,-0.588902,-0.565338,-0.617234,-0.63764,-0.466482,-0.703369:0.347051,0.47701,0.435126,0.452311,0.412176,0.384759,0.438101,0.318957,0.354581,0.391371,0.483916,0.588628,0.582594,0.616039:-0.196051,-0.261931,-0.209729,-0.163595,-0.140054,-0.11599,-0.06912,0.069944,0.146921,0.163436,0.122388,0.09034,0.134799,0.253465:-0.234443,-0.162024,-0.075281,-0.042263,-0.028664,0.043163,0.073247,0.116826,0.131132,0.229192,0.297198,0.303861,0.268751,0.304666:-0.341504,-0.317716,-0.296973,-0.326752,-0.25605,-0.240371,-0.245614,-0.181324,-0.185878,-0.209063,-0.231638,-0.21317,-0.183822,-0.29404:0.248989,0.253211,0.200807,0.241665,0.19852,0.121774,0.068054,0.024637,0.022192,0.003319,-0.013171,-0.062761,-0.114139,-0.094796:0.013626,0.013804,0.087506,0.015873,-0.053094,-0.069809,-0.103908,-0.190099,-0.260656,-0.257703,-0.249463,-0.211774,-0.171082,-0.213522:-0.443739,-0.510133,-0.518766,-0.554284,-0.536773,-0.552223,-0.583147,-0.50017,-0.47458,-0.509019,-0.520489,-0.520435,-0.442293,-0.440858:-0.089728,-0.086865,-0.130761,-0.141345,-0.175583,-0.178979,-0.155666,-0.186496,-0.116644,-0.061331,-0.029244,-0.024027,-0.056117,0.047296:-0.015233,-0.016282,-1.45E-4,-0.054282,-0.035589,0.005489,0.048465,0.086239,0.081497,0.106604,0.076381,0.078113,0.077191,0.011252:0.009893,0.041893,0.023152,0.113436,0.126977,0.131421,0.13515,0.147167,0.106681,0.081274,0.092586,0.044185,-0.045769,-0.092023:6
1.417991,1.501911,1.430086,1.360812,1.310157,1.227942,1.437762,1.26975,1.334437,1.293983,0.95844,0.886988,1.018928,1.166187,1.146484,0.997014:-0.610545,-0.69033,-0.554699,-0.587052,-0.532234,-0.435215,-0.556135,-0.516221,-0.588643,-0.633757,-0.631124,-0.581575,-0.656036,-0.877628,-0.982897,-0.909116:0.581785,0.5831,0.561697,0.655741,0.677795,0.659068,0.806847,0.738758,0.618679,0.463207,0.426359,0.49406,0.58365,0.674242,0.630473,0.504625:-0.355309,-0.324791,-0.486221,-0.339845,-0.429265,-0.465959,-0.516402,-0.486409,-0.446217,-0.278948,0.064598,8.54E-4,-0.130439,0.014775,0.134392,0.197257:-0.329618,-0.362622,-0.230167,-0.208794,-0.040572,0.016168,-0.016568,0.06354,0.135476,0.27176,0.177912,0.309765,0.379457,0.282115,0.260221,0.313204:-0.352661,-0.296562,-0.221665,-0.171364,-0.102906,-0.025087,0.003243,-0.019384,-0.029823,-0.071753,-0.068989,-0.168179,-0.210776,-0.196408,-0.168709,-0.214501:0.116122,0.106605,0.05462,0.07471,0.02267,-0.001594,-0.067607,-0.077638,-0.133302,-0.166026,-0.091605,-0.125649,-0.193056,-0.197994,-0.241691,-0.223222:0.115162,0.117334,0.087701,0.011015,-0.092463,-0.116081,-0.080958,-0.137004,-0.213928,-0.214208,-0.277069,-0.203999,-0.174959,-0.204622,-0.190917,-0.214505:-0.37436,-0.362146,-0.400758,-0.372588,-0.426827,-0.461233,-0.530782,-0.53434,-0.502866,-0.466821,-0.41785,-0.439989,-0.447816,-0.410732,-0.332142,-0.272577:-0.144372,-0.192558,-0.229001,-0.20382,-0.191915,-0.193449,-0.205713,-0.157945,-0.090659,-0.104819,-0.156889,-0.106765,-0.00902,0.007921,-0.023899,0.006797:-0.0326,0.01165,0.025984,-0.017031,0.00704,0.036432,0.083053,0.096644,0.085662,0.072831,0.107802,0.057284,-0.00178,0.005969,0.033978,-0.018184:-0.001328,0.012427,0.068591,0.12255,0.23301,0.163571,0.100014,0.098913,0.103225,0.099989,0.092936,0.038356,-0.031804,-0.07895,-0.144158,-0.151839:6
1.27262,1.143689,1.108706,1.118812,1.158854,1.141314,1.125348,1.135177,1.093941,1.094296,1.008653,1.001011,0.912565,0.885434,0.841391,0.74217,0.71023:-0.953621,-0.956041,-0.998301,-1.039983,-1.075493,-1.064326,-1.073425,-1.106186,-1.087381,-1.106407,-1.098314,-1.135242,-1.098152,-1.151298,-1.219128,-1.206813,-1.232399:0.48,0.454725,0.434609,0.436091,0.449779,0.419973,0.389187,0.402005,0.400928,0.442391,0.435293,0.456465,0.451865,0.491039,0.521016,0.538266,0.573737:-0.403965,-0.386494,-0.342924,-0.324273,-0.323965,-0.315031,-0.275676,-0.248515,-0.197998,-0.150461,-0.10859,-0.065059,0.004763,0.076015,0.137341,0.210561,0.244047:-0.515487,-0.453272,-0.404831,-0.348771,-0.291293,-0.24199,-0.191323,-0.134481,-0.059613,0.006817,0.052016,0.087848,0.14013,0.168326,0.183122,0.192033,0.195823:-0.349435,-0.315686,-0.282502,-0.272946,-0.266805,-0.256044,-0.244574,-0.221701,-0.211224,-0.200445,-0.199857,-0.196614,-0.228279,-0.273264,-0.303818,-0.303871,-0.284348:0.263457,0.214426,0.186451,0.189213,0.188222,0.184229,0.150606,0.087427,0.029657,-0.010781,-0.033689,-0.086582,-0.114552,-0.113923,-0.105194,-0.140008,-0.192897:0.009761,-0.020056,-0.039275,-0.025724,-0.012057,-0.036877,-0.050946,-0.070063,-0.132604,-0.184127,-0.204088,-0.19105,-0.188272,-0.196833,-0.205848,-0.219471,-0.219908:-0.37411,-0.362168,-0.382541,-0.444504,-0.506143,-0.535181,-0.548585,-0.547454,-0.536946,-0.559818,-0.556481,-0.555488,-0.546051,-0.529044,-0.496864,-0.452802,-0.410096:0.039202,-0.005768,-0.041247,-0.066938,-0.083761,-0.10907,-0.132628,-0.147703,-0.124454,-0.08501,-0.082302,-0.06277,-0.024524,0.020184,0.046617,0.041266,0.031305:-0.021781,-0.014389,-0.001162,0.002443,0.005283,0.016936,0.045383,0.058085,0.059367,0.088593,0.100486,0.132686,0.13581,0.104671,0.048522,0.037193,0.033173:-0.067136,-0.034958,-0.025135,-0.013639,0.009354,0.047488,0.060368,0.069172,0.086334,0.087822,0.091345,0.045602,-0.009656,-0.064072,-0.109873,-0.144051,-0.173405:6
1.280221,1.189719,1.180677,1.227566,1.198781,1.209542,1.071482,1.270707,1.139028,0.966258,1.02853,0.994806,0.899629,0.878232,0.843849,0.841155:-0.505663,-0.457072,-0.442537,-0.455229,-0.36024,-0.38034,-0.431299,-0.745474,-0.814854,-0.823738,-0.947674,-1.008018,-1.041965,-1.098483,-1.117931,-1.151452:0.451366,0.446413,0.451003,0.435601,0.290643,0.12124,0.122996,0.292901,0.262039,0.310624,0.408721,0.448556,0.451253,0.521334,0.565294,0.629803:-0.567728,-0.601227,-0.585727,-0.597337,-0.564543,-0.447418,-0.316834,-0.330925,-0.276223,-0.302269,-0.302978,-0.266941,-0.174008,-0.133909,-0.061494,-0.008958:-0.430399,-0.381993,-0.330509,-0.265189,-0.157461,-0.030549,0.027782,-0.002878,0.047143,0.114247,0.117146,0.126045,0.104853,0.119688,0.13669,0.145361:-0.31858,-0.312805,-0.25488,-0.241907,-0.277166,-0.298428,-0.273202,-0.224592,-0.201634,-0.165197,-0.10402,-0.086723,-0.10107,-0.105962,-0.10958,-0.115133:0.281754,0.306457,0.235961,0.235061,0.271962,0.278467,0.229081,0.179226,0.155737,0.065946,-0.011957,-0.044543,-0.049059,-0.093956,-0.134289,-0.160718:-0.05309,-0.062579,0.014061,0.015489,-0.041273,-0.084419,-0.123201,-0.129433,-0.155118,-0.15745,-0.164726,-0.208758,-0.251997,-0.265557,-0.270135,-0.270561:-0.326722,-0.340409,-0.364603,-0.379128,-0.362868,-0.43578,-0.461276,-0.513791,-0.515097,-0.502982,-0.516297,-0.510852,-0.488982,-0.472979,-0.441325,-0.425041:0.014249,-0.036933,-0.10641,-0.136211,-0.169238,-0.141896,-0.157361,-0.147532,-0.15517,-0.166799,-0.142464,-0.091831,-0.070994,-0.025836,-0.006871,0.014996:-0.166863,-0.172943,-0.092797,-0.10436,-0.148919,-0.134463,-0.099115,-0.086925,-0.06187,-0.02724,-1.45E-4,0.003891,0.022711,0.02799,0.039665,0.044928:-0.005951,0.057632,0.028997,0.072151,0.136082,0.125724,0.147679,0.172837,0.165107,0.159471,0.11055,0.060349,0.022296,-0.020062,-0.05264,-0.087053:6
1.700086,1.869226,1.820374,1.779567,1.845931,1.417793,1.561344,1.498159,1.59408,1.497732,1.331647,1.412948,1.285735,1.332666,1.15712,0.817373,0.792734,1.072058,1.043603:-0.567929,-0.566148,-0.622146,-0.64244,-0.688143,-0.476522,-0.753027,-0.838888,-0.980553,-0.923619,-0.869128,-0.955984,-0.952388,-1.091938,-1.059135,-0.959463,-0.96761,-1.106394,-1.163382:0.540806,0.328457,0.293829,0.31314,0.356464,0.180222,0.356292,0.346559,0.469611,0.443928,0.435702,0.46191,0.435284,0.564832,0.542473,0.519934,0.543315,0.586216,0.596998:-0.194175,-0.193968,-0.191691,-0.210551,-0.21789,-0.112946,-0.158297,-0.015162,-0.053774,0.03004,0.142914,0.140379,0.195282,0.108809,0.149508,0.114987,0.138139,0.156926,0.198437:-0.172369,-0.105167,-0.112787,-0.111395,-0.072823,0.076253,0.011404,-0.065086,-0.019716,0.019076,-0.012075,-0.006027,0.036145,0.101748,0.130607,0.219464,0.229312,0.158131,0.148919:-0.460285,-0.416517,-0.288117,-0.224206,-0.23439,-0.251954,-0.259459,-0.146293,-0.186324,-0.206638,-0.120646,-0.143209,-0.154922,-0.179072,-0.201932,-0.301544,-0.297976,-0.246151,-0.215257:0.141621,0.123053,0.075847,0.088608,0.051089,0.070185,0.122813,0.052601,3.29E-4,0.002485,-0.053959,-0.045887,-0.045671,-0.083488,-0.053662,-0.015152,-0.025655,-0.060298,-0.109096:-0.020247,0.010561,-0.036326,-0.11211,-0.164073,-0.16217,-0.228703,-0.271761,-0.254481,-0.292915,-0.319662,-0.320473,-0.318172,-0.268394,-0.289895,-0.310276,-0.331803,-0.321102,-0.296484:-0.418508,-0.436978,-0.398063,-0.39324,-0.380943,-0.403076,-0.509813,-0.454541,-0.520316,-0.500735,-0.419027,-0.438378,-0.430082,-0.470705,-0.44945,-0.424904,-0.406543,-0.417523,-0.394798:-0.095641,-0.216588,-0.237404,-0.201084,-0.169311,-0.164338,-0.084184,-0.157241,-0.094381,-0.086713,-0.142922,-0.119143,-0.108865,-0.046294,-0.035153,-0.001497,0.011617,0.031173,0.004138:-0.139638,-0.1009,-0.095029,-0.140066,-0.192176,-0.123624,-0.121974,-0.023926,0.004405,0.016117,0.059879,0.061857,0.068875,0.042699,0.005591,-0.078023,-0.095497,-0.071897,-0.041266:0.143834,0.17395,0.127403,0.108717,0.157641,0.117311,0.137255,0.103804,0.083348,0.100871,0.104062,0.09805,0.073743,0.018247,0.021117,0.08141,0.080413,-0.005252,-0.05978:6
1.330126,1.358914,1.302974,1.240517,1.39637,1.424961,1.356231,1.281982,1.187617,1.249225,1.23089,1.235792,1.176846,1.228294,1.371317,1.408469,1.165271,1.05617:-0.365854,-0.447801,-0.449392,-0.706588,-0.930489,-0.836658,-0.796289,-0.778254,-0.750682,-0.834714,-0.868235,-0.942245,-0.922655,-0.954524,-1.085642,-1.194426,-1.15267,-1.214917:0.338942,0.316253,0.249938,0.167945,0.294869,0.440343,0.427829,0.405293,0.383316,0.441083,0.464848,0.550304,0.527238,0.519914,0.578447,0.624819,0.564982,0.613419:-0.367605,-0.394978,-0.318744,-0.110604,-0.157992,-0.27483,-0.221491,-0.189682,-0.16069,-0.16466,-0.075057,-0.058214,0.039852,0.140226,0.198541,0.187359,0.232645,0.202604:-0.226475,-0.184778,-0.128737,-0.09529,-0.085716,-0.092705,-0.029426,0.026838,0.079575,0.101842,0.070347,0.072703,0.101454,0.103383,0.077105,0.081302,0.084858,0.106553:-0.384276,-0.340993,-0.384264,-0.302025,-0.197767,-0.162214,-0.165116,-0.153829,-0.136924,-0.121134,-0.074653,-0.047124,-0.094824,-0.104809,-0.056703,-0.096577,-0.111024,-0.121055:0.262204,0.216411,0.214296,0.110462,0.129747,0.06806,0.04426,0.035171,0.019022,-0.003553,-0.015108,-0.023629,-0.002843,-0.052412,-0.145714,-0.164965,-0.160013,-0.181026:-0.058797,0.014862,0.001752,0.030478,0.045375,-0.010679,-0.075865,-0.140536,-0.167126,-0.185288,-0.21826,-0.212361,-0.243595,-0.253301,-0.258596,-0.267651,-0.307039,-0.299686:-0.303528,-0.353258,-0.329319,-0.341735,-0.39037,-0.414262,-0.424346,-0.459236,-0.496547,-0.52157,-0.499989,-0.516937,-0.513305,-0.47311,-0.410398,-0.421534,-0.394943,-0.387513:-0.08319,-0.123006,-0.092723,-0.17741,-0.234755,-0.217726,-0.189813,-0.166489,-0.153355,-0.129371,-0.146565,-0.134071,-0.087921,-0.076867,-0.101303,-0.052423,-0.035543,-0.004119:-0.145056,-0.114951,-0.129687,-0.022723,-0.061104,-0.08009,-0.078038,-0.041029,0.001296,0.013733,0.056535,0.077451,0.071101,0.083989,0.099206,0.088982,0.065854,0.0486:0.100625,0.078005,0.116931,0.090291,0.055108,0.093224,0.112758,0.12163,0.106077,0.106501,0.100012,0.063973,0.033003,-0.027509,-0.073934,-0.120013,-0.122159,-0.157385:6
1.584863,1.362149,1.261508,1.341368,1.46919,1.511445,1.512608,1.529306,1.10702,1.427518,1.567936,1.505391,1.256352,1.228427,1.23929,1.211959,1.180123,1.068187,0.976749,1.077934:-0.844085,-0.795459,-0.855714,-0.941555,-1.053543,-1.156112,-1.270324,-1.313317,-1.001897,-1.254006,-1.349246,-1.356352,-1.268644,-1.347629,-1.416034,-1.402145,-1.436934,-1.41371,-1.428528,-1.529583:0.385709,0.362527,0.390795,0.390042,0.399398,0.407861,0.445095,0.435136,0.256741,0.46435,0.521382,0.535072,0.499605,0.538882,0.567001,0.554354,0.600475,0.582511,0.614005,0.690222:-0.346245,-0.315622,-0.30128,-0.213718,-0.232515,-0.247615,-0.191613,-0.166197,0.05267,-0.094541,-0.031899,0.039263,0.076722,0.023968,0.075508,0.133091,0.110623,0.179437,0.19993,0.168499:-0.505911,-0.39821,-0.320696,-0.35231,-0.324706,-0.276981,-0.272057,-0.245514,-0.262592,-0.179488,-0.192128,-0.199086,-0.159075,-0.111124,-0.1085,-0.082979,-0.044566,-0.029235,-0.009196,-0.012279:-0.354922,-0.360246,-0.34182,-0.283816,-0.234059,-0.188428,-0.106862,-0.074178,-0.040368,-0.036312,0.010882,0.034314,0.008874,-0.022151,-0.017392,-0.057076,-0.076591,-0.094929,-0.116092,-0.100104:0.332525,0.313431,0.277322,0.230915,0.194713,0.141758,0.06512,0.034465,0.030508,-0.017647,-0.074729,-0.09095,-0.080693,-0.07909,-0.124941,-0.141387,-0.171059,-0.177374,-0.193874,-0.228132:-0.074434,-0.083452,-0.096108,-0.100694,-0.078413,-0.076785,-0.101627,-0.136451,-0.23074,-0.234249,-0.256339,-0.289647,-0.311999,-0.295277,-0.296912,-0.309768,-0.298738,-0.31392,-0.303064,-0.281027:-0.414116,-0.379317,-0.404833,-0.414305,-0.466388,-0.490682,-0.455172,-0.458463,-0.402836,-0.442321,-0.396939,-0.359162,-0.365182,-0.415115,-0.395405,-0.386658,-0.388351,-0.362799,-0.347033,-0.338941:-0.03546,-0.085081,-0.089959,-0.141412,-0.180271,-0.212431,-0.273883,-0.278129,-0.279974,-0.212281,-0.21901,-0.21287,-0.172494,-0.142783,-0.157121,-0.124815,-0.089774,-0.082735,-0.073503,-0.062057:-0.080923,-0.124448,-0.143466,-0.075791,-0.045397,-0.036089,-0.009172,0.020289,0.030066,0.051375,0.068549,0.055945,0.051697,0.063325,0.083156,0.083745,0.073705,0.052223,0.029606,0.030791:0.012524,0.082307,0.110168,0.101672,0.103452,0.120987,0.156168,0.170508,0.209097,0.15915,0.150273,0.140345,0.093684,0.040289,0.02446,-0.004015,-0.049097,-0.058832,-0.073938,-0.107679:6
1.579189,1.413253,1.469604,1.593599,1.553632,1.516024,1.720189,1.732294,1.680505,1.514412,1.308258,1.281894,1.41032,1.24151,1.216207,1.134136,1.354973,1.310946:-1.276039,-1.253364,-1.480902,-1.624337,-1.540699,-1.430395,-1.536323,-1.568544,-1.541408,-1.453808,-1.365956,-1.429286,-1.585489,-1.44958,-1.515929,-1.49656,-1.596429,-1.678867:0.458562,0.347769,0.412846,0.465941,0.412083,0.328152,0.375467,0.414715,0.436076,0.387462,0.35328,0.40747,0.461177,0.371016,0.388427,0.405035,0.5051,0.549266:-0.081549,-0.020123,-0.111937,-0.126139,-0.087903,-0.004092,0.007566,0.057074,0.042021,0.046531,0.105918,0.116306,0.094289,0.233951,0.382583,0.467523,0.357831,0.412029:-0.66138,-0.591131,-0.514603,-0.528729,-0.450045,-0.347729,-0.29637,-0.263907,-0.197004,-0.118454,-0.076056,-0.060258,-0.088991,-0.088942,-0.122574,-0.130099,-0.035639,-0.060544:-0.229169,-0.258082,-0.248586,-0.194795,-0.206648,-0.216302,-0.190728,-0.158835,-0.142432,-0.151972,-0.154561,-0.148369,-0.091892,-0.068046,-0.078424,-0.079521,-0.090354,-0.099647:0.143208,0.132924,0.111636,0.10884,0.126888,0.110723,0.060672,0.028757,0.001887,-0.014363,-0.046257,-0.060211,-0.072335,-0.099964,-0.127274,-0.163123,-0.201306,-0.174798:-0.045948,-0.030587,-0.005762,-0.0127,-0.047299,-0.062548,-0.032616,-0.060671,-0.093644,-0.132324,-0.204752,-0.261966,-0.27891,-0.352769,-0.349941,-0.333735,-0.303722,-0.297228:-0.283937,-0.300024,-0.358112,-0.404404,-0.460796,-0.479896,-0.528128,-0.523132,-0.536544,-0.519709,-0.463196,-0.478062,-0.513547,-0.42933,-0.412388,-0.394174,-0.380633,-0.367793:-0.119201,-0.15834,-0.182455,-0.212921,-0.199131,-0.241923,-0.296385,-0.310831,-0.283971,-0.252386,-0.218795,-0.132841,-0.117969,-0.139115,-0.135631,-0.133058,-0.126919,-0.112363:0.041106,0.02674,0.049667,0.095224,0.100901,0.107121,0.187121,0.194255,0.167495,0.115214,0.069516,0.077445,0.135217,0.109624,0.135956,0.152831,0.155032,0.135376:-0.023814,-0.011771,-0.020886,-0.019343,0.004584,0.071337,0.093276,0.117079,0.08945,0.087191,0.099931,0.031383,-0.011261,0.052078,0.035902,0.025502,-0.008508,-0.037042:6
1.260308,1.111078,0.966461,1.207213,1.474308,1.365198,1.402734,1.425864,1.48213,1.425185,1.256772,1.180771,1.174196,1.16113,1.165946,1.117817,1.089142,1.229198:-0.35414,-0.454499,-0.489973,-0.293979,-0.202886,-0.238689,-0.591023,-0.743038,-0.636304,-0.776208,-0.882628,-0.984758,-1.043666,-1.093048,-1.22011,-1.279367,-1.315186,-1.471116:0.584624,0.634587,0.600966,0.522558,0.224587,0.241586,0.467882,0.507534,0.323641,0.421467,0.462226,0.536286,0.550358,0.512025,0.54444,0.585504,0.602797,0.695688:-0.382856,-0.550885,-0.622602,-0.620327,-0.416362,-0.342121,-0.36813,-0.377961,-0.24917,-0.206353,-0.138271,-0.118385,-0.062227,0.029834,0.13439,0.176064,0.220715,0.254741:-0.463628,-0.389085,-0.270021,-0.254737,-0.072842,0.020247,-0.042211,-0.023749,0.130538,0.087875,0.069612,0.056348,0.054113,0.065011,0.03871,0.050585,0.047872,-0.008225:-0.26209,-0.1033,-0.093685,-0.206805,-0.318752,-0.322414,-0.190828,-0.122338,-0.153207,-0.089293,-0.039749,-0.057904,-0.128864,-0.205494,-0.149089,-0.142226,-0.134119,-0.079698:0.414763,0.256748,0.229093,0.308841,0.284778,0.232695,0.128984,0.037858,0.017503,-0.021124,-0.04156,-0.02747,0.001778,0.001678,-0.081973,-0.096136,-0.096059,-0.154538:-0.060087,-0.122457,-0.077232,-0.071701,-0.035164,-0.032291,-0.040858,-0.051739,-0.171569,-0.237723,-0.280727,-0.291433,-0.317578,-0.348405,-0.348675,-0.350766,-0.342546,-0.302934:-0.257893,-0.286601,-0.310229,-0.404836,-0.509822,-0.537671,-0.479221,-0.448333,-0.426547,-0.451821,-0.471027,-0.513781,-0.521254,-0.480436,-0.414006,-0.391355,-0.367655,-0.331143:0.100878,0.001122,-0.074867,-0.069359,-0.068546,-0.102674,-0.154255,-0.183491,-0.147755,-0.108187,-0.08222,-0.049002,-0.003478,0.044736,0.023747,0.051657,0.05468,0.01661:-0.132338,-0.121157,-0.171229,-0.15539,-0.117975,-0.077065,-0.050024,-0.023402,-0.058884,-0.001821,0.042993,0.055745,0.018378,-0.019909,0.014456,0.011024,0.013313,0.046111:-0.046447,-0.009675,0.027297,0.021694,0.040711,0.099603,0.136356,0.181729,0.217957,0.163897,0.080946,0.03824,0.02778,-0.002818,-0.068115,-0.10175,-0.119865,-0.162584:6
1.204473,1.144159,1.140901,1.2202,1.336634,1.192498,1.230732,1.181445,1.11708,1.053908,1.080708,0.998283,0.991295,0.925066,0.862461,0.878623,0.753486:-0.992381,-0.911079,-0.871391,-0.88055,-0.952533,-0.950961,-1.083304,-1.073742,-1.067165,-1.071724,-1.156719,-1.230345,-1.295075,-1.309536,-1.322619,-1.371336,-1.302457:0.515337,0.516717,0.527094,0.509184,0.482296,0.455721,0.496309,0.502783,0.484317,0.456154,0.505995,0.555648,0.590859,0.591364,0.607784,0.651313,0.618385:-0.455605,-0.408827,-0.385613,-0.377101,-0.333888,-0.266973,-0.257757,-0.164614,-0.088695,-0.017992,0.059299,0.105243,0.149031,0.183042,0.20964,0.21037,0.291121:-0.305134,-0.296233,-0.22169,-0.161056,-0.140526,-0.083906,-0.05154,-4.26E-4,0.067649,0.094809,0.083267,0.114852,0.139688,0.167685,0.187967,0.191204,0.186717:-0.20125,-0.160387,-0.165051,-0.181756,-0.177913,-0.159067,-0.128568,-0.111104,-0.053496,-0.033694,-0.042041,-0.068125,-0.099397,-0.11598,-0.118896,-0.12949,-0.158756:0.200322,0.18996,0.167701,0.170267,0.154826,0.089241,0.021311,-0.03002,-0.06019,-0.037922,-0.037997,-0.069618,-0.095824,-0.105345,-0.133749,-0.161193,-0.172847:0.003572,-0.011971,0.012386,0.017128,0.014361,0.001831,-0.013,-0.07362,-0.158077,-0.20436,-0.21612,-0.22437,-0.220747,-0.228035,-0.222333,-0.208531,-0.222691:-0.47325,-0.448447,-0.489132,-0.540155,-0.563606,-0.53358,-0.533414,-0.491942,-0.450691,-0.4723,-0.497859,-0.497967,-0.492262,-0.485153,-0.463847,-0.435706,-0.373542:-0.102021,-0.168772,-0.186036,-0.195433,-0.224264,-0.280397,-0.272051,-0.245469,-0.201454,-0.171753,-0.152161,-0.111671,-0.086709,-0.066449,-0.065982,-0.05599,-0.065695:-0.088639,-0.070778,-0.050633,-0.053094,-0.042616,-0.032772,0.004722,0.021574,0.013419,0.037728,0.084501,0.080774,0.069662,0.058641,0.050996,0.024012,0.00172:-0.034601,0.005435,0.006082,0.01668,0.02525,0.062975,0.055499,0.073842,0.067741,0.029617,-0.019388,-0.072344,-0.103685,-0.12265,-0.141375,-0.164959,-0.1574:6
1.388185,1.421275,1.492029,1.300695,1.4691,1.491153,1.334861,1.339048,1.417724,1.421113,1.274699,1.198083,1.063657,1.079915,1.216228,1.093386:-0.651899,-0.689829,-0.743624,-0.635672,-0.79856,-0.864345,-0.804017,-0.858948,-0.939161,-0.981838,-0.996665,-1.043834,-1.062507,-1.134952,-1.279336,-1.277942:0.762845,0.728933,0.703005,0.591243,0.673624,0.635858,0.519747,0.509313,0.517774,0.486859,0.491163,0.553767,0.603842,0.662315,0.728633,0.72418:-0.766083,-0.706491,-0.605173,-0.485219,-0.516436,-0.418519,-0.297613,-0.242687,-0.213616,-0.150098,-0.031379,0.034779,0.102827,0.160418,0.182186,0.269536:-0.550149,-0.495728,-0.461364,-0.38777,-0.354215,-0.29026,-0.201476,-0.094833,5.37E-4,0.08819,0.125903,0.167623,0.191054,0.203388,0.181193,0.213457:-0.094115,-0.104389,-0.081685,-0.063266,-0.046376,-0.042411,-0.011327,-0.047606,-0.090378,-0.055049,0.012521,-0.009704,-0.072413,-0.112526,-0.138766,-0.152171:0.1472,0.202623,0.201122,0.199512,0.189209,0.147909,0.099343,0.055965,0.021065,-0.066104,-0.116346,-0.104611,-0.099377,-0.115454,-0.132726,-0.129653:-0.004834,-0.026697,-0.02822,-0.04916,-0.025901,-0.040788,-0.113238,-0.117841,-0.12759,-0.174076,-0.254998,-0.27562,-0.267113,-0.256617,-0.222036,-0.207618:-0.292513,-0.391781,-0.41709,-0.392698,-0.480914,-0.496083,-0.487058,-0.538314,-0.58377,-0.511478,-0.433539,-0.463951,-0.477384,-0.480269,-0.483358,-0.430085:0.016606,0.020906,-0.040212,-0.122119,-0.133485,-0.174221,-0.216005,-0.220839,-0.182658,-0.163134,-0.087079,0.007282,0.025363,0.044745,0.069366,0.068687:-0.114098,-0.115574,-0.092803,-0.075309,-0.050216,-0.007322,0.046329,0.086153,0.08286,0.044796,0.042204,0.069956,0.073191,0.062384,0.058733,0.040497:-0.150734,-0.142518,-0.124595,-0.065823,-0.069565,-0.037555,0.015473,0.054401,0.073426,0.078703,-0.001722,-0.126327,-0.153569,-0.190528,-0.246741,-0.241246:6
1.199748,1.19421,1.092678,1.146875,1.131741,1.120028,1.095645,1.166136,1.017718,1.13181,1.073087,1.032602,0.912833,0.982213,0.945345,0.920761:-0.939892,-1.033042,-1.044986,-1.157156,-1.194772,-1.215193,-1.204229,-1.311131,-1.268343,-1.401879,-1.414361,-1.462454,-1.416601,-1.471513,-1.457538,-1.475963:0.673849,0.680399,0.640004,0.638228,0.617467,0.614607,0.604538,0.645109,0.630207,0.664475,0.675732,0.702377,0.71507,0.758612,0.771678,0.789809:-0.591709,-0.568862,-0.50362,-0.506196,-0.46863,-0.40579,-0.31702,-0.283203,-0.199762,-0.214115,-0.156317,-0.094993,0.015449,0.043814,0.083852,0.118671:-0.3818,-0.375185,-0.337498,-0.282101,-0.207965,-0.142715,-0.092841,-0.087247,-0.031084,-0.023228,0.019742,0.043073,0.088516,0.098014,0.119247,0.126658:-0.030972,0.003556,-0.011718,-0.005625,-0.008322,-0.006355,0.008386,0.050972,0.038169,0.049833,0.005057,-0.023541,-0.057897,-0.056412,-0.055607,-0.048649:0.172566,0.113487,0.089227,0.060042,0.037166,0.008872,-0.042915,-0.086388,-0.10203,-0.116874,-0.147586,-0.194959,-0.222807,-0.219121,-0.194941,-0.185338:-0.06763,-0.076981,-0.086279,-0.078993,-0.080674,-0.102461,-0.141344,-0.175643,-0.203986,-0.197189,-0.197678,-0.207992,-0.233279,-0.234756,-0.228606,-0.214422:-0.462255,-0.481052,-0.487197,-0.529835,-0.547476,-0.55324,-0.530551,-0.526566,-0.527004,-0.548926,-0.5442,-0.501386,-0.465786,-0.462201,-0.449785,-0.423625:-0.091757,-0.152718,-0.176948,-0.179995,-0.187166,-0.16904,-0.183418,-0.188396,-0.185674,-0.162264,-0.128508,-0.089938,-0.054538,-0.003946,0.019927,0.023959:-0.082961,-0.017426,0.011844,0.036049,0.046219,0.065837,0.096043,0.122335,0.129879,0.130962,0.129974,0.113664,0.112606,0.107954,0.10111,0.087493:-0.084846,-0.060483,-0.038906,-0.023804,-0.005248,-0.011259,0.015255,0.006427,3.6E-4,-0.052838,-0.086657,-0.127294,-0.147482,-0.196633,-0.210676,-0.226882:6
1.277207,1.263267,1.161705,1.330224,1.298243,1.238066,1.219298,1.156879,0.993283,1.128383,1.039385,0.78735,0.904596,0.878922,0.939126,0.911341:-0.992207,-1.071407,-1.068723,-1.099603,-1.050692,-1.112697,-1.162386,-1.127325,-1.073248,-1.285479,-1.338071,-1.156813,-1.229262,-1.254144,-1.312961,-1.319096:0.654349,0.652389,0.624726,0.66053,0.649894,0.64249,0.637449,0.64139,0.601863,0.699453,0.721152,0.635551,0.706499,0.723789,0.777676,0.826925:-0.533625,-0.518115,-0.460843,-0.453199,-0.375146,-0.383818,-0.318616,-0.184533,-0.044761,-0.108878,-0.079582,0.095725,0.063174,0.092315,0.122256,0.144273:-0.41925,-0.399572,-0.332876,-0.269789,-0.189538,-0.135594,-0.105604,-0.066298,-0.027709,0.011398,0.040176,0.072816,0.120924,0.148082,0.15188,0.168361:-0.135196,-0.073568,-0.058753,-0.019397,-0.00815,0.006524,0.008487,-0.019112,-0.02126,-0.020085,-0.025907,-0.056208,-0.085406,-0.092518,-0.096879,-0.116545:0.150928,0.126476,0.078817,0.027887,0.003673,-0.007674,-0.045356,-0.116113,-0.142106,-0.189869,-0.216123,-0.208587,-0.230458,-0.250087,-0.265903,-0.269966:-0.007779,-0.013842,-0.012695,-0.018827,-0.060643,-0.089022,-0.12395,-0.179754,-0.249003,-0.241896,-0.253873,-0.298511,-0.274752,-0.261362,-0.239834,-0.211764:-0.444317,-0.454349,-0.429457,-0.453076,-0.477403,-0.509517,-0.49151,-0.423695,-0.395961,-0.438843,-0.429249,-0.373289,-0.371,-0.340783,-0.324234,-0.314076:-0.132261,-0.194264,-0.261126,-0.280649,-0.28321,-0.259146,-0.244921,-0.204412,-0.176658,-0.106783,-0.081396,-0.096958,-0.046149,-0.033307,-0.022208,-0.003394:-0.078324,-0.056546,-0.05303,-0.019185,0.020665,0.021806,0.025747,0.021607,0.036056,0.061115,0.061865,0.058345,0.028639,0.014995,0.006718,-0.008312:-0.056112,-0.03619,0.035469,0.073733,0.095643,0.07856,0.066214,0.038216,0.021046,-0.048856,-0.074398,-0.042911,-0.077371,-0.098067,-0.125541,-0.164548:6
1.212795,1.268083,1.265382,1.27148,1.274246,1.25464,1.215421,1.327192,1.178381,1.09196,1.083079,1.128285,1.067322,1.017156,1.015173,1.042836,1.010185,0.923989,1.014283,1.034189,1.004999,0.983847:-0.739742,-0.791996,-0.811773,-0.858778,-0.8232,-0.968493,-0.952206,-0.924915,-0.862063,-0.864502,-0.914445,-0.993942,-1.008301,-0.997239,-1.027225,-1.077461,-1.109586,-1.116913,-1.234023,-1.26265,-1.240861,-1.243044:0.499901,0.506923,0.501826,0.525269,0.479503,0.453213,0.448378,0.502797,0.479208,0.467317,0.500756,0.602182,0.622363,0.586234,0.645101,0.666056,0.664645,0.653561,0.685062,0.686367,0.684786,0.695545:-0.407688,-0.435747,-0.404563,-0.347633,-0.289484,-0.259746,-0.231016,-0.207252,-0.138887,-0.113551,-0.073514,-0.116293,-0.092091,-0.025227,-0.02561,-0.027873,0.034222,0.115677,0.121419,0.157158,0.201247,0.223644:-0.378092,-0.321197,-0.273845,-0.226473,-0.138714,-0.067012,-0.020481,0.031406,0.093423,0.115813,0.136321,0.146621,0.151589,0.179537,0.177503,0.19235,0.215823,0.229361,0.207026,0.205121,0.215387,0.217037:-0.283273,-0.26936,-0.255783,-0.250181,-0.260956,-0.225903,-0.203282,-0.153239,-0.145084,-0.133166,-0.092974,-0.040447,-0.049545,-0.07655,-0.081991,-0.12838,-0.176369,-0.203369,-0.207282,-0.21585,-0.231421,-0.238087:0.209405,0.212913,0.210706,0.199679,0.170964,0.095887,0.087478,0.03432,-0.001554,-0.04133,-0.074237,-0.092405,-0.073022,-0.086463,-0.123532,-0.138078,-0.166797,-0.178393,-0.195994,-0.206493,-0.209668,-0.219435:0.016054,0.034504,0.041871,0.017384,-0.020998,-0.051368,-0.083234,-0.105285,-0.109747,-0.133648,-0.178718,-0.213605,-0.224118,-0.220431,-0.222468,-0.215649,-0.192147,-0.176744,-0.154341,-0.148145,-0.153928,-0.144439:-0.390797,-0.430484,-0.456919,-0.499882,-0.535575,-0.555963,-0.597886,-0.621641,-0.610675,-0.574468,-0.521318,-0.530409,-0.56045,-0.547386,-0.518865,-0.506626,-0.481878,-0.467881,-0.464536,-0.450021,-0.431767,-0.419282:-0.043243,-0.074027,-0.115485,-0.119467,-0.133317,-0.147642,-0.156921,-0.163474,-0.192172,-0.200892,-0.155928,-0.085776,-0.044326,-0.039201,-0.033244,-0.006431,-0.008856,-0.02483,-0.021261,-0.026264,-0.022434,-0.02598:-0.050571,-0.079379,-0.080592,-0.073551,-0.041819,-0.01407,0.021821,0.07391,0.103244,0.115188,0.067075,0.056298,0.083218,0.079305,0.064161,0.022559,0.011844,0.020856,0.022436,0.023881,0.011959,0.010929:-0.062831,-0.038774,-0.021061,-0.015326,0.026807,0.041782,0.066179,0.078998,0.102676,0.117236,0.093666,0.008804,-0.074773,-0.110883,-0.124271,-0.124717,-0.143146,-0.16077,-0.19627,-0.210247,-0.210685,-0.220194:6
1.634959,1.622002,1.744731,1.774602,1.755921,1.256628,1.553456,1.496753,1.449464,1.338201,0.999884,1.105598,1.071699,0.861552,0.942359,0.996011,1.00593,0.912215:-0.458404,-0.571531,-0.827231,-1.015854,-1.027675,-0.915208,-1.261541,-1.283441,-1.362507,-1.437938,-1.325354,-1.500929,-1.487284,-1.328807,-1.436661,-1.515727,-1.566691,-1.526933:0.405786,0.331708,0.286143,0.337387,0.304059,0.266255,0.522411,0.553525,0.588821,0.601679,0.541738,0.62273,0.644006,0.600679,0.715998,0.78677,0.832763,0.838989:-0.492961,-0.403836,-0.277048,-0.215586,-0.147797,0.007662,-0.162462,-0.12542,-0.132364,-0.09559,0.030674,-0.025886,0.051218,0.241964,0.240029,0.254575,0.255879,0.267463:-0.230743,-0.137233,-0.127108,-0.163922,-0.111891,-0.133356,-0.087512,-0.065028,-0.037364,-0.011764,0.009336,0.007542,0.007292,-0.005502,0.013284,0.011461,0.03054,0.070203:-0.320094,-0.300863,-0.300787,-0.234041,-0.211308,-0.053079,0.020696,0.064915,0.058912,0.055685,0.012377,0.003962,-0.051242,-0.083502,-0.084988,-0.065849,-0.077551,-0.108432:0.178312,0.142569,0.158572,0.132973,0.091972,-0.007482,-0.066605,-0.088513,-0.107655,-0.12573,-0.115361,-0.138884,-0.140692,-0.151339,-0.174526,-0.211901,-0.227041,-0.20841:0.047787,0.004702,-0.001823,-0.036314,-0.074267,-0.151647,-0.124584,-0.179333,-0.197758,-0.223373,-0.283715,-0.2551,-0.254449,-0.280775,-0.249915,-0.232766,-0.20176,-0.197221:-0.48526,-0.481258,-0.539479,-0.559297,-0.524965,-0.381702,-0.418717,-0.416297,-0.455,-0.461852,-0.429662,-0.458823,-0.437464,-0.345933,-0.320139,-0.292147,-0.281252,-0.293696:-0.159904,-0.156817,-0.18983,-0.235213,-0.263524,-0.345585,-0.319109,-0.279981,-0.219933,-0.178239,-0.159902,-0.109792,-0.068844,-0.085538,-0.062153,-0.067947,-0.049688,-0.009597:-0.054714,-0.078342,-0.056525,-0.018944,-0.027802,-0.019731,-0.010509,0.010845,0.041267,0.051259,0.038611,0.055499,0.052273,0.043787,0.0281,0.03395,0.018712,-0.006728:0.032374,0.06046,0.067073,0.082551,0.140078,0.210325,0.147668,0.092218,0.0181,-0.037477,-0.019584,-0.096797,-0.133419,-0.098079,-0.13125,-0.156684,-0.204372,-0.233337:6
1.288838,1.328138,1.400051,1.478089,1.546201,1.429106,1.629786,1.663681,1.510074,1.550028,1.316038,1.307533,1.315988,1.328029,1.215961,1.141404:-0.510741,-0.471188,-0.47151,-0.504982,-0.387946,-0.388281,-0.670544,-0.797015,-0.86667,-0.91008,-0.822045,-0.835425,-0.970992,-1.153359,-1.207239,-1.253873:0.724452,0.680494,0.682034,0.628445,0.594319,0.488368,0.60437,0.61529,0.659997,0.701116,0.571756,0.529251,0.596012,0.688355,0.731095,0.796597:-0.593787,-0.520856,-0.522565,-0.485717,-0.477631,-0.313735,-0.324399,-0.289447,-0.259469,-0.301335,-0.180792,-0.088798,-0.057953,-0.066552,-0.014365,0.045558:-0.412714,-0.369669,-0.331178,-0.265239,-0.218092,-0.179721,-0.179937,-0.144149,-0.081475,-0.058315,0.040305,0.07458,0.037487,0.009974,0.028804,0.066221:-0.131968,-0.169861,-0.167988,-0.12788,-0.157216,-0.136201,-0.098406,-0.068388,-0.018361,0.011091,-0.009119,-0.016125,-0.004382,-0.001382,-0.026947,-0.068897:0.245461,0.271811,0.255595,0.174554,0.190011,0.175065,0.139166,0.090847,-0.00285,-0.032686,-0.015242,-0.024474,-0.062279,-0.132839,-0.18704,-0.25105:0.003243,-0.002882,-0.023025,-0.032738,-0.053857,-0.074617,-0.078476,-0.082905,-0.095919,-0.132064,-0.169722,-0.200342,-0.221411,-0.210631,-0.218551,-0.226086:-0.289305,-0.351977,-0.410351,-0.446747,-0.478959,-0.470293,-0.55881,-0.548078,-0.498327,-0.539351,-0.525928,-0.502875,-0.48854,-0.47423,-0.43603,-0.389676:0.04853,0.02465,-0.024443,-0.107679,-0.114168,-0.167198,-0.168028,-0.193049,-0.218801,-0.190482,-0.186818,-0.184005,-0.168006,-0.147094,-0.111134,-0.053994:-0.185204,-0.187454,-0.164563,-0.111844,-0.120671,-0.05976,0.017167,0.03436,0.042344,0.067823,0.051012,0.022613,0.04037,0.076978,0.078406,0.062053:-0.175236,-0.180481,-0.135963,-0.095814,-0.052947,-0.025519,-0.013148,0.031017,0.054804,0.036073,0.049865,0.041022,-0.00743,-0.080405,-0.13837,-0.194837:6
1.254176,1.317557,1.351821,1.334417,1.240854,1.384541,1.450316,1.475114,1.498332,1.321982,1.149012,1.354533,1.447895,1.30003,1.126097,1.331279,1.277646,1.076243,1.262389,1.222575,1.168198:-0.757245,-0.742599,-0.651729,-0.741798,-0.695667,-0.952989,-1.03279,-1.022341,-0.994299,-0.954821,-0.921683,-0.985261,-0.967671,-0.915417,-0.848303,-1.055997,-0.977677,-0.796624,-0.952768,-0.991444,-0.932923:0.808118,0.745786,0.663865,0.729254,0.585753,0.612495,0.55959,0.53009,0.580599,0.532022,0.507537,0.538614,0.535517,0.524962,0.490117,0.676397,0.670324,0.554213,0.704542,0.767302,0.7665:-0.610866,-0.542373,-0.445992,-0.461157,-0.264051,-0.044372,-0.089785,-0.262533,-0.298655,-0.15962,-0.059313,-0.020757,-0.011662,0.066284,0.205066,0.144825,0.200554,0.31419,0.2099,0.221718,0.246576:-0.38673,-0.32409,-0.270607,-0.205913,-0.125873,-0.163706,-0.083981,0.005724,0.023787,0.066679,0.074807,0.07014,0.125124,0.163891,0.126442,0.124234,0.159987,0.187625,0.272252,0.263024,0.298169:-0.057012,-0.097659,-0.132802,-0.139853,-0.184002,-0.154888,-0.100336,-0.096478,-0.078815,-0.023926,-0.040739,-0.092398,-0.175905,-0.182771,-0.138135,-0.147117,-0.182621,-0.196203,-0.234002,-0.235167,-0.265771:0.06166,0.093451,0.118826,0.049359,0.077691,0.074178,0.010314,-0.07898,-0.135209,-0.163604,-0.147622,-0.120422,-0.13583,-0.147992,-0.152582,-0.18961,-0.15565,-0.158558,-0.214675,-0.229484,-0.232535:-0.045122,-0.033597,-0.053476,-0.063152,-0.091639,-0.14583,-0.132862,-0.124477,-0.157397,-0.251978,-0.31506,-0.304176,-0.280852,-0.283441,-0.31107,-0.248314,-0.234225,-0.249948,-0.185426,-0.179535,-0.17364:-0.381577,-0.460299,-0.489185,-0.520354,-0.515622,-0.512507,-0.543107,-0.549209,-0.517545,-0.44153,-0.43347,-0.468956,-0.493797,-0.477644,-0.423093,-0.459777,-0.46147,-0.374239,-0.388806,-0.341959,-0.313565:-0.152013,-0.153596,-0.149294,-0.128382,-0.126946,-0.146349,-0.186834,-0.196612,-0.19764,-0.154682,-0.090987,-0.05028,-0.008188,-0.015928,-0.049049,-0.027136,-0.002609,0.007912,0.082235,0.082566,0.083388:-0.05391,-0.024559,0.006826,0.032995,0.050583,0.096994,0.146143,0.089737,0.0647,0.066942,0.045671,0.042935,0.041528,0.074719,0.11014,0.133433,0.116228,0.067047,0.01239,-0.024585,-0.05161:0.0213,0.011774,0.019686,0.065329,0.078983,0.083067,0.063058,0.089073,0.133436,0.061687,-8.67E-4,-0.040904,-0.059433,-0.081182,-0.092622,-0.138986,-0.155754,-0.177646,-0.246712,-0.252139,-0.247744:6
1.046002,1.176191,1.197558,1.127028,1.151608,1.117971,1.330742,1.435691,1.390667,1.473947,1.274802,1.368583,1.309052,1.444271,1.357119,1.231936,1.210668,1.203381,1.085022,1.06016,1.264099:-0.748736,-0.771432,-0.719043,-0.471601,-0.510277,-0.475818,-0.63481,-0.849558,-0.904433,-0.879683,-0.850491,-0.905496,-0.914481,-1.097529,-1.092932,-1.07697,-1.131945,-1.183695,-1.123636,-1.10133,-1.263801:0.773581,0.74835,0.801165,0.78701,0.691506,0.64443,0.63339,0.662411,0.6492,0.645352,0.590093,0.657184,0.649798,0.827414,0.860696,0.873399,0.931283,0.969839,0.91646,0.855977,0.989142:-0.665591,-0.571913,-0.537824,-0.448208,-0.373269,-0.371275,-0.336981,-0.30186,-0.256318,-0.237802,-0.162003,-0.133881,-0.046436,-0.074853,-0.007027,0.026358,0.053677,0.139544,0.240358,0.347209,0.294534:-0.538148,-0.476141,-0.419222,-0.289985,-0.183261,-0.136162,-0.129139,-0.121944,-0.082652,-0.009769,0.06441,0.039541,0.02179,-0.043608,-0.029528,0.033245,0.041149,0.028039,0.060579,0.051759,0.041935:-0.044819,-0.027322,-0.042398,-0.094425,-0.137026,-0.109175,-0.066272,-0.023903,0.014878,-0.022998,-0.026996,0.014645,0.077789,0.081524,0.076448,0.037616,0.008902,0.006324,-0.024077,-0.017505,-0.006107:0.235212,0.179857,0.188323,0.264103,0.242693,0.256768,0.18017,0.089375,0.033981,0.018929,-0.021567,-0.081272,-0.140348,-0.165493,-0.162679,-0.177611,-0.201135,-0.235668,-0.239585,-0.236173,-0.288934:-0.155658,-0.091567,-0.103967,-0.134383,-0.161221,-0.196775,-0.169092,-0.15709,-0.16799,-0.165182,-0.199163,-0.229178,-0.314541,-0.327685,-0.336832,-0.306145,-0.279973,-0.271885,-0.280087,-0.303146,-0.269746:-0.351648,-0.392618,-0.441714,-0.47497,-0.489223,-0.536086,-0.587805,-0.591354,-0.560805,-0.570678,-0.52464,-0.475566,-0.385969,-0.440391,-0.427745,-0.418427,-0.399752,-0.31531,-0.251219,-0.212708,-0.209098:0.040771,-0.059407,-0.088662,-0.053751,-0.093275,-0.129851,-0.141147,-0.145132,-0.170472,-0.164458,-0.188732,-0.196005,-0.166326,-0.098781,-0.089739,-0.073609,-0.038033,-0.039085,-0.043634,-0.052721,-0.049075:-0.200922,-0.105485,-0.110393,-0.158821,-0.148117,-0.098886,-0.007927,0.067427,0.092847,0.072103,0.066208,0.059953,0.035825,0.09261,0.0915,0.079929,0.082247,0.056841,0.008428,9.42E-4,0.014179:-0.118008,-0.138887,-0.077521,-0.020603,0.082958,0.118324,0.078416,0.062959,0.065103,0.097677,0.119691,0.114964,0.060607,-0.04494,-0.053198,-0.063983,-0.117583,-0.149412,-0.13602,-0.13205,-0.178201:6
1.134642,1.100723,1.177772,0.945255,1.136335,1.158164,1.20028,1.31306,1.260499,1.354997,1.367624,1.387803,1.167456,1.182948,1.129727,1.110549,1.037701:-0.858507,-0.927993,-1.00151,-0.874263,-1.084493,-1.13694,-1.187839,-1.192571,-1.162372,-1.249323,-1.234342,-1.266796,-1.203825,-1.268632,-1.290459,-1.374108,-1.388273:0.56462,0.544191,0.553851,0.44374,0.556324,0.555502,0.582951,0.578984,0.532673,0.592234,0.574644,0.564762,0.527887,0.580684,0.580357,0.646248,0.661697:-0.524881,-0.523474,-0.487047,-0.324275,-0.439097,-0.416793,-0.335349,-0.300069,-0.17589,-0.188939,-0.108715,-0.015925,0.101396,0.138133,0.166395,0.139437,0.168223:-0.342394,-0.329549,-0.334355,-0.312015,-0.201651,-0.146314,-0.117546,-0.089464,-0.079731,-0.079393,-0.063641,-0.034559,0.011694,0.039857,0.057905,0.076765,0.095784:-0.16409,-0.160232,-0.097837,-0.082618,-0.06206,-0.051137,-0.027223,0.001965,0.04001,0.050501,0.011145,-5.86E-4,-0.014234,-0.050625,-0.077429,-0.067574,-0.061774:0.206594,0.184081,0.13728,0.110465,0.046217,-0.009015,-0.081005,-0.094872,-0.114267,-0.124553,-0.093438,-0.115715,-0.115138,-0.15458,-0.173076,-0.21,-0.228557:-0.055743,-0.055117,-0.040398,-0.07275,-0.055406,-0.07549,-0.126204,-0.160245,-0.220224,-0.219221,-0.228426,-0.233925,-0.269275,-0.266256,-0.27583,-0.262949,-0.266366:-0.402762,-0.41677,-0.417966,-0.372512,-0.450033,-0.466356,-0.456976,-0.476926,-0.429246,-0.458384,-0.480875,-0.434468,-0.397781,-0.384631,-0.369198,-0.38674,-0.387441:-0.058676,-0.101186,-0.179746,-0.253153,-0.216404,-0.228861,-0.234579,-0.239476,-0.266708,-0.244375,-0.202061,-0.185658,-0.170743,-0.136682,-0.113558,-0.095242,-0.098157:-0.09938,-0.102288,-0.056018,-0.017442,-0.020391,-0.002449,0.048871,0.066643,0.062264,0.082321,0.099413,0.091054,0.062819,0.058538,0.050222,0.074976,0.089994:0.008207,0.025937,0.037486,0.086484,0.072094,0.082524,0.104016,0.126698,0.156611,0.11978,0.076778,0.039118,0.011512,-0.03163,-0.049118,-0.093979,-0.110475:6
1.021967,1.127047,1.021297,0.864052,0.782299,0.866466,1.084979,1.1118,1.057131,1.033066,1.044846,1.06406,1.063538,0.983869,0.98574,1.001203,0.96113,0.90362,0.992907,0.934468,0.869321:-0.753771,-0.626562,-0.807225,-0.888456,-0.903034,-0.898359,-0.993431,-1.05697,-1.005902,-0.975823,-1.001561,-1.011869,-1.052511,-1.030465,-1.063528,-1.122069,-1.145997,-1.136474,-1.227305,-1.235948,-1.209052:0.86277,0.729841,0.728831,0.712101,0.691301,0.624595,0.547675,0.582836,0.616986,0.622951,0.601854,0.619874,0.649168,0.639758,0.660065,0.695837,0.723321,0.721025,0.753943,0.783885,0.813838:-0.720686,-0.668445,-0.618472,-0.583244,-0.552996,-0.467306,-0.310894,-0.320372,-0.314988,-0.285471,-0.264529,-0.224025,-0.204636,-0.136208,-0.11139,-0.107501,-0.057928,0.032921,0.057545,0.111061,0.153218:-0.545637,-0.436364,-0.354953,-0.281598,-0.235212,-0.160114,-0.113514,-0.087784,-0.067993,-0.0204,0.036176,0.078683,0.112171,0.130583,0.117636,0.108676,0.122344,0.142062,0.143381,0.125001,0.127556:0.044443,-0.034535,-0.007399,0.001891,-0.003389,-0.015861,-0.059864,-0.009809,-0.00516,-0.02651,-0.039871,-0.016567,0.010629,0.00986,0.003944,-0.010063,-0.031885,-0.061066,-0.094582,-0.103584,-0.106466:0.200624,0.228053,0.192453,0.175111,0.161076,0.130464,0.121506,0.064449,0.052204,0.046779,0.014066,-0.027596,-0.073567,-0.091439,-0.100222,-0.112144,-0.125994,-0.141625,-0.174007,-0.177006,-0.175602:-0.095381,-0.111744,-0.082185,-0.110015,-0.145873,-0.150158,-0.118738,-0.142768,-0.173223,-0.190373,-0.189887,-0.194798,-0.193561,-0.236875,-0.265612,-0.267099,-0.271993,-0.273752,-0.234624,-0.253507,-0.276668:-0.291952,-0.348356,-0.387431,-0.436481,-0.4818,-0.535889,-0.57284,-0.566193,-0.57866,-0.577634,-0.574295,-0.545568,-0.502267,-0.47798,-0.475579,-0.477127,-0.452434,-0.416613,-0.413604,-0.390091,-0.365216:-0.034141,-0.058302,-0.088574,-0.117898,-0.135482,-0.125925,-0.126568,-0.141111,-0.139699,-0.11108,-0.077555,-0.063723,-0.066585,-0.04759,-0.017201,0.001711,0.020096,0.01513,0.021975,0.028311,0.04883:-0.155552,-0.146331,-0.124576,-0.109519,-0.086317,-0.02867,0.036735,0.065724,0.068937,0.076646,0.106887,0.124077,0.106246,0.092277,0.076271,0.063479,0.038181,0.022033,0.017592,0.009342,-0.006101:-0.085989,-0.024606,-0.012632,0.029713,0.059623,0.023953,-0.003226,0.025393,0.057358,0.082645,0.067717,0.052469,0.042927,0.014781,-0.027735,-0.072616,-0.10969,-0.127014,-0.176839,-0.189018,-0.196941:6
0.840222,0.891725,0.946005,0.918356,0.956647,1.023214,1.063233,1.076121,1.113354,1.023666,1.125983,1.165911,1.084918,1.090148,1.069942,1.035286,0.993519,1.0183,1.01703,0.960701,0.940376,0.893825,0.856473:-0.455193,-0.560369,-0.582318,-0.607522,-0.632146,-0.686054,-0.750977,-0.792589,-0.805371,-0.75308,-0.807465,-0.886282,-0.881454,-0.897562,-0.937011,-0.974705,-0.981115,-1.036697,-1.086964,-1.079265,-1.094122,-1.138989,-1.189369:0.566602,0.627925,0.651056,0.643215,0.644957,0.637761,0.619096,0.576565,0.54029,0.498554,0.521501,0.59903,0.631287,0.62552,0.635566,0.620177,0.614284,0.656909,0.686014,0.681915,0.689752,0.736423,0.752914:-0.724399,-0.749952,-0.710933,-0.691128,-0.65269,-0.640546,-0.633,-0.617086,-0.537631,-0.467677,-0.41339,-0.388645,-0.407865,-0.369671,-0.294908,-0.218792,-0.189286,-0.189402,-0.174409,-0.12921,-0.090288,-0.119016,-0.108155:-0.257055,-0.277072,-0.268836,-0.221001,-0.202,-0.184954,-0.141778,-0.072953,-0.018802,0.022084,0.033865,0.05752,0.10982,0.135965,0.132815,0.146578,0.171128,0.16207,0.151898,0.162158,0.165873,0.167344,0.162929:-0.13185,-0.101826,-0.081305,-0.076447,-0.051693,-0.051515,-0.051163,-0.045773,-0.070849,-0.024025,0.036652,0.032006,0.025172,0.032984,0.027835,0.025355,0.01679,0.007028,1.96E-4,-0.018301,-0.032558,-0.044827,-0.050587:0.120788,0.140388,0.13365,0.130941,0.112541,0.115579,0.102091,0.059496,0.034011,-0.006742,-0.065363,-0.09917,-0.108719,-0.107229,-0.120026,-0.143678,-0.165162,-0.174697,-0.172653,-0.169455,-0.164832,-0.177931,-0.190253:-0.031784,-0.011654,-0.010045,-0.013108,-0.009189,-0.02352,-0.038247,-0.038388,-0.053033,-0.128884,-0.166487,-0.168777,-0.158558,-0.155471,-0.183015,-0.205997,-0.231024,-0.225353,-0.224448,-0.243488,-0.267193,-0.254185,-0.244097:-0.357837,-0.397805,-0.419466,-0.45632,-0.476827,-0.512614,-0.543161,-0.540076,-0.54048,-0.506136,-0.491463,-0.506828,-0.527175,-0.537907,-0.523084,-0.48717,-0.451913,-0.463985,-0.485285,-0.482707,-0.464101,-0.460461,-0.4527:0.0091,-0.026684,-0.079893,-0.10174,-0.137676,-0.143502,-0.141887,-0.171633,-0.173599,-0.161591,-0.144405,-0.113091,-0.103639,-0.115454,-0.104309,-0.097627,-0.065202,-0.029448,-0.002469,0.017613,0.035178,0.039031,0.029587:-0.134873,-0.121737,-0.091215,-0.063971,-0.054963,-0.048682,-0.042468,-0.044384,-0.042568,-0.016139,0.025195,0.072517,0.10157,0.127927,0.126344,0.104665,0.067511,0.082654,0.105258,0.097988,0.062586,0.037675,0.039166:-0.100607,-0.112792,-0.090451,-0.068553,-0.064407,-0.052389,-0.032188,0.012903,0.043739,0.048892,0.023473,0.006574,0.008319,-0.003715,-0.017234,-0.023415,-0.044845,-0.109039,-0.166019,-0.185195,-0.175471,-0.165435,-0.169568:6
1.345737,1.2035,1.084387,1.094616,1.090794,1.128753,1.180029,1.137768,1.177255,1.123901,1.142381,1.182571,1.176431,1.156874,1.11227,1.0552,1.008176,0.939954,0.915657,0.904611:-0.59777,-0.650478,-0.643011,-0.665633,-0.654601,-0.670724,-0.779246,-0.771378,-0.850037,-0.885017,-0.937337,-0.997549,-1.04408,-1.100927,-1.123111,-1.125229,-1.154657,-1.142347,-1.165994,-1.252585:0.548252,0.566614,0.552813,0.554122,0.542095,0.523837,0.505755,0.465822,0.50187,0.483855,0.496047,0.505684,0.520424,0.565402,0.58258,0.587261,0.627396,0.619656,0.620379,0.670077:-0.573222,-0.590526,-0.583448,-0.571042,-0.55854,-0.547067,-0.510453,-0.4286,-0.413196,-0.340507,-0.327838,-0.317754,-0.281486,-0.26569,-0.245491,-0.202578,-0.147586,-0.090287,-0.065839,-0.04714:-0.459565,-0.413643,-0.335964,-0.306419,-0.256483,-0.197613,-0.147161,-0.100446,-0.050543,-0.014543,0.040483,0.077401,0.113683,0.147378,0.162695,0.161473,0.14653,0.153116,0.173534,0.172723:-0.260471,-0.197802,-0.20129,-0.174726,-0.154019,-0.164764,-0.116683,-0.101632,-0.107718,-0.117607,-0.128228,-0.093418,-0.046287,-0.008807,-8.23E-4,-0.021362,-0.038115,-0.059155,-0.07888,-0.080807:0.241196,0.264621,0.277818,0.259281,0.230577,0.224811,0.153711,0.093618,0.050914,0.0238,-0.018883,-0.066326,-0.125179,-0.165853,-0.156566,-0.128998,-0.13698,-0.145138,-0.165825,-0.215324:0.008182,-0.010805,-0.011764,-0.012369,-0.019831,0.004983,0.005692,-0.027112,-0.038904,-0.045828,-0.047834,-0.09211,-0.101798,-0.116841,-0.158869,-0.186773,-0.191266,-0.186599,-0.168072,-0.164973:-0.306636,-0.322417,-0.371866,-0.415418,-0.443308,-0.493912,-0.505726,-0.489563,-0.515751,-0.533346,-0.570237,-0.560902,-0.513751,-0.477936,-0.485229,-0.510681,-0.514964,-0.51132,-0.500102,-0.450158:0.056852,-0.01015,-0.027619,-0.071617,-0.110547,-0.125669,-0.160312,-0.200315,-0.191224,-0.205484,-0.195585,-0.167865,-0.188003,-0.176205,-0.124892,-0.07638,-0.067467,-0.077825,-0.076138,-0.055473:-0.140743,-0.155952,-0.181927,-0.155642,-0.13064,-0.103467,-0.05422,-0.030051,-0.019958,0.026295,0.073014,0.097665,0.104062,0.090959,0.070277,0.074872,0.102197,0.118433,0.10246,0.070255:-0.113965,-0.067065,-0.059255,-0.054679,-0.031767,-0.027034,-0.035442,-0.001903,0.027422,0.045672,0.054769,0.055933,0.059868,0.057027,0.025849,-0.029817,-0.071257,-0.102499,-0.134566,-0.181901:6
0.848057,0.754592,0.849282,0.921236,0.921786,0.893671,0.877775,0.96975,1.004721,1.015803,1.073604,1.025527,1.027273,0.984212,0.942407,0.913179,0.898425,0.852094,0.833683,0.797319,0.809983,0.848357,0.77145,0.789315:-0.597896,-0.615593,-0.689679,-0.714893,-0.744887,-0.731544,-0.711138,-0.80383,-0.872783,-0.903212,-0.98147,-1.029632,-1.065112,-1.087045,-1.149841,-1.221883,-1.277663,-1.271376,-1.274164,-1.277293,-1.315159,-1.357984,-1.33015,-1.394854:0.488421,0.426554,0.439091,0.454542,0.46783,0.426817,0.375768,0.398271,0.437098,0.480365,0.510364,0.536819,0.544365,0.543451,0.557655,0.598304,0.625646,0.637856,0.664552,0.68058,0.712,0.736283,0.726265,0.758307:-0.762307,-0.694761,-0.691175,-0.652344,-0.579402,-0.556246,-0.508279,-0.482781,-0.410463,-0.362394,-0.320664,-0.266319,-0.293996,-0.258928,-0.231675,-0.214427,-0.171509,-0.116258,-0.095223,-0.049043,-0.017961,0.011961,0.074415,0.065432:-0.366249,-0.316869,-0.279827,-0.243735,-0.241033,-0.17588,-0.116553,-0.090081,-0.081979,-0.052491,-0.043975,0.014046,0.076659,0.110715,0.111654,0.095234,0.084114,0.095321,0.119504,0.133994,0.134164,0.140734,0.178815,0.204944:-0.260308,-0.273282,-0.25844,-0.237038,-0.217789,-0.215285,-0.201508,-0.168739,-0.15218,-0.141435,-0.136021,-0.116003,-0.083544,-0.053186,-0.011188,-0.007772,-0.016112,-0.030882,-0.050419,-0.066785,-0.069837,-0.070827,-0.08763,-0.081094:0.201691,0.220008,0.198901,0.18045,0.203659,0.199402,0.200531,0.17644,0.132005,0.107876,0.098433,0.03693,-0.024493,-0.058538,-0.093077,-0.096977,-0.111094,-0.13679,-0.153447,-0.159092,-0.162096,-0.174289,-0.181995,-0.193683:0.001661,-0.011941,0.002743,0.013718,-0.007708,-0.011647,-0.029297,-0.052584,-0.060725,-0.090347,-0.123507,-0.123783,-0.124146,-0.177111,-0.235424,-0.25102,-0.256452,-0.269337,-0.26458,-0.253241,-0.22668,-0.187485,-0.171122,-0.156264:-0.357285,-0.390063,-0.431679,-0.465877,-0.499973,-0.498346,-0.507732,-0.518934,-0.542098,-0.56329,-0.580291,-0.579091,-0.563774,-0.540403,-0.526125,-0.548108,-0.543781,-0.511489,-0.487219,-0.463454,-0.451227,-0.427593,-0.393187,-0.369967:0.002298,-0.02637,-0.058339,-0.103269,-0.110322,-0.135474,-0.150939,-0.170681,-0.194767,-0.170597,-0.128627,-0.130844,-0.159801,-0.155912,-0.11512,-0.087296,-0.066681,-0.048389,-0.020879,-0.007023,-0.005753,-0.014652,-0.01647,0.010213:-0.107736,-0.093909,-0.08573,-0.071144,-0.048842,-0.04794,-0.054133,-0.054148,-0.007016,0.01104,0.032947,0.057023,0.057666,0.041349,0.03758,0.068067,0.086746,0.080465,0.051433,0.045467,0.054211,0.058122,0.046295,-0.001919:-0.046352,-0.028256,-0.005139,0.018616,0.019059,0.058993,0.056142,0.086225,0.102502,0.110473,0.092731,0.061891,0.084336,0.094579,0.039818,-0.008069,-0.054021,-0.0732,-0.079601,-0.094092,-0.123074,-0.155722,-0.172404,-0.214577:6
0.670688,0.491817,0.526172,0.603895,0.512508,0.436892,0.449749,0.585046,0.404429,0.357859,0.428926,0.502442,0.345597,0.12948:-0.046778,0.04687,0.129609,0.092981,0.108542,0.091719,0.062874,-0.017104,0.066534,-0.027302,-0.088789,-0.086538,-0.184479,-0.220639:-0.009778,-0.040462,-0.227531,-0.31943,-0.335493,-0.337956,-0.317703,-0.251532,-0.21307,-0.110001,-0.119912,-0.136918,-0.015575,0.116281:-0.530929,-0.490387,-0.36225,-0.316777,-0.199666,-0.141598,-0.127966,-0.11328,-0.032379,0.056639,0.135948,0.178288,0.186926,0.253343:0.391632,0.403536,0.305582,0.24876,0.292163,0.366657,0.406972,0.471257,0.443273,0.391727,0.337917,0.355261,0.459074,0.362649:-0.292637,-0.207469,-0.072093,0.072419,0.064758,0.055313,0.06433,0.056765,0.057854,0.086781,0.19241,0.196661,0.072264,6.83E-4:-0.176579,-0.161474,-0.171434,-0.197193,-0.167574,-0.193648,-0.244644,-0.217574,-0.09945,-0.048699,-0.113274,-0.201335,-0.205073,-0.164495:0.074286,0.052294,-0.137675,-0.208853,-0.280417,-0.296791,-0.263473,-0.308564,-0.325153,-0.306144,-0.308756,-0.280839,-0.254829,-0.250147:0.015982,-0.056894,0.047054,0.118631,0.17439,0.155452,0.079135,0.074383,0.007687,-0.064062,0.009989,0.092062,0.099321,0.126768:-0.027155,-0.066905,-0.212121,-0.309677,-0.40793,-0.388759,-0.296563,-0.25154,-0.259789,-0.247431,-0.327722,-0.417467,-0.417604,-0.437949:-0.212474,-0.18231,-0.065104,0.04734,0.062203,0.076037,0.079222,0.081236,0.111192,0.111034,0.136422,0.162494,0.132666,0.095175:0.098855,0.148983,0.130376,0.073074,0.037333,0.001577,-0.016481,-0.015531,0.018904,0.06136,0.028761,-0.016365,0.009629,-0.006269:7
0.610661,0.597666,0.725404,0.49809,0.454559,0.697946,0.627129,0.626373,0.657903,0.681251,0.675324,0.426839,0.444719,0.480609,0.563402,0.63407,0.59367,0.546669,0.454827,0.457177,0.514986,0.347745:0.211527,0.270115,0.070188,0.080823,0.093182,0.092597,0.043501,0.072497,0.137964,0.20209,0.234267,0.308689,0.250732,0.160395,0.075053,0.094187,0.112973,0.036878,-0.012296,-0.241316,-0.395693,-0.339637:-0.080642,-0.012032,0.025021,-0.121432,-0.229091,-0.251451,-0.198498,-0.172915,-0.208697,-0.274075,-0.245902,-0.212304,-0.213648,-0.235682,-0.217934,-0.278633,-0.229806,-0.223137,-0.189351,-0.009268,0.171244,0.111979:-0.406219,-0.497989,-0.517179,-0.418249,-0.410824,-0.414206,-0.458749,-0.396634,-0.331874,-0.32089,-0.323631,-0.291628,-0.262983,-0.305009,-0.281434,-0.148392,-0.0887,-0.021061,-0.014275,0.016442,0.029743,0.04817:0.049032,0.145099,0.184431,0.141415,0.168637,0.195811,0.20108,0.193926,0.249341,0.281859,0.295226,0.326982,0.480669,0.55309,0.543011,0.537953,0.585204,0.60421,0.64915,0.586026,0.606354,0.729397:-0.486165,-0.454753,-0.418232,-0.402993,-0.347423,-0.259343,-0.20506,-0.251214,-0.313661,-0.231761,-0.113233,-0.145608,-0.186603,-0.127617,-0.037334,0.030797,0.102645,0.141992,0.145465,0.122248,0.054885,-0.085499:-0.10421,-0.177583,-0.171629,-0.14823,-0.144419,-0.131704,-0.142522,-0.107534,-0.060694,-0.068279,-0.119442,-0.105829,-0.148464,-0.166967,-0.191551,-0.155322,-0.158723,-0.204523,-0.25313,-0.219762,-0.192146,-0.170475:0.07655,0.081848,0.032223,0.011594,0.005425,-0.021917,-0.065231,-0.056915,-0.07146,-0.158544,-0.204421,-0.149546,-0.165718,-0.184909,-0.167396,-0.200621,-0.362668,-0.407658,-0.365456,-0.301583,-0.244175,-0.182723:0.194202,0.14078,0.176781,0.15467,0.163938,0.17207,0.175313,0.140798,0.062282,0.087575,0.140159,0.048815,0.025845,-0.006635,-0.010387,-0.02192,0.05334,0.081751,0.066334,0.010224,-0.100032,-0.09352:-0.119349,-0.065078,-0.102031,-0.162244,-0.226576,-0.244155,-0.299697,-0.291097,-0.211438,-0.204308,-0.267207,-0.275565,-0.215797,-0.272499,-0.309585,-0.249507,-0.258691,-0.255426,-0.273471,-0.276197,-0.165807,-0.149979:-0.074849,-0.054245,-0.128456,-0.143025,-0.145404,-0.156769,-0.136605,-0.153986,-0.178787,-0.148661,-0.080336,-0.063092,-0.098844,-0.0334,0.024371,0.042639,0.057682,0.066549,0.090377,0.045853,-0.058003,-0.064489:0.109799,0.076713,0.140577,0.10127,0.07485,0.071553,0.100801,0.152213,0.163554,0.145478,0.131477,0.174134,0.167435,0.150648,0.099562,0.054613,0.081191,0.042431,-0.012358,0.041415,0.089716,0.044669:7
0.256892,0.23796,0.236313,0.222734,0.378334,0.353977,0.237258,0.122295,0.070246,0.10187,0.164482,0.023789,0.053141,0.400079:0.340879,0.287925,0.080026,0.060194,-0.041898,-0.090867,-0.146575,-0.036887,-0.12104,-0.163208,-0.11419,-0.008242,-0.043972,-0.22373:-0.228636,-0.251835,-0.187544,-0.043308,-0.063447,-0.040509,0.09804,0.20598,0.132892,0.268534,0.431912,0.451386,0.424189,0.420787:-0.388484,-0.234066,-0.189243,-0.224242,-0.200604,-0.088733,0.009047,0.005519,0.109688,0.089336,0.033009,0.152029,0.16019,0.209789:0.336766,0.349974,0.344118,0.323864,0.375442,0.414681,0.474283,0.449482,0.542032,0.570479,0.549816,0.545995,0.526079,0.467336:-0.214212,-0.230495,-0.173413,-0.134606,-0.123728,-0.129927,-0.164054,-0.177796,-0.206296,-0.202159,-0.162779,-0.147943,-0.114695,-0.066375:0.004274,-0.072778,-0.128433,-0.117325,-0.167106,-0.219178,-0.263992,-0.248522,-0.279798,-0.218713,-0.116864,-0.144897,-0.154434,-0.248802:-0.054614,-0.109301,-0.120617,-0.089845,-0.108468,-0.126729,-0.139412,-0.11414,-0.070008,-0.050155,-0.132703,-0.145501,-0.117369,-0.067993:-0.084081,-0.036943,0.019724,-0.036418,-0.023408,0.002781,0.002261,-0.012215,0.031294,-0.055827,-0.120952,-0.082045,-0.093043,-0.024858:-0.245729,-0.263898,-0.328046,-0.313561,-0.309624,-0.272195,-0.206136,-0.23231,-0.218814,-0.147899,-0.082501,-0.12153,-0.135384,-0.152946:0.010891,0.014438,-0.003156,-0.067614,-0.064842,-0.02585,0.046479,0.119962,0.107567,0.064181,0.080805,0.045354,0.03749,0.018871:0.163081,0.169754,0.172577,0.221052,0.192365,0.169218,0.1594,0.124579,0.071463,0.083556,0.068741,0.00946,-0.044217,-0.101707:7
0.895146,0.86085,0.821426,0.813866,0.758168,0.795146,0.704778,0.659676,0.571664,0.276936,0.125687,0.104687,0.140318,0.039419:-0.128268,-0.160701,-0.02745,-0.128307,-0.201357,-0.06611,-0.376236,-0.394957,-0.308216,-0.288264,-0.327146,-0.40533,-0.44321,-0.340488:0.070095,0.025272,-0.031824,-0.034177,-0.054652,-0.159162,-0.092095,-0.141682,-0.139263,-0.028055,6.73E-4,0.07466,0.139214,0.117636:-0.632854,-0.493436,-0.429133,-0.400103,-0.316925,-0.176872,-0.239575,-0.150013,0.021068,0.001233,0.008989,0.023946,0.047876,0.143981:0.038142,-0.066894,-0.006255,0.096607,0.151375,0.204117,0.28224,0.326845,0.324743,0.396959,0.535955,0.565554,0.557817,0.498317:-0.324898,-0.182061,-0.184051,-0.173686,-0.1098,-0.068879,0.117407,0.151013,0.082301,0.082062,0.017411,0.00782,0.067557,0.059794:0.008748,0.085074,0.021808,-0.05689,-0.094847,-0.15223,-0.288938,-0.310315,-0.260527,-0.250675,-0.309337,-0.27228,-0.270466,-0.268649:0.049438,-0.055517,-0.077582,-0.11376,-0.181138,-0.224201,-0.185845,-0.220563,-0.283588,-0.242273,-0.19829,-0.187835,-0.175625,-0.163653:0.158764,0.184202,0.188991,0.197117,0.213272,0.167468,0.006654,0.054589,0.14452,0.076447,0.064197,0.02001,-0.001391,0.024671:-0.08615,-0.172263,-0.228101,-0.304722,-0.372853,-0.424116,-0.336509,-0.354468,-0.370995,-0.338253,-0.269013,-0.221803,-0.207066,-0.277818:-0.251798,-0.24575,-0.253433,-0.273238,-0.245081,-0.092585,-0.084845,-0.059652,-0.019982,-0.006256,-0.020377,-0.031164,-0.040063,0.003358:0.185552,0.203674,0.187537,0.20011,0.229347,0.193705,0.149632,0.133087,0.136709,0.128923,0.056528,0.032225,0.034035,0.007134:7
1.114108,1.097083,0.911502,0.696653,0.652034,0.641655,0.522637,0.355671,0.354206,0.482005,0.577627,0.65322:0.017739,-0.092212,-0.028621,0.171578,0.136867,0.034788,0.075652,0.222049,0.134539,-0.063779,-0.114132,-0.209838:0.066611,0.124267,0.077279,0.037714,-0.040452,-0.034573,-0.001106,0.018258,0.013558,0.084748,0.073725,0.137356:-0.379944,-0.290487,-0.258647,-0.317215,-0.282527,-0.148537,-0.086442,-0.04577,0.055066,0.090742,0.133647,0.184585:0.228813,0.19549,0.302196,0.275229,0.376963,0.508694,0.503844,0.504294,0.560001,0.494248,0.42419,0.396686:-0.139089,-0.071002,0.002523,0.107673,0.14637,0.125949,0.125029,-0.047069,-0.144115,-0.011919,0.075034,0.0587:-0.033648,-0.113767,-0.115125,-0.022001,-0.066831,-0.152342,-0.146972,-0.081177,-0.092119,-0.140271,-0.210666,-0.225636:-0.084718,-0.175676,-0.249495,-0.28373,-0.348942,-0.450224,-0.455058,-0.376519,-0.307525,-0.351108,-0.342375,-0.352996:0.028278,0.206714,0.216724,0.162011,0.171153,0.233944,0.19148,0.034238,0.001956,0.091854,0.166563,0.192074:-0.079475,-0.15654,-0.191561,-0.263298,-0.249699,-0.207409,-0.175543,-0.102638,-0.144055,-0.234632,-0.363105,-0.331653:-0.17608,-0.176871,-0.157061,-0.141544,-0.131126,-0.099585,-0.055404,-0.011058,-0.035602,-0.104111,-0.025186,-0.02681:0.128222,0.188096,0.173513,0.165949,0.125466,0.090318,0.051831,-0.044314,-0.031876,0.05615,0.013617,-0.001139:7
0.804848,0.815066,0.827732,0.906904,0.905516,0.762885,0.741363,0.83367,0.704717,0.601461,0.534986,0.415948,0.471451,0.54362,0.315305:0.180229,0.092896,0.004193,-0.0051,-0.009152,0.134925,0.012089,-0.200856,-0.261804,-0.301783,-0.33709,-0.300256,-0.366159,-0.396026,-0.299435:-0.088514,-0.033353,-7.66E-4,-0.16297,-0.269376,-0.348222,-0.248817,-0.162075,-0.07956,0.024072,0.047797,0.024993,0.012212,0.060273,0.204062:-0.477709,-0.502088,-0.438866,-0.267792,-0.210406,-0.15293,-0.164182,-0.164817,-0.121822,-0.11228,-0.023321,0.048239,0.157539,0.199464,0.074685:0.058719,0.187781,0.244212,0.217051,0.301154,0.350817,0.367973,0.414971,0.502323,0.614317,0.611248,0.665488,0.58091,0.532743,0.587754:-0.181707,-0.169079,-0.204273,-0.213455,-0.140048,-0.089893,0.02312,0.131502,0.103986,-0.007909,0.008235,-0.003795,-0.015925,0.029742,0.050035:-0.106886,-0.169889,-0.127778,-0.01905,-0.059683,-0.071322,-0.109608,-0.193675,-0.231126,-0.178248,-0.223774,-0.297162,-0.26606,-0.283323,-0.293724:-0.050887,-0.028085,-0.066106,-0.168691,-0.186588,-0.23514,-0.296303,-0.364864,-0.338213,-0.312406,-0.369968,-0.385082,-0.380531,-0.364656,-0.310188:0.166296,0.122192,0.059227,0.074529,0.024432,0.058478,0.067936,0.086781,0.056043,0.034582,0.06231,0.06757,0.096134,0.105656,0.055527:-0.274513,-0.209386,-0.185761,-0.265113,-0.262047,-0.311649,-0.316931,-0.253178,-0.209318,-0.201883,-0.145676,-0.128309,-0.18225,-0.174934,-0.141935:-0.160164,-0.244018,-0.253313,-0.186678,-0.15162,-0.067353,-0.031881,-0.050761,-0.061558,-0.101007,-0.11582,-0.062682,-0.036423,-0.058814,-0.056791:0.075277,0.111921,0.17566,0.169595,0.13576,0.092603,0.116643,0.135398,0.137764,0.155534,0.098333,0.047087,0.03786,0.033098,0.032919:7
0.819645,0.832152,0.74853,0.802912,0.769411,0.578417,0.360106,0.384933,0.355973,0.259052,0.210437,0.128867,0.148587,0.067104:0.074831,0.157748,0.109089,-0.040082,-0.053305,0.002513,0.021141,-0.031356,-0.117746,-0.166009,-0.236915,-0.260385,-0.305664,-0.285111:-0.28205,-0.195827,-0.116163,-0.218431,-0.204545,-0.036064,0.074861,-0.00481,0.033522,0.083484,0.137199,0.136219,0.173592,0.247716:-0.285882,-0.401452,-0.340887,-0.290803,-0.260487,-0.317994,-0.208106,-0.102804,-0.081909,0.013988,0.089623,0.092975,0.086658,0.082606:0.413359,0.527161,0.554787,0.570825,0.582704,0.577641,0.546796,0.651426,0.752742,0.725058,0.659825,0.685084,0.694844,0.667957:-0.005369,-0.045915,-0.070334,0.012607,0.089434,0.149939,0.073187,0.021566,-0.012018,-0.016517,0.004487,-0.028568,-0.020398,-0.014284:-0.207522,-0.106891,-0.105362,-0.123833,-0.102919,-0.079374,-0.092587,-0.162703,-0.221444,-0.23835,-0.249585,-0.235867,-0.247209,-0.183667:-0.110606,-0.160237,-0.177764,-0.242426,-0.29763,-0.280895,-0.222703,-0.218558,-0.224177,-0.229556,-0.186581,-0.121272,-0.119071,-0.164517:-0.014487,-0.010857,0.026747,0.001818,-0.011482,-0.065925,-0.101793,-0.038743,-0.034413,-0.035666,-0.033961,-0.058005,-0.06465,-0.076039:-0.286074,-0.310266,-0.334364,-0.253131,-0.210091,-0.217603,-0.258577,-0.277563,-0.170588,-0.155675,-0.203566,-0.185388,-0.160709,-0.130717:-0.015036,-0.012897,-0.061777,-0.008452,0.004944,0.031996,0.121952,0.070861,-0.057359,-0.047241,-0.00408,-0.005965,0.047357,0.076485:0.055305,0.121039,0.195986,0.126617,0.130858,0.151068,0.078192,0.076354,0.104997,0.092724,0.06558,0.012451,-0.022303,-0.054392:7
1.046327,1.063011,1.185077,1.05036,0.800597,0.702199,0.821942,0.945465,0.976223,0.796418,0.796111,0.933347,0.910625,0.765395,0.635638,0.577776:0.053718,0.145032,0.089301,0.176281,0.327439,0.269407,0.229043,0.237413,0.141661,0.150675,0.058174,-0.097524,-0.101243,-0.095119,-0.033882,-0.107735:0.055641,0.095254,0.043516,-0.006182,0.074909,0.091222,0.06603,0.067242,0.120077,-0.005592,-0.02941,0.043828,0.007202,0.018359,0.003589,0.071909:-0.516544,-0.548457,-0.582752,-0.638974,-0.680702,-0.588575,-0.695496,-0.757305,-0.706698,-0.445271,-0.262434,-0.256397,-0.186432,-0.066918,-0.094997,-0.104449:0.23872,0.221441,0.260359,0.291767,0.298718,0.377598,0.402217,0.297059,0.353439,0.461545,0.332973,0.395356,0.474673,0.485121,0.624946,0.636213:-0.051499,-0.123885,-0.103071,-0.046209,0.034381,-0.002573,0.052951,0.180996,0.159483,0.051731,0.053141,0.038516,-0.00364,-0.008051,-0.066238,-0.019669:-0.257536,-0.115835,-0.053916,-0.030707,-0.038494,-0.081986,-0.040889,0.030476,-0.003316,-0.084925,-0.086909,-0.157891,-0.17197,-0.217614,-0.215864,-0.251621:0.068369,-0.045466,-0.107239,-0.10249,-0.14147,-0.120313,-0.093716,-0.138285,-0.165427,-0.189025,-0.269081,-0.303309,-0.298448,-0.294256,-0.273403,-0.264374:0.068652,0.167469,0.165453,0.097219,0.034953,0.019832,-0.022076,-0.083244,-0.144143,-0.027308,0.16567,0.142647,0.059263,0.077198,-0.003114,0.009894:-0.209567,-0.215046,-0.270964,-0.294951,-0.247966,-0.21224,-0.204734,-0.272526,-0.272754,-0.320274,-0.377879,-0.274824,-0.29509,-0.313116,-0.218561,-0.229481:-0.065161,-0.137183,-0.126409,-0.035778,0.001068,-0.065875,-0.045855,-0.040603,-0.051296,-0.043603,-0.090172,-0.093877,-0.012616,0.006431,-0.009649,-0.014878:0.065516,0.171152,0.225688,0.197882,0.218463,0.207968,0.19199,0.186842,0.196658,0.127663,0.088155,0.096875,0.097008,0.072804,0.047778,0.066783:7
1.595928,1.807213,1.708263,1.502999,1.379689,1.336772,1.377305,1.376391,1.316133,1.183646,1.104563,1.115208,1.074501,0.990839,0.899084,0.71497:-0.409936,-0.51138,-0.458278,-0.281822,-0.295361,-0.298403,-0.29036,-0.339717,-0.297937,-0.152357,-0.083098,-0.155184,-0.283206,-0.284118,-0.255015,-0.255765:0.16469,0.137933,0.085938,-0.072125,-0.052272,-0.043753,-0.158453,-0.218238,-0.249712,-0.335374,-0.336368,-0.33351,-0.211337,-0.134164,-0.043425,-0.074818:-0.592553,-0.630593,-0.6348,-0.572887,-0.640063,-0.686142,-0.614178,-0.536578,-0.440168,-0.380455,-0.398074,-0.294376,-0.234529,-0.19774,-0.177761,-0.016105:-0.097061,-0.07683,-0.026796,-0.003735,0.045417,0.100284,0.15073,0.131168,0.143864,0.200796,0.298441,0.345219,0.411927,0.482943,0.529892,0.476367:-0.257119,-0.161128,-0.194293,-0.142835,-0.080778,-0.015618,0.038754,0.08388,0.01319,-0.008545,0.049947,0.059407,0.016825,0.034464,0.005435,-0.056302:-0.128961,-0.220989,-0.184066,-0.129213,-0.131817,-0.162468,-0.223702,-0.205191,-0.112205,-0.079068,-0.144002,-0.088868,-0.145217,-0.247817,-0.251239,-0.183152:-0.012669,-0.061873,-0.046288,-0.144628,-0.151561,-0.142165,-0.151553,-0.153981,-0.223442,-0.287421,-0.232564,-0.331833,-0.366127,-0.300403,-0.257194,-0.260671:0.211809,0.232431,0.183969,0.266105,0.244522,0.1656,0.163728,0.153658,0.159121,0.126201,0.012624,0.016395,0.118792,0.108718,0.03199,0.040991:0.225053,0.146805,0.154575,0.095577,0.03736,-0.021523,-0.155615,-0.229028,-0.222084,-0.253369,-0.257282,-0.206586,-0.272313,-0.314592,-0.233275,-0.257377:-0.278909,-0.292407,-0.266653,-0.255746,-0.269441,-0.232379,-0.159846,-0.153785,-0.165233,-0.084216,0.009801,0.001432,-0.00981,0.029717,0.031085,0.083485:-0.013519,-0.009106,-0.005897,0.036975,0.091299,0.094575,0.076593,0.090804,0.1373,0.1263,0.098957,0.10423,0.127017,0.079308,0.042961,0.019081:7
0.812838,0.98669,1.080723,1.007085,1.043726,1.126704,1.163037,1.067502,0.807883,0.726574,0.669944,0.527333,0.422065,0.489935:0.082578,0.085124,0.06868,-0.030268,-0.110609,-0.204244,-0.320557,-0.284881,-0.100242,-0.08251,-0.063606,-0.07963,-0.083716,-0.217667:0.031643,-0.134846,-0.239386,-0.063803,0.070267,0.03989,0.106623,0.036711,-0.161583,-0.217788,-0.265759,-0.237665,-0.180763,-0.051081:-0.485969,-0.502446,-0.485827,-0.541155,-0.625536,-0.580713,-0.543537,-0.475842,-0.314727,-0.202836,-0.144774,-0.076413,-0.045918,-0.057551:-0.013736,0.11898,0.238286,0.253884,0.280662,0.277798,0.310773,0.395456,0.406927,0.405029,0.460823,0.47722,0.452759,0.429173:-0.359447,-0.304586,-0.340315,-0.223143,-0.157384,-0.111776,0.085467,0.153905,0.128712,0.13399,0.130866,0.139567,0.133905,0.1283:-0.07257,-0.040822,0.007969,-0.049484,-0.082143,-0.11039,-0.268622,-0.320036,-0.282225,-0.294098,-0.311886,-0.294472,-0.252048,-0.251347:0.012902,-0.0358,-0.072167,-0.072143,-0.019147,-0.055895,-0.047643,-0.067756,-0.146245,-0.193099,-0.235909,-0.311337,-0.358695,-0.306278:0.283829,0.233302,0.160011,0.183099,0.095981,0.046183,-0.045587,-0.087794,-9.28E-4,0.051285,0.037525,0.024395,0.029251,0.005068:-0.148398,-0.175058,-0.160326,-0.246448,-0.259161,-0.308215,-0.274595,-0.273016,-0.369318,-0.419773,-0.397634,-0.371267,-0.343261,-0.307981:-0.165161,-0.162244,-0.219225,-0.2485,-0.255651,-0.199293,-0.136296,-0.095312,-0.069617,-0.018284,0.047895,0.040145,0.027335,0.033989:0.123045,0.073317,0.071463,0.138996,0.174582,0.160181,0.061879,0.031113,0.028337,4.82E-4,-0.046891,-0.021039,-0.015693,-0.032407:7
1.052635,1.077845,1.138127,1.211252,1.171689,0.903495,0.945761,0.974394,0.851238,0.71411,0.695946,0.713518:0.194907,0.114302,-0.033416,-0.108811,-0.014231,0.18837,0.226562,0.307282,0.298965,0.26206,0.309702,0.287927:0.163806,0.044069,0.115546,0.233691,0.163959,-0.078145,-0.185681,-0.243491,-0.269567,-0.283942,-0.215212,-0.137521:-0.6975,-0.726874,-0.723081,-0.78104,-0.770849,-0.538296,-0.378334,-0.339684,-0.278499,-0.221809,-0.182906,-0.072934:0.268477,0.316382,0.268695,0.25167,0.282594,0.287318,0.243415,0.273098,0.315403,0.365027,0.377746,0.370044:-0.273455,-0.139394,-0.116978,-0.079517,0.030077,0.088637,0.111855,0.116587,0.115375,0.170966,0.200223,0.107351:-0.284947,-0.233306,-0.217634,-0.20621,-0.220827,-0.268513,-0.24033,-0.266645,-0.232405,-0.140295,-0.129019,-0.100933:0.120165,-0.003957,-0.001945,0.020518,0.004081,-0.00298,-0.140618,-0.196721,-0.220585,-0.299141,-0.318507,-0.256532:0.191759,0.138857,0.101642,-0.029519,-0.070923,0.040141,0.097232,0.140169,0.095945,0.07093,0.06898,-0.013939:-0.019773,-0.064665,-0.126246,-0.160411,-0.155062,-0.142236,-0.203264,-0.301729,-0.366434,-0.345095,-0.327628,-0.340993:-0.084375,-0.034013,-0.057305,-0.027607,0.029465,-0.011638,0.042744,0.167755,0.239757,0.203065,0.212618,0.287186:0.047394,0.107964,0.177516,0.218843,0.156457,0.043169,0.049331,-0.020107,-0.052248,-0.027774,-0.045276,-0.075356:7
1.111344,1.086831,0.931342,0.88182,0.898042,0.898446,0.94249,0.816055,0.783705,0.954892,0.658987,0.697644,0.643596,0.618433:-0.165575,-0.003356,0.188076,0.305332,0.262931,0.089185,0.042762,0.132473,0.291676,0.242844,0.273502,0.202227,0.211834,0.132479:-0.055946,-0.122954,-0.202167,-0.295018,-0.332203,-0.157681,-0.105295,-0.151716,-0.271309,-0.333114,-0.246476,-0.204182,-0.115262,0.023559:-0.579973,-0.59818,-0.587947,-0.549411,-0.499352,-0.595481,-0.579617,-0.426535,-0.350619,-0.188131,-0.113137,-0.114393,-0.135233,-0.11157:-0.02662,0.016547,0.084999,0.133639,0.17031,0.314717,0.329148,0.296119,0.405258,0.573485,0.616749,0.619234,0.67944,0.699591:-0.523795,-0.447033,-0.428157,-0.479983,-0.30516,-0.195945,-0.131683,-0.086065,-0.012127,-0.114928,-0.123464,0.023502,-0.016112,-0.029852:-0.032317,-0.009658,0.00339,0.104801,0.050437,-0.132503,-0.151584,-0.104604,-0.098058,-0.102784,-0.071237,-0.138816,-0.155937,-0.193039:0.121169,0.093628,0.059062,0.038078,-0.068718,-0.015878,-0.018855,-0.079286,-0.232308,-0.280584,-0.329778,-0.370956,-0.313331,-0.286375:0.116767,0.070916,0.059038,0.007494,0.025804,0.011258,-0.080037,-0.095209,-0.073547,-0.081329,-0.075467,-0.051282,-0.097254,-0.048402:0.024792,0.005141,-0.067126,-0.120614,-0.187438,-0.180975,-0.149536,-0.213585,-0.173236,-0.110531,-0.114197,-0.1633,-0.13945,-0.130452:-0.177399,-0.148306,-0.103166,-0.137542,-0.11107,-0.128801,-0.104896,-0.038423,0.021164,0.001437,0.030842,0.080517,0.062672,0.015997:0.113443,0.095161,0.09255,0.137681,0.125204,0.091961,0.097038,0.141712,0.122969,0.068935,0.027118,-0.008647,-0.021263,-0.022381:7
1.228122,1.136772,1.146679,1.19375,1.145775,1.229486,1.088101,0.957804,0.876025,0.819738,0.7776,0.613181,0.525848,0.455876,0.367997,0.29894,0.269298,0.212185,0.185369:-0.381122,-0.281504,-0.265555,-0.287637,-0.256821,-0.395957,-0.337856,-0.288036,-0.295304,-0.297664,-0.245801,-0.258621,-0.310134,-0.314931,-0.301159,-0.445452,-0.486586,-0.519775,-0.542501:0.211319,0.117615,0.070918,0.097769,0.091675,0.055158,0.034392,-0.023185,-0.094542,-0.049829,-0.023875,0.051624,0.117411,0.140349,0.164106,0.217111,0.297057,0.344722,0.338006:-0.691086,-0.693038,-0.670139,-0.697872,-0.716021,-0.61618,-0.519352,-0.448861,-0.326534,-0.382676,-0.38056,-0.333969,-0.272745,-0.203675,-0.164261,-0.144311,-0.097967,-0.033451,0.034883:0.094814,0.169907,0.206531,0.190351,0.22221,0.199232,0.161468,0.191715,0.2736,0.361992,0.437977,0.433351,0.456691,0.517213,0.541149,0.574805,0.57462,0.568435,0.549327:-0.395951,-0.411662,-0.38733,-0.309123,-0.27445,-0.183375,-0.084784,-0.090485,-0.125547,-0.071738,-0.041137,0.005625,0.038536,0.009171,-0.013834,-0.015205,-0.02812,-0.040738,-0.046822:-0.26507,-0.232049,-0.194113,-0.171905,-0.164302,-0.142726,-0.173625,-0.137345,-0.121157,-0.11504,-0.135195,-0.139218,-0.144148,-0.17069,-0.147604,-0.174569,-0.213958,-0.206495,-0.178547:0.189009,0.169643,0.120779,0.113404,0.124165,0.026902,0.003174,-0.052638,-0.154089,-0.18324,-0.205473,-0.205779,-0.22517,-0.206758,-0.180094,-0.183882,-0.168341,-0.172318,-0.184684:0.076175,0.063168,0.076004,0.030498,0.003892,-0.005553,0.021918,0.013501,0.05535,-0.00273,-0.021012,-0.049662,-0.086001,-0.106643,-0.111145,-0.095945,-0.082751,-0.08428,-0.060672:0.015279,-0.006478,-0.026551,-0.054511,-0.095096,-0.097545,-0.146879,-0.185331,-0.235482,-0.245762,-0.24269,-0.236671,-0.208875,-0.205935,-0.220228,-0.212148,-0.212596,-0.19528,-0.20155:-0.221689,-0.232962,-0.27623,-0.280288,-0.280152,-0.305994,-0.273888,-0.237156,-0.192342,-0.174508,-0.130254,-0.060879,-0.00964,-0.003181,-0.020311,-0.063685,-0.062503,-0.058031,-0.053265:0.050488,0.053834,0.076069,0.066205,0.073333,0.069716,0.056494,0.101129,0.128703,0.187724,0.197829,0.16716,0.143639,0.109788,0.083426,0.084583,0.068724,0.044975,0.044061:7
1.71677,1.741396,1.459664,1.253061,1.228656,1.022274,0.905833,0.848983,0.772254,0.786614,0.684949,0.745885,0.960059,1.054474,0.989265:-0.462197,-0.443475,-0.20538,-0.117331,-0.166387,-0.02198,0.034934,0.036161,0.120653,0.089062,0.023135,-0.091014,-0.326703,-0.512197,-0.602913:0.074143,0.048935,-0.057802,-0.241616,-0.254564,-0.344037,-0.337135,-0.302089,-0.384196,-0.326572,-0.335382,-0.315879,-0.166199,0.011886,0.101317:-0.607281,-0.639774,-0.524102,-0.407744,-0.382415,-0.388232,-0.428364,-0.448376,-0.347657,-0.346035,-0.208941,-0.116317,-0.095054,-0.087548,-0.042472:0.009114,0.025354,-0.011102,0.066247,0.036655,0.089591,0.170188,0.257383,0.327767,0.362673,0.393013,0.379093,0.373012,0.405505,0.464309:-0.315389,-0.24636,-0.160384,-0.149811,-0.097479,-0.052873,0.003404,0.034024,0.042779,0.120155,0.169697,0.192271,0.164051,0.076682,-0.002944:-0.199414,-0.200514,-0.153814,-0.170834,-0.1221,-0.102667,-0.116531,-0.126195,-0.118169,-0.103777,-0.137799,-0.170737,-0.172668,-0.215559,-0.213984:-0.01615,-0.119185,-0.142918,-0.101187,-0.21092,-0.285601,-0.299119,-0.31438,-0.363462,-0.384569,-0.447482,-0.453236,-0.403264,-0.237761,-0.190238:0.097432,0.16578,0.21889,0.174392,0.271899,0.326179,0.26737,0.173548,0.12182,0.098237,0.104753,0.117636,0.087615,-0.00237,-0.014397:0.180281,0.088754,-0.036078,-0.096477,-0.183331,-0.281745,-0.297389,-0.274543,-0.28221,-0.283009,-0.254006,-0.254165,-0.219987,-0.196668,-0.151658:-0.234763,-0.305405,-0.224508,-0.173644,-0.20749,-0.136031,-0.108169,-0.101685,0.001304,0.008792,0.042528,0.057518,-0.007842,-0.025157,-0.071593:-0.010328,0.117065,0.091133,0.028672,0.072483,0.045596,0.047464,0.063623,0.014474,0.074747,0.073972,0.035715,0.086561,0.105639,0.091767:7
1.113227,1.05021,0.994475,0.932372,0.829045,0.752441,0.660702,0.634819,0.666577,0.704309,0.724824:-0.753495,-0.668841,-0.641672,-0.636532,-0.565937,-0.550278,-0.462752,-0.430486,-0.461317,-0.490183,-0.599168:-0.048691,-0.172436,-0.238919,-0.243404,-0.37615,-0.440903,-0.48129,-0.42472,-0.331178,-0.284474,-0.224208:-0.51178,-0.493455,-0.438822,-0.396451,-0.34685,-0.262901,-0.240361,-0.266346,-0.291863,-0.284462,-0.158983:0.168148,0.194522,0.201003,0.241619,0.337125,0.391248,0.454068,0.482839,0.503929,0.505463,0.503104:-0.351618,-0.265686,-0.215763,-0.208479,-0.188205,-0.175606,-0.153953,-0.119282,-0.093509,-0.108257,-0.192741:-0.279352,-0.30996,-0.320471,-0.282579,-0.24311,-0.176465,-0.148986,-0.144662,-0.153256,-0.094688,-0.072529:0.137625,0.128396,0.11883,0.072838,-0.077805,-0.183343,-0.235368,-0.216855,-0.183646,-0.205169,-0.213363:-0.034964,-0.018775,-0.041192,-0.105372,-0.06542,-0.059538,-0.079604,-0.135872,-0.208487,-0.254144,-0.282982:0.009101,-0.052558,-0.092482,-0.07046,-0.130512,-0.141818,-0.197607,-0.221848,-0.171969,-0.190426,-0.157722:-0.155552,-0.139191,-0.125287,-0.113231,-0.100588,-0.145332,-0.122116,-0.104874,-0.107084,-0.083521,-0.072676:-0.130883,-0.145113,-0.156626,-0.154094,-0.08265,-0.063223,-0.039012,-0.014955,-0.003468,0.047885,0.070977:7
1.178126,1.304508,1.300213,1.237372,1.138988,1.066064,1.00381,0.880951,0.875275,0.938993,0.922175,0.889285,0.836226,0.747441,0.723876:0.436774,0.391721,0.394382,0.264556,0.173355,0.177184,0.172855,0.142177,0.038345,-0.213007,-0.34637,-0.449949,-0.440739,-0.442267,-0.464662:-0.098255,-0.151884,-0.182721,-0.181079,-0.282461,-0.257697,-0.280707,-0.241717,-0.03916,0.055308,0.268095,0.356085,0.301207,0.268522,0.298529:-0.444825,-0.45074,-0.474965,-0.454987,-0.406663,-0.397257,-0.263854,-0.226706,-0.236733,-0.148699,-0.075728,-0.120248,0.086645,0.195822,0.168243:-0.141404,-0.111937,-0.037572,0.12193,0.231807,0.295133,0.221952,0.210213,0.228616,0.256338,0.247813,0.390196,0.383542,0.388274,0.4693:-0.078174,-0.064183,0.018608,0.016015,0.057637,0.093822,0.167167,0.20917,0.175028,0.183579,0.192786,0.1108,0.056241,0.011469,-0.039439:-0.201883,-0.160031,-0.19131,-0.157848,-0.14369,-0.137048,-0.063293,-0.066096,-0.014162,0.01256,-0.057389,-0.133648,-0.11187,-0.096194,-0.125039:0.021087,0.009225,-0.073225,-0.143768,-0.22119,-0.236553,-0.318787,-0.314634,-0.329866,-0.314668,-0.240155,-0.174155,-0.182659,-0.190768,-0.141323:0.319513,0.309155,0.317672,0.296516,0.222015,0.18941,0.185605,0.132654,-0.014141,-0.08894,-0.10064,-0.109334,-0.067116,-0.02314,-0.013614:-0.31544,-0.323118,-0.329326,-0.324598,-0.239544,-0.28539,-0.341159,-0.4322,-0.38669,-0.310868,-0.298363,-0.223791,-0.291857,-0.302831,-0.298767:0.063145,0.04208,0.030006,-0.064892,-0.111413,-0.096264,-0.092784,-0.020605,0.049293,-2.63E-4,0.005712,0.012967,0.068062,0.057844,0.038454:-0.03414,-0.02094,-0.027863,-0.001838,-0.020957,0.008172,0.014089,0.015822,0.106945,0.145669,0.173088,0.122595,0.163565,0.150994,0.130886:7
0.592573,0.739541,0.60409,0.623492,0.659631,0.631761,0.756104,0.842171,0.769967,0.823,0.789647,0.834139:0.035194,-0.005208,0.07047,0.004335,-0.07639,-0.130313,-0.254006,-0.224315,-0.095674,-0.134266,-0.05849,-0.062163:-0.08479,-0.134063,-0.305673,-0.258486,-0.21783,-0.24241,-0.201094,-0.202272,-0.21238,-0.119452,-0.16823,-0.193474:-0.612506,-0.558859,-0.55767,-0.572895,-0.542232,-0.478991,-0.486141,-0.421543,-0.389135,-0.411943,-0.21825,-0.123128:0.148048,0.12477,0.283808,0.296901,0.295623,0.359321,0.459778,0.463277,0.4873,0.547832,0.485536,0.478634:-0.558844,-0.492238,-0.515099,-0.43829,-0.356423,-0.32663,-0.289391,-0.238951,-0.213791,-0.183978,-0.136436,-0.183758:-0.034797,-0.040142,0.011247,-0.032275,-0.091444,-0.091853,-0.14791,-0.158381,-0.156201,-0.218364,-0.23609,-0.160744:0.231259,0.122198,0.074397,0.050289,0.020098,-0.024559,-0.04549,-0.121726,-0.158318,-0.139176,-0.193886,-0.237017:0.065484,0.107261,0.080597,0.066054,0.059518,0.051336,-0.011919,-0.009184,-0.026348,-0.050137,-0.024113,-0.039824:-0.121961,-0.104397,-0.121882,-0.142644,-0.178315,-0.226187,-0.212284,-0.228522,-0.22172,-0.232139,-0.27736,-0.229404:-0.183969,-0.197773,-0.206378,-0.173782,-0.136551,-0.119666,-0.121412,-0.083006,-0.042344,0.010201,0.137228,0.138133:0.111025,0.127246,0.098104,0.109248,0.125654,0.150651,0.16379,0.184263,0.15175,0.162987,0.133714,0.148189:7
1.034207,1.001888,1.083347,1.255594,1.204798,0.954564,0.814092,0.784495,0.634576,0.594499,0.566568,0.559651,0.517596,0.437661,0.542528,0.501096,0.286073,0.197982,0.209591,0.206025:0.242887,0.256462,0.223085,0.023815,-0.003221,0.102746,0.184487,0.203194,0.261007,0.231943,0.135738,0.050947,0.068913,0.044611,-0.083566,-0.123115,-0.117493,-0.115563,-0.079403,-0.119103:0.090119,0.054099,0.108053,0.187428,0.240996,0.125147,-0.094314,-0.152421,-0.034111,-0.092515,-0.122068,-0.013633,0.070357,0.155624,0.187446,0.124567,0.144653,0.243769,0.309385,0.473683:-0.790825,-0.767492,-0.808446,-0.887274,-0.836071,-0.677666,-0.507255,-0.503583,-0.43732,-0.362733,-0.325102,-0.334453,-0.260412,-0.248263,-0.158756,-0.03163,0.006464,0.047557,0.018692,0.03156:0.301003,0.281741,0.264054,0.327094,0.290185,0.331574,0.485781,0.515656,0.34536,0.410065,0.546592,0.628077,0.660171,0.695696,0.7163,0.718277,0.745317,0.69276,0.661269,0.683964:-0.323233,-0.297755,-0.23909,-0.163222,-0.057459,-0.105396,-0.177006,-0.017448,0.080815,0.172741,0.179187,0.164971,0.126027,0.114801,0.081903,-0.004301,-0.066096,-0.02364,0.025808,0.013991:-0.289554,-0.260921,-0.254322,-0.271982,-0.315161,-0.290862,-0.234226,-0.183364,-0.076352,-0.079297,-0.132669,-0.159611,-0.128204,-0.145131,-0.152817,-0.095285,-0.062103,-0.123718,-0.125714,-0.10924:0.10428,0.051725,0.072055,0.14844,0.115114,0.047422,-0.018832,-0.153776,-0.246021,-0.326046,-0.292803,-0.276421,-0.281524,-0.223081,-0.253295,-0.261111,-0.192158,-0.162969,-0.137521,-0.109298:0.013668,0.063047,-0.022151,-0.102041,-0.046448,-0.008133,-0.100645,-0.077871,0.024746,0.009645,-0.051653,-0.068991,-0.049008,-0.099784,-0.065272,-0.096508,-0.139927,-0.090847,-0.109397,-0.166546:0.107431,0.09196,0.064254,-0.01857,-0.082593,-0.070308,-0.029036,-0.13744,-0.342391,-0.37089,-0.263111,-0.175005,-0.168266,-0.190636,-0.209396,-0.153123,-0.127955,-0.158809,-0.195405,-0.18486:-0.103407,-0.146862,-0.101021,-0.06792,-0.064313,-0.13231,-0.123524,-0.062538,0.020309,0.092735,0.015367,-0.041174,-0.011967,-0.019075,-0.024135,-0.036482,-0.025541,-0.051831,0.026593,0.067814:-0.081227,-0.040736,-0.048084,-0.06254,-0.044005,-0.006842,-0.00798,0.039681,0.136003,0.140717,0.120256,0.146581,0.128103,0.122925,0.139836,0.112983,0.086194,0.120476,0.089295,0.091922:7
1.288539,1.338578,1.354823,1.462144,1.583188,1.425568,1.142331,1.162061,1.248425,1.338342,1.312397,0.97497,0.885486,1.044459,1.04449,0.901821,1.002018,0.889368:0.242986,0.291703,0.257157,0.107767,-0.149749,-0.10539,0.003503,0.025441,-0.075112,-0.235371,-0.301365,-0.199251,-0.140541,-0.145222,-0.268816,-0.250044,-0.309981,-0.371597:-0.046354,-0.200897,-0.25419,-0.180266,-0.167775,-0.095586,-0.18122,-0.32319,-0.274707,-0.183431,-0.26381,-0.32737,-0.261054,-0.217558,-0.077077,0.001684,-0.053067,0.015038:-0.440194,-0.416164,-0.372749,-0.45668,-0.317476,-0.411192,-0.40189,-0.402416,-0.42522,-0.353068,-0.268771,-0.170357,-0.114529,-0.062014,-0.096585,-0.055728,0.052426,0.141875:0.172789,0.200609,0.13478,0.183669,0.081805,0.127616,0.294802,0.427704,0.446436,0.466313,0.442113,0.492726,0.515979,0.453436,0.500886,0.478357,0.537041,0.495163:-0.585185,-0.613881,-0.557927,-0.454359,-0.348316,-0.185235,-0.247358,-0.289017,-0.187295,-0.068755,0.019352,0.033461,0.070979,0.159951,0.141934,0.114666,0.084856,0.144313:-0.172905,-0.127469,-0.043632,-0.048648,-0.011756,-0.173763,-0.085597,-0.041072,-0.05066,-0.117265,-0.146969,-0.172347,-0.204858,-0.164317,-0.193195,-0.144226,-0.233167,-0.255696:0.054782,0.023883,-0.028306,-0.038244,-0.119486,-0.072359,-0.09628,-0.103536,-0.151993,-0.177731,-0.195546,-0.208159,-0.264723,-0.399723,-0.367867,-0.400037,-0.365442,-0.342722:0.187598,0.193309,0.233299,0.158081,0.160805,0.230904,0.146331,0.073736,0.070917,0.037626,0.055179,0.070283,0.103436,0.135258,0.081518,0.066624,0.153128,0.143302:0.073042,0.012631,-0.054612,-0.065594,-0.046415,-0.20849,-0.163271,-0.148143,-0.178235,-0.195354,-0.261629,-0.328236,-0.342381,-0.313109,-0.27321,-0.253967,-0.263364,-0.246592:-0.261249,-0.248424,-0.225501,-0.25848,-0.290914,-0.239593,-0.282568,-0.287954,-0.254187,-0.238707,-0.188049,-0.073164,-0.006918,-0.026617,-0.063199,-0.039518,-0.039837,-0.02589:0.041663,0.047668,0.063961,0.080835,0.056354,0.064186,0.051228,0.032136,0.067565,0.100642,0.066961,-5.24E-4,-0.003638,0.047084,0.103978,0.120776,0.06149,0.058967:7
1.882421,1.849286,1.740823,1.381523,1.349351,1.487826,1.542535,1.320267,1.119015,1.102457,1.103569,1.142966,0.987976,0.858665,0.871337,0.780574,0.766112,0.704501:-0.290616,-0.266252,-0.202576,-0.148921,-0.265711,-0.342047,-0.300938,-0.248531,-0.156729,-0.136216,-0.201948,-0.275386,-0.294946,-0.419676,-0.44732,-0.455366,-0.561371,-0.589537:0.32088,0.229718,0.138303,0.082436,0.082319,0.024559,-0.113085,-0.132285,-0.123628,-0.147601,-0.125773,-0.09102,-0.055058,0.129023,0.127087,0.146416,0.22272,0.20007:-0.722098,-0.690753,-0.64198,-0.56144,-0.587092,-0.564902,-0.466037,-0.440312,-0.426439,-0.405406,-0.386589,-0.378542,-0.222309,-0.204213,-0.144382,-0.08615,-0.047599,-0.002465:0.036163,0.060075,0.118494,0.159781,0.247462,0.298489,0.259573,0.322862,0.386069,0.444872,0.506254,0.586969,0.503332,0.546723,0.636085,0.659027,0.63457,0.641745:-0.150788,-0.212232,-0.185164,-0.154944,-0.115468,-0.052016,0.023279,0.048661,0.053211,0.078886,0.132467,0.187486,0.253092,0.171721,0.060588,0.031907,0.041141,0.018612:-0.288689,-0.235307,-0.217193,-0.228351,-0.249502,-0.238067,-0.162747,-0.135492,-0.084759,-0.032547,-0.083365,-0.151172,-0.180487,-0.183845,-0.158526,-0.162499,-0.163097,-0.097629:0.07027,0.04519,-0.033537,-0.024258,0.012798,-0.047393,-0.167257,-0.217891,-0.255576,-0.32209,-0.370559,-0.382026,-0.42177,-0.352707,-0.337427,-0.331088,-0.324393,-0.325287:0.123966,0.144391,0.151992,0.145823,0.123865,0.075682,0.154439,0.176603,0.113142,0.049509,0.041628,0.046755,0.067535,-0.018761,0.013649,0.069009,0.086546,0.083682:0.092284,0.056234,0.043782,0.01381,-0.031855,-0.05049,-0.179562,-0.249851,-0.230586,-0.20702,-0.211853,-0.225449,-0.217776,-0.129286,-0.099059,-0.115697,-0.101989,-0.092763:-0.180384,-0.250393,-0.254711,-0.240481,-0.257454,-0.256479,-0.28656,-0.274468,-0.261236,-0.240392,-0.226898,-0.203187,-0.163952,-0.193485,-0.220918,-0.210707,-0.213043,-0.195282:-0.074946,0.002136,0.001347,-0.057296,-0.069852,-0.053904,0.020334,0.058397,0.084704,0.107105,0.124356,0.130574,0.103901,0.122452,0.14433,0.150232,0.16355,0.165301:7
1.063128,1.029435,0.921816,1.039001,1.279862,1.256229,1.107278,0.951566,0.969755,0.940444,0.727637,0.657121,0.558043,0.474776,0.382227,0.329306,0.2591,0.261491,0.283906,0.319712,0.253547:0.035596,0.180467,0.172482,0.059075,-0.097783,-0.047985,0.025801,-0.004886,-0.138873,-0.147219,-0.056202,-0.015517,-0.036388,-0.073068,-0.116084,-0.134504,-0.136032,-0.204816,-0.272729,-0.294178,-0.33466:0.090958,-0.028876,-0.096115,-0.0792,-0.063764,-0.169223,-0.246294,-0.231932,-0.199468,-0.212544,-0.286275,-0.247382,-0.216071,-0.197203,-0.154934,-0.14708,-0.118897,-0.031287,0.011883,-0.012086,0.127685:-0.326739,-0.352843,-0.316573,-0.321478,-0.377154,-0.439521,-0.372581,-0.361516,-0.369443,-0.378809,-0.408413,-0.413538,-0.347728,-0.271762,-0.206489,-0.062362,0.015293,0.037047,0.130878,0.24435,0.19083:-0.054362,0.040019,0.008714,0.001605,0.101001,0.296889,0.350356,0.340752,0.351306,0.415875,0.584343,0.645928,0.592799,0.587445,0.622913,0.582702,0.5766,0.636896,0.674663,0.685165,0.695619:-0.478965,-0.529777,-0.449572,-0.322426,-0.271627,-0.36803,-0.358972,-0.233692,-0.131138,-0.095594,-0.187666,-0.175473,-0.098768,-0.078373,-0.106892,-0.076033,-0.069504,-0.086496,-0.148402,-0.164333,-0.11121:-0.079626,-0.039768,-0.004523,0.015753,0.0047,-0.018046,0.014574,0.025054,-0.015133,-0.021775,-0.034708,-0.064957,-0.051614,-0.055692,-0.066033,-0.061255,-0.071164,-0.11969,-0.151545,-0.174469,-0.186399:0.032142,0.065399,0.047548,0.03822,0.065111,0.068813,-0.022991,-0.066163,-0.044093,-0.054008,-0.019387,-0.050903,-0.139265,-0.220473,-0.24549,-0.346387,-0.34887,-0.30587,-0.253667,-0.240528,-0.204776:0.203657,0.182865,0.140059,0.12124,0.048418,0.045733,0.050393,0.008939,-0.024011,-0.046795,-0.098447,-0.141633,-0.168746,-0.12995,-0.115741,-0.021018,0.012129,0.020695,0.037435,0.080378,0.025404:0.116312,0.075404,0.004836,-7.2E-4,-0.022135,-0.054334,-0.075495,-0.136103,-0.16254,-0.215479,-0.216893,-0.169009,-0.185691,-0.209057,-0.209279,-0.210633,-0.178426,-0.126672,-0.115997,-0.139671,-0.091176:-0.241262,-0.241083,-0.223382,-0.246758,-0.246495,-0.278658,-0.286703,-0.289818,-0.30239,-0.29486,-0.266243,-0.220772,-0.15142,-0.118622,-0.07344,-0.071128,-0.088428,-0.106019,-0.082254,-0.034092,-0.049838:0.071171,0.072634,0.048822,0.03416,0.022736,0.058053,0.075376,0.078406,0.057167,0.031987,-0.018569,-0.020797,0.004245,0.036855,0.06793,0.087639,0.075651,0.056095,0.009306,-0.024705,0.003793:7
0.576173,0.595376,0.66891,0.646375,0.593508,0.688348,0.787807,0.736133,0.739896,0.705681,0.629982,0.512949,0.399893,0.420488,0.357264,0.248626,0.210857:-0.107152,-0.185322,-0.198221,-0.122606,-0.097627,-0.175687,-0.269776,-0.209236,-0.153124,-0.201824,-0.239741,-0.206992,-0.249076,-0.340483,-0.373496,-0.385701,-0.448059:0.019279,-0.065069,-0.122652,-0.232062,-0.271945,-0.217298,-0.184863,-0.293022,-0.357421,-0.320701,-0.310347,-0.330684,-0.243573,-0.193407,-0.053437,0.058014,0.114155:-0.507711,-0.491188,-0.499155,-0.480244,-0.494974,-0.544754,-0.53686,-0.477582,-0.424097,-0.384287,-0.291181,-0.204937,-0.112666,-0.022678,0.064017,0.085088,0.082108:0.053939,0.090054,0.13994,0.191385,0.267321,0.340076,0.325659,0.370438,0.420023,0.42241,0.430857,0.470317,0.514931,0.498435,0.459729,0.503364,0.523494:-0.543784,-0.497193,-0.453392,-0.421399,-0.39553,-0.329683,-0.194157,-0.135578,-0.104156,-0.038246,0.025614,0.039294,-0.051533,-0.095928,-0.1795,-0.190658,-0.166367:-0.105114,-0.079542,-0.097759,-0.068408,-0.060922,-0.090343,-0.13645,-0.16543,-0.168109,-0.19422,-0.263352,-0.289439,-0.251877,-0.223485,-0.152704,-0.183854,-0.17341:0.150614,0.134702,0.111977,0.043898,0.020995,0.011876,-0.036776,-0.101521,-0.173612,-0.221415,-0.257978,-0.302789,-0.313705,-0.260271,-0.225579,-0.172694,-0.15028:0.085458,0.062931,0.067661,0.091138,0.04748,-0.015114,-0.042703,-0.066664,-0.059758,-0.051138,-0.042744,-0.022367,-0.013541,-0.025616,-0.054341,-0.076487,-0.079765:-0.098015,-0.113828,-0.146662,-0.201706,-0.216069,-0.217109,-0.223735,-0.24325,-0.286051,-0.302434,-0.268601,-0.272498,-0.243276,-0.226059,-0.230901,-0.236418,-0.232212:-0.18282,-0.186682,-0.18479,-0.176411,-0.196037,-0.21777,-0.189424,-0.106034,-0.045417,-0.021549,0.018035,0.075501,0.063869,0.063322,0.083681,0.077306,0.060586:0.082602,0.044936,0.042466,0.062715,0.063874,0.078456,0.069845,0.05052,0.062525,0.06615,0.028403,-0.009377,-0.010729,-0.042662,-0.026787,-0.001803,-0.00659:7
0.674404,0.615864,0.675698,0.784919,0.839696,0.830496,0.827179,0.87674,0.844843,0.697917,0.693037,0.838377,0.670084,0.540088,0.525971,0.373671,0.360949,0.458093,0.465328,0.391926,0.349771:0.201976,0.229595,0.27167,0.279976,0.291384,0.33804,0.436747,0.456605,0.454199,0.468595,0.21692,0.10998,0.17833,0.175303,0.051586,0.040409,-0.009355,-0.05876,-0.107078,-0.144699,-0.136869:-0.17635,-0.111878,-0.140349,-0.14655,-0.145271,-0.230712,-0.412346,-0.493024,-0.548132,-0.49705,-0.468966,-0.441066,-0.471237,-0.535259,-0.423705,-0.310931,-0.117809,-0.107164,-0.137901,-0.02385,-0.009357:-0.517746,-0.557362,-0.574745,-0.57447,-0.579256,-0.644981,-0.640853,-0.584728,-0.566662,-0.606742,-0.542362,-0.516014,-0.408931,-0.279079,-0.202613,-0.108916,-0.129905,-0.116402,-0.047914,-0.029426,0.067786:0.175109,0.160604,0.158971,0.112891,0.064878,0.162109,0.291843,0.308691,0.357042,0.421063,0.480878,0.629014,0.694496,0.766336,0.819692,0.789702,0.761013,0.758771,0.768472,0.709922,0.667694:-0.605989,-0.598706,-0.580278,-0.517215,-0.465681,-0.434878,-0.506314,-0.437311,-0.337172,-0.276113,-0.194695,-0.193463,-0.191685,-0.26239,-0.261241,-0.264461,-0.1906,-0.132198,-0.177857,-0.209479,-0.225881:-0.097858,-0.135205,-0.10577,-0.085016,-0.020049,0.02979,0.084091,0.100418,0.05622,0.050179,0.001887,-0.041533,-0.051086,-0.027933,-0.074519,-0.071768,-0.109662,-0.118931,-0.060533,0.001531,0.018229:0.219418,0.235598,0.209099,0.152149,0.082233,0.029459,0.020282,-0.060863,-0.078594,-0.091132,-0.138803,-0.170051,-0.215741,-0.233664,-0.205479,-0.168409,-0.137018,-0.115352,-0.119482,-0.107969,-0.104046:0.147984,0.142645,0.142299,0.139333,0.104739,0.009218,-0.033032,-0.015978,-0.022026,-0.092448,-0.117585,-0.147039,-0.182883,-0.177579,-0.181283,-0.218476,-0.266171,-0.257985,-0.207791,-0.207597,-0.181766:-0.063119,-0.077029,-0.078329,-0.1105,-0.145163,-0.043189,-0.085475,-0.159829,-0.144259,-0.151484,-0.149961,-0.117641,-0.093369,-0.081309,-0.097369,-0.094218,-0.044198,-0.025637,-0.065807,-0.083962,-0.118928:-0.103347,-0.080681,-0.089982,-0.061025,-0.025347,-0.117028,-0.138138,-0.095963,-0.084705,-0.065414,-0.071072,-0.105383,-0.10599,-0.147776,-0.149949,-0.126876,-0.093735,-0.099008,-0.10483,-0.073127,-0.031966:0.010008,0.019326,0.025799,0.023178,0.042783,0.067321,0.038901,0.040205,1.8E-4,-0.008089,0.02877,0.044644,0.029447,-4.84E-4,-0.009792,0.013158,-0.017523,-0.051535,-0.033615,-0.041996,-0.047537:7
0.497956,0.496196,0.399664,0.612105,0.731564,0.8233,0.719017,0.646911,0.815205,0.70998,0.645912,0.522938,0.354655,0.244236,0.151705,0.105265,0.038007:0.409761,0.279298,0.326301,0.221689,0.029068,0.043925,0.095717,0.161316,-0.016991,-0.097129,-0.13792,-0.080998,-0.004691,-0.077038,-0.106315,-0.191953,-0.211863:-0.115554,-0.093957,-0.140661,-0.070349,-0.033061,-0.133918,-0.163319,-0.13874,-0.10703,-0.092918,-0.093364,-0.211184,-0.272872,-0.141188,-0.090371,-0.070944,-0.057882:-0.480706,-0.427903,-0.381061,-0.442849,-0.397247,-0.341992,-0.382529,-0.428607,-0.371867,-0.342549,-0.217814,-0.012698,0.027597,0.098026,0.147858,0.200127,0.285335:0.240611,0.204448,0.261054,0.259956,0.311992,0.366282,0.313921,0.329779,0.477497,0.556197,0.544921,0.634725,0.680093,0.546182,0.543349,0.606003,0.587661:-0.421844,-0.333163,-0.376013,-0.297715,-0.22759,-0.21921,-0.142356,-0.076989,-0.121878,-0.082749,-0.098186,-0.174488,-0.157314,-0.01666,-0.005759,-0.05599,-0.019537:-0.195239,-0.187247,-0.187286,-0.241991,-0.242965,-0.178118,-0.154534,-0.126068,-0.158851,-0.198161,-0.158449,-0.148424,-0.136646,-0.164986,-0.181999,-0.166621,-0.206511:-0.070911,-0.099655,-0.090762,-0.062764,-0.128484,-0.191134,-0.200361,-0.187365,-0.183419,-0.203635,-0.23181,-0.269518,-0.293551,-0.355015,-0.347285,-0.347107,-0.353973:0.151651,0.191535,0.161673,0.208948,0.21331,0.169698,0.189086,0.161554,0.089314,0.090149,0.090779,0.061113,0.040739,0.12015,0.135191,0.157632,0.207224:0.037311,-0.019526,-0.055806,-0.046949,-0.120713,-0.14427,-0.16302,-0.203479,-0.191012,-0.188736,-0.207085,-0.161151,-0.185243,-0.269078,-0.245235,-0.210206,-0.264858:-0.031849,-0.088735,-0.050084,-0.102478,-0.09583,-0.104329,-0.101376,-0.076093,-0.060433,-0.036649,-0.032392,-0.046698,-0.024092,-0.032439,-0.031395,-0.042827,0.001625:0.070831,0.128269,0.115039,0.116806,0.174438,0.159127,0.160452,0.178176,0.14968,0.144073,0.163122,0.126109,0.102662,0.150246,0.099125,0.055909,0.029632:7
1.287531,1.410495,1.587959,1.465483,1.386691,1.363249,1.237902,1.189058,1.274986,1.282219,1.041303,0.898199,0.901567,0.771554,0.586873,0.542292,0.580166:-0.303062,-0.342695,-0.387286,-0.317448,-0.331071,-0.269133,-0.209425,-0.18606,-0.27288,-0.278425,-0.24466,-0.382427,-0.483751,-0.501973,-0.523698,-0.526749,-0.501348:0.1613,0.121286,0.077278,0.024134,-0.17473,-0.316156,-0.348389,-0.346163,-0.272856,-0.304609,-0.279988,-0.14599,-0.103066,-0.060767,0.066796,0.127314,0.122911:-0.669192,-0.671474,-0.702133,-0.714462,-0.516074,-0.442217,-0.45469,-0.470299,-0.495072,-0.393483,-0.312764,-0.295941,-0.167082,-0.070909,-0.047177,0.037381,0.114998:0.062019,0.040737,0.062325,0.130419,0.035691,0.051887,0.148399,0.222142,0.300785,0.318928,0.396876,0.488612,0.478298,0.464242,0.484339,0.49073,0.514928:-0.298345,-0.249933,-0.202223,-0.12181,-0.100695,-0.039123,6.69E-4,0.037332,0.07014,0.177683,0.208893,0.143645,0.139275,0.11896,0.065809,0.009623,-0.051293:-0.259754,-0.170363,-0.126761,-0.191269,-0.112372,-0.09544,-0.050265,-0.032794,-0.043193,-0.098549,-0.136966,-0.134142,-0.169954,-0.190758,-0.179238,-0.167705,-0.140286:9.13E-4,-0.033595,-0.066495,-0.03971,-0.162112,-0.279328,-0.336428,-0.3766,-0.414374,-0.480809,-0.501526,-0.491103,-0.493058,-0.473791,-0.402987,-0.36491,-0.321855:0.134917,0.093331,0.092643,0.092859,0.200339,0.290561,0.266413,0.204203,0.125538,0.115069,0.051925,0.034296,0.082654,0.102399,0.064457,0.067378,0.07125:0.163934,0.166086,0.133831,0.094682,0.003675,-0.144153,-0.211297,-0.207497,-0.160729,-0.211143,-0.188749,-0.127731,-0.153004,-0.185655,-0.190092,-0.200375,-0.205069:-0.252167,-0.263622,-0.309557,-0.248363,-0.261821,-0.221815,-0.180051,-0.157775,-0.193776,-0.109846,-0.073226,-0.154627,-0.142762,-0.105698,-0.07486,-0.030089,0.003702:-0.009771,-8.76E-4,0.043678,0.004678,0.033649,0.065137,0.106897,0.136369,0.186889,0.179042,0.156899,0.173691,0.145152,0.113548,0.103928,0.098661,0.09004:7
1.190255,1.071736,1.047498,0.875008,0.819163,0.813374,0.773364,0.600411,0.500157,0.483246,0.561528,0.489456,0.353435,0.336865,0.260784,0.204472:-0.080559,-0.075127,-0.11727,0.014736,0.062087,0.043431,-0.059824,-0.117725,-0.109482,-0.241605,-0.344462,-0.358623,-0.344004,-0.311606,-0.218259,-0.251224:0.031952,-0.014263,0.046959,-0.120437,-0.264199,-0.312157,-0.281137,-0.102341,-0.083433,-0.055493,-0.028017,0.017798,0.129633,0.129174,0.067329,0.176005:-0.772609,-0.71262,-0.756861,-0.643858,-0.530049,-0.425206,-0.339964,-0.360979,-0.32198,-0.246144,-0.151233,-0.032924,-0.049584,-0.014153,0.093255,0.066814:0.221606,0.222454,0.26311,0.213681,0.263641,0.327455,0.320752,0.326734,0.423981,0.460746,0.452328,0.394762,0.400741,0.43993,0.461444,0.460899:-0.393816,-0.352787,-0.205436,-0.118074,-0.106263,-0.046832,0.060823,0.063761,0.046109,0.068519,0.028239,-0.069642,-0.077422,-0.069996,-0.113121,-0.140481:-0.170765,-0.133243,-0.192424,-0.109136,-0.073006,-0.096725,-0.091459,-0.046621,-0.060961,-0.103917,-0.096164,-9.42E-4,-0.01799,-0.060334,-0.049652,-0.026519:0.17076,0.184665,0.163346,0.001557,-0.093455,-0.198685,-0.294462,-0.304681,-0.316956,-0.324598,-0.315921,-0.292631,-0.244095,-0.220209,-0.220827,-0.185136:0.129893,0.06698,0.029558,0.045205,0.095851,0.147504,0.159118,0.049532,-0.006196,0.017457,0.057318,0.01683,-0.016013,-0.012513,0.021935,0.026327:-0.065683,-0.05503,-0.081755,-0.243513,-0.331449,-0.333454,-0.358356,-0.363334,-0.31769,-0.283965,-0.303493,-0.288468,-0.274612,-0.298594,-0.344725,-0.324667:-0.184204,-0.187973,-0.146513,-0.033977,-0.013505,-0.038919,-0.050489,-0.041882,-0.053119,-0.120615,-0.108397,-0.031463,0.021966,0.066053,0.117055,0.035513:0.125309,0.091119,0.066756,0.095955,0.063562,0.054578,0.085667,0.170702,0.200109,0.188396,0.150064,0.115953,0.141983,0.113645,0.052885,0.087158:7
1.148698,1.247033,1.291493,1.250639,1.270182,1.290451,1.208141,1.169777,1.164519,1.126515,1.143128,1.065827,1.039138,0.901382,0.869181,1.011486:-0.275565,-0.223713,-0.069887,0.047066,0.046589,-1.2E-4,-0.154006,-0.334908,-0.255571,-0.337723,-0.502457,-0.502086,-0.438506,-0.392525,-0.353742,-0.523864:-0.027874,-0.040171,-0.168827,-0.244693,-0.236405,-0.255312,-0.146981,-0.058951,-0.123333,-0.077557,0.019586,0.022145,-0.034887,-0.003463,0.024025,0.14871:-0.639747,-0.669303,-0.640948,-0.673276,-0.690514,-0.587875,-0.4752,-0.527444,-0.427155,-0.292025,-0.215484,-0.050599,0.012278,-0.028123,-0.021694,0.074066:0.041958,0.087646,0.187191,0.301496,0.30921,0.237109,0.308592,0.502026,0.560323,0.428744,0.346064,0.360611,0.454469,0.51165,0.504023,0.43744:-0.357154,-0.31157,-0.303446,-0.348001,-0.318185,-0.161327,-0.108753,-0.105623,-0.117942,-0.049282,0.031822,0.00372,-0.081346,-0.149221,-0.155429,-0.183151:-0.116872,-0.050157,-0.042302,-0.069945,-0.029203,-0.014012,-0.127506,-0.244471,-0.207762,-0.139837,-0.18965,-0.222386,-0.228124,-0.142309,-0.10489,-0.050114:0.016752,-0.02905,-0.03882,0.025118,-0.033722,-0.20033,-0.189019,-0.124229,-0.201824,-0.300507,-0.24055,-0.234254,-0.210612,-0.161279,-0.161464,-0.238192:0.201649,0.172705,0.148811,0.037623,-0.022131,0.068375,0.043692,-0.07029,-0.077246,-0.048688,-0.082273,-0.016693,0.004803,-0.077927,-0.078715,-0.038989:-0.070203,-0.042685,-0.032125,-0.097564,-0.129793,-0.195723,-0.255413,-0.161572,-0.175032,-0.220141,-0.277481,-0.337178,-0.307448,-0.287475,-0.30115,-0.225822:-0.226344,-0.272437,-0.246662,-0.178838,-0.150457,-0.116432,-0.095956,-0.128468,-0.119584,-0.089283,-0.030178,-0.01774,-0.032674,-0.023458,-0.015246,-0.11876:0.146297,0.170881,0.117266,0.091446,0.140105,0.16289,0.207399,0.165028,0.152642,0.182043,0.17784,0.183957,0.103153,0.072277,0.058659,0.13003:7
1.061287,1.169762,1.342135,1.126987,0.972126,1.058462,1.113041,1.151031,1.085663,1.074431,0.862113,0.639209,0.613207,0.633797,0.566876,0.465905,0.419093:0.122144,0.24772,0.215069,0.188635,0.292124,0.184718,-0.037368,-0.056136,0.060707,0.032317,0.028902,0.115234,-0.012408,-0.152394,-0.108521,-0.121702,-0.171005:-0.019981,-0.125936,-0.197424,-0.1407,-0.168115,-0.200023,-0.117783,-0.118797,-0.218258,-0.337205,-0.375022,-0.213369,-0.079121,-0.091558,-0.193894,-0.146507,0.028825:-0.744008,-0.817676,-0.720883,-0.688295,-0.744688,-0.727961,-0.637894,-0.606309,-0.575606,-0.45043,-0.223081,-0.23141,-0.160068,-0.014062,0.10531,0.067603,0.026078:0.234243,0.381524,0.325589,0.315665,0.343194,0.417483,0.381881,0.331744,0.323767,0.385245,0.394138,0.40999,0.443726,0.499762,0.514372,0.572601,0.577442:-0.476752,-0.545706,-0.482961,-0.425945,-0.360134,-0.266305,-0.181113,-0.07238,0.05503,0.026184,0.043563,0.092764,0.035501,-0.05818,-0.100141,-0.135678,-0.143494:-0.27805,-0.238453,-0.205722,-0.160922,-0.152886,-0.142442,-0.111501,-0.123574,-0.089622,-0.024254,-0.065557,-0.086792,-0.05742,-0.092786,-0.102144,-0.045155,-0.019431:0.107222,0.084918,0.040871,0.064317,0.0325,-0.067152,-0.104301,-0.06516,-0.198928,-0.311014,-0.363856,-0.416877,-0.375543,-0.280786,-0.273677,-0.269076,-0.275678:0.056882,0.022219,0.05789,0.060876,0.030843,-0.010624,-0.031441,-0.058294,-0.011985,-0.013432,0.021899,0.034119,2.29E-4,0.045275,0.075794,0.002421,-0.04238:0.120807,0.135405,0.104525,0.056683,0.041463,0.040996,-0.006864,-0.125173,-0.239922,-0.235651,-0.221293,-0.208398,-0.242238,-0.335629,-0.300358,-0.187407,-0.109174:-0.100983,-0.10634,-0.13058,-0.160936,-0.113935,-0.120287,-0.198943,-0.119783,-0.010298,-0.011428,0.016,8.98E-4,-0.001582,0.027218,0.019015,-0.052306,-0.083005:-0.034612,-0.028209,0.002059,0.034628,0.007387,0.060487,0.130724,0.105072,0.131602,0.113824,0.048171,0.091923,0.11502,0.092527,0.011295,0.028803,0.052882:7
0.932747,0.827916,0.897155,1.001841,0.869022,0.870631,0.762149,0.697654,0.697281,0.685018,0.534179,0.385436,0.175137,0.064488,0.037143,0.008338,0.130842,0.195541,0.112482,0.027152:0.107527,0.166544,0.24417,0.218814,0.26025,0.185393,0.307742,0.374744,0.244951,0.180414,0.186545,0.10818,-0.041601,-0.188256,-0.271459,-0.222967,-0.223368,-0.202816,-0.161583,-0.203802:0.002567,-0.085526,-0.256142,-0.340261,-0.278875,-0.23804,-0.361546,-0.390534,-0.329102,-0.241744,-0.332223,-0.337662,-0.165697,-0.061768,-0.009178,0.022346,0.024298,0.090837,0.313275,0.496376:-0.629358,-0.624917,-0.565692,-0.480901,-0.503806,-0.498914,-0.489045,-0.537696,-0.517755,-0.532885,-0.445471,-0.418994,-0.401859,-0.319985,-0.236113,-0.159333,-0.127608,-0.11559,-0.052651,0.021119:0.07769,0.07099,0.009753,-0.002239,0.05274,0.143006,0.18312,0.234464,0.343556,0.401578,0.35685,0.36429,0.359585,0.332416,0.333184,0.354102,0.380421,0.431831,0.429868,0.453287:-0.235301,-0.156585,-0.058148,-0.032948,-0.028932,-0.016962,-0.034042,0.023002,0.028668,0.034904,0.049892,0.043667,0.03549,0.036447,0.012739,-0.01222,0.001415,-0.049724,-0.101478,-0.214499:-0.43064,-0.352012,-0.256688,-0.209956,-0.157154,-0.172972,-0.089971,-0.072786,-0.151325,-0.155482,-0.097688,-0.069815,-0.07267,-0.072125,-0.071388,-0.108588,-0.115971,-0.108775,-0.147144,-0.204592:0.124715,0.019868,-0.095497,-0.141794,-0.160748,-0.151415,-0.211577,-0.208686,-0.204331,-0.228981,-0.297682,-0.337255,-0.342189,-0.359729,-0.346973,-0.312157,-0.316039,-0.285796,-0.23874,-0.139026:0.236563,0.226894,0.308622,0.387006,0.26702,0.209542,0.162412,0.117497,0.098666,0.028696,0.007716,-0.067381,-0.124659,-0.116377,-0.120645,-0.143578,-0.140057,-0.163111,-0.205369,-0.181224:-0.046978,-0.107905,-0.214813,-0.286226,-0.292197,-0.27756,-0.271815,-0.303955,-0.289862,-0.284536,-0.369501,-0.354344,-0.328671,-0.327119,-0.335837,-0.333673,-0.326302,-0.336812,-0.31474,-0.297745:0.018382,0.038749,0.083151,0.079346,0.0832,0.021474,0.044286,0.043326,-0.009224,-0.030935,0.027831,0.037396,0.036695,0.05054,0.096582,0.150534,0.129598,0.078638,0.028463,-0.02772:-0.079619,-0.032454,-0.019554,-0.048752,-0.002959,0.018299,-0.01372,-0.017371,-0.008383,0.048989,0.02493,0.009416,0.01885,-0.0072,-0.043892,-0.064934,-0.047339,0.028103,0.073698,0.045678:7
1.011366,0.933559,0.940797,1.125397,1.060463,0.998268,0.884441,1.027902,0.999154,0.859216,0.939655,0.941795,0.939164,0.782934,0.596055,0.628971:0.281388,0.429417,0.420413,0.281843,0.265478,0.243212,0.229096,0.147239,0.095626,0.121101,0.054983,0.058615,-0.062571,-0.059842,0.03461,0.048237:-0.20866,-0.396285,-0.38129,-0.255211,-0.151445,-0.198012,-0.295315,-0.372828,-0.410148,-0.365538,-0.329797,-0.243414,-0.145353,-0.057489,0.040401,0.119505:-0.420172,-0.540625,-0.528159,-0.455694,-0.523042,-0.521985,-0.415365,-0.3101,-0.195185,-0.215613,-0.21746,-0.241073,-0.222167,-0.21686,-0.134541,-0.052796:0.148243,0.432372,0.398625,0.199187,0.210996,0.300026,0.31177,0.350262,0.361706,0.4297,0.492779,0.539817,0.6022,0.734912,0.589234,0.505293:-0.41021,-0.537147,-0.434893,-0.222685,-0.178907,-0.128331,-0.030087,-0.002093,0.050318,0.056102,-0.020419,9.44E-4,0.056765,-0.003945,0.023111,0.065202:-0.043454,-0.001203,0.001425,0.027349,0.035705,-0.034162,-0.078172,-0.112751,-0.154182,-0.125461,-0.105097,-0.159026,-0.166409,-0.140544,-0.080503,-0.058888:0.017282,0.034345,-3.17E-4,-0.119724,-0.094829,-0.061376,-0.164983,-0.221711,-0.260767,-0.318248,-0.28776,-0.221263,-0.255886,-0.302999,-0.320555,-0.364895:0.233188,0.081134,0.056381,0.139546,0.017866,-0.076765,0.053537,0.070998,0.052115,0.038946,-0.020671,-0.068075,-0.061802,-0.056246,-0.036678,-0.049648:-0.063042,-0.009653,-0.055045,-0.173431,-0.121239,-0.084827,-0.158723,-0.205133,-0.213408,-0.190989,-0.187475,-0.165766,-0.144539,-0.095733,-0.175279,-0.199165:-0.165677,-0.201079,-0.176083,-0.111499,-0.120902,-0.110331,-0.096445,-0.055706,-0.034612,-0.037024,-0.02426,-0.022067,-0.034722,-0.083253,-0.046891,0.006658:0.064439,0.020832,0.030951,0.098597,0.135866,0.076348,0.059159,0.025582,0.004631,0.042484,0.060346,0.019364,0.045383,0.086799,0.101841,0.112119:7
0.940117,1.10811,0.988062,0.9632,1.049409,1.026765,0.957145,0.929074,0.920558,0.888552,0.838604,0.89359,0.879384,0.833344,0.644474,0.560794,0.619483:0.224281,0.114396,0.206421,0.157765,0.098383,0.134341,0.219749,0.128989,0.067312,0.066673,0.138571,0.067737,-0.052347,-0.143432,-0.125701,-0.150172,-0.312502:-0.057153,-2.2E-5,-0.113405,-0.18879,-0.227317,-0.240089,-0.25932,-0.248306,-0.331021,-0.309206,-0.201473,-0.259036,-0.231843,-0.129338,-0.152217,-0.110297,0.059997:-0.717958,-0.725527,-0.636369,-0.624761,-0.669184,-0.677744,-0.667224,-0.565264,-0.46556,-0.442981,-0.550471,-0.440805,-0.302701,-0.242726,-0.147165,-0.082375,-0.075871:0.331894,0.32816,0.213439,0.209755,0.283526,0.294795,0.335251,0.336072,0.309365,0.296403,0.363816,0.445034,0.416089,0.421565,0.496119,0.558592,0.596035:-0.527972,-0.47862,-0.36851,-0.321181,-0.322206,-0.23509,-0.148428,-0.170342,-0.055156,0.031315,0.067254,0.079646,0.110692,-0.0068,-0.027732,-0.054608,-0.088244:-0.297374,-0.290946,-0.197799,-0.169289,-0.148442,-0.113996,-0.114863,-0.070103,-0.104915,-0.108124,-0.042972,-0.106116,-0.173813,-0.079586,-0.054109,-0.056776,-0.076395:0.127326,0.155379,0.042831,-0.001752,-0.006368,-0.069979,-0.119697,-0.131874,-0.187101,-0.228867,-0.252111,-0.252507,-0.219898,-0.189681,-0.266028,-0.261253,-0.17298:0.099106,0.057455,0.091554,0.137806,0.108838,0.084664,0.052891,0.002529,0.047248,0.06086,-0.06188,-0.075276,-0.057079,-0.114193,-0.088234,-0.114268,-0.140949:0.163341,0.152429,0.095362,0.004285,-0.086211,-0.131187,-0.131712,-0.150069,-0.249792,-0.320289,-0.276999,-0.270355,-0.332652,-0.313572,-0.245121,-0.192546,-0.205802:-0.147215,-0.175176,-0.164809,-0.140297,-0.121624,-0.101184,-0.08265,-0.136129,-0.073991,-0.044623,-0.052743,-0.010613,0.009693,-0.040457,-0.080196,-0.071254,-0.041955:-0.084564,-0.080715,-0.041751,-0.039197,-0.026639,-0.001896,0.003025,0.037474,0.006016,0.018755,0.071065,0.018517,-0.006604,0.040486,0.045195,0.050453,0.084079:7
0.738825,0.715023,0.745283,0.690168,0.58109,0.527189,0.479079,0.528846,0.635926,0.660518,0.538108,0.430021,0.344208,0.373319,0.438745,0.455306,0.341188:0.366468,0.30399,0.219505,0.213359,0.372854,0.385153,0.300077,0.182285,0.131323,0.007355,0.08998,0.141277,0.103029,0.001733,-0.112815,-0.29016,-0.317776:0.038252,0.034152,-0.013162,-0.094317,-0.342745,-0.329768,-0.16297,-0.125169,-0.215108,-0.19999,-0.265198,-0.206909,-0.09097,-0.073917,-0.021708,0.153808,0.194523:-0.396917,-0.280713,-0.297405,-0.37269,-0.302878,-0.228003,-0.253431,-0.268387,-0.182177,-0.053766,0.019964,0.034061,0.03291,0.129084,0.125999,0.145779,0.220046:0.177764,0.107653,0.17623,0.429849,0.550035,0.392299,0.402496,0.526972,0.668863,0.642167,0.720305,0.775732,0.638629,0.581962,0.634435,0.598266,0.545688:-0.307536,-0.224854,-0.112461,-0.187495,-0.198098,9.5E-4,0.055381,0.018348,-0.043905,-0.038675,-0.101037,-0.128987,-0.018092,-0.092909,-0.157543,-0.136647,-0.072862:-0.193414,-0.132032,-0.10651,-0.113461,-0.034701,0.028751,0.007385,-0.027929,-0.056834,-0.069251,-0.078588,-0.099661,-0.066603,0.027351,0.004611,-0.005652,-0.035671:-0.010489,-0.106326,-0.167168,-0.104204,-0.125352,-0.236461,-0.287655,-0.291555,-0.304995,-0.324701,-0.302657,-0.288849,-0.318298,-0.274545,-0.213507,-0.222793,-0.216835:0.13152,0.148848,0.133242,-0.013112,-0.083606,-0.050325,-0.02705,-0.119429,-0.16027,-0.103404,-0.093564,-0.079014,-0.07735,-0.098739,-0.063535,-0.043202,-0.01766:-0.077225,-0.152551,-0.172178,-0.118331,-0.171896,-0.30239,-0.309982,-0.19728,-0.136841,-0.176159,-0.163063,-0.146494,-0.152099,-0.176913,-0.214667,-0.210288,-0.244781:-0.042312,-0.066292,-0.125303,-0.129851,-0.090562,-0.050561,-0.08356,-0.116913,-0.139287,-0.138536,-0.119736,-0.12069,-0.1191,-0.108589,-0.097558,-0.114134,-0.071188:0.061239,0.12776,0.163427,0.105331,0.015004,0.04995,0.10536,0.101993,0.083432,0.073913,0.027813,0.00752,0.048275,0.057431,0.044649,0.092996,0.078232:7
0.745149,0.721528,0.737315,0.806611,0.812578,0.896961,1.052666,1.075123,0.847872,0.660111,0.562303,0.50776,0.509498,0.574821,0.486923,0.399688,0.384866,0.434464:0.395069,0.407711,0.261877,0.269627,0.281432,0.235362,0.087577,-0.01181,-0.045273,0.205658,0.267867,0.280788,0.264221,0.158954,0.115504,0.149582,0.159552,-0.019486:0.110389,0.10407,0.089608,-0.026076,-0.098407,-0.090738,-0.127395,-0.061578,-0.113138,-0.305168,-0.121035,-0.100634,-0.185037,-0.122176,-0.077949,-0.037082,-0.021934,-0.041371:-0.728061,-0.747822,-0.676024,-0.661473,-0.625394,-0.627505,-0.601675,-0.594878,-0.462184,-0.384511,-0.458984,-0.45713,-0.340264,-0.302094,-0.214873,-0.154813,-0.129699,0.029246:0.249064,0.235156,0.250493,0.390693,0.384253,0.447222,0.453866,0.414247,0.461357,0.554108,0.555917,0.584911,0.637099,0.66687,0.669443,0.745928,0.795176,0.750672:-0.591363,-0.467438,-0.487296,-0.596798,-0.518075,-0.479543,-0.381452,-0.275415,-0.225352,-0.286994,-0.172152,-0.103449,-0.061747,-0.073291,-0.065929,-0.10918,-0.186918,-0.248256:-0.09114,-0.122406,-0.09896,-0.043554,-0.044589,-0.065776,-0.065985,-0.077947,-0.190094,-0.121002,-0.15105,-0.148655,-0.128735,-0.124696,-0.170223,-0.182543,-0.148899,-0.146665:0.209441,0.148773,0.17413,0.205801,0.128616,0.122483,0.094561,0.085766,0.078987,-0.027833,-0.081455,-0.1644,-0.262866,-0.319023,-0.302357,-0.235394,-0.195396,-0.227961:-0.008686,0.003103,-0.013076,-0.04209,7.73E-4,-0.071362,-0.142485,-0.174072,-0.172183,-0.090604,-0.098748,-0.133088,-0.082466,-0.120095,-0.092869,-0.110609,-0.162833,-0.12963:-0.042748,-0.070409,-0.10685,-0.096288,-0.146225,-0.147849,-0.154764,-0.160841,-0.153038,-0.185958,-0.147463,-0.119446,-0.137955,-0.088942,-0.130365,-0.151907,-0.132675,-0.130936:-0.133001,-0.100573,-0.154201,-0.247729,-0.235765,-0.238914,-0.249066,-0.241499,-0.231322,-0.171598,-0.127596,-0.054237,0.006016,-0.054867,-0.039375,-0.041493,-0.029662,0.030031:-0.003555,-0.008196,0.023767,0.032377,0.034176,0.034076,0.060759,0.058371,0.019142,0.014797,0.088482,0.105432,0.093845,0.134537,0.10514,0.072907,0.052693,0.043921:7
0.990024,0.794613,0.739377,0.873352,0.95161,1.000213,1.051482,1.031791,0.907259,0.824436,0.679252,0.494774,0.308947,0.200991,0.335375,0.383353,0.327239:0.417418,0.555054,0.52672,0.44995,0.363417,0.337631,0.314516,0.281955,0.416552,0.445446,0.388037,0.260095,0.412125,0.551314,0.407037,0.351895,0.367438:0.131779,0.120928,0.311778,0.162799,0.09646,0.115208,0.077976,-0.036675,-0.28675,-0.302656,-0.21913,-0.138978,-0.085753,0.081138,0.084386,0.136212,0.17277:-0.647602,-0.743437,-0.836126,-0.788205,-0.771743,-0.80425,-0.842318,-0.777762,-0.572932,-0.491945,-0.501437,-0.482786,-0.472562,-0.4827,-0.407288,-0.349229,-0.286653:0.204029,0.31848,0.172239,0.233347,0.350423,0.397812,0.449794,0.466454,0.48217,0.543968,0.604766,0.590509,0.581778,0.513959,0.575618,0.507717,0.472758:-0.597146,-0.602618,-0.443299,-0.414751,-0.449612,-0.391495,-0.27694,-0.120371,-0.163064,-0.160849,-0.04441,0.04852,-0.028274,-0.033933,-0.001776,0.005124,-0.053727:-0.242897,-0.136212,-0.075786,-0.096799,-0.121978,-0.111133,-0.11116,-0.102226,-0.045912,-0.004053,-0.054057,-0.099165,-0.002574,0.070725,-0.015896,0.024535,0.079513:0.176911,0.126832,0.050732,0.096733,0.143012,0.137762,0.094407,-0.009479,-0.050367,-0.152846,-0.166918,-0.15282,-0.149856,-0.216779,-0.240443,-0.204829,-0.231908:0.179177,-0.002705,-0.101298,-0.015399,-0.031855,-0.106353,-0.128336,-0.119544,-0.115292,-0.093675,-0.170231,-0.160792,-0.213671,-0.247975,-0.221671,-0.256609,-0.222148:0.017878,0.132164,0.07052,0.047844,0.046218,0.003031,-0.028416,-0.018559,-0.130697,-0.200443,-0.205494,-0.196651,-0.191814,-0.169395,-0.118537,-0.10264,-0.083296:-0.029325,-0.048758,-0.050646,-0.128806,-0.163044,-0.146711,-0.128234,-0.15599,-0.108656,-0.094745,-0.113576,-0.15482,-0.09873,-0.013822,0.006505,-0.019922,-0.041792:0.017052,0.034312,0.090311,0.07314,0.038449,0.038129,0.045766,0.06125,-0.040126,-0.00694,0.047787,0.033421,0.013736,0.024936,0.029674,0.049517,0.053805:7
1.093728,1.145229,1.127935,1.035595,0.922226,0.800794,0.827312,0.921962,0.983744,0.883116,0.739288,0.789319,0.787241,0.717261,0.655802,0.529126:0.252823,0.254283,0.155747,0.229787,0.339872,0.428578,0.355052,0.323819,0.172423,0.193263,0.298626,0.293784,0.165798,0.157046,0.308777,0.370961:0.180421,0.175912,0.138448,0.12012,0.039699,0.027172,-0.142377,-0.232388,-0.084644,0.024409,-0.020093,0.018308,0.011908,0.070163,0.067292,0.049994:-0.958492,-0.879129,-0.748714,-0.741796,-0.614264,-0.640949,-0.504146,-0.412461,-0.426207,-0.383705,-0.266084,-0.238846,-0.171902,-0.171468,-0.213809,-0.155269:0.212178,0.195193,0.08781,0.016971,0.051805,0.094508,0.297229,0.472605,0.502018,0.363352,0.374706,0.280303,0.3937,0.409184,0.322851,0.437861:-0.32526,-0.321938,-0.152883,-0.019961,-0.162113,-0.045683,-0.029937,-0.117204,-0.081035,-0.02114,0.036036,0.067596,-0.015624,-0.042936,0.111251,0.037076:-0.142523,-0.148672,-0.141078,-0.120837,-0.034777,-0.067684,-0.122182,-0.108796,-0.086926,-0.008456,0.045582,0.095193,0.094082,0.0983,0.052016,0.002555:0.086617,0.063721,-0.026409,0.011398,0.022576,-0.044815,-0.178908,-0.179859,-0.20956,-0.268084,-0.381386,-0.371998,-0.348045,-0.344042,-0.428054,-0.381592:-0.084225,-0.003226,0.053597,-0.048316,0.002317,0.030052,0.086958,0.028832,0.008992,-0.029814,-0.060494,-0.048762,-0.098587,-0.133394,-0.019991,-0.024183:0.055356,0.056976,0.013809,-0.068903,-0.198754,-0.25119,-0.225651,-0.203963,-0.145426,-0.095075,-0.16448,-0.291883,-0.202963,-0.127452,-0.232375,-0.235579:-0.045436,-0.101978,-0.139937,-0.100367,-0.054039,0.001967,-0.007831,-0.032462,-0.156008,-0.168161,-0.05396,0.034392,-0.045674,-0.070137,0.00592,0.035364:0.051094,0.070377,0.082281,0.047799,0.048609,0.069845,0.073231,0.029621,0.105543,0.142099,0.173885,0.159034,0.157369,0.118735,0.086316,0.029575:7
0.479529,0.512327,0.509446,0.575635,0.5557,0.4814,0.546957,0.615086,0.728806,0.666991,0.74169,0.96522,0.997618,0.857489,0.910712,0.781584,0.513215,0.511669,0.38665,0.319133,0.456994:0.511991,0.517507,0.554046,0.50691,0.460349,0.3586,0.242093,0.272781,0.266569,0.298743,0.086081,-0.031036,-0.010957,-0.008386,-0.067674,0.132762,0.181548,0.102643,0.10463,0.072723,-0.036882:0.313722,0.208303,0.109692,0.046939,-0.029109,-0.013962,0.095862,0.043756,-0.096158,-0.023491,0.011169,0.090779,0.063216,0.113367,0.113846,-0.051813,-0.002752,0.080527,0.134425,0.212717,0.232092:-0.656374,-0.637883,-0.626337,-0.498598,-0.429184,-0.387315,-0.455049,-0.59897,-0.553044,-0.532607,-0.479901,-0.462617,-0.346925,-0.350942,-0.222318,-0.217307,-0.110874,-0.117848,-0.061514,0.033313,-0.006122:0.112063,0.075298,0.208468,0.326717,0.342438,0.303159,0.285348,0.392217,0.386921,0.331508,0.425177,0.508388,0.415249,0.401867,0.468317,0.505116,0.443603,0.558526,0.626502,0.601026,0.590666:-0.417808,-0.329819,-0.483284,-0.592055,-0.499185,-0.403263,-0.270713,-0.250382,-0.283033,-0.276381,-0.210382,-0.161073,-0.046378,0.03129,-0.063098,-0.120585,-0.171665,-0.191089,-0.303193,-0.362024,-0.263762:-0.158603,-0.119658,-0.090692,-0.10497,-0.145461,-0.159259,-0.158859,-0.082042,0.026,0.054428,-0.097165,-0.172753,-0.218248,-0.216821,-0.173219,-0.076954,-0.013106,-0.156425,-0.156523,-0.129761,-0.096612:0.235797,0.198484,0.256896,0.20398,0.091306,0.051843,0.116535,0.164304,0.095294,0.073822,0.019412,0.042037,0.031945,0.011574,-0.064967,-0.099973,-0.136155,-0.078807,-0.064038,-0.103216,-0.114888:0.01349,-0.029932,-0.018093,0.084054,0.161747,0.146813,0.063246,-0.01497,-0.040387,-0.062333,-0.0093,-0.050024,-0.040381,-0.093213,-0.050093,-0.070043,-0.030984,0.00974,-0.008801,0.037072,-0.01443:-0.040875,-0.050477,-0.001236,-0.019975,-0.081464,-0.174375,-0.179002,-0.171566,-0.173002,-0.201939,-0.178879,-0.158185,-0.210968,-0.190755,-0.180541,-0.160064,-0.259525,-0.200802,-0.123044,-0.117279,-0.177638:0.103185,0.101721,-0.0207,-0.091602,-0.066425,-0.005369,-0.056866,-0.144294,-0.14396,-0.063452,-0.108946,-0.132348,-0.043554,-0.053375,-0.13534,-0.089495,-0.019895,-0.136747,-0.200443,-0.193661,-0.162258:0.013299,-0.032334,0.015865,0.084482,0.076027,0.049971,0.103,0.117813,0.13728,0.141816,0.149183,0.152506,0.109484,0.134637,0.177206,0.118632,0.104689,0.081917,0.065474,0.05159,0.098345:7
0.59587,0.918156,1.067385,0.945759,1.036181,1.171354,1.1775,1.037101,0.862678,0.942212,1.071257,1.131791,1.29831,1.159161,0.97132,0.916897,1.086126,0.915579,0.733317,0.7882,0.877599,0.907883,0.819647,0.694983,0.65212:0.145085,0.003947,0.19112,0.245446,0.249244,0.198213,0.085983,0.168211,0.263389,0.314286,0.256907,0.17181,0.110882,0.122663,0.113483,0.097419,0.016557,0.017403,0.1472,0.197891,0.169957,0.160275,-0.027962,0.005096,-0.004763:0.304334,0.240874,0.073841,0.064593,0.025086,-0.012537,0.038901,0.051131,0.004169,-0.057106,-0.08076,-0.058187,-0.087823,-0.178258,-0.230543,-0.201633,-0.163399,-0.156507,-0.111998,-0.053648,-0.013688,0.075982,0.074923,-0.004106,-0.050375:-0.848149,-0.787581,-0.748582,-0.784968,-0.80628,-0.803055,-0.804507,-0.827647,-0.830082,-0.843457,-0.821174,-0.821808,-0.796673,-0.720907,-0.661047,-0.644075,-0.56235,-0.511774,-0.492796,-0.533183,-0.539584,-0.644744,-0.430862,-0.305161,-0.166756:0.199972,0.214622,0.22639,0.289846,0.298386,0.27663,0.282515,0.275141,0.284192,0.351094,0.374006,0.392356,0.376751,0.344884,0.350743,0.375994,0.396787,0.473264,0.559507,0.559123,0.51747,0.533158,0.632208,0.710667,0.701997:-0.509893,-0.440595,-0.453903,-0.490447,-0.476695,-0.443495,-0.412643,-0.344973,-0.353125,-0.356472,-0.351967,-0.35801,-0.312468,-0.226116,-0.21546,-0.168532,-0.078459,-0.115443,-0.10381,-0.06723,-9.16E-4,0.108797,0.01327,-0.124203,-0.171669:-0.354674,-0.334987,-0.292091,-0.312836,-0.267564,-0.214914,-0.273463,-0.242722,-0.22524,-0.179889,-0.166265,-0.18198,-0.164823,-0.185475,-0.127063,-0.125118,-0.198318,-0.22727,-0.229966,-0.185033,-0.152054,-0.176857,-0.230747,-0.191291,-0.189263:0.173234,0.171972,0.09838,0.147921,0.138111,0.08014,0.147367,0.122215,0.107004,0.091366,0.055913,0.058575,0.059055,0.061649,0.005397,-0.032496,-0.057744,-0.054962,-0.097398,-0.137146,-0.170057,-0.166103,-0.157136,-0.157338,-0.17433:-7.6E-4,0.093092,0.179949,0.152113,0.123802,0.117115,0.115153,0.125507,0.09393,0.05188,0.068579,0.053121,0.037712,-0.052753,-0.080068,-0.071074,-0.043812,-0.070964,-0.096267,-0.129365,-0.12045,-0.176744,-0.193523,-0.164594,-0.109625:0.078397,0.024471,0.0504,0.099675,0.106958,0.085994,0.039454,0.003369,0.019967,0.019188,-0.037096,-0.031396,-0.056614,-0.092922,-0.118306,-0.147032,-0.200994,-0.159748,-0.163842,-0.171077,-0.195418,-0.15751,-0.123859,-0.13016,-0.180294:-0.03976,-0.087705,-0.098588,-0.114662,-0.106072,-0.121254,-0.127516,-0.122504,-0.121788,-0.120535,-0.12155,-0.165864,-0.192273,-0.109699,-0.127395,-0.118407,-0.082429,-0.080448,-0.030917,0.005921,0.002101,0.001839,5.19E-4,-0.047725,-0.039842:0.00809,0.025018,0.018251,-0.015183,-0.017592,0.017212,-0.017468,-0.002301,-0.001526,-0.016197,-0.010277,0.003776,-0.003767,-0.069997,-0.028607,-0.00349,0.005451,-3.89E-4,0.021102,0.045024,0.069514,0.05853,5.56E-4,-4.69E-4,-0.010048:7
0.987293,0.898128,0.904586,1.030244,0.932445,0.857313,0.904708,1.031835,0.91794,0.686031,0.667376,0.615298,0.560356,0.592446,0.460955,0.284835,0.35536,0.234664:-0.084813,-0.010144,0.050403,-0.036617,0.035664,0.120591,0.11742,-0.025207,0.053701,0.167532,0.135848,0.106299,0.097357,0.065526,0.016256,-0.010749,-0.023155,0.06427:0.350135,0.311768,0.235893,0.133207,0.020461,-0.04904,-0.028181,-0.083844,-0.154025,-0.174515,-0.162652,0.063132,0.090048,-0.019981,0.054749,0.114767,0.12117,0.142822:-0.727016,-0.689414,-0.640734,-0.595826,-0.598523,-0.564928,-0.631347,-0.48509,-0.343829,-0.316136,-0.27699,-0.359293,-0.243762,-0.050066,-0.049527,-0.009184,0.055575,0.040702:0.081792,0.091163,0.081604,0.116278,0.260751,0.35128,0.320131,0.278113,0.382386,0.398052,0.494113,0.506766,0.551638,0.480371,0.48729,0.550962,0.552462,0.472941:-0.168853,-0.185672,-0.127749,-0.074022,-0.087528,-0.137042,-0.00817,0.088085,0.023915,0.080679,0.114598,0.048273,0.004925,-0.029307,0.042602,0.048761,0.015618,0.049844:-0.266979,-0.206164,-0.006468,-0.011547,-0.096907,-0.052825,-0.004453,-0.048731,-0.012985,0.008426,-0.005234,-0.01824,-0.083279,0.034123,-0.031661,-0.146751,-0.128789,0.00427:0.046818,0.00602,-0.133349,-0.182519,-0.140239,-0.10953,-0.138094,-0.243998,-0.287718,-0.342767,-0.392603,-0.267734,-0.277729,-0.312625,-0.318731,-0.31755,-0.327387,-0.354868:0.19607,0.168457,0.117123,0.237755,0.189117,0.054304,0.017412,0.128223,0.099664,0.085224,0.063629,0.013832,-0.001978,-0.020186,0.037545,0.065465,0.107199,0.001202:0.060369,0.025799,-0.029727,-0.032324,0.007848,0.01356,-0.059525,-0.172908,-0.106823,-0.066011,-0.136459,-0.18079,-0.157309,-0.17545,-0.217609,-0.18793,-0.206921,-0.229707:-0.223176,-0.19987,-0.19101,-0.280642,-0.27808,-0.206489,-0.164775,-0.137157,-0.159,-0.11807,-0.011942,0.049818,-0.014544,-0.028727,-0.023175,-0.012835,-0.003653,0.080015:0.060755,0.115611,0.220334,0.217292,0.174502,0.173096,0.183942,0.177504,0.154038,0.178709,0.181644,0.180099,0.201372,0.183181,0.162262,0.160227,0.152898,0.127418:7
0.891301,0.833655,0.854492,0.848678,0.699393,0.827169,0.743084,0.727795,0.77589,0.646841,0.557966,0.518693,0.444102,0.420467,0.338946,0.254304:0.29649,0.267917,0.211919,0.176066,0.190696,0.076714,0.04453,-0.010161,-0.051652,-0.005603,-0.016913,-0.082936,-0.1328,-0.087671,-0.095942,-0.208759:0.159636,0.108248,0.090254,0.05005,-0.046789,-0.070531,-0.085623,-0.053979,-0.047312,-0.148226,-0.205286,-0.229922,-0.116787,-0.072396,-0.008405,0.093167:-0.578351,-0.643103,-0.672292,-0.662065,-0.64921,-0.645484,-0.598363,-0.647853,-0.657869,-0.482602,-0.318858,-0.279328,-0.338905,-0.329493,-0.261535,-0.173665:0.276586,0.392904,0.405727,0.37176,0.434566,0.525103,0.496923,0.494644,0.50425,0.483253,0.462524,0.482759,0.574605,0.605648,0.526803,0.518774:-0.526144,-0.494128,-0.473092,-0.416887,-0.355559,-0.303717,-0.258639,-0.133107,-0.028916,1.8E-5,0.064566,0.066249,0.055069,0.039445,0.075635,0.063873:-0.179687,-0.239816,-0.240416,-0.156445,-0.116125,-0.177157,-0.147403,-0.130857,-0.128481,-0.097853,-0.101455,-0.057867,-0.092234,-0.077109,-0.014778,-0.040006:0.071175,0.067445,0.085752,0.072526,0.008869,0.00405,-0.009808,-0.025336,-0.039706,-0.14375,-0.274509,-0.277145,-0.226806,-0.246653,-0.305752,-0.308766:0.050806,0.047187,0.074616,0.052682,0.011935,7.46E-4,-0.007432,-0.041488,-0.093464,-0.051823,0.035522,-0.012208,-0.110959,-0.109932,-0.080042,-0.06864:-0.008093,0.013931,0.004954,-0.016595,-0.048502,-0.045061,-0.08385,-0.11719,-0.150049,-0.234379,-0.330158,-0.307605,-0.198497,-0.195637,-0.244947,-0.215058:-0.074779,-0.100817,-0.136017,-0.168279,-0.195836,-0.204787,-0.226543,-0.202643,-0.15928,-0.140387,-0.084208,-0.066371,-0.096038,-0.081307,-0.031929,-0.018642:0.065539,0.006275,0.007442,0.046076,0.035342,6.73E-4,0.013873,0.02102,0.024544,0.060237,0.072944,0.026832,0.032247,0.041985,0.055149,0.034003:7
1.246408,1.215999,1.221931,1.281469,1.178034,1.018393,0.882642,0.83544,0.884338,0.80126,0.72213,0.679501,0.582742,0.522007,0.503084,0.591853:0.028934,0.152711,0.118106,0.146138,0.191973,0.221572,0.270652,0.394647,0.476469,0.539374,0.586668,0.494957,0.398618,0.36499,0.128103,-0.0777:0.486866,0.433231,0.436785,0.415026,0.27552,0.122116,0.045525,-0.116585,-0.255062,-0.258372,-0.175163,-0.055308,0.07087,0.015906,0.059969,0.164115:-0.369081,-0.551806,-0.5795,-0.534669,-0.513419,-0.509286,-0.493744,-0.329331,-0.353944,-0.446609,-0.579743,-0.613655,-0.484602,-0.225242,-0.027131,0.099511:-0.060187,0.062949,0.014156,-0.039824,-0.078803,-0.003163,0.152392,0.114283,0.259719,0.362404,0.432659,0.467573,0.436593,0.377177,0.453038,0.408259:-0.364942,-0.298039,-0.197501,-0.191125,-0.17185,-0.115712,-0.094633,-0.041925,-0.007708,-0.144139,-0.104172,-0.046811,-0.079809,-0.061058,0.042917,0.073093:-0.224876,-0.296233,-0.385297,-0.338235,-0.153697,-0.191058,-0.280903,-0.198723,-0.104235,0.008964,0.063886,0.134423,0.162181,0.122648,-0.004391,-0.035143:0.106865,0.168888,0.088421,0.035987,0.011758,0.010525,0.051866,-0.104529,-0.216455,-0.145197,-0.128201,-0.139936,-0.16835,-0.205985,-0.265979,-0.318286:0.063987,0.063438,0.168217,0.187875,0.145228,0.146667,0.101422,0.248567,0.134364,-0.078724,-0.185554,-0.216152,-0.213107,-0.141132,-0.038185,0.012461:0.13092,0.093343,0.138924,0.120809,0.051692,0.01655,-0.018147,-0.205526,-0.160194,-0.046114,-0.082912,-0.132329,-0.085286,-0.213969,-0.29344,-0.339714:-0.085051,-0.045262,-0.097396,-0.113712,-0.164841,-0.175719,-0.135964,-0.054381,-0.032087,-0.126528,-0.126251,-0.146524,-0.14576,-0.02087,0.010026,-0.003971:0.047267,-0.012678,-0.00678,0.022961,0.039933,0.023812,-0.017125,-0.003284,0.016152,0.079989,0.102472,0.108587,0.099305,0.040542,0.071629,0.144368:7
0.917441,0.83423,0.844789,0.713405,0.588785,0.535687,0.462241,0.324519,0.183415,0.077047:-0.587333,-0.410407,-0.404806,-0.365527,-0.353828,-0.407941,-0.579253,-0.624827,-0.507966,-0.513728:0.047873,0.07598,0.086962,0.041147,0.099177,0.223372,0.345084,0.491188,0.620941,0.745372:-0.34077,-0.347517,-0.273976,-0.237465,-0.155802,-0.101515,-0.025921,0.095928,0.2139,0.300464:-0.002475,0.137446,0.199837,0.221827,0.284266,0.440514,0.466077,0.460771,0.415368,0.373444:-0.14879,-0.202531,-0.210676,-0.18104,-0.140318,-0.124748,-0.15936,-0.250834,-0.307854,-0.304345:-0.123322,-0.102925,-0.09033,-0.089045,-0.137679,-0.244183,-0.228341,-0.180819,-0.15311,-0.143188:0.09183,-0.001504,-0.14312,-0.200153,-0.233045,-0.197945,-0.146051,-0.152887,-0.13892,-0.076727:-0.075701,-0.110739,-0.135989,-0.157292,-0.128836,-0.118048,-0.122774,-0.131537,-0.130357,-0.119254:-0.327151,-0.282265,-0.207313,-0.202108,-0.206589,-0.175164,-0.107414,-0.077041,-0.085197,-0.069385:-0.03358,0.01359,0.025807,0.115768,0.1658,0.122531,0.059577,-0.016646,-0.043828,-0.071635:0.224802,0.268328,0.297188,0.205539,0.128068,0.0618,-0.056675,-0.096541,-0.132929,-0.174906:8
1.052872,1.124436,1.0537,0.979647,0.878323,0.876914,0.90564,0.853989,0.800752,0.773894,0.74148,0.713085:-0.13003,-0.231588,-0.121337,-0.180893,-0.431465,-0.663162,-0.619706,-0.708265,-0.766809,-0.803302,-0.810582,-0.873766:-0.29785,-0.344837,-0.292895,-0.281981,-0.148127,-0.021576,0.111323,0.295777,0.43731,0.653174,0.739916,0.847064:-0.13562,-0.036077,-0.08732,-0.113697,-0.087663,0.033186,0.06208,0.084294,0.107527,0.108675,0.238893,0.329313:-0.286437,-0.356449,-0.341607,-0.341491,-0.193112,-0.056093,0.096837,0.205978,0.273016,0.320183,0.33776,0.321754:-0.255265,-0.181277,-0.12953,-0.095406,-0.070172,-0.022223,-0.038889,-0.02878,-0.060675,-0.233508,-0.305371,-0.101597:0.001007,0.048384,-0.025759,-0.047377,-0.113429,-0.210951,-0.287283,-0.415369,-0.45657,-0.335497,-0.21626,-0.239707:-0.066882,-0.143909,-0.126369,-0.114569,-0.110124,-0.101975,-0.102788,-0.156085,-0.148713,-0.133251,-0.092223,-0.014024:0.209557,0.156598,0.107736,0.026707,-0.102251,-0.253129,-0.316309,-0.188374,-0.13832,-0.167388,-0.152546,-0.07137:-0.417565,-0.376575,-0.401283,-0.421749,-0.323419,-0.228157,-0.169675,-0.133531,-0.104878,-4.0E-6,0.047561,-0.019005:0.048598,0.042586,0.170462,0.229496,0.19296,0.123373,0.132818,0.107711,0.073645,-0.026241,-0.103948,-0.046457:0.203458,0.183623,0.222499,0.246854,0.277371,0.247434,0.178873,0.091366,0.023137,-0.05195,-0.092258,-0.168115:8
0.721666,0.719477,0.826922,1.011884,0.87394,0.542652,0.526923,0.74307,0.604837,0.457284,0.31404,0.182495,0.038963,-0.072614:0.235287,0.19389,0.017441,-0.324358,-0.284155,-0.079966,-0.084238,-0.321388,-0.38424,-0.444973,-0.483619,-0.502441,-0.511659,-0.477771:-0.208294,-0.267674,-0.23987,-0.22588,-0.128953,-0.10264,-0.048104,-0.016504,-0.009085,0.078389,0.192778,0.255092,0.338867,0.469851:-0.411741,-0.255502,-0.07282,0.086718,0.054894,-0.0215,-0.07659,-0.044178,0.140313,0.317342,0.464951,0.59227,0.646172,0.601641:0.21681,0.222447,0.174058,0.131411,0.155177,0.226975,0.306645,0.341385,0.338155,0.342656,0.323039,0.320632,0.310203,0.265229:-0.439879,-0.472232,-0.474839,-0.404086,-0.289826,-0.292738,-0.282686,-0.1915,-0.250201,-0.345076,-0.381917,-0.339883,-0.28602,-0.27438:0.082024,0.110063,0.052991,0.152734,0.149262,0.017061,-0.056991,-0.041053,-0.037396,0.006414,0.002067,0.012917,0.049979,0.08414:0.144196,0.045701,-0.003136,-0.059206,-0.109432,-0.188382,-0.261261,-0.330677,-0.335822,-0.324766,-0.262356,-0.233435,-0.21847,-0.213268:0.035029,-0.025469,-0.098958,-0.123932,-0.056523,-0.054094,-0.055189,-0.085181,-0.067569,-0.034416,0.035117,0.116864,0.113213,0.073521:-0.120504,-0.158061,-0.179868,-0.199639,-0.255107,-0.332109,-0.306861,-0.246026,-0.21723,-0.13565,-0.148995,-0.190598,-0.175305,-0.16918:-0.145034,-0.084516,-0.093941,-0.115611,-0.087254,0.049266,0.080134,0.069011,0.074586,-0.003748,-0.022241,-0.014075,-0.03827,-0.069726:0.202483,0.264858,0.278231,0.266202,0.292087,0.270767,0.228369,0.207096,0.139472,0.047564,-0.062717,-0.131385,-0.168456,-0.189143:8
1.496334,1.385434,1.432559,1.417883,1.226584,1.182681,1.141077,1.016237,0.936636,0.786182,0.659076:-0.4766,-0.384583,-0.448778,-0.502019,-0.50933,-0.52227,-0.503513,-0.522784,-0.669546,-0.733531,-0.762243:0.128671,0.143375,0.164335,0.256865,0.325751,0.417836,0.429499,0.438836,0.570028,0.724503,0.865613:-0.480379,-0.389821,-0.363768,-0.382978,-0.286812,-0.211133,-0.127928,0.023367,0.184298,0.245198,0.288024:-0.258138,-0.172918,-0.108872,-0.019899,-0.016182,0.100671,0.30603,0.408879,0.386576,0.393488,0.380364:-0.270433,-0.251335,-0.156599,-0.10395,-0.044299,-0.025606,-0.060877,-0.194784,-0.301715,-0.311081,-0.2349:0.017263,-0.022282,-0.120266,-0.160465,-0.134308,-0.21506,-0.328933,-0.332336,-0.292242,-0.243389,-0.152054:-0.037075,-0.095822,0.004455,-0.011351,-0.064537,-0.155442,-0.210151,-0.202368,-0.115276,-0.038872,-0.0262:-0.091076,-0.129567,-0.225208,-0.19463,-0.251785,-0.264114,-0.166616,-0.107885,-0.12182,-0.090311,-0.091744:-0.211983,-0.246549,-0.276139,-0.32199,-0.262371,-0.188372,-0.1316,-0.117559,-0.065365,-0.035418,0.028233:-0.014279,0.073441,0.181958,0.156723,0.196646,0.207972,0.064678,-0.05457,-0.105787,-0.137887,-0.202388:0.310381,0.352866,0.310171,0.371658,0.283314,0.168324,0.07933,0.021046,-0.079321,-0.115301,-0.186:8
1.212938,1.442664,1.427714,1.262638,1.14986,1.168582,1.029286,0.820778,0.720922,0.762688:-0.711937,-0.594082,-0.649751,-0.83964,-0.796206,-0.822141,-0.855604,-0.830917,-0.876777,-0.958305:0.261502,0.220175,0.181188,0.153171,0.251007,0.396502,0.49389,0.625624,0.719644,0.837613:-0.614347,-0.568592,-0.579573,-0.49621,-0.406479,-0.311736,-0.177618,-0.088874,0.019445,0.103944:-0.111807,-0.009655,0.085712,0.17846,0.258121,0.250517,0.265759,0.330349,0.35629,0.352547:-0.324754,-0.277588,-0.242984,-0.150118,-0.070648,-0.078269,-0.193615,-0.329341,-0.331822,-0.254491:-0.126843,-0.132635,-0.209357,-0.300885,-0.31642,-0.292859,-0.301744,-0.354912,-0.354627,-0.316233:0.164982,0.14649,0.11208,0.030451,-0.012552,-0.044337,-0.041952,-0.021825,0.004621,0.079339:-0.076014,-0.188201,-0.224162,-0.17971,-0.239824,-0.340281,-0.31571,-0.243299,-0.217321,-0.182841:-0.132733,-0.239387,-0.278041,-0.267081,-0.256039,-0.198417,-0.14906,-0.09074,-0.052004,-0.038563:-0.129162,-0.048128,-0.009807,0.018346,0.058926,0.133099,0.087105,0.014074,-0.001817,-0.011566:0.251313,0.281659,0.275708,0.285973,0.219599,0.11932,0.053276,-0.025846,-0.134348,-0.238962:8
1.353403,1.087092,0.829805,0.823466,0.612837,0.520098,0.542239,0.579878,0.538363,0.452873:-0.583277,-0.550837,-0.395419,-0.276881,-0.18653,-0.137962,-0.237843,-0.383804,-0.579677,-0.647348:0.186046,0.225658,0.103162,0.232479,0.367616,0.383789,0.27743,0.337599,0.58627,0.724885:-0.50317,-0.671921,-0.654274,-0.553483,-0.459821,-0.30367,-0.08423,0.018552,0.116733,0.165274:-0.261562,-0.072217,0.087924,0.15891,0.246819,0.300391,0.361954,0.37697,0.366503,0.418452:-0.19244,-0.293462,-0.355243,-0.305442,-0.157818,-0.150837,-0.219487,-0.220251,-0.273701,-0.292869:-0.118787,-0.097718,-0.047917,0.002566,-0.041542,-0.054528,-0.142767,-0.195636,-0.191904,-0.152398:0.224882,0.202807,0.098646,0.046093,-0.069554,-0.196687,-0.227791,-0.184016,-0.086943,-0.024401:-0.141497,-0.259964,-0.220076,-0.255585,-0.324834,-0.338089,-0.228369,-0.192704,-0.168152,-0.132665:-0.266847,-0.262009,-0.259424,-0.238628,-0.164952,-0.153594,-0.131208,-0.075704,-0.01484,-0.019168:0.119975,0.1669,0.139494,0.148188,0.193551,0.210772,0.106598,-0.003557,-0.052347,-0.094876:0.157627,0.256011,0.317915,0.293997,0.168867,0.04218,0.011885,-0.028079,-0.138959,-0.174582:8
0.926877,0.854054,0.819298,0.734843,0.650166,0.59655,0.60809,0.646834,0.604085,0.534595,0.413886:-0.336383,-0.409698,-0.336947,-0.388488,-0.510989,-0.435061,-0.468444,-0.587681,-0.63522,-0.689311,-0.670823:0.159914,0.330015,0.300336,0.155516,0.223736,0.255211,0.29965,0.407713,0.487046,0.604318,0.598661:-0.390682,-0.388052,-0.460676,-0.355771,-0.217459,-0.176778,-0.181177,-0.12741,0.001986,0.144965,0.264385:-0.212373,-0.033936,0.100868,0.127779,0.168943,0.201334,0.327062,0.409875,0.418818,0.373813,0.394685:-0.157505,-0.194622,-0.195488,-0.092266,-0.129562,-0.146838,-0.168212,-0.182409,-0.216257,-0.26174,-0.268338:-0.076994,-0.117128,-0.063216,-0.009174,0.018782,0.065496,-0.073045,-0.209236,-0.222371,-0.186372,-0.196369:0.129379,0.080447,0.029472,-0.091007,-0.179902,-0.197861,-0.095408,-0.046644,-0.053391,-0.047647,-0.017096:0.046638,-0.0817,-0.171937,-0.162954,-0.228165,-0.241636,-0.258877,-0.27205,-0.211792,-0.145144,-0.080087:-0.313401,-0.285679,-0.282334,-0.290865,-0.271872,-0.270558,-0.23651,-0.17154,-0.120995,-0.083207,-0.113479:-0.036659,-0.00432,0.076716,0.075314,0.126647,0.142238,0.122418,0.103649,0.045489,-0.00516,-0.00552:0.160714,0.183835,0.235069,0.257152,0.258453,0.250574,0.179653,0.07576,-0.01057,-0.06533,-0.105424:8
1.073009,1.217138,1.349026,1.181426,0.935451,0.747724,0.582352,0.551827,0.517779,0.5485,0.463176:-0.872243,-0.98795,-0.886976,-0.702947,-0.565152,-0.624156,-0.561361,-0.528172,-0.581326,-0.694758,-0.774101:0.34804,0.249488,0.179512,0.304219,0.358324,0.374682,0.364568,0.387229,0.44949,0.571933,0.667723:-0.495581,-0.544066,-0.495418,-0.441809,-0.434535,-0.438221,-0.294898,-0.134333,0.003383,0.121877,0.262914:-0.262815,-0.164629,-0.128721,-0.049284,0.16044,0.266962,0.333963,0.371668,0.420336,0.442878,0.401562:-0.259608,-0.172845,-0.037159,-0.074078,-0.049931,-0.009909,-0.1171,-0.197317,-0.258889,-0.290699,-0.234778:-0.086249,-0.083399,-0.132839,-0.16196,-0.185539,-0.157356,-0.132395,-0.161993,-0.227986,-0.267957,-0.242709:0.139819,0.098682,0.086005,0.040124,-0.08448,-0.114647,-0.180846,-0.211747,-0.188994,-0.114444,-0.038228:-0.116435,-0.128079,-0.138831,-0.211515,-0.263359,-0.268834,-0.245969,-0.195687,-0.145058,-0.089563,-0.070208:-0.208027,-0.259587,-0.366509,-0.378141,-0.25583,-0.196271,-0.208984,-0.195866,-0.13523,-0.088355,-0.081639:-0.109513,-0.112238,7.44E-4,0.055049,0.067386,0.071181,0.048105,0.028639,-0.021265,-0.082743,-0.079902:0.21303,0.259696,0.231315,0.276424,0.248328,0.223221,0.231351,0.171127,0.061592,-0.009583,-0.094146:8
1.173177,1.31795,1.396463,1.126417,1.149587,1.000221,1.002308,0.945081,0.881734,0.945976,0.815284:-0.573879,-0.577139,-0.534566,-0.446813,-0.671862,-0.783501,-0.817363,-0.82315,-0.807405,-0.848761,-0.893848:0.288365,0.253389,0.301398,0.229239,0.206844,0.281374,0.351,0.358763,0.397796,0.507677,0.62806:-0.736917,-0.741815,-0.641591,-0.530929,-0.540787,-0.506442,-0.407075,-0.285746,-0.259253,-0.16043,0.011248:0.055636,0.103246,0.072228,0.024998,0.036582,0.080505,0.097162,0.202792,0.304149,0.345177,0.33665:-0.389305,-0.374844,-0.338951,-0.210616,-0.175471,-0.151365,-0.139201,-0.169081,-0.152044,-0.142775,-0.237949:-0.212188,-0.210066,-0.130271,-0.102213,-0.151606,-0.169626,-0.153124,-0.182825,-0.268897,-0.375821,-0.378406:0.272271,0.25985,0.224676,0.152189,0.014516,-0.043701,-0.05583,-0.086168,-0.10629,-0.127751,-0.123545:-0.131876,-0.184807,-0.224583,-0.191747,-0.22527,-0.299926,-0.346947,-0.342472,-0.321887,-0.285012,-0.249269:-0.168306,-0.189243,-0.225873,-0.385371,-0.287003,-0.247466,-0.258784,-0.223435,-0.236144,-0.206483,-0.12481:-0.126981,-0.10236,-0.070607,-0.024794,-0.073072,-0.018107,0.013009,-0.007333,0.008323,0.018899,-0.024705:0.170355,0.206133,0.253158,0.229396,0.212426,0.217987,0.210885,0.152962,0.126763,0.080062,-0.007294:8
0.969274,1.019944,1.025541,0.897577,0.737774,0.650033,0.573688,0.576672,0.580776,0.474157,0.432615,0.374844:-0.364676,-0.334019,-0.331276,-0.249662,-0.138838,-0.207099,-0.218488,-0.310251,-0.452626,-0.517544,-0.646638,-0.653992:0.12963,0.100726,0.091129,0.07467,0.179187,0.191902,0.109532,0.147567,0.185256,0.370173,0.531043,0.516352:-0.666811,-0.594882,-0.53807,-0.417746,-0.331071,-0.238335,-0.120445,0.001788,0.145777,0.200879,0.248109,0.340906:-0.011758,0.046765,0.079656,0.04543,0.004809,0.117789,0.296251,0.254521,0.245552,0.332404,0.413705,0.431532:-0.371159,-0.319217,-0.271474,-0.157207,-0.1133,-0.241481,-0.301299,-0.247917,-0.269757,-0.270798,-0.261398,-0.306088:0.034597,-0.008316,-3.33E-4,0.017971,0.058865,-0.046712,-0.109288,-0.166657,-0.158097,-0.194851,-0.245616,-0.217432:0.044426,0.015311,-0.017261,-0.091122,-0.180424,-0.189504,-0.200537,-0.237851,-0.237367,-0.168308,-0.0888,-0.06265:-0.144268,-0.214068,-0.213511,-0.15754,-0.209442,-0.2441,-0.204732,-0.101021,-0.102894,-0.097722,-0.085111,-0.082258:-0.290304,-0.313623,-0.338553,-0.372404,-0.373346,-0.281479,-0.251344,-0.299632,-0.199682,-0.14666,-0.127946,-0.156545:-0.059249,0.013562,0.02281,0.096023,0.241517,0.241175,0.185244,0.163245,0.090886,0.047016,-0.047731,-0.079391:0.31132,0.283397,0.287742,0.251207,0.177842,0.126172,0.088944,0.051963,-0.04166,-0.079348,-0.104155,-0.127206:8
0.721106,0.453363,0.316388,0.216416,0.232335,0.210279,0.25665,0.296015,0.233294:-0.444963,-0.341712,-0.295746,-0.397592,-0.478407,-0.583662,-0.671917,-0.740383,-0.743322:0.328532,0.222406,0.166686,0.22919,0.289653,0.324747,0.500938,0.692591,0.771344:-0.516584,-0.415363,-0.315359,-0.137917,0.005535,0.011394,0.040386,0.101374,0.193737:0.188134,0.284311,0.343891,0.215976,0.208166,0.273005,0.338881,0.427038,0.452251:-0.230078,-0.225532,-0.221085,-0.269349,-0.299996,-0.324302,-0.386444,-0.408935,-0.418762:-0.122697,-0.098502,-0.129408,-0.11509,-0.182325,-0.222534,-0.309404,-0.382229,-0.330649:0.125137,0.020227,-0.053535,-0.152613,-0.199663,-0.156382,-0.072202,-0.00257,0.040558:-0.30548,-0.354424,-0.341962,-0.30706,-0.270205,-0.282554,-0.26467,-0.194707,-0.162182:-0.248238,-0.269377,-0.293813,-0.220249,-0.167521,-0.169544,-0.14528,-0.106289,-0.112502:0.157909,0.119023,0.038284,0.002335,0.041921,0.052956,0.002789,-0.071456,-0.118639:0.211436,0.165803,0.152392,0.049726,-0.043181,-0.072417,-0.086186,-0.129281,-0.144789:8
1.08669,0.986123,0.910148,0.883491,0.899465,0.912837,0.976549,0.933462,0.926213,0.770439,0.585752,0.47521:-0.314253,-0.473351,-0.617667,-0.733094,-0.705131,-0.704882,-0.715959,-0.722138,-0.77264,-0.74088,-0.712599,-0.683421:0.193567,0.176823,0.159239,0.204437,0.256986,0.247338,0.243116,0.299675,0.351147,0.406549,0.513965,0.6168:-0.639918,-0.627211,-0.628806,-0.668848,-0.589163,-0.444144,-0.273818,-0.097022,-0.008295,0.052652,0.10953,0.158333:-0.004903,0.051301,0.180916,0.231231,0.228929,0.29093,0.294622,0.272109,0.294582,0.339467,0.377425,0.401788:-0.277921,-0.258951,-0.262014,-0.230578,-0.219173,-0.155465,-0.125981,-0.170554,-0.233367,-0.324956,-0.321856,-0.29455:-0.206793,-0.258199,-0.249883,-0.261463,-0.261596,-0.25532,-0.247304,-0.254912,-0.274875,-0.258424,-0.223267,-0.205494:0.198094,0.185341,0.130488,0.105788,0.04916,-0.042295,-0.107832,-0.155459,-0.144781,-0.153566,-0.135471,-0.096996:-0.162013,-0.192504,-0.254453,-0.325846,-0.333691,-0.342143,-0.354736,-0.321329,-0.296898,-0.245854,-0.195549,-0.16761:-0.270673,-0.273016,-0.213237,-0.244168,-0.222175,-0.20788,-0.183461,-0.144331,-0.112237,-0.064306,-0.045729,-0.058687:0.014888,0.036833,0.027272,0.025814,0.075592,0.072134,0.072322,0.06207,0.025399,-0.036418,-0.062812,-0.090361:0.138631,0.156814,0.163741,0.165404,0.193338,0.143565,0.05578,0.024003,-0.025912,-0.06819,-0.104688,-0.14588:8
1.678449,1.661562,1.641858,1.410985,1.17866,1.095539,1.038992,0.785269,0.693624,0.806328,0.768105,0.731992,0.602382,0.659561,0.678594,0.575839,0.528083:-0.312888,-0.437823,-0.591126,-0.662663,-0.633646,-0.613558,-0.674355,-0.624425,-0.567867,-0.693017,-0.699256,-0.726138,-0.670694,-0.765078,-0.845652,-0.805056,-0.832183:0.10331,0.034722,0.012341,0.096985,0.121965,0.161461,0.22489,0.208578,0.200173,0.291165,0.277598,0.372298,0.415563,0.46909,0.551466,0.586663,0.656939:-0.662141,-0.611422,-0.557852,-0.660763,-0.597441,-0.486015,-0.313444,-0.232232,-0.178465,-0.140978,-0.024067,0.047691,0.144237,0.207421,0.24329,0.299939,0.292809:-0.092768,0.05896,0.088732,0.176485,0.274627,0.328893,0.312501,0.29617,0.311173,0.303074,0.282807,0.293493,0.309761,0.331399,0.32127,0.314033,0.350299:-0.256991,-0.351039,-0.344024,-0.302018,-0.297052,-0.222434,-0.101164,-0.088056,-0.097065,-0.095485,-0.090783,-0.081706,-0.082785,-0.130388,-0.119874,-0.144642,-0.204057:-0.110225,-0.1447,-0.169331,-0.291557,-0.333247,-0.341443,-0.316143,-0.346526,-0.391238,-0.372045,-0.352308,-0.337814,-0.310848,-0.30838,-0.308431,-0.315965,-0.306472:0.119638,0.184663,0.19459,0.201991,0.13088,0.057657,-0.003063,-0.077363,-0.10396,-0.171498,-0.207277,-0.166346,-0.130856,-0.099456,-0.080166,-0.052718,-0.035622:-0.125574,-0.221498,-0.298172,-0.313864,-0.326384,-0.330883,-0.303349,-0.292185,-0.273589,-0.291058,-0.289835,-0.283442,-0.26872,-0.250582,-0.252868,-0.243587,-0.223032:-0.277348,-0.23931,-0.246496,-0.292436,-0.271883,-0.283414,-0.257871,-0.223702,-0.175548,-0.092931,-0.047164,-0.020822,-0.042483,-0.071127,-0.074628,-0.080001,-0.077768:-0.099477,-0.113275,-0.056361,0.01729,0.056826,0.061748,0.03108,0.040509,0.065686,0.060218,0.064146,0.076499,0.052813,0.019999,-0.004683,-0.043917,-0.09758:0.168583,0.152135,0.133883,0.145174,0.174749,0.177153,0.08257,0.027277,-0.03065,-0.076303,-0.10661,-0.16661,-0.212331,-0.229974,-0.264628,-0.284836,-0.280231:8
1.201842,1.093488,0.964446,1.045901,0.969486,0.889008,0.77397,0.631087,0.485196,0.462649,0.513419,0.533309,0.597257:-0.428381,-0.621112,-0.563681,-0.748314,-0.84667,-0.768062,-0.744824,-0.651806,-0.604972,-0.638365,-0.677977,-0.716661,-0.84095:0.15466,0.1964,0.125915,0.112193,0.147566,0.236824,0.234256,0.161749,0.099012,0.325128,0.519659,0.606951,0.668934:-0.629672,-0.699178,-0.66934,-0.57217,-0.514626,-0.407866,-0.389653,-0.294831,-0.114179,-0.030217,0.048008,0.122611,0.199336:-0.038424,0.034166,0.060737,0.053163,0.087869,0.112706,0.206303,0.299805,0.3361,0.315921,0.358193,0.370197,0.360661:-0.252056,-0.225432,-0.19964,-0.133497,-0.073291,-0.045388,-0.083387,-0.18557,-0.322629,-0.309241,-0.323885,-0.333454,-0.326364:-0.164265,-0.215027,-0.1898,-0.187234,-0.208331,-0.171424,-0.166087,-0.164697,-0.156275,-0.209925,-0.259604,-0.276466,-0.284958:0.037783,0.081215,0.052413,-0.013901,-0.039463,-0.097543,-0.13274,-0.155947,-0.182484,-0.158564,-0.094242,-0.050527,-0.011647:-0.04984,-0.127535,-0.124701,-0.172276,-0.24506,-0.307169,-0.349509,-0.322922,-0.270534,-0.242425,-0.177041,-0.124835,-0.134378:-0.142449,-0.158312,-0.184017,-0.192144,-0.251248,-0.231878,-0.214176,-0.226691,-0.208585,-0.172289,-0.095518,-0.095035,-0.113982:-0.077371,-0.023595,0.013804,0.039776,0.053149,0.098538,0.107368,0.077641,0.064795,0.042735,-0.039957,-0.109955,-0.143445:0.167786,0.195252,0.241146,0.229601,0.203134,0.155833,0.120316,0.100051,0.061044,0.020317,-0.07119,-0.127282,-0.153793:8
0.879081,1.013215,1.059873,1.113963,1.091646,1.01377,0.932986,0.820141,0.773092,0.789093,0.74233,0.636015:-0.444343,-0.464406,-0.52389,-0.5915,-0.602034,-0.597666,-0.53314,-0.566823,-0.67035,-0.685562,-0.742237,-0.757866:0.099331,0.073175,0.159576,0.209836,0.229632,0.249741,0.232753,0.366178,0.528624,0.364661,0.443366,0.604401:-0.685815,-0.634636,-0.591977,-0.582374,-0.635355,-0.634275,-0.496285,-0.297018,-0.098354,-0.02133,-0.006858,0.038453:-0.03018,-0.071549,-0.073627,-0.024492,0.085174,0.173312,0.270296,0.203326,0.167034,0.266587,0.275187,0.303135:-0.379373,-0.269729,-0.203382,-0.185619,-0.199261,-0.192576,-0.209305,-0.186301,-0.206373,-0.302356,-0.325217,-0.310434:-0.104122,-0.158297,-0.198189,-0.180279,-0.158767,-0.169954,-0.134077,-0.045953,-0.10612,-0.132531,-0.172753,-0.22582:0.158748,0.116597,0.132144,0.106984,0.054284,-0.001029,-0.08523,-0.223448,-0.20901,-0.193349,-0.17064,-0.129899:-0.082151,-0.09244,-0.180103,-0.237306,-0.312561,-0.370374,-0.390352,-0.403985,-0.363433,-0.339836,-0.301589,-0.266315:-0.235658,-0.282798,-0.247531,-0.170085,-0.133694,-0.137603,-0.13766,-0.103457,-0.068005,-0.060802,-0.059569,-0.042214:-0.073367,0.040183,0.097557,0.086365,0.058721,0.070857,0.069023,0.066641,0.047906,-0.005489,-0.043789,-0.054525:0.276331,0.238997,0.17249,0.146547,0.146797,0.142879,0.164518,0.158509,0.05056,-0.007115,-0.040624,-0.09843:8
1.019158,0.975532,0.770579,0.707209,0.689422,0.710751,0.679867,0.565154,0.52507,0.539991,0.521288:-0.602569,-0.523103,-0.444281,-0.483107,-0.485024,-0.576882,-0.687371,-0.616084,-0.686349,-0.733352,-0.7502:0.229669,0.110091,0.152131,0.242634,0.219656,0.281093,0.337767,0.289659,0.328602,0.405949,0.463399:-0.703522,-0.555926,-0.46956,-0.425719,-0.430119,-0.281412,-0.143733,0.003549,0.115551,0.187611,0.299634:0.22499,0.246406,0.286554,0.299161,0.351554,0.331216,0.339461,0.345475,0.368774,0.389116,0.394445:-0.310842,-0.319112,-0.268525,-0.262949,-0.241537,-0.194484,-0.196211,-0.193068,-0.213007,-0.227184,-0.26061:-0.180708,-0.102673,-0.14401,-0.207494,-0.203626,-0.202653,-0.222827,-0.240852,-0.261168,-0.274081,-0.284837:0.272597,0.140536,0.02111,-0.045735,-0.089082,-0.148615,-0.165863,-0.158376,-0.0978,-0.068417,-0.034639:-0.303556,-0.30913,-0.298234,-0.327777,-0.37703,-0.364868,-0.344996,-0.298995,-0.228164,-0.190398,-0.199125:-0.26045,-0.271042,-0.270672,-0.18623,-0.145336,-0.119351,-0.11267,-0.113768,-0.110512,-0.094826,-0.076713:-0.068712,-0.117232,-0.084716,0.001429,0.057909,0.087267,0.079606,0.090111,0.047716,-0.012225,-0.061174:0.126824,0.178276,0.197727,0.138179,0.075712,0.045993,0.039638,-0.021109,-0.121971,-0.180276,-0.236276:8
1.109512,1.191945,1.23305,1.174544,1.069766,0.884114,0.764801,0.701993,0.681959,0.580681,0.409447,0.280801,0.147217,0.091064,0.156791:-0.766059,-0.706248,-0.71257,-0.663283,-0.605153,-0.539755,-0.514003,-0.536067,-0.617115,-0.70189,-0.65846,-0.650537,-0.636198,-0.644922,-0.712055:0.254505,0.213192,0.187809,0.140772,0.113066,0.091469,0.097644,0.153896,0.208272,0.315175,0.390855,0.487338,0.579689,0.640095,0.705467:-0.660506,-0.754806,-0.763419,-0.630481,-0.573823,-0.459021,-0.351306,-0.275709,-0.175203,-0.068757,0.018923,0.071168,0.145006,0.209932,0.254457:0.014341,0.119191,0.182967,0.17844,0.243588,0.318443,0.370457,0.413935,0.380289,0.399228,0.471683,0.522616,0.509588,0.490601,0.470796:-0.220301,-0.219042,-0.196322,-0.158345,-0.161301,-0.170266,-0.159925,-0.194536,-0.222143,-0.268729,-0.313762,-0.317617,-0.299203,-0.324094,-0.338979:-0.277641,-0.298022,-0.295161,-0.249753,-0.221963,-0.17367,-0.159664,-0.209529,-0.24677,-0.275914,-0.269367,-0.23466,-0.227684,-0.214029,-0.226816:0.174422,0.186983,0.158155,0.054404,-0.041752,-0.134053,-0.202384,-0.181377,-0.165172,-0.13023,-0.089901,-0.051306,-0.065411,-0.051435,-0.012822:-0.109673,-0.189745,-0.246971,-0.267184,-0.300432,-0.316924,-0.29363,-0.293737,-0.288526,-0.275332,-0.219024,-0.198086,-0.165941,-0.156583,-0.157375:-0.289221,-0.302322,-0.291022,-0.265543,-0.206009,-0.190414,-0.203746,-0.193244,-0.158881,-0.12765,-0.116632,-0.096485,-0.093539,-0.095146,-0.112201:-0.059366,-0.030871,-4.24E-4,0.027499,0.059192,0.051919,0.034141,0.041359,0.043199,0.028253,0.009445,-0.032645,-0.081725,-0.118927,-0.138941:0.138971,0.162433,0.183891,0.179626,0.182638,0.196154,0.164135,0.079196,-5.09E-4,-0.041745,-0.074563,-0.115008,-0.135057,-0.152355,-0.156094:8
1.091764,1.096155,0.843608,0.942752,1.027709,0.872092,0.81651,0.766872,0.720964,0.600284,0.431284:-0.550228,-0.36039,-0.320323,-0.567977,-0.633705,-0.48677,-0.462563,-0.530822,-0.613057,-0.56138,-0.507057:0.100592,0.028265,0.071906,0.230703,0.274328,0.209635,0.321689,0.443768,0.510248,0.542025,0.579374:-0.687898,-0.488987,-0.339743,-0.348939,-0.348903,-0.226771,-0.076531,0.046705,0.151919,0.217631,0.27085:0.212557,0.299779,0.420477,0.446673,0.465659,0.500801,0.510872,0.532984,0.53938,0.54417,0.528632:-0.391154,-0.401874,-0.335507,-0.222584,-0.184909,-0.224348,-0.26323,-0.255375,-0.305743,-0.352905,-0.359592:-0.171296,-0.130937,-0.152888,-0.250378,-0.291953,-0.278368,-0.268243,-0.255559,-0.255837,-0.25445,-0.24303:0.139304,0.063899,-0.027672,-0.04982,-0.08118,-0.142849,-0.136621,-0.084913,-0.055109,-0.048466,-0.045504:-0.278771,-0.324663,-0.352631,-0.423167,-0.449462,-0.427628,-0.422823,-0.348743,-0.255507,-0.220322,-0.211537:-0.221642,-0.260696,-0.224666,-0.214777,-0.193843,-0.127247,-0.049714,-0.031272,-0.019456,-0.033664,-0.079497:-0.108883,-0.076979,-0.05334,-0.008055,0.005762,0.014341,0.056554,0.022782,-0.100007,-0.147412,-0.124702:0.232322,0.25699,0.187285,0.152596,0.121983,0.058567,-0.02252,-0.101213,-0.160583,-0.190013,-0.192719:8
1.301345,1.209992,1.190015,1.131816,1.17789,1.175467,1.041964,0.944589,0.893499,0.96647,1.026342,0.873342:-0.534115,-0.633089,-0.620525,-0.524114,-0.482948,-0.392443,-0.294029,-0.293194,-0.354497,-0.543053,-0.785179,-0.794501:-0.029277,-0.033089,0.011236,-0.112041,-0.145634,-0.13916,-0.036424,0.078352,0.229951,0.314969,0.461673,0.579051:-0.596741,-0.500381,-0.522727,-0.497173,-0.462715,-0.375686,-0.418711,-0.378307,-0.280186,-0.078892,0.099824,0.134165:-0.164916,-0.098506,-0.020879,0.061431,0.123872,0.151293,0.271659,0.301257,0.341701,0.389113,0.387659,0.434957:-0.339901,-0.337273,-0.306658,-0.32764,-0.293325,-0.237829,-0.188666,-0.1403,-0.116309,-0.160728,-0.207881,-0.231771:-0.077589,-0.086791,-0.13667,-0.109473,-0.090088,-0.088881,-0.193895,-0.23388,-0.264697,-0.311022,-0.269206,-0.261473:0.093173,0.086518,0.108085,0.106776,0.071091,-0.055991,-0.12285,-0.169752,-0.180778,-0.12894,-0.100509,-0.045698:-0.048059,-0.088164,-0.116978,-0.143268,-0.183919,-0.16038,-0.181054,-0.195307,-0.207318,-0.199085,-0.182074,-0.158303:-0.162472,-0.173342,-0.23123,-0.210644,-0.255584,-0.286486,-0.210955,-0.163272,-0.127807,-0.083932,-0.04285,-0.065433:-0.090877,-0.058931,-0.013058,0.00605,0.003138,0.023304,0.092174,0.111564,0.096867,0.035421,-0.039475,-0.076751:0.179604,0.219704,0.25257,0.251026,0.259313,0.267802,0.203991,0.150153,0.085301,-0.017062,-0.078917,-0.11159:8
1.390405,1.380391,1.350672,1.333235,1.285052,1.183065,1.05476,1.051171,0.885946,0.829237,0.714141,0.547098,0.39324,0.299703,0.299449:-0.476216,-0.403163,-0.473901,-0.525722,-0.462999,-0.389952,-0.28413,-0.292214,-0.366063,-0.400854,-0.522518,-0.518251,-0.518779,-0.646628,-0.726452:0.093175,0.113008,0.163935,0.27249,0.324566,0.206194,0.148838,0.083108,0.179172,0.249991,0.378024,0.444419,0.529595,0.617293,0.753356:-0.302409,-0.391299,-0.445182,-0.542579,-0.52106,-0.445253,-0.477626,-0.406933,-0.306834,-0.242525,-0.144388,-0.053498,0.083489,0.175945,0.187075:-0.247381,-0.055049,0.052596,0.116325,0.162075,0.203689,0.361592,0.497918,0.470408,0.531181,0.517572,0.521477,0.491686,0.478795,0.480183:-0.145331,-0.156097,-0.221714,-0.212812,-0.173912,-0.131019,-0.169226,-0.247144,-0.213689,-0.212283,-0.196981,-0.238986,-0.268245,-0.257832,-0.28384:-0.115536,-0.115054,-0.07615,-0.098479,-0.101448,-0.083627,-0.110298,-0.134858,-0.127624,-0.185981,-0.20795,-0.211315,-0.194227,-0.143886,-0.195607:0.174954,0.239636,0.255362,0.259795,0.201985,0.087612,0.084369,0.079797,0.030155,-0.021733,-0.106228,-0.117577,-0.063839,0.001563,0.067619:0.040786,-0.083825,-0.181115,-0.209524,-0.234403,-0.222596,-0.277766,-0.284177,-0.313229,-0.316524,-0.286036,-0.257698,-0.264179,-0.244695,-0.213755:-0.350866,-0.371475,-0.280469,-0.235042,-0.198339,-0.205222,-0.172786,-0.16232,-0.148914,-0.113946,-0.052044,-0.027255,-0.017438,-0.019829,-0.06118:0.01929,0.105251,0.089581,0.046786,0.049399,0.046925,0.081696,0.048609,0.073714,0.080415,0.050544,0.040834,0.028188,-0.026236,-0.065874:0.244791,0.223525,0.214936,0.205203,0.195815,0.217748,0.205157,0.210677,0.163228,0.094355,0.025248,-0.057468,-0.146357,-0.155619,-0.165533:8
0.966185,0.9227,0.829345,0.667718,0.50875,0.414774,0.332277,0.267508,0.218597,0.208793,0.099395,-0.034421,-0.099102:-0.483338,-0.499936,-0.511005,-0.481633,-0.47086,-0.488236,-0.470285,-0.501878,-0.551996,-0.611839,-0.59138,-0.53294,-0.52888:0.065536,0.071323,0.061024,0.032298,0.02534,0.079679,0.091608,0.122299,0.225879,0.397122,0.483293,0.50725,0.538871:-0.536177,-0.551997,-0.512818,-0.397476,-0.247329,-0.145954,-0.047701,0.056365,0.163625,0.22645,0.264305,0.327887,0.381054:0.0245,0.106533,0.119246,0.115479,0.154183,0.205388,0.207134,0.202723,0.228119,0.319041,0.394824,0.40565,0.399405:-0.302268,-0.258354,-0.199763,-0.141783,-0.106175,-0.129821,-0.17333,-0.217858,-0.271662,-0.305299,-0.301991,-0.289757,-0.279856:-0.145863,-0.174202,-0.151606,-0.129604,-0.154765,-0.181792,-0.20939,-0.254139,-0.305781,-0.316282,-0.275081,-0.25612,-0.256334:0.117737,0.103902,0.063009,-0.006319,-0.057368,-0.081567,-0.085044,-0.071512,-0.053315,-0.028786,-0.02426,-0.030586,-0.034653:-0.126434,-0.182636,-0.248463,-0.291271,-0.314912,-0.326441,-0.321053,-0.293256,-0.2463,-0.20984,-0.171039,-0.160983,-0.15147:-0.309318,-0.281599,-0.275075,-0.270564,-0.273413,-0.27911,-0.284561,-0.259605,-0.208969,-0.151589,-0.145825,-0.152083,-0.154231:-0.021976,0.022922,0.055979,0.062892,0.061742,0.073817,0.085587,0.058105,0.034067,0.012779,-0.015524,-0.032676,-0.069713:0.217761,0.199635,0.175975,0.125136,0.059533,0.016095,-0.022806,-0.069273,-0.116506,-0.137857,-0.168997,-0.219253,-0.241006:8
0.809814,0.902874,0.865703,0.825638,0.773174,0.719397,0.754355,0.741003,0.53257,0.432445,0.422098,0.330714,0.305503,0.347651:-0.736811,-0.358676,-0.262172,-0.408091,-0.224724,-0.219536,-0.339892,-0.422316,-0.383949,-0.438482,-0.604684,-0.681526,-0.762307,-0.855118:0.357379,0.223355,0.219145,0.258278,0.067363,0.056431,0.190613,0.270453,0.257215,0.313756,0.494146,0.615065,0.717596,0.840326:-0.840329,-0.692539,-0.575778,-0.426607,-0.377236,-0.29434,-0.292311,-0.251248,-0.066718,0.086092,0.151165,0.201275,0.251788,0.300145:-0.091862,-0.040358,-0.096224,-0.075023,0.055727,0.086795,0.15328,0.303738,0.341945,0.373596,0.415463,0.415673,0.411543,0.383691:-0.32955,-0.43314,-0.434105,-0.314882,-0.300312,-0.294152,-0.219039,-0.197324,-0.250504,-0.29116,-0.273629,-0.286417,-0.317632,-0.321277:-0.142782,-0.002409,0.110279,0.082121,0.012885,-0.002651,-0.092489,-0.233563,-0.199565,-0.162155,-0.170432,-0.147353,-0.137609,-0.164803:0.359666,0.202873,-0.015984,-0.053986,-0.053741,-0.091836,-0.146117,-0.118347,-0.188685,-0.199494,-0.101918,-0.038949,0.005787,0.061924:-0.250893,-0.238014,-0.215208,-0.284823,-0.353265,-0.376195,-0.386957,-0.348779,-0.26884,-0.205424,-0.183274,-0.157454,-0.174188,-0.203206:-0.232357,-0.226717,-0.211019,-0.217375,-0.244815,-0.254973,-0.190613,-0.133077,-0.098243,-0.059644,-0.048254,-0.076363,-0.075093,-0.074309:0.138848,0.075503,0.073298,0.09203,0.131299,0.136358,0.196647,0.173764,0.117419,0.053026,-0.024312,-0.103607,-0.163258,-0.178844:0.127406,0.21021,0.265048,0.234023,0.162374,0.14608,0.128239,0.096599,0.022794,-0.066271,-0.130795,-0.16553,-0.169543,-0.192629:8
1.043195,1.107183,1.033089,0.952346,0.934951,1.041588,1.043972,1.09423,1.077464,0.768171,0.708934,0.816728,0.713698:-0.137942,-0.131707,-0.108233,-0.210653,-0.282929,-0.326655,-0.37308,-0.55965,-0.675208,-0.631754,-0.706914,-0.662592,-0.6325:-0.168679,-0.160827,-0.17526,-0.100065,-0.063828,-0.080358,-0.077761,0.014554,0.154265,0.319814,0.387906,0.423847,0.481474:-0.357687,-0.307073,-0.162136,-0.005604,0.144122,0.183496,0.176354,0.157367,0.246997,0.354802,0.390609,0.401459,0.414602:-0.107546,-0.048751,-0.116451,-0.194237,-0.167506,-0.119944,-0.010896,0.129103,0.146426,0.182067,0.253231,0.253743,0.258193:-0.266301,-0.203811,-0.08033,-0.019606,-0.023308,-0.069446,-0.08205,-0.044354,-0.028822,-0.131642,-0.133789,-0.169847,-0.174363:-0.066007,-0.081265,-0.009132,0.014604,-0.063806,-0.089625,-0.144431,-0.264193,-0.26586,-0.269428,-0.291285,-0.303014,-0.326191:-0.044364,-0.05641,-0.184081,-0.256438,-0.305079,-0.325042,-0.273378,-0.185645,-0.125504,-0.135856,-0.085641,-0.074525,-0.052785:0.075076,-0.020009,-0.059322,-0.108905,-0.115323,-0.124128,-0.14926,-0.158606,-0.147038,-0.03676,-0.04487,-0.069379,-0.102443:-0.32277,-0.318215,-0.4277,-0.43732,-0.39683,-0.366227,-0.330165,-0.246614,-0.198466,-0.222673,-0.203869,-0.18132,-0.173283:0.019178,0.027043,0.054202,0.086249,0.161523,0.192651,0.160352,0.067795,0.052471,0.027829,0.014705,-0.003198,-0.030164:0.221012,0.198204,0.171758,0.173946,0.168705,0.18063,0.162969,0.108075,0.02603,-0.038117,-0.099008,-0.147452,-0.20231:8
1.400301,1.356081,1.05348,0.771595,0.751878,0.855724,0.804394,0.69477,0.582342,0.565022,0.566249,0.450301:-0.680969,-0.709464,-0.52819,-0.469075,-0.501794,-0.594473,-0.686552,-0.897063,-0.915633,-0.802081,-0.762517,-0.809301:0.137273,0.070358,-0.036395,-0.116779,-0.071597,0.071412,0.165257,0.307998,0.401037,0.526742,0.645594,0.704242:-0.713564,-0.635922,-0.580361,-0.471244,-0.419469,-0.342566,-0.191666,-0.113879,-0.03105,0.034209,0.026544,0.058222:0.020424,0.015607,0.130572,0.234607,0.319036,0.398661,0.418383,0.448485,0.477507,0.533607,0.564444,0.539836:-0.239238,-0.204162,-0.261716,-0.279887,-0.262734,-0.182173,-0.119045,-0.162016,-0.207724,-0.225177,-0.238844,-0.256695:-0.287916,-0.281229,-0.251657,-0.247191,-0.272338,-0.314798,-0.366198,-0.437836,-0.487691,-0.483979,-0.444768,-0.409528:0.267153,0.17859,0.108428,0.027302,0.005088,-0.053861,-0.140672,-0.13181,-0.113005,-0.063686,0.002377,0.021737:-0.008712,-0.049412,-0.090751,-0.125609,-0.202083,-0.256303,-0.254467,-0.247224,-0.204023,-0.15782,-0.17643,-0.196466:-0.26094,-0.263133,-0.257047,-0.297557,-0.305013,-0.267082,-0.234284,-0.197131,-0.172903,-0.145768,-0.14233,-0.140717:-0.0537,-0.025765,-0.010532,-0.013029,-0.020757,-0.04701,-0.01048,-0.008319,-0.011903,-0.021092,-0.053195,-0.07938:0.154108,0.150616,0.180013,0.184977,0.188992,0.158478,0.08304,0.013839,-0.040737,-0.105947,-0.182703,-0.228411:8
1.008538,0.703943,0.647401,0.721812,0.714359,0.57136,0.519316,0.528334,0.464675,0.377436,0.348387,0.335074:-0.460474,-0.473419,-0.377264,-0.443134,-0.49442,-0.477633,-0.563755,-0.63301,-0.623342,-0.670985,-0.701195,-0.779893:0.182627,0.182347,0.136856,0.116728,0.185901,0.208032,0.250436,0.33242,0.430293,0.512397,0.564243,0.62622:-0.904271,-0.849165,-0.738342,-0.595285,-0.485637,-0.41479,-0.347746,-0.261255,-0.127747,0.031063,0.103929,0.139156:0.221828,0.297645,0.371892,0.392938,0.368872,0.403434,0.442703,0.46165,0.493828,0.511445,0.537026,0.540923:-0.31618,-0.310066,-0.310863,-0.262393,-0.194504,-0.194864,-0.220175,-0.242597,-0.258174,-0.280121,-0.310126,-0.32593:-0.275622,-0.296571,-0.282892,-0.259322,-0.222628,-0.210908,-0.249786,-0.310411,-0.346567,-0.333255,-0.327338,-0.333333:0.23303,0.188347,0.101904,0.010397,-0.04891,-0.112396,-0.115519,-0.105454,-0.088971,-0.06472,-0.061122,-0.041437:-0.215589,-0.23901,-0.23674,-0.243079,-0.320882,-0.366467,-0.383322,-0.36561,-0.304519,-0.212852,-0.187116,-0.181896:-0.243944,-0.233653,-0.252475,-0.280065,-0.272761,-0.259861,-0.242722,-0.222909,-0.187946,-0.137704,-0.127416,-0.133905:-0.154038,-0.133515,-0.11409,-0.080908,-0.041194,0.010131,0.025234,0.039817,0.029095,-0.042027,-0.098383,-0.137627:0.089599,0.097755,0.146581,0.162395,0.139571,0.114725,0.09575,0.084321,0.035098,-0.056978,-0.095779,-0.115835:8
1.278831,1.150783,0.990335,0.946077,0.787198,0.668281,0.796848,0.657507,0.596572,0.587168,0.568218:-0.530101,-0.545109,-0.585804,-0.627651,-0.622635,-0.597938,-0.843274,-0.83137,-0.818353,-0.867908,-0.974577:0.220454,0.172206,0.286383,0.348755,0.339142,0.221187,0.263676,0.360349,0.45786,0.579654,0.740376:-0.664687,-0.545743,-0.561593,-0.510309,-0.449404,-0.329639,-0.205942,-0.20887,-0.121926,0.016636,0.072594:-0.020261,0.008802,0.117495,0.188994,0.252241,0.288087,0.280652,0.359994,0.424296,0.480489,0.502243:-0.17507,-0.174162,-0.132282,-0.058119,-0.027687,-0.029749,-0.025258,-0.07359,-0.122863,-0.167374,-0.173248:-0.30157,-0.299708,-0.361818,-0.39094,-0.379477,-0.321278,-0.319782,-0.374095,-0.426903,-0.420501,-0.427696:0.171574,0.126675,0.134667,0.093329,0.053979,0.002748,-0.062703,-0.072183,-0.051494,0.008493,0.058055:-0.090087,-0.10448,-0.168742,-0.228154,-0.287343,-0.337992,-0.346759,-0.333868,-0.295865,-0.220407,-0.190253:-0.383534,-0.379432,-0.374573,-0.377212,-0.376952,-0.368447,-0.321093,-0.284617,-0.241185,-0.19109,-0.168829:-0.090321,-0.089634,-0.05333,0.006972,0.041021,0.052522,0.036441,0.044253,0.048231,0.002351,-0.038867:0.113571,0.135151,0.124595,0.126295,0.1085,0.079557,0.036307,0.014891,-0.027121,-0.103548,-0.171771:8
1.145384,1.132609,1.002064,1.030104,1.043685,1.023268,0.892337,0.850265,0.919355,0.965001,0.890664,0.727791:-0.623872,-0.645722,-0.643745,-0.771076,-0.673512,-0.666456,-0.664482,-0.769858,-0.874482,-0.774849,-0.736398,-0.845586:0.156249,0.116999,0.088471,0.211543,0.290961,0.245657,0.26724,0.326172,0.345345,0.425375,0.597575,0.647298:-0.757831,-0.748131,-0.72082,-0.760015,-0.687514,-0.564483,-0.634771,-0.540542,-0.377029,-0.286341,-0.143683,-0.038487:0.021343,0.052638,0.089704,0.144125,0.21588,0.367822,0.42433,0.407611,0.386178,0.457262,0.525325,0.527138:-0.411967,-0.398393,-0.337501,-0.231225,-0.196253,-0.203069,-0.160859,-0.156209,-0.180959,-0.245957,-0.296296,-0.311061:-0.140881,-0.1275,-0.1783,-0.298034,-0.315522,-0.317355,-0.293203,-0.279029,-0.301738,-0.352015,-0.395198,-0.376026:0.285412,0.233347,0.185229,0.206264,0.160754,0.020368,0.008596,-0.001347,-0.022296,-0.009058,0.019254,0.050633:-0.162226,-0.189798,-0.179408,-0.22499,-0.27612,-0.368104,-0.467591,-0.509503,-0.466526,-0.40831,-0.298831,-0.276523:-0.119204,-0.151482,-0.234513,-0.303281,-0.317449,-0.217817,-0.218552,-0.245642,-0.232926,-0.170637,-0.09175,-0.112711:-0.194909,-0.202577,-0.145338,-0.074048,-0.057481,0.008209,0.055464,0.089424,0.077885,0.043061,-0.037357,-0.071352:0.090366,0.133298,0.149104,0.121684,0.124578,0.13002,0.099795,0.099296,0.070798,0.010784,-0.104953,-0.161708:8
0.72322,0.650496,0.688952,0.681923,0.720418,0.760652,0.675989,0.67032,0.633021,0.60301,0.54831,0.451885,0.380327:-0.591654,-0.501598,-0.464085,-0.454946,-0.458936,-0.48775,-0.506988,-0.653404,-0.71229,-0.704188,-0.724322,-0.743143,-0.754713:0.354567,0.365943,0.376711,0.311503,0.332046,0.286269,0.267036,0.334003,0.362558,0.367194,0.399728,0.458669,0.55716:-0.760988,-0.744272,-0.756586,-0.683692,-0.671739,-0.654634,-0.64145,-0.578136,-0.494343,-0.347355,-0.239072,-0.161289,-0.07197:0.072436,0.017085,0.025754,0.14883,0.221049,0.274472,0.276269,0.291071,0.37045,0.431804,0.518561,0.535402,0.526544:-0.311098,-0.274891,-0.235441,-0.217003,-0.173753,-0.130525,-0.117821,-0.107048,-0.123359,-0.127903,-0.125642,-0.141278,-0.182259:-0.239803,-0.179855,-0.150609,-0.183069,-0.227929,-0.248634,-0.228458,-0.26422,-0.291231,-0.288904,-0.303268,-0.304005,-0.320021:0.341901,0.259293,0.200947,0.186771,0.185213,0.093885,0.00631,-0.0418,-0.055995,-0.058794,-0.033353,-0.021396,-0.01149:-0.108643,-0.148566,-0.200416,-0.251013,-0.294875,-0.309651,-0.356749,-0.39756,-0.432997,-0.432443,-0.392793,-0.359455,-0.321527:-0.234216,-0.234732,-0.237241,-0.307756,-0.348257,-0.311358,-0.258064,-0.205382,-0.191807,-0.195956,-0.198637,-0.189863,-0.166169:-0.08673,-0.108856,-0.108036,-0.097993,-0.067263,-0.052931,-0.012296,0.046122,0.088864,0.106267,0.074438,0.036466,-0.006086:0.044496,0.06989,0.08171,0.095364,0.093931,0.085273,0.064754,0.036974,0.046755,0.049994,0.007832,-0.068928,-0.13576:8
1.301832,0.95299,0.949635,0.966034,0.894882,0.870401,0.825928,0.781772,0.670686,0.525951,0.35225,0.252574:-0.508461,-0.348503,-0.289565,-0.334177,-0.43285,-0.590073,-0.730321,-0.866268,-0.976323,-0.976151,-0.883694,-0.881375:-0.065884,0.029813,0.036723,0.085321,0.171144,0.248387,0.333834,0.45477,0.612973,0.758224,0.840431,0.92887:-0.501713,-0.45975,-0.400572,-0.365117,-0.359253,-0.321684,-0.190531,-0.037587,0.055198,0.142359,0.254155,0.307709:0.123752,0.208517,0.273484,0.345876,0.391847,0.405277,0.407241,0.453079,0.503551,0.510941,0.480452,0.453427:-0.304677,-0.29616,-0.23718,-0.180765,-0.127953,-0.132421,-0.154369,-0.157781,-0.181773,-0.218829,-0.239497,-0.234936:-0.025088,-0.041796,-0.077679,-0.145035,-0.208425,-0.254501,-0.303997,-0.348618,-0.350507,-0.366069,-0.340517,-0.32631:0.091042,0.053575,-0.029118,-0.069011,-0.100911,-0.11011,-0.118653,-0.072572,0.022075,0.072839,0.074047,0.10616:-0.078845,-0.124737,-0.198525,-0.259717,-0.307572,-0.336896,-0.314994,-0.256097,-0.202563,-0.182617,-0.174358,-0.161998:-0.298993,-0.350352,-0.354673,-0.338436,-0.304851,-0.259696,-0.202204,-0.156911,-0.139536,-0.146251,-0.136107,-0.131418:-0.180198,-0.091268,-0.040279,-0.036938,-0.031655,-0.023383,0.005294,-0.006654,-0.069448,-0.100278,-0.111451,-0.109695:0.224709,0.213432,0.196657,0.17857,0.14935,0.112564,0.051367,-0.031069,-0.124456,-0.191374,-0.228159,-0.238327:8
1.197129,0.89391,0.869252,0.78293,0.638708,0.534052,0.559838,0.743078,0.774573,0.695431,0.724692:-0.682869,-0.461025,-0.397277,-0.671705,-0.831266,-0.693025,-0.574983,-0.565049,-0.513854,-0.607357,-0.787248:0.408894,0.358927,0.340346,0.290732,0.180864,0.239334,0.333732,0.368973,0.445529,0.550832,0.632302:-0.813699,-0.744037,-0.704064,-0.5762,-0.397759,-0.448926,-0.438369,-0.356692,-0.238474,-0.136059,-0.042486:0.019754,0.126377,0.210452,0.258762,0.309135,0.353862,0.39357,0.4488,0.51238,0.535828,0.518242:-0.236907,-0.242837,-0.178098,-0.123544,-0.136558,-0.153698,-0.168325,-0.18011,-0.170454,-0.240521,-0.250397:-0.334953,-0.30371,-0.30267,-0.311016,-0.245051,-0.241847,-0.248736,-0.284925,-0.286076,-0.325056,-0.3899:0.312461,0.277921,0.217504,0.103545,8.63E-4,-0.034475,-0.085135,-0.075922,-0.054175,0.014039,0.03579:-0.145452,-0.181005,-0.225467,-0.269044,-0.294947,-0.365859,-0.457815,-0.4599,-0.414063,-0.356251,-0.297195:-0.347309,-0.366989,-0.371262,-0.338088,-0.291631,-0.256012,-0.20568,-0.197569,-0.173397,-0.153144,-0.138572:-0.073475,-0.085854,-0.0723,-0.068541,-0.090109,-0.011334,0.095513,0.115862,0.090394,0.041905,-0.007215:0.109131,0.139585,0.136864,0.1053,0.090097,0.071584,0.054973,0.056034,0.008793,-0.098913,-0.185736:8
1.088272,0.905,0.824872,0.831809,0.843988,0.803638,0.99334,0.936087,0.77166,0.723292,0.624266,0.578359,0.494638,0.405741:-0.388112,-0.511557,-0.61424,-0.711117,-0.765717,-0.669438,-0.809553,-0.809736,-0.805893,-0.851898,-0.851613,-0.861646,-0.878986,-0.90939:0.246722,0.308625,0.335373,0.332288,0.288273,0.213376,0.288173,0.320668,0.378697,0.475102,0.545892,0.615643,0.703721,0.777537:-0.714119,-0.738881,-0.77204,-0.756183,-0.66498,-0.440263,-0.371423,-0.335387,-0.319013,-0.303888,-0.190303,-0.082733,-0.019105,0.031311:0.099548,0.170618,0.224015,0.238387,0.228962,0.179476,0.205407,0.297247,0.346397,0.385116,0.404231,0.41542,0.468092,0.486838:-0.349177,-0.257081,-0.209484,-0.17997,-0.16597,-0.073668,-0.043015,-0.073299,-0.090303,-0.130489,-0.194369,-0.220059,-0.215844,-0.206077:-0.269902,-0.338205,-0.380997,-0.383185,-0.33767,-0.274832,-0.24953,-0.232131,-0.238342,-0.28561,-0.3249,-0.335813,-0.319435,-0.316837:0.228311,0.275599,0.293268,0.277363,0.207617,0.044343,-0.033145,-0.066506,-0.065068,-0.040492,-0.039716,-0.012741,0.031004,0.042586:-0.195171,-0.221369,-0.254457,-0.276761,-0.286743,-0.311025,-0.389892,-0.43641,-0.477306,-0.472982,-0.412824,-0.34702,-0.29045,-0.276865:-0.280973,-0.332087,-0.370896,-0.392934,-0.363321,-0.307116,-0.249412,-0.213319,-0.227766,-0.218177,-0.176143,-0.145493,-0.107629,-0.088098:-0.018263,-0.030797,-0.025677,-0.024963,-0.030751,-0.00577,0.057463,0.080186,0.11679,0.127124,0.102116,0.064684,0.013395,-0.004995:0.065773,0.056412,0.061446,0.069372,0.070195,0.050561,0.010763,0.011906,0.012024,-0.001855,-0.040519,-0.08016,-0.134645,-0.192626:8
1.035833,0.852769,0.696713,0.585383,0.728989,0.872394,0.774456,0.761115,0.700463,0.595551,0.538333,0.482467:-0.554279,-0.620228,-0.507681,-0.352982,-0.359584,-0.533151,-0.572596,-0.707723,-0.778034,-0.830645,-0.915531,-0.93683:0.076329,0.128649,0.091526,-0.046738,-0.019043,0.119475,0.133722,0.23523,0.327923,0.425266,0.548062,0.619193:-0.698547,-0.650651,-0.554693,-0.463571,-0.388101,-0.353985,-0.266677,-0.200946,-0.131746,-0.019227,0.079172,0.134666:-0.075061,-0.029699,0.006086,0.084234,0.125446,0.161911,0.191998,0.248081,0.348991,0.413964,0.455427,0.473747:-0.259614,-0.223279,-0.242009,-0.245205,-0.168286,-0.053125,-0.057858,-0.125869,-0.191402,-0.205527,-0.220661,-0.257002:-0.170697,-0.169279,-0.12746,-0.098278,-0.116844,-0.190122,-0.201774,-0.255833,-0.324275,-0.34792,-0.353472,-0.355774:0.215351,0.202047,0.094528,-0.022985,-0.09255,-0.10769,-0.138593,-0.134397,-0.10613,-0.075651,-0.02108,0.009208:-0.088709,-0.125043,-0.167721,-0.16408,-0.199497,-0.283081,-0.325392,-0.33658,-0.322226,-0.267305,-0.230285,-0.211734:-0.290493,-0.286668,-0.286332,-0.333179,-0.358934,-0.328319,-0.289868,-0.22868,-0.190875,-0.163476,-0.148114,-0.147048:0.02325,0.030752,0.002824,0.002677,0.008447,0.031595,0.054041,0.06777,0.063906,0.033344,-0.021342,-0.078442:0.143952,0.142384,0.150098,0.18462,0.219035,0.182566,0.114529,0.05655,0.021453,-0.031569,-0.116315,-0.167998:8
1.286509,1.136576,1.130266,1.011388,0.774745,0.782781,1.036797,1.102685,0.943694,0.785259,0.579536:-0.630752,-0.598176,-0.51067,-0.52186,-0.536885,-0.61866,-0.715794,-0.736505,-0.763525,-0.798587,-0.806526:0.333444,0.293671,0.128928,0.082848,0.234366,0.349532,0.304875,0.162298,0.222788,0.34703,0.450099:-0.881951,-0.823091,-0.749273,-0.655165,-0.625283,-0.519384,-0.372391,-0.165102,-0.051735,0.095267,0.193652:0.047529,0.122685,0.208055,0.257839,0.329583,0.361137,0.398664,0.354815,0.3491,0.372733,0.452426:-0.331909,-0.331047,-0.343182,-0.316972,-0.256633,-0.126622,-0.091095,-0.156816,-0.203111,-0.244521,-0.285835:-0.36377,-0.338202,-0.283853,-0.284096,-0.311743,-0.342555,-0.339635,-0.241995,-0.250443,-0.291668,-0.280573:0.379842,0.349689,0.278337,0.193408,0.155159,0.04755,-0.04943,-0.127568,-0.156633,-0.105473,-0.008697:-0.139904,-0.168169,-0.241588,-0.269307,-0.339157,-0.369266,-0.391733,-0.403678,-0.336583,-0.260525,-0.192419:-0.324735,-0.290009,-0.276922,-0.298961,-0.30514,-0.271517,-0.225379,-0.182301,-0.176177,-0.153221,-0.134276:-0.029957,-0.056025,-0.054259,-0.037109,-0.016688,0.010962,0.034837,0.023712,0.009467,-0.017797,-0.083726:0.116385,0.091885,0.083822,0.110915,0.118004,0.061517,0.008042,-8.38E-4,-0.004547,-0.075678,-0.158205:8
1.741948,1.544978,1.178075,1.104901,1.175366,1.048246,0.827921,0.898884,0.862505,0.810356,0.812186,0.617886,0.458315,0.369384,0.228093,0.164308:-1.089897,-1.015132,-1.044635,-1.066774,-0.935729,-0.841731,-0.77788,-0.660153,-0.682142,-0.736179,-0.844705,-0.869429,-0.754925,-0.647701,-0.608714,-0.59568:0.336385,0.273879,0.405926,0.39895,0.245182,0.207537,0.216843,0.207678,0.227229,0.274925,0.384205,0.46652,0.508749,0.615978,0.760191,0.940296:-0.53992,-0.519649,-0.601026,-0.618787,-0.626437,-0.566449,-0.507184,-0.444528,-0.269706,-0.214224,-0.133107,0.007165,0.064482,0.100961,0.117237,0.161014:-0.259824,-0.196054,-0.055896,0.014057,0.155466,0.273492,0.370495,0.411172,0.388115,0.405941,0.406508,0.454453,0.521738,0.531254,0.507606,0.438483:-0.14396,-0.184103,-0.184196,-0.145242,-0.152452,-0.142913,-0.132582,-0.13318,-0.145277,-0.16145,-0.157453,-0.18756,-0.247326,-0.293132,-0.305214,-0.317365:-0.275699,-0.256316,-0.283247,-0.290229,-0.291066,-0.294295,-0.268816,-0.28295,-0.311456,-0.303959,-0.330207,-0.303392,-0.266474,-0.268175,-0.267866,-0.271381:0.170239,0.173924,0.163563,0.149018,0.144338,0.083475,0.021492,-0.022964,-0.11845,-0.147343,-0.128934,-0.097153,-0.071599,-0.042087,0.008486,0.050341:0.045522,0.004168,-0.117082,-0.180344,-0.233377,-0.251017,-0.28427,-0.273156,-0.249255,-0.272751,-0.265402,-0.209934,-0.172447,-0.158601,-0.198055,-0.19038:-0.303661,-0.317221,-0.23015,-0.272628,-0.326409,-0.336836,-0.344798,-0.336207,-0.240153,-0.190454,-0.139902,-0.115479,-0.12703,-0.152601,-0.154057,-0.178336:-0.154849,-0.154087,-0.142982,-0.124656,-0.097725,-0.083581,-0.083533,-0.063237,-0.015156,-0.006102,0.003332,-0.029964,-0.056808,-0.087695,-0.108126,-0.138555:0.091477,0.117788,0.066306,0.108719,0.160744,0.178069,0.204881,0.175364,0.085356,0.046544,-0.032486,-0.07866,-0.09558,-0.111229,-0.150919,-0.15913:8
1.015136,1.084295,1.180333,1.10993,1.138213,1.186606,1.154679,1.04896,0.990652,0.946371,0.956233,1.040298,1.051319,0.767053,0.705231:-0.452552,-0.459063,-0.533553,-0.431749,-0.385955,-0.381829,-0.39806,-0.725061,-0.947135,-0.972427,-1.031046,-1.093629,-1.055364,-1.133085,-1.19379:0.162934,0.052699,0.060416,0.042414,0.07832,0.156986,0.091685,0.205269,0.403876,0.517087,0.546362,0.59586,0.700428,0.896369,0.926319:-0.678842,-0.696264,-0.780705,-0.760594,-0.725735,-0.678205,-0.582504,-0.507438,-0.495625,-0.381214,-0.160888,-0.03289,0.080839,0.040234,0.103562:-0.035747,0.035551,0.118676,0.191501,0.25056,0.324262,0.391504,0.36704,0.388554,0.428725,0.454571,0.469272,0.423615,0.428109,0.410409:-0.398506,-0.406792,-0.372515,-0.346449,-0.308579,-0.238777,-0.15765,-0.09676,-0.076349,-0.089176,-0.105282,-0.125672,-0.198769,-0.190951,-0.204525:-0.260206,-0.249018,-0.281265,-0.285066,-0.306395,-0.330374,-0.331538,-0.362414,-0.465088,-0.51638,-0.488839,-0.451975,-0.424288,-0.496864,-0.467372:0.265931,0.251324,0.248369,0.204627,0.224513,0.21402,0.097586,0.0276,0.030482,0.024578,0.034274,0.074886,0.072525,0.142458,0.175767:-0.030885,-0.072075,-0.131084,-0.148619,-0.225942,-0.298731,-0.336749,-0.366884,-0.38582,-0.373212,-0.314372,-0.275354,-0.249115,-0.216971,-0.188293:-0.28769,-0.318567,-0.315059,-0.321731,-0.319581,-0.330231,-0.309771,-0.283328,-0.261334,-0.245626,-0.224955,-0.225392,-0.195925,-0.221586,-0.2098:-0.117034,-0.105583,-0.113259,-0.116296,-0.067956,-0.018417,-0.031506,-0.019281,0.084778,0.148709,0.121925,0.057008,-0.00437,0.009762,-0.013459:0.100838,0.120079,0.14446,0.158281,0.131227,0.107914,0.040334,-0.006761,-0.047813,-0.05198,-0.095607,-0.157356,-0.194175,-0.262493,-0.28133:8
0.77782,0.788819,0.856088,1.005783,0.857316,0.926051,1.0401,0.973785,0.930519,0.879035,0.862332,0.885086,0.845752,0.710901,0.714814:-0.439318,-0.523184,-0.543295,-0.554484,-0.504605,-0.490726,-0.531297,-0.528739,-0.58109,-0.655872,-0.748666,-0.769999,-0.815642,-0.767577,-0.697406:0.378312,0.395766,0.40385,0.37242,0.223507,0.234262,0.29823,0.3381,0.307407,0.452832,0.564946,0.61984,0.721289,0.722215,0.736107:-0.857837,-0.808756,-0.72949,-0.696607,-0.56499,-0.535442,-0.516755,-0.426513,-0.190585,-0.018661,0.102878,0.21714,0.111162,0.089193,0.135411:-0.145079,-0.141411,-0.079216,-0.029258,0.054667,0.147689,0.258597,0.330542,0.283987,0.250306,0.368856,0.34158,0.362162,0.43785,0.463614:-0.377665,-0.327682,-0.289689,-0.223472,-0.237974,-0.237248,-0.248863,-0.218682,-0.188045,-0.209172,-0.297057,-0.28416,-0.237984,-0.239232,-0.308735:-0.028605,-0.049996,-0.099721,-0.097388,-0.038403,-0.093809,-0.178996,-0.191385,-0.144612,-0.134675,-0.231112,-0.205358,-0.26107,-0.283235,-0.264222:0.305232,0.308274,0.281843,0.19078,0.082489,0.057465,-0.0113,-0.081625,-0.111608,-0.074665,-0.035707,-0.0992,-0.107428,-0.076893,-0.029165:-0.271148,-0.336108,-0.358108,-0.361655,-0.379071,-0.401144,-0.442892,-0.476754,-0.437431,-0.417218,-0.356361,-0.327447,-0.254907,-0.203108,-0.156953:-0.187227,-0.19799,-0.264302,-0.272213,-0.28357,-0.272928,-0.164863,-0.132667,-0.157898,-0.115272,-0.027538,-0.002995,0.032001,0.033818,-0.001536:0.08785,0.112511,0.092408,0.054134,-0.003662,0.028129,0.075435,0.110032,0.122356,0.082185,-0.016078,-0.087584,-0.169224,-0.205811,-0.221149:0.065036,0.01451,0.067109,0.126472,0.172738,0.166239,0.129058,0.118599,0.075007,-0.045497,-0.188999,-0.21404,-0.244563,-0.23406,-0.165262:8
1.543065,1.522998,1.377161,1.149043,0.95682,0.829515,0.781076,0.83187,0.87688,0.744956,0.639882:-0.220852,-0.239076,-0.383738,-0.548851,-0.626957,-0.495029,-0.403808,-0.573052,-0.709424,-0.647509,-0.59829:0.158096,0.217523,0.305007,0.403991,0.40738,0.430707,0.670934,1.002348,1.128259,1.138771,1.110077:-0.81355,-0.610869,-0.39234,-0.405923,-0.363336,-0.210643,-0.14756,-0.114377,-0.0029,0.068163,0.040002:0.039291,0.00492,0.033842,0.256119,0.428106,0.503988,0.488304,0.417083,0.382131,0.438455,0.466031:-0.392243,-0.363043,-0.242134,-0.208001,-0.224351,-0.251265,-0.236466,-0.281513,-0.282177,-0.23822,-0.189878:-0.134869,-0.057105,-0.131963,-0.29768,-0.394319,-0.403219,-0.3522,-0.392337,-0.426073,-0.373511,-0.350386:0.171497,0.091901,0.024909,-0.017816,-0.041173,-0.093764,-0.084733,0.088636,0.112074,0.086947,0.092041:-0.311396,-0.354364,-0.375569,-0.410768,-0.403543,-0.357255,-0.354732,-0.383794,-0.337416,-0.311335,-0.278098:-0.289859,-0.293779,-0.240765,-0.190271,-0.152542,-0.110165,-0.064747,-0.126044,-0.158659,-0.129712,-0.089918:-0.075337,-0.037905,0.05628,0.078815,0.077189,0.076436,0.078512,0.054994,0.005249,-0.027879,-0.029905:0.196859,0.234841,0.124692,0.01455,-0.034466,-0.063674,-0.138665,-0.232552,-0.252302,-0.250971,-0.261133:8
1.672509,1.471528,1.522864,1.439534,1.293571,1.248402,1.114168,1.035338,1.158925,1.149858,1.125969,1.119387,1.182012,1.237289,1.070175,0.999682,0.942112:-1.015112,-1.128871,-1.028958,-1.000657,-0.977092,-0.797922,-0.625006,-0.700529,-0.743873,-0.832154,-0.839626,-0.892008,-1.033384,-1.175726,-1.139875,-1.152245,-1.196599:0.48968,0.481715,0.460071,0.405375,0.313004,0.219,0.198183,0.264183,0.274269,0.244419,0.23294,0.29789,0.358791,0.463889,0.54265,0.615389,0.664398:-0.72431,-0.714956,-0.73617,-0.740478,-0.702283,-0.727412,-0.750069,-0.664379,-0.5615,-0.355784,-0.218647,-0.17695,-0.059406,0.069798,0.143173,0.183679,0.237311:-0.273833,-0.235929,-0.216729,-0.16866,-0.070996,0.039309,0.093637,0.150923,0.228398,0.261485,0.278157,0.315081,0.344435,0.356489,0.367512,0.361255,0.376117:-0.08272,-0.086739,-0.121147,-0.148207,-0.16917,-0.232347,-0.277423,-0.198898,-0.1137,-0.079807,-0.09442,-0.141244,-0.151212,-0.149549,-0.155386,-0.181007,-0.202457:-0.374673,-0.38389,-0.361223,-0.333198,-0.330959,-0.30337,-0.215636,-0.284941,-0.318863,-0.284229,-0.261613,-0.287901,-0.315795,-0.315164,-0.307881,-0.284538,-0.294567:0.18989,0.205815,0.219502,0.197626,0.18031,0.179147,0.158729,0.136905,0.063759,-0.034461,-0.11531,-0.143331,-0.137215,-0.09285,-0.085369,-0.069722,-0.048218:0.078787,0.062529,0.026862,-0.02308,-0.04204,-0.095719,-0.20836,-0.232221,-0.260369,-0.288736,-0.305573,-0.293282,-0.297779,-0.267228,-0.221945,-0.211884,-0.212839:-0.306677,-0.31597,-0.305988,-0.252854,-0.247611,-0.239241,-0.210207,-0.253445,-0.274702,-0.25033,-0.212384,-0.179107,-0.130137,-0.104404,-0.104129,-0.077928,-0.066857:-0.102555,-0.092653,-0.088439,-0.080958,-0.104065,-0.126806,-0.085081,-0.03432,-0.028763,-0.039827,-0.035172,-0.042881,-0.049041,-0.04755,-0.063338,-0.099894,-0.125025:0.105053,0.111201,0.125976,0.116677,0.105512,0.12735,0.138927,0.115337,0.097374,0.06,0.034291,0.041556,-0.015941,-0.080624,-0.098823,-0.153566,-0.214415:8
0.808124,0.879928,0.856067,0.778212,0.72245,0.707324,0.668734,0.651696,0.689292,0.607141,0.499599,0.431718,0.395912:-0.559465,-0.52967,-0.48546,-0.486554,-0.523075,-0.576306,-0.584536,-0.524613,-0.588312,-0.634185,-0.590056,-0.517098,-0.49261:0.255194,0.161068,0.171496,0.214255,0.253005,0.293947,0.346875,0.399121,0.448528,0.51835,0.600711,0.574766,0.591506:-0.824944,-0.744091,-0.69466,-0.626017,-0.555583,-0.49796,-0.413623,-0.259299,-0.111017,-0.043587,0.017586,0.091511,0.127147:0.177264,0.26481,0.339945,0.385922,0.412914,0.435098,0.468103,0.511579,0.556156,0.56815,0.584267,0.608423,0.601615:-0.387695,-0.372073,-0.340326,-0.280678,-0.236879,-0.218496,-0.231687,-0.263361,-0.257881,-0.271849,-0.344538,-0.388463,-0.381147:-0.210543,-0.185417,-0.179335,-0.17105,-0.153013,-0.160055,-0.197915,-0.202975,-0.196407,-0.220026,-0.256748,-0.254885,-0.254354:0.316256,0.239519,0.186315,0.088534,0.00578,-0.036937,-0.072932,-0.102844,-0.065552,-0.025845,-0.005656,-0.018124,-0.037007:-0.288111,-0.306524,-0.337939,-0.389528,-0.469332,-0.528878,-0.523282,-0.465828,-0.385865,-0.317735,-0.273229,-0.234318,-0.197252:-0.276554,-0.274601,-0.278295,-0.238352,-0.203006,-0.176243,-0.131255,-0.082912,-0.06186,-0.074822,-0.072862,-0.078114,-0.069635:-0.08475,-0.116341,-0.12118,-0.093152,-0.033352,0.033331,0.070746,0.077504,0.03103,-0.044054,-0.105132,-0.13447,-0.1556:0.061395,0.088102,0.098747,0.066476,0.035068,0.015446,-0.003044,-0.011352,-0.056992,-0.121701,-0.161327,-0.171,-0.181482:8
0.762565,0.743003,0.749449,0.718413,0.648483,0.628044,0.617714,0.642754,0.599736,0.486527,0.326063,0.229309,0.241106,0.159686:-0.280218,-0.180322,-0.140829,-0.128782,-0.11986,-0.188423,-0.29249,-0.384108,-0.424609,-0.46103,-0.485905,-0.525866,-0.611435,-0.587575:-0.083535,-0.122759,-0.157412,-0.166296,-0.185897,-0.151375,-0.105488,0.055776,0.239682,0.309245,0.373815,0.494538,0.67966,0.719846:-0.467963,-0.438889,-0.393405,-0.376621,-0.317967,-0.306911,-0.2856,-0.284886,-0.230313,-0.101756,0.030863,0.156645,0.197183,0.291338:-0.078846,-0.028833,0.024534,0.096095,0.131438,0.212921,0.313609,0.371836,0.394498,0.446341,0.472809,0.455846,0.462032,0.436834:-0.358635,-0.362169,-0.341256,-0.304074,-0.285356,-0.273646,-0.276907,-0.260409,-0.253738,-0.246686,-0.289201,-0.351946,-0.391097,-0.405568:-0.028063,-0.029215,-0.031361,-0.051605,-0.055436,-0.089976,-0.119235,-0.146599,-0.114424,-0.099926,-0.132798,-0.169944,-0.208244,-0.17602:0.198109,0.15213,0.099175,0.040869,-0.005498,-0.048981,-0.109195,-0.135868,-0.16006,-0.157038,-0.125063,-0.091128,-0.019266,-0.016213:-0.124118,-0.163915,-0.18897,-0.20539,-0.229405,-0.263651,-0.294469,-0.333253,-0.360626,-0.322716,-0.263246,-0.212975,-0.221488,-0.189279:-0.251351,-0.268777,-0.303611,-0.333524,-0.369993,-0.316783,-0.234474,-0.154136,-0.063553,-0.072332,-0.100541,-0.101224,-0.077303,-0.073838:0.104082,0.12957,0.115811,0.104519,0.104349,0.064041,0.027392,0.024173,0.053451,0.044183,0.00943,-0.05304,-0.114702,-0.14371:0.08959,0.093657,0.108291,0.1224,0.135923,0.137124,0.134816,0.106442,0.023876,-0.035726,-0.125036,-0.174741,-0.193865,-0.194639:8
0.945494,0.955062,0.926432,0.851136,0.809449,0.815483,0.850114,0.79829,0.798101,0.81787,0.645559,0.532016,0.633144:-0.531296,-0.530123,-0.54694,-0.506503,-0.521981,-0.589675,-0.683431,-0.702209,-0.737587,-0.86831,-0.812865,-0.822829,-1.047234:0.253981,0.212947,0.187978,0.177143,0.157749,0.166339,0.178,0.225502,0.288736,0.405223,0.446922,0.5219,0.750513:-0.923811,-0.872717,-0.777113,-0.657828,-0.545971,-0.514764,-0.469773,-0.355883,-0.148193,0.043639,0.165133,0.283215,0.283156:0.141285,0.191458,0.238491,0.311338,0.402446,0.495727,0.558559,0.603587,0.626317,0.554539,0.523603,0.474412,0.438401:-0.396021,-0.37042,-0.341076,-0.342645,-0.339071,-0.306515,-0.229939,-0.186973,-0.167741,-0.166597,-0.231857,-0.254056,-0.222609:-0.311171,-0.311275,-0.310667,-0.285266,-0.27263,-0.301842,-0.370964,-0.42085,-0.420094,-0.405785,-0.375915,-0.352174,-0.362836:0.400765,0.342087,0.272551,0.196096,0.119413,0.058638,-0.024328,-0.068898,-0.085307,-0.07123,-0.042353,-0.013829,0.054216:-0.15134,-0.18286,-0.206367,-0.247759,-0.324926,-0.399219,-0.403987,-0.354647,-0.274268,-0.216805,-0.185097,-0.172002,-0.167271:-0.222874,-0.238774,-0.274743,-0.300868,-0.281808,-0.236803,-0.187726,-0.154706,-0.10162,-0.098164,-0.130166,-0.144306,-0.118124:-0.053355,-0.076286,-0.099758,-0.108268,-0.071231,-0.029122,0.001202,-0.018237,-0.051954,-0.079141,-0.088367,-0.083452,-0.095781:0.061392,0.066842,0.096824,0.152913,0.148636,0.109659,0.08639,0.056807,-0.040807,-0.141236,-0.17264,-0.186756,-0.228216:8
1.100164,1.15771,1.167371,0.963491,1.024418,1.219944,1.207015,1.029412,0.868908,0.764459,0.696831,0.669305,0.616877:-0.529642,-0.562926,-0.473456,-0.359739,-0.510282,-0.534998,-0.552869,-0.47567,-0.514591,-0.655749,-0.753551,-0.843878,-0.917966:0.129557,0.102592,0.045865,-7.28E-4,-0.123257,-0.17893,-0.017765,0.07001,0.174277,0.390896,0.599962,0.761135,0.935298:-0.718313,-0.701806,-0.652908,-0.600539,-0.328408,-0.179318,-0.302573,-0.249718,-0.155966,-0.072575,0.002789,0.092761,0.206908:0.128432,0.137881,0.153816,0.248829,0.335798,0.338305,0.489011,0.62369,0.705181,0.746532,0.675873,0.577407,0.461858:-0.407571,-0.358781,-0.316897,-0.31424,-0.358336,-0.23615,-0.204545,-0.193343,-0.187908,-0.168675,-0.161809,-0.169933,-0.201077:-0.242482,-0.255085,-0.216548,-0.134908,-0.125914,-0.201332,-0.294204,-0.362489,-0.379289,-0.409297,-0.42148,-0.389013,-0.333974:0.175336,0.168287,0.106193,0.003783,-0.021706,-0.018334,-0.040388,-0.096132,-0.091065,-0.013815,0.022156,0.033381,0.067893:-0.035351,-0.058474,-0.084008,-0.177732,-0.234618,-0.269449,-0.301017,-0.285515,-0.247266,-0.184108,-0.162761,-0.174823,-0.187939:-0.237823,-0.281872,-0.321637,-0.214861,-0.215862,-0.295096,-0.253251,-0.201434,-0.150792,-0.108621,-0.098579,-0.092523,-0.11975:-0.18806,-0.168073,-0.150566,-0.18332,-0.21639,-0.13967,-0.08364,-0.050439,-0.067372,-0.096224,-0.112793,-0.110418,-0.108283:0.196792,0.183533,0.192321,0.157112,0.156552,0.117933,0.086523,0.0467,6.05E-4,-0.088617,-0.176758,-0.222484,-0.220187:8
0.889082,0.734023,0.680597,0.70418,0.676484,0.708648,0.768042,0.729502,0.676929,0.630692,0.548025,0.410218,0.327928,0.261602,0.210223:-0.405309,-0.407203,-0.431699,-0.414031,-0.449316,-0.561408,-0.672852,-0.772324,-0.845723,-0.881972,-0.908739,-0.916467,-0.903607,-0.891629,-0.899351:0.060706,0.065547,0.023925,-0.075958,-0.076714,0.040491,0.12804,0.215,0.32457,0.452314,0.615397,0.766327,0.869472,0.94514,0.999603:-0.640625,-0.562755,-0.518921,-0.468447,-0.448661,-0.445772,-0.382456,-0.340589,-0.255222,-0.125678,-0.001853,0.075519,0.138201,0.184213,0.206284:0.02662,0.068123,0.111143,0.195779,0.289849,0.323062,0.354378,0.362363,0.407674,0.450756,0.480119,0.472529,0.438189,0.411272,0.406545:-0.427189,-0.413194,-0.381007,-0.365873,-0.317023,-0.246203,-0.179323,-0.131978,-0.130748,-0.158574,-0.208743,-0.257755,-0.294219,-0.302212,-0.274797:-0.050245,-0.058524,-0.038973,-0.022029,-0.071498,-0.169441,-0.243812,-0.26125,-0.308157,-0.336937,-0.354851,-0.352947,-0.34263,-0.335768,-0.339736:0.207557,0.173409,0.106274,0.050675,0.028839,0.011281,-0.060068,-0.114169,-0.10707,-0.073797,-0.0213,0.029444,0.061437,0.08206,0.09961:-0.103371,-0.110159,-0.140122,-0.204792,-0.23103,-0.251644,-0.288277,-0.351796,-0.347453,-0.299044,-0.252803,-0.237657,-0.228524,-0.217252,-0.200277:-0.207676,-0.273077,-0.300866,-0.313853,-0.33897,-0.31835,-0.247722,-0.171893,-0.137333,-0.102647,-0.094823,-0.111216,-0.12116,-0.11877,-0.105866:-0.113607,-0.124098,-0.121782,-0.137453,-0.128208,-0.096279,-0.030467,0.038169,0.056548,0.026103,-0.025033,-0.072945,-0.103171,-0.111089,-0.09772:0.139452,0.187588,0.213682,0.205266,0.188242,0.181052,0.138253,0.072925,0.02152,-0.053817,-0.123197,-0.169549,-0.201449,-0.227559,-0.252835:8
0.814615,0.831144,0.849239,0.791114,0.773274,0.851581,0.904727,0.79653,0.737643,0.719181,0.605364,0.503109,0.130173,-0.058017,-0.017176,-0.044632:-0.32859,-0.325272,-0.316777,-0.24068,-0.156911,-0.120852,-0.270646,-0.498605,-0.566883,-0.494159,-0.349271,-0.388738,-0.460991,-0.547498,-0.344947,-0.310806:0.04004,0.036495,0.093042,0.145468,0.149189,-0.040594,-0.141638,0.009474,0.11707,0.175848,0.165519,0.257908,0.442893,0.576626,0.414398,0.406909:-0.92045,-0.900892,-0.872516,-0.792954,-0.680168,-0.49664,-0.277998,-0.240964,-0.260419,-0.108132,0.062158,0.235133,0.350751,0.36823,0.464853,0.523604:0.169675,0.183603,0.211867,0.259603,0.322588,0.335529,0.305201,0.339878,0.448738,0.537679,0.553384,0.502646,0.44035,0.491837,0.453789,0.360026:-0.639835,-0.611199,-0.564243,-0.52549,-0.48615,-0.481542,-0.360802,-0.262898,-0.275715,-0.305214,-0.319316,-0.359816,-0.363758,-0.375713,-0.357995,-0.294152:-0.084702,-0.09877,-0.136005,-0.140102,-0.146629,-0.124506,-0.169726,-0.253033,-0.322814,-0.383412,-0.340526,-0.313057,-0.308007,-0.29758,-0.196926,-0.13916:0.350854,0.325263,0.301666,0.26565,0.209257,0.095091,0.032335,0.00512,-0.027605,-0.063142,-0.058719,-0.029208,-0.010698,0.062962,0.066186,0.035549:-0.328575,-0.339904,-0.356515,-0.373396,-0.377973,-0.388789,-0.418879,-0.446981,-0.43865,-0.400693,-0.365393,-0.292976,-0.20593,-0.220306,-0.143934,-0.023281:-0.149245,-0.156162,-0.167336,-0.17674,-0.174164,-0.202404,-0.242019,-0.253732,-0.190593,-0.11059,-0.113043,-0.101032,-0.141504,-0.0986,-0.112417,-0.202108:-0.048217,-0.037119,-0.019186,-0.005638,-3.3E-4,-0.00134,-0.028616,-0.010104,0.008411,0.068683,0.085187,-0.004614,-0.041691,-0.060001,-0.017338,-0.011481:0.130224,0.153033,0.178045,0.202649,0.207534,0.205402,0.191604,0.148895,0.108925,0.051862,-0.021214,-0.148957,-0.223481,-0.256287,-0.285128,-0.277757:8
0.810487,0.900697,0.874437,0.851114,0.863155,0.786376,0.794883,0.848966,0.79359,0.612545,0.457155,0.279692,0.13621:-0.675222,-0.731138,-0.75258,-0.738134,-0.770397,-0.804914,-0.88944,-0.972847,-0.999716,-1.004929,-1.055168,-1.085969,-1.050542:0.300021,0.297667,0.307114,0.308793,0.335839,0.354487,0.369395,0.441121,0.505965,0.651701,0.810352,0.951711,1.062105:-0.847597,-0.810441,-0.774694,-0.683801,-0.58871,-0.501211,-0.419196,-0.327858,-0.204288,-0.062958,0.036068,0.10545,0.135973:0.054461,0.046334,0.082666,0.149817,0.230747,0.341551,0.418365,0.434161,0.456813,0.497232,0.480364,0.44647,0.437621:-0.310508,-0.297757,-0.287378,-0.24423,-0.201384,-0.18646,-0.17054,-0.122104,-0.119093,-0.172333,-0.207984,-0.225338,-0.263539:-0.310633,-0.279447,-0.263275,-0.272062,-0.302587,-0.339805,-0.404259,-0.468871,-0.479514,-0.446034,-0.411533,-0.386163,-0.357375:0.349624,0.334164,0.31167,0.24831,0.177824,0.107098,0.040431,-0.035217,-0.050631,0.013058,0.06333,0.104829,0.171013:-0.158105,-0.20238,-0.272671,-0.310303,-0.332928,-0.377582,-0.398711,-0.367466,-0.304223,-0.250422,-0.236606,-0.213053,-0.194492:-0.332077,-0.353066,-0.352018,-0.357772,-0.360007,-0.324327,-0.283019,-0.227292,-0.163629,-0.106591,-0.101537,-0.11514,-0.117297:-0.040899,-0.03791,-0.006941,0.010461,0.003272,0.016139,0.062644,0.07744,0.049103,0.001201,-0.037402,-0.08173,-0.102047:0.090883,0.127891,0.141434,0.146344,0.145362,0.118263,0.091972,0.069466,-0.018425,-0.166601,-0.234277,-0.249798,-0.256044:8
0.791108,0.902897,1.056277,0.821248,0.626206,0.673893,0.753527,0.648997,0.445161,0.276889,0.176101,0.074998:-0.589607,-0.56065,-0.514867,-0.466933,-0.606291,-0.782454,-0.916945,-1.043881,-1.103197,-1.116581,-1.129939,-1.105171:0.188684,0.202993,0.175102,0.291751,0.349189,0.360615,0.426441,0.594167,0.736629,0.851233,0.946553,1.002476:-0.732215,-0.611544,-0.558669,-0.584621,-0.51155,-0.431759,-0.298778,-0.162714,-0.078393,-0.009684,0.032819,0.06121:0.105912,0.124722,0.227423,0.398558,0.454804,0.447749,0.433057,0.465819,0.498906,0.519364,0.500438,0.500349:-0.320133,-0.260599,-0.266411,-0.251416,-0.186408,-0.14888,-0.132493,-0.137142,-0.176444,-0.208847,-0.212605,-0.236834:-0.234055,-0.25048,-0.229451,-0.264337,-0.309167,-0.328965,-0.331214,-0.333868,-0.375757,-0.413448,-0.412172,-0.373045:0.297652,0.265798,0.21215,0.139652,0.004137,-0.038576,-0.04099,0.010741,0.057484,0.080051,0.103704,0.152749:-0.241213,-0.278998,-0.32398,-0.384726,-0.436228,-0.452286,-0.429457,-0.352617,-0.308996,-0.279464,-0.247346,-0.227763:-0.381222,-0.433079,-0.422948,-0.336788,-0.240131,-0.224233,-0.195375,-0.15584,-0.151295,-0.132475,-0.11272,-0.093483:-0.02879,-7.88E-4,-0.039482,-0.075671,0.011801,0.061003,0.073254,0.008029,-0.031377,-0.050041,-0.069516,-0.082658:0.09707,0.123763,0.127816,0.091359,0.052598,0.055807,0.012363,-0.091463,-0.172608,-0.232818,-0.267206,-0.273359:8
1.149366,1.1365,1.07148,1.051197,1.023712,1.062887,1.046912,0.960843,0.95322,0.941739,0.679694,0.596487,0.751146:-0.056636,-0.056364,-0.17509,-0.273869,-0.307662,-0.41261,-0.506128,-0.591659,-0.753012,-0.889853,-0.80566,-0.83881,-1.096105:-0.14613,-0.253163,-0.154079,-0.019875,-0.005157,0.03504,0.068095,0.142567,0.273367,0.447796,0.469138,0.584845,0.891842:-0.598742,-0.464744,-0.448062,-0.450651,-0.433125,-0.385727,-0.301875,-0.22171,-0.112633,0.004542,0.189642,0.323838,0.249013:0.079884,0.073621,0.098429,0.182797,0.251789,0.294801,0.300678,0.327255,0.365735,0.409804,0.44312,0.435775,0.42813:-0.473031,-0.37823,-0.303395,-0.287355,-0.253875,-0.215252,-0.18529,-0.182252,-0.183251,-0.189317,-0.216722,-0.241245,-0.248914:-0.056133,0.014382,-0.050914,-0.13546,-0.149788,-0.182055,-0.213332,-0.243155,-0.277926,-0.306227,-0.296585,-0.316632,-0.375997:0.223633,0.114617,0.082431,0.069886,0.031022,-0.038914,-0.109877,-0.138007,-0.125626,-0.096113,-0.071089,-0.026587,0.081862:-0.058412,-0.058358,-0.127649,-0.223961,-0.256298,-0.272014,-0.286392,-0.302802,-0.29669,-0.249117,-0.187914,-0.158631,-0.156119:-0.245961,-0.275261,-0.276268,-0.247234,-0.25959,-0.233827,-0.195772,-0.173734,-0.131554,-0.083081,-0.098768,-0.114278,-0.108475:-0.082232,-0.117029,-0.120618,-0.124345,-0.13305,-0.123605,-0.067615,0.007814,0.011728,-0.035786,-0.069601,-0.092839,-0.128784:0.077999,0.082805,0.07013,0.081436,0.090762,0.105453,0.111038,0.107369,0.065206,-0.021611,-0.107609,-0.148892,-0.176873:8
0.799913,0.692246,0.734323,0.917923,0.979249,0.851729,0.660186,0.649446,0.597846,0.603485,0.512721,0.379586,0.254416:-0.513378,-0.256092,-0.257816,-0.408838,-0.519406,-0.408562,-0.385521,-0.40721,-0.480475,-0.763254,-0.82144,-0.836354,-0.809705:0.319412,0.268958,0.218265,0.157199,0.162978,0.08247,0.283412,0.325374,0.44215,0.541866,0.574542,0.683596,0.82037:-0.723659,-0.635706,-0.581784,-0.516395,-0.497113,-0.460107,-0.426384,-0.356315,-0.233331,-0.042883,0.10355,0.171012,0.179591:0.053022,0.136691,0.187145,0.163783,0.168457,0.233964,0.230816,0.369244,0.438981,0.472098,0.504068,0.535822,0.541206:-0.281851,-0.269069,-0.240586,-0.201266,-0.143098,-0.236266,-0.276867,-0.234185,-0.181293,-0.215585,-0.27794,-0.338795,-0.360623:-0.101358,-2.78E-4,-0.009104,-0.106931,-0.184155,-0.176494,-0.160061,-0.22273,-0.269799,-0.298715,-0.271993,-0.272687,-0.287088:0.249496,0.146467,0.056535,9.8E-5,-0.038659,-0.103029,-0.143437,-0.186691,-0.109323,-0.055641,-0.059534,0.006508,0.087438:-0.185781,-0.185891,-0.236503,-0.206774,-0.213954,-0.153511,-0.238667,-0.331758,-0.367815,-0.230187,-0.158363,-0.164432,-0.161213:-0.278938,-0.299294,-0.272934,-0.309344,-0.315256,-0.294428,-0.208318,-0.18149,-0.165538,-0.108612,-0.098473,-0.09294,-0.103778:-0.077339,-0.106962,-0.049331,-0.057267,-0.065345,-0.071246,-0.02297,0.068572,0.096479,-0.057245,-0.167466,-0.203234,-0.182673:0.204833,0.226595,0.19578,0.236157,0.22684,0.237335,0.165533,0.14658,0.063289,-0.063399,-0.084415,-0.122918,-0.161931:8
0.890403,0.779937,0.837071,1.014346,1.091854,0.886841,0.642978,0.595278,0.673194,0.756703,0.737374,0.666365,0.608967,0.517676:-0.394014,-0.432351,-0.475997,-0.530622,-0.575174,-0.63996,-0.649437,-0.737017,-0.880893,-0.974209,-1.010952,-1.075421,-1.095054,-1.063974:0.459053,0.419948,0.393988,0.397578,0.248843,0.296623,0.349677,0.367444,0.39299,0.437328,0.530956,0.632212,0.710222,0.782018:-0.86918,-0.840905,-0.819946,-0.781662,-0.633949,-0.612696,-0.527035,-0.445596,-0.404284,-0.265735,-0.109952,-0.019714,0.076568,0.147483:-0.011869,0.03791,0.058918,0.01569,-0.006297,0.153162,0.269673,0.392505,0.462557,0.485688,0.52186,0.553634,0.563918,0.552687:-0.422456,-0.424833,-0.408603,-0.342136,-0.263302,-0.240997,-0.225627,-0.186972,-0.131513,-0.112806,-0.109429,-0.128679,-0.18659,-0.229596:-0.153104,-0.156616,-0.146375,-0.132554,-0.125239,-0.172209,-0.218527,-0.289586,-0.380875,-0.471507,-0.530916,-0.524349,-0.493073,-0.454756:0.358579,0.357339,0.347976,0.308968,0.196813,0.181853,0.130175,0.06901,0.029486,-0.036089,-0.0465,0.016233,0.076221,0.103977:-0.222273,-0.240947,-0.285629,-0.31297,-0.267994,-0.303707,-0.352886,-0.408546,-0.403348,-0.315615,-0.22414,-0.181111,-0.166618,-0.175376:-0.24168,-0.286834,-0.326041,-0.357594,-0.392466,-0.373923,-0.371088,-0.345992,-0.311479,-0.24545,-0.184383,-0.170578,-0.172233,-0.169556:-0.073314,-0.083125,-0.071734,-0.047517,-0.047555,-0.092066,-0.062668,-0.011272,0.005144,0.002518,0.002457,-0.027235,-0.065121,-0.072535:0.090457,0.126515,0.15086,0.156234,0.163727,0.152816,0.136733,0.116907,0.083417,0.040806,-0.033051,-0.11728,-0.168284,-0.203651:8
0.932799,0.817452,0.677211,0.606508,0.820578,0.913794,0.922389,0.865279,0.748962,0.438339,0.292958,0.40696:-0.505127,-0.536583,-0.56012,-0.511266,-0.6172,-0.623364,-0.60086,-0.63749,-0.657967,-0.529335,-0.565159,-0.677707:0.241088,0.280777,0.36505,0.379372,0.292814,0.243879,0.315902,0.476098,0.552004,0.538732,0.613072,0.711026:-0.790894,-0.725442,-0.683644,-0.662933,-0.484232,-0.330538,-0.226997,-0.041099,0.037497,0.129324,0.236918,0.32166:0.052681,0.087161,0.125619,0.172284,0.214595,0.261369,0.326175,0.366192,0.436192,0.540209,0.492372,0.411807:-0.385324,-0.348724,-0.285746,-0.222334,-0.209393,-0.198309,-0.173058,-0.132646,-0.196937,-0.319069,-0.329073,-0.28491:-0.194213,-0.198945,-0.175195,-0.130287,-0.16273,-0.219722,-0.27071,-0.314008,-0.309416,-0.258783,-0.229798,-0.216446:0.352137,0.312342,0.246883,0.149354,0.050543,-0.101329,-0.166719,-0.14673,-0.099485,-0.09557,-0.085882,-0.066503:-0.223408,-0.277551,-0.370701,-0.450935,-0.446763,-0.405976,-0.388009,-0.297752,-0.189059,-0.156015,-0.13783,-0.124896:-0.255845,-0.294014,-0.315351,-0.301567,-0.301043,-0.240613,-0.196762,-0.157505,-0.137579,-0.106553,-0.111641,-0.085651:0.049864,0.055392,0.080885,0.093165,0.104302,0.115405,0.117206,0.076803,-0.039682,-0.139055,-0.153564,-0.158153:0.109702,0.12976,0.148684,0.133795,0.126695,0.126576,0.11434,0.036896,-0.069629,-0.114079,-0.133235,-0.15164:8
1.587478,1.679569,1.331602,1.462285,1.467636,1.574815,1.476161,1.403297,1.300103,1.282121,1.169659,1.080475,0.973774,0.848628,0.788728:0.011602,-0.142875,-0.048136,-0.204371,-0.245205,-0.348581,-0.320052,-0.32291,-0.369755,-0.376954,-0.408841,-0.474655,-0.470474,-0.357273,-0.38165:0.176796,0.313967,0.233187,0.373592,0.387966,0.396193,0.336608,0.313235,0.252676,0.260369,0.2465,0.226442,0.187824,0.119735,0.133488:-0.315726,-0.318033,-0.240975,-0.416051,-0.442905,-0.427667,-0.36668,-0.381335,-0.385023,-0.373183,-0.332946,-0.30744,-0.253102,-0.165421,-0.099593:-0.154902,-0.255113,-0.238177,-0.107457,-0.010334,-1.98E-4,-0.01397,0.011078,0.130716,0.236708,0.384294,0.510794,0.611771,0.667473,0.714338:-0.569685,-0.475282,-0.433666,-0.467747,-0.463511,-0.424688,-0.36136,-0.297815,-0.296697,-0.243603,-0.197019,-0.167563,-0.138231,-0.153162,-0.176042:0.169223,0.178781,0.133098,0.133423,0.096882,0.110201,0.152605,0.162625,0.14392,0.086595,-0.022976,-0.051023,-0.05538,-0.056774,-0.102111:0.240834,0.159286,0.230347,0.285819,0.309248,0.279089,0.217648,0.145556,0.128265,0.090954,0.108011,0.125622,0.052887,-0.03089,-0.038891:-0.021412,0.075382,0.045999,-0.054318,-0.14885,-0.163834,-0.133934,-0.141623,-0.183113,-0.13985,-0.180277,-0.240654,-0.263741,-0.223193,-0.24482:-0.070292,-0.113565,-0.169915,-0.140146,-0.120891,-0.1386,-0.223079,-0.249956,-0.218815,-0.25417,-0.219422,-0.17962,-0.148164,-0.168155,-0.119669:-0.108172,-0.152426,-0.086713,-0.170786,-0.1567,-0.19483,-0.190502,-0.201123,-0.243618,-0.271035,-0.222582,-0.198841,-0.158342,-0.159386,-0.154014:0.103413,0.169051,0.106553,0.14753,0.14731,0.171832,0.202978,0.222055,0.211397,0.265452,0.217592,0.175881,0.155212,0.157311,0.096:9
1.070652,1.035943,1.091492,1.11189,1.213034,1.280598,1.143496,0.946307,0.966981,1.00332,0.942648,0.859233:-0.234098,-0.176617,-0.206593,-0.28279,-0.350239,-0.469304,-0.436544,-0.333988,-0.419414,-0.544575,-0.515916,-0.368628:0.20448,0.168884,0.130166,0.166333,0.176224,0.187795,0.218296,0.241425,0.334966,0.423619,0.454117,0.360321:-0.594403,-0.575882,-0.4551,-0.364138,-0.283377,-0.126195,-0.088896,-0.111921,-0.064246,0.052941,0.079167,0.180511:0.235258,0.339103,0.384499,0.423579,0.470095,0.532502,0.611924,0.698784,0.657314,0.55325,0.582195,0.609073:-0.373531,-0.362097,-0.299649,-0.294489,-0.266292,-0.235075,-0.233496,-0.257234,-0.250704,-0.235945,-0.318071,-0.363115:0.04649,0.032797,-0.007658,-0.015609,-0.028925,-0.088132,-0.13814,-0.182895,-0.195468,-0.164346,-0.179623,-0.172784:0.294488,0.239701,0.146421,0.110418,0.063385,-0.013911,-0.073566,-0.071955,-0.082788,-0.135561,-0.119408,-0.160148:-0.348198,-0.398107,-0.370163,-0.375459,-0.404648,-0.3796,-0.334519,-0.332041,-0.344086,-0.353929,-0.367066,-0.339934:-0.186167,-0.141508,-0.116341,-0.131276,-0.110509,-0.070176,-0.054211,-0.052984,-0.039971,-0.011599,0.010892,0.03727:0.02037,0.034318,0.037246,0.045917,0.015787,-0.033693,-0.060546,-0.047274,-0.050519,-0.067859,-0.080218,-0.113843:0.190797,0.173035,0.180825,0.207346,0.189642,0.150689,0.132991,0.072982,0.023907,-0.022938,-0.056985,-0.09504:9
1.401514,1.590423,1.488125,1.449159,1.398464,1.371858,1.343797,1.185762,1.177183,1.099979,1.087492,1.222471,1.12307,1.080687,1.009036,0.866103,0.844162:0.030547,-0.096465,-0.185069,-0.296557,-0.340871,-0.353779,-0.331632,-0.316703,-0.290595,-0.294131,-0.335351,-0.407576,-0.41628,-0.393211,-0.440856,-0.416587,-0.331813:-0.182475,-0.304224,-0.282393,-0.111391,-0.064273,-0.088984,0.002138,-0.064961,-0.099926,-0.057134,0.120007,0.159585,0.205962,0.26219,0.388689,0.417218,0.364227:-0.41653,-0.322832,-0.302198,-0.382739,-0.348648,-0.241995,-0.328259,-0.260342,-0.151066,-0.115178,-0.161185,-0.075264,-0.094873,-0.10808,-0.082673,0.005608,0.064731:0.086833,0.145702,0.229961,0.329198,0.354867,0.407294,0.564326,0.630722,0.63418,0.651264,0.674986,0.642157,0.668194,0.670798,0.655708,0.652257,0.624191:-0.417837,-0.404014,-0.319463,-0.326847,-0.329335,-0.373262,-0.304811,-0.26948,-0.317229,-0.277628,-0.190283,-0.117834,-0.154763,-0.16863,-0.19431,-0.225587,-0.280831:0.01578,0.070917,-0.028886,-0.070473,-0.053597,-0.019728,-0.07675,-0.093655,-0.056654,-0.08907,-0.246663,-0.321413,-0.255215,-0.224619,-0.235499,-0.251125,-0.22871:0.321125,0.247299,0.20584,0.145345,0.098195,0.072268,0.044874,0.013054,-0.016178,-0.059465,0.015826,0.034321,0.044247,0.078237,0.099291,0.085284,0.092261:-0.213435,-0.249825,-0.223738,-0.282616,-0.31373,-0.272697,-0.237237,-0.243237,-0.267268,-0.184246,-0.186428,-0.234111,-0.286142,-0.292811,-0.291732,-0.264531,-0.262896:-0.131668,-0.079625,-0.086678,-0.073825,-0.054012,-0.028767,-0.055986,-0.045097,-0.03012,-0.029781,-0.066051,-0.069284,-0.015723,-0.036122,-0.045928,-0.058437,-0.059661:-0.06763,-0.12334,-0.072636,0.026614,0.046192,-0.032562,-0.046766,-0.03141,-0.043479,-0.033993,0.075828,0.130035,0.107721,0.083184,0.084425,0.111324,0.095524:0.145677,0.179506,0.146313,0.189864,0.234851,0.260888,0.273876,0.213796,0.220612,0.157611,0.044852,-0.007658,-0.00761,-0.016586,-0.049967,-0.088633,-0.115812:9
1.142008,1.11914,1.125247,1.257379,1.255726,1.243948,1.269245,1.321269,1.316827,1.427034,1.436278,1.2361,1.129221,1.09742,1.018153,0.975818,0.930464:-0.070057,-0.043878,-0.138189,-0.165337,-0.146677,-0.106532,-0.143555,-0.315994,-0.262429,-0.440648,-0.550717,-0.404873,-0.395481,-0.453635,-0.566604,-0.619504,-0.555352:0.226367,0.219106,0.260782,0.109506,0.058492,0.026272,0.006087,0.113233,-0.053768,0.094745,0.227921,0.162675,0.074231,0.13921,0.294811,0.346043,0.307944:-0.46327,-0.467641,-0.390039,-0.350333,-0.355789,-0.336991,-0.288258,-0.292147,-0.138403,-0.221535,-0.291414,-0.169899,-0.082441,-0.003705,0.049533,0.076936,0.18062:-0.10223,-0.062028,-0.027208,0.052186,0.080955,0.13309,0.180612,0.180309,0.26592,0.381314,0.414114,0.529082,0.640859,0.58969,0.543389,0.551292,0.584962:-0.481276,-0.470764,-0.488738,-0.499554,-0.459142,-0.458338,-0.420542,-0.290579,-0.263765,-0.220907,-0.147212,-0.248244,-0.23717,-0.217148,-0.177851,-0.165889,-0.211319:0.271051,0.273746,0.234383,0.21101,0.214789,0.252358,0.305019,0.269082,0.195528,0.117492,0.106324,0.074555,0.017922,0.018338,9.11E-4,0.008597,-0.033545:0.296442,0.276665,0.242393,0.216786,0.194176,0.187157,0.16429,0.049052,-0.035115,0.002059,0.025804,0.019478,-0.020542,-0.068553,-0.081911,-0.126514,-0.171167:-0.190625,-0.209353,-0.24927,-0.237006,-0.248562,-0.274024,-0.256959,-0.162603,-0.142484,-0.213149,-0.206734,-0.25058,-0.163507,-0.191209,-0.237886,-0.182735,-0.117872:-0.017245,-0.02586,-0.029896,-0.046132,-0.083342,-0.130799,-0.168817,-0.17531,-0.152872,-0.056918,-0.047993,0.010648,-0.007378,-0.03572,-0.043329,-0.052047,-0.035105:-0.084358,-0.081434,-0.040784,-0.077661,-0.059467,-0.049415,-0.077012,-0.135152,-0.09056,-0.121318,-0.145286,-0.06618,-0.092598,-0.038231,-0.008925,-0.049566,-0.090425:0.062703,0.090795,0.165326,0.20093,0.228463,0.276239,0.30163,0.33601,0.30012,0.292133,0.321329,0.265221,0.226729,0.246126,0.23249,0.229365,0.145204:9
1.2543,1.29435,1.21004,1.226763,1.127746,1.092457,1.138951,1.122253,1.016003,0.920008,0.963346,0.973761,0.876964,0.747514,0.65405,0.598581,0.591365,0.536538,0.503008,0.619478:-0.061214,-0.034288,-0.018559,-0.084338,-0.043165,-0.125153,-0.208736,-0.220958,-0.231472,-0.183865,-0.264441,-0.36261,-0.430906,-0.357821,-0.231511,-0.278668,-0.325787,-0.242182,-0.24313,-0.309874:0.161361,0.107561,0.040763,0.037864,-0.021545,-0.018817,0.029102,0.091099,0.029555,-0.068604,-0.024332,-0.020527,0.07117,0.099663,0.022823,-0.00141,0.006991,0.053232,0.071851,0.113437:-0.465982,-0.507057,-0.477219,-0.464557,-0.432011,-0.34577,-0.237525,-0.231745,-0.16521,-0.128268,-0.11919,0.008483,0.026244,-0.027054,0.090096,0.226182,0.23911,0.149464,0.150763,0.202338:-0.123012,-0.071167,-0.053602,-0.028215,0.014158,0.064984,0.089221,0.123268,0.142933,0.142028,0.227071,0.320924,0.366411,0.451217,0.48941,0.488982,0.495674,0.525185,0.540304,0.58833:-0.52262,-0.531736,-0.529756,-0.494312,-0.472694,-0.475446,-0.445927,-0.411601,-0.404442,-0.388253,-0.373169,-0.338729,-0.3238,-0.347789,-0.370111,-0.352604,-0.31318,-0.293337,-0.32436,-0.30997:0.239847,0.262988,0.23887,0.225562,0.255621,0.25562,0.24854,0.239122,0.216655,0.217586,0.19624,0.144154,0.126906,0.093819,0.073845,0.052962,0.050034,0.027061,0.033906,0.017176:0.375368,0.379501,0.349802,0.268991,0.232985,0.16005,0.073448,0.039645,-0.003322,0.009362,-0.003125,-0.072931,-0.094255,-0.105392,-0.161402,-0.177879,-0.185375,-0.199441,-0.185105,-0.172378:-0.188827,-0.243108,-0.26467,-0.27435,-0.265145,-0.223999,-0.240092,-0.274192,-0.222598,-0.237579,-0.300015,-0.329463,-0.369399,-0.365453,-0.324382,-0.312942,-0.306563,-0.258926,-0.281533,-0.277756:0.062661,0.01088,-0.02235,0.012516,-0.020944,-0.020034,-0.022216,-0.051866,-0.076332,-0.100459,-0.083143,-0.060753,-0.05653,-0.039501,-0.029169,-0.040382,-0.061434,-0.06971,-0.05612,-0.034305:-0.053099,-0.039216,-0.028606,-0.031849,-0.045078,-0.065419,-0.025651,0.030243,0.025394,-6.06E-4,0.017935,0.050576,0.046051,0.035882,0.019311,0.025921,0.020935,0.019024,0.043123,0.025248:0.072673,0.119862,0.144276,0.163106,0.21386,0.283526,0.324676,0.334598,0.324672,0.303973,0.297248,0.299064,0.284424,0.288232,0.25369,0.241997,0.219471,0.182585,0.189984,0.190005:9
1.216869,1.199041,1.153688,1.128125,1.092165,1.12982,1.088643,0.994173,0.938432,1.005422,1.127695,1.185485,1.226156,1.037873,0.957088,0.963308,0.945433,0.901836:-0.20787,-0.331275,-0.403568,-0.461098,-0.426387,-0.517971,-0.550319,-0.517984,-0.450145,-0.546954,-0.703083,-0.752828,-0.773874,-0.635696,-0.606916,-0.697906,-0.726048,-0.67964:-0.062392,0.008722,0.046696,0.048101,0.002575,0.019036,0.026524,0.061503,-0.053748,0.005567,0.168632,0.252451,0.326914,0.324273,0.362974,0.470315,0.497252,0.505169:-0.352132,-0.364934,-0.391671,-0.404384,-0.35041,-0.346278,-0.312467,-0.207551,-0.079976,-0.051926,-0.015921,0.026177,0.01879,0.063998,0.058132,-0.006271,0.03702,0.075909:-0.314502,-0.17233,-0.086907,-0.015053,0.069774,0.076879,0.117342,0.226771,0.293526,0.320668,0.317471,0.311477,0.30086,0.330914,0.386632,0.419042,0.419486,0.449437:-0.231424,-0.207854,-0.214901,-0.168837,-0.166728,-0.104386,-0.071499,-0.120055,-0.145185,-0.040805,0.054222,0.048193,0.012289,-0.024246,-0.037304,0.010057,0.015808,-5.2E-5:-0.094339,-0.076254,-0.118371,-0.168993,-0.210199,-0.230041,-0.245326,-0.289956,-0.261318,-0.277979,-0.329284,-0.326981,-0.324748,-0.333699,-0.335117,-0.363429,-0.335104,-0.315246:0.294203,0.263389,0.230417,0.199709,0.167893,0.156041,0.135748,0.092647,0.050778,0.078301,0.074754,0.052604,0.030851,-0.005914,-0.024832,-0.013004,0.018252,0.02379:-0.12275,-0.097955,-0.10939,-0.17216,-0.174606,-0.154536,-0.170665,-0.214787,-0.233583,-0.257917,-0.268712,-0.293303,-0.330384,-0.337461,-0.303888,-0.244062,-0.244475,-0.24944:-0.235771,-0.251239,-0.228599,-0.23376,-0.234073,-0.268136,-0.265371,-0.165303,-0.117273,-0.180074,-0.241338,-0.25421,-0.282562,-0.213129,-0.150912,-0.157836,-0.173774,-0.155445:0.159737,0.119464,0.162791,0.210433,0.230148,0.193311,0.205061,0.28169,0.289177,0.267559,0.27451,0.282536,0.28184,0.273852,0.245461,0.217642,0.228272,0.237562:0.190133,0.207657,0.210723,0.214801,0.245937,0.23408,0.224187,0.200765,0.169309,0.146608,0.119907,0.08497,0.062129,0.001385,-0.045593,-0.05914,-0.067061,-0.081428:9
1.347925,1.253195,1.352092,1.45776,1.389103,1.432712,1.405312,1.321872,1.284493,1.216718,1.210849,1.237287,1.293659,1.417021,1.198564,1.10167:-0.24042,-0.085413,-0.114956,-0.18265,-0.151529,-0.2144,-0.45845,-0.472943,-0.501016,-0.630031,-0.641732,-0.690598,-0.750846,-0.897061,-0.834645,-0.825263:0.390879,0.155462,-0.047696,-0.080084,-0.128164,-0.042935,0.127307,0.197019,0.180326,0.23378,0.323882,0.318712,0.313281,0.4094,0.45486,0.584433:-0.48826,-0.460008,-0.396871,-0.358975,-0.242798,-0.26942,-0.34926,-0.412666,-0.370347,-0.321689,-0.357594,-0.275811,-0.131322,-0.056726,-0.027532,-0.136385:-0.442739,-0.341014,-0.188593,-0.138531,-0.169873,-0.055649,0.015404,0.127912,0.266263,0.337227,0.365168,0.422675,0.431907,0.398555,0.465208,0.572189:-0.290382,-0.34671,-0.275687,-0.060459,-0.03986,-0.106271,-0.074354,-0.147556,-0.222506,-0.22176,-0.185516,-0.16945,-0.146344,-0.080872,-0.062168,-0.082276:-0.097503,-0.040376,-0.061445,-0.089444,0.071596,0.001382,-0.04589,-0.049771,-0.0691,-0.058796,-0.074899,-0.15535,-0.224386,-0.302728,-0.335411,-0.364806:0.248112,0.218416,0.190228,0.131343,0.208305,0.197184,0.114062,0.127134,0.176344,0.172374,0.117463,0.014304,-0.031477,-0.037997,-0.008657,0.066319:-0.001994,-0.017911,-0.087317,-0.025532,-0.022411,-0.164272,-0.273363,-0.3311,-0.366995,-0.389269,-0.403489,-0.373535,-0.356818,-0.291064,-0.221571,-0.254491:-0.171499,-0.179635,-0.124567,-0.188186,-0.307789,-0.235827,-0.161305,-0.130597,-0.094366,-0.083411,-0.080585,-0.031777,-0.060167,-0.084411,-0.067112,-0.056775:0.142574,0.100232,0.067031,0.094608,0.097446,0.173108,0.247236,0.221079,0.198259,0.154091,0.119329,0.104727,0.121419,0.150334,0.160542,0.144139:0.108213,0.126363,0.117006,0.182736,0.20162,0.2286,0.221064,0.226534,0.201499,0.190055,0.160457,0.099483,0.065967,0.021833,-0.036328,-0.070263:9
1.60102,1.735717,1.621477,1.552038,1.553485,1.723606,1.494759,1.373784,1.364154,1.195591,1.076688,1.016938:-0.132294,-0.300989,-0.223292,-0.17066,-0.272853,-0.677411,-0.665371,-0.66109,-0.618557,-0.57675,-0.478711,-0.503196:0.11915,0.209325,0.14482,0.058857,0.011261,0.157708,0.19392,0.224116,0.209713,0.282412,0.243601,0.36446:-0.55427,-0.608285,-0.596831,-0.600178,-0.423308,-0.218956,-0.26676,-0.270007,-0.063243,-0.055452,0.048098,0.006974:-0.04461,0.011589,0.120236,0.308588,0.319982,0.295996,0.441752,0.523379,0.560604,0.572304,0.60005,0.64637:-0.413543,-0.421883,-0.394266,-0.324164,-0.249596,-0.175273,-0.191513,-0.182528,-0.208641,-0.220677,-0.263777,-0.222481:0.049132,0.031025,0.009391,-0.060883,-0.108448,-0.151646,-0.169167,-0.191238,-0.20796,-0.208999,-0.14405,-0.166508:0.303086,0.292036,0.256134,0.161818,0.118924,0.066225,0.061235,0.047052,-0.041233,-0.048926,-0.075504,-0.086246:-0.192454,-0.326892,-0.386982,-0.328299,-0.309876,-0.266538,-0.317854,-0.367333,-0.380295,-0.314366,-0.317146,-0.260246:-0.193496,-0.163121,-0.161956,-0.115301,-0.120267,-0.103341,-0.072752,-0.058332,-0.003248,-0.033882,0.017155,0.022375:-0.023547,-0.02677,0.017917,-0.037068,0.018893,0.019061,0.01639,0.03742,0.023036,-0.053277,-0.059897,-0.026586:0.144058,0.16526,0.181179,0.209425,0.172469,0.140515,0.161475,0.12154,0.045388,0.077682,0.066383,0.066215:9
1.579517,1.470623,1.24332,1.160084,1.34013,1.545529,1.43116,1.50593,1.448989,1.293192,1.296936,1.198807,1.011733,1.084662,1.306617:-0.150031,-0.201098,-0.242608,-0.233865,-0.250253,-0.452116,-0.464186,-0.45089,-0.446076,-0.502138,-0.593655,-0.592085,-0.460767,-0.524911,-0.677065:-0.007689,-0.074954,-0.089654,-0.078057,-0.106679,-0.010457,-0.043657,-0.097915,-0.116597,-0.006388,0.115091,0.122787,0.079732,0.159336,0.300954:-0.480479,-0.466529,-0.462804,-0.473329,-0.500399,-0.567097,-0.520117,-0.420379,-0.331764,-0.329926,-0.365893,-0.299481,-0.144954,-0.09355,-0.078663:-0.25901,-0.283368,-0.23729,-0.182021,-0.098663,-0.045362,0.021689,0.02978,0.08375,0.261993,0.402928,0.456523,0.475651,0.500103,0.510987:-0.210892,-0.153808,-0.12886,-0.141139,-0.206614,-0.187856,-0.247239,-0.255898,-0.20444,-0.219979,-0.167296,-0.115315,-0.103378,-0.084785,-0.084695:-0.080261,-0.038586,-0.033694,-0.048477,-0.08325,-0.156305,-0.133436,-0.144948,-0.20405,-0.22052,-0.229994,-0.225974,-0.246027,-0.308476,-0.355739:0.248281,0.166199,0.158702,0.151126,0.178016,0.146321,0.113339,0.126062,0.103378,0.064987,0.059913,0.045996,0.026745,0.040075,0.043023:0.00229,0.041037,0.037562,4.21E-4,-0.092938,-0.096667,-0.158849,-0.220735,-0.222795,-0.201751,-0.207715,-0.225484,-0.2641,-0.260442,-0.22056:-0.202123,-0.249206,-0.270682,-0.250276,-0.2239,-0.27196,-0.261645,-0.256812,-0.244737,-0.193561,-0.144475,-0.164672,-0.199188,-0.192228,-0.141727:0.063248,0.051541,0.053026,0.056283,0.046626,0.049916,0.076111,0.130208,0.191655,0.19814,0.152382,0.145561,0.172426,0.172141,0.136395:0.080306,0.146327,0.150177,0.141508,0.116555,0.179494,0.228726,0.231179,0.231062,0.258465,0.263044,0.224553,0.132669,0.038049,-0.030931:9
1.166344,1.320299,1.53131,1.548629,1.556029,1.316629,1.003198,1.088663,1.424088,1.424212,1.465492,1.392085,1.203254,1.327757,1.357406,1.185587,1.088864,1.249696,1.328229:-0.144428,-0.213391,-0.373285,-0.396191,-0.390141,-0.262739,-0.268116,-0.251958,-0.391241,-0.432832,-0.399487,-0.36169,-0.282633,-0.348194,-0.380444,-0.380477,-0.335451,-0.453747,-0.548512:0.408938,0.386707,0.496241,0.477849,0.294038,0.141541,0.038499,0.144544,0.171702,0.110448,0.124889,0.111803,0.087795,0.167854,0.235532,0.262344,0.239028,0.32041,0.51533:-0.620263,-0.592262,-0.612888,-0.617668,-0.560712,-0.59994,-0.572951,-0.511587,-0.557379,-0.636897,-0.450025,-0.25519,-0.18526,-0.045626,0.026347,0.116462,0.265445,0.262517,0.230431:-0.154973,-0.135521,-0.121545,-0.052831,0.001664,0.156274,0.420916,0.434004,0.36137,0.40086,0.466214,0.540194,0.589417,0.626738,0.645521,0.666202,0.630355,0.621117,0.60615:-0.361136,-0.304609,-0.320364,-0.357715,-0.36447,-0.423471,-0.465236,-0.410102,-0.28751,-0.280695,-0.251619,-0.266943,-0.244913,-0.209423,-0.225398,-0.258605,-0.282007,-0.26556,-0.26851:-0.104019,-0.114501,-0.104159,-0.025104,0.005371,-0.035363,-0.009558,-0.029967,-0.122196,-0.150151,-0.150921,-0.169311,-0.170299,-0.141657,-0.036249,-0.061853,-0.069133,-0.090409,-0.13782:0.394993,0.397888,0.445916,0.441121,0.432781,0.419981,0.398443,0.38519,0.356417,0.33975,0.259516,0.159591,0.125872,0.044383,-0.034317,-0.048911,-0.056038,-0.018305,0.004236:-0.084782,-0.022343,-0.090492,-0.173501,-0.199421,-0.207072,-0.272924,-0.302707,-0.288584,-0.301618,-0.317235,-0.335623,-0.322634,-0.308391,-0.364025,-0.313227,-0.256406,-0.316788,-0.345052:-0.169695,-0.225579,-0.212666,-0.141302,-0.124014,-0.165127,-0.124046,-0.155488,-0.230504,-0.235086,-0.210136,-0.131969,-0.109061,-0.035407,0.042573,0.031451,-0.025465,-0.01895,0.005531:0.094705,0.081001,0.085114,0.023031,-0.018587,-0.092758,-0.079743,-0.047965,-0.017823,-0.049996,-0.026803,0.024286,0.063609,0.037414,-0.001229,-0.057301,-0.079348,-0.015831,0.004772:0.052833,0.10256,0.09928,0.101457,0.050309,0.064709,0.089132,0.108226,0.126475,0.14002,0.17915,0.191009,0.163116,0.143674,0.143301,0.118032,0.088009,0.029571,-0.028727:9
1.68245,1.585062,1.483944,1.464892,1.391221,1.339611,1.248651,1.194466,1.139731,1.052896,1.046543,1.165703,1.069178:-0.312225,-0.311948,-0.340305,-0.350029,-0.295751,-0.378544,-0.370652,-0.355751,-0.365524,-0.433394,-0.435776,-0.425015,-0.485369:0.225249,0.215031,0.201969,0.239557,0.214269,0.230921,0.175279,0.132172,0.115952,0.138963,0.155,0.106848,0.248118:-0.75454,-0.758523,-0.732554,-0.740707,-0.663765,-0.610265,-0.578938,-0.518287,-0.389271,-0.273215,-0.18203,0.010344,-0.01872:-0.003071,0.10335,0.133469,0.181411,0.271053,0.326068,0.395665,0.48162,0.47279,0.464468,0.486376,0.496937,0.551988:-0.295031,-0.247686,-0.251783,-0.286721,-0.31722,-0.275757,-0.267609,-0.277414,-0.264275,-0.21922,-0.204724,-0.261589,-0.280615:-0.088903,-0.106854,-0.07081,-0.084332,-0.085571,-0.127852,-0.141886,-0.141027,-0.121006,-0.086043,-0.056884,-0.048233,-0.115524:0.492238,0.486612,0.489074,0.462579,0.386947,0.337577,0.282014,0.208066,0.165398,0.125773,0.085707,0.001193,0.004992:-0.109586,-0.125784,-0.167474,-0.220658,-0.221925,-0.244496,-0.259558,-0.296637,-0.325905,-0.336595,-0.33132,-0.297648,-0.314235:-0.18602,-0.22471,-0.267416,-0.270353,-0.207851,-0.174608,-0.146616,-0.102732,-0.143792,-0.132643,-0.089247,0.00288,0.009504:0.035048,0.014352,0.022328,0.028439,0.014301,0.03387,0.019024,0.022671,0.062095,0.062852,0.056196,0.035535,0.06955:-0.009465,-3.8E-5,0.040176,0.115239,0.190003,0.208484,0.210872,0.23969,0.250308,0.210865,0.162557,0.116278,0.082177:9
1.516098,1.659279,1.424975,1.385072,1.318859,1.335149,1.36467,1.317647,1.306274,1.22092,1.16779,1.058361,0.989689,0.94142,0.922534,0.902862:-0.234427,-0.30194,-0.225557,-0.281918,-0.259744,-0.434709,-0.536909,-0.583573,-0.714883,-0.76205,-0.819771,-0.789354,-0.782713,-0.786808,-0.816348,-0.844496:-0.141608,-0.059518,-0.140608,-0.133551,-0.196978,-0.124223,-0.062246,0.013549,0.092649,0.131807,0.21887,0.243017,0.294108,0.363879,0.414013,0.440911:-0.479843,-0.556808,-0.447379,-0.441657,-0.40132,-0.328368,-0.343855,-0.387238,-0.328339,-0.248975,-0.201347,-0.111442,-0.108429,-0.083762,-0.050642,0.06904:-0.283094,-0.213941,-0.198288,-0.124778,-0.053211,8.64E-4,0.101043,0.239171,0.293036,0.327449,0.384568,0.42927,0.505219,0.522123,0.529368,0.537926:-0.351136,-0.383263,-0.331361,-0.314429,-0.307909,-0.263003,-0.26904,-0.313957,-0.332363,-0.318002,-0.27334,-0.231043,-0.161393,-0.104336,-0.13977,-0.193958:-0.1187,-0.088973,-0.101607,-0.120909,-0.094455,-0.09548,-0.12505,-0.143947,-0.149831,-0.177476,-0.205809,-0.138409,-0.184933,-0.192442,-0.161171,-0.145767:0.345022,0.416675,0.389326,0.369725,0.317779,0.278319,0.236044,0.175869,0.099335,0.049762,0.039097,-0.028381,-0.091251,-0.128937,-0.10875,-0.082839:-0.019124,-0.122038,-0.163209,-0.193259,-0.23539,-0.302697,-0.35021,-0.411927,-0.427856,-0.391935,-0.379114,-0.399013,-0.380457,-0.378603,-0.368104,-0.374238:-0.151522,-0.189069,-0.154216,-0.184129,-0.209159,-0.207712,-0.224693,-0.182768,-0.139146,-0.109842,-0.09044,-0.042503,0.007997,0.027109,0.047509,0.037377:0.018627,0.065578,0.043365,0.034729,0.007736,0.023676,0.044107,0.030389,-0.002349,-0.020505,0.002864,0.018372,0.018147,-0.006074,-0.028695,-0.020583:0.021717,0.010017,0.01498,0.025966,0.074527,0.071685,0.083569,0.12151,0.161699,0.160602,0.133376,0.111029,0.03547,-0.03352,-0.047282,-0.061689:9
1.298623,1.320662,1.312305,1.247773,1.312982,1.329031,1.264911,1.186673,1.191323,1.190901,1.133756,1.093756,1.059246,0.997742,0.982148,1.0139:-0.093577,-0.123676,-0.275645,-0.198975,-0.195953,-0.317154,-0.411571,-0.339629,-0.399064,-0.490613,-0.526169,-0.564383,-0.660646,-0.716539,-0.7778,-0.855031:0.246081,0.133945,0.108986,0.092868,0.103205,0.174355,0.178294,0.116509,0.107092,0.135813,0.144443,0.14198,0.182973,0.227063,0.27589,0.348937:-0.562873,-0.516631,-0.499249,-0.468356,-0.414294,-0.44892,-0.402976,-0.371627,-0.32826,-0.299807,-0.24923,-0.155704,-0.108995,-0.069769,-0.006651,0.055115:-0.031341,0.086802,0.119401,0.091704,0.078399,0.155369,0.187623,0.26946,0.298884,0.30493,0.330094,0.349479,0.410996,0.464662,0.48688,0.485704:-0.469653,-0.492165,-0.445204,-0.452321,-0.445177,-0.377437,-0.323081,-0.344134,-0.30836,-0.248885,-0.224658,-0.263338,-0.243237,-0.217518,-0.193326,-0.15959:0.15772,0.085223,0.09771,0.162272,0.130621,0.064058,0.053624,0.044764,0.049402,0.027459,0.031605,0.068819,0.0122,-0.011169,-6.63E-4,0.004322:0.297848,0.275805,0.205908,0.184614,0.140975,0.188686,0.100127,0.078783,0.09334,0.096328,0.045496,-0.004141,-0.033949,-0.045125,-0.073358,-0.125559:-0.300381,-0.274288,-0.328881,-0.332068,-0.269329,-0.346954,-0.371685,-0.336515,-0.394749,-0.417143,-0.407367,-0.44839,-0.46783,-0.454549,-0.449452,-0.447676:-0.029248,-0.080638,-0.093994,-0.090865,-0.101195,-0.114416,-0.079914,-0.098525,-0.127968,-0.170001,-0.168694,-0.129768,-0.062235,-0.053945,-0.045854,-0.006643:-0.037173,-0.089913,-0.106894,-0.088802,-0.070784,-0.037109,0.003743,-0.010319,0.023501,0.037676,-0.002303,-0.025807,-0.017856,-0.027358,-0.057,-0.098539:0.097859,0.167869,0.189522,0.195051,0.224346,0.19341,0.190332,0.221302,0.218101,0.212519,0.215882,0.192578,0.116107,0.105647,0.105154,0.063514:9
1.198665,1.106367,1.15558,1.473832,1.572541,1.365423,1.370297,1.422905,1.268508,1.259466,1.299608,1.293918,1.302017,1.179287,1.194785,1.115406:0.26265,0.006996,-0.104552,-0.123614,-0.093382,0.057255,0.049907,-0.186764,-0.180771,-0.262647,-0.331232,-0.41308,-0.533852,-0.568773,-0.676972,-0.700807:-0.09373,-0.022313,-0.120965,-0.221338,-0.219394,-0.244456,-0.153188,-0.05257,-0.162768,-0.168685,-0.086938,0.018437,0.11744,0.191286,0.382532,0.43921:-0.309535,-0.247472,-0.271655,-0.355634,-0.365813,-0.319595,-0.321018,-0.324603,-0.265402,-0.177714,-0.148427,-0.129281,-0.10802,-0.048048,-0.048204,0.024124:-0.390325,-0.215833,-0.168898,-0.159163,-0.07213,0.023068,0.008573,0.114744,0.232802,0.288893,0.346996,0.399585,0.462149,0.511518,0.537253,0.556281:-0.339776,-0.321305,-0.331264,-0.351465,-0.35345,-0.347744,-0.295764,-0.214298,-0.242393,-0.250456,-0.259676,-0.256506,-0.267608,-0.24209,-0.202399,-0.221388:-0.124892,-0.176739,-0.180175,-0.181129,-0.202929,-0.219948,-0.182151,-0.188205,-0.244895,-0.253401,-0.217961,-0.18297,-0.167724,-0.174334,-0.215548,-0.184891:0.242109,0.269423,0.27828,0.241399,0.290335,0.273856,0.219081,0.190284,0.174744,0.135038,0.069099,-0.004372,-0.017017,0.023949,0.047926,0.006458:0.063698,0.038023,-0.01395,-0.116692,-0.176812,-0.173948,-0.276078,-0.359697,-0.322625,-0.330942,-0.373246,-0.375332,-0.354216,-0.347012,-0.366087,-0.34986:-0.201202,-0.139567,-0.212984,-0.189338,-0.191762,-0.232281,-0.171714,-0.135052,-0.174638,-0.118496,-0.068419,-0.017282,0.006353,3.78E-4,-0.006486,0.020927:0.033669,-0.062685,-0.125936,-0.097593,-0.085608,-0.086191,-0.02318,0.029416,-0.005564,-0.009554,0.021338,0.028318,0.01339,0.038991,0.071244,0.021111:0.054264,0.07068,0.052327,0.026843,0.03252,0.069701,0.064657,0.025766,0.095284,0.112705,0.11547,0.119298,0.126285,0.072726,-0.007317,-0.002249:9
1.547365,1.535704,1.466194,1.439294,1.466419,1.246421,1.229557,1.045168,0.977306,0.832982,0.770457,0.791902:-0.51478,-0.604935,-0.583783,-0.595624,-0.715353,-0.655112,-0.630581,-0.523729,-0.573875,-0.498226,-0.488004,-0.561904:-0.113296,-0.057987,-0.021205,0.010529,0.110918,0.106777,0.197257,0.183131,0.197559,0.171789,0.179936,0.24214:-0.200651,-0.28698,-0.327369,-0.199398,-0.254917,-0.212393,-0.247005,-0.144333,0.018262,0.022861,-0.012345,0.031241:-0.11586,-0.018224,0.167828,0.10904,0.224649,0.366503,0.469334,0.558918,0.58243,0.668597,0.730446,0.718256:-0.193183,-0.265753,-0.204357,-0.158735,-0.219843,-0.187821,-0.203854,-0.23777,-0.268766,-0.289116,-0.247525,-0.196216:-0.11737,-0.117671,-0.126685,-0.095891,-0.026022,-0.0357,-0.10752,-0.127569,-0.142928,-0.155977,-0.098423,-0.061971:0.114093,0.116217,0.125326,0.057897,-0.00211,0.005053,-0.006058,-0.069294,-0.129323,-0.125338,-0.085915,-0.082997:-0.064746,-0.094541,-0.112483,-0.181981,-0.245968,-0.255944,-0.295365,-0.293597,-0.237355,-0.211309,-0.227168,-0.262518:-0.182575,-0.191753,-0.204764,-0.237595,-0.133095,-0.114078,-0.069364,-0.042836,-0.032044,-0.019332,0.044729,0.067831:-0.027891,-0.072738,-0.07631,-0.028285,-0.106091,-0.073391,-0.075423,-0.051897,-0.068736,-0.051949,-0.032297,-0.03582:0.15902,0.168462,0.190263,0.222192,0.240367,0.225264,0.217662,0.19834,0.188422,0.163265,0.103245,0.061648:9
0.961089,1.225195,1.267463,1.163998,1.113536,1.092649,1.23636,1.23023,1.165717,1.033524,1.022426,1.082058,0.975833,1.052299,1.071301:0.101827,-0.026599,0.161428,0.168675,0.099197,-0.001011,-0.173208,-0.238658,-0.305188,-0.286548,-0.299443,-0.330344,-0.309625,-0.468964,-0.472625:0.013051,0.046162,-0.033252,0.001833,0.103707,0.131775,0.144678,0.113857,0.118838,0.074216,0.037855,0.115921,0.079473,0.174532,0.271217:-0.473609,-0.548302,-0.566649,-0.583028,-0.616741,-0.521579,-0.559938,-0.506264,-0.421015,-0.35303,-0.257663,-0.243579,-0.16644,-0.134818,-0.115797:-0.216827,-0.0776,0.059846,0.156983,0.222359,0.277847,0.414659,0.518652,0.533723,0.542272,0.564408,0.66406,0.66403,0.620698,0.655554:-0.257211,-0.175405,-0.083908,-0.065925,-0.07068,-0.216768,-0.206198,-0.216936,-0.23016,-0.212627,-0.206989,-0.223206,-0.185402,-0.067894,-0.012724:-0.110707,-0.096639,-0.088683,-0.13696,-0.185391,-0.124705,-0.224956,-0.270263,-0.226297,-0.18716,-0.194343,-0.225068,-0.254543,-0.296602,-0.384484:0.255169,0.301511,0.234307,0.207718,0.213988,0.249684,0.189485,0.147742,0.160508,0.154872,0.150062,0.124102,0.020457,-0.017583,-0.004638:0.087958,-0.023916,-0.079378,-0.065229,-0.072744,-0.195663,-0.216159,-0.236361,-0.258722,-0.264131,-0.311066,-0.317983,-0.258802,-0.217325,-0.222127:-0.230163,-0.197435,-0.159623,-0.187906,-0.191529,-0.213987,-0.144496,-0.093994,-0.116052,-0.144337,-0.100423,-0.041113,0.01773,-0.041434,-0.024892:0.077789,0.056177,0.080191,0.059111,0.030937,0.036311,0.02913,0.070899,0.09282,0.111738,0.113094,0.08267,0.067606,0.093771,0.145019:0.058856,0.022296,-0.004718,0.02537,0.037333,0.103297,0.107003,0.137715,0.202102,0.189521,0.137655,0.091498,0.032996,0.018625,-0.081642:9
1.164143,1.310321,1.147539,1.038933,1.135281,1.233045,1.274549,1.219501,1.196387,1.228612,1.206496,1.065539,1.334598,1.099952:-0.326873,-0.435275,-0.34121,-0.203067,-0.304934,-0.419669,-0.547552,-0.609781,-0.69812,-0.711245,-0.723099,-0.682723,-0.935858,-0.711556:-0.021113,0.006209,-0.051647,-0.157715,-0.168822,-0.01685,0.097771,0.118316,0.186461,0.273158,0.362202,0.299327,0.39089,0.234073:-0.418294,-0.415275,-0.380298,-0.339114,-0.314809,-0.382656,-0.380666,-0.246194,-0.188156,-0.236553,-0.214285,0.011908,0.037756,0.247242:-0.166244,-0.060822,0.016822,0.07037,0.095689,0.202159,0.32146,0.361556,0.355729,0.401205,0.519438,0.506107,0.493798,0.47688:-0.234142,-0.214436,-0.199321,-0.202735,-0.158659,-0.14332,-0.157612,-0.163793,-0.076246,-0.01271,-0.057099,-0.095613,-0.098532,-0.08705:-0.173134,-0.177636,-0.172532,-0.128955,-0.090158,-0.108145,-0.147465,-0.140351,-0.198821,-0.307149,-0.37851,-0.282764,-0.212496,-0.188671:0.331097,0.340365,0.388983,0.405894,0.341135,0.241958,0.193172,0.154091,0.057882,0.005396,0.001979,-0.029556,-0.00761,-0.031445:-0.027745,-0.086488,-0.129918,-0.167802,-0.255003,-0.289457,-0.343858,-0.368996,-0.357887,-0.302054,-0.268855,-0.256498,-0.269908,-0.235406:-0.210537,-0.197625,-0.204378,-0.219598,-0.20256,-0.216877,-0.222464,-0.209085,-0.207599,-0.204894,-0.151684,-0.087453,-0.049935,-0.113858:0.054064,0.133797,0.118709,0.053173,0.062024,0.091035,0.07588,0.032872,0.031176,0.046694,0.024546,0.005665,0.001292,0.023205:0.097877,0.124993,0.147403,0.140011,0.140194,0.134676,0.147445,0.147269,0.078177,0.032034,0.032252,0.023892,0.001389,0.001729:9
0.791434,0.852344,0.983853,1.109106,1.171679,1.215352,1.272172,1.153125,1.047935,0.977569,0.741517,0.647456,0.790384,0.814933,0.800343,0.660101:-0.323044,-0.314197,-0.439619,-0.533956,-0.53167,-0.521584,-0.541816,-0.525078,-0.423504,-0.502663,-0.758381,-0.752827,-0.54777,-0.530521,-0.623721,-0.692298:0.317135,0.231913,0.314076,0.322932,0.29928,0.309532,0.283998,0.24014,0.140723,0.145194,0.09259,0.121231,0.285742,0.375191,0.465303,0.364056:-0.722195,-0.673932,-0.708856,-0.706598,-0.668969,-0.612936,-0.521823,-0.335813,-0.193828,-0.146087,-0.061609,-0.052759,0.057668,0.089686,0.122858,0.215139:-0.101159,-0.001039,0.167517,0.302335,0.357118,0.375309,0.371964,0.363505,0.382667,0.48593,0.565686,0.624165,0.574142,0.593556,0.559419,0.484538:-0.224655,-0.223203,-0.219839,-0.200495,-0.213176,-0.213554,-0.211061,-0.191454,-0.180675,-0.166776,-0.072291,-0.069493,-0.145469,-0.16199,-0.138814,-0.117722:-0.21008,-0.190676,-0.218755,-0.256614,-0.308175,-0.291923,-0.299368,-0.27509,-0.209427,-0.18318,-0.14073,-0.119944,-0.183041,-0.186762,-0.125637,-0.042798:0.425723,0.380435,0.370504,0.354437,0.273844,0.235091,0.209166,0.173538,0.169009,0.136433,0.067667,0.06489,0.032495,0.040603,0.062122,0.032596:-0.080314,-0.090758,-0.159077,-0.22021,-0.25897,-0.305217,-0.303,-0.299968,-0.27952,-0.241264,-0.255928,-0.288354,-0.341598,-0.321453,-0.326604,-0.353563:-0.253283,-0.253524,-0.255845,-0.245388,-0.229807,-0.26123,-0.261077,-0.25652,-0.240722,-0.180457,-0.029019,-9.1E-5,0.015678,0.063947,0.065796,0.102495:0.06578,0.036992,0.023419,0.043366,0.041901,0.062426,0.11886,0.188168,0.177973,0.134733,0.141935,0.155075,0.159174,0.126483,0.127678,0.052205:0.10058,0.121996,0.137297,0.12444,0.147265,0.225381,0.250868,0.242141,0.204865,0.147354,0.004205,-0.012853,-0.043539,-0.115249,-0.121955,-0.206009:9
1.204453,1.123658,1.026504,1.089764,1.13401,0.982032,1.085374,1.113885,1.130016,1.138215,1.313407,1.201934,1.121585,1.164453,1.064627:-0.42785,-0.447547,-0.484855,-0.488294,-0.548097,-0.533954,-0.637955,-0.715478,-0.709723,-0.658009,-0.70404,-0.628577,-0.560163,-0.457996,-0.31882:0.732213,0.637912,0.464914,0.523908,0.657417,0.564422,0.501127,0.457829,0.400829,0.33349,0.337594,0.201065,0.297053,0.45106,0.540104:-0.699554,-0.603662,-0.482395,-0.498717,-0.527535,-0.460858,-0.454375,-0.40047,-0.290484,-0.156791,-0.122755,0.004053,0.102022,0.140806,0.057949:-0.345411,-0.214306,-0.107094,-0.006327,0.064593,0.16212,0.261781,0.37138,0.445353,0.506161,0.524524,0.533136,0.541931,0.519355,0.618162:-0.241186,-0.238541,-0.166804,-0.135812,-0.151357,-0.195955,-0.197534,-0.139272,-0.143949,-0.17745,-0.152177,-0.208935,-0.20151,-0.128911,-0.137342:-0.113796,-0.03681,-0.058458,-0.136801,-0.160912,-0.139535,-0.137574,-0.129452,-0.104946,-0.108018,-0.175267,-0.09362,-0.075051,-0.167674,-0.213215:0.370365,0.357848,0.208885,0.174946,0.265588,0.26654,0.281761,0.274856,0.180121,0.095757,0.056883,-0.10882,-0.139656,-0.036181,0.043956:-0.13328,-0.281572,-0.348528,-0.310039,-0.350072,-0.377142,-0.38986,-0.39255,-0.430911,-0.423406,-0.413547,-0.345398,-0.342683,-0.285973,-0.270239:-0.25056,-0.264767,-0.237095,-0.276111,-0.363308,-0.356254,-0.342225,-0.331625,-0.286384,-0.216216,-0.20073,-0.131057,-0.11787,-0.199572,-0.196609:0.118079,0.091671,0.096539,0.076407,0.059437,0.018814,-0.011282,-0.002714,-0.033703,-0.101932,-0.086177,-0.142085,-0.105573,0.023479,0.11305:-0.046583,-0.057539,-0.047395,0.049307,0.09988,0.10304,0.086747,0.066841,0.102853,0.084383,0.042039,0.097454,0.115016,0.061721,0.001654:9
1.229754,1.355087,1.428604,1.466943,1.40711,1.343772,1.428232,1.527627,1.395016,1.495819,1.575589,1.584897,1.60203,1.498344,1.360617,1.298451,1.299741,1.296947,1.099922,1.066038,0.885017:-0.412049,-0.47026,-0.488052,-0.388542,-0.338769,-0.446471,-0.458205,-0.455972,-0.342188,-0.429773,-0.486196,-0.458194,-0.546517,-0.540556,-0.437963,-0.485007,-0.531694,-0.629803,-0.537992,-0.576541,-0.472931:0.44825,0.440139,0.361346,0.273697,0.202606,0.282053,0.250684,0.119704,-0.044094,-0.067848,-0.069117,-0.100978,-0.051678,-0.017765,0.020269,0.180175,0.184155,0.249332,0.283298,0.372551,0.401314:-0.626694,-0.661189,-0.672122,-0.560673,-0.503779,-0.608347,-0.587776,-0.421901,-0.299069,-0.239857,-0.212794,-0.139299,-0.10679,-0.084794,-0.163807,-0.222838,-0.02939,0.124094,0.133283,0.249627,0.260941:-0.251684,-0.215972,-0.195829,-0.195988,-0.135503,-0.043631,-0.022077,-7.0E-4,0.113431,0.188338,0.2314,0.276911,0.362546,0.443842,0.599256,0.650047,0.649604,0.679709,0.682201,0.628806,0.664451:-0.447848,-0.464733,-0.452418,-0.484069,-0.466349,-0.397778,-0.369183,-0.35671,-0.404643,-0.394748,-0.34722,-0.315353,-0.268699,-0.208399,-0.163168,-0.159817,-0.189098,-0.229139,-0.191419,-0.243325,-0.273946:-0.009771,-0.016995,-0.008408,0.030334,0.020561,-0.014545,0.010236,0.016115,0.085715,0.095879,0.081548,0.0892,0.044776,-0.047533,-0.150207,-0.161725,-0.084012,-0.096828,-0.130903,-0.105269,-0.111746:0.262005,0.319599,0.326697,0.318408,0.280775,0.297496,0.276852,0.230411,0.137598,0.093734,0.037898,-0.013984,-0.021838,-0.05125,-0.072648,-0.053531,-0.096844,-0.09176,-0.096546,-0.113473,-0.125766:-0.172498,-0.154826,-0.15749,-0.140681,-0.116071,-0.135515,-0.151166,-0.127868,-0.147004,-0.197024,-0.199062,-0.17,-0.209368,-0.240123,-0.265189,-0.308285,-0.314043,-0.300025,-0.267898,-0.322536,-0.343616:-0.068798,-0.052252,-0.078766,-0.061089,-0.091375,-0.149085,-0.157149,-0.169236,-0.151201,-0.113565,-0.121283,-0.143042,-0.127813,-0.155536,-0.113974,-0.080906,-0.041915,0.001061,-0.046409,-0.032509,-0.002187:0.056133,-0.023115,-0.053187,-0.049651,-0.074589,-0.109865,-0.136865,-0.145405,-0.18932,-0.188952,-0.197344,-0.197956,-0.173133,-0.141909,-0.127691,-0.098069,-0.11961,-0.147399,-0.114631,-0.073262,-0.064414:0.109308,0.090478,0.078472,0.064864,0.097396,0.14066,0.154902,0.152221,0.201395,0.214382,0.231165,0.243926,0.231311,0.207295,0.148649,0.150284,0.150494,0.099568,0.064113,0.015586,-0.02867:9
1.323488,1.2421,1.292041,1.191334,0.975493,0.925709,1.027261,0.9616,0.844343,0.750255:-0.463687,-0.426872,-0.536629,-0.654259,-0.734597,-0.629691,-0.246822,-0.118619,-0.113456,-0.224164:-0.198963,-0.285179,-0.351209,-0.238465,-0.066875,-0.046774,-0.058353,0.014742,0.005362,0.044064:-0.570255,-0.514609,-0.526282,-0.497971,-0.419634,-0.396018,-0.472441,-0.382606,-0.149223,-0.030691:0.282852,0.301228,0.364083,0.393883,0.316855,0.500848,0.6841,0.643761,0.478623,0.525258:-0.363754,-0.295255,-0.307396,-0.291741,-0.238644,-0.177401,-0.288179,-0.3935,-0.367931,-0.392938:-0.055253,-0.112479,-0.12656,-0.042874,0.010791,-0.013133,-0.121987,-0.134235,-0.054283,0.004954:0.123361,0.057928,0.144824,0.039742,0.027104,0.049376,0.030732,-0.020091,-0.097209,-0.005907:-0.11614,-0.189052,-0.272908,-0.267749,-0.296107,-0.241423,-0.231207,-0.327956,-0.345571,-0.34936:-0.070514,-0.167093,-0.127422,-0.095989,-0.124217,-0.170866,-0.070673,-0.047093,-0.072873,-0.009604:-0.16889,-0.038161,-0.042591,-0.136781,-0.051128,-0.083395,-0.098549,-0.054577,0.054498,0.071378:0.215351,0.174522,0.121266,0.183526,0.203075,0.213382,0.170043,0.170766,0.117959,0.091553:9
0.722903,0.998982,1.125377,1.172781,1.095314,0.972977,0.987952,1.059708,1.053396,1.104986,1.048745:-0.659432,-0.492918,-0.381492,-0.570412,-0.622873,-0.600708,-0.669703,-0.760888,-0.823644,-0.913071,-0.900136:-0.188257,-0.165593,-0.27948,-0.177741,-0.159833,-0.160085,-0.15249,-0.079263,0.027104,0.14873,0.167742:-0.186586,-0.171398,0.007447,0.014643,0.053917,0.181684,0.261985,0.321474,0.404951,0.450455,0.48106:-0.016672,-0.051028,-0.021447,0.076173,0.169597,0.238875,0.261016,0.255991,0.255164,0.259835,0.248417:-0.194239,-0.110248,-0.145927,-0.108764,-0.096972,-0.149298,-0.155623,-0.123018,-0.073808,-0.057758,-0.071994:0.020373,0.049994,0.077712,6.57E-4,-0.029779,-0.070138,-0.104958,-0.140133,-0.161677,-0.190637,-0.149948:0.07405,0.072976,-0.071121,4.18E-4,0.004754,-0.038834,-0.06971,-0.122638,-0.201415,-0.192763,-0.232864:-0.120119,-0.131762,-0.09406,-0.231074,-0.264733,-0.173475,-0.151949,-0.138922,-0.100583,-0.122933,-0.099498:-0.200436,-0.253631,-0.243004,-0.140983,-0.12979,-0.116466,-0.103765,-0.078621,-0.052955,-0.041869,-0.053494:0.04254,0.103869,0.129584,0.116098,0.096922,0.079119,0.068409,0.075649,0.044775,0.038463,2.42E-4:0.124569,0.258342,0.303749,0.264723,0.201861,0.134604,0.106699,0.082741,0.04242,0.00639,-0.001926:9
0.954686,1.17122,1.281883,1.356103,1.31809,1.345129,1.249693,1.183738,1.244976,1.295982,1.271452,1.16097,1.015825,0.889828,0.92649:-0.155453,-0.19671,-0.340361,-0.446519,-0.52921,-0.714028,-0.721155,-0.680265,-0.703298,-0.655292,-0.625999,-0.745243,-0.84807,-0.844817,-0.91401:0.043867,-0.029445,-0.086069,-0.095669,-0.044035,0.094671,0.145885,0.228104,0.208675,0.099567,0.079486,0.150359,0.260954,0.301312,0.387956:-0.392593,-0.451029,-0.41691,-0.373772,-0.367788,-0.429043,-0.464999,-0.514648,-0.439447,-0.364272,-0.36863,-0.31311,-0.229349,-0.056829,-0.006424:-0.363007,-0.302325,-0.202044,-0.191858,-0.156588,-0.01455,0.102409,0.127063,0.161255,0.240522,0.293557,0.287532,0.36883,0.443103,0.451747:-0.294507,-0.268389,-0.243181,-0.291088,-0.284167,-0.303877,-0.312763,-0.282947,-0.280047,-0.290336,-0.300614,-0.27612,-0.258929,-0.253186,-0.242593:0.068441,-0.00785,-0.067155,-0.025049,-0.021618,-0.020425,-0.015355,-0.039983,-0.08165,-0.122981,-0.177238,-0.175003,-0.180682,-0.183753,-0.209258:0.214231,0.296052,0.321054,0.289104,0.255331,0.216996,0.170627,0.14873,0.102343,0.016362,-0.024285,-0.023303,-0.036246,-0.082535,-0.124212:-0.108383,-0.218339,-0.218974,-0.216324,-0.256549,-0.339418,-0.423165,-0.435957,-0.432527,-0.445737,-0.466707,-0.477177,-0.477784,-0.471587,-0.441622:-0.221173,-0.187621,-0.166178,-0.142029,-0.123643,-0.109135,-0.076558,-0.097956,-0.072923,-0.03651,-0.052662,-0.077364,-0.04706,-0.003392,-0.012745:0.082447,0.07988,0.034127,0.008628,0.031537,0.08994,0.078961,0.079997,0.075818,0.052089,0.068553,0.083439,0.064839,0.038447,-0.008188:0.104602,0.044542,0.016625,0.022292,0.001498,0.057779,0.124126,0.150273,0.130478,0.117624,0.122785,0.093485,0.080141,0.032093,0.006147:9
1.169915,1.336779,1.308836,1.201284,1.133934,1.138537,1.128988,1.096886,1.111664,1.074262,1.074518,1.015054,0.956467:-0.255233,-0.368083,-0.405402,-0.389109,-0.39225,-0.392731,-0.449284,-0.512858,-0.526368,-0.599514,-0.689243,-0.723909,-0.747713:-0.099638,-0.110601,-0.114605,-0.138033,-0.119351,-0.149063,-0.143659,-0.100215,-0.153475,0.005591,0.139229,0.172063,0.213417:-0.438796,-0.416594,-0.397414,-0.340961,-0.284969,-0.231612,-0.200743,-0.148292,0.013783,0.044735,0.058871,0.159899,0.230856:-0.372436,-0.265562,-0.152079,-0.067795,0.040101,0.110203,0.214046,0.238095,0.330054,0.406183,0.443318,0.461225,0.440032:-0.184431,-0.108986,-0.095258,-0.063424,-0.055635,-0.051099,-0.057225,-0.11547,-0.158552,-0.10602,-0.050469,-0.050444,-0.049876:-0.002282,-0.116587,-0.169537,-0.2093,-0.254026,-0.276942,-0.309702,-0.24494,-0.201137,-0.309158,-0.360985,-0.361349,-0.348521:0.106098,0.083312,0.073047,0.074079,0.055293,0.045626,0.064621,0.112178,0.12805,0.042275,0.017376,0.036298,0.04994:0.226262,0.143885,0.102587,0.061558,0.003548,-0.036279,-0.118667,-0.193583,-0.260171,-0.257332,-0.245833,-0.220675,-0.222973:-0.347996,-0.345876,-0.367532,-0.375152,-0.345845,-0.321553,-0.227528,-0.182086,-0.063529,-0.072076,-0.079183,-0.101832,-0.108186:-0.018087,-0.03073,5.51E-4,0.057543,0.125097,0.145129,0.175622,0.204767,0.189326,0.204457,0.212596,0.172961,0.163129:0.211663,0.234389,0.263949,0.275242,0.289333,0.275772,0.205026,0.178196,0.110478,0.034221,-0.016919,-0.04847,-0.095299:9
0.930609,0.932398,0.996422,0.990474,0.969227,1.00477,0.911901,0.933609,0.935011,0.923778,1.015027:-0.148703,-0.215458,-0.245597,-0.264663,-0.269483,-0.387321,-0.370813,-0.488606,-0.590981,-0.650747,-0.796244:0.207096,0.047454,-0.030993,-0.081531,-0.148744,-0.066153,-0.051352,0.015762,0.18573,0.326193,0.445364:-0.381461,-0.368668,-0.395152,-0.31493,-0.192929,-0.146857,-0.107917,-0.072036,-0.058638,-0.056139,-0.083018:-0.213983,-0.098858,-0.029698,0.014171,0.026561,0.135856,0.248642,0.353393,0.395917,0.432797,0.528218:-0.17088,-0.108544,-0.124975,-0.106849,-0.074599,-0.06248,-0.06875,-0.026345,-0.039353,-0.084457,-0.080519:-0.01007,-0.065299,-0.108544,-0.149145,-0.179392,-0.223233,-0.227726,-0.226519,-0.236885,-0.262357,-0.333338:0.259103,0.232146,0.239279,0.217755,0.166177,0.110797,0.089869,0.11601,0.063832,0.043893,0.059634:-0.034622,-0.063349,-0.175109,-0.279421,-0.243854,-0.249013,-0.243734,-0.292593,-0.292538,-0.302548,-0.266281:-0.29039,-0.341865,-0.310203,-0.247004,-0.284663,-0.219665,-0.224454,-0.204325,-0.16289,-0.119212,-0.078032:0.123702,0.114966,0.150148,0.202515,0.193032,0.181266,0.225519,0.220114,0.216306,0.213323,0.196559:0.125297,0.154344,0.156634,0.174265,0.211929,0.183997,0.156951,0.075909,0.024422,-0.004757,-0.04707:9
1.24223,1.275841,1.262895,1.129381,1.099244,1.129976,1.086874,1.043529,1.187766,1.212234,1.269193,1.245227:-0.177697,-0.243482,-0.333123,-0.352932,-0.382404,-0.261193,-0.280801,-0.368438,-0.575306,-0.644546,-0.727357,-0.758309:-0.2253,-0.128623,-0.048815,-0.08896,0.023931,0.002521,-0.135888,-0.115207,0.04217,0.091264,0.150478,0.171653:-0.229293,-0.277007,-0.293256,-0.207035,-0.067949,-0.06937,-0.155835,-0.111919,-0.075497,-0.038732,0.025541,0.109792:-0.296585,-0.224854,-0.16074,-0.107998,0.011231,0.100461,0.237522,0.274712,0.346884,0.433685,0.473628,0.442709:-0.270807,-0.222121,-0.173376,-0.200962,-0.27955,-0.160713,-0.052804,0.005106,0.033628,0.035969,0.056939,0.029051:0.066081,0.001134,-0.019968,-0.042892,-0.197341,-0.227954,-0.241579,-0.252413,-0.326648,-0.356637,-0.409237,-0.432704:-0.135733,-0.069141,-0.020115,-0.076603,-0.095044,-0.031967,-0.005003,-0.04154,-0.065942,-0.110525,-0.102784,-0.117691:0.261653,0.209403,0.115981,0.108738,0.054342,-0.001878,-0.08899,-0.126246,-0.147198,-0.104358,-0.097387,-0.075886:-0.416958,-0.384482,-0.340111,-0.359305,-0.303988,-0.379091,-0.384682,-0.378593,-0.307883,-0.268881,-0.240803,-0.259832:-0.090795,-0.134196,-0.150712,-0.121834,-0.054598,0.012431,0.086629,0.089482,0.052767,0.012287,0.017385,-5.26E-4:0.185514,0.244012,0.24469,0.257696,0.263645,0.25534,0.189803,0.170963,0.14037,0.108731,0.042251,0.025137:9
1.505235,1.300354,1.232291,1.257719,1.15199,1.142423,1.159332,1.049236,1.097965,1.3004,1.346108,1.40791,1.35814,1.312326,1.348968:0.169987,-0.014071,-0.108531,-0.007197,0.011314,-0.003146,-0.136711,-0.117507,-0.191089,-0.482557,-0.573678,-0.628384,-0.600663,-0.657673,-0.694131:-0.492503,-0.335232,-0.255146,-0.352898,-0.381983,-0.337216,-0.306608,-0.277092,-0.202192,-0.05106,-0.035103,-0.066016,-0.092839,0.001782,0.02713:-0.109341,-0.102282,-0.14378,-0.217576,-0.256182,-0.380693,-0.418685,-0.359179,-0.27737,-0.279453,-0.263296,-0.196831,-0.082372,-0.009747,0.078345:-0.544213,-0.610788,-0.570131,-0.452617,-0.317174,-0.139042,-0.006828,0.00184,-0.012827,0.068015,0.181124,0.266346,0.294479,0.364787,0.387663:-0.445761,-0.313796,-0.314066,-0.315611,-0.284449,-0.310461,-0.29913,-0.275229,-0.210345,-0.153088,-0.164615,-0.170761,-0.176914,-0.183363,-0.124483:0.179052,0.19061,0.172414,0.077716,-0.00306,-0.081396,-0.128291,-0.110644,-0.133367,-0.196463,-0.178983,-0.183338,-0.190757,-0.176548,-0.161365:0.086784,0.036236,0.014277,0.081027,0.106841,0.214489,0.234696,0.214201,0.187105,0.226834,0.195591,0.15885,0.143419,0.081793,-0.022281:0.226178,0.135798,0.106134,0.125634,0.077267,-0.015616,-0.120527,-0.184484,-0.217719,-0.246849,-0.272799,-0.304362,-0.314721,-0.325228,-0.311359:-0.217769,-0.243522,-0.279655,-0.324319,-0.348943,-0.336125,-0.258992,-0.25556,-0.260017,-0.275461,-0.201337,-0.161791,-0.171435,-0.12852,-0.098183:0.094555,0.102208,0.115165,0.056678,0.079563,0.064246,0.04107,0.106145,0.157746,0.179279,0.122921,0.118199,0.109581,0.099174,0.068928:-0.03217,-0.020283,0.049313,0.054758,0.084515,0.102539,0.116001,0.147744,0.20651,0.20501,0.138691,0.124582,0.142197,0.111942,0.065885:9
1.112425,1.011173,0.972779,0.957612,1.037642,1.260043,1.465661,1.388906,1.241333,1.175623,1.195498,1.471431,1.382793,1.418509:-0.163326,-0.180188,-0.087256,-0.073539,-0.076396,-0.223337,-0.470201,-0.460253,-0.489743,-0.67923,-0.843473,-0.836767,-0.712973,-0.780273:-0.30761,-0.237999,-0.341108,-0.356955,-0.314899,-0.243125,-0.179102,-0.217898,-0.240264,-0.128117,-0.016394,0.228531,0.221811,0.285353:-0.353347,-0.344964,-0.370138,-0.403258,-0.386746,-0.309836,-0.246619,-0.17833,-0.12291,-0.013344,0.076506,-0.124236,-0.094434,-0.087637:-0.224929,-0.104752,-0.062454,0.022583,0.041908,0.058222,0.123787,0.15426,0.227498,0.231451,0.259181,0.401467,0.437898,0.481431:-0.301433,-0.273027,-0.245131,-0.236452,-0.238449,-0.231011,-0.261547,-0.220454,-0.157653,-0.010919,0.050084,-0.046007,-0.07806,-0.123554:-0.112237,-0.165804,-0.146241,-0.155179,-0.168935,-0.142976,-0.109114,-0.115107,-0.178033,-0.299932,-0.337363,-0.291352,-0.307245,-0.313209:0.203884,0.243675,0.263031,0.257959,0.25633,0.239782,0.207102,0.129018,-0.046884,-0.092922,-0.092898,-0.074225,-0.027404,0.004093:0.044621,-0.071081,-0.140726,-0.198474,-0.223933,-0.244615,-0.281225,-0.353911,-0.360318,-0.339495,-0.31039,-0.344006,-0.387733,-0.366268:-0.296026,-0.267674,-0.304488,-0.262224,-0.23551,-0.188887,-0.156097,-0.093954,0.005988,-0.035084,-0.101137,-0.107862,-0.122532,-0.083416:0.012566,0.074387,0.063687,0.078641,0.099293,0.077656,0.051782,0.084187,0.103857,0.115294,0.120808,0.08347,0.130369,0.109575:0.13597,0.161397,0.102767,0.082706,0.119964,0.19674,0.181479,0.155184,0.106172,0.038878,0.015395,0.028021,-1.37E-4,-0.027859:9
1.421622,1.601568,1.372168,1.114734,1.202514,1.273056,1.216506,1.214579,1.170031,1.118108,1.177449:-0.386758,-0.401418,-0.601565,-0.643728,-0.436324,-0.41261,-0.424432,-0.399925,-0.306025,-0.258605,-0.40408:-0.187715,-0.115707,-0.015212,-0.067501,-0.05121,0.022741,-0.034349,-0.127891,-0.145534,-0.103982,0.052026:-0.504102,-0.549387,-0.629353,-0.643356,-0.429247,-0.329668,-0.294238,-0.239583,-0.195854,-0.231256,-0.284812:-0.026528,-0.033465,-0.021942,0.060287,0.110985,0.124095,0.16627,0.221423,0.276371,0.344866,0.42984:-0.56274,-0.543227,-0.263379,-0.142488,-0.342492,-0.412164,-0.397758,-0.374714,-0.346794,-0.223807,-0.203484:0.087821,0.13675,0.025577,0.043098,0.11981,0.143246,0.091827,0.046216,0.042325,-0.014415,-0.072393:0.168902,0.172487,0.053792,0.019596,0.041591,0.043805,0.023178,0.051754,0.031668,-0.046215,-0.080955:-0.137287,-0.190715,-0.112695,-0.094912,-0.179789,-0.206256,-0.191598,-0.197824,-0.181205,-0.219385,-0.244424:0.087146,-0.017122,-0.05936,-0.01205,-0.041304,-0.094194,-0.111245,-0.099159,-0.077962,0.013357,-0.001849:-0.142142,-0.111288,-0.128995,-0.154492,-0.110844,-0.04231,-0.011547,-0.018177,-0.024079,-0.010018,-0.016634:0.101818,0.227841,0.195739,0.143707,0.298334,0.414377,0.425088,0.359986,0.30589,0.19286,0.224688:9
