/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.CharToCharFunction;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.tuple.Twin;
import org.eclipse.collections.impl.bag.mutable.HashBag;
import org.eclipse.collections.impl.block.factory.primitive.CharToCharFunctions;
import org.eclipse.collections.impl.block.function.primitive.CharFunction;
import org.eclipse.collections.impl.block.function.primitive.CodePointFunction;
import org.eclipse.collections.impl.block.predicate.CodePointPredicate;
import org.eclipse.collections.impl.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.impl.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CodePointProcedure;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.string.immutable.CharAdapter;
import org.eclipse.collections.impl.string.immutable.CodePointAdapter;
import org.eclipse.collections.impl.string.immutable.CodePointList;
import org.eclipse.collections.impl.tuple.Tuples;

public final class StringIterate {
    private StringIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static CharAdapter asCharAdapter(String string) {
        return CharAdapter.adapt(string);
    }

    public static CodePointAdapter asCodePointAdapter(String string) {
        return CodePointAdapter.adapt(string);
    }

    public static CodePointList toCodePointList(String string) {
        return CodePointList.from(string);
    }

    @Deprecated
    public static MutableList<String> csvTokensToSortedList(String string) {
        return StringIterate.tokensToSortedList(string, ",");
    }

    @Deprecated
    public static MutableList<String> csvTrimmedTokensToSortedList(String string) {
        return StringIterate.trimmedTokensToSortedList(string, ",");
    }

    public static MutableList<String> tokensToSortedList(String string, String separator) {
        return StringIterate.tokensToList(string, separator).sortThis();
    }

    public static MutableList<String> trimmedTokensToSortedList(String string, String separator) {
        return StringIterate.trimmedTokensToList(string, separator).sortThis();
    }

    @Deprecated
    public static MutableList<String> csvTokensToList(String string) {
        return StringIterate.tokensToList(string, ",");
    }

    @Deprecated
    public static MutableList<String> csvTrimmedTokensToList(String string) {
        return StringIterate.trimmedTokensToList(string, ",");
    }

    public static MutableList<String> tokensToList(String string, String separator) {
        MutableList<String> list = Lists.mutable.empty();
        StringTokenizer stringTokenizer = new StringTokenizer(string, separator);
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            list.add(token);
        }
        return list;
    }

    public static MutableList<String> trimmedTokensToList(String string, String separator) {
        return StringIterate.trimStringList(StringIterate.tokensToList(string, separator));
    }

    private static <L extends List<String>> L trimStringList(L strings) {
        ListIterator<String> listIt = strings.listIterator();
        while (listIt.hasNext()) {
            String string = listIt.next().trim();
            listIt.set(string);
        }
        return strings;
    }

    @Deprecated
    public static MutableSet<String> csvTokensToSet(String string) {
        return StringIterate.tokensToSet(string, ",");
    }

    public static MutableSet<String> tokensToSet(String string, String separator) {
        MutableSet<String> set = Sets.mutable.empty();
        StringTokenizer stringTokenizer = new StringTokenizer(string, separator);
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            set.add(token);
        }
        return set;
    }

    public static MutableMap<String, String> tokensToMap(String string) {
        return StringIterate.tokensToMap(string, "|", ":");
    }

    public static MutableMap<String, String> tokensToMap(String string, String pairSeparator, String keyValueSeparator) {
        MutableMap<String, String> map = Maps.mutable.empty();
        StringTokenizer tokenizer = new StringTokenizer(string, pairSeparator);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String key = token.substring(0, token.indexOf(keyValueSeparator));
            String value = token.substring(token.indexOf(keyValueSeparator) + 1);
            map.put(key, value);
        }
        return map;
    }

    public static <K, V> MutableMap<K, V> tokensToMap(String string, String separator, String keyValueSeparator, Function<String, K> keyFunction, Function<String, V> valueFunction) {
        MutableMap<K, V> map = Maps.mutable.empty();
        StringTokenizer tokenizer = new StringTokenizer(string, separator);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String key = token.substring(0, token.indexOf(keyValueSeparator));
            String value = token.substring(token.indexOf(keyValueSeparator) + 1);
            map.put(keyFunction.valueOf(key), valueFunction.valueOf(value));
        }
        return map;
    }

    @Deprecated
    public static MutableList<String> csvTokensToReverseSortedList(String string) {
        return StringIterate.tokensToReverseSortedList(string, ",");
    }

    public static MutableList<String> tokensToReverseSortedList(String string, String separator) {
        return StringIterate.tokensToList(string, separator).sortThis(Collections.reverseOrder());
    }

    public static void forEachToken(String string, String separator, Procedure<String> procedure) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, separator);
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            procedure.value(token);
        }
    }

    public static <T, R> R injectIntoTokens(String string, String separator, R injectedValue, Function2<? super R, String, ? extends R> function) {
        R result = injectedValue;
        StringTokenizer stringTokenizer = new StringTokenizer(string, separator);
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            result = function.value(result, token);
        }
        return result;
    }

    public static void forEachTrimmedToken(String string, String separator, Procedure<String> procedure) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, separator);
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken().trim();
            procedure.value(token);
        }
    }

    @Deprecated
    public static void forEach(String string, CharProcedure procedure) {
        StringIterate.forEachChar(string, procedure::value);
    }

    @Deprecated
    public static void forEach(String string, org.eclipse.collections.api.block.procedure.primitive.CharProcedure procedure) {
        StringIterate.forEachChar(string, procedure);
    }

    public static void forEachChar(String string, org.eclipse.collections.api.block.procedure.primitive.CharProcedure procedure) {
        int size = string.length();
        for (int i = 0; i < size; ++i) {
            procedure.value(string.charAt(i));
        }
    }

    @Deprecated
    public static void forEach(String string, CodePointProcedure procedure) {
        StringIterate.forEachCodePoint(string, procedure);
    }

    public static void forEachCodePoint(String string, CodePointProcedure procedure) {
        int codePoint;
        int size = string.length();
        for (int i = 0; i < size; i += Character.charCount(codePoint)) {
            codePoint = string.codePointAt(i);
            procedure.value(codePoint);
        }
    }

    @Deprecated
    public static void reverseForEach(String string, org.eclipse.collections.api.block.procedure.primitive.CharProcedure procedure) {
        StringIterate.reverseForEachChar(string, procedure);
    }

    public static void reverseForEachChar(String string, org.eclipse.collections.api.block.procedure.primitive.CharProcedure procedure) {
        for (int i = string.length() - 1; i >= 0; --i) {
            procedure.value(string.charAt(i));
        }
    }

    @Deprecated
    public static void reverseForEach(String string, CodePointProcedure procedure) {
        StringIterate.reverseForEachCodePoint(string, procedure);
    }

    public static void reverseForEachCodePoint(String string, CodePointProcedure procedure) {
        int i = StringIterate.lastIndex(string);
        while (i >= 0) {
            int codePoint = string.codePointAt(i);
            procedure.value(codePoint);
            if (i == 0) {
                --i;
                continue;
            }
            i -= StringIterate.numberOfChars(string, i);
        }
    }

    private static int lastIndex(String string) {
        if (StringIterate.isEmpty(string)) {
            return -1;
        }
        int size = string.length();
        if (size > 1) {
            return size - StringIterate.numberOfChars(string, size);
        }
        return 0;
    }

    public static int numberOfChars(String string, int i) {
        return StringIterate.isSurrogate(string, i) ? 2 : 1;
    }

    public static boolean isSurrogate(String string, int i) {
        return Character.isLowSurrogate(string.charAt(i - 1)) && Character.isHighSurrogate(string.charAt(i - 2));
    }

    @Deprecated
    public static int count(String string, CharPredicate predicate) {
        return StringIterate.countChar(string, predicate::accept);
    }

    @Deprecated
    public static int count(String string, org.eclipse.collections.api.block.predicate.primitive.CharPredicate predicate) {
        return StringIterate.countChar(string, predicate);
    }

    public static int countChar(String string, org.eclipse.collections.api.block.predicate.primitive.CharPredicate predicate) {
        int count = 0;
        int size = string.length();
        for (int i = 0; i < size; ++i) {
            if (!predicate.accept(string.charAt(i))) continue;
            ++count;
        }
        return count;
    }

    @Deprecated
    public static int count(String string, CodePointPredicate predicate) {
        return StringIterate.countCodePoint(string, predicate);
    }

    public static int countCodePoint(String string, CodePointPredicate predicate) {
        int codePoint;
        int count = 0;
        int size = string.length();
        for (int i = 0; i < size; i += Character.charCount(codePoint)) {
            codePoint = string.codePointAt(i);
            if (!predicate.accept(codePoint)) continue;
            ++count;
        }
        return count;
    }

    @Deprecated
    public static String collect(String string, CharFunction function) {
        return StringIterate.collectChar(string, function::valueOf);
    }

    @Deprecated
    public static String collect(String string, CharToCharFunction function) {
        return StringIterate.collectChar(string, function);
    }

    public static String collectChar(String string, CharToCharFunction function) {
        int size = string.length();
        StringBuilder builder = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            builder.append(function.valueOf(string.charAt(i)));
        }
        return builder.toString();
    }

    @Deprecated
    public static String collect(String string, CodePointFunction function) {
        return StringIterate.collectCodePoint(string, function);
    }

    public static String collectCodePoint(String string, CodePointFunction function) {
        int codePoint;
        int size = string.length();
        StringBuilder builder = new StringBuilder(size);
        for (int i = 0; i < size; i += Character.charCount(codePoint)) {
            codePoint = string.codePointAt(i);
            builder.appendCodePoint(function.valueOf(codePoint));
        }
        return builder.toString();
    }

    public static String englishToUpperCase(String string) {
        if (StringIterate.anySatisfyChar(string, Character::isLowerCase)) {
            return StringIterate.collectChar(string, CharToCharFunctions.toUpperCase());
        }
        return string;
    }

    public static String englishToLowerCase(String string) {
        if (StringIterate.anySatisfyChar(string, Character::isUpperCase)) {
            return StringIterate.collectChar(string, CharToCharFunctions.toLowerCase());
        }
        return string;
    }

    @Deprecated
    public static Character detect(String string, org.eclipse.collections.api.block.predicate.primitive.CharPredicate predicate) {
        return StringIterate.detectChar(string, predicate);
    }

    public static Character detectChar(String string, org.eclipse.collections.api.block.predicate.primitive.CharPredicate predicate) {
        int size = string.length();
        for (int i = 0; i < size; ++i) {
            char character = string.charAt(i);
            if (!predicate.accept(character)) continue;
            return Character.valueOf(character);
        }
        return null;
    }

    @Deprecated
    public static Character detectIfNone(String string, org.eclipse.collections.api.block.predicate.primitive.CharPredicate predicate, char resultIfNone) {
        return StringIterate.detectCharIfNone(string, predicate, resultIfNone);
    }

    public static Character detectCharIfNone(String string, org.eclipse.collections.api.block.predicate.primitive.CharPredicate predicate, char resultIfNone) {
        Character result = StringIterate.detectChar(string, predicate);
        return result == null ? Character.valueOf(resultIfNone) : result;
    }

    @Deprecated
    public static Character detectIfNone(String string, org.eclipse.collections.api.block.predicate.primitive.CharPredicate predicate, String resultIfNone) {
        return StringIterate.detectCharIfNone(string, predicate, resultIfNone);
    }

    public static Character detectCharIfNone(String string, org.eclipse.collections.api.block.predicate.primitive.CharPredicate predicate, String resultIfNone) {
        Character result = StringIterate.detectChar(string, predicate);
        return result == null ? Character.valueOf(resultIfNone.charAt(0)) : result;
    }

    @Deprecated
    public static int occurrencesOf(String string, char value) {
        return StringIterate.occurrencesOfChar(string, value);
    }

    public static int occurrencesOfChar(String string, char value) {
        return StringIterate.countChar(string, character -> value == character);
    }

    @Deprecated
    public static int occurrencesOf(String string, int value) {
        return StringIterate.occurrencesOfCodePoint(string, value);
    }

    public static int occurrencesOfCodePoint(String string, int value) {
        return StringIterate.countCodePoint(string, codePoint -> value == codePoint);
    }

    public static int occurrencesOf(String string, String singleCharacter) {
        if (singleCharacter.length() != 1) {
            throw new IllegalArgumentException("Argument should be a single character: " + singleCharacter);
        }
        return StringIterate.occurrencesOfChar(string, singleCharacter.charAt(0));
    }

    @Deprecated
    public static boolean anySatisfy(String string, org.eclipse.collections.api.block.predicate.primitive.CharPredicate predicate) {
        return StringIterate.anySatisfyChar(string, predicate);
    }

    public static boolean anySatisfyChar(String string, org.eclipse.collections.api.block.predicate.primitive.CharPredicate predicate) {
        int size = string.length();
        for (int i = 0; i < size; ++i) {
            if (!predicate.accept(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean anySatisfy(String string, CodePointPredicate predicate) {
        return StringIterate.anySatisfyCodePoint(string, predicate);
    }

    public static boolean anySatisfyCodePoint(String string, CodePointPredicate predicate) {
        int codePoint;
        int size = string.length();
        for (int i = 0; i < size; i += Character.charCount(codePoint)) {
            codePoint = string.codePointAt(i);
            if (!predicate.accept(codePoint)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean allSatisfy(String string, org.eclipse.collections.api.block.predicate.primitive.CharPredicate predicate) {
        return StringIterate.allSatisfyChar(string, predicate);
    }

    public static boolean allSatisfyChar(String string, org.eclipse.collections.api.block.predicate.primitive.CharPredicate predicate) {
        int size = string.length();
        for (int i = 0; i < size; ++i) {
            if (predicate.accept(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static boolean allSatisfy(String string, CodePointPredicate predicate) {
        return StringIterate.allSatisfyCodePoint(string, predicate);
    }

    public static boolean allSatisfyCodePoint(String string, CodePointPredicate predicate) {
        int codePoint;
        int size = string.length();
        for (int i = 0; i < size; i += Character.charCount(codePoint)) {
            codePoint = string.codePointAt(i);
            if (predicate.accept(codePoint)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static boolean noneSatisfy(String string, org.eclipse.collections.api.block.predicate.primitive.CharPredicate predicate) {
        return StringIterate.noneSatisfyChar(string, predicate);
    }

    public static boolean noneSatisfyChar(String string, org.eclipse.collections.api.block.predicate.primitive.CharPredicate predicate) {
        int size = string.length();
        for (int i = 0; i < size; ++i) {
            if (!predicate.accept(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static boolean noneSatisfy(String string, CodePointPredicate predicate) {
        return StringIterate.noneSatisfyCodePoint(string, predicate);
    }

    public static boolean noneSatisfyCodePoint(String string, CodePointPredicate predicate) {
        int codePoint;
        int size = string.length();
        for (int i = 0; i < size; i += Character.charCount(codePoint)) {
            codePoint = string.codePointAt(i);
            if (!predicate.accept(codePoint)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static String select(String string, org.eclipse.collections.api.block.predicate.primitive.CharPredicate predicate) {
        return StringIterate.selectChar(string, predicate);
    }

    public static String selectChar(String string, org.eclipse.collections.api.block.predicate.primitive.CharPredicate predicate) {
        int size = string.length();
        StringBuilder buffer = new StringBuilder(string.length());
        for (int i = 0; i < size; ++i) {
            char character = string.charAt(i);
            if (!predicate.accept(character)) continue;
            buffer.append(character);
        }
        return buffer.toString();
    }

    @Deprecated
    public static String select(String string, CodePointPredicate predicate) {
        return StringIterate.selectCodePoint(string, predicate);
    }

    public static String selectCodePoint(String string, CodePointPredicate predicate) {
        int codePoint;
        int size = string.length();
        StringBuilder buffer = new StringBuilder(string.length());
        for (int i = 0; i < size; i += Character.charCount(codePoint)) {
            codePoint = string.codePointAt(i);
            if (!predicate.accept(codePoint)) continue;
            buffer.appendCodePoint(codePoint);
        }
        return buffer.toString();
    }

    @Deprecated
    public static String reject(String string, org.eclipse.collections.api.block.predicate.primitive.CharPredicate predicate) {
        return StringIterate.rejectChar(string, predicate);
    }

    public static String rejectChar(String string, org.eclipse.collections.api.block.predicate.primitive.CharPredicate predicate) {
        int size = string.length();
        StringBuilder buffer = new StringBuilder(string.length());
        for (int i = 0; i < size; ++i) {
            char character = string.charAt(i);
            if (predicate.accept(character)) continue;
            buffer.append(character);
        }
        return buffer.toString();
    }

    @Deprecated
    public static String reject(String string, CodePointPredicate predicate) {
        return StringIterate.rejectCodePoint(string, predicate);
    }

    public static String rejectCodePoint(String string, CodePointPredicate predicate) {
        int codePoint;
        int size = string.length();
        StringBuilder buffer = new StringBuilder(string.length());
        for (int i = 0; i < size; i += Character.charCount(codePoint)) {
            codePoint = string.codePointAt(i);
            if (predicate.accept(codePoint)) continue;
            buffer.appendCodePoint(codePoint);
        }
        return buffer.toString();
    }

    public static String getLastToken(String value, String separator) {
        if (StringIterate.notEmpty(value)) {
            int lastIndex = value.lastIndexOf(separator);
            if (lastIndex > -1) {
                return value.substring(lastIndex + separator.length());
            }
            return value;
        }
        return value == null ? null : "";
    }

    public static String getFirstToken(String value, String separator) {
        if (StringIterate.notEmpty(value)) {
            int firstIndex = value.indexOf(separator);
            if (firstIndex > -1) {
                return value.substring(0, firstIndex);
            }
            return value;
        }
        return value == null ? null : "";
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isEmptyOrWhitespace(String string) {
        return StringIterate.isEmpty(string) || StringIterate.isWhitespace(string);
    }

    private static boolean isWhitespace(String string) {
        return StringIterate.allSatisfyCodePoint(string, CodePointPredicate.IS_WHITESPACE);
    }

    public static boolean isNumber(String string) {
        return StringIterate.charactersSatisfy(string, CodePointPredicate.IS_DIGIT);
    }

    public static boolean isAlphaNumeric(String string) {
        return StringIterate.charactersSatisfy(string, CodePointPredicate.IS_LETTER_OR_DIGIT);
    }

    private static boolean charactersSatisfy(String string, CodePointPredicate predicate) {
        return !"".equals(string) && StringIterate.allSatisfyCodePoint(string, predicate);
    }

    public static boolean notEmpty(String string) {
        return !StringIterate.isEmpty(string);
    }

    public static boolean notEmptyOrWhitespace(String string) {
        return !StringIterate.isEmptyOrWhitespace(string);
    }

    public static String repeat(String template, int repeatTimes) {
        StringBuilder buf = new StringBuilder(template.length() * repeatTimes);
        for (int i = 0; i < repeatTimes; ++i) {
            buf.append(template);
        }
        return buf.toString();
    }

    public static String repeat(char c, int repeatTimes) {
        StringBuilder buf = new StringBuilder(repeatTimes);
        for (int i = 0; i < repeatTimes; ++i) {
            buf.append(c);
        }
        return buf.toString();
    }

    public static String padOrTrim(String message, int targetLength) {
        int messageLength = message.length();
        if (messageLength >= targetLength) {
            return message.substring(0, targetLength);
        }
        return message + StringIterate.repeat(' ', targetLength - messageLength);
    }

    public static MutableList<Character> toList(String string) {
        MutableList<Character> characters = Lists.mutable.withInitialCapacity(string.length());
        StringIterate.forEachChar(string, new AddCharacterToCollection(characters));
        return characters;
    }

    public static MutableList<Character> toLowercaseList(String string) {
        FastList<Character> characters = FastList.newList();
        StringIterate.forEachChar(string, new AddLowercaseCharacterToCollection(characters));
        return characters;
    }

    public static MutableList<Character> toUppercaseList(String string) {
        FastList<Character> characters = FastList.newList();
        StringIterate.forEachChar(string, new AddUppercaseCharacterToCollection(characters));
        return characters;
    }

    public static MutableBag<Character> toBag(String string) {
        HashBag<Character> characters = HashBag.newBag();
        StringIterate.forEachChar(string, new AddCharacterToCollection(characters));
        return characters;
    }

    public static MutableBag<Character> toLowercaseBag(String string) {
        HashBag<Character> characters = HashBag.newBag();
        StringIterate.forEachChar(string, new AddLowercaseCharacterToCollection(characters));
        return characters;
    }

    public static MutableBag<Character> toUppercaseBag(String string) {
        HashBag<Character> characters = HashBag.newBag();
        StringIterate.forEachChar(string, new AddUppercaseCharacterToCollection(characters));
        return characters;
    }

    public static MutableSet<Character> toSet(String string) {
        MutableSet<Character> characters = Sets.mutable.empty();
        StringIterate.forEachChar(string, new AddCharacterToCollection(characters));
        return characters;
    }

    public static MutableList<String> chunk(String string, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        int length = string.length();
        if (length == 0) {
            return FastList.newList();
        }
        MutableList<String> result = Lists.mutable.withInitialCapacity((length + size - 1) / size);
        for (int startOffset = 0; startOffset < length; startOffset += size) {
            result.add(string.substring(startOffset, Math.min(startOffset + size, length)));
        }
        return result;
    }

    @Deprecated
    public static MutableSet<Character> asUppercaseSet(String string) {
        return StringIterate.toUppercaseSet(string);
    }

    public static MutableSet<Character> toUppercaseSet(String string) {
        MutableSet<Character> characters = Sets.mutable.empty();
        StringIterate.forEachChar(string, new AddUppercaseCharacterToCollection(characters));
        return characters;
    }

    @Deprecated
    public static MutableSet<Character> asLowercaseSet(String string) {
        return StringIterate.toLowercaseSet(string);
    }

    public static MutableSet<Character> toLowercaseSet(String string) {
        MutableSet<Character> characters = Sets.mutable.empty();
        StringIterate.forEachChar(string, new AddLowercaseCharacterToCollection(characters));
        return characters;
    }

    public static Twin<String> splitAtIndex(String aString, int index) {
        return Tuples.twin(aString.substring(0, index), aString.substring(index));
    }

    private static final class AddUppercaseCharacterToCollection
    implements org.eclipse.collections.api.block.procedure.primitive.CharProcedure {
        private final MutableCollection<Character> characters;

        private AddUppercaseCharacterToCollection(MutableCollection<Character> characters) {
            this.characters = characters;
        }

        @Override
        public void value(char character) {
            this.characters.add(Character.valueOf(Character.toUpperCase(character)));
        }
    }

    private static final class AddLowercaseCharacterToCollection
    implements org.eclipse.collections.api.block.procedure.primitive.CharProcedure {
        private final MutableCollection<Character> characters;

        private AddLowercaseCharacterToCollection(MutableCollection<Character> characters) {
            this.characters = characters;
        }

        @Override
        public void value(char character) {
            this.characters.add(Character.valueOf(Character.toLowerCase(character)));
        }
    }

    private static final class AddCharacterToCollection
    implements org.eclipse.collections.api.block.procedure.primitive.CharProcedure {
        private final MutableCollection<Character> characters;

        private AddCharacterToCollection(MutableCollection<Character> characters) {
            this.characters = characters;
        }

        @Override
        public void value(char character) {
            this.characters.add(Character.valueOf(character));
        }
    }
}

