/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.OrderingScheme;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.SortNode;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class StreamSortNode
extends SortNode {
    private final int streamCompareKeyEndIndex;

    public StreamSortNode(PlanNodeId id, PlanNode child, OrderingScheme scheme, boolean partial, boolean orderByAllIdsAndTime, int streamCompareKeyEndIndex) {
        super(id, child, scheme, partial, orderByAllIdsAndTime);
        this.streamCompareKeyEndIndex = streamCompareKeyEndIndex;
    }

    public int getStreamCompareKeyEndIndex() {
        return this.streamCompareKeyEndIndex;
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new StreamSortNode(this.id, (PlanNode)Iterables.getOnlyElement(newChildren), this.orderingScheme, this.partial, this.orderByAllIdsAndTime, this.streamCompareKeyEndIndex);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitStreamSort(this, context);
    }

    @Override
    public PlanNode clone() {
        return new StreamSortNode(this.id, null, this.orderingScheme, this.partial, this.orderByAllIdsAndTime, this.streamCompareKeyEndIndex);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TABLE_STREAM_SORT_NODE.serialize(byteBuffer);
        this.orderingScheme.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.streamCompareKeyEndIndex, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TABLE_STREAM_SORT_NODE.serialize(stream);
        this.orderingScheme.serialize(stream);
        ReadWriteIOUtils.write((int)this.streamCompareKeyEndIndex, (OutputStream)stream);
    }

    public static SortNode deserialize(ByteBuffer byteBuffer) {
        OrderingScheme orderingScheme = OrderingScheme.deserialize(byteBuffer);
        int streamCompareKeyEndIndex = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new StreamSortNode(planNodeId, null, orderingScheme, false, false, streamCompareKeyEndIndex);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StreamSortNode streamSortNode = (StreamSortNode)o;
        return Objects.equal((Object)this.streamCompareKeyEndIndex, (Object)streamSortNode.streamCompareKeyEndIndex);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.streamCompareKeyEndIndex});
    }

    @Override
    public String toString() {
        return "StreamSortNode-" + this.getPlanNodeId();
    }
}

