/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.ratis.util.BiWeakValueCache;

public final class WeakValueCache<K, V> {
    private final String keyName;
    private final String name;
    private final Function<K, V> constructor;
    private final AtomicInteger constructionCount = new AtomicInteger(0);
    private final ConcurrentMap<K, V> map = BiWeakValueCache.newMap();

    public WeakValueCache(String keyName, Function<K, V> constructor) {
        this.keyName = keyName;
        this.name = keyName + "-cache";
        this.constructor = constructor;
    }

    private V construct(K key) {
        V constructed = this.constructor.apply(key);
        Objects.requireNonNull(constructed, "constructed == null");
        this.constructionCount.incrementAndGet();
        return constructed;
    }

    public V getOrCreate(K key) {
        Objects.requireNonNull(key, () -> this.keyName + " (key) == null");
        return (V)this.map.computeIfAbsent(key, this::construct);
    }

    List<V> getValues() {
        return new ArrayList(this.map.values());
    }

    public String toString() {
        return this.name;
    }
}

