/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SubscriptionStatement;

public class CreateTopic
extends SubscriptionStatement {
    private final String topicName;
    private final boolean ifNotExistsCondition;
    private final Map<String, String> topicAttributes;

    public CreateTopic(String topicName, boolean ifNotExistsCondition, Map<String, String> topicAttributes) {
        this.topicName = Objects.requireNonNull(topicName, "topic name can not be null");
        this.ifNotExistsCondition = ifNotExistsCondition;
        this.topicAttributes = Objects.requireNonNull(topicAttributes, "topic attributes can not be null");
    }

    public String getTopicName() {
        return this.topicName;
    }

    public boolean hasIfNotExistsCondition() {
        return this.ifNotExistsCondition;
    }

    public Map<String, String> getTopicAttributes() {
        return this.topicAttributes;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateTopic(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.topicAttributes, this.ifNotExistsCondition, this.topicAttributes);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateTopic that = (CreateTopic)obj;
        return Objects.equals(this.topicName, that.topicName) && Objects.equals(this.ifNotExistsCondition, that.ifNotExistsCondition) && Objects.equals(this.topicAttributes, that.topicAttributes);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pipeName", (Object)this.topicName).add("ifNotExistsCondition", this.ifNotExistsCondition).add("topicAttributes", this.topicAttributes).toString();
    }
}

