/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.analyzer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.NodeRef;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ResolvedFunction;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FunctionCall;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RangeQuantifier;

public class PatternRecognitionAnalysis {
    private final Set<String> allLabels;
    private final Set<String> undefinedLabels;
    private final Map<NodeRef<RangeQuantifier>, Analysis.Range> ranges;

    public PatternRecognitionAnalysis(Set<String> allLabels, Set<String> undefinedLabels, Map<NodeRef<RangeQuantifier>, Analysis.Range> ranges) {
        this.allLabels = Objects.requireNonNull(allLabels, "allLabels is null");
        this.undefinedLabels = ImmutableSet.copyOf(undefinedLabels);
        this.ranges = ImmutableMap.copyOf(ranges);
    }

    public Set<String> getAllLabels() {
        return this.allLabels;
    }

    public Set<String> getUndefinedLabels() {
        return this.undefinedLabels;
    }

    public Map<NodeRef<RangeQuantifier>, Analysis.Range> getRanges() {
        return this.ranges;
    }

    public String toString() {
        return "PatternRecognitionAnalysis{allLabels=" + this.allLabels + ", undefinedLabels=" + this.undefinedLabels + ", ranges=" + this.ranges + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatternRecognitionAnalysis that = (PatternRecognitionAnalysis)o;
        return Objects.equals(this.allLabels, that.allLabels) && Objects.equals(this.undefinedLabels, that.undefinedLabels) && Objects.equals(this.ranges, that.ranges);
    }

    public int hashCode() {
        return Objects.hash(this.allLabels, this.undefinedLabels, this.ranges);
    }

    public static class Navigation {
        public static final Navigation DEFAULT = new Navigation(NavigationAnchor.LAST, NavigationMode.RUNNING, 0, 0);
        private final NavigationAnchor anchor;
        private final NavigationMode mode;
        private final int logicalOffset;
        private final int physicalOffset;

        public Navigation(NavigationAnchor anchor, NavigationMode mode, int logicalOffset, int physicalOffset) {
            this.anchor = Objects.requireNonNull(anchor, "anchor is null");
            this.mode = Objects.requireNonNull(mode, "mode is null");
            this.logicalOffset = logicalOffset;
            this.physicalOffset = physicalOffset;
        }

        public NavigationAnchor getAnchor() {
            return this.anchor;
        }

        public NavigationMode getMode() {
            return this.mode;
        }

        public int getLogicalOffset() {
            return this.logicalOffset;
        }

        public int getPhysicalOffset() {
            return this.physicalOffset;
        }
    }

    public static enum NavigationAnchor {
        FIRST,
        LAST;

    }

    public static class MatchNumberDescriptor
    implements Descriptor {
    }

    public static class ClassifierDescriptor
    implements Descriptor {
        private final Optional<String> label;
        private final Navigation navigation;

        public ClassifierDescriptor(Optional<String> label, Navigation navigation) {
            this.label = Objects.requireNonNull(label, "label is null");
            this.navigation = Objects.requireNonNull(navigation, "navigation is null");
        }

        public Optional<String> getLabel() {
            return this.label;
        }

        public Navigation getNavigation() {
            return this.navigation;
        }

        public String toString() {
            return "ClassifierDescriptor{label=" + this.label + ", navigation=" + this.navigation + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassifierDescriptor that = (ClassifierDescriptor)o;
            return Objects.equals(this.label, that.label) && Objects.equals(this.navigation, that.navigation);
        }

        public int hashCode() {
            return Objects.hash(this.label, this.navigation);
        }
    }

    public static class ScalarInputDescriptor
    implements Descriptor {
        private final Optional<String> label;
        private final Navigation navigation;

        public ScalarInputDescriptor(Optional<String> label, Navigation navigation) {
            this.label = Objects.requireNonNull(label, "label is null");
            this.navigation = Objects.requireNonNull(navigation, "navigation is null");
        }

        public Optional<String> getLabel() {
            return this.label;
        }

        public Navigation getNavigation() {
            return this.navigation;
        }

        public String toString() {
            return "ScalarInputDescriptor{label=" + this.label + ", navigation=" + this.navigation + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ScalarInputDescriptor that = (ScalarInputDescriptor)o;
            return Objects.equals(this.label, that.label) && Objects.equals(this.navigation, that.navigation);
        }

        public int hashCode() {
            return Objects.hash(this.label, this.navigation);
        }
    }

    public static class AggregationDescriptor
    implements Descriptor {
        private final ResolvedFunction function;
        private final List<Expression> arguments;
        private final NavigationMode mode;
        private final Set<String> labels;
        private final List<FunctionCall> matchNumberCalls;
        private final List<FunctionCall> classifierCalls;

        public AggregationDescriptor(ResolvedFunction function, List<Expression> arguments, NavigationMode mode, Set<String> labels, List<FunctionCall> matchNumberCalls, List<FunctionCall> classifierCalls) {
            this.function = Objects.requireNonNull(function, "function is null");
            this.arguments = Objects.requireNonNull(arguments, "arguments is null");
            this.mode = Objects.requireNonNull(mode, "mode is null");
            this.labels = Objects.requireNonNull(labels, "labels is null");
            this.matchNumberCalls = Objects.requireNonNull(matchNumberCalls, "matchNumberCalls is null");
            this.classifierCalls = Objects.requireNonNull(classifierCalls, "classifierCalls is null");
        }

        public ResolvedFunction getFunction() {
            return this.function;
        }

        public List<Expression> getArguments() {
            return this.arguments;
        }

        public NavigationMode getMode() {
            return this.mode;
        }

        public Set<String> getLabels() {
            return this.labels;
        }

        public List<FunctionCall> getMatchNumberCalls() {
            return this.matchNumberCalls;
        }

        public List<FunctionCall> getClassifierCalls() {
            return this.classifierCalls;
        }

        public String toString() {
            return "AggregationDescriptor{function=" + this.function + ", arguments=" + this.arguments + ", mode=" + (Object)((Object)this.mode) + ", labels=" + this.labels + ", matchNumberCalls=" + this.matchNumberCalls + ", classifierCalls=" + this.classifierCalls + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AggregationDescriptor that = (AggregationDescriptor)o;
            return Objects.equals(this.function, that.function) && Objects.equals(this.arguments, that.arguments) && this.mode == that.mode && Objects.equals(this.labels, that.labels) && Objects.equals(this.matchNumberCalls, that.matchNumberCalls) && Objects.equals(this.classifierCalls, that.classifierCalls);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.function, this.arguments, this.mode, this.labels, this.matchNumberCalls, this.classifierCalls});
        }
    }

    public static interface Descriptor {
    }

    public static enum NavigationMode {
        RUNNING,
        FINAL;

    }

    public static class PatternFunctionAnalysis {
        private final Expression expression;
        private final Descriptor descriptor;

        public PatternFunctionAnalysis(Expression expression, Descriptor descriptor) {
            this.expression = Objects.requireNonNull(expression, "expression is null");
            this.descriptor = Objects.requireNonNull(descriptor, "descriptor is null");
        }

        public Expression getExpression() {
            return this.expression;
        }

        public Descriptor getDescriptor() {
            return this.descriptor;
        }

        public String toString() {
            return "PatternFunctionAnalysis{expression=" + this.expression + ", descriptor=" + this.descriptor + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PatternFunctionAnalysis that = (PatternFunctionAnalysis)o;
            return Objects.equals(this.expression, that.expression) && Objects.equals(this.descriptor, that.descriptor);
        }

        public int hashCode() {
            return Objects.hash(this.expression, this.descriptor);
        }
    }
}

