/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.frame;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.Partition;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.frame.Frame;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.frame.FrameInfo;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.utils.Range;

public class RowsFrame
implements Frame {
    private final Partition partition;
    private final FrameInfo frameInfo;
    private final int partitionSize;

    public RowsFrame(Partition partition, FrameInfo frameInfo) {
        Preconditions.checkArgument((frameInfo.getFrameType() == FrameInfo.FrameType.ROWS ? 1 : 0) != 0);
        this.partition = partition;
        this.frameInfo = frameInfo;
        this.partitionSize = partition.getPositionCount();
    }

    @Override
    public Range getRange(int currentPosition, int currentGroup, int peerGroupStart, int peerGroupEnd) {
        int frameEnd;
        int offset;
        int frameStart;
        switch (this.frameInfo.getStartType()) {
            case UNBOUNDED_PRECEDING: {
                frameStart = 0;
                break;
            }
            case PRECEDING: {
                offset = (int)this.getOffset(this.frameInfo.getStartOffsetChannel(), currentPosition);
                frameStart = currentPosition - offset;
                break;
            }
            case CURRENT_ROW: {
                frameStart = currentPosition;
                break;
            }
            case FOLLOWING: {
                offset = (int)this.getOffset(this.frameInfo.getStartOffsetChannel(), currentPosition);
                frameStart = currentPosition + offset;
                break;
            }
            default: {
                throw new SemanticException("UNBOUND PRECEDING is not allowed in frame start!");
            }
        }
        switch (this.frameInfo.getEndType()) {
            case PRECEDING: {
                offset = (int)this.getOffset(this.frameInfo.getEndOffsetChannel(), currentPosition);
                frameEnd = currentPosition - offset;
                break;
            }
            case CURRENT_ROW: {
                frameEnd = currentPosition;
                break;
            }
            case FOLLOWING: {
                offset = (int)this.getOffset(this.frameInfo.getEndOffsetChannel(), currentPosition);
                frameEnd = currentPosition + offset;
                break;
            }
            case UNBOUNDED_FOLLOWING: {
                frameEnd = this.partitionSize - 1;
                break;
            }
            default: {
                throw new SemanticException("UNBOUND PRECEDING is not allowed in frame end!");
            }
        }
        if (frameEnd < frameStart || frameEnd < 0 || frameStart >= this.partitionSize) {
            return new Range(-1, -1);
        }
        frameStart = Math.max(frameStart, 0);
        frameEnd = Math.min(frameEnd, this.partitionSize - 1);
        return new Range(frameStart, frameEnd);
    }

    public long getOffset(int channel, int index) {
        Preconditions.checkArgument((!this.partition.isNull(channel, index) ? 1 : 0) != 0);
        long offset = this.partition.getLong(channel, index);
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0);
        return offset;
    }
}

