/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class SubscriptionAcknowledgement
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=821");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=823");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=822");
    private final UInteger subscriptionId;
    private final UInteger sequenceNumber;

    public SubscriptionAcknowledgement(UInteger subscriptionId, UInteger sequenceNumber) {
        this.subscriptionId = subscriptionId;
        this.sequenceNumber = sequenceNumber;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public UInteger getSubscriptionId() {
        return this.subscriptionId;
    }

    public UInteger getSequenceNumber() {
        return this.sequenceNumber;
    }

    protected SubscriptionAcknowledgement(SubscriptionAcknowledgementBuilder<?, ?> b) {
        super(b);
        this.subscriptionId = ((SubscriptionAcknowledgementBuilder)b).subscriptionId;
        this.sequenceNumber = ((SubscriptionAcknowledgementBuilder)b).sequenceNumber;
    }

    public static SubscriptionAcknowledgementBuilder<?, ?> builder() {
        return new SubscriptionAcknowledgementBuilderImpl();
    }

    public SubscriptionAcknowledgementBuilder<?, ?> toBuilder() {
        return new SubscriptionAcknowledgementBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubscriptionAcknowledgement)) {
            return false;
        }
        SubscriptionAcknowledgement other = (SubscriptionAcknowledgement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UInteger this$subscriptionId = this.getSubscriptionId();
        UInteger other$subscriptionId = other.getSubscriptionId();
        if (this$subscriptionId == null ? other$subscriptionId != null : !((Object)this$subscriptionId).equals(other$subscriptionId)) {
            return false;
        }
        UInteger this$sequenceNumber = this.getSequenceNumber();
        UInteger other$sequenceNumber = other.getSequenceNumber();
        return !(this$sequenceNumber == null ? other$sequenceNumber != null : !((Object)this$sequenceNumber).equals(other$sequenceNumber));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubscriptionAcknowledgement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UInteger $subscriptionId = this.getSubscriptionId();
        result = result * 59 + ($subscriptionId == null ? 43 : ((Object)$subscriptionId).hashCode());
        UInteger $sequenceNumber = this.getSequenceNumber();
        result = result * 59 + ($sequenceNumber == null ? 43 : ((Object)$sequenceNumber).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SubscriptionAcknowledgement(subscriptionId=" + this.getSubscriptionId() + ", sequenceNumber=" + this.getSequenceNumber() + ")";
    }

    private static final class SubscriptionAcknowledgementBuilderImpl
    extends SubscriptionAcknowledgementBuilder<SubscriptionAcknowledgement, SubscriptionAcknowledgementBuilderImpl> {
        private SubscriptionAcknowledgementBuilderImpl() {
        }

        @Override
        protected SubscriptionAcknowledgementBuilderImpl self() {
            return this;
        }

        @Override
        public SubscriptionAcknowledgement build() {
            return new SubscriptionAcknowledgement(this);
        }
    }

    public static abstract class SubscriptionAcknowledgementBuilder<C extends SubscriptionAcknowledgement, B extends SubscriptionAcknowledgementBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private UInteger subscriptionId;
        private UInteger sequenceNumber;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SubscriptionAcknowledgementBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(SubscriptionAcknowledgement instance, SubscriptionAcknowledgementBuilder<?, ?> b) {
            b.subscriptionId(instance.subscriptionId);
            b.sequenceNumber(instance.sequenceNumber);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B subscriptionId(UInteger subscriptionId) {
            this.subscriptionId = subscriptionId;
            return (B)this.self();
        }

        public B sequenceNumber(UInteger sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "SubscriptionAcknowledgement.SubscriptionAcknowledgementBuilder(super=" + super.toString() + ", subscriptionId=" + this.subscriptionId + ", sequenceNumber=" + this.sequenceNumber + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<SubscriptionAcknowledgement> {
        @Override
        public Class<SubscriptionAcknowledgement> getType() {
            return SubscriptionAcknowledgement.class;
        }

        @Override
        public SubscriptionAcknowledgement decode(SerializationContext context, UaDecoder decoder) {
            UInteger subscriptionId = decoder.readUInt32("SubscriptionId");
            UInteger sequenceNumber = decoder.readUInt32("SequenceNumber");
            return new SubscriptionAcknowledgement(subscriptionId, sequenceNumber);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, SubscriptionAcknowledgement value) {
            encoder.writeUInt32("SubscriptionId", value.getSubscriptionId());
            encoder.writeUInt32("SequenceNumber", value.getSequenceNumber());
        }
    }
}

