/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.DataChangeTrigger;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringFilter;

public class DataChangeFilter
extends MonitoringFilter
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=722");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=724");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=723");
    private final DataChangeTrigger trigger;
    private final UInteger deadbandType;
    private final Double deadbandValue;

    public DataChangeFilter(DataChangeTrigger trigger, UInteger deadbandType, Double deadbandValue) {
        this.trigger = trigger;
        this.deadbandType = deadbandType;
        this.deadbandValue = deadbandValue;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public DataChangeTrigger getTrigger() {
        return this.trigger;
    }

    public UInteger getDeadbandType() {
        return this.deadbandType;
    }

    public Double getDeadbandValue() {
        return this.deadbandValue;
    }

    protected DataChangeFilter(DataChangeFilterBuilder<?, ?> b) {
        super((MonitoringFilter.MonitoringFilterBuilder<?, ?>)b);
        this.trigger = ((DataChangeFilterBuilder)b).trigger;
        this.deadbandType = ((DataChangeFilterBuilder)b).deadbandType;
        this.deadbandValue = ((DataChangeFilterBuilder)b).deadbandValue;
    }

    public static DataChangeFilterBuilder<?, ?> builder() {
        return new DataChangeFilterBuilderImpl();
    }

    public DataChangeFilterBuilder<?, ?> toBuilder() {
        return new DataChangeFilterBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataChangeFilter)) {
            return false;
        }
        DataChangeFilter other = (DataChangeFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Double this$deadbandValue = this.getDeadbandValue();
        Double other$deadbandValue = other.getDeadbandValue();
        if (this$deadbandValue == null ? other$deadbandValue != null : !((Object)this$deadbandValue).equals(other$deadbandValue)) {
            return false;
        }
        DataChangeTrigger this$trigger = this.getTrigger();
        DataChangeTrigger other$trigger = other.getTrigger();
        if (this$trigger == null ? other$trigger != null : !this$trigger.equals(other$trigger)) {
            return false;
        }
        UInteger this$deadbandType = this.getDeadbandType();
        UInteger other$deadbandType = other.getDeadbandType();
        return !(this$deadbandType == null ? other$deadbandType != null : !((Object)this$deadbandType).equals(other$deadbandType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DataChangeFilter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Double $deadbandValue = this.getDeadbandValue();
        result = result * 59 + ($deadbandValue == null ? 43 : ((Object)$deadbandValue).hashCode());
        DataChangeTrigger $trigger = this.getTrigger();
        result = result * 59 + ($trigger == null ? 43 : $trigger.hashCode());
        UInteger $deadbandType = this.getDeadbandType();
        result = result * 59 + ($deadbandType == null ? 43 : ((Object)$deadbandType).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "DataChangeFilter(trigger=" + this.getTrigger() + ", deadbandType=" + this.getDeadbandType() + ", deadbandValue=" + this.getDeadbandValue() + ")";
    }

    private static final class DataChangeFilterBuilderImpl
    extends DataChangeFilterBuilder<DataChangeFilter, DataChangeFilterBuilderImpl> {
        private DataChangeFilterBuilderImpl() {
        }

        @Override
        protected DataChangeFilterBuilderImpl self() {
            return this;
        }

        @Override
        public DataChangeFilter build() {
            return new DataChangeFilter(this);
        }
    }

    public static abstract class DataChangeFilterBuilder<C extends DataChangeFilter, B extends DataChangeFilterBuilder<C, B>>
    extends MonitoringFilter.MonitoringFilterBuilder<C, B> {
        private DataChangeTrigger trigger;
        private UInteger deadbandType;
        private Double deadbandValue;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DataChangeFilterBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(DataChangeFilter instance, DataChangeFilterBuilder<?, ?> b) {
            b.trigger(instance.trigger);
            b.deadbandType(instance.deadbandType);
            b.deadbandValue(instance.deadbandValue);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B trigger(DataChangeTrigger trigger) {
            this.trigger = trigger;
            return (B)this.self();
        }

        public B deadbandType(UInteger deadbandType) {
            this.deadbandType = deadbandType;
            return (B)this.self();
        }

        public B deadbandValue(Double deadbandValue) {
            this.deadbandValue = deadbandValue;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DataChangeFilter.DataChangeFilterBuilder(super=" + super.toString() + ", trigger=" + this.trigger + ", deadbandType=" + this.deadbandType + ", deadbandValue=" + this.deadbandValue + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<DataChangeFilter> {
        @Override
        public Class<DataChangeFilter> getType() {
            return DataChangeFilter.class;
        }

        @Override
        public DataChangeFilter decode(SerializationContext context, UaDecoder decoder) {
            DataChangeTrigger trigger = decoder.readEnum("Trigger", DataChangeTrigger.class);
            UInteger deadbandType = decoder.readUInt32("DeadbandType");
            Double deadbandValue = decoder.readDouble("DeadbandValue");
            return new DataChangeFilter(trigger, deadbandType, deadbandValue);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, DataChangeFilter value) {
            encoder.writeEnum("Trigger", value.getTrigger());
            encoder.writeUInt32("DeadbandType", value.getDeadbandType());
            encoder.writeDouble("DeadbandValue", value.getDeadbandValue());
        }
    }
}

