/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.partition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.partition.Partition;
import org.apache.iotdb.commons.partition.RegionReplicaSetInfo;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.tsfile.read.filter.basic.Filter;

public class DataPartition
extends Partition {
    private static long timePartitionInterval = CommonDescriptor.getInstance().getConfig().getTimePartitionInterval();
    public static final TRegionReplicaSet NOT_ASSIGNED = new TRegionReplicaSet();
    private Map<String, Map<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TRegionReplicaSet>>>> dataPartitionMap;

    public DataPartition(String seriesSlotExecutorName, int seriesPartitionSlotNum) {
        super(seriesSlotExecutorName, seriesPartitionSlotNum);
    }

    @Override
    public boolean isEmpty() {
        return this.dataPartitionMap == null || this.dataPartitionMap.isEmpty();
    }

    public DataPartition(Map<String, Map<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TRegionReplicaSet>>>> dataPartitionMap, String seriesSlotExecutorName, int seriesPartitionSlotNum) {
        this(seriesSlotExecutorName, seriesPartitionSlotNum);
        this.dataPartitionMap = dataPartitionMap;
    }

    public Map<String, Map<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TRegionReplicaSet>>>> getDataPartitionMap() {
        return this.dataPartitionMap;
    }

    public void setDataPartitionMap(Map<String, Map<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TRegionReplicaSet>>>> dataPartitionMap) {
        this.dataPartitionMap = dataPartitionMap;
    }

    public List<List<TTimePartitionSlot>> getTimePartitionRange(String deviceName, Filter timeFilter) {
        String storageGroup = this.getStorageGroupByDevice(deviceName);
        TSeriesPartitionSlot seriesPartitionSlot = this.calculateDeviceGroupId(deviceName);
        if (!this.dataPartitionMap.containsKey(storageGroup) || !this.dataPartitionMap.get(storageGroup).containsKey(seriesPartitionSlot)) {
            return Collections.emptyList();
        }
        ArrayList<List<TTimePartitionSlot>> res = new ArrayList<List<TTimePartitionSlot>>();
        Map<TTimePartitionSlot, List<TRegionReplicaSet>> map = this.dataPartitionMap.get(storageGroup).get(seriesPartitionSlot);
        List timePartitionSlotList = map.keySet().stream().filter(key -> TimePartitionUtils.satisfyPartitionStartTime(timeFilter, key.startTime)).sorted(Comparator.comparingLong(TTimePartitionSlot::getStartTime)).collect(Collectors.toList());
        if (timePartitionSlotList.isEmpty()) {
            return res;
        }
        int previousRegionId = map.get(timePartitionSlotList.get((int)0)).get((int)0).regionId.id;
        int previousIndex = 0;
        res.add(new ArrayList());
        ((List)res.get(previousIndex)).add((TTimePartitionSlot)timePartitionSlotList.get(0));
        int size = timePartitionSlotList.size();
        for (int i = 1; i < size; ++i) {
            int currentRegionId = map.get(timePartitionSlotList.get((int)i)).get((int)0).regionId.id;
            if (currentRegionId == previousRegionId) {
                ((List)res.get(previousIndex)).add((TTimePartitionSlot)timePartitionSlotList.get(i));
                continue;
            }
            previousRegionId = currentRegionId;
            res.add(new ArrayList());
            ((List)res.get(++previousIndex)).add((TTimePartitionSlot)timePartitionSlotList.get(i));
        }
        return res;
    }

    public List<TRegionReplicaSet> getDataRegionReplicaSetWithTimeFilter(String deviceName, Filter timeFilter) {
        String storageGroup = this.getStorageGroupByDevice(deviceName);
        TSeriesPartitionSlot seriesPartitionSlot = this.calculateDeviceGroupId(deviceName);
        if (!this.dataPartitionMap.containsKey(storageGroup) || !this.dataPartitionMap.get(storageGroup).containsKey(seriesPartitionSlot)) {
            return Collections.singletonList(NOT_ASSIGNED);
        }
        return this.dataPartitionMap.get(storageGroup).get(seriesPartitionSlot).entrySet().stream().filter(entry -> TimePartitionUtils.satisfyPartitionStartTime(timeFilter, ((TTimePartitionSlot)entry.getKey()).startTime)).flatMap(entry -> ((List)entry.getValue()).stream()).distinct().collect(Collectors.toList());
    }

    public List<TRegionReplicaSet> getDataRegionReplicaSet(String deviceName, TTimePartitionSlot tTimePartitionSlot) {
        String storageGroup = this.getStorageGroupByDevice(deviceName);
        Map<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TRegionReplicaSet>>> dbMap = this.dataPartitionMap.get(storageGroup);
        if (dbMap == null) {
            return Collections.singletonList(NOT_ASSIGNED);
        }
        TSeriesPartitionSlot seriesPartitionSlot = this.calculateDeviceGroupId(deviceName);
        Map<TTimePartitionSlot, List<TRegionReplicaSet>> seriesSlotMap = dbMap.get(seriesPartitionSlot);
        if (seriesSlotMap == null) {
            return Collections.singletonList(NOT_ASSIGNED);
        }
        List<TRegionReplicaSet> regionReplicaSets = seriesSlotMap.get(tTimePartitionSlot);
        if (regionReplicaSets == null) {
            return Collections.singletonList(NOT_ASSIGNED);
        }
        return regionReplicaSets;
    }

    public List<TRegionReplicaSet> getDataRegionReplicaSetForWriting(String deviceName, List<TTimePartitionSlot> timePartitionSlotList) {
        String storageGroup = this.getStorageGroupByDevice(deviceName);
        TSeriesPartitionSlot seriesPartitionSlot = this.calculateDeviceGroupId(deviceName);
        ArrayList<TRegionReplicaSet> dataRegionReplicaSets = new ArrayList<TRegionReplicaSet>();
        Map<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TRegionReplicaSet>>> dataBasePartitionMap = this.dataPartitionMap.get(storageGroup);
        Map<TTimePartitionSlot, List<TRegionReplicaSet>> slotReplicaSetMap = dataBasePartitionMap.get(seriesPartitionSlot);
        for (TTimePartitionSlot timePartitionSlot : timePartitionSlotList) {
            List<TRegionReplicaSet> targetRegionList = slotReplicaSetMap.get(timePartitionSlot);
            if (targetRegionList == null || targetRegionList.isEmpty()) {
                throw new RuntimeException(String.format("targetRegionList is empty. device: %s, timeSlot: %s", deviceName, timePartitionSlot));
            }
            dataRegionReplicaSets.add(targetRegionList.get(targetRegionList.size() - 1));
        }
        return dataRegionReplicaSets;
    }

    public TRegionReplicaSet getDataRegionReplicaSetForWriting(String deviceName, TTimePartitionSlot timePartitionSlot) {
        String storageGroup = this.getStorageGroupByDevice(deviceName);
        TSeriesPartitionSlot seriesPartitionSlot = this.calculateDeviceGroupId(deviceName);
        Map<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TRegionReplicaSet>>> databasePartitionMap = this.dataPartitionMap.get(storageGroup);
        if (databasePartitionMap == null) {
            throw new RuntimeException("Database not exists and failed to create automatically because enable_auto_create_schema is FALSE.");
        }
        List<TRegionReplicaSet> regions = databasePartitionMap.get(seriesPartitionSlot).get(timePartitionSlot);
        return regions.get(0);
    }

    private String getStorageGroupByDevice(String deviceName) {
        for (String storageGroup : this.dataPartitionMap.keySet()) {
            if (!PathUtils.isStartWith(deviceName, storageGroup)) continue;
            return storageGroup;
        }
        return null;
    }

    @Override
    public List<RegionReplicaSetInfo> getDistributionInfo() {
        HashMap distributionMap = new HashMap();
        this.dataPartitionMap.forEach((storageGroup, partition) -> {
            List ret = partition.entrySet().stream().flatMap(s -> ((Map)s.getValue()).entrySet().stream().flatMap(e -> ((List)e.getValue()).stream())).collect(Collectors.toList());
            for (TRegionReplicaSet regionReplicaSet : ret) {
                distributionMap.computeIfAbsent(regionReplicaSet, RegionReplicaSetInfo::new).setStorageGroup((String)storageGroup);
            }
        });
        return new ArrayList<RegionReplicaSetInfo>(distributionMap.values());
    }
}

